--------------     -----------------------------------------------------------------------
**Title**          Organizing community coding events in open source biological research

**Author**         Brad Chapman

**Affiliations**   Harvard Chan School Bioinformatics Core (<http://bioinformatics.sph.harvard.edu/>)

**Contact**        bchapman@hsph.harvard.edu

**Keywords**       bioinformatics, open source, community, diversity, training
--------------     -------------------------------------------------------------------------

The Open Bioinformatics Foundation (<https://www.open-bio.org>) is a
community of scientists creating open source code to solve biological problems.
A yearly conference, started in 2000, provides the opportunity for in person
discussion and presentation on technical work about code development and
biological analyses.

In 2010, we recognized a need for a more practical hands on working session in
addition to the conference and developed a two day coding session called the
OpenBio Codefest (<https://www.open-bio.org/wiki/Codefest>). This event
continued the past 7 years in a wide diversity of locations, with the most
recent taking place at an Orlando makerspace (<https://www.open-bio.org/wiki/Codefest_2016>).

At the CSCW 2017 Hackathon workshop, I'll discuss the organization and evolution
of Codefest. It initially started as a space for community members who were
already collaborating remotely to sit together and work. Over time, it grew to
better incorporate new members into the community by serving as a fun and
open environment for sharing work and meeting like-minded researchers.

The positive things we've learned in organizing Codefest are:

- The value of collaboration over competition. Codefest has no prizes or
  competitive structure, and instead focuses on producing useful practical code that
  we can share at the associated conference and more widely through blog posts
  and scientific papers.

- The power of self-organizing groups. We do not pre-define the agenda for
  Codefest and let the attendees suggest areas of focus and then provide
  introductions so working groups can form. This allows newer community members
  to work alongside more experienced developers in areas they'd like to learn,
  and to allow the community to shift focus with new technologies and approaches.

- The advantage of in person discussion for developing interoperability
  standards. One successful outcome of Codefest have been the development of tool
  communication standards which allow different communities to share development
  resources. Like other projects at Codefest, standards creation happened
  organically due to the need for larger projects to be able to better to re-use
  analyses.

We also currently face challenges that we're hoping to learn potential solutions to:

- How to attract a more diverse set of community members. Like many programming
  and bioinformatics conferences, we struggle to attract a diverse crowd of
  attendees. As a result, Codefest can feel intimidating or unwelcoming to those
  outside the community. We've received universal praise that we're welcoming
  once overcoming that initial hurdle, but would like ways to project this
  welcoming attitude so under-represented researchers feel comfortable investing
  their time and expertise at Codefest.

- Incorporating teaching and training into the content of Codefest. As we've
  increasingly tried to attract new community members, we've developed the need
  to help integrate them into the community. In many cases, new members will be
  experts in some areas but not in the projects or languages under active
  development at Codefest. We need to develop methods to quickly get them
  comfortable and productive so they can contribute within a reasonably short
  time frame.

- Scaling events to incorporate new members and approaches. As we actively
  recruit new attendees we're running into the issue of figuring out how to
  support them at larger scale. Our approach of having a few mentors who make
  connections and provide orientation on projects will need improvement if we're
  successful in recruiting new, diverse attendees.

Attending the Hackathon Workshop is a chance to show areas where we've been
successful, and to learn how to be better organizers. We hope to continue to
expand and improve Codefest and related events for the open bioinformatics
community.
