I'm at the [2018 Hacking and Making Workshop](http://hackathon-workshop-2018.com/) in Montreal.
This is a one day workshop of researchers on collaboration events, and I'm here
to share experiences organizing
[Codefests](https://www.open-bio.org/wiki/Codefest_2017) and to learn ideas to
apply to the [upcoming collaboration fest](https://galaxyproject.org/events/gccbosc2018/collaboration/)
at the [GCC/BOSC bioinformatics community conference](https://gccbosc2018.sched.com/).

## Collective Innovation
/Liz Gerber/

Technology enables new forms of organizing, but needs tending otherwise may
cripple broad engagement. Part of [Delta Lab](http://delta.northwestern.edu/),
a diverse multi-discipline research lab at Northeastern.

Key: access to knowledge drives innovation. How do we access this knowledge?
Especially need diverse knowledge. 3 approaches to do this:

- Wealthy firms only: buy an innovation firm
- Adopt new processes: agile, design thinking, lean manufacturing
- Use of internet and social media to access knowledge

Last one: collective innovation. Actively engage number and variety of people,
even across weakly connected networks.

Case study in collective innovation: kids struggle to stay positive while
managing with chronic diseases; diabetes. Jerry the Bear is a toy to help learn
about medical procedures. Empowers kids to learn about their diseases. Developed
by two students at Design America; learned that kids with diseases took care of
stuffed animals in a different way. First worked with groups on internet in
diabetes web portals, then built bear by learning what to do via YouTube. Got
feedback on prototype through crowdsourcing. Went into production using
crowdfunding, then marketing through online.

Contrast this with firm led innovation. Firm provides critical knowledge and
capital at each stage. Already have infrastructure in place to do all these
steps. Interesting contrast: children typically not involved in the processes.

Collective innovation allows for the wider engagement with people that would
normally not get consulted. Opportunities and challenges with this:

- Roles -- greater flexibility and distribution in roles and rapidly changing
  responsibilities. However, problem is that people often lack critical skills
  for changing roles. Autonomy and skills need motivate people, but can
  overwhelm and lead to burnout.

- Communication -- lower cost of communication, but more relationships and
  resources to manage. You get inexpensive, continuous feedback but it's
  overwhelming and noisy.

- Trust -- Online need to build trust, lack of risk assurance and responsibility
  for quality.

- Reputation -- lower expectations and greater openness; first timers welcome.
  However, hard to recover from missteps.

How can we overcome these challenges in the context of Hackathons? Outcomes:
artifacts, technical expertise, design process experience, social networks,
emotional effect, identity. Diverse experiences: hackathons with non-profits,
for-profits, remote hackathons, academics, ages from 8 to 100.

Time bounded nature provides the biggest challenges in roles, communication and
trust. Need to assign team roles (multiple per person) to manage expectations.
Try to structure activities and guide processes through design patterns or
repurposeable templates. Communication: early introductions to jumpstart
knowledge exchange and understand project scope. Be ready before the hackathon
and good to go. Need guidance on how to communicate across domains. Leaders set
challenging goals and provide way to get user feedback on work. Trust: build
with project stakeholders to understand perspectives.

Call to action: address operations, but also need to handle organizational
behavior issues. Design for before, during and after.

Call to action for educators: prepare students for collective innovation: how to
do hackathon.

Call to action for scholars: understand through multiple lenses and as
socio-technical changes.

## Notes from Working groups

- [Organizing hackathons](https://docs.google.com/document/d/1amH2OA-vpfz7l8IDFN8c4pgrMp8SyDtzTmm6KaQrFoI/edit?usp=sharing)
- [Diversity and inclusion working group](https://docs.google.com/document/d/1iAhIlVmKayt3JgZ7ORTtwUgubklkW9mZ9IHy23bOdBY/edit?usp=sharing)
- [Measuring Hackathon outcomes](https://docs.google.com/document/d/1ERZk5uXAdw1rAbm7VR05ZRfmTjbpZc-thiu-1c0dADY/edit?usp=sharing)
- [Discussion from plenary session](https://docs.google.com/document/d/1EPado4-4D9eQrosW8nsRy1knKCZwWrYt6ODcGgeip8o/edit)

## Ideas for improving CoFest

- More pre-event engagement -- introductions through Google doc
- Explicit brainstorming at start of event; within teams, also pre-event on
  Google doc
- Set norms for inclusiveness: new projects, open to ideas and sharing
- Weekly/bi-weekly/monthly hacking event in addition to Codefest, online + Boston local
- Implement ideas on inclusive hackerspaces: https://egerber.mech.northwestern.edu/wp-content/uploads/2012/12/Gerber_UniversityMakerspaces-Opportunities-to-Support-Equitable-Participation-for-Women-in-Engineering.pdf
- Borrow existing measures of outcomes: https://thewinnower.com/papers/5577-a-step-by-step-guide-for-organizing-open-collaborative-brainhack-events
  https://neurohackweek.github.io/nhw2017/
- Invite people + friends: trust + engagement
