Computational dissection of intra-tumor genetic heterogeneity and applications
to the study of cancer treatment, evolution and metastasis
Scott Carter -- Broad Institute

Scott emphasizes that cancer tissue samples are heterogeneous: mixture of cancer
and normal, along with multiple sample subclones. End up with DNA from a
population of cells. Initial work on problem: HAPSEG
(https://www.broadinstitute.org/cancer/cga/hapseg) uses SNP arrays. Difficult
issue due to loads of unknowns to calculate copy number changes. Genotypes in
the reference are correlated by phasing. HAPSEQ feeds into ABSOLUTE
(https://www.broadinstitute.org/cancer/cga/absolute) which uses these copy
number estimates to infer purity and ploidy. Favor models with the least amount
of evolutions from a diploid cell.

Other work: classifying point-mutations by multiplicity: loss of
heterogeneity. Looked as expected: tumor suppressors are homozygous, onocogenes
are not. Found frequent whole genome doublings in cancer. Used exome sequencing
to identify subclonal populations: both CNVs and SNPs shared.

CAPSEG: calculates copy-ratios from whole-exome sequencing. Projects tumor
samples onto a basis of noise, getting a corrected sets of segmental change
points. Look at both CNVs and heterozygous SNP calls: expected hets
around 0.5. If you don't see then have something else going on. For
instance 0.8/0.2 in a deletion: 0.2 is contamination. Use this to identify
regions of allelic balance and inbalance. Evaluation on normal exomes: with
pulldown have +/- 0.5 due to pulldown. Binomial model is not a good fit because
of this. Also need to adjust for the fatter tail: beta-binomial model. Validated
on results with both exome and SNPs.

Current version of ABSOLUTE: cancer cell fraction (CCF) represented as
uncertainty, and then propagated forward. Can use these CCFs with uncertainty to
cluster similar CCFs across multiple samples of the same cancer that
metastasized. Can identify germline and clusters of mutations creating
phylogenetic tree of mutation history. Tool name is phylogic, doesn't look to be
publicly available.

Case studies using this on cancer metastasis with multiple samples over
time. You can use CCF to predict which SNPs are earlier drivers and which
occurred later. Found that subpopulations remained stable over time before
treatment. After chemo, certain subpopulations dominate that were previously
outcompeted by the main population.

Next case study: mouse model of small cell lung cancer. 3 tissue samples:
primary tumor + two independent liver metastases. One clone in the primary
tissue moved and then independently involved in two subsequent tumors. Infers
the initial subclone -- not yet done in human likely due to sampling bias.

Next case study: esophageal adenocarcinoma. 6 tissue samples across the whole
esophagus. Need a quantitative assessment of CCF to get the correct tree: naive
tree building no good. Contamination across tissues causes issues. What happened
is cancer evolved twice and then cross-contaminated.

Brain metastasis case study. Terrible diagnosis: median survival is
months. Looking at if brain metastases share the same subpopulations. Brain
samples for study are primarily old FFPE without matching normals. 88 cases: 84
show branched subclones: no overlap in closes between tissue samples. Could not
find founder clone but consistent with that hypothesis. The other 4 cases has
two totally different cancers that share no mutations. When did this happen? 3
people are heavy smokers, last patient had a germline BRCA mutation. Genetic
risk and environmental exposure: get cancer more than once. Second question:
were there brain cancer only mutations not in primary biopsy? Yes, even in only
a subset of cells in brain cells for some cases. Within the brain metastasis
they are more homogeneous so share actionable driver mutations.
