from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

CZECH_LANG_MODEL = {
    38: {  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.LIKELY,  # 'C'
        42: SequenceLikelihood.LIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.LIKELY,  # 'L'
        39: SequenceLikelihood.LIKELY,  # 'M'
        37: SequenceLikelihood.LIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.LIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    44: {  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.LIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    47: {  # 'C'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.LIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.LIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    42: {  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.LIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.LIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.LIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.LIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    48: {  # 'E'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.LIKELY,  # 'C'
        42: SequenceLikelihood.LIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.LIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.LIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        56: SequenceLikelihood.LIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    57: {  # 'F'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    60: {  # 'G'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    54: {  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    53: {  # 'I'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.LIKELY,  # 'C'
        42: SequenceLikelihood.LIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.LIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    45: {  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    41: {  # 'K'
        38: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    52: {  # 'L'
        38: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    39: {  # 'M'
        38: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.LIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.LIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.LIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    37: {  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.LIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.LIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    43: {  # 'O'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.LIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.LIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.LIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.LIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    32: {  # 'P'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.POSITIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.LIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    74: {  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    46: {  # 'R'
        38: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    35: {  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.LIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.LIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    40: {  # 'T'
        38: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.LIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.LIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.LIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    56: {  # 'U'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.LIKELY,  # 'ž'
    },
    36: {  # 'V'
        38: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.LIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.LIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.LIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    62: {  # 'W'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    69: {  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    66: {  # 'Y'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    50: {  # 'Z'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    3: {  # 'a'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.POSITIVE,  # 'f'
        33: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.LIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.POSITIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.LIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    23: {  # 'b'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.LIKELY,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.POSITIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.POSITIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.LIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.LIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    17: {  # 'c'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.LIKELY,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.LIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    12: {  # 'd'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.LIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.POSITIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.LIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.POSITIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    2: {  # 'e'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.POSITIVE,  # 'f'
        33: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.POSITIVE,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.LIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.LIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.POSITIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    34: {  # 'f'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.LIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    33: {  # 'g'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    19: {  # 'h'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.LIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.LIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.LIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.LIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.LIKELY,  # 'ž'
    },
    6: {  # 'i'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        33: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.LIKELY,  # 'é'
        16: SequenceLikelihood.LIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.LIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    21: {  # 'j'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.LIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    11: {  # 'k'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.LIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.POSITIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.LIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.POSITIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.LIKELY,  # 'ž'
    },
    8: {  # 'l'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        33: SequenceLikelihood.LIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.POSITIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.LIKELY,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.POSITIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    14: {  # 'm'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.LIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.POSITIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.POSITIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.LIKELY,  # 'ž'
    },
    4: {  # 'n'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.POSITIVE,  # 'f'
        33: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.POSITIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.POSITIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.POSITIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.LIKELY,  # 'ž'
    },
    1: {  # 'o'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.POSITIVE,  # 'f'
        33: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.LIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.POSITIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    15: {  # 'p'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.LIKELY,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.POSITIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.POSITIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.POSITIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    73: {  # 'q'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    10: {  # 'r'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        33: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.POSITIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.POSITIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    7: {  # 's'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.LIKELY,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.LIKELY,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.LIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    5: {  # 't'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.POSITIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.POSITIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.POSITIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.POSITIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    13: {  # 'u'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        33: SequenceLikelihood.LIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.LIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.LIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    9: {  # 'v'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.POSITIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.POSITIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.LIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.POSITIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.LIKELY,  # 'ž'
    },
    55: {  # 'w'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    51: {  # 'x'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    22: {  # 'y'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.LIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    20: {  # 'z'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.POSITIVE,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.LIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.LIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.LIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    72: {  # 'Á'
        38: SequenceLikelihood.NEGATIVE,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    76: {  # 'É'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.NEGATIVE,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    70: {  # 'Í'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.NEGATIVE,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.NEGATIVE,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    82: {  # 'Ó'
        38: SequenceLikelihood.NEGATIVE,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        57: SequenceLikelihood.NEGATIVE,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        53: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.NEGATIVE,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.NEGATIVE,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        21: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.NEGATIVE,  # 'u'
        9: SequenceLikelihood.NEGATIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    67: {  # 'Ú'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.NEGATIVE,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    77: {  # 'Ý'
        38: SequenceLikelihood.NEGATIVE,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        21: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    18: {  # 'á'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.POSITIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    25: {  # 'é'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.LIKELY,  # 'ž'
    },
    16: {  # 'í'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.LIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    63: {  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'A'
        44: SequenceLikelihood.NEGATIVE,  # 'B'
        47: SequenceLikelihood.NEGATIVE,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        57: SequenceLikelihood.NEGATIVE,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        53: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.NEGATIVE,  # 'K'
        52: SequenceLikelihood.NEGATIVE,  # 'L'
        39: SequenceLikelihood.NEGATIVE,  # 'M'
        37: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.NEGATIVE,  # 'U'
        36: SequenceLikelihood.NEGATIVE,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    49: {  # 'ú'
        38: SequenceLikelihood.NEGATIVE,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.NEGATIVE,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        57: SequenceLikelihood.NEGATIVE,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        53: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        41: SequenceLikelihood.NEGATIVE,  # 'K'
        52: SequenceLikelihood.NEGATIVE,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.NEGATIVE,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.UNLIKELY,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.LIKELY,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    29: {  # 'ý'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.LIKELY,  # 'ž'
    },
    59: {  # 'Č'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.LIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    28: {  # 'č'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.LIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    79: {  # 'Ď'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.NEGATIVE,  # 'B'
        47: SequenceLikelihood.NEGATIVE,  # 'C'
        42: SequenceLikelihood.NEGATIVE,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        53: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.NEGATIVE,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.NEGATIVE,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.NEGATIVE,  # 'v'
        55: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    65: {  # 'ď'
        38: SequenceLikelihood.NEGATIVE,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.NEGATIVE,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.NEGATIVE,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.NEGATIVE,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.NEGATIVE,  # 'T'
        56: SequenceLikelihood.NEGATIVE,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    75: {  # 'Ě'
        38: SequenceLikelihood.NEGATIVE,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        23: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.NEGATIVE,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    24: {  # 'ě'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.POSITIVE,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.LIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.POSITIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    81: {  # 'Ň'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.NEGATIVE,  # 'B'
        47: SequenceLikelihood.NEGATIVE,  # 'C'
        42: SequenceLikelihood.NEGATIVE,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        57: SequenceLikelihood.NEGATIVE,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.NEGATIVE,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.NEGATIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    58: {  # 'ň'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    71: {  # 'Ř'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.UNLIKELY,  # 'Y'
        50: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.NEGATIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    26: {  # 'ř'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.LIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    64: {  # 'Š'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    30: {  # 'š'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.NEGATIVE,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.UNLIKELY,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        61: SequenceLikelihood.LIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    80: {  # 'Ť'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.NEGATIVE,  # 'B'
        47: SequenceLikelihood.NEGATIVE,  # 'C'
        42: SequenceLikelihood.NEGATIVE,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.NEGATIVE,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.NEGATIVE,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.NEGATIVE,  # 'b'
        17: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.NEGATIVE,  # 'r'
        7: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.NEGATIVE,  # 'v'
        55: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.UNLIKELY,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.NEGATIVE,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    61: {  # 'ť'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    78: {  # 'Ů'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.NEGATIVE,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.NEGATIVE,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        13: SequenceLikelihood.NEGATIVE,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        16: SequenceLikelihood.NEGATIVE,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.NEGATIVE,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.NEGATIVE,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    31: {  # 'ů'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        11: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.LIKELY,  # 'r'
        7: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.POSITIVE,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.NEGATIVE,  # 'Ň'
        58: SequenceLikelihood.UNLIKELY,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    68: {  # 'Ž'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.NEGATIVE,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.NEGATIVE,  # 'j'
        11: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.NEGATIVE,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'Á'
        76: SequenceLikelihood.UNLIKELY,  # 'É'
        70: SequenceLikelihood.UNLIKELY,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.UNLIKELY,  # 'í'
        63: SequenceLikelihood.NEGATIVE,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.NEGATIVE,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        79: SequenceLikelihood.UNLIKELY,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.NEGATIVE,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.NEGATIVE,  # 'ň'
        71: SequenceLikelihood.UNLIKELY,  # 'Ř'
        26: SequenceLikelihood.NEGATIVE,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.NEGATIVE,  # 'ť'
        78: SequenceLikelihood.UNLIKELY,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        27: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    27: {  # 'ž'
        38: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        42: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        57: SequenceLikelihood.UNLIKELY,  # 'F'
        60: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        53: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        41: SequenceLikelihood.UNLIKELY,  # 'K'
        52: SequenceLikelihood.UNLIKELY,  # 'L'
        39: SequenceLikelihood.UNLIKELY,  # 'M'
        37: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        74: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        56: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        62: SequenceLikelihood.UNLIKELY,  # 'W'
        69: SequenceLikelihood.NEGATIVE,  # 'X'
        66: SequenceLikelihood.NEGATIVE,  # 'Y'
        50: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'b'
        17: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        33: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        11: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        73: SequenceLikelihood.UNLIKELY,  # 'q'
        10: SequenceLikelihood.UNLIKELY,  # 'r'
        7: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        9: SequenceLikelihood.UNLIKELY,  # 'v'
        55: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'Á'
        76: SequenceLikelihood.NEGATIVE,  # 'É'
        70: SequenceLikelihood.NEGATIVE,  # 'Í'
        82: SequenceLikelihood.NEGATIVE,  # 'Ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ú'
        77: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        16: SequenceLikelihood.POSITIVE,  # 'í'
        63: SequenceLikelihood.UNLIKELY,  # 'ó'
        49: SequenceLikelihood.UNLIKELY,  # 'ú'
        29: SequenceLikelihood.UNLIKELY,  # 'ý'
        59: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        79: SequenceLikelihood.NEGATIVE,  # 'Ď'
        65: SequenceLikelihood.UNLIKELY,  # 'ď'
        75: SequenceLikelihood.NEGATIVE,  # 'Ě'
        24: SequenceLikelihood.UNLIKELY,  # 'ě'
        81: SequenceLikelihood.UNLIKELY,  # 'Ň'
        58: SequenceLikelihood.LIKELY,  # 'ň'
        71: SequenceLikelihood.NEGATIVE,  # 'Ř'
        26: SequenceLikelihood.UNLIKELY,  # 'ř'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        30: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        61: SequenceLikelihood.UNLIKELY,  # 'ť'
        78: SequenceLikelihood.NEGATIVE,  # 'Ů'
        31: SequenceLikelihood.UNLIKELY,  # 'ů'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        27: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
}

# Character Mapping Table(s):
CP852_CZECH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 38,  # 'A'
    66: 44,  # 'B'
    67: 47,  # 'C'
    68: 42,  # 'D'
    69: 48,  # 'E'
    70: 57,  # 'F'
    71: 60,  # 'G'
    72: 54,  # 'H'
    73: 53,  # 'I'
    74: 45,  # 'J'
    75: 41,  # 'K'
    76: 52,  # 'L'
    77: 39,  # 'M'
    78: 37,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 74,  # 'Q'
    82: 46,  # 'R'
    83: 35,  # 'S'
    84: 40,  # 'T'
    85: 56,  # 'U'
    86: 36,  # 'V'
    87: 62,  # 'W'
    88: 69,  # 'X'
    89: 66,  # 'Y'
    90: 50,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 23,  # 'b'
    99: 17,  # 'c'
    100: 12,  # 'd'
    101: 2,  # 'e'
    102: 34,  # 'f'
    103: 33,  # 'g'
    104: 19,  # 'h'
    105: 6,  # 'i'
    106: 21,  # 'j'
    107: 11,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 1,  # 'o'
    112: 15,  # 'p'
    113: 73,  # 'q'
    114: 10,  # 'r'
    115: 7,  # 's'
    116: 5,  # 't'
    117: 13,  # 'u'
    118: 9,  # 'v'
    119: 55,  # 'w'
    120: 51,  # 'x'
    121: 22,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 25,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 31,  # 'ů'
    134: 0,  # 'ć'
    135: 0,  # 'ç'
    136: 0,  # 'ł'
    137: 0,  # 'ë'
    138: 0,  # 'Ő'
    139: 0,  # 'ő'
    140: 0,  # 'î'
    141: 0,  # 'Ź'
    142: 0,  # 'Ä'
    143: 0,  # 'Ć'
    144: 76,  # 'É'
    145: 0,  # 'Ĺ'
    146: 0,  # 'ĺ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'Ľ'
    150: 0,  # 'ľ'
    151: 0,  # 'Ś'
    152: 0,  # 'ś'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 80,  # 'Ť'
    156: 61,  # 'ť'
    157: 0,  # 'Ł'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 28,  # 'č'
    160: 18,  # 'á'
    161: 16,  # 'í'
    162: 63,  # 'ó'
    163: 49,  # 'ú'
    164: 0,  # 'Ą'
    165: 0,  # 'ą'
    166: 68,  # 'Ž'
    167: 27,  # 'ž'
    168: 0,  # 'Ę'
    169: 0,  # 'ę'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: 0,  # 'ź'
    172: 59,  # 'Č'
    173: 0,  # 'ş'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 72,  # 'Á'
    182: 0,  # 'Â'
    183: 75,  # 'Ě'
    184: 0,  # 'Ş'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 0,  # 'Ż'
    190: 0,  # 'ż'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'Ă'
    199: 0,  # 'ă'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'đ'
    209: 0,  # 'Đ'
    210: 79,  # 'Ď'
    211: 0,  # 'Ë'
    212: 65,  # 'ď'
    213: 81,  # 'Ň'
    214: 70,  # 'Í'
    215: 0,  # 'Î'
    216: 24,  # 'ě'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: 0,  # 'Ţ'
    222: 78,  # 'Ů'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 82,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ń'
    228: 0,  # 'ń'
    229: 58,  # 'ň'
    230: 64,  # 'Š'
    231: 30,  # 'š'
    232: 0,  # 'Ŕ'
    233: 67,  # 'Ú'
    234: 0,  # 'ŕ'
    235: 0,  # 'Ű'
    236: 29,  # 'ý'
    237: 77,  # 'Ý'
    238: 0,  # 'ţ'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '˝'
    242: CharacterCategory.SYMBOL,  # '˛'
    243: 0,  # 'ˇ'
    244: CharacterCategory.SYMBOL,  # '˘'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: 0,  # 'ű'
    252: 71,  # 'Ř'
    253: 26,  # 'ř'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP852_CZECH_MODEL = SingleByteCharSetModel(
    charset_name="CP852",
    language="Czech",
    char_to_order_map=CP852_CZECH_CHAR_TO_ORDER,
    language_model=CZECH_LANG_MODEL,
    typical_positive_ratio=0.9326686569821343,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚÝáéíóúýČčĎďĚěŇňŘřŠšŤťŮůŽž",
)

ISO_8859_2_CZECH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 38,  # 'A'
    66: 44,  # 'B'
    67: 47,  # 'C'
    68: 42,  # 'D'
    69: 48,  # 'E'
    70: 57,  # 'F'
    71: 60,  # 'G'
    72: 54,  # 'H'
    73: 53,  # 'I'
    74: 45,  # 'J'
    75: 41,  # 'K'
    76: 52,  # 'L'
    77: 39,  # 'M'
    78: 37,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 74,  # 'Q'
    82: 46,  # 'R'
    83: 35,  # 'S'
    84: 40,  # 'T'
    85: 56,  # 'U'
    86: 36,  # 'V'
    87: 62,  # 'W'
    88: 69,  # 'X'
    89: 66,  # 'Y'
    90: 50,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 23,  # 'b'
    99: 17,  # 'c'
    100: 12,  # 'd'
    101: 2,  # 'e'
    102: 34,  # 'f'
    103: 33,  # 'g'
    104: 19,  # 'h'
    105: 6,  # 'i'
    106: 21,  # 'j'
    107: 11,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 1,  # 'o'
    112: 15,  # 'p'
    113: 73,  # 'q'
    114: 10,  # 'r'
    115: 7,  # 's'
    116: 5,  # 't'
    117: 13,  # 'u'
    118: 9,  # 'v'
    119: 55,  # 'w'
    120: 51,  # 'x'
    121: 22,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ľ'
    166: 0,  # 'Ś'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: 64,  # 'Š'
    170: 0,  # 'Ş'
    171: 80,  # 'Ť'
    172: 0,  # 'Ź'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 68,  # 'Ž'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 0,  # 'ą'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ł'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'ľ'
    182: 0,  # 'ś'
    183: 0,  # 'ˇ'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 30,  # 'š'
    186: 0,  # 'ş'
    187: 61,  # 'ť'
    188: 0,  # 'ź'
    189: CharacterCategory.SYMBOL,  # '˝'
    190: 27,  # 'ž'
    191: 0,  # 'ż'
    192: 0,  # 'Ŕ'
    193: 72,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ĺ'
    198: 0,  # 'Ć'
    199: 0,  # 'Ç'
    200: 59,  # 'Č'
    201: 76,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 75,  # 'Ě'
    205: 70,  # 'Í'
    206: 0,  # 'Î'
    207: 79,  # 'Ď'
    208: 0,  # 'Đ'
    209: 0,  # 'Ń'
    210: 81,  # 'Ň'
    211: 82,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 71,  # 'Ř'
    217: 78,  # 'Ů'
    218: 67,  # 'Ú'
    219: 0,  # 'Ű'
    220: 0,  # 'Ü'
    221: 77,  # 'Ý'
    222: 0,  # 'Ţ'
    223: 0,  # 'ß'
    224: 0,  # 'ŕ'
    225: 18,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ĺ'
    230: 0,  # 'ć'
    231: 0,  # 'ç'
    232: 28,  # 'č'
    233: 25,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 24,  # 'ě'
    237: 16,  # 'í'
    238: 0,  # 'î'
    239: 65,  # 'ď'
    240: 0,  # 'đ'
    241: 0,  # 'ń'
    242: 58,  # 'ň'
    243: 63,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 26,  # 'ř'
    249: 31,  # 'ů'
    250: 49,  # 'ú'
    251: 0,  # 'ű'
    252: 0,  # 'ü'
    253: 29,  # 'ý'
    254: 0,  # 'ţ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

ISO_8859_2_CZECH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-2",
    language="Czech",
    char_to_order_map=ISO_8859_2_CZECH_CHAR_TO_ORDER,
    language_model=CZECH_LANG_MODEL,
    typical_positive_ratio=0.9326686569821343,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚÝáéíóúýČčĎďĚěŇňŘřŠšŤťŮůŽž",
)

ISO_8859_16_CZECH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 38,  # 'A'
    66: 44,  # 'B'
    67: 47,  # 'C'
    68: 42,  # 'D'
    69: 48,  # 'E'
    70: 57,  # 'F'
    71: 60,  # 'G'
    72: 54,  # 'H'
    73: 53,  # 'I'
    74: 45,  # 'J'
    75: 41,  # 'K'
    76: 52,  # 'L'
    77: 39,  # 'M'
    78: 37,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 74,  # 'Q'
    82: 46,  # 'R'
    83: 35,  # 'S'
    84: 40,  # 'T'
    85: 56,  # 'U'
    86: 36,  # 'V'
    87: 62,  # 'W'
    88: 69,  # 'X'
    89: 66,  # 'Y'
    90: 50,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 23,  # 'b'
    99: 17,  # 'c'
    100: 12,  # 'd'
    101: 2,  # 'e'
    102: 34,  # 'f'
    103: 33,  # 'g'
    104: 19,  # 'h'
    105: 6,  # 'i'
    106: 21,  # 'j'
    107: 11,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 1,  # 'o'
    112: 15,  # 'p'
    113: 73,  # 'q'
    114: 10,  # 'r'
    115: 7,  # 's'
    116: 5,  # 't'
    117: 13,  # 'u'
    118: 9,  # 'v'
    119: 55,  # 'w'
    120: 51,  # 'x'
    121: 22,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: 0,  # 'ą'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '„'
    166: 64,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 30,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ș'
    171: CharacterCategory.SYMBOL,  # '«'
    172: 0,  # 'Ź'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'ź'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 59,  # 'Č'
    179: 0,  # 'ł'
    180: 68,  # 'Ž'
    181: CharacterCategory.SYMBOL,  # '”'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 27,  # 'ž'
    185: 28,  # 'č'
    186: 0,  # 'ș'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: 0,  # 'ż'
    192: 0,  # 'À'
    193: 72,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ć'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 76,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 70,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Đ'
    209: 0,  # 'Ń'
    210: 0,  # 'Ò'
    211: 82,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: 0,  # 'Ś'
    216: 0,  # 'Ű'
    217: 0,  # 'Ù'
    218: 67,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ę'
    222: 0,  # 'Ț'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 18,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ć'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 25,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 16,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'đ'
    241: 0,  # 'ń'
    242: 0,  # 'ò'
    243: 63,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: 0,  # 'ś'
    248: 0,  # 'ű'
    249: 0,  # 'ù'
    250: 49,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ę'
    254: 0,  # 'ț'
    255: 0,  # 'ÿ'
}

ISO_8859_16_CZECH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-16",
    language="Czech",
    char_to_order_map=ISO_8859_16_CZECH_CHAR_TO_ORDER,
    language_model=CZECH_LANG_MODEL,
    typical_positive_ratio=0.9383332322021865,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚÝáéíóúýČčĎďĚěŇňŘřŠšŤťŮůŽž",
)

MACLATIN2_CZECH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 38,  # 'A'
    66: 44,  # 'B'
    67: 47,  # 'C'
    68: 42,  # 'D'
    69: 48,  # 'E'
    70: 57,  # 'F'
    71: 60,  # 'G'
    72: 54,  # 'H'
    73: 53,  # 'I'
    74: 45,  # 'J'
    75: 41,  # 'K'
    76: 52,  # 'L'
    77: 39,  # 'M'
    78: 37,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 74,  # 'Q'
    82: 46,  # 'R'
    83: 35,  # 'S'
    84: 40,  # 'T'
    85: 56,  # 'U'
    86: 36,  # 'V'
    87: 62,  # 'W'
    88: 69,  # 'X'
    89: 66,  # 'Y'
    90: 50,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 23,  # 'b'
    99: 17,  # 'c'
    100: 12,  # 'd'
    101: 2,  # 'e'
    102: 34,  # 'f'
    103: 33,  # 'g'
    104: 19,  # 'h'
    105: 6,  # 'i'
    106: 21,  # 'j'
    107: 11,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 1,  # 'o'
    112: 15,  # 'p'
    113: 73,  # 'q'
    114: 10,  # 'r'
    115: 7,  # 's'
    116: 5,  # 't'
    117: 13,  # 'u'
    118: 9,  # 'v'
    119: 55,  # 'w'
    120: 51,  # 'x'
    121: 22,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Ā'
    130: 0,  # 'ā'
    131: 76,  # 'É'
    132: 0,  # 'Ą'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 18,  # 'á'
    136: 0,  # 'ą'
    137: 59,  # 'Č'
    138: 0,  # 'ä'
    139: 28,  # 'č'
    140: 0,  # 'Ć'
    141: 0,  # 'ć'
    142: 25,  # 'é'
    143: 0,  # 'Ź'
    144: 0,  # 'ź'
    145: 79,  # 'Ď'
    146: 16,  # 'í'
    147: 65,  # 'ď'
    148: 0,  # 'Ē'
    149: 0,  # 'ē'
    150: 0,  # 'Ė'
    151: 63,  # 'ó'
    152: 0,  # 'ė'
    153: 0,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 49,  # 'ú'
    157: 75,  # 'Ě'
    158: 24,  # 'ě'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: 0,  # 'Ę'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: 0,  # 'ę'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'ģ'
    175: 0,  # 'Į'
    176: 0,  # 'į'
    177: 0,  # 'Ī'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: 0,  # 'ī'
    181: 0,  # 'Ķ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: 0,  # 'ł'
    185: 0,  # 'Ļ'
    186: 0,  # 'ļ'
    187: 0,  # 'Ľ'
    188: 0,  # 'ľ'
    189: 0,  # 'Ĺ'
    190: 0,  # 'ĺ'
    191: 0,  # 'Ņ'
    192: 0,  # 'ņ'
    193: 0,  # 'Ń'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ń'
    197: 81,  # 'Ň'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 58,  # 'ň'
    204: 0,  # 'Ő'
    205: 0,  # 'Õ'
    206: 0,  # 'ő'
    207: 0,  # 'Ō'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ō'
    217: 0,  # 'Ŕ'
    218: 0,  # 'ŕ'
    219: 71,  # 'Ř'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 26,  # 'ř'
    223: 0,  # 'Ŗ'
    224: 0,  # 'ŗ'
    225: 64,  # 'Š'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: 30,  # 'š'
    229: 0,  # 'Ś'
    230: 0,  # 'ś'
    231: 72,  # 'Á'
    232: 80,  # 'Ť'
    233: 61,  # 'ť'
    234: 70,  # 'Í'
    235: 68,  # 'Ž'
    236: 27,  # 'ž'
    237: 0,  # 'Ū'
    238: 82,  # 'Ó'
    239: 0,  # 'Ô'
    240: 0,  # 'ū'
    241: 78,  # 'Ů'
    242: 67,  # 'Ú'
    243: 31,  # 'ů'
    244: 0,  # 'Ű'
    245: 0,  # 'ű'
    246: 0,  # 'Ų'
    247: 0,  # 'ų'
    248: 77,  # 'Ý'
    249: 29,  # 'ý'
    250: 0,  # 'ķ'
    251: 0,  # 'Ż'
    252: 0,  # 'Ł'
    253: 0,  # 'ż'
    254: 0,  # 'Ģ'
    255: 0,  # 'ˇ'
}

MACLATIN2_CZECH_MODEL = SingleByteCharSetModel(
    charset_name="MacLatin2",
    language="Czech",
    char_to_order_map=MACLATIN2_CZECH_CHAR_TO_ORDER,
    language_model=CZECH_LANG_MODEL,
    typical_positive_ratio=0.9326686569821343,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚÝáéíóúýČčĎďĚěŇňŘřŠšŤťŮůŽž",
)

WINDOWS_1250_CZECH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 38,  # 'A'
    66: 44,  # 'B'
    67: 47,  # 'C'
    68: 42,  # 'D'
    69: 48,  # 'E'
    70: 57,  # 'F'
    71: 60,  # 'G'
    72: 54,  # 'H'
    73: 53,  # 'I'
    74: 45,  # 'J'
    75: 41,  # 'K'
    76: 52,  # 'L'
    77: 39,  # 'M'
    78: 37,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 74,  # 'Q'
    82: 46,  # 'R'
    83: 35,  # 'S'
    84: 40,  # 'T'
    85: 56,  # 'U'
    86: 36,  # 'V'
    87: 62,  # 'W'
    88: 69,  # 'X'
    89: 66,  # 'Y'
    90: 50,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 23,  # 'b'
    99: 17,  # 'c'
    100: 12,  # 'd'
    101: 2,  # 'e'
    102: 34,  # 'f'
    103: 33,  # 'g'
    104: 19,  # 'h'
    105: 6,  # 'i'
    106: 21,  # 'j'
    107: 11,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 1,  # 'o'
    112: 15,  # 'p'
    113: 73,  # 'q'
    114: 10,  # 'r'
    115: 7,  # 's'
    116: 5,  # 't'
    117: 13,  # 'u'
    118: 9,  # 'v'
    119: 55,  # 'w'
    120: 51,  # 'x'
    121: 22,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: CharacterCategory.UNDEFINED,  # None
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.UNDEFINED,  # None
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 64,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Ś'
    141: 80,  # 'Ť'
    142: 68,  # 'Ž'
    143: 0,  # 'Ź'
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 30,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'ś'
    157: 61,  # 'ť'
    158: 27,  # 'ž'
    159: 0,  # 'ź'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'ˇ'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ą'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ş'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ł'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 0,  # 'ą'
    186: 0,  # 'ş'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Ľ'
    189: CharacterCategory.SYMBOL,  # '˝'
    190: 0,  # 'ľ'
    191: 0,  # 'ż'
    192: 0,  # 'Ŕ'
    193: 72,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ĺ'
    198: 0,  # 'Ć'
    199: 0,  # 'Ç'
    200: 59,  # 'Č'
    201: 76,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 75,  # 'Ě'
    205: 70,  # 'Í'
    206: 0,  # 'Î'
    207: 79,  # 'Ď'
    208: 0,  # 'Đ'
    209: 0,  # 'Ń'
    210: 81,  # 'Ň'
    211: 82,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 71,  # 'Ř'
    217: 78,  # 'Ů'
    218: 67,  # 'Ú'
    219: 0,  # 'Ű'
    220: 0,  # 'Ü'
    221: 77,  # 'Ý'
    222: 0,  # 'Ţ'
    223: 0,  # 'ß'
    224: 0,  # 'ŕ'
    225: 18,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ĺ'
    230: 0,  # 'ć'
    231: 0,  # 'ç'
    232: 28,  # 'č'
    233: 25,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 24,  # 'ě'
    237: 16,  # 'í'
    238: 0,  # 'î'
    239: 65,  # 'ď'
    240: 0,  # 'đ'
    241: 0,  # 'ń'
    242: 58,  # 'ň'
    243: 63,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 26,  # 'ř'
    249: 31,  # 'ů'
    250: 49,  # 'ú'
    251: 0,  # 'ű'
    252: 0,  # 'ü'
    253: 29,  # 'ý'
    254: 0,  # 'ţ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

WINDOWS_1250_CZECH_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1250",
    language="Czech",
    char_to_order_map=WINDOWS_1250_CZECH_CHAR_TO_ORDER,
    language_model=CZECH_LANG_MODEL,
    typical_positive_ratio=0.9326686569821343,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÚÝáéíóúýČčĎďĚěŇňŘřŠšŤťŮůŽž",
)
