from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

HUNGARIAN_LANG_MODEL = {
    31: {  # 'A'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.LIKELY,  # 'K'
        46: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.LIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.LIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    39: {  # 'B'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    47: {  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.NEGATIVE,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.LIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.NEGATIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    49: {  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    34: {  # 'E'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.LIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.LIKELY,  # 'K'
        46: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        57: SequenceLikelihood.LIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.LIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.NEGATIVE,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    45: {  # 'F'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.LIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    51: {  # 'G'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.LIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.LIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    42: {  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.LIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    43: {  # 'I'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.NEGATIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    54: {  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.LIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    37: {  # 'K'
        31: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.LIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.LIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    46: {  # 'L'
        31: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    33: {  # 'M'
        31: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.LIKELY,  # 'ű'
    },
    41: {  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.LIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.LIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    52: {  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.LIKELY,  # 'K'
        46: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.NEGATIVE,  # 'é'
        29: SequenceLikelihood.NEGATIVE,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.NEGATIVE,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.NEGATIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    44: {  # 'P'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    69: {  # 'Q'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.NEGATIVE,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.NEGATIVE,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.NEGATIVE,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.NEGATIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    50: {  # 'R'
        31: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.LIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    35: {  # 'S'
        31: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.LIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    38: {  # 'T'
        31: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.LIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.LIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.LIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    57: {  # 'U'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.NEGATIVE,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.NEGATIVE,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    48: {  # 'V'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    59: {  # 'W'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.NEGATIVE,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    62: {  # 'X'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.NEGATIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    61: {  # 'Y'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    55: {  # 'Z'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    2: {  # 'a'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.POSITIVE,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.LIKELY,  # 'w'
        40: SequenceLikelihood.LIKELY,  # 'x'
        16: SequenceLikelihood.LIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    18: {  # 'b'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.LIKELY,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.LIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.LIKELY,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.LIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.POSITIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.LIKELY,  # 'ű'
    },
    28: {  # 'c'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.LIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.LIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    17: {  # 'd'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.POSITIVE,  # 'j'
        7: SequenceLikelihood.LIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.LIKELY,  # 'y'
        11: SequenceLikelihood.LIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.POSITIVE,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.LIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.POSITIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    1: {  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.POSITIVE,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.POSITIVE,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.LIKELY,  # 'w'
        40: SequenceLikelihood.POSITIVE,  # 'x'
        16: SequenceLikelihood.LIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.LIKELY,  # 'í'
        24: SequenceLikelihood.LIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    26: {  # 'f'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.LIKELY,  # 'ó'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.POSITIVE,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.POSITIVE,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.LIKELY,  # 'ű'
    },
    14: {  # 'g'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.POSITIVE,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.POSITIVE,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.POSITIVE,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.POSITIVE,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.LIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.LIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.LIKELY,  # 'ű'
    },
    20: {  # 'h'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.LIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.POSITIVE,  # 'í'
        24: SequenceLikelihood.LIKELY,  # 'ó'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.LIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.LIKELY,  # 'ű'
    },
    8: {  # 'i'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.POSITIVE,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.LIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.LIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    23: {  # 'j'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.LIKELY,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.LIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.LIKELY,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.POSITIVE,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    7: {  # 'k'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.LIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.LIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.POSITIVE,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.POSITIVE,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.LIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.LIKELY,  # 'ű'
    },
    5: {  # 'l'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.POSITIVE,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.POSITIVE,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.POSITIVE,  # 'y'
        11: SequenceLikelihood.LIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.POSITIVE,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.POSITIVE,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.POSITIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    15: {  # 'm'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.LIKELY,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.LIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.LIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.POSITIVE,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.LIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.POSITIVE,  # 'ű'
    },
    6: {  # 'n'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.POSITIVE,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.LIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.POSITIVE,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.LIKELY,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.LIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.POSITIVE,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.LIKELY,  # 'ű'
    },
    10: {  # 'o'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.POSITIVE,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.LIKELY,  # 'w'
        40: SequenceLikelihood.LIKELY,  # 'x'
        16: SequenceLikelihood.LIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    21: {  # 'p'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        28: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.POSITIVE,  # 'j'
        7: SequenceLikelihood.LIKELY,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.LIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.LIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.POSITIVE,  # 'í'
        24: SequenceLikelihood.LIKELY,  # 'ó'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.LIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.LIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    68: {  # 'q'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.NEGATIVE,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    9: {  # 'r'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.POSITIVE,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.POSITIVE,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.LIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.LIKELY,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.POSITIVE,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.POSITIVE,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.POSITIVE,  # 'ű'
    },
    4: {  # 's'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.LIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.LIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.POSITIVE,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        32: SequenceLikelihood.POSITIVE,  # 'ú'
        30: SequenceLikelihood.POSITIVE,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.POSITIVE,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.LIKELY,  # 'ű'
    },
    3: {  # 't'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.POSITIVE,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.POSITIVE,  # 'y'
        11: SequenceLikelihood.LIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.POSITIVE,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        32: SequenceLikelihood.POSITIVE,  # 'ú'
        30: SequenceLikelihood.POSITIVE,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.POSITIVE,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.POSITIVE,  # 'ű'
    },
    22: {  # 'u'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.LIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.LIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.LIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.LIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    19: {  # 'v'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.LIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.POSITIVE,  # 'í'
        24: SequenceLikelihood.LIKELY,  # 'ó'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.LIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.POSITIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.LIKELY,  # 'ű'
    },
    53: {  # 'w'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.LIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    40: {  # 'x'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.LIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.LIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    16: {  # 'y'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.LIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.POSITIVE,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.POSITIVE,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.LIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.LIKELY,  # 'ű'
    },
    11: {  # 'z'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.POSITIVE,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.POSITIVE,  # 'á'
        13: SequenceLikelihood.POSITIVE,  # 'é'
        29: SequenceLikelihood.POSITIVE,  # 'í'
        24: SequenceLikelihood.POSITIVE,  # 'ó'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        32: SequenceLikelihood.LIKELY,  # 'ú'
        30: SequenceLikelihood.POSITIVE,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.POSITIVE,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.LIKELY,  # 'ű'
    },
    58: {  # 'Á'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.NEGATIVE,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.NEGATIVE,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.NEGATIVE,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.NEGATIVE,  # 'w'
        40: SequenceLikelihood.NEGATIVE,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.NEGATIVE,  # 'é'
        29: SequenceLikelihood.NEGATIVE,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.NEGATIVE,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.NEGATIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    56: {  # 'É'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.NEGATIVE,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.LIKELY,  # 'v'
        53: SequenceLikelihood.NEGATIVE,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.NEGATIVE,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.NEGATIVE,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.NEGATIVE,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.NEGATIVE,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    64: {  # 'Í'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.NEGATIVE,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.NEGATIVE,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        26: SequenceLikelihood.NEGATIVE,  # 'f'
        14: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.NEGATIVE,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.NEGATIVE,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.NEGATIVE,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.NEGATIVE,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.NEGATIVE,  # 'w'
        40: SequenceLikelihood.NEGATIVE,  # 'x'
        16: SequenceLikelihood.NEGATIVE,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.NEGATIVE,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.NEGATIVE,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.NEGATIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    65: {  # 'Ó'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.NEGATIVE,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.NEGATIVE,  # 'w'
        40: SequenceLikelihood.NEGATIVE,  # 'x'
        16: SequenceLikelihood.NEGATIVE,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.NEGATIVE,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.NEGATIVE,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.NEGATIVE,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.NEGATIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    60: {  # 'Ö'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.NEGATIVE,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.NEGATIVE,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        68: SequenceLikelihood.NEGATIVE,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.NEGATIVE,  # 'w'
        40: SequenceLikelihood.NEGATIVE,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.NEGATIVE,  # 'á'
        13: SequenceLikelihood.NEGATIVE,  # 'é'
        29: SequenceLikelihood.NEGATIVE,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.NEGATIVE,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.NEGATIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    63: {  # 'Ú'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.NEGATIVE,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        26: SequenceLikelihood.NEGATIVE,  # 'f'
        14: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.NEGATIVE,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.NEGATIVE,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.NEGATIVE,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.NEGATIVE,  # 'u'
        19: SequenceLikelihood.NEGATIVE,  # 'v'
        53: SequenceLikelihood.NEGATIVE,  # 'w'
        40: SequenceLikelihood.NEGATIVE,  # 'x'
        16: SequenceLikelihood.NEGATIVE,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.NEGATIVE,  # 'á'
        13: SequenceLikelihood.NEGATIVE,  # 'é'
        29: SequenceLikelihood.NEGATIVE,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.NEGATIVE,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.NEGATIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    67: {  # 'Ü'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        26: SequenceLikelihood.NEGATIVE,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        68: SequenceLikelihood.NEGATIVE,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.NEGATIVE,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.NEGATIVE,  # 'w'
        40: SequenceLikelihood.NEGATIVE,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.NEGATIVE,  # 'á'
        13: SequenceLikelihood.NEGATIVE,  # 'é'
        29: SequenceLikelihood.NEGATIVE,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.NEGATIVE,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    12: {  # 'á'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.NEGATIVE,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.NEGATIVE,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.NEGATIVE,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.POSITIVE,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.POSITIVE,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.LIKELY,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.LIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    13: {  # 'é'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.NEGATIVE,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.UNLIKELY,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.NEGATIVE,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        8: SequenceLikelihood.LIKELY,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    29: {  # 'í'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.NEGATIVE,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.NEGATIVE,  # 'E'
        45: SequenceLikelihood.NEGATIVE,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.NEGATIVE,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.NEGATIVE,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.LIKELY,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    24: {  # 'ó'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.POSITIVE,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.NEGATIVE,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    25: {  # 'ö'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.NEGATIVE,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.NEGATIVE,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.NEGATIVE,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.NEGATIVE,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.NEGATIVE,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    32: {  # 'ú'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.NEGATIVE,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.NEGATIVE,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.NEGATIVE,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.NEGATIVE,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.NEGATIVE,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.POSITIVE,  # 'j'
        7: SequenceLikelihood.LIKELY,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.NEGATIVE,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.LIKELY,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    30: {  # 'ü'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.NEGATIVE,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.NEGATIVE,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.NEGATIVE,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.NEGATIVE,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.NEGATIVE,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.UNLIKELY,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.LIKELY,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.NEGATIVE,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    66: {  # 'Ő'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        68: SequenceLikelihood.NEGATIVE,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.NEGATIVE,  # 'w'
        40: SequenceLikelihood.NEGATIVE,  # 'x'
        16: SequenceLikelihood.NEGATIVE,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.UNLIKELY,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.NEGATIVE,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.NEGATIVE,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    27: {  # 'ő'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.UNLIKELY,  # 'X'
        61: SequenceLikelihood.UNLIKELY,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        28: SequenceLikelihood.LIKELY,  # 'c'
        17: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        26: SequenceLikelihood.LIKELY,  # 'f'
        14: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        8: SequenceLikelihood.POSITIVE,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        68: SequenceLikelihood.NEGATIVE,  # 'q'
        9: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.POSITIVE,  # 'v'
        53: SequenceLikelihood.UNLIKELY,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.UNLIKELY,  # 'y'
        11: SequenceLikelihood.POSITIVE,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.UNLIKELY,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.LIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.UNLIKELY,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
    70: {  # 'Ű'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.NEGATIVE,  # 'O'
        44: SequenceLikelihood.NEGATIVE,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.NEGATIVE,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.NEGATIVE,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        28: SequenceLikelihood.NEGATIVE,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        26: SequenceLikelihood.NEGATIVE,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.NEGATIVE,  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'j'
        7: SequenceLikelihood.UNLIKELY,  # 'k'
        5: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        68: SequenceLikelihood.NEGATIVE,  # 'q'
        9: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        22: SequenceLikelihood.NEGATIVE,  # 'u'
        19: SequenceLikelihood.UNLIKELY,  # 'v'
        53: SequenceLikelihood.NEGATIVE,  # 'w'
        40: SequenceLikelihood.NEGATIVE,  # 'x'
        16: SequenceLikelihood.NEGATIVE,  # 'y'
        11: SequenceLikelihood.UNLIKELY,  # 'z'
        58: SequenceLikelihood.NEGATIVE,  # 'Á'
        56: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.NEGATIVE,  # 'Ü'
        12: SequenceLikelihood.NEGATIVE,  # 'á'
        13: SequenceLikelihood.NEGATIVE,  # 'é'
        29: SequenceLikelihood.NEGATIVE,  # 'í'
        24: SequenceLikelihood.NEGATIVE,  # 'ó'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        32: SequenceLikelihood.NEGATIVE,  # 'ú'
        30: SequenceLikelihood.NEGATIVE,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.NEGATIVE,  # 'ő'
        70: SequenceLikelihood.UNLIKELY,  # 'Ű'
        36: SequenceLikelihood.NEGATIVE,  # 'ű'
    },
    36: {  # 'ű'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        47: SequenceLikelihood.UNLIKELY,  # 'C'
        49: SequenceLikelihood.NEGATIVE,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        45: SequenceLikelihood.UNLIKELY,  # 'F'
        51: SequenceLikelihood.UNLIKELY,  # 'G'
        42: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        54: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        46: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        52: SequenceLikelihood.UNLIKELY,  # 'O'
        44: SequenceLikelihood.UNLIKELY,  # 'P'
        69: SequenceLikelihood.NEGATIVE,  # 'Q'
        50: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        57: SequenceLikelihood.UNLIKELY,  # 'U'
        48: SequenceLikelihood.UNLIKELY,  # 'V'
        59: SequenceLikelihood.UNLIKELY,  # 'W'
        62: SequenceLikelihood.NEGATIVE,  # 'X'
        61: SequenceLikelihood.NEGATIVE,  # 'Y'
        55: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        28: SequenceLikelihood.UNLIKELY,  # 'c'
        17: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'f'
        14: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        8: SequenceLikelihood.UNLIKELY,  # 'i'
        23: SequenceLikelihood.LIKELY,  # 'j'
        7: SequenceLikelihood.POSITIVE,  # 'k'
        5: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        68: SequenceLikelihood.NEGATIVE,  # 'q'
        9: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'u'
        19: SequenceLikelihood.LIKELY,  # 'v'
        53: SequenceLikelihood.NEGATIVE,  # 'w'
        40: SequenceLikelihood.UNLIKELY,  # 'x'
        16: SequenceLikelihood.NEGATIVE,  # 'y'
        11: SequenceLikelihood.LIKELY,  # 'z'
        58: SequenceLikelihood.UNLIKELY,  # 'Á'
        56: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Í'
        65: SequenceLikelihood.NEGATIVE,  # 'Ó'
        60: SequenceLikelihood.NEGATIVE,  # 'Ö'
        63: SequenceLikelihood.UNLIKELY,  # 'Ú'
        67: SequenceLikelihood.UNLIKELY,  # 'Ü'
        12: SequenceLikelihood.UNLIKELY,  # 'á'
        13: SequenceLikelihood.UNLIKELY,  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'í'
        24: SequenceLikelihood.UNLIKELY,  # 'ó'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        32: SequenceLikelihood.UNLIKELY,  # 'ú'
        30: SequenceLikelihood.UNLIKELY,  # 'ü'
        66: SequenceLikelihood.NEGATIVE,  # 'Ő'
        27: SequenceLikelihood.UNLIKELY,  # 'ő'
        70: SequenceLikelihood.NEGATIVE,  # 'Ű'
        36: SequenceLikelihood.UNLIKELY,  # 'ű'
    },
}

# Character Mapping Table(s):
CP852_HUNGARIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 39,  # 'B'
    67: 47,  # 'C'
    68: 49,  # 'D'
    69: 34,  # 'E'
    70: 45,  # 'F'
    71: 51,  # 'G'
    72: 42,  # 'H'
    73: 43,  # 'I'
    74: 54,  # 'J'
    75: 37,  # 'K'
    76: 46,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 52,  # 'O'
    80: 44,  # 'P'
    81: 69,  # 'Q'
    82: 50,  # 'R'
    83: 35,  # 'S'
    84: 38,  # 'T'
    85: 57,  # 'U'
    86: 48,  # 'V'
    87: 59,  # 'W'
    88: 62,  # 'X'
    89: 61,  # 'Y'
    90: 55,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 28,  # 'c'
    100: 17,  # 'd'
    101: 1,  # 'e'
    102: 26,  # 'f'
    103: 14,  # 'g'
    104: 20,  # 'h'
    105: 8,  # 'i'
    106: 23,  # 'j'
    107: 7,  # 'k'
    108: 5,  # 'l'
    109: 15,  # 'm'
    110: 6,  # 'n'
    111: 10,  # 'o'
    112: 21,  # 'p'
    113: 68,  # 'q'
    114: 9,  # 'r'
    115: 4,  # 's'
    116: 3,  # 't'
    117: 22,  # 'u'
    118: 19,  # 'v'
    119: 53,  # 'w'
    120: 40,  # 'x'
    121: 16,  # 'y'
    122: 11,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 30,  # 'ü'
    130: 13,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'ů'
    134: 0,  # 'ć'
    135: 0,  # 'ç'
    136: 0,  # 'ł'
    137: 0,  # 'ë'
    138: 66,  # 'Ő'
    139: 27,  # 'ő'
    140: 0,  # 'î'
    141: 0,  # 'Ź'
    142: 0,  # 'Ä'
    143: 0,  # 'Ć'
    144: 56,  # 'É'
    145: 0,  # 'Ĺ'
    146: 0,  # 'ĺ'
    147: 0,  # 'ô'
    148: 25,  # 'ö'
    149: 0,  # 'Ľ'
    150: 0,  # 'ľ'
    151: 0,  # 'Ś'
    152: 0,  # 'ś'
    153: 60,  # 'Ö'
    154: 67,  # 'Ü'
    155: 0,  # 'Ť'
    156: 0,  # 'ť'
    157: 0,  # 'Ł'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'č'
    160: 12,  # 'á'
    161: 29,  # 'í'
    162: 24,  # 'ó'
    163: 32,  # 'ú'
    164: 0,  # 'Ą'
    165: 0,  # 'ą'
    166: 0,  # 'Ž'
    167: 0,  # 'ž'
    168: 0,  # 'Ę'
    169: 0,  # 'ę'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: 0,  # 'ź'
    172: 0,  # 'Č'
    173: 0,  # 'ş'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 58,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'Ě'
    184: 0,  # 'Ş'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 0,  # 'Ż'
    190: 0,  # 'ż'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'Ă'
    199: 0,  # 'ă'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'đ'
    209: 0,  # 'Đ'
    210: 0,  # 'Ď'
    211: 0,  # 'Ë'
    212: 0,  # 'ď'
    213: 0,  # 'Ň'
    214: 64,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'ě'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: 0,  # 'Ţ'
    222: 0,  # 'Ů'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 65,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ń'
    228: 0,  # 'ń'
    229: 0,  # 'ň'
    230: 0,  # 'Š'
    231: 0,  # 'š'
    232: 0,  # 'Ŕ'
    233: 63,  # 'Ú'
    234: 0,  # 'ŕ'
    235: 70,  # 'Ű'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: 0,  # 'ţ'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '˝'
    242: CharacterCategory.SYMBOL,  # '˛'
    243: 0,  # 'ˇ'
    244: CharacterCategory.SYMBOL,  # '˘'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: 36,  # 'ű'
    252: 0,  # 'Ř'
    253: 0,  # 'ř'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP852_HUNGARIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP852",
    language="Hungarian",
    char_to_order_map=CP852_HUNGARIAN_CHAR_TO_ORDER,
    language_model=HUNGARIAN_LANG_MODEL,
    typical_positive_ratio=0.9477402550819032,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÖÚÜáéíóöúüŐőŰű",
)

ISO_8859_2_HUNGARIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 39,  # 'B'
    67: 47,  # 'C'
    68: 49,  # 'D'
    69: 34,  # 'E'
    70: 45,  # 'F'
    71: 51,  # 'G'
    72: 42,  # 'H'
    73: 43,  # 'I'
    74: 54,  # 'J'
    75: 37,  # 'K'
    76: 46,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 52,  # 'O'
    80: 44,  # 'P'
    81: 69,  # 'Q'
    82: 50,  # 'R'
    83: 35,  # 'S'
    84: 38,  # 'T'
    85: 57,  # 'U'
    86: 48,  # 'V'
    87: 59,  # 'W'
    88: 62,  # 'X'
    89: 61,  # 'Y'
    90: 55,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 28,  # 'c'
    100: 17,  # 'd'
    101: 1,  # 'e'
    102: 26,  # 'f'
    103: 14,  # 'g'
    104: 20,  # 'h'
    105: 8,  # 'i'
    106: 23,  # 'j'
    107: 7,  # 'k'
    108: 5,  # 'l'
    109: 15,  # 'm'
    110: 6,  # 'n'
    111: 10,  # 'o'
    112: 21,  # 'p'
    113: 68,  # 'q'
    114: 9,  # 'r'
    115: 4,  # 's'
    116: 3,  # 't'
    117: 22,  # 'u'
    118: 19,  # 'v'
    119: 53,  # 'w'
    120: 40,  # 'x'
    121: 16,  # 'y'
    122: 11,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ľ'
    166: 0,  # 'Ś'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: 0,  # 'Š'
    170: 0,  # 'Ş'
    171: 0,  # 'Ť'
    172: 0,  # 'Ź'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'Ž'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 0,  # 'ą'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ł'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'ľ'
    182: 0,  # 'ś'
    183: 0,  # 'ˇ'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 0,  # 'š'
    186: 0,  # 'ş'
    187: 0,  # 'ť'
    188: 0,  # 'ź'
    189: CharacterCategory.SYMBOL,  # '˝'
    190: 0,  # 'ž'
    191: 0,  # 'ż'
    192: 0,  # 'Ŕ'
    193: 58,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ĺ'
    198: 0,  # 'Ć'
    199: 0,  # 'Ç'
    200: 0,  # 'Č'
    201: 56,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ě'
    205: 64,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ď'
    208: 0,  # 'Đ'
    209: 0,  # 'Ń'
    210: 0,  # 'Ň'
    211: 65,  # 'Ó'
    212: 0,  # 'Ô'
    213: 66,  # 'Ő'
    214: 60,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ř'
    217: 0,  # 'Ů'
    218: 63,  # 'Ú'
    219: 70,  # 'Ű'
    220: 67,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Ţ'
    223: 0,  # 'ß'
    224: 0,  # 'ŕ'
    225: 12,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ĺ'
    230: 0,  # 'ć'
    231: 0,  # 'ç'
    232: 0,  # 'č'
    233: 13,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ě'
    237: 29,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ď'
    240: 0,  # 'đ'
    241: 0,  # 'ń'
    242: 0,  # 'ň'
    243: 24,  # 'ó'
    244: 0,  # 'ô'
    245: 27,  # 'ő'
    246: 25,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ř'
    249: 0,  # 'ů'
    250: 32,  # 'ú'
    251: 36,  # 'ű'
    252: 30,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'ţ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

ISO_8859_2_HUNGARIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-2",
    language="Hungarian",
    char_to_order_map=ISO_8859_2_HUNGARIAN_CHAR_TO_ORDER,
    language_model=HUNGARIAN_LANG_MODEL,
    typical_positive_ratio=0.9477402550819032,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÖÚÜáéíóöúüŐőŰű",
)

ISO_8859_16_HUNGARIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 39,  # 'B'
    67: 47,  # 'C'
    68: 49,  # 'D'
    69: 34,  # 'E'
    70: 45,  # 'F'
    71: 51,  # 'G'
    72: 42,  # 'H'
    73: 43,  # 'I'
    74: 54,  # 'J'
    75: 37,  # 'K'
    76: 46,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 52,  # 'O'
    80: 44,  # 'P'
    81: 69,  # 'Q'
    82: 50,  # 'R'
    83: 35,  # 'S'
    84: 38,  # 'T'
    85: 57,  # 'U'
    86: 48,  # 'V'
    87: 59,  # 'W'
    88: 62,  # 'X'
    89: 61,  # 'Y'
    90: 55,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 28,  # 'c'
    100: 17,  # 'd'
    101: 1,  # 'e'
    102: 26,  # 'f'
    103: 14,  # 'g'
    104: 20,  # 'h'
    105: 8,  # 'i'
    106: 23,  # 'j'
    107: 7,  # 'k'
    108: 5,  # 'l'
    109: 15,  # 'm'
    110: 6,  # 'n'
    111: 10,  # 'o'
    112: 21,  # 'p'
    113: 68,  # 'q'
    114: 9,  # 'r'
    115: 4,  # 's'
    116: 3,  # 't'
    117: 22,  # 'u'
    118: 19,  # 'v'
    119: 53,  # 'w'
    120: 40,  # 'x'
    121: 16,  # 'y'
    122: 11,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: 0,  # 'ą'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '„'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ș'
    171: CharacterCategory.SYMBOL,  # '«'
    172: 0,  # 'Ź'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'ź'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 0,  # 'Č'
    179: 0,  # 'ł'
    180: 0,  # 'Ž'
    181: CharacterCategory.SYMBOL,  # '”'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: 0,  # 'č'
    186: 0,  # 'ș'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: 0,  # 'ż'
    192: 0,  # 'À'
    193: 58,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ć'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 56,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 64,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Đ'
    209: 0,  # 'Ń'
    210: 0,  # 'Ò'
    211: 65,  # 'Ó'
    212: 0,  # 'Ô'
    213: 66,  # 'Ő'
    214: 60,  # 'Ö'
    215: 0,  # 'Ś'
    216: 70,  # 'Ű'
    217: 0,  # 'Ù'
    218: 63,  # 'Ú'
    219: 0,  # 'Û'
    220: 67,  # 'Ü'
    221: 0,  # 'Ę'
    222: 0,  # 'Ț'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 12,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ć'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 13,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 29,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'đ'
    241: 0,  # 'ń'
    242: 0,  # 'ò'
    243: 24,  # 'ó'
    244: 0,  # 'ô'
    245: 27,  # 'ő'
    246: 25,  # 'ö'
    247: 0,  # 'ś'
    248: 36,  # 'ű'
    249: 0,  # 'ù'
    250: 32,  # 'ú'
    251: 0,  # 'û'
    252: 30,  # 'ü'
    253: 0,  # 'ę'
    254: 0,  # 'ț'
    255: 0,  # 'ÿ'
}

ISO_8859_16_HUNGARIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-16",
    language="Hungarian",
    char_to_order_map=ISO_8859_16_HUNGARIAN_CHAR_TO_ORDER,
    language_model=HUNGARIAN_LANG_MODEL,
    typical_positive_ratio=0.9477402550819032,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÖÚÜáéíóöúüŐőŰű",
)

MACLATIN2_HUNGARIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 39,  # 'B'
    67: 47,  # 'C'
    68: 49,  # 'D'
    69: 34,  # 'E'
    70: 45,  # 'F'
    71: 51,  # 'G'
    72: 42,  # 'H'
    73: 43,  # 'I'
    74: 54,  # 'J'
    75: 37,  # 'K'
    76: 46,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 52,  # 'O'
    80: 44,  # 'P'
    81: 69,  # 'Q'
    82: 50,  # 'R'
    83: 35,  # 'S'
    84: 38,  # 'T'
    85: 57,  # 'U'
    86: 48,  # 'V'
    87: 59,  # 'W'
    88: 62,  # 'X'
    89: 61,  # 'Y'
    90: 55,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 28,  # 'c'
    100: 17,  # 'd'
    101: 1,  # 'e'
    102: 26,  # 'f'
    103: 14,  # 'g'
    104: 20,  # 'h'
    105: 8,  # 'i'
    106: 23,  # 'j'
    107: 7,  # 'k'
    108: 5,  # 'l'
    109: 15,  # 'm'
    110: 6,  # 'n'
    111: 10,  # 'o'
    112: 21,  # 'p'
    113: 68,  # 'q'
    114: 9,  # 'r'
    115: 4,  # 's'
    116: 3,  # 't'
    117: 22,  # 'u'
    118: 19,  # 'v'
    119: 53,  # 'w'
    120: 40,  # 'x'
    121: 16,  # 'y'
    122: 11,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Ā'
    130: 0,  # 'ā'
    131: 56,  # 'É'
    132: 0,  # 'Ą'
    133: 60,  # 'Ö'
    134: 67,  # 'Ü'
    135: 12,  # 'á'
    136: 0,  # 'ą'
    137: 0,  # 'Č'
    138: 0,  # 'ä'
    139: 0,  # 'č'
    140: 0,  # 'Ć'
    141: 0,  # 'ć'
    142: 13,  # 'é'
    143: 0,  # 'Ź'
    144: 0,  # 'ź'
    145: 0,  # 'Ď'
    146: 29,  # 'í'
    147: 0,  # 'ď'
    148: 0,  # 'Ē'
    149: 0,  # 'ē'
    150: 0,  # 'Ė'
    151: 24,  # 'ó'
    152: 0,  # 'ė'
    153: 0,  # 'ô'
    154: 25,  # 'ö'
    155: 0,  # 'õ'
    156: 32,  # 'ú'
    157: 0,  # 'Ě'
    158: 0,  # 'ě'
    159: 30,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: 0,  # 'Ę'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: 0,  # 'ę'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'ģ'
    175: 0,  # 'Į'
    176: 0,  # 'į'
    177: 0,  # 'Ī'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: 0,  # 'ī'
    181: 0,  # 'Ķ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: 0,  # 'ł'
    185: 0,  # 'Ļ'
    186: 0,  # 'ļ'
    187: 0,  # 'Ľ'
    188: 0,  # 'ľ'
    189: 0,  # 'Ĺ'
    190: 0,  # 'ĺ'
    191: 0,  # 'Ņ'
    192: 0,  # 'ņ'
    193: 0,  # 'Ń'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ń'
    197: 0,  # 'Ň'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'ň'
    204: 66,  # 'Ő'
    205: 0,  # 'Õ'
    206: 27,  # 'ő'
    207: 0,  # 'Ō'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ō'
    217: 0,  # 'Ŕ'
    218: 0,  # 'ŕ'
    219: 0,  # 'Ř'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ř'
    223: 0,  # 'Ŗ'
    224: 0,  # 'ŗ'
    225: 0,  # 'Š'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: 0,  # 'š'
    229: 0,  # 'Ś'
    230: 0,  # 'ś'
    231: 58,  # 'Á'
    232: 0,  # 'Ť'
    233: 0,  # 'ť'
    234: 64,  # 'Í'
    235: 0,  # 'Ž'
    236: 0,  # 'ž'
    237: 0,  # 'Ū'
    238: 65,  # 'Ó'
    239: 0,  # 'Ô'
    240: 0,  # 'ū'
    241: 0,  # 'Ů'
    242: 63,  # 'Ú'
    243: 0,  # 'ů'
    244: 70,  # 'Ű'
    245: 36,  # 'ű'
    246: 0,  # 'Ų'
    247: 0,  # 'ų'
    248: 0,  # 'Ý'
    249: 0,  # 'ý'
    250: 0,  # 'ķ'
    251: 0,  # 'Ż'
    252: 0,  # 'Ł'
    253: 0,  # 'ż'
    254: 0,  # 'Ģ'
    255: 0,  # 'ˇ'
}

MACLATIN2_HUNGARIAN_MODEL = SingleByteCharSetModel(
    charset_name="MacLatin2",
    language="Hungarian",
    char_to_order_map=MACLATIN2_HUNGARIAN_CHAR_TO_ORDER,
    language_model=HUNGARIAN_LANG_MODEL,
    typical_positive_ratio=0.9477402550819032,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÖÚÜáéíóöúüŐőŰű",
)

WINDOWS_1250_HUNGARIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 39,  # 'B'
    67: 47,  # 'C'
    68: 49,  # 'D'
    69: 34,  # 'E'
    70: 45,  # 'F'
    71: 51,  # 'G'
    72: 42,  # 'H'
    73: 43,  # 'I'
    74: 54,  # 'J'
    75: 37,  # 'K'
    76: 46,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 52,  # 'O'
    80: 44,  # 'P'
    81: 69,  # 'Q'
    82: 50,  # 'R'
    83: 35,  # 'S'
    84: 38,  # 'T'
    85: 57,  # 'U'
    86: 48,  # 'V'
    87: 59,  # 'W'
    88: 62,  # 'X'
    89: 61,  # 'Y'
    90: 55,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 28,  # 'c'
    100: 17,  # 'd'
    101: 1,  # 'e'
    102: 26,  # 'f'
    103: 14,  # 'g'
    104: 20,  # 'h'
    105: 8,  # 'i'
    106: 23,  # 'j'
    107: 7,  # 'k'
    108: 5,  # 'l'
    109: 15,  # 'm'
    110: 6,  # 'n'
    111: 10,  # 'o'
    112: 21,  # 'p'
    113: 68,  # 'q'
    114: 9,  # 'r'
    115: 4,  # 's'
    116: 3,  # 't'
    117: 22,  # 'u'
    118: 19,  # 'v'
    119: 53,  # 'w'
    120: 40,  # 'x'
    121: 16,  # 'y'
    122: 11,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: CharacterCategory.UNDEFINED,  # None
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.UNDEFINED,  # None
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Ś'
    141: 0,  # 'Ť'
    142: 0,  # 'Ž'
    143: 0,  # 'Ź'
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'ś'
    157: 0,  # 'ť'
    158: 0,  # 'ž'
    159: 0,  # 'ź'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'ˇ'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ą'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ş'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ł'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 0,  # 'ą'
    186: 0,  # 'ş'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Ľ'
    189: CharacterCategory.SYMBOL,  # '˝'
    190: 0,  # 'ľ'
    191: 0,  # 'ż'
    192: 0,  # 'Ŕ'
    193: 58,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ĺ'
    198: 0,  # 'Ć'
    199: 0,  # 'Ç'
    200: 0,  # 'Č'
    201: 56,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ě'
    205: 64,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ď'
    208: 0,  # 'Đ'
    209: 0,  # 'Ń'
    210: 0,  # 'Ň'
    211: 65,  # 'Ó'
    212: 0,  # 'Ô'
    213: 66,  # 'Ő'
    214: 60,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ř'
    217: 0,  # 'Ů'
    218: 63,  # 'Ú'
    219: 70,  # 'Ű'
    220: 67,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Ţ'
    223: 0,  # 'ß'
    224: 0,  # 'ŕ'
    225: 12,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ĺ'
    230: 0,  # 'ć'
    231: 0,  # 'ç'
    232: 0,  # 'č'
    233: 13,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ě'
    237: 29,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ď'
    240: 0,  # 'đ'
    241: 0,  # 'ń'
    242: 0,  # 'ň'
    243: 24,  # 'ó'
    244: 0,  # 'ô'
    245: 27,  # 'ő'
    246: 25,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ř'
    249: 0,  # 'ů'
    250: 32,  # 'ú'
    251: 36,  # 'ű'
    252: 30,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'ţ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

WINDOWS_1250_HUNGARIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1250",
    language="Hungarian",
    char_to_order_map=WINDOWS_1250_HUNGARIAN_CHAR_TO_ORDER,
    language_model=HUNGARIAN_LANG_MODEL,
    typical_positive_ratio=0.9477402550819032,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÉÍÓÖÚÜáéíóöúüŐőŰű",
)
