from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

KAZAKH_LANG_MODEL = {
    83: {  # 'Ё'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.NEGATIVE,  # 'А'
        33: SequenceLikelihood.NEGATIVE,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.NEGATIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.NEGATIVE,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.NEGATIVE,  # 'д'
        2: SequenceLikelihood.NEGATIVE,  # 'е'
        19: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.NEGATIVE,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.NEGATIVE,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.NEGATIVE,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.NEGATIVE,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.NEGATIVE,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.NEGATIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    56: {  # 'І'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.LIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.LIKELY,  # 'К'
        57: SequenceLikelihood.LIKELY,  # 'Л'
        38: SequenceLikelihood.LIKELY,  # 'М'
        47: SequenceLikelihood.LIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.NEGATIVE,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.LIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    31: {  # 'А'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.LIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.LIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.LIKELY,  # 'Л'
        38: SequenceLikelihood.LIKELY,  # 'М'
        47: SequenceLikelihood.LIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.LIKELY,  # 'Р'
        36: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        65: SequenceLikelihood.LIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.LIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.LIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.LIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.LIKELY,  # 'Ғ'
        20: SequenceLikelihood.LIKELY,  # 'ғ'
        34: SequenceLikelihood.POSITIVE,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    33: {  # 'Б'
        83: SequenceLikelihood.UNLIKELY,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.LIKELY,  # 'ү'
        58: SequenceLikelihood.LIKELY,  # 'Ұ'
        26: SequenceLikelihood.POSITIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.LIKELY,  # 'ө'
    },
    63: {  # 'В'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    59: {  # 'Г'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.LIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    48: {  # 'Д'
        83: SequenceLikelihood.UNLIKELY,  # 'Ё'
        56: SequenceLikelihood.LIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.LIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.NEGATIVE,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.LIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.LIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    44: {  # 'Е'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.LIKELY,  # 'К'
        57: SequenceLikelihood.LIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.LIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.LIKELY,  # 'Р'
        36: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.LIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.NEGATIVE,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.LIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    43: {  # 'Ж'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.LIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.LIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.LIKELY,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.LIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.LIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.LIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    64: {  # 'З'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.NEGATIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    54: {  # 'И'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    74: {  # 'Й'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.NEGATIVE,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.NEGATIVE,  # 'м'
        4: SequenceLikelihood.NEGATIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    41: {  # 'К'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.LIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.LIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.LIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.POSITIVE,  # 'ө'
    },
    57: {  # 'Л'
        83: SequenceLikelihood.UNLIKELY,  # 'Ё'
        56: SequenceLikelihood.LIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.LIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.LIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.NEGATIVE,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.NEGATIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    38: {  # 'М'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.LIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.LIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.LIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.LIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.POSITIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.POSITIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    47: {  # 'Н'
        83: SequenceLikelihood.UNLIKELY,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.LIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.LIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.POSITIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    37: {  # 'О'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.LIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.LIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.LIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.LIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.NEGATIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.LIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.LIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.LIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    50: {  # 'П'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.NEGATIVE,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.LIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    46: {  # 'Р'
        83: SequenceLikelihood.UNLIKELY,  # 'Ё'
        56: SequenceLikelihood.LIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.LIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.LIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    36: {  # 'С'
        83: SequenceLikelihood.UNLIKELY,  # 'Ё'
        56: SequenceLikelihood.LIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.LIKELY,  # 'П'
        46: SequenceLikelihood.LIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.LIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.LIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.LIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.LIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.LIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.LIKELY,  # 'ө'
    },
    39: {  # 'Т'
        83: SequenceLikelihood.UNLIKELY,  # 'Ё'
        56: SequenceLikelihood.LIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.LIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.LIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.LIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.LIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.POSITIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.LIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.LIKELY,  # 'ө'
    },
    65: {  # 'У'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    66: {  # 'Ф'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.NEGATIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    61: {  # 'Х'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.NEGATIVE,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.NEGATIVE,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    77: {  # 'Ц'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.NEGATIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.NEGATIVE,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.NEGATIVE,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.NEGATIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    76: {  # 'Ч'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.NEGATIVE,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.NEGATIVE,  # 'г'
        9: SequenceLikelihood.NEGATIVE,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    52: {  # 'Ш'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.NEGATIVE,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    81: {  # 'Щ'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.NEGATIVE,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.NEGATIVE,  # 'г'
        9: SequenceLikelihood.NEGATIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.NEGATIVE,  # 'л'
        11: SequenceLikelihood.NEGATIVE,  # 'м'
        4: SequenceLikelihood.NEGATIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.NEGATIVE,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.NEGATIVE,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.NEGATIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    84: {  # 'Ъ'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.NEGATIVE,  # 'А'
        33: SequenceLikelihood.NEGATIVE,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.NEGATIVE,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.NEGATIVE,  # 'б'
        32: SequenceLikelihood.NEGATIVE,  # 'в'
        25: SequenceLikelihood.NEGATIVE,  # 'г'
        9: SequenceLikelihood.NEGATIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.NEGATIVE,  # 'м'
        4: SequenceLikelihood.NEGATIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.NEGATIVE,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.NEGATIVE,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.NEGATIVE,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.NEGATIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    62: {  # 'Ы'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.LIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.LIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.NEGATIVE,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.NEGATIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.NEGATIVE,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.LIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.LIKELY,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    80: {  # 'Ь'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.NEGATIVE,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.NEGATIVE,  # 'б'
        32: SequenceLikelihood.NEGATIVE,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.NEGATIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.NEGATIVE,  # 'л'
        11: SequenceLikelihood.NEGATIVE,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.NEGATIVE,  # 'т'
        16: SequenceLikelihood.NEGATIVE,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.NEGATIVE,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.NEGATIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    68: {  # 'Э'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.NEGATIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.NEGATIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    78: {  # 'Ю'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.NEGATIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.NEGATIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.NEGATIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    71: {  # 'Я'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.NEGATIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.LIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    1: {  # 'а'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.POSITIVE,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.POSITIVE,  # 'ф'
        35: SequenceLikelihood.POSITIVE,  # 'х'
        40: SequenceLikelihood.POSITIVE,  # 'ц'
        60: SequenceLikelihood.LIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.LIKELY,  # 'ю'
        30: SequenceLikelihood.POSITIVE,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.POSITIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.LIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    15: {  # 'б'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.LIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.LIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.POSITIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.POSITIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.POSITIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.POSITIVE,  # 'ө'
    },
    32: {  # 'в'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.LIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    25: {  # 'г'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.LIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.LIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.LIKELY,  # 'ө'
    },
    9: {  # 'д'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.LIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.POSITIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.LIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.POSITIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.LIKELY,  # 'ө'
    },
    2: {  # 'е'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.POSITIVE,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.LIKELY,  # 'ф'
        35: SequenceLikelihood.POSITIVE,  # 'х'
        40: SequenceLikelihood.LIKELY,  # 'ц'
        60: SequenceLikelihood.LIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.LIKELY,  # 'ю'
        30: SequenceLikelihood.LIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.LIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.LIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.POSITIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    19: {  # 'ж'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.POSITIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.POSITIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.POSITIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.POSITIVE,  # 'ө'
    },
    18: {  # 'з'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.LIKELY,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.LIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.LIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    17: {  # 'и'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.POSITIVE,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.POSITIVE,  # 'ф'
        35: SequenceLikelihood.POSITIVE,  # 'х'
        40: SequenceLikelihood.POSITIVE,  # 'ц'
        60: SequenceLikelihood.LIKELY,  # 'ч'
        24: SequenceLikelihood.LIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.LIKELY,  # 'ю'
        30: SequenceLikelihood.POSITIVE,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.LIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    21: {  # 'й'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.LIKELY,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.LIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.LIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    13: {  # 'к'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.LIKELY,  # 'в'
        25: SequenceLikelihood.LIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.POSITIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.LIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.POSITIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.LIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.POSITIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.POSITIVE,  # 'ө'
    },
    8: {  # 'л'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.POSITIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.LIKELY,  # 'ю'
        30: SequenceLikelihood.LIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    11: {  # 'м'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.LIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.LIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.LIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.POSITIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.POSITIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.POSITIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.LIKELY,  # 'ө'
    },
    4: {  # 'н'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.LIKELY,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.POSITIVE,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.POSITIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.LIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.LIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.LIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.LIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.POSITIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.POSITIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.LIKELY,  # 'ө'
    },
    14: {  # 'о'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.POSITIVE,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.POSITIVE,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.POSITIVE,  # 'ц'
        60: SequenceLikelihood.LIKELY,  # 'ч'
        24: SequenceLikelihood.LIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.LIKELY,  # 'э'
        53: SequenceLikelihood.LIKELY,  # 'ю'
        30: SequenceLikelihood.LIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.POSITIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    22: {  # 'п'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.LIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.LIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    6: {  # 'р'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.LIKELY,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.LIKELY,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.LIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.LIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.LIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.LIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.LIKELY,  # 'ө'
    },
    10: {  # 'с'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.LIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.LIKELY,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.LIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.LIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.LIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.POSITIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.POSITIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.POSITIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.POSITIVE,  # 'ө'
    },
    5: {  # 'т'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.LIKELY,  # 'в'
        25: SequenceLikelihood.LIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.LIKELY,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.LIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.LIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.POSITIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.POSITIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.POSITIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.POSITIVE,  # 'ө'
    },
    16: {  # 'у'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.POSITIVE,  # 'х'
        40: SequenceLikelihood.LIKELY,  # 'ц'
        60: SequenceLikelihood.LIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.LIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    42: {  # 'ф'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.LIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    35: {  # 'х'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.LIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    40: {  # 'ц'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.NEGATIVE,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    60: {  # 'ч'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.NEGATIVE,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    24: {  # 'ш'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.LIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.LIKELY,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.LIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.LIKELY,  # 'ө'
    },
    73: {  # 'щ'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.NEGATIVE,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.NEGATIVE,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    72: {  # 'ъ'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.NEGATIVE,  # 'А'
        33: SequenceLikelihood.NEGATIVE,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.NEGATIVE,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    3: {  # 'ы'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.UNLIKELY,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.POSITIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    45: {  # 'ь'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.LIKELY,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.LIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.LIKELY,  # 'ю'
        30: SequenceLikelihood.LIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    49: {  # 'э'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.NEGATIVE,  # 'А'
        33: SequenceLikelihood.NEGATIVE,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.NEGATIVE,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.LIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    53: {  # 'ю'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.NEGATIVE,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.LIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.LIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.LIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    30: {  # 'я'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.LIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    79: {  # 'ё'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.NEGATIVE,  # 'А'
        33: SequenceLikelihood.NEGATIVE,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.NEGATIVE,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.NEGATIVE,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.NEGATIVE,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.NEGATIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    7: {  # 'і'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.UNLIKELY,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.POSITIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    69: {  # 'Ғ'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.LIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.NEGATIVE,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.NEGATIVE,  # 'л'
        11: SequenceLikelihood.NEGATIVE,  # 'м'
        4: SequenceLikelihood.NEGATIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.NEGATIVE,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.LIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.NEGATIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.NEGATIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    20: {  # 'ғ'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.LIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.LIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    34: {  # 'Қ'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.LIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.LIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.LIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.LIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.LIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.LIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.NEGATIVE,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.LIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.POSITIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    12: {  # 'қ'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.LIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.POSITIVE,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.POSITIVE,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.POSITIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    75: {  # 'Ң'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.NEGATIVE,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.NEGATIVE,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.NEGATIVE,  # 'м'
        4: SequenceLikelihood.NEGATIVE,  # 'н'
        14: SequenceLikelihood.NEGATIVE,  # 'о'
        22: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.NEGATIVE,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    23: {  # 'ң'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.LIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.POSITIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.UNLIKELY,  # 'ё'
        7: SequenceLikelihood.POSITIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.LIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    67: {  # 'Ү'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.NEGATIVE,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.LIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.LIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.NEGATIVE,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    29: {  # 'ү'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.NEGATIVE,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.POSITIVE,  # 'г'
        9: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.LIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    58: {  # 'Ұ'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.LIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.UNLIKELY,  # 'Ю'
        71: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.NEGATIVE,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.NEGATIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.LIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.NEGATIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    26: {  # 'ұ'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.NEGATIVE,  # 'А'
        33: SequenceLikelihood.NEGATIVE,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.NEGATIVE,  # 'е'
        19: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.LIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.LIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.POSITIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.POSITIVE,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.LIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    82: {  # 'Һ'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.NEGATIVE,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.NEGATIVE,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.NEGATIVE,  # 'б'
        32: SequenceLikelihood.NEGATIVE,  # 'в'
        25: SequenceLikelihood.NEGATIVE,  # 'г'
        9: SequenceLikelihood.NEGATIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.NEGATIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.NEGATIVE,  # 'н'
        14: SequenceLikelihood.NEGATIVE,  # 'о'
        22: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.NEGATIVE,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.NEGATIVE,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.NEGATIVE,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.NEGATIVE,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.NEGATIVE,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    70: {  # 'һ'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.NEGATIVE,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.NEGATIVE,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.NEGATIVE,  # 'Р'
        36: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.NEGATIVE,  # 'ж'
        18: SequenceLikelihood.UNLIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        8: SequenceLikelihood.UNLIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.UNLIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    51: {  # 'Ә'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.UNLIKELY,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.NEGATIVE,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.LIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.UNLIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        16: SequenceLikelihood.LIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.NEGATIVE,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.NEGATIVE,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.UNLIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.NEGATIVE,  # 'ө'
    },
    28: {  # 'ә'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.NEGATIVE,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.NEGATIVE,  # 'Ж'
        64: SequenceLikelihood.NEGATIVE,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.NEGATIVE,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.LIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.POSITIVE,  # 'ж'
        18: SequenceLikelihood.LIKELY,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.POSITIVE,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.LIKELY,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.UNLIKELY,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ң'
        23: SequenceLikelihood.LIKELY,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.UNLIKELY,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.NEGATIVE,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    55: {  # 'Ө'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.UNLIKELY,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.UNLIKELY,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Г'
        48: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.UNLIKELY,  # 'И'
        74: SequenceLikelihood.UNLIKELY,  # 'Й'
        41: SequenceLikelihood.UNLIKELY,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.UNLIKELY,  # 'М'
        47: SequenceLikelihood.UNLIKELY,  # 'Н'
        37: SequenceLikelihood.UNLIKELY,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'У'
        66: SequenceLikelihood.UNLIKELY,  # 'Ф'
        61: SequenceLikelihood.UNLIKELY,  # 'Х'
        77: SequenceLikelihood.UNLIKELY,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.UNLIKELY,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.UNLIKELY,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.UNLIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.NEGATIVE,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.LIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        8: SequenceLikelihood.LIKELY,  # 'л'
        11: SequenceLikelihood.LIKELY,  # 'м'
        4: SequenceLikelihood.LIKELY,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.NEGATIVE,  # 'ф'
        35: SequenceLikelihood.NEGATIVE,  # 'х'
        40: SequenceLikelihood.NEGATIVE,  # 'ц'
        60: SequenceLikelihood.NEGATIVE,  # 'ч'
        24: SequenceLikelihood.UNLIKELY,  # 'ш'
        73: SequenceLikelihood.NEGATIVE,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.NEGATIVE,  # 'ы'
        45: SequenceLikelihood.NEGATIVE,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.NEGATIVE,  # 'ю'
        30: SequenceLikelihood.NEGATIVE,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.NEGATIVE,  # 'і'
        69: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        20: SequenceLikelihood.NEGATIVE,  # 'ғ'
        34: SequenceLikelihood.UNLIKELY,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.LIKELY,  # 'ң'
        67: SequenceLikelihood.UNLIKELY,  # 'Ү'
        29: SequenceLikelihood.NEGATIVE,  # 'ү'
        58: SequenceLikelihood.UNLIKELY,  # 'Ұ'
        26: SequenceLikelihood.NEGATIVE,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.UNLIKELY,  # 'Ә'
        28: SequenceLikelihood.NEGATIVE,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
    27: {  # 'ө'
        83: SequenceLikelihood.NEGATIVE,  # 'Ё'
        56: SequenceLikelihood.NEGATIVE,  # 'І'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        33: SequenceLikelihood.NEGATIVE,  # 'Б'
        63: SequenceLikelihood.NEGATIVE,  # 'В'
        59: SequenceLikelihood.NEGATIVE,  # 'Г'
        48: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        43: SequenceLikelihood.UNLIKELY,  # 'Ж'
        64: SequenceLikelihood.UNLIKELY,  # 'З'
        54: SequenceLikelihood.NEGATIVE,  # 'И'
        74: SequenceLikelihood.NEGATIVE,  # 'Й'
        41: SequenceLikelihood.NEGATIVE,  # 'К'
        57: SequenceLikelihood.UNLIKELY,  # 'Л'
        38: SequenceLikelihood.NEGATIVE,  # 'М'
        47: SequenceLikelihood.NEGATIVE,  # 'Н'
        37: SequenceLikelihood.NEGATIVE,  # 'О'
        50: SequenceLikelihood.UNLIKELY,  # 'П'
        46: SequenceLikelihood.UNLIKELY,  # 'Р'
        36: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        65: SequenceLikelihood.NEGATIVE,  # 'У'
        66: SequenceLikelihood.NEGATIVE,  # 'Ф'
        61: SequenceLikelihood.NEGATIVE,  # 'Х'
        77: SequenceLikelihood.NEGATIVE,  # 'Ц'
        76: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        81: SequenceLikelihood.NEGATIVE,  # 'Щ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        80: SequenceLikelihood.NEGATIVE,  # 'Ь'
        68: SequenceLikelihood.NEGATIVE,  # 'Э'
        78: SequenceLikelihood.NEGATIVE,  # 'Ю'
        71: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        15: SequenceLikelihood.POSITIVE,  # 'б'
        32: SequenceLikelihood.UNLIKELY,  # 'в'
        25: SequenceLikelihood.LIKELY,  # 'г'
        9: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        19: SequenceLikelihood.UNLIKELY,  # 'ж'
        18: SequenceLikelihood.POSITIVE,  # 'з'
        17: SequenceLikelihood.UNLIKELY,  # 'и'
        21: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        8: SequenceLikelihood.POSITIVE,  # 'л'
        11: SequenceLikelihood.POSITIVE,  # 'м'
        4: SequenceLikelihood.POSITIVE,  # 'н'
        14: SequenceLikelihood.UNLIKELY,  # 'о'
        22: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        16: SequenceLikelihood.UNLIKELY,  # 'у'
        42: SequenceLikelihood.UNLIKELY,  # 'ф'
        35: SequenceLikelihood.UNLIKELY,  # 'х'
        40: SequenceLikelihood.UNLIKELY,  # 'ц'
        60: SequenceLikelihood.UNLIKELY,  # 'ч'
        24: SequenceLikelihood.POSITIVE,  # 'ш'
        73: SequenceLikelihood.UNLIKELY,  # 'щ'
        72: SequenceLikelihood.NEGATIVE,  # 'ъ'
        3: SequenceLikelihood.UNLIKELY,  # 'ы'
        45: SequenceLikelihood.UNLIKELY,  # 'ь'
        49: SequenceLikelihood.UNLIKELY,  # 'э'
        53: SequenceLikelihood.UNLIKELY,  # 'ю'
        30: SequenceLikelihood.UNLIKELY,  # 'я'
        79: SequenceLikelihood.NEGATIVE,  # 'ё'
        7: SequenceLikelihood.UNLIKELY,  # 'і'
        69: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        20: SequenceLikelihood.UNLIKELY,  # 'ғ'
        34: SequenceLikelihood.NEGATIVE,  # 'Қ'
        12: SequenceLikelihood.UNLIKELY,  # 'қ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ң'
        23: SequenceLikelihood.POSITIVE,  # 'ң'
        67: SequenceLikelihood.NEGATIVE,  # 'Ү'
        29: SequenceLikelihood.UNLIKELY,  # 'ү'
        58: SequenceLikelihood.NEGATIVE,  # 'Ұ'
        26: SequenceLikelihood.UNLIKELY,  # 'ұ'
        82: SequenceLikelihood.NEGATIVE,  # 'Һ'
        70: SequenceLikelihood.UNLIKELY,  # 'һ'
        51: SequenceLikelihood.NEGATIVE,  # 'Ә'
        28: SequenceLikelihood.UNLIKELY,  # 'ә'
        55: SequenceLikelihood.UNLIKELY,  # 'Ө'
        27: SequenceLikelihood.UNLIKELY,  # 'ө'
    },
}

# Character Mapping Table(s):
KZ1048_KAZAKH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ђ'
    129: 0,  # 'Ѓ'
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ѓ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.SYMBOL,  # '€'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Љ'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Њ'
    141: 34,  # 'Қ'
    142: 82,  # 'Һ'
    143: 0,  # 'Џ'
    144: 0,  # 'ђ'
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'љ'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'њ'
    157: 12,  # 'қ'
    158: 70,  # 'һ'
    159: 0,  # 'џ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 58,  # 'Ұ'
    162: 26,  # 'ұ'
    163: 51,  # 'Ә'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 55,  # 'Ө'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 83,  # 'Ё'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 69,  # 'Ғ'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 67,  # 'Ү'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 56,  # 'І'
    179: 7,  # 'і'
    180: 27,  # 'ө'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 79,  # 'ё'
    185: CharacterCategory.SYMBOL,  # '№'
    186: 20,  # 'ғ'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 28,  # 'ә'
    189: 75,  # 'Ң'
    190: 23,  # 'ң'
    191: 29,  # 'ү'
    192: 31,  # 'А'
    193: 33,  # 'Б'
    194: 63,  # 'В'
    195: 59,  # 'Г'
    196: 48,  # 'Д'
    197: 44,  # 'Е'
    198: 43,  # 'Ж'
    199: 64,  # 'З'
    200: 54,  # 'И'
    201: 74,  # 'Й'
    202: 41,  # 'К'
    203: 57,  # 'Л'
    204: 38,  # 'М'
    205: 47,  # 'Н'
    206: 37,  # 'О'
    207: 50,  # 'П'
    208: 46,  # 'Р'
    209: 36,  # 'С'
    210: 39,  # 'Т'
    211: 65,  # 'У'
    212: 66,  # 'Ф'
    213: 61,  # 'Х'
    214: 77,  # 'Ц'
    215: 76,  # 'Ч'
    216: 52,  # 'Ш'
    217: 81,  # 'Щ'
    218: 84,  # 'Ъ'
    219: 62,  # 'Ы'
    220: 80,  # 'Ь'
    221: 68,  # 'Э'
    222: 78,  # 'Ю'
    223: 71,  # 'Я'
    224: 1,  # 'а'
    225: 15,  # 'б'
    226: 32,  # 'в'
    227: 25,  # 'г'
    228: 9,  # 'д'
    229: 2,  # 'е'
    230: 19,  # 'ж'
    231: 18,  # 'з'
    232: 17,  # 'и'
    233: 21,  # 'й'
    234: 13,  # 'к'
    235: 8,  # 'л'
    236: 11,  # 'м'
    237: 4,  # 'н'
    238: 14,  # 'о'
    239: 22,  # 'п'
    240: 6,  # 'р'
    241: 10,  # 'с'
    242: 5,  # 'т'
    243: 16,  # 'у'
    244: 42,  # 'ф'
    245: 35,  # 'х'
    246: 40,  # 'ц'
    247: 60,  # 'ч'
    248: 24,  # 'ш'
    249: 73,  # 'щ'
    250: 72,  # 'ъ'
    251: 3,  # 'ы'
    252: 45,  # 'ь'
    253: 49,  # 'э'
    254: 53,  # 'ю'
    255: 30,  # 'я'
}

KZ1048_KAZAKH_MODEL = SingleByteCharSetModel(
    charset_name="KZ1048",
    language="Kazakh",
    char_to_order_map=KZ1048_KAZAKH_CHAR_TO_ORDER,
    language_model=KAZAKH_LANG_MODEL,
    typical_positive_ratio=0.9696662785097961,
    keep_ascii_letters=False,
    alphabet="ЁІАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяёіҒғҚқҢңҮүҰұҺһӘәӨө",
)

PTCP154_KAZAKH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Җ'
    129: 69,  # 'Ғ'
    130: 0,  # 'Ӯ'
    131: 20,  # 'ғ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: 0,  # 'Ҷ'
    135: 67,  # 'Ү'
    136: 0,  # 'Ҳ'
    137: 29,  # 'ү'
    138: 0,  # 'Ҡ'
    139: 0,  # 'Ӣ'
    140: 75,  # 'Ң'
    141: 34,  # 'Қ'
    142: 82,  # 'Һ'
    143: 0,  # 'Ҹ'
    144: 0,  # 'җ'
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: 0,  # 'ҳ'
    153: 0,  # 'ҷ'
    154: 0,  # 'ҡ'
    155: 0,  # 'ӣ'
    156: 23,  # 'ң'
    157: 12,  # 'қ'
    158: 70,  # 'һ'
    159: 0,  # 'ҹ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ў'
    162: 0,  # 'ў'
    163: 0,  # 'Ј'
    164: 55,  # 'Ө'
    165: 0,  # 'Ҙ'
    166: 58,  # 'Ұ'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 83,  # 'Ё'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 51,  # 'Ә'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: 0,  # 'ӯ'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ҝ'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 26,  # 'ұ'
    178: 56,  # 'І'
    179: 7,  # 'і'
    180: 0,  # 'ҙ'
    181: 27,  # 'ө'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 79,  # 'ё'
    185: CharacterCategory.SYMBOL,  # '№'
    186: 28,  # 'ә'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'ј'
    189: 0,  # 'Ҫ'
    190: 0,  # 'ҫ'
    191: 0,  # 'ҝ'
    192: 31,  # 'А'
    193: 33,  # 'Б'
    194: 63,  # 'В'
    195: 59,  # 'Г'
    196: 48,  # 'Д'
    197: 44,  # 'Е'
    198: 43,  # 'Ж'
    199: 64,  # 'З'
    200: 54,  # 'И'
    201: 74,  # 'Й'
    202: 41,  # 'К'
    203: 57,  # 'Л'
    204: 38,  # 'М'
    205: 47,  # 'Н'
    206: 37,  # 'О'
    207: 50,  # 'П'
    208: 46,  # 'Р'
    209: 36,  # 'С'
    210: 39,  # 'Т'
    211: 65,  # 'У'
    212: 66,  # 'Ф'
    213: 61,  # 'Х'
    214: 77,  # 'Ц'
    215: 76,  # 'Ч'
    216: 52,  # 'Ш'
    217: 81,  # 'Щ'
    218: 84,  # 'Ъ'
    219: 62,  # 'Ы'
    220: 80,  # 'Ь'
    221: 68,  # 'Э'
    222: 78,  # 'Ю'
    223: 71,  # 'Я'
    224: 1,  # 'а'
    225: 15,  # 'б'
    226: 32,  # 'в'
    227: 25,  # 'г'
    228: 9,  # 'д'
    229: 2,  # 'е'
    230: 19,  # 'ж'
    231: 18,  # 'з'
    232: 17,  # 'и'
    233: 21,  # 'й'
    234: 13,  # 'к'
    235: 8,  # 'л'
    236: 11,  # 'м'
    237: 4,  # 'н'
    238: 14,  # 'о'
    239: 22,  # 'п'
    240: 6,  # 'р'
    241: 10,  # 'с'
    242: 5,  # 'т'
    243: 16,  # 'у'
    244: 42,  # 'ф'
    245: 35,  # 'х'
    246: 40,  # 'ц'
    247: 60,  # 'ч'
    248: 24,  # 'ш'
    249: 73,  # 'щ'
    250: 72,  # 'ъ'
    251: 3,  # 'ы'
    252: 45,  # 'ь'
    253: 49,  # 'э'
    254: 53,  # 'ю'
    255: 30,  # 'я'
}

PTCP154_KAZAKH_MODEL = SingleByteCharSetModel(
    charset_name="PTCP154",
    language="Kazakh",
    char_to_order_map=PTCP154_KAZAKH_CHAR_TO_ORDER,
    language_model=KAZAKH_LANG_MODEL,
    typical_positive_ratio=0.9696662785097961,
    keep_ascii_letters=False,
    alphabet="ЁІАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяёіҒғҚқҢңҮүҰұҺһӘәӨө",
)
