from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

MACEDONIAN_LANG_MODEL = {
    59: {  # 'Ѓ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.NEGATIVE,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.NEGATIVE,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.NEGATIVE,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.NEGATIVE,  # 'С'
        36: SequenceLikelihood.NEGATIVE,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.NEGATIVE,  # 'з'
        3: SequenceLikelihood.UNLIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.NEGATIVE,  # 'л'
        14: SequenceLikelihood.NEGATIVE,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.NEGATIVE,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    62: {  # 'Ѕ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.NEGATIVE,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.NEGATIVE,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.NEGATIVE,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        10: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.UNLIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.NEGATIVE,  # 'л'
        14: SequenceLikelihood.NEGATIVE,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.NEGATIVE,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.NEGATIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.NEGATIVE,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    47: {  # 'Ј'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.POSITIVE,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.NEGATIVE,  # 'з'
        3: SequenceLikelihood.UNLIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.NEGATIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    61: {  # 'Љ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.NEGATIVE,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        10: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.NEGATIVE,  # 'з'
        3: SequenceLikelihood.UNLIKELY,  # 'и'
        11: SequenceLikelihood.NEGATIVE,  # 'к'
        12: SequenceLikelihood.NEGATIVE,  # 'л'
        14: SequenceLikelihood.NEGATIVE,  # 'м'
        6: SequenceLikelihood.NEGATIVE,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.NEGATIVE,  # 'п'
        7: SequenceLikelihood.NEGATIVE,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.NEGATIVE,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.NEGATIVE,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.NEGATIVE,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    60: {  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.NEGATIVE,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.NEGATIVE,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.NEGATIVE,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        10: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.NEGATIVE,  # 'з'
        3: SequenceLikelihood.UNLIKELY,  # 'и'
        11: SequenceLikelihood.NEGATIVE,  # 'к'
        12: SequenceLikelihood.NEGATIVE,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.NEGATIVE,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.NEGATIVE,  # 'п'
        7: SequenceLikelihood.NEGATIVE,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.NEGATIVE,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    57: {  # 'Ќ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.NEGATIVE,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.NEGATIVE,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        25: SequenceLikelihood.NEGATIVE,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.NEGATIVE,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        10: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.UNLIKELY,  # 'и'
        11: SequenceLikelihood.NEGATIVE,  # 'к'
        12: SequenceLikelihood.NEGATIVE,  # 'л'
        14: SequenceLikelihood.NEGATIVE,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.NEGATIVE,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.NEGATIVE,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.NEGATIVE,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    56: {  # 'Џ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.NEGATIVE,  # 'л'
        14: SequenceLikelihood.NEGATIVE,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.NEGATIVE,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.NEGATIVE,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    28: {  # 'А'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.LIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.LIKELY,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.LIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        44: SequenceLikelihood.LIKELY,  # 'Г'
        37: SequenceLikelihood.POSITIVE,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.LIKELY,  # 'Ж'
        43: SequenceLikelihood.LIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.LIKELY,  # 'Л'
        29: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.POSITIVE,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.POSITIVE,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.POSITIVE,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.LIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.LIKELY,  # 'Ч'
        51: SequenceLikelihood.LIKELY,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        10: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.LIKELY,  # 'з'
        3: SequenceLikelihood.UNLIKELY,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.LIKELY,  # 'ф'
        39: SequenceLikelihood.LIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.LIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    41: {  # 'Б'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.LIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.LIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    33: {  # 'В'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.POSITIVE,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.POSITIVE,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.LIKELY,  # 'Л'
        29: SequenceLikelihood.POSITIVE,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        32: SequenceLikelihood.POSITIVE,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    44: {  # 'Г'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.LIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    37: {  # 'Д'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.LIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.LIKELY,  # 'Д'
        38: SequenceLikelihood.POSITIVE,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.POSITIVE,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.POSITIVE,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    38: {  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.LIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.LIKELY,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.LIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        44: SequenceLikelihood.LIKELY,  # 'Г'
        37: SequenceLikelihood.LIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.LIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.LIKELY,  # 'Л'
        29: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.POSITIVE,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.LIKELY,  # 'Т'
        46: SequenceLikelihood.POSITIVE,  # 'У'
        48: SequenceLikelihood.LIKELY,  # 'Ф'
        50: SequenceLikelihood.LIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.LIKELY,  # 'Ч'
        51: SequenceLikelihood.LIKELY,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.LIKELY,  # 'з'
        3: SequenceLikelihood.UNLIKELY,  # 'и'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.LIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    55: {  # 'Ж'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.NEGATIVE,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.NEGATIVE,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.NEGATIVE,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.NEGATIVE,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    43: {  # 'З'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.POSITIVE,  # 'А'
        41: SequenceLikelihood.LIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.LIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        10: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    35: {  # 'И'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.LIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.LIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        44: SequenceLikelihood.LIKELY,  # 'Г'
        37: SequenceLikelihood.POSITIVE,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.LIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.LIKELY,  # 'Л'
        29: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.POSITIVE,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.LIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.LIKELY,  # 'Ч'
        51: SequenceLikelihood.LIKELY,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        10: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.POSITIVE,  # 'з'
        3: SequenceLikelihood.UNLIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    34: {  # 'К'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.POSITIVE,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.LIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.LIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.POSITIVE,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.LIKELY,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    45: {  # 'Л'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.NEGATIVE,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.NEGATIVE,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    29: {  # 'М'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.POSITIVE,  # 'А'
        41: SequenceLikelihood.LIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.LIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.POSITIVE,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.POSITIVE,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.LIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    31: {  # 'Н'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.POSITIVE,  # 'А'
        41: SequenceLikelihood.LIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.LIKELY,  # 'Г'
        37: SequenceLikelihood.LIKELY,  # 'Д'
        38: SequenceLikelihood.POSITIVE,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.POSITIVE,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.POSITIVE,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.LIKELY,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.LIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.NEGATIVE,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    32: {  # 'О'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.LIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.LIKELY,  # 'Б'
        33: SequenceLikelihood.POSITIVE,  # 'В'
        44: SequenceLikelihood.LIKELY,  # 'Г'
        37: SequenceLikelihood.POSITIVE,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.LIKELY,  # 'Ж'
        43: SequenceLikelihood.LIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.LIKELY,  # 'Л'
        29: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.POSITIVE,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.LIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.LIKELY,  # 'Ч'
        51: SequenceLikelihood.LIKELY,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.UNLIKELY,  # 'и'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        27: SequenceLikelihood.LIKELY,  # 'ф'
        39: SequenceLikelihood.LIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    30: {  # 'П'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.LIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.LIKELY,  # 'Л'
        29: SequenceLikelihood.POSITIVE,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.POSITIVE,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    40: {  # 'Р'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.POSITIVE,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.LIKELY,  # 'Д'
        38: SequenceLikelihood.POSITIVE,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.LIKELY,  # 'З'
        35: SequenceLikelihood.POSITIVE,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        32: SequenceLikelihood.POSITIVE,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.LIKELY,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    25: {  # 'С'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.LIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.POSITIVE,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.POSITIVE,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.LIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.POSITIVE,  # 'К'
        45: SequenceLikelihood.LIKELY,  # 'Л'
        29: SequenceLikelihood.POSITIVE,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.POSITIVE,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    36: {  # 'Т'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.POSITIVE,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.POSITIVE,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.POSITIVE,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        32: SequenceLikelihood.POSITIVE,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.LIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    46: {  # 'У'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.LIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.LIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        44: SequenceLikelihood.LIKELY,  # 'Г'
        37: SequenceLikelihood.LIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.LIKELY,  # 'Л'
        29: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.LIKELY,  # 'С'
        36: SequenceLikelihood.LIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.LIKELY,  # 'Ч'
        51: SequenceLikelihood.LIKELY,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.UNLIKELY,  # 'и'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        20: SequenceLikelihood.LIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    48: {  # 'Ф'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.LIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.NEGATIVE,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.NEGATIVE,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    50: {  # 'Х'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.LIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.NEGATIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    49: {  # 'Ц'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    53: {  # 'Ч'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.LIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        10: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.NEGATIVE,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.NEGATIVE,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.NEGATIVE,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    51: {  # 'Ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.LIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.LIKELY,  # 'И'
        34: SequenceLikelihood.LIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.LIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        10: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.NEGATIVE,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    1: {  # 'а'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.POSITIVE,  # 'ж'
        16: SequenceLikelihood.POSITIVE,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.POSITIVE,  # 'ф'
        39: SequenceLikelihood.POSITIVE,  # 'х'
        22: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        20: SequenceLikelihood.POSITIVE,  # 'ш'
        42: SequenceLikelihood.POSITIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.POSITIVE,  # 'ј'
        54: SequenceLikelihood.LIKELY,  # 'љ'
        24: SequenceLikelihood.POSITIVE,  # 'њ'
        26: SequenceLikelihood.POSITIVE,  # 'ќ'
        52: SequenceLikelihood.LIKELY,  # 'џ'
    },
    19: {  # 'б'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.NEGATIVE,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.NEGATIVE,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.NEGATIVE,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.POSITIVE,  # 'ј'
        54: SequenceLikelihood.LIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    9: {  # 'в'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.LIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        20: SequenceLikelihood.LIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.POSITIVE,  # 'ј'
        54: SequenceLikelihood.LIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    18: {  # 'г'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.LIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    10: {  # 'д'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.LIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.LIKELY,  # 'х'
        22: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    4: {  # 'е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.POSITIVE,  # 'ж'
        16: SequenceLikelihood.POSITIVE,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.POSITIVE,  # 'ф'
        39: SequenceLikelihood.POSITIVE,  # 'х'
        22: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        20: SequenceLikelihood.POSITIVE,  # 'ш'
        42: SequenceLikelihood.POSITIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.POSITIVE,  # 'ј'
        54: SequenceLikelihood.LIKELY,  # 'љ'
        24: SequenceLikelihood.POSITIVE,  # 'њ'
        26: SequenceLikelihood.POSITIVE,  # 'ќ'
        52: SequenceLikelihood.LIKELY,  # 'џ'
    },
    23: {  # 'ж'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.NEGATIVE,  # 'А'
        41: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.NEGATIVE,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.NEGATIVE,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.LIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    16: {  # 'з'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.POSITIVE,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    3: {  # 'и'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.LIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.POSITIVE,  # 'ж'
        16: SequenceLikelihood.POSITIVE,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.POSITIVE,  # 'ф'
        39: SequenceLikelihood.POSITIVE,  # 'х'
        22: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        20: SequenceLikelihood.POSITIVE,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.POSITIVE,  # 'ј'
        54: SequenceLikelihood.LIKELY,  # 'љ'
        24: SequenceLikelihood.POSITIVE,  # 'њ'
        26: SequenceLikelihood.POSITIVE,  # 'ќ'
        52: SequenceLikelihood.LIKELY,  # 'џ'
    },
    11: {  # 'к'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.LIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    12: {  # 'л'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        10: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.POSITIVE,  # 'ж'
        16: SequenceLikelihood.LIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.LIKELY,  # 'ф'
        39: SequenceLikelihood.LIKELY,  # 'х'
        22: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        20: SequenceLikelihood.LIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.POSITIVE,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    14: {  # 'м'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.LIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.POSITIVE,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    6: {  # 'н'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.LIKELY,  # 'ж'
        16: SequenceLikelihood.POSITIVE,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.POSITIVE,  # 'ф'
        39: SequenceLikelihood.LIKELY,  # 'х'
        22: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        20: SequenceLikelihood.LIKELY,  # 'ш'
        42: SequenceLikelihood.LIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.LIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.LIKELY,  # 'џ'
    },
    2: {  # 'о'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.UNLIKELY,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.POSITIVE,  # 'ж'
        16: SequenceLikelihood.POSITIVE,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.POSITIVE,  # 'ф'
        39: SequenceLikelihood.POSITIVE,  # 'х'
        22: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        20: SequenceLikelihood.POSITIVE,  # 'ш'
        42: SequenceLikelihood.POSITIVE,  # 'ѓ'
        58: SequenceLikelihood.LIKELY,  # 'ѕ'
        17: SequenceLikelihood.POSITIVE,  # 'ј'
        54: SequenceLikelihood.LIKELY,  # 'љ'
        24: SequenceLikelihood.LIKELY,  # 'њ'
        26: SequenceLikelihood.POSITIVE,  # 'ќ'
        52: SequenceLikelihood.LIKELY,  # 'џ'
    },
    13: {  # 'п'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.NEGATIVE,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.LIKELY,  # 'ф'
        39: SequenceLikelihood.LIKELY,  # 'х'
        22: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        20: SequenceLikelihood.POSITIVE,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.POSITIVE,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    7: {  # 'р'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.POSITIVE,  # 'ж'
        16: SequenceLikelihood.POSITIVE,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.LIKELY,  # 'ф'
        39: SequenceLikelihood.POSITIVE,  # 'х'
        22: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        20: SequenceLikelihood.POSITIVE,  # 'ш'
        42: SequenceLikelihood.LIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.LIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.LIKELY,  # 'џ'
    },
    8: {  # 'с'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.POSITIVE,  # 'ф'
        39: SequenceLikelihood.LIKELY,  # 'х'
        22: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.LIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    5: {  # 'т'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.UNLIKELY,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.LIKELY,  # 'ф'
        39: SequenceLikelihood.POSITIVE,  # 'х'
        22: SequenceLikelihood.LIKELY,  # 'ц'
        21: SequenceLikelihood.LIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.LIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    15: {  # 'у'
        59: SequenceLikelihood.UNLIKELY,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.NEGATIVE,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.POSITIVE,  # 'ж'
        16: SequenceLikelihood.POSITIVE,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.POSITIVE,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        27: SequenceLikelihood.LIKELY,  # 'ф'
        39: SequenceLikelihood.POSITIVE,  # 'х'
        22: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        20: SequenceLikelihood.POSITIVE,  # 'ш'
        42: SequenceLikelihood.POSITIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.LIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.LIKELY,  # 'ќ'
        52: SequenceLikelihood.LIKELY,  # 'џ'
    },
    27: {  # 'ф'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.NEGATIVE,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    39: {  # 'х'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.NEGATIVE,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.NEGATIVE,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.NEGATIVE,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    22: {  # 'ц'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.NEGATIVE,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.NEGATIVE,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.LIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    21: {  # 'ч'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.NEGATIVE,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.POSITIVE,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.LIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    20: {  # 'ш'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.NEGATIVE,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.NEGATIVE,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.NEGATIVE,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.LIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    42: {  # 'ѓ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.NEGATIVE,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.NEGATIVE,  # 'Д'
        38: SequenceLikelihood.NEGATIVE,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.NEGATIVE,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.NEGATIVE,  # 'Н'
        32: SequenceLikelihood.NEGATIVE,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        25: SequenceLikelihood.NEGATIVE,  # 'С'
        36: SequenceLikelihood.NEGATIVE,  # 'Т'
        46: SequenceLikelihood.NEGATIVE,  # 'У'
        48: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.NEGATIVE,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.NEGATIVE,  # 'х'
        22: SequenceLikelihood.NEGATIVE,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    58: {  # 'ѕ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.NEGATIVE,  # 'А'
        41: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.NEGATIVE,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.NEGATIVE,  # 'Д'
        38: SequenceLikelihood.NEGATIVE,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.NEGATIVE,  # 'И'
        34: SequenceLikelihood.NEGATIVE,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.NEGATIVE,  # 'Н'
        32: SequenceLikelihood.NEGATIVE,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        25: SequenceLikelihood.NEGATIVE,  # 'С'
        36: SequenceLikelihood.NEGATIVE,  # 'Т'
        46: SequenceLikelihood.NEGATIVE,  # 'У'
        48: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        27: SequenceLikelihood.NEGATIVE,  # 'ф'
        39: SequenceLikelihood.NEGATIVE,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.NEGATIVE,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.NEGATIVE,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    17: {  # 'ј'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.UNLIKELY,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ќ'
        56: SequenceLikelihood.UNLIKELY,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.UNLIKELY,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.UNLIKELY,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.UNLIKELY,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        10: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.POSITIVE,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        12: SequenceLikelihood.LIKELY,  # 'л'
        14: SequenceLikelihood.POSITIVE,  # 'м'
        6: SequenceLikelihood.POSITIVE,  # 'н'
        2: SequenceLikelihood.POSITIVE,  # 'о'
        13: SequenceLikelihood.LIKELY,  # 'п'
        7: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        5: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.LIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.POSITIVE,  # 'ц'
        21: SequenceLikelihood.POSITIVE,  # 'ч'
        20: SequenceLikelihood.LIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.UNLIKELY,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.UNLIKELY,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.POSITIVE,  # 'ќ'
        52: SequenceLikelihood.LIKELY,  # 'џ'
    },
    54: {  # 'љ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.NEGATIVE,  # 'А'
        41: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.NEGATIVE,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.NEGATIVE,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.NEGATIVE,  # 'И'
        34: SequenceLikelihood.NEGATIVE,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.NEGATIVE,  # 'Н'
        32: SequenceLikelihood.NEGATIVE,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        25: SequenceLikelihood.NEGATIVE,  # 'С'
        36: SequenceLikelihood.NEGATIVE,  # 'Т'
        46: SequenceLikelihood.NEGATIVE,  # 'У'
        48: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.UNLIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    24: {  # 'њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.NEGATIVE,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.NEGATIVE,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.NEGATIVE,  # 'Д'
        38: SequenceLikelihood.NEGATIVE,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.NEGATIVE,  # 'И'
        34: SequenceLikelihood.NEGATIVE,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.NEGATIVE,  # 'Н'
        32: SequenceLikelihood.NEGATIVE,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        25: SequenceLikelihood.NEGATIVE,  # 'С'
        36: SequenceLikelihood.NEGATIVE,  # 'Т'
        46: SequenceLikelihood.NEGATIVE,  # 'У'
        48: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.NEGATIVE,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    26: {  # 'ќ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.UNLIKELY,  # 'А'
        41: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        43: SequenceLikelihood.UNLIKELY,  # 'З'
        35: SequenceLikelihood.UNLIKELY,  # 'И'
        34: SequenceLikelihood.UNLIKELY,  # 'К'
        45: SequenceLikelihood.UNLIKELY,  # 'Л'
        29: SequenceLikelihood.UNLIKELY,  # 'М'
        31: SequenceLikelihood.UNLIKELY,  # 'Н'
        32: SequenceLikelihood.NEGATIVE,  # 'О'
        30: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        25: SequenceLikelihood.UNLIKELY,  # 'С'
        36: SequenceLikelihood.UNLIKELY,  # 'Т'
        46: SequenceLikelihood.NEGATIVE,  # 'У'
        48: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.UNLIKELY,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.POSITIVE,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.UNLIKELY,  # 'м'
        6: SequenceLikelihood.LIKELY,  # 'н'
        2: SequenceLikelihood.UNLIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.NEGATIVE,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.UNLIKELY,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.UNLIKELY,  # 'ќ'
        52: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    52: {  # 'џ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ѓ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ѕ'
        47: SequenceLikelihood.NEGATIVE,  # 'Ј'
        61: SequenceLikelihood.NEGATIVE,  # 'Љ'
        60: SequenceLikelihood.NEGATIVE,  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ќ'
        56: SequenceLikelihood.NEGATIVE,  # 'Џ'
        28: SequenceLikelihood.NEGATIVE,  # 'А'
        41: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        44: SequenceLikelihood.NEGATIVE,  # 'Г'
        37: SequenceLikelihood.UNLIKELY,  # 'Д'
        38: SequenceLikelihood.NEGATIVE,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        43: SequenceLikelihood.NEGATIVE,  # 'З'
        35: SequenceLikelihood.NEGATIVE,  # 'И'
        34: SequenceLikelihood.NEGATIVE,  # 'К'
        45: SequenceLikelihood.NEGATIVE,  # 'Л'
        29: SequenceLikelihood.NEGATIVE,  # 'М'
        31: SequenceLikelihood.NEGATIVE,  # 'Н'
        32: SequenceLikelihood.NEGATIVE,  # 'О'
        30: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        25: SequenceLikelihood.NEGATIVE,  # 'С'
        36: SequenceLikelihood.NEGATIVE,  # 'Т'
        46: SequenceLikelihood.NEGATIVE,  # 'У'
        48: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        51: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        10: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        23: SequenceLikelihood.NEGATIVE,  # 'ж'
        16: SequenceLikelihood.UNLIKELY,  # 'з'
        3: SequenceLikelihood.LIKELY,  # 'и'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        12: SequenceLikelihood.UNLIKELY,  # 'л'
        14: SequenceLikelihood.LIKELY,  # 'м'
        6: SequenceLikelihood.UNLIKELY,  # 'н'
        2: SequenceLikelihood.LIKELY,  # 'о'
        13: SequenceLikelihood.UNLIKELY,  # 'п'
        7: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        5: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        27: SequenceLikelihood.UNLIKELY,  # 'ф'
        39: SequenceLikelihood.UNLIKELY,  # 'х'
        22: SequenceLikelihood.UNLIKELY,  # 'ц'
        21: SequenceLikelihood.UNLIKELY,  # 'ч'
        20: SequenceLikelihood.UNLIKELY,  # 'ш'
        42: SequenceLikelihood.NEGATIVE,  # 'ѓ'
        58: SequenceLikelihood.NEGATIVE,  # 'ѕ'
        17: SequenceLikelihood.UNLIKELY,  # 'ј'
        54: SequenceLikelihood.NEGATIVE,  # 'љ'
        24: SequenceLikelihood.UNLIKELY,  # 'њ'
        26: SequenceLikelihood.NEGATIVE,  # 'ќ'
        52: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
}

# Character Mapping Table(s):
CP855_MACEDONIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'ђ'
    129: 0,  # 'Ђ'
    130: 42,  # 'ѓ'
    131: 59,  # 'Ѓ'
    132: 0,  # 'ё'
    133: 0,  # 'Ё'
    134: 0,  # 'є'
    135: 0,  # 'Є'
    136: 58,  # 'ѕ'
    137: 62,  # 'Ѕ'
    138: 0,  # 'і'
    139: 0,  # 'І'
    140: 0,  # 'ї'
    141: 0,  # 'Ї'
    142: 17,  # 'ј'
    143: 47,  # 'Ј'
    144: 54,  # 'љ'
    145: 61,  # 'Љ'
    146: 24,  # 'њ'
    147: 60,  # 'Њ'
    148: 0,  # 'ћ'
    149: 0,  # 'Ћ'
    150: 26,  # 'ќ'
    151: 57,  # 'Ќ'
    152: 0,  # 'ў'
    153: 0,  # 'Ў'
    154: 52,  # 'џ'
    155: 56,  # 'Џ'
    156: 0,  # 'ю'
    157: 0,  # 'Ю'
    158: 0,  # 'ъ'
    159: 0,  # 'Ъ'
    160: 1,  # 'а'
    161: 28,  # 'А'
    162: 19,  # 'б'
    163: 41,  # 'Б'
    164: 22,  # 'ц'
    165: 49,  # 'Ц'
    166: 10,  # 'д'
    167: 37,  # 'Д'
    168: 4,  # 'е'
    169: 38,  # 'Е'
    170: 27,  # 'ф'
    171: 48,  # 'Ф'
    172: 18,  # 'г'
    173: 44,  # 'Г'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 39,  # 'х'
    182: 50,  # 'Х'
    183: 3,  # 'и'
    184: 35,  # 'И'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 0,  # 'й'
    190: 0,  # 'Й'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 11,  # 'к'
    199: 34,  # 'К'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 12,  # 'л'
    209: 45,  # 'Л'
    210: 14,  # 'м'
    211: 29,  # 'М'
    212: 6,  # 'н'
    213: 31,  # 'Н'
    214: 2,  # 'о'
    215: 32,  # 'О'
    216: 13,  # 'п'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: 30,  # 'П'
    222: 0,  # 'я'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Я'
    225: 7,  # 'р'
    226: 40,  # 'Р'
    227: 8,  # 'с'
    228: 25,  # 'С'
    229: 5,  # 'т'
    230: 36,  # 'Т'
    231: 15,  # 'у'
    232: 46,  # 'У'
    233: 23,  # 'ж'
    234: 55,  # 'Ж'
    235: 9,  # 'в'
    236: 33,  # 'В'
    237: 0,  # 'ь'
    238: 0,  # 'Ь'
    239: CharacterCategory.SYMBOL,  # '№'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: 0,  # 'ы'
    242: 0,  # 'Ы'
    243: 16,  # 'з'
    244: 43,  # 'З'
    245: 20,  # 'ш'
    246: 51,  # 'Ш'
    247: 0,  # 'э'
    248: 0,  # 'Э'
    249: 0,  # 'щ'
    250: 0,  # 'Щ'
    251: 21,  # 'ч'
    252: 53,  # 'Ч'
    253: CharacterCategory.SYMBOL,  # '§'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP855_MACEDONIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP855",
    language="Macedonian",
    char_to_order_map=CP855_MACEDONIAN_CHAR_TO_ORDER,
    language_model=MACEDONIAN_LANG_MODEL,
    typical_positive_ratio=0.9834588496580098,
    keep_ascii_letters=False,
    alphabet="ЃЅЈЉЊЌЏАБВГДЕЖЗИКЛМНОПРСТУФХЦЧШабвгдежзиклмнопрстуфхцчшѓѕјљњќџ",
)

CP866_MACEDONIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 28,  # 'А'
    129: 41,  # 'Б'
    130: 33,  # 'В'
    131: 44,  # 'Г'
    132: 37,  # 'Д'
    133: 38,  # 'Е'
    134: 55,  # 'Ж'
    135: 43,  # 'З'
    136: 0,  # 'И'
    137: 0,  # 'Й'
    138: 34,  # 'К'
    139: 45,  # 'Л'
    140: 29,  # 'М'
    141: 31,  # 'Н'
    142: 32,  # 'О'
    143: 30,  # 'П'
    144: 40,  # 'Р'
    145: 25,  # 'С'
    146: 36,  # 'Т'
    147: 46,  # 'У'
    148: 48,  # 'Ф'
    149: 50,  # 'Х'
    150: 49,  # 'Ц'
    151: 53,  # 'Ч'
    152: 51,  # 'Ш'
    153: 0,  # 'Щ'
    154: 0,  # 'Ъ'
    155: 0,  # 'Ы'
    156: 0,  # 'Ь'
    157: 0,  # 'Э'
    158: 0,  # 'Ю'
    159: 0,  # 'Я'
    160: 1,  # 'а'
    161: 19,  # 'б'
    162: 9,  # 'в'
    163: 18,  # 'г'
    164: 10,  # 'д'
    165: 4,  # 'е'
    166: 23,  # 'ж'
    167: 16,  # 'з'
    168: 0,  # 'и'
    169: 0,  # 'й'
    170: 11,  # 'к'
    171: 12,  # 'л'
    172: 14,  # 'м'
    173: 6,  # 'н'
    174: 2,  # 'о'
    175: 13,  # 'п'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 7,  # 'р'
    225: 8,  # 'с'
    226: 5,  # 'т'
    227: 15,  # 'у'
    228: 27,  # 'ф'
    229: 39,  # 'х'
    230: 22,  # 'ц'
    231: 21,  # 'ч'
    232: 20,  # 'ш'
    233: 0,  # 'щ'
    234: 0,  # 'ъ'
    235: 0,  # 'ы'
    236: 0,  # 'ь'
    237: 0,  # 'э'
    238: 0,  # 'ю'
    239: 0,  # 'я'
    240: 0,  # 'Ё'
    241: 0,  # 'ё'
    242: 0,  # 'Є'
    243: 0,  # 'є'
    244: 0,  # 'Ї'
    245: 0,  # 'ї'
    246: 0,  # 'Ў'
    247: 0,  # 'ў'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: CharacterCategory.SYMBOL,  # '№'
    253: CharacterCategory.SYMBOL,  # '¤'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP866_MACEDONIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP866",
    language="Macedonian",
    char_to_order_map=CP866_MACEDONIAN_CHAR_TO_ORDER,
    language_model=MACEDONIAN_LANG_MODEL,
    typical_positive_ratio=0.985123636939552,
    keep_ascii_letters=False,
    alphabet="ЃЅЈЉЊЌЏАБВГДЕЖЗИКЛМНОПРСТУФХЦЧШабвгдежзиклмнопрстуфхцчшѓѕјљњќџ",
)

ISO_8859_5_MACEDONIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ё'
    162: 0,  # 'Ђ'
    163: 59,  # 'Ѓ'
    164: 0,  # 'Є'
    165: 62,  # 'Ѕ'
    166: 0,  # 'І'
    167: 0,  # 'Ї'
    168: 47,  # 'Ј'
    169: 61,  # 'Љ'
    170: 60,  # 'Њ'
    171: 0,  # 'Ћ'
    172: 57,  # 'Ќ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'Ў'
    175: 56,  # 'Џ'
    176: 28,  # 'А'
    177: 41,  # 'Б'
    178: 33,  # 'В'
    179: 44,  # 'Г'
    180: 37,  # 'Д'
    181: 38,  # 'Е'
    182: 55,  # 'Ж'
    183: 43,  # 'З'
    184: 35,  # 'И'
    185: 0,  # 'Й'
    186: 34,  # 'К'
    187: 45,  # 'Л'
    188: 29,  # 'М'
    189: 31,  # 'Н'
    190: 32,  # 'О'
    191: 30,  # 'П'
    192: 40,  # 'Р'
    193: 25,  # 'С'
    194: 36,  # 'Т'
    195: 46,  # 'У'
    196: 48,  # 'Ф'
    197: 50,  # 'Х'
    198: 49,  # 'Ц'
    199: 53,  # 'Ч'
    200: 51,  # 'Ш'
    201: 0,  # 'Щ'
    202: 0,  # 'Ъ'
    203: 0,  # 'Ы'
    204: 0,  # 'Ь'
    205: 0,  # 'Э'
    206: 0,  # 'Ю'
    207: 0,  # 'Я'
    208: 1,  # 'а'
    209: 19,  # 'б'
    210: 9,  # 'в'
    211: 18,  # 'г'
    212: 10,  # 'д'
    213: 4,  # 'е'
    214: 23,  # 'ж'
    215: 16,  # 'з'
    216: 3,  # 'и'
    217: 0,  # 'й'
    218: 11,  # 'к'
    219: 12,  # 'л'
    220: 14,  # 'м'
    221: 6,  # 'н'
    222: 2,  # 'о'
    223: 13,  # 'п'
    224: 7,  # 'р'
    225: 8,  # 'с'
    226: 5,  # 'т'
    227: 15,  # 'у'
    228: 27,  # 'ф'
    229: 39,  # 'х'
    230: 22,  # 'ц'
    231: 21,  # 'ч'
    232: 20,  # 'ш'
    233: 0,  # 'щ'
    234: 0,  # 'ъ'
    235: 0,  # 'ы'
    236: 0,  # 'ь'
    237: 0,  # 'э'
    238: 0,  # 'ю'
    239: 0,  # 'я'
    240: CharacterCategory.SYMBOL,  # '№'
    241: 0,  # 'ё'
    242: 0,  # 'ђ'
    243: 42,  # 'ѓ'
    244: 0,  # 'є'
    245: 58,  # 'ѕ'
    246: 0,  # 'і'
    247: 0,  # 'ї'
    248: 17,  # 'ј'
    249: 54,  # 'љ'
    250: 24,  # 'њ'
    251: 0,  # 'ћ'
    252: 26,  # 'ќ'
    253: CharacterCategory.SYMBOL,  # '§'
    254: 0,  # 'ў'
    255: 52,  # 'џ'
}

ISO_8859_5_MACEDONIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-5",
    language="Macedonian",
    char_to_order_map=ISO_8859_5_MACEDONIAN_CHAR_TO_ORDER,
    language_model=MACEDONIAN_LANG_MODEL,
    typical_positive_ratio=0.9834588496580098,
    keep_ascii_letters=False,
    alphabet="ЃЅЈЉЊЌЏАБВГДЕЖЗИКЛМНОПРСТУФХЦЧШабвгдежзиклмнопрстуфхцчшѓѕјљњќџ",
)

KOI8_R_MACEDONIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '─'
    129: CharacterCategory.SYMBOL,  # '│'
    130: CharacterCategory.SYMBOL,  # '┌'
    131: CharacterCategory.SYMBOL,  # '┐'
    132: CharacterCategory.SYMBOL,  # '└'
    133: CharacterCategory.SYMBOL,  # '┘'
    134: CharacterCategory.SYMBOL,  # '├'
    135: CharacterCategory.SYMBOL,  # '┤'
    136: CharacterCategory.SYMBOL,  # '┬'
    137: CharacterCategory.SYMBOL,  # '┴'
    138: CharacterCategory.SYMBOL,  # '┼'
    139: CharacterCategory.SYMBOL,  # '▀'
    140: CharacterCategory.SYMBOL,  # '▄'
    141: CharacterCategory.SYMBOL,  # '█'
    142: CharacterCategory.SYMBOL,  # '▌'
    143: CharacterCategory.SYMBOL,  # '▐'
    144: CharacterCategory.SYMBOL,  # '░'
    145: CharacterCategory.SYMBOL,  # '▒'
    146: CharacterCategory.SYMBOL,  # '▓'
    147: CharacterCategory.SYMBOL,  # '⌠'
    148: CharacterCategory.SYMBOL,  # '■'
    149: CharacterCategory.SYMBOL,  # '∙'
    150: CharacterCategory.SYMBOL,  # '√'
    151: CharacterCategory.SYMBOL,  # '≈'
    152: CharacterCategory.SYMBOL,  # '≤'
    153: CharacterCategory.SYMBOL,  # '≥'
    154: CharacterCategory.CONTROL,  # '\xa0'
    155: CharacterCategory.SYMBOL,  # '⌡'
    156: CharacterCategory.SYMBOL,  # '°'
    157: CharacterCategory.DIGIT,  # '²'
    158: CharacterCategory.SYMBOL,  # '·'
    159: CharacterCategory.SYMBOL,  # '÷'
    160: CharacterCategory.SYMBOL,  # '═'
    161: CharacterCategory.SYMBOL,  # '║'
    162: CharacterCategory.SYMBOL,  # '╒'
    163: 0,  # 'ё'
    164: CharacterCategory.SYMBOL,  # '╓'
    165: CharacterCategory.SYMBOL,  # '╔'
    166: CharacterCategory.SYMBOL,  # '╕'
    167: CharacterCategory.SYMBOL,  # '╖'
    168: CharacterCategory.SYMBOL,  # '╗'
    169: CharacterCategory.SYMBOL,  # '╘'
    170: CharacterCategory.SYMBOL,  # '╙'
    171: CharacterCategory.SYMBOL,  # '╚'
    172: CharacterCategory.SYMBOL,  # '╛'
    173: CharacterCategory.SYMBOL,  # '╜'
    174: CharacterCategory.SYMBOL,  # '╝'
    175: CharacterCategory.SYMBOL,  # '╞'
    176: CharacterCategory.SYMBOL,  # '╟'
    177: CharacterCategory.SYMBOL,  # '╠'
    178: CharacterCategory.SYMBOL,  # '╡'
    179: 0,  # 'Ё'
    180: CharacterCategory.SYMBOL,  # '╢'
    181: CharacterCategory.SYMBOL,  # '╣'
    182: CharacterCategory.SYMBOL,  # '╤'
    183: CharacterCategory.SYMBOL,  # '╥'
    184: CharacterCategory.SYMBOL,  # '╦'
    185: CharacterCategory.SYMBOL,  # '╧'
    186: CharacterCategory.SYMBOL,  # '╨'
    187: CharacterCategory.SYMBOL,  # '╩'
    188: CharacterCategory.SYMBOL,  # '╪'
    189: CharacterCategory.SYMBOL,  # '╫'
    190: CharacterCategory.SYMBOL,  # '╬'
    191: CharacterCategory.SYMBOL,  # '©'
    192: 0,  # 'ю'
    193: 1,  # 'а'
    194: 19,  # 'б'
    195: 22,  # 'ц'
    196: 10,  # 'д'
    197: 4,  # 'е'
    198: 27,  # 'ф'
    199: 18,  # 'г'
    200: 39,  # 'х'
    201: 3,  # 'и'
    202: 0,  # 'й'
    203: 11,  # 'к'
    204: 12,  # 'л'
    205: 14,  # 'м'
    206: 6,  # 'н'
    207: 2,  # 'о'
    208: 13,  # 'п'
    209: 0,  # 'я'
    210: 7,  # 'р'
    211: 8,  # 'с'
    212: 5,  # 'т'
    213: 15,  # 'у'
    214: 23,  # 'ж'
    215: 9,  # 'в'
    216: 0,  # 'ь'
    217: 0,  # 'ы'
    218: 16,  # 'з'
    219: 20,  # 'ш'
    220: 0,  # 'э'
    221: 0,  # 'щ'
    222: 21,  # 'ч'
    223: 0,  # 'ъ'
    224: 0,  # 'Ю'
    225: 28,  # 'А'
    226: 41,  # 'Б'
    227: 49,  # 'Ц'
    228: 37,  # 'Д'
    229: 38,  # 'Е'
    230: 48,  # 'Ф'
    231: 44,  # 'Г'
    232: 50,  # 'Х'
    233: 35,  # 'И'
    234: 0,  # 'Й'
    235: 34,  # 'К'
    236: 45,  # 'Л'
    237: 29,  # 'М'
    238: 31,  # 'Н'
    239: 32,  # 'О'
    240: 30,  # 'П'
    241: 0,  # 'Я'
    242: 40,  # 'Р'
    243: 25,  # 'С'
    244: 36,  # 'Т'
    245: 46,  # 'У'
    246: 55,  # 'Ж'
    247: 33,  # 'В'
    248: 0,  # 'Ь'
    249: 0,  # 'Ы'
    250: 43,  # 'З'
    251: 51,  # 'Ш'
    252: 0,  # 'Э'
    253: 0,  # 'Щ'
    254: 53,  # 'Ч'
    255: 0,  # 'Ъ'
}

KOI8_R_MACEDONIAN_MODEL = SingleByteCharSetModel(
    charset_name="KOI8-R",
    language="Macedonian",
    char_to_order_map=KOI8_R_MACEDONIAN_CHAR_TO_ORDER,
    language_model=MACEDONIAN_LANG_MODEL,
    typical_positive_ratio=0.985123636939552,
    keep_ascii_letters=False,
    alphabet="ЃЅЈЉЊЌЏАБВГДЕЖЗИКЛМНОПРСТУФХЦЧШабвгдежзиклмнопрстуфхцчшѓѕјљњќџ",
)

MACCYRILLIC_MACEDONIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 28,  # 'А'
    129: 41,  # 'Б'
    130: 33,  # 'В'
    131: 44,  # 'Г'
    132: 37,  # 'Д'
    133: 38,  # 'Е'
    134: 55,  # 'Ж'
    135: 43,  # 'З'
    136: 35,  # 'И'
    137: 0,  # 'Й'
    138: 34,  # 'К'
    139: 45,  # 'Л'
    140: 29,  # 'М'
    141: 31,  # 'Н'
    142: 32,  # 'О'
    143: 30,  # 'П'
    144: 40,  # 'Р'
    145: 25,  # 'С'
    146: 36,  # 'Т'
    147: 46,  # 'У'
    148: 48,  # 'Ф'
    149: 50,  # 'Х'
    150: 49,  # 'Ц'
    151: 53,  # 'Ч'
    152: 51,  # 'Ш'
    153: 0,  # 'Щ'
    154: 0,  # 'Ъ'
    155: 0,  # 'Ы'
    156: 0,  # 'Ь'
    157: 0,  # 'Э'
    158: 0,  # 'Ю'
    159: 0,  # 'Я'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: 0,  # 'Ґ'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'І'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: 0,  # 'Ђ'
    172: 0,  # 'ђ'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 59,  # 'Ѓ'
    175: 42,  # 'ѓ'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: 0,  # 'і'
    181: 0,  # 'µ'
    182: 0,  # 'ґ'
    183: 47,  # 'Ј'
    184: 0,  # 'Є'
    185: 0,  # 'є'
    186: 0,  # 'Ї'
    187: 0,  # 'ї'
    188: 61,  # 'Љ'
    189: 54,  # 'љ'
    190: 60,  # 'Њ'
    191: 24,  # 'њ'
    192: 17,  # 'ј'
    193: 62,  # 'Ѕ'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'Ћ'
    204: 0,  # 'ћ'
    205: 57,  # 'Ќ'
    206: 26,  # 'ќ'
    207: 58,  # 'ѕ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '„'
    216: 0,  # 'Ў'
    217: 0,  # 'ў'
    218: 56,  # 'Џ'
    219: 52,  # 'џ'
    220: CharacterCategory.SYMBOL,  # '№'
    221: 0,  # 'Ё'
    222: 0,  # 'ё'
    223: 0,  # 'я'
    224: 1,  # 'а'
    225: 19,  # 'б'
    226: 9,  # 'в'
    227: 18,  # 'г'
    228: 10,  # 'д'
    229: 4,  # 'е'
    230: 23,  # 'ж'
    231: 16,  # 'з'
    232: 3,  # 'и'
    233: 0,  # 'й'
    234: 11,  # 'к'
    235: 12,  # 'л'
    236: 14,  # 'м'
    237: 6,  # 'н'
    238: 2,  # 'о'
    239: 13,  # 'п'
    240: 7,  # 'р'
    241: 8,  # 'с'
    242: 5,  # 'т'
    243: 15,  # 'у'
    244: 27,  # 'ф'
    245: 39,  # 'х'
    246: 22,  # 'ц'
    247: 21,  # 'ч'
    248: 20,  # 'ш'
    249: 0,  # 'щ'
    250: 0,  # 'ъ'
    251: 0,  # 'ы'
    252: 0,  # 'ь'
    253: 0,  # 'э'
    254: 0,  # 'ю'
    255: CharacterCategory.SYMBOL,  # '€'
}

MACCYRILLIC_MACEDONIAN_MODEL = SingleByteCharSetModel(
    charset_name="MacCyrillic",
    language="Macedonian",
    char_to_order_map=MACCYRILLIC_MACEDONIAN_CHAR_TO_ORDER,
    language_model=MACEDONIAN_LANG_MODEL,
    typical_positive_ratio=0.9834588496580098,
    keep_ascii_letters=False,
    alphabet="ЃЅЈЉЊЌЏАБВГДЕЖЗИКЛМНОПРСТУФХЦЧШабвгдежзиклмнопрстуфхцчшѓѕјљњќџ",
)

WINDOWS_1251_MACEDONIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ђ'
    129: 59,  # 'Ѓ'
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 42,  # 'ѓ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.SYMBOL,  # '€'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 61,  # 'Љ'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 60,  # 'Њ'
    141: 57,  # 'Ќ'
    142: 0,  # 'Ћ'
    143: 56,  # 'Џ'
    144: 0,  # 'ђ'
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 54,  # 'љ'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 24,  # 'њ'
    157: 26,  # 'ќ'
    158: 0,  # 'ћ'
    159: 52,  # 'џ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ў'
    162: 0,  # 'ў'
    163: 47,  # 'Ј'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ґ'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ё'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Є'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ї'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 0,  # 'І'
    179: 0,  # 'і'
    180: 0,  # 'ґ'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ё'
    185: CharacterCategory.SYMBOL,  # '№'
    186: 0,  # 'є'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 17,  # 'ј'
    189: 62,  # 'Ѕ'
    190: 58,  # 'ѕ'
    191: 0,  # 'ї'
    192: 28,  # 'А'
    193: 41,  # 'Б'
    194: 33,  # 'В'
    195: 44,  # 'Г'
    196: 37,  # 'Д'
    197: 38,  # 'Е'
    198: 55,  # 'Ж'
    199: 43,  # 'З'
    200: 35,  # 'И'
    201: 0,  # 'Й'
    202: 34,  # 'К'
    203: 45,  # 'Л'
    204: 29,  # 'М'
    205: 31,  # 'Н'
    206: 32,  # 'О'
    207: 30,  # 'П'
    208: 40,  # 'Р'
    209: 25,  # 'С'
    210: 36,  # 'Т'
    211: 46,  # 'У'
    212: 48,  # 'Ф'
    213: 50,  # 'Х'
    214: 49,  # 'Ц'
    215: 53,  # 'Ч'
    216: 51,  # 'Ш'
    217: 0,  # 'Щ'
    218: 0,  # 'Ъ'
    219: 0,  # 'Ы'
    220: 0,  # 'Ь'
    221: 0,  # 'Э'
    222: 0,  # 'Ю'
    223: 0,  # 'Я'
    224: 1,  # 'а'
    225: 19,  # 'б'
    226: 9,  # 'в'
    227: 18,  # 'г'
    228: 10,  # 'д'
    229: 4,  # 'е'
    230: 23,  # 'ж'
    231: 16,  # 'з'
    232: 3,  # 'и'
    233: 0,  # 'й'
    234: 11,  # 'к'
    235: 12,  # 'л'
    236: 14,  # 'м'
    237: 6,  # 'н'
    238: 2,  # 'о'
    239: 13,  # 'п'
    240: 7,  # 'р'
    241: 8,  # 'с'
    242: 5,  # 'т'
    243: 15,  # 'у'
    244: 27,  # 'ф'
    245: 39,  # 'х'
    246: 22,  # 'ц'
    247: 21,  # 'ч'
    248: 20,  # 'ш'
    249: 0,  # 'щ'
    250: 0,  # 'ъ'
    251: 0,  # 'ы'
    252: 0,  # 'ь'
    253: 0,  # 'э'
    254: 0,  # 'ю'
    255: 0,  # 'я'
}

WINDOWS_1251_MACEDONIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1251",
    language="Macedonian",
    char_to_order_map=WINDOWS_1251_MACEDONIAN_CHAR_TO_ORDER,
    language_model=MACEDONIAN_LANG_MODEL,
    typical_positive_ratio=0.9834588496580098,
    keep_ascii_letters=False,
    alphabet="ЃЅЈЉЊЌЏАБВГДЕЖЗИКЛМНОПРСТУФХЦЧШабвгдежзиклмнопрстуфхцчшѓѕјљњќџ",
)
