from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

PORTUGUESE_LANG_MODEL = {
    23: {  # 'A'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.POSITIVE,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.POSITIVE,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.POSITIVE,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.POSITIVE,  # 'R'
        29: SequenceLikelihood.POSITIVE,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.LIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.LIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    43: {  # 'B'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    26: {  # 'C'
        23: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.LIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        31: SequenceLikelihood.POSITIVE,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.LIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    37: {  # 'D'
        23: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.POSITIVE,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.POSITIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    27: {  # 'E'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.POSITIVE,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.POSITIVE,  # 'R'
        29: SequenceLikelihood.POSITIVE,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.LIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.POSITIVE,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    44: {  # 'F'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.LIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    47: {  # 'G'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    54: {  # 'H'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.LIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    38: {  # 'I'
        23: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.POSITIVE,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.POSITIVE,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.POSITIVE,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.LIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    52: {  # 'J'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.LIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.LIKELY,  # 'ú'
    },
    61: {  # 'K'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    45: {  # 'L'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.LIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    35: {  # 'M'
        23: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.POSITIVE,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.LIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.LIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    39: {  # 'N'
        23: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        54: SequenceLikelihood.LIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.POSITIVE,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.POSITIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    31: {  # 'O'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.POSITIVE,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.POSITIVE,  # 'R'
        29: SequenceLikelihood.POSITIVE,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    30: {  # 'P'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.POSITIVE,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.LIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.LIKELY,  # 'ú'
    },
    58: {  # 'Q'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    36: {  # 'R'
        23: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.POSITIVE,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.POSITIVE,  # 'I'
        52: SequenceLikelihood.LIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        31: SequenceLikelihood.POSITIVE,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    29: {  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.POSITIVE,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.POSITIVE,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.LIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.POSITIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.LIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    40: {  # 'T'
        23: SequenceLikelihood.POSITIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.POSITIVE,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.POSITIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        49: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.LIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.LIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    50: {  # 'U'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        40: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    49: {  # 'V'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    60: {  # 'W'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    63: {  # 'X'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.LIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    65: {  # 'Y'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    64: {  # 'Z'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    1: {  # 'a'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.POSITIVE,  # 'j'
        51: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.LIKELY,  # 'w'
        33: SequenceLikelihood.POSITIVE,  # 'x'
        53: SequenceLikelihood.POSITIVE,  # 'y'
        28: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.POSITIVE,  # 'ç'
        25: SequenceLikelihood.LIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    18: {  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.POSITIVE,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.LIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        42: SequenceLikelihood.LIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ó'
        59: SequenceLikelihood.LIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    12: {  # 'c'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.LIKELY,  # 'á'
        57: SequenceLikelihood.LIKELY,  # 'â'
        20: SequenceLikelihood.LIKELY,  # 'ã'
        22: SequenceLikelihood.LIKELY,  # 'ç'
        25: SequenceLikelihood.LIKELY,  # 'é'
        42: SequenceLikelihood.POSITIVE,  # 'ê'
        32: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ó'
        59: SequenceLikelihood.LIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    7: {  # 'd'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.POSITIVE,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.LIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.LIKELY,  # 'é'
        42: SequenceLikelihood.POSITIVE,  # 'ê'
        32: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.LIKELY,  # 'ú'
    },
    2: {  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.POSITIVE,  # 'j'
        51: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.LIKELY,  # 'w'
        33: SequenceLikelihood.POSITIVE,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.LIKELY,  # 'ã'
        22: SequenceLikelihood.POSITIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.LIKELY,  # 'ú'
    },
    17: {  # 'f'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.LIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.LIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.LIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    16: {  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        9: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.LIKELY,  # 'á'
        57: SequenceLikelihood.LIKELY,  # 'â'
        20: SequenceLikelihood.LIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.LIKELY,  # 'é'
        42: SequenceLikelihood.POSITIVE,  # 'ê'
        32: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    21: {  # 'h'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.POSITIVE,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.POSITIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.POSITIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    6: {  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        34: SequenceLikelihood.LIKELY,  # 'j'
        51: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.POSITIVE,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.POSITIVE,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.POSITIVE,  # 'ã'
        22: SequenceLikelihood.POSITIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.POSITIVE,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.LIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    34: {  # 'j'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.POSITIVE,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    51: {  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    13: {  # 'l'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.POSITIVE,  # 'á'
        57: SequenceLikelihood.LIKELY,  # 'â'
        20: SequenceLikelihood.LIKELY,  # 'ã'
        22: SequenceLikelihood.LIKELY,  # 'ç'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        42: SequenceLikelihood.LIKELY,  # 'ê'
        32: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.POSITIVE,  # 'ó'
        59: SequenceLikelihood.LIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.LIKELY,  # 'ú'
    },
    10: {  # 'm'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.POSITIVE,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.POSITIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        42: SequenceLikelihood.LIKELY,  # 'ê'
        32: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.POSITIVE,  # 'ó'
        59: SequenceLikelihood.LIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.LIKELY,  # 'ú'
    },
    8: {  # 'n'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.POSITIVE,  # 'j'
        51: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.LIKELY,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.POSITIVE,  # 'á'
        57: SequenceLikelihood.LIKELY,  # 'â'
        20: SequenceLikelihood.POSITIVE,  # 'ã'
        22: SequenceLikelihood.POSITIVE,  # 'ç'
        25: SequenceLikelihood.LIKELY,  # 'é'
        42: SequenceLikelihood.LIKELY,  # 'ê'
        32: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.POSITIVE,  # 'ó'
        59: SequenceLikelihood.LIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    3: {  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.POSITIVE,  # 'j'
        51: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.POSITIVE,  # 'w'
        33: SequenceLikelihood.POSITIVE,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.LIKELY,  # 'ã'
        22: SequenceLikelihood.POSITIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    14: {  # 'p'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        7: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.LIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.LIKELY,  # 'ã'
        22: SequenceLikelihood.POSITIVE,  # 'ç'
        25: SequenceLikelihood.LIKELY,  # 'é'
        42: SequenceLikelihood.LIKELY,  # 'ê'
        32: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.POSITIVE,  # 'ó'
        59: SequenceLikelihood.LIKELY,  # 'ô'
        46: SequenceLikelihood.LIKELY,  # 'õ'
        48: SequenceLikelihood.POSITIVE,  # 'ú'
    },
    19: {  # 'q'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    5: {  # 'r'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.POSITIVE,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.POSITIVE,  # 'á'
        57: SequenceLikelihood.LIKELY,  # 'â'
        20: SequenceLikelihood.POSITIVE,  # 'ã'
        22: SequenceLikelihood.POSITIVE,  # 'ç'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        42: SequenceLikelihood.POSITIVE,  # 'ê'
        32: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.POSITIVE,  # 'ó'
        59: SequenceLikelihood.LIKELY,  # 'ô'
        46: SequenceLikelihood.LIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    4: {  # 's'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.POSITIVE,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.POSITIVE,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.POSITIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        42: SequenceLikelihood.LIKELY,  # 'ê'
        32: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.POSITIVE,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.POSITIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    9: {  # 't'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.LIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.LIKELY,  # 'y'
        28: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.POSITIVE,  # 'á'
        57: SequenceLikelihood.POSITIVE,  # 'â'
        20: SequenceLikelihood.POSITIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        42: SequenceLikelihood.POSITIVE,  # 'ê'
        32: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.POSITIVE,  # 'ó'
        59: SequenceLikelihood.LIKELY,  # 'ô'
        46: SequenceLikelihood.LIKELY,  # 'õ'
        48: SequenceLikelihood.LIKELY,  # 'ú'
    },
    11: {  # 'u'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.LIKELY,  # 'j'
        51: SequenceLikelihood.LIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.POSITIVE,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.POSITIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.LIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.POSITIVE,  # 'ç'
        25: SequenceLikelihood.LIKELY,  # 'é'
        42: SequenceLikelihood.POSITIVE,  # 'ê'
        32: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    15: {  # 'v'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.POSITIVE,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.LIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.POSITIVE,  # 'é'
        42: SequenceLikelihood.LIKELY,  # 'ê'
        32: SequenceLikelihood.POSITIVE,  # 'í'
        41: SequenceLikelihood.LIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    56: {  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.LIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.UNLIKELY,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    33: {  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.LIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.LIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    53: {  # 'y'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        9: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    28: {  # 'z'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.UNLIKELY,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.LIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    72: {  # 'À'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        43: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        34: SequenceLikelihood.NEGATIVE,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.NEGATIVE,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.NEGATIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.NEGATIVE,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    66: {  # 'Á'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    75: {  # 'Â'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        43: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        34: SequenceLikelihood.NEGATIVE,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.NEGATIVE,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.NEGATIVE,  # 'u'
        15: SequenceLikelihood.NEGATIVE,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.NEGATIVE,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    67: {  # 'Ã'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        34: SequenceLikelihood.NEGATIVE,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.NEGATIVE,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.NEGATIVE,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    68: {  # 'Ç'
        23: SequenceLikelihood.LIKELY,  # 'A'
        43: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        7: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.NEGATIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.NEGATIVE,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.NEGATIVE,  # 'l'
        10: SequenceLikelihood.NEGATIVE,  # 'm'
        8: SequenceLikelihood.NEGATIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.NEGATIVE,  # 'r'
        4: SequenceLikelihood.NEGATIVE,  # 's'
        9: SequenceLikelihood.NEGATIVE,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.NEGATIVE,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.NEGATIVE,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.UNLIKELY,  # 'Á'
        75: SequenceLikelihood.UNLIKELY,  # 'Â'
        67: SequenceLikelihood.LIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    62: {  # 'É'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.NEGATIVE,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.UNLIKELY,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    73: {  # 'Ê'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.NEGATIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.NEGATIVE,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.NEGATIVE,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    69: {  # 'Í'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.NEGATIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.NEGATIVE,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    70: {  # 'Ó'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.NEGATIVE,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.NEGATIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    76: {  # 'Ô'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.NEGATIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        34: SequenceLikelihood.NEGATIVE,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.NEGATIVE,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.NEGATIVE,  # 'r'
        4: SequenceLikelihood.NEGATIVE,  # 's'
        9: SequenceLikelihood.NEGATIVE,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.NEGATIVE,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.UNLIKELY,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    74: {  # 'Õ'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        40: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        7: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.NEGATIVE,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        34: SequenceLikelihood.NEGATIVE,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.NEGATIVE,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.NEGATIVE,  # 'n'
        3: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.NEGATIVE,  # 's'
        9: SequenceLikelihood.NEGATIVE,  # 't'
        11: SequenceLikelihood.NEGATIVE,  # 'u'
        15: SequenceLikelihood.NEGATIVE,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.NEGATIVE,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    71: {  # 'Ú'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.NEGATIVE,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.NEGATIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.NEGATIVE,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    55: {  # 'à'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.NEGATIVE,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.NEGATIVE,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    24: {  # 'á'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.LIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    57: {  # 'â'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        43: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        31: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        40: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.NEGATIVE,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.NEGATIVE,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.NEGATIVE,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    20: {  # 'ã'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    22: {  # 'ç'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        40: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.NEGATIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.UNLIKELY,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.UNLIKELY,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.UNLIKELY,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.POSITIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.POSITIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
    25: {  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.LIKELY,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.UNLIKELY,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.UNLIKELY,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.UNLIKELY,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    42: {  # 'ê'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    32: {  # 'í'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.LIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.POSITIVE,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.LIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    41: {  # 'ó'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.UNLIKELY,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        7: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.POSITIVE,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.UNLIKELY,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.UNLIKELY,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.UNLIKELY,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    59: {  # 'ô'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        43: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        40: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        9: SequenceLikelihood.UNLIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.UNLIKELY,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.UNLIKELY,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.NEGATIVE,  # 'ç'
        25: SequenceLikelihood.NEGATIVE,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.UNLIKELY,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    46: {  # 'õ'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        43: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        31: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        40: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        49: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        7: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.NEGATIVE,  # 'j'
        51: SequenceLikelihood.NEGATIVE,  # 'k'
        13: SequenceLikelihood.UNLIKELY,  # 'l'
        10: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        9: SequenceLikelihood.NEGATIVE,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.NEGATIVE,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.NEGATIVE,  # 'ê'
        32: SequenceLikelihood.NEGATIVE,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.UNLIKELY,  # 'õ'
        48: SequenceLikelihood.NEGATIVE,  # 'ú'
    },
    48: {  # 'ú'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        43: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        38: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        61: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        31: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        40: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        49: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        63: SequenceLikelihood.NEGATIVE,  # 'X'
        65: SequenceLikelihood.NEGATIVE,  # 'Y'
        64: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        7: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        21: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'j'
        51: SequenceLikelihood.UNLIKELY,  # 'k'
        13: SequenceLikelihood.POSITIVE,  # 'l'
        10: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        3: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        19: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        9: SequenceLikelihood.LIKELY,  # 't'
        11: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        33: SequenceLikelihood.UNLIKELY,  # 'x'
        53: SequenceLikelihood.NEGATIVE,  # 'y'
        28: SequenceLikelihood.UNLIKELY,  # 'z'
        72: SequenceLikelihood.NEGATIVE,  # 'À'
        66: SequenceLikelihood.NEGATIVE,  # 'Á'
        75: SequenceLikelihood.NEGATIVE,  # 'Â'
        67: SequenceLikelihood.NEGATIVE,  # 'Ã'
        68: SequenceLikelihood.NEGATIVE,  # 'Ç'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        73: SequenceLikelihood.NEGATIVE,  # 'Ê'
        69: SequenceLikelihood.NEGATIVE,  # 'Í'
        70: SequenceLikelihood.NEGATIVE,  # 'Ó'
        76: SequenceLikelihood.NEGATIVE,  # 'Ô'
        74: SequenceLikelihood.NEGATIVE,  # 'Õ'
        71: SequenceLikelihood.NEGATIVE,  # 'Ú'
        55: SequenceLikelihood.NEGATIVE,  # 'à'
        24: SequenceLikelihood.UNLIKELY,  # 'á'
        57: SequenceLikelihood.NEGATIVE,  # 'â'
        20: SequenceLikelihood.NEGATIVE,  # 'ã'
        22: SequenceLikelihood.UNLIKELY,  # 'ç'
        25: SequenceLikelihood.UNLIKELY,  # 'é'
        42: SequenceLikelihood.UNLIKELY,  # 'ê'
        32: SequenceLikelihood.UNLIKELY,  # 'í'
        41: SequenceLikelihood.NEGATIVE,  # 'ó'
        59: SequenceLikelihood.NEGATIVE,  # 'ô'
        46: SequenceLikelihood.NEGATIVE,  # 'õ'
        48: SequenceLikelihood.UNLIKELY,  # 'ú'
    },
}

# Character Mapping Table(s):
CP037_PORTUGUESE_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 57,  # 'â'
    67: 0,  # 'ä'
    68: 55,  # 'à'
    69: 24,  # 'á'
    70: 20,  # 'ã'
    71: 0,  # 'å'
    72: 22,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 25,  # 'é'
    82: 42,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 32,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 75,  # 'Â'
    99: 0,  # 'Ä'
    100: 72,  # 'À'
    101: 66,  # 'Á'
    102: 67,  # 'Ã'
    103: 0,  # 'Å'
    104: 68,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 62,  # 'É'
    114: 73,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 69,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 18,  # 'b'
    131: 12,  # 'c'
    132: 7,  # 'd'
    133: 2,  # 'e'
    134: 17,  # 'f'
    135: 16,  # 'g'
    136: 21,  # 'h'
    137: 6,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 34,  # 'j'
    146: 51,  # 'k'
    147: 13,  # 'l'
    148: 10,  # 'm'
    149: 8,  # 'n'
    150: 3,  # 'o'
    151: 14,  # 'p'
    152: 19,  # 'q'
    153: 5,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 4,  # 's'
    163: 9,  # 't'
    164: 11,  # 'u'
    165: 15,  # 'v'
    166: 56,  # 'w'
    167: 33,  # 'x'
    168: 53,  # 'y'
    169: 28,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 23,  # 'A'
    194: 43,  # 'B'
    195: 26,  # 'C'
    196: 37,  # 'D'
    197: 27,  # 'E'
    198: 44,  # 'F'
    199: 47,  # 'G'
    200: 54,  # 'H'
    201: 38,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 59,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 41,  # 'ó'
    207: 46,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 52,  # 'J'
    210: 61,  # 'K'
    211: 45,  # 'L'
    212: 35,  # 'M'
    213: 39,  # 'N'
    214: 31,  # 'O'
    215: 30,  # 'P'
    216: 58,  # 'Q'
    217: 36,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 0,  # 'ù'
    222: 48,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 29,  # 'S'
    227: 40,  # 'T'
    228: 50,  # 'U'
    229: 49,  # 'V'
    230: 60,  # 'W'
    231: 63,  # 'X'
    232: 65,  # 'Y'
    233: 64,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 76,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 70,  # 'Ó'
    239: 74,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 0,  # 'Ù'
    254: 71,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP037_PORTUGUESE_MODEL = SingleByteCharSetModel(
    charset_name="CP037",
    language="Portuguese",
    char_to_order_map=CP037_PORTUGUESE_CHAR_TO_ORDER,
    language_model=PORTUGUESE_LANG_MODEL,
    typical_positive_ratio=0.9702544244301395,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÁÂÃÇÉÊÍÓÔÕÚàáâãçéêíóôõú",
)

CP437_PORTUGUESE_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 43,  # 'B'
    67: 26,  # 'C'
    68: 37,  # 'D'
    69: 27,  # 'E'
    70: 44,  # 'F'
    71: 47,  # 'G'
    72: 54,  # 'H'
    73: 38,  # 'I'
    74: 52,  # 'J'
    75: 61,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 39,  # 'N'
    79: 31,  # 'O'
    80: 30,  # 'P'
    81: 58,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 40,  # 'T'
    85: 50,  # 'U'
    86: 49,  # 'V'
    87: 60,  # 'W'
    88: 63,  # 'X'
    89: 65,  # 'Y'
    90: 64,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 12,  # 'c'
    100: 7,  # 'd'
    101: 2,  # 'e'
    102: 17,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 6,  # 'i'
    106: 34,  # 'j'
    107: 51,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 8,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 5,  # 'r'
    115: 4,  # 's'
    116: 9,  # 't'
    117: 11,  # 'u'
    118: 15,  # 'v'
    119: 56,  # 'w'
    120: 33,  # 'x'
    121: 53,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 68,  # 'Ç'
    129: 0,  # 'ü'
    130: 25,  # 'é'
    131: 57,  # 'â'
    132: 0,  # 'ä'
    133: 55,  # 'à'
    134: 0,  # 'å'
    135: 22,  # 'ç'
    136: 42,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 62,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 59,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 24,  # 'á'
    161: 32,  # 'í'
    162: 41,  # 'ó'
    163: 48,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP437_PORTUGUESE_MODEL = SingleByteCharSetModel(
    charset_name="CP437",
    language="Portuguese",
    char_to_order_map=CP437_PORTUGUESE_CHAR_TO_ORDER,
    language_model=PORTUGUESE_LANG_MODEL,
    typical_positive_ratio=0.9711390800816553,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÁÂÃÇÉÊÍÓÔÕÚàáâãçéêíóôõú",
)

CP500_PORTUGUESE_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 57,  # 'â'
    67: 0,  # 'ä'
    68: 55,  # 'à'
    69: 24,  # 'á'
    70: 20,  # 'ã'
    71: 0,  # 'å'
    72: 22,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 25,  # 'é'
    82: 42,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 32,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 75,  # 'Â'
    99: 0,  # 'Ä'
    100: 72,  # 'À'
    101: 66,  # 'Á'
    102: 67,  # 'Ã'
    103: 0,  # 'Å'
    104: 68,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 62,  # 'É'
    114: 73,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 69,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 18,  # 'b'
    131: 12,  # 'c'
    132: 7,  # 'd'
    133: 2,  # 'e'
    134: 17,  # 'f'
    135: 16,  # 'g'
    136: 21,  # 'h'
    137: 6,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 34,  # 'j'
    146: 51,  # 'k'
    147: 13,  # 'l'
    148: 10,  # 'm'
    149: 8,  # 'n'
    150: 3,  # 'o'
    151: 14,  # 'p'
    152: 19,  # 'q'
    153: 5,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 4,  # 's'
    163: 9,  # 't'
    164: 11,  # 'u'
    165: 15,  # 'v'
    166: 56,  # 'w'
    167: 33,  # 'x'
    168: 53,  # 'y'
    169: 28,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 23,  # 'A'
    194: 43,  # 'B'
    195: 26,  # 'C'
    196: 37,  # 'D'
    197: 27,  # 'E'
    198: 44,  # 'F'
    199: 47,  # 'G'
    200: 54,  # 'H'
    201: 38,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 59,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 41,  # 'ó'
    207: 46,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 52,  # 'J'
    210: 61,  # 'K'
    211: 45,  # 'L'
    212: 35,  # 'M'
    213: 39,  # 'N'
    214: 31,  # 'O'
    215: 30,  # 'P'
    216: 58,  # 'Q'
    217: 36,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 0,  # 'ù'
    222: 48,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 29,  # 'S'
    227: 40,  # 'T'
    228: 50,  # 'U'
    229: 49,  # 'V'
    230: 60,  # 'W'
    231: 63,  # 'X'
    232: 65,  # 'Y'
    233: 64,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 76,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 70,  # 'Ó'
    239: 74,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 0,  # 'Ù'
    254: 71,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP500_PORTUGUESE_MODEL = SingleByteCharSetModel(
    charset_name="CP500",
    language="Portuguese",
    char_to_order_map=CP500_PORTUGUESE_CHAR_TO_ORDER,
    language_model=PORTUGUESE_LANG_MODEL,
    typical_positive_ratio=0.9702544244301395,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÁÂÃÇÉÊÍÓÔÕÚàáâãçéêíóôõú",
)

CP850_PORTUGUESE_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 43,  # 'B'
    67: 26,  # 'C'
    68: 37,  # 'D'
    69: 27,  # 'E'
    70: 44,  # 'F'
    71: 47,  # 'G'
    72: 54,  # 'H'
    73: 38,  # 'I'
    74: 52,  # 'J'
    75: 61,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 39,  # 'N'
    79: 31,  # 'O'
    80: 30,  # 'P'
    81: 58,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 40,  # 'T'
    85: 50,  # 'U'
    86: 49,  # 'V'
    87: 60,  # 'W'
    88: 63,  # 'X'
    89: 65,  # 'Y'
    90: 64,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 12,  # 'c'
    100: 7,  # 'd'
    101: 2,  # 'e'
    102: 17,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 6,  # 'i'
    106: 34,  # 'j'
    107: 51,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 8,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 5,  # 'r'
    115: 4,  # 's'
    116: 9,  # 't'
    117: 11,  # 'u'
    118: 15,  # 'v'
    119: 56,  # 'w'
    120: 33,  # 'x'
    121: 53,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 68,  # 'Ç'
    129: 0,  # 'ü'
    130: 25,  # 'é'
    131: 57,  # 'â'
    132: 0,  # 'ä'
    133: 55,  # 'à'
    134: 0,  # 'å'
    135: 22,  # 'ç'
    136: 42,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 62,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 59,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 24,  # 'á'
    161: 32,  # 'í'
    162: 41,  # 'ó'
    163: 48,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 66,  # 'Á'
    182: 75,  # 'Â'
    183: 72,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 20,  # 'ã'
    199: 67,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 73,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: 0,  # 'ı'
    214: 69,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 70,  # 'Ó'
    225: 0,  # 'ß'
    226: 76,  # 'Ô'
    227: 0,  # 'Ò'
    228: 46,  # 'õ'
    229: 74,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 71,  # 'Ú'
    234: 0,  # 'Û'
    235: 0,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP850_PORTUGUESE_MODEL = SingleByteCharSetModel(
    charset_name="CP850",
    language="Portuguese",
    char_to_order_map=CP850_PORTUGUESE_CHAR_TO_ORDER,
    language_model=PORTUGUESE_LANG_MODEL,
    typical_positive_ratio=0.9702544244301395,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÁÂÃÇÉÊÍÓÔÕÚàáâãçéêíóôõú",
)

CP858_PORTUGUESE_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 43,  # 'B'
    67: 26,  # 'C'
    68: 37,  # 'D'
    69: 27,  # 'E'
    70: 44,  # 'F'
    71: 47,  # 'G'
    72: 54,  # 'H'
    73: 38,  # 'I'
    74: 52,  # 'J'
    75: 61,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 39,  # 'N'
    79: 31,  # 'O'
    80: 30,  # 'P'
    81: 58,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 40,  # 'T'
    85: 50,  # 'U'
    86: 49,  # 'V'
    87: 60,  # 'W'
    88: 63,  # 'X'
    89: 65,  # 'Y'
    90: 64,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 12,  # 'c'
    100: 7,  # 'd'
    101: 2,  # 'e'
    102: 17,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 6,  # 'i'
    106: 34,  # 'j'
    107: 51,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 8,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 5,  # 'r'
    115: 4,  # 's'
    116: 9,  # 't'
    117: 11,  # 'u'
    118: 15,  # 'v'
    119: 56,  # 'w'
    120: 33,  # 'x'
    121: 53,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 68,  # 'Ç'
    129: 0,  # 'ü'
    130: 25,  # 'é'
    131: 57,  # 'â'
    132: 0,  # 'ä'
    133: 55,  # 'à'
    134: 0,  # 'å'
    135: 22,  # 'ç'
    136: 42,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 62,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 59,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 24,  # 'á'
    161: 32,  # 'í'
    162: 41,  # 'ó'
    163: 48,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 66,  # 'Á'
    182: 75,  # 'Â'
    183: 72,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 20,  # 'ã'
    199: 67,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 73,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: CharacterCategory.SYMBOL,  # '€'
    214: 69,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 70,  # 'Ó'
    225: 0,  # 'ß'
    226: 76,  # 'Ô'
    227: 0,  # 'Ò'
    228: 46,  # 'õ'
    229: 74,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 71,  # 'Ú'
    234: 0,  # 'Û'
    235: 0,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP858_PORTUGUESE_MODEL = SingleByteCharSetModel(
    charset_name="CP858",
    language="Portuguese",
    char_to_order_map=CP858_PORTUGUESE_CHAR_TO_ORDER,
    language_model=PORTUGUESE_LANG_MODEL,
    typical_positive_ratio=0.9702544244301395,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÁÂÃÇÉÊÍÓÔÕÚàáâãçéêíóôõú",
)

CP860_PORTUGUESE_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 43,  # 'B'
    67: 26,  # 'C'
    68: 37,  # 'D'
    69: 27,  # 'E'
    70: 44,  # 'F'
    71: 47,  # 'G'
    72: 54,  # 'H'
    73: 38,  # 'I'
    74: 52,  # 'J'
    75: 61,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 39,  # 'N'
    79: 31,  # 'O'
    80: 30,  # 'P'
    81: 58,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 40,  # 'T'
    85: 50,  # 'U'
    86: 49,  # 'V'
    87: 60,  # 'W'
    88: 63,  # 'X'
    89: 65,  # 'Y'
    90: 64,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 12,  # 'c'
    100: 7,  # 'd'
    101: 2,  # 'e'
    102: 17,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 6,  # 'i'
    106: 34,  # 'j'
    107: 51,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 8,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 5,  # 'r'
    115: 4,  # 's'
    116: 9,  # 't'
    117: 11,  # 'u'
    118: 15,  # 'v'
    119: 56,  # 'w'
    120: 33,  # 'x'
    121: 53,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 68,  # 'Ç'
    129: 0,  # 'ü'
    130: 25,  # 'é'
    131: 57,  # 'â'
    132: 20,  # 'ã'
    133: 55,  # 'à'
    134: 66,  # 'Á'
    135: 22,  # 'ç'
    136: 42,  # 'ê'
    137: 73,  # 'Ê'
    138: 0,  # 'è'
    139: 69,  # 'Í'
    140: 76,  # 'Ô'
    141: 0,  # 'ì'
    142: 67,  # 'Ã'
    143: 75,  # 'Â'
    144: 62,  # 'É'
    145: 72,  # 'À'
    146: 0,  # 'È'
    147: 59,  # 'ô'
    148: 46,  # 'õ'
    149: 0,  # 'ò'
    150: 71,  # 'Ú'
    151: 0,  # 'ù'
    152: 0,  # 'Ì'
    153: 74,  # 'Õ'
    154: 0,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ù'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 70,  # 'Ó'
    160: 24,  # 'á'
    161: 32,  # 'í'
    162: 41,  # 'ó'
    163: 48,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: 0,  # 'Ò'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP860_PORTUGUESE_MODEL = SingleByteCharSetModel(
    charset_name="CP860",
    language="Portuguese",
    char_to_order_map=CP860_PORTUGUESE_CHAR_TO_ORDER,
    language_model=PORTUGUESE_LANG_MODEL,
    typical_positive_ratio=0.9702544244301395,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÁÂÃÇÉÊÍÓÔÕÚàáâãçéêíóôõú",
)

ISO_8859_1_PORTUGUESE_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 43,  # 'B'
    67: 26,  # 'C'
    68: 37,  # 'D'
    69: 27,  # 'E'
    70: 44,  # 'F'
    71: 47,  # 'G'
    72: 54,  # 'H'
    73: 38,  # 'I'
    74: 52,  # 'J'
    75: 61,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 39,  # 'N'
    79: 31,  # 'O'
    80: 30,  # 'P'
    81: 58,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 40,  # 'T'
    85: 50,  # 'U'
    86: 49,  # 'V'
    87: 60,  # 'W'
    88: 63,  # 'X'
    89: 65,  # 'Y'
    90: 64,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 12,  # 'c'
    100: 7,  # 'd'
    101: 2,  # 'e'
    102: 17,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 6,  # 'i'
    106: 34,  # 'j'
    107: 51,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 8,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 5,  # 'r'
    115: 4,  # 's'
    116: 9,  # 't'
    117: 11,  # 'u'
    118: 15,  # 'v'
    119: 56,  # 'w'
    120: 33,  # 'x'
    121: 53,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 72,  # 'À'
    193: 66,  # 'Á'
    194: 75,  # 'Â'
    195: 67,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 68,  # 'Ç'
    200: 0,  # 'È'
    201: 62,  # 'É'
    202: 73,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 69,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 70,  # 'Ó'
    212: 76,  # 'Ô'
    213: 74,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 71,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 55,  # 'à'
    225: 24,  # 'á'
    226: 57,  # 'â'
    227: 20,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 22,  # 'ç'
    232: 0,  # 'è'
    233: 25,  # 'é'
    234: 42,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 32,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 41,  # 'ó'
    244: 59,  # 'ô'
    245: 46,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 48,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_1_PORTUGUESE_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-1",
    language="Portuguese",
    char_to_order_map=ISO_8859_1_PORTUGUESE_CHAR_TO_ORDER,
    language_model=PORTUGUESE_LANG_MODEL,
    typical_positive_ratio=0.9702544244301395,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÁÂÃÇÉÊÍÓÔÕÚàáâãçéêíóôõú",
)

ISO_8859_15_PORTUGUESE_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 43,  # 'B'
    67: 26,  # 'C'
    68: 37,  # 'D'
    69: 27,  # 'E'
    70: 44,  # 'F'
    71: 47,  # 'G'
    72: 54,  # 'H'
    73: 38,  # 'I'
    74: 52,  # 'J'
    75: 61,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 39,  # 'N'
    79: 31,  # 'O'
    80: 30,  # 'P'
    81: 58,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 40,  # 'T'
    85: 50,  # 'U'
    86: 49,  # 'V'
    87: 60,  # 'W'
    88: 63,  # 'X'
    89: 65,  # 'Y'
    90: 64,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 12,  # 'c'
    100: 7,  # 'd'
    101: 2,  # 'e'
    102: 17,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 6,  # 'i'
    106: 34,  # 'j'
    107: 51,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 8,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 5,  # 'r'
    115: 4,  # 's'
    116: 9,  # 't'
    117: 11,  # 'u'
    118: 15,  # 'v'
    119: 56,  # 'w'
    120: 33,  # 'x'
    121: 53,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: 0,  # 'Ž'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 72,  # 'À'
    193: 66,  # 'Á'
    194: 75,  # 'Â'
    195: 67,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 68,  # 'Ç'
    200: 0,  # 'È'
    201: 62,  # 'É'
    202: 73,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 69,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 70,  # 'Ó'
    212: 76,  # 'Ô'
    213: 74,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 71,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 55,  # 'à'
    225: 24,  # 'á'
    226: 57,  # 'â'
    227: 20,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 22,  # 'ç'
    232: 0,  # 'è'
    233: 25,  # 'é'
    234: 42,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 32,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 41,  # 'ó'
    244: 59,  # 'ô'
    245: 46,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 48,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_15_PORTUGUESE_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-15",
    language="Portuguese",
    char_to_order_map=ISO_8859_15_PORTUGUESE_CHAR_TO_ORDER,
    language_model=PORTUGUESE_LANG_MODEL,
    typical_positive_ratio=0.9702544244301395,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÁÂÃÇÉÊÍÓÔÕÚàáâãçéêíóôõú",
)

MACROMAN_PORTUGUESE_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 43,  # 'B'
    67: 26,  # 'C'
    68: 37,  # 'D'
    69: 27,  # 'E'
    70: 44,  # 'F'
    71: 47,  # 'G'
    72: 54,  # 'H'
    73: 38,  # 'I'
    74: 52,  # 'J'
    75: 61,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 39,  # 'N'
    79: 31,  # 'O'
    80: 30,  # 'P'
    81: 58,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 40,  # 'T'
    85: 50,  # 'U'
    86: 49,  # 'V'
    87: 60,  # 'W'
    88: 63,  # 'X'
    89: 65,  # 'Y'
    90: 64,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 12,  # 'c'
    100: 7,  # 'd'
    101: 2,  # 'e'
    102: 17,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 6,  # 'i'
    106: 34,  # 'j'
    107: 51,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 8,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 5,  # 'r'
    115: 4,  # 's'
    116: 9,  # 't'
    117: 11,  # 'u'
    118: 15,  # 'v'
    119: 56,  # 'w'
    120: 33,  # 'x'
    121: 53,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Å'
    130: 68,  # 'Ç'
    131: 62,  # 'É'
    132: 0,  # 'Ñ'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 24,  # 'á'
    136: 55,  # 'à'
    137: 57,  # 'â'
    138: 0,  # 'ä'
    139: 20,  # 'ã'
    140: 0,  # 'å'
    141: 22,  # 'ç'
    142: 25,  # 'é'
    143: 0,  # 'è'
    144: 42,  # 'ê'
    145: 0,  # 'ë'
    146: 32,  # 'í'
    147: 0,  # 'ì'
    148: 0,  # 'î'
    149: 0,  # 'ï'
    150: 0,  # 'ñ'
    151: 41,  # 'ó'
    152: 0,  # 'ò'
    153: 59,  # 'ô'
    154: 0,  # 'ö'
    155: 46,  # 'õ'
    156: 48,  # 'ú'
    157: 0,  # 'ù'
    158: 0,  # 'û'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 0,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 72,  # 'À'
    204: 67,  # 'Ã'
    205: 74,  # 'Õ'
    206: 0,  # 'Œ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ÿ'
    217: 0,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ﬁ'
    223: 0,  # 'ﬂ'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 75,  # 'Â'
    230: 73,  # 'Ê'
    231: 66,  # 'Á'
    232: 0,  # 'Ë'
    233: 0,  # 'È'
    234: 69,  # 'Í'
    235: 0,  # 'Î'
    236: 0,  # 'Ï'
    237: 0,  # 'Ì'
    238: 70,  # 'Ó'
    239: 76,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 0,  # 'Ò'
    242: 71,  # 'Ú'
    243: 0,  # 'Û'
    244: 0,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACROMAN_PORTUGUESE_MODEL = SingleByteCharSetModel(
    charset_name="MacRoman",
    language="Portuguese",
    char_to_order_map=MACROMAN_PORTUGUESE_CHAR_TO_ORDER,
    language_model=PORTUGUESE_LANG_MODEL,
    typical_positive_ratio=0.9702544244301395,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÁÂÃÇÉÊÍÓÔÕÚàáâãçéêíóôõú",
)

WINDOWS_1252_PORTUGUESE_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 43,  # 'B'
    67: 26,  # 'C'
    68: 37,  # 'D'
    69: 27,  # 'E'
    70: 44,  # 'F'
    71: 47,  # 'G'
    72: 54,  # 'H'
    73: 38,  # 'I'
    74: 52,  # 'J'
    75: 61,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 39,  # 'N'
    79: 31,  # 'O'
    80: 30,  # 'P'
    81: 58,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 40,  # 'T'
    85: 50,  # 'U'
    86: 49,  # 'V'
    87: 60,  # 'W'
    88: 63,  # 'X'
    89: 65,  # 'Y'
    90: 64,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 18,  # 'b'
    99: 12,  # 'c'
    100: 7,  # 'd'
    101: 2,  # 'e'
    102: 17,  # 'f'
    103: 16,  # 'g'
    104: 21,  # 'h'
    105: 6,  # 'i'
    106: 34,  # 'j'
    107: 51,  # 'k'
    108: 13,  # 'l'
    109: 10,  # 'm'
    110: 8,  # 'n'
    111: 3,  # 'o'
    112: 14,  # 'p'
    113: 19,  # 'q'
    114: 5,  # 'r'
    115: 4,  # 's'
    116: 9,  # 't'
    117: 11,  # 'u'
    118: 15,  # 'v'
    119: 56,  # 'w'
    120: 33,  # 'x'
    121: 53,  # 'y'
    122: 28,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: 0,  # 'Ž'
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: 0,  # 'ž'
    159: 0,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 72,  # 'À'
    193: 66,  # 'Á'
    194: 75,  # 'Â'
    195: 67,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 68,  # 'Ç'
    200: 0,  # 'È'
    201: 62,  # 'É'
    202: 73,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 69,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 70,  # 'Ó'
    212: 76,  # 'Ô'
    213: 74,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 71,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 55,  # 'à'
    225: 24,  # 'á'
    226: 57,  # 'â'
    227: 20,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 22,  # 'ç'
    232: 0,  # 'è'
    233: 25,  # 'é'
    234: 42,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 32,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 41,  # 'ó'
    244: 59,  # 'ô'
    245: 46,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 48,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

WINDOWS_1252_PORTUGUESE_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1252",
    language="Portuguese",
    char_to_order_map=WINDOWS_1252_PORTUGUESE_CHAR_TO_ORDER,
    language_model=PORTUGUESE_LANG_MODEL,
    typical_positive_ratio=0.9702544244301395,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÁÂÃÇÉÊÍÓÔÕÚàáâãçéêíóôõú",
)
