from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

TAJIK_LANG_MODEL = {
    65: {  # 'Ё'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.NEGATIVE,  # 'э'
        51: SequenceLikelihood.NEGATIVE,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.NEGATIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.NEGATIVE,  # 'ӯ'
    },
    32: {  # 'А'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.LIKELY,  # 'Б'
        44: SequenceLikelihood.LIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.LIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.LIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.LIKELY,  # 'К'
        60: SequenceLikelihood.LIKELY,  # 'Л'
        33: SequenceLikelihood.LIKELY,  # 'М'
        45: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        39: SequenceLikelihood.LIKELY,  # 'С'
        34: SequenceLikelihood.LIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.LIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.POSITIVE,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.LIKELY,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.LIKELY,  # 'Ҳ'
        12: SequenceLikelihood.LIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    36: {  # 'Б'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.LIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    44: {  # 'В'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.LIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.NEGATIVE,  # 'ӯ'
    },
    56: {  # 'Г'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.NEGATIVE,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    35: {  # 'Д'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.LIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.LIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.LIKELY,  # 'Т'
        54: SequenceLikelihood.LIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    63: {  # 'Е'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.NEGATIVE,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.NEGATIVE,  # 'ӯ'
    },
    69: {  # 'Ж'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.NEGATIVE,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        49: SequenceLikelihood.NEGATIVE,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.NEGATIVE,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.NEGATIVE,  # 'м'
        5: SequenceLikelihood.NEGATIVE,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        8: SequenceLikelihood.NEGATIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.NEGATIVE,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.NEGATIVE,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.NEGATIVE,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.NEGATIVE,  # 'ҳ'
        50: SequenceLikelihood.NEGATIVE,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.NEGATIVE,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    55: {  # 'З'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.NEGATIVE,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    37: {  # 'И'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.LIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.LIKELY,  # 'К'
        60: SequenceLikelihood.LIKELY,  # 'Л'
        33: SequenceLikelihood.LIKELY,  # 'М'
        45: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        39: SequenceLikelihood.LIKELY,  # 'С'
        34: SequenceLikelihood.LIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.LIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.LIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.LIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.LIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.LIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    68: {  # 'Й'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.NEGATIVE,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.NEGATIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.NEGATIVE,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.NEGATIVE,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.NEGATIVE,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.NEGATIVE,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.NEGATIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    43: {  # 'К'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.LIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    60: {  # 'Л'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    33: {  # 'М'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.LIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.LIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.LIKELY,  # 'Т'
        54: SequenceLikelihood.LIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    45: {  # 'Н'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.LIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.LIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.NEGATIVE,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.LIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    41: {  # 'О'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.LIKELY,  # 'Б'
        44: SequenceLikelihood.LIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.LIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.LIKELY,  # 'Л'
        33: SequenceLikelihood.LIKELY,  # 'М'
        45: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.LIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.LIKELY,  # 'қ'
        42: SequenceLikelihood.LIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.NEGATIVE,  # 'ӯ'
    },
    46: {  # 'П'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.NEGATIVE,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    40: {  # 'Р'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    39: {  # 'С'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.LIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.LIKELY,  # 'С'
        34: SequenceLikelihood.LIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    34: {  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    54: {  # 'У'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.LIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.LIKELY,  # 'М'
        45: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.LIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.NEGATIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.NEGATIVE,  # 'ӯ'
    },
    53: {  # 'Ф'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    49: {  # 'Х'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.LIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    59: {  # 'Ч'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.LIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    48: {  # 'Ш'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.NEGATIVE,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    70: {  # 'Ъ'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.NEGATIVE,  # 'в'
        19: SequenceLikelihood.NEGATIVE,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        14: SequenceLikelihood.NEGATIVE,  # 'л'
        7: SequenceLikelihood.NEGATIVE,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        8: SequenceLikelihood.NEGATIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.NEGATIVE,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.NEGATIVE,  # 'э'
        51: SequenceLikelihood.NEGATIVE,  # 'ю'
        25: SequenceLikelihood.NEGATIVE,  # 'я'
        29: SequenceLikelihood.NEGATIVE,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.NEGATIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.NEGATIVE,  # 'ӯ'
    },
    57: {  # 'Э'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.LIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.LIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.NEGATIVE,  # 'ӯ'
    },
    66: {  # 'Ю'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.NEGATIVE,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.NEGATIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.NEGATIVE,  # 'ӯ'
    },
    61: {  # 'Я'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.NEGATIVE,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.NEGATIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.NEGATIVE,  # 'ӯ'
    },
    1: {  # 'а'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.LIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        21: SequenceLikelihood.POSITIVE,  # 'ф'
        20: SequenceLikelihood.POSITIVE,  # 'х'
        31: SequenceLikelihood.LIKELY,  # 'ч'
        18: SequenceLikelihood.POSITIVE,  # 'ш'
        28: SequenceLikelihood.POSITIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.LIKELY,  # 'ю'
        25: SequenceLikelihood.LIKELY,  # 'я'
        29: SequenceLikelihood.POSITIVE,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.POSITIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.POSITIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.POSITIVE,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.LIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    11: {  # 'б'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.LIKELY,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.LIKELY,  # 'қ'
        42: SequenceLikelihood.NEGATIVE,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.NEGATIVE,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    16: {  # 'в'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.NEGATIVE,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.NEGATIVE,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.LIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.LIKELY,  # 'ч'
        18: SequenceLikelihood.LIKELY,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.LIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.LIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.LIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.POSITIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    19: {  # 'г'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.NEGATIVE,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.LIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.POSITIVE,  # 'ӯ'
    },
    6: {  # 'д'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.LIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.LIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.LIKELY,  # 'ю'
        25: SequenceLikelihood.LIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.LIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.LIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.POSITIVE,  # 'ӯ'
    },
    15: {  # 'е'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.LIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.POSITIVE,  # 'ф'
        20: SequenceLikelihood.POSITIVE,  # 'х'
        31: SequenceLikelihood.LIKELY,  # 'ч'
        18: SequenceLikelihood.POSITIVE,  # 'ш'
        28: SequenceLikelihood.POSITIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.LIKELY,  # 'ю'
        25: SequenceLikelihood.LIKELY,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.POSITIVE,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.LIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    58: {  # 'ж'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.NEGATIVE,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.NEGATIVE,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.NEGATIVE,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.NEGATIVE,  # 'Л'
        33: SequenceLikelihood.NEGATIVE,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.NEGATIVE,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        49: SequenceLikelihood.NEGATIVE,  # 'Х'
        59: SequenceLikelihood.NEGATIVE,  # 'Ч'
        48: SequenceLikelihood.NEGATIVE,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.NEGATIVE,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.NEGATIVE,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    17: {  # 'з'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.POSITIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    2: {  # 'и'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.LIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        21: SequenceLikelihood.POSITIVE,  # 'ф'
        20: SequenceLikelihood.POSITIVE,  # 'х'
        31: SequenceLikelihood.LIKELY,  # 'ч'
        18: SequenceLikelihood.POSITIVE,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.POSITIVE,  # 'ю'
        25: SequenceLikelihood.POSITIVE,  # 'я'
        29: SequenceLikelihood.POSITIVE,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.LIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.POSITIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.POSITIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.LIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    30: {  # 'й'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.NEGATIVE,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.LIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.LIKELY,  # 'я'
        29: SequenceLikelihood.POSITIVE,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.LIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    13: {  # 'к'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.LIKELY,  # 'ч'
        18: SequenceLikelihood.LIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.LIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.LIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.POSITIVE,  # 'ӯ'
    },
    14: {  # 'л'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.LIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.LIKELY,  # 'ч'
        18: SequenceLikelihood.LIKELY,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.LIKELY,  # 'ю'
        25: SequenceLikelihood.LIKELY,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.POSITIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    7: {  # 'м'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.LIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.POSITIVE,  # 'ч'
        18: SequenceLikelihood.LIKELY,  # 'ш'
        28: SequenceLikelihood.POSITIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.LIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.POSITIVE,  # 'ӯ'
    },
    5: {  # 'н'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.POSITIVE,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.POSITIVE,  # 'ч'
        18: SequenceLikelihood.POSITIVE,  # 'ш'
        28: SequenceLikelihood.POSITIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.LIKELY,  # 'я'
        29: SequenceLikelihood.POSITIVE,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.LIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.POSITIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.POSITIVE,  # 'ӯ'
    },
    3: {  # 'о'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.LIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        21: SequenceLikelihood.POSITIVE,  # 'ф'
        20: SequenceLikelihood.POSITIVE,  # 'х'
        31: SequenceLikelihood.LIKELY,  # 'ч'
        18: SequenceLikelihood.POSITIVE,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.LIKELY,  # 'э'
        51: SequenceLikelihood.LIKELY,  # 'ю'
        25: SequenceLikelihood.POSITIVE,  # 'я'
        29: SequenceLikelihood.POSITIVE,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.POSITIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.POSITIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.POSITIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    26: {  # 'п'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        44: SequenceLikelihood.NEGATIVE,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.NEGATIVE,  # 'К'
        60: SequenceLikelihood.NEGATIVE,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.NEGATIVE,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.LIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.NEGATIVE,  # 'Ҳ'
        12: SequenceLikelihood.LIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.POSITIVE,  # 'ӯ'
    },
    4: {  # 'р'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.LIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.POSITIVE,  # 'ф'
        20: SequenceLikelihood.POSITIVE,  # 'х'
        31: SequenceLikelihood.POSITIVE,  # 'ч'
        18: SequenceLikelihood.POSITIVE,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.LIKELY,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.POSITIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.POSITIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.POSITIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.POSITIVE,  # 'ӯ'
    },
    10: {  # 'с'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.LIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.POSITIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.POSITIVE,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.LIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.POSITIVE,  # 'ӯ'
    },
    8: {  # 'т'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.LIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.LIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.LIKELY,  # 'ч'
        18: SequenceLikelihood.LIKELY,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.LIKELY,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.LIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    9: {  # 'у'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.LIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.LIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.POSITIVE,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.POSITIVE,  # 'ф'
        20: SequenceLikelihood.POSITIVE,  # 'х'
        31: SequenceLikelihood.LIKELY,  # 'ч'
        18: SequenceLikelihood.POSITIVE,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.LIKELY,  # 'ю'
        25: SequenceLikelihood.LIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.POSITIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.POSITIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.POSITIVE,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    21: {  # 'ф'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.NEGATIVE,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.NEGATIVE,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.NEGATIVE,  # 'Х'
        59: SequenceLikelihood.NEGATIVE,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.LIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.LIKELY,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.LIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.LIKELY,  # 'ҳ'
        50: SequenceLikelihood.NEGATIVE,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.LIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    20: {  # 'х'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.NEGATIVE,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.NEGATIVE,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.NEGATIVE,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.LIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.POSITIVE,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.LIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.LIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.POSITIVE,  # 'ӯ'
    },
    31: {  # 'ч'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        44: SequenceLikelihood.NEGATIVE,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.NEGATIVE,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.NEGATIVE,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.NEGATIVE,  # 'К'
        60: SequenceLikelihood.NEGATIVE,  # 'Л'
        33: SequenceLikelihood.NEGATIVE,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.NEGATIVE,  # 'С'
        34: SequenceLikelihood.NEGATIVE,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        49: SequenceLikelihood.NEGATIVE,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.NEGATIVE,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.NEGATIVE,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.NEGATIVE,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    18: {  # 'ш'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.NEGATIVE,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.POSITIVE,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.LIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.LIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.LIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.LIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    28: {  # 'ъ'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.NEGATIVE,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.NEGATIVE,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.NEGATIVE,  # 'К'
        60: SequenceLikelihood.NEGATIVE,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.NEGATIVE,  # 'О'
        46: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        39: SequenceLikelihood.NEGATIVE,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.NEGATIVE,  # 'Ч'
        48: SequenceLikelihood.NEGATIVE,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.LIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.LIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.LIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.LIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.LIKELY,  # 'ҳ'
        50: SequenceLikelihood.NEGATIVE,  # 'Ҷ'
        24: SequenceLikelihood.LIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.LIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    47: {  # 'э'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.NEGATIVE,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.NEGATIVE,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.NEGATIVE,  # 'К'
        60: SequenceLikelihood.NEGATIVE,  # 'Л'
        33: SequenceLikelihood.NEGATIVE,  # 'М'
        45: SequenceLikelihood.NEGATIVE,  # 'Н'
        41: SequenceLikelihood.NEGATIVE,  # 'О'
        46: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        39: SequenceLikelihood.NEGATIVE,  # 'С'
        34: SequenceLikelihood.NEGATIVE,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        49: SequenceLikelihood.NEGATIVE,  # 'Х'
        59: SequenceLikelihood.NEGATIVE,  # 'Ч'
        48: SequenceLikelihood.NEGATIVE,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.LIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.LIKELY,  # 'ш'
        28: SequenceLikelihood.POSITIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.NEGATIVE,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.NEGATIVE,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.LIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    51: {  # 'ю'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.NEGATIVE,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.NEGATIVE,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.NEGATIVE,  # 'К'
        60: SequenceLikelihood.NEGATIVE,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.NEGATIVE,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        39: SequenceLikelihood.NEGATIVE,  # 'С'
        34: SequenceLikelihood.NEGATIVE,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.NEGATIVE,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.NEGATIVE,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.NEGATIVE,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    25: {  # 'я'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.POSITIVE,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.POSITIVE,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.LIKELY,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.POSITIVE,  # 'ш'
        28: SequenceLikelihood.LIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    29: {  # 'ё'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.NEGATIVE,  # 'К'
        60: SequenceLikelihood.NEGATIVE,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.NEGATIVE,  # 'Х'
        59: SequenceLikelihood.NEGATIVE,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.POSITIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    64: {  # 'Ғ'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.NEGATIVE,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.NEGATIVE,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        11: SequenceLikelihood.NEGATIVE,  # 'б'
        16: SequenceLikelihood.NEGATIVE,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.NEGATIVE,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        14: SequenceLikelihood.NEGATIVE,  # 'л'
        7: SequenceLikelihood.NEGATIVE,  # 'м'
        5: SequenceLikelihood.NEGATIVE,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        8: SequenceLikelihood.NEGATIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.NEGATIVE,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.NEGATIVE,  # 'э'
        51: SequenceLikelihood.NEGATIVE,  # 'ю'
        25: SequenceLikelihood.NEGATIVE,  # 'я'
        29: SequenceLikelihood.NEGATIVE,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.NEGATIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.NEGATIVE,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    38: {  # 'ғ'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.NEGATIVE,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.NEGATIVE,  # 'М'
        45: SequenceLikelihood.NEGATIVE,  # 'Н'
        41: SequenceLikelihood.NEGATIVE,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.NEGATIVE,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.NEGATIVE,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.LIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.LIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.NEGATIVE,  # 'Ҳ'
        12: SequenceLikelihood.LIKELY,  # 'ҳ'
        50: SequenceLikelihood.NEGATIVE,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    52: {  # 'Қ'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.NEGATIVE,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.NEGATIVE,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.NEGATIVE,  # 'э'
        51: SequenceLikelihood.NEGATIVE,  # 'ю'
        25: SequenceLikelihood.NEGATIVE,  # 'я'
        29: SequenceLikelihood.NEGATIVE,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    22: {  # 'қ'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.NEGATIVE,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.NEGATIVE,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        49: SequenceLikelihood.NEGATIVE,  # 'Х'
        59: SequenceLikelihood.NEGATIVE,  # 'Ч'
        48: SequenceLikelihood.NEGATIVE,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.POSITIVE,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.POSITIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.LIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.LIKELY,  # 'ӯ'
    },
    42: {  # 'Ҳ'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.LIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.LIKELY,  # 'Н'
        41: SequenceLikelihood.LIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.LIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.NEGATIVE,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    12: {  # 'ҳ'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.POSITIVE,  # 'б'
        16: SequenceLikelihood.LIKELY,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.POSITIVE,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.LIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.LIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.LIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.NEGATIVE,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.POSITIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    50: {  # 'Ҷ'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.LIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.NEGATIVE,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.NEGATIVE,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    24: {  # 'ҷ'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.NEGATIVE,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.NEGATIVE,  # 'К'
        60: SequenceLikelihood.NEGATIVE,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.NEGATIVE,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.LIKELY,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.LIKELY,  # 'л'
        7: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.NEGATIVE,  # 'Ҳ'
        12: SequenceLikelihood.LIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.LIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.LIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.POSITIVE,  # 'ӯ'
    },
    67: {  # 'Ӣ'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.NEGATIVE,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.NEGATIVE,  # 'г'
        6: SequenceLikelihood.NEGATIVE,  # 'д'
        15: SequenceLikelihood.NEGATIVE,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.NEGATIVE,  # 'й'
        13: SequenceLikelihood.NEGATIVE,  # 'к'
        14: SequenceLikelihood.NEGATIVE,  # 'л'
        7: SequenceLikelihood.NEGATIVE,  # 'м'
        5: SequenceLikelihood.NEGATIVE,  # 'н'
        3: SequenceLikelihood.NEGATIVE,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.NEGATIVE,  # 'р'
        10: SequenceLikelihood.NEGATIVE,  # 'с'
        8: SequenceLikelihood.NEGATIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.NEGATIVE,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.NEGATIVE,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.NEGATIVE,  # 'ъ'
        47: SequenceLikelihood.NEGATIVE,  # 'э'
        51: SequenceLikelihood.NEGATIVE,  # 'ю'
        25: SequenceLikelihood.NEGATIVE,  # 'я'
        29: SequenceLikelihood.NEGATIVE,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.NEGATIVE,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.NEGATIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.NEGATIVE,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    23: {  # 'ӣ'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.UNLIKELY,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.NEGATIVE,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.UNLIKELY,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.UNLIKELY,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        57: SequenceLikelihood.UNLIKELY,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.UNLIKELY,  # 'ӣ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    62: {  # 'Ӯ'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.UNLIKELY,  # 'Г'
        35: SequenceLikelihood.UNLIKELY,  # 'Д'
        63: SequenceLikelihood.UNLIKELY,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.UNLIKELY,  # 'Н'
        41: SequenceLikelihood.NEGATIVE,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.UNLIKELY,  # 'Ф'
        49: SequenceLikelihood.UNLIKELY,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.UNLIKELY,  # 'Ю'
        61: SequenceLikelihood.UNLIKELY,  # 'Я'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        11: SequenceLikelihood.UNLIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.UNLIKELY,  # 'г'
        6: SequenceLikelihood.UNLIKELY,  # 'д'
        15: SequenceLikelihood.UNLIKELY,  # 'е'
        58: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        30: SequenceLikelihood.UNLIKELY,  # 'й'
        13: SequenceLikelihood.UNLIKELY,  # 'к'
        14: SequenceLikelihood.UNLIKELY,  # 'л'
        7: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.NEGATIVE,  # 'п'
        4: SequenceLikelihood.UNLIKELY,  # 'р'
        10: SequenceLikelihood.UNLIKELY,  # 'с'
        8: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.NEGATIVE,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.UNLIKELY,  # 'х'
        31: SequenceLikelihood.UNLIKELY,  # 'ч'
        18: SequenceLikelihood.UNLIKELY,  # 'ш'
        28: SequenceLikelihood.UNLIKELY,  # 'ъ'
        47: SequenceLikelihood.NEGATIVE,  # 'э'
        51: SequenceLikelihood.NEGATIVE,  # 'ю'
        25: SequenceLikelihood.UNLIKELY,  # 'я'
        29: SequenceLikelihood.UNLIKELY,  # 'ё'
        64: SequenceLikelihood.UNLIKELY,  # 'Ғ'
        38: SequenceLikelihood.UNLIKELY,  # 'ғ'
        52: SequenceLikelihood.UNLIKELY,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.UNLIKELY,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.UNLIKELY,  # 'Ӣ'
        23: SequenceLikelihood.NEGATIVE,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
    27: {  # 'ӯ'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        32: SequenceLikelihood.UNLIKELY,  # 'А'
        36: SequenceLikelihood.UNLIKELY,  # 'Б'
        44: SequenceLikelihood.UNLIKELY,  # 'В'
        56: SequenceLikelihood.NEGATIVE,  # 'Г'
        35: SequenceLikelihood.NEGATIVE,  # 'Д'
        63: SequenceLikelihood.NEGATIVE,  # 'Е'
        69: SequenceLikelihood.NEGATIVE,  # 'Ж'
        55: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        68: SequenceLikelihood.UNLIKELY,  # 'Й'
        43: SequenceLikelihood.UNLIKELY,  # 'К'
        60: SequenceLikelihood.UNLIKELY,  # 'Л'
        33: SequenceLikelihood.UNLIKELY,  # 'М'
        45: SequenceLikelihood.NEGATIVE,  # 'Н'
        41: SequenceLikelihood.NEGATIVE,  # 'О'
        46: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        39: SequenceLikelihood.UNLIKELY,  # 'С'
        34: SequenceLikelihood.UNLIKELY,  # 'Т'
        54: SequenceLikelihood.NEGATIVE,  # 'У'
        53: SequenceLikelihood.NEGATIVE,  # 'Ф'
        49: SequenceLikelihood.NEGATIVE,  # 'Х'
        59: SequenceLikelihood.UNLIKELY,  # 'Ч'
        48: SequenceLikelihood.UNLIKELY,  # 'Ш'
        70: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        57: SequenceLikelihood.NEGATIVE,  # 'Э'
        66: SequenceLikelihood.NEGATIVE,  # 'Ю'
        61: SequenceLikelihood.NEGATIVE,  # 'Я'
        1: SequenceLikelihood.LIKELY,  # 'а'
        11: SequenceLikelihood.LIKELY,  # 'б'
        16: SequenceLikelihood.UNLIKELY,  # 'в'
        19: SequenceLikelihood.LIKELY,  # 'г'
        6: SequenceLikelihood.POSITIVE,  # 'д'
        15: SequenceLikelihood.LIKELY,  # 'е'
        58: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        30: SequenceLikelihood.POSITIVE,  # 'й'
        13: SequenceLikelihood.LIKELY,  # 'к'
        14: SequenceLikelihood.POSITIVE,  # 'л'
        7: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        26: SequenceLikelihood.UNLIKELY,  # 'п'
        4: SequenceLikelihood.POSITIVE,  # 'р'
        10: SequenceLikelihood.POSITIVE,  # 'с'
        8: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        21: SequenceLikelihood.UNLIKELY,  # 'ф'
        20: SequenceLikelihood.LIKELY,  # 'х'
        31: SequenceLikelihood.LIKELY,  # 'ч'
        18: SequenceLikelihood.POSITIVE,  # 'ш'
        28: SequenceLikelihood.POSITIVE,  # 'ъ'
        47: SequenceLikelihood.UNLIKELY,  # 'э'
        51: SequenceLikelihood.UNLIKELY,  # 'ю'
        25: SequenceLikelihood.POSITIVE,  # 'я'
        29: SequenceLikelihood.LIKELY,  # 'ё'
        64: SequenceLikelihood.NEGATIVE,  # 'Ғ'
        38: SequenceLikelihood.LIKELY,  # 'ғ'
        52: SequenceLikelihood.NEGATIVE,  # 'Қ'
        22: SequenceLikelihood.UNLIKELY,  # 'қ'
        42: SequenceLikelihood.UNLIKELY,  # 'Ҳ'
        12: SequenceLikelihood.POSITIVE,  # 'ҳ'
        50: SequenceLikelihood.UNLIKELY,  # 'Ҷ'
        24: SequenceLikelihood.UNLIKELY,  # 'ҷ'
        67: SequenceLikelihood.NEGATIVE,  # 'Ӣ'
        23: SequenceLikelihood.LIKELY,  # 'ӣ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ӯ'
        27: SequenceLikelihood.UNLIKELY,  # 'ӯ'
    },
}

# Character Mapping Table(s):
KOI8_T_TAJIK_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 22,  # 'қ'
    129: 38,  # 'ғ'
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 64,  # 'Ғ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.UNDEFINED,  # None
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 12,  # 'ҳ'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 42,  # 'Ҳ'
    141: 24,  # 'ҷ'
    142: 50,  # 'Ҷ'
    143: CharacterCategory.UNDEFINED,  # None
    144: 52,  # 'Қ'
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: CharacterCategory.UNDEFINED,  # None
    155: CharacterCategory.SYMBOL,  # '›'
    156: CharacterCategory.UNDEFINED,  # None
    157: CharacterCategory.UNDEFINED,  # None
    158: CharacterCategory.UNDEFINED,  # None
    159: CharacterCategory.UNDEFINED,  # None
    160: CharacterCategory.UNDEFINED,  # None
    161: 27,  # 'ӯ'
    162: 62,  # 'Ӯ'
    163: 29,  # 'ё'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 23,  # 'ӣ'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.UNDEFINED,  # None
    169: CharacterCategory.UNDEFINED,  # None
    170: CharacterCategory.UNDEFINED,  # None
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.UNDEFINED,  # None
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: 65,  # 'Ё'
    180: CharacterCategory.UNDEFINED,  # None
    181: 67,  # 'Ӣ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.UNDEFINED,  # None
    185: CharacterCategory.SYMBOL,  # '№'
    186: CharacterCategory.UNDEFINED,  # None
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.UNDEFINED,  # None
    189: CharacterCategory.UNDEFINED,  # None
    190: CharacterCategory.UNDEFINED,  # None
    191: CharacterCategory.SYMBOL,  # '©'
    192: 51,  # 'ю'
    193: 1,  # 'а'
    194: 11,  # 'б'
    195: 0,  # 'ц'
    196: 6,  # 'д'
    197: 15,  # 'е'
    198: 21,  # 'ф'
    199: 19,  # 'г'
    200: 20,  # 'х'
    201: 2,  # 'и'
    202: 30,  # 'й'
    203: 13,  # 'к'
    204: 14,  # 'л'
    205: 7,  # 'м'
    206: 5,  # 'н'
    207: 3,  # 'о'
    208: 26,  # 'п'
    209: 25,  # 'я'
    210: 4,  # 'р'
    211: 10,  # 'с'
    212: 8,  # 'т'
    213: 9,  # 'у'
    214: 58,  # 'ж'
    215: 16,  # 'в'
    216: 0,  # 'ь'
    217: 0,  # 'ы'
    218: 17,  # 'з'
    219: 18,  # 'ш'
    220: 47,  # 'э'
    221: 0,  # 'щ'
    222: 31,  # 'ч'
    223: 28,  # 'ъ'
    224: 66,  # 'Ю'
    225: 32,  # 'А'
    226: 36,  # 'Б'
    227: 0,  # 'Ц'
    228: 35,  # 'Д'
    229: 63,  # 'Е'
    230: 53,  # 'Ф'
    231: 56,  # 'Г'
    232: 49,  # 'Х'
    233: 37,  # 'И'
    234: 68,  # 'Й'
    235: 43,  # 'К'
    236: 60,  # 'Л'
    237: 33,  # 'М'
    238: 45,  # 'Н'
    239: 41,  # 'О'
    240: 46,  # 'П'
    241: 61,  # 'Я'
    242: 40,  # 'Р'
    243: 39,  # 'С'
    244: 34,  # 'Т'
    245: 54,  # 'У'
    246: 69,  # 'Ж'
    247: 44,  # 'В'
    248: 0,  # 'Ь'
    249: 0,  # 'Ы'
    250: 55,  # 'З'
    251: 48,  # 'Ш'
    252: 57,  # 'Э'
    253: 0,  # 'Щ'
    254: 59,  # 'Ч'
    255: 70,  # 'Ъ'
}

KOI8_T_TAJIK_MODEL = SingleByteCharSetModel(
    charset_name="KOI8-T",
    language="Tajik",
    char_to_order_map=KOI8_T_TAJIK_CHAR_TO_ORDER,
    language_model=TAJIK_LANG_MODEL,
    typical_positive_ratio=0.9655277101951257,
    keep_ascii_letters=False,
    alphabet="ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЧШЪЭЮЯабвгдежзийклмнопрстуфхчшъэюяёҒғҚқҲҳҶҷӢӣӮӯ",
)
