from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

TURKISH_LANG_MODEL = {
    29: {  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.POSITIVE,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.POSITIVE,  # 'K'
        45: SequenceLikelihood.POSITIVE,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.POSITIVE,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.LIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.POSITIVE,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.LIKELY,  # 'Y'
        57: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.LIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.LIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.LIKELY,  # 'Ğ'
        24: SequenceLikelihood.LIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.LIKELY,  # 'Ş'
        19: SequenceLikelihood.LIKELY,  # 'ş'
    },
    30: {  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.LIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    46: {  # 'C'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        48: SequenceLikelihood.LIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    37: {  # 'D'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.POSITIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.LIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        42: SequenceLikelihood.LIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.LIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.LIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.LIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    34: {  # 'E'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.LIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.POSITIVE,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.POSITIVE,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.POSITIVE,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.LIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        20: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.LIKELY,  # 'Ğ'
        24: SequenceLikelihood.POSITIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.LIKELY,  # 'ş'
    },
    47: {  # 'F'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.LIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.NEGATIVE,  # 'ş'
    },
    40: {  # 'G'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.LIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.POSITIVE,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.NEGATIVE,  # 'ş'
    },
    39: {  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.LIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.LIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.LIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.LIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    48: {  # 'I'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.LIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.LIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.LIKELY,  # 'Y'
        57: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.LIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    61: {  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    31: {  # 'K'
        29: SequenceLikelihood.POSITIVE,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.LIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        42: SequenceLikelihood.LIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.LIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    45: {  # 'L'
        29: SequenceLikelihood.POSITIVE,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.POSITIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.LIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.LIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    35: {  # 'M'
        29: SequenceLikelihood.POSITIVE,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        48: SequenceLikelihood.LIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.LIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    43: {  # 'N'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.LIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    44: {  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.LIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.NEGATIVE,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    42: {  # 'P'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    65: {  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.NEGATIVE,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.NEGATIVE,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.NEGATIVE,  # 'Ş'
        19: SequenceLikelihood.NEGATIVE,  # 'ş'
    },
    41: {  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.LIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.LIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    32: {  # 'S'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.LIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        42: SequenceLikelihood.LIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.LIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.LIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.LIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.NEGATIVE,  # 'ş'
    },
    33: {  # 'T'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.LIKELY,  # 'B'
        46: SequenceLikelihood.LIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.LIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.POSITIVE,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.LIKELY,  # 'U'
        52: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.LIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.LIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.LIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.LIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    50: {  # 'U'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.LIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.LIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.LIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.NEGATIVE,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.NEGATIVE,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    52: {  # 'V'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.NEGATIVE,  # 'ş'
    },
    60: {  # 'W'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.NEGATIVE,  # 'Ş'
        19: SequenceLikelihood.NEGATIVE,  # 'ş'
    },
    64: {  # 'X'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.NEGATIVE,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.NEGATIVE,  # 'ş'
    },
    38: {  # 'Y'
        29: SequenceLikelihood.POSITIVE,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.LIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.LIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.LIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.LIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    57: {  # 'Z'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.NEGATIVE,  # 'ş'
    },
    1: {  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        20: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.POSITIVE,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.LIKELY,  # 'w'
        59: SequenceLikelihood.LIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.POSITIVE,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.POSITIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.POSITIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.POSITIVE,  # 'ş'
    },
    16: {  # 'b'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.LIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.POSITIVE,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    22: {  # 'c'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    9: {  # 'd'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.POSITIVE,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    2: {  # 'e'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        20: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.LIKELY,  # 'w'
        59: SequenceLikelihood.POSITIVE,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.POSITIVE,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.POSITIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.POSITIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.POSITIVE,  # 'ş'
    },
    28: {  # 'f'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.LIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.LIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    20: {  # 'g'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.POSITIVE,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    23: {  # 'h'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.LIKELY,  # 'â'
        25: SequenceLikelihood.LIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.LIKELY,  # 'ş'
    },
    3: {  # 'i'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.LIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        20: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.LIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.POSITIVE,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.POSITIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.POSITIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.POSITIVE,  # 'ş'
    },
    49: {  # 'j'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.LIKELY,  # 'ı'
        53: SequenceLikelihood.NEGATIVE,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    8: {  # 'k'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.LIKELY,  # 'â'
        25: SequenceLikelihood.POSITIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.POSITIVE,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.LIKELY,  # 'ş'
    },
    6: {  # 'l'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        20: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.LIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.LIKELY,  # 'â'
        25: SequenceLikelihood.POSITIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    11: {  # 'm'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.LIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.LIKELY,  # 'ş'
    },
    4: {  # 'n'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        20: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.POSITIVE,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.POSITIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.LIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.LIKELY,  # 'ş'
    },
    15: {  # 'o'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        20: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.POSITIVE,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.LIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.POSITIVE,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.LIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.POSITIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.POSITIVE,  # 'ş'
    },
    26: {  # 'p'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.LIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.LIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    66: {  # 'q'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.NEGATIVE,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.NEGATIVE,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.NEGATIVE,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    5: {  # 'r'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        20: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.LIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.LIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.POSITIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.LIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.POSITIVE,  # 'ş'
    },
    12: {  # 's'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        20: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.POSITIVE,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    10: {  # 't'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.LIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.POSITIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.POSITIVE,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    13: {  # 'u'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        20: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.POSITIVE,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.POSITIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.POSITIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.POSITIVE,  # 'ş'
    },
    21: {  # 'v'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.LIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.NEGATIVE,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.LIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.LIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.LIKELY,  # 'ş'
    },
    56: {  # 'w'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.LIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.NEGATIVE,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.NEGATIVE,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    59: {  # 'x'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.NEGATIVE,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.NEGATIVE,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    14: {  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        22: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        20: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.POSITIVE,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    18: {  # 'z'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.LIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    68: {  # 'Â'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.NEGATIVE,  # 'I'
        61: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        64: SequenceLikelihood.NEGATIVE,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.NEGATIVE,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.NEGATIVE,  # 'o'
        26: SequenceLikelihood.NEGATIVE,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.NEGATIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.NEGATIVE,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.NEGATIVE,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.NEGATIVE,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.NEGATIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    51: {  # 'Ç'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        64: SequenceLikelihood.NEGATIVE,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.NEGATIVE,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.NEGATIVE,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.LIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.LIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    69: {  # 'Î'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.NEGATIVE,  # 'I'
        61: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        20: SequenceLikelihood.NEGATIVE,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.NEGATIVE,  # 'i'
        49: SequenceLikelihood.NEGATIVE,  # 'j'
        8: SequenceLikelihood.NEGATIVE,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.NEGATIVE,  # 'o'
        26: SequenceLikelihood.NEGATIVE,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        13: SequenceLikelihood.NEGATIVE,  # 'u'
        21: SequenceLikelihood.NEGATIVE,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.NEGATIVE,  # 'y'
        18: SequenceLikelihood.NEGATIVE,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.NEGATIVE,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.NEGATIVE,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.NEGATIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.NEGATIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.NEGATIVE,  # 'ş'
    },
    54: {  # 'Ö'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.LIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.NEGATIVE,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.NEGATIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.NEGATIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.POSITIVE,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.NEGATIVE,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.LIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    70: {  # 'Û'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.NEGATIVE,  # 'B'
        46: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        42: SequenceLikelihood.NEGATIVE,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        52: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        20: SequenceLikelihood.NEGATIVE,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.NEGATIVE,  # 'i'
        49: SequenceLikelihood.NEGATIVE,  # 'j'
        8: SequenceLikelihood.NEGATIVE,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        15: SequenceLikelihood.NEGATIVE,  # 'o'
        26: SequenceLikelihood.NEGATIVE,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.NEGATIVE,  # 'r'
        12: SequenceLikelihood.NEGATIVE,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        13: SequenceLikelihood.NEGATIVE,  # 'u'
        21: SequenceLikelihood.NEGATIVE,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.NEGATIVE,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.NEGATIVE,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.NEGATIVE,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.NEGATIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.NEGATIVE,  # 'ı'
        53: SequenceLikelihood.NEGATIVE,  # 'Ş'
        19: SequenceLikelihood.NEGATIVE,  # 'ş'
    },
    55: {  # 'Ü'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.LIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.NEGATIVE,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.NEGATIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.NEGATIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.NEGATIVE,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.NEGATIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    58: {  # 'â'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.NEGATIVE,  # 'B'
        46: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.NEGATIVE,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        43: SequenceLikelihood.NEGATIVE,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        42: SequenceLikelihood.NEGATIVE,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        52: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        64: SequenceLikelihood.NEGATIVE,  # 'X'
        38: SequenceLikelihood.NEGATIVE,  # 'Y'
        57: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.NEGATIVE,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.NEGATIVE,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.NEGATIVE,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.NEGATIVE,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    25: {  # 'ç'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.NEGATIVE,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.POSITIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.POSITIVE,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    63: {  # 'î'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.NEGATIVE,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.NEGATIVE,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.NEGATIVE,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        42: SequenceLikelihood.NEGATIVE,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        52: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        64: SequenceLikelihood.NEGATIVE,  # 'X'
        38: SequenceLikelihood.NEGATIVE,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.NEGATIVE,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.NEGATIVE,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.NEGATIVE,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.NEGATIVE,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    27: {  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.NEGATIVE,  # 'B'
        46: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.NEGATIVE,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        64: SequenceLikelihood.NEGATIVE,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.LIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.POSITIVE,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.NEGATIVE,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.LIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.POSITIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.NEGATIVE,  # 'Ş'
        19: SequenceLikelihood.LIKELY,  # 'ş'
    },
    67: {  # 'û'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        30: SequenceLikelihood.NEGATIVE,  # 'B'
        46: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.NEGATIVE,  # 'D'
        34: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        48: SequenceLikelihood.NEGATIVE,  # 'I'
        61: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.NEGATIVE,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.NEGATIVE,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        32: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.NEGATIVE,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        64: SequenceLikelihood.NEGATIVE,  # 'X'
        38: SequenceLikelihood.NEGATIVE,  # 'Y'
        57: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.NEGATIVE,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.NEGATIVE,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.NEGATIVE,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.NEGATIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.NEGATIVE,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.NEGATIVE,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    17: {  # 'ü'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.POSITIVE,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.POSITIVE,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.POSITIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.POSITIVE,  # 'ş'
    },
    62: {  # 'Ğ'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.NEGATIVE,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.NEGATIVE,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.NEGATIVE,  # 'f'
        20: SequenceLikelihood.NEGATIVE,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.NEGATIVE,  # 'j'
        8: SequenceLikelihood.NEGATIVE,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.NEGATIVE,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.NEGATIVE,  # 'y'
        18: SequenceLikelihood.NEGATIVE,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.NEGATIVE,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.NEGATIVE,  # 'Ş'
        19: SequenceLikelihood.NEGATIVE,  # 'ş'
    },
    24: {  # 'ğ'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.NEGATIVE,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.NEGATIVE,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.NEGATIVE,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        64: SequenceLikelihood.NEGATIVE,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.UNLIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.NEGATIVE,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.NEGATIVE,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.NEGATIVE,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    36: {  # 'İ'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'K'
        45: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.POSITIVE,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.LIKELY,  # 'Y'
        57: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.LIKELY,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.NEGATIVE,  # 'â'
        25: SequenceLikelihood.LIKELY,  # 'ç'
        63: SequenceLikelihood.NEGATIVE,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.LIKELY,  # 'Ş'
        19: SequenceLikelihood.POSITIVE,  # 'ş'
    },
    7: {  # 'ı'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.UNLIKELY,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        28: SequenceLikelihood.POSITIVE,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.POSITIVE,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.POSITIVE,  # 'r'
        12: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.UNLIKELY,  # 'u'
        21: SequenceLikelihood.LIKELY,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.UNLIKELY,  # 'x'
        14: SequenceLikelihood.POSITIVE,  # 'y'
        18: SequenceLikelihood.POSITIVE,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.LIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.NEGATIVE,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.UNLIKELY,  # 'Ğ'
        24: SequenceLikelihood.POSITIVE,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.POSITIVE,  # 'ş'
    },
    53: {  # 'Ş'
        29: SequenceLikelihood.LIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.NEGATIVE,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        22: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        28: SequenceLikelihood.UNLIKELY,  # 'f'
        20: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        49: SequenceLikelihood.NEGATIVE,  # 'j'
        8: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.UNLIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.NEGATIVE,  # 'q'
        5: SequenceLikelihood.UNLIKELY,  # 'r'
        12: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        13: SequenceLikelihood.LIKELY,  # 'u'
        21: SequenceLikelihood.UNLIKELY,  # 'v'
        56: SequenceLikelihood.NEGATIVE,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.NEGATIVE,  # 'y'
        18: SequenceLikelihood.NEGATIVE,  # 'z'
        68: SequenceLikelihood.UNLIKELY,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.UNLIKELY,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.UNLIKELY,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.NEGATIVE,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.UNLIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.UNLIKELY,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.NEGATIVE,  # 'ğ'
        36: SequenceLikelihood.LIKELY,  # 'İ'
        7: SequenceLikelihood.UNLIKELY,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
    19: {  # 'ş'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        30: SequenceLikelihood.UNLIKELY,  # 'B'
        46: SequenceLikelihood.UNLIKELY,  # 'C'
        37: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        48: SequenceLikelihood.UNLIKELY,  # 'I'
        61: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        45: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        42: SequenceLikelihood.UNLIKELY,  # 'P'
        65: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        50: SequenceLikelihood.UNLIKELY,  # 'U'
        52: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        64: SequenceLikelihood.NEGATIVE,  # 'X'
        38: SequenceLikelihood.UNLIKELY,  # 'Y'
        57: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        28: SequenceLikelihood.LIKELY,  # 'f'
        20: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        49: SequenceLikelihood.UNLIKELY,  # 'j'
        8: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        15: SequenceLikelihood.LIKELY,  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'p'
        66: SequenceLikelihood.UNLIKELY,  # 'q'
        5: SequenceLikelihood.LIKELY,  # 'r'
        12: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        13: SequenceLikelihood.POSITIVE,  # 'u'
        21: SequenceLikelihood.POSITIVE,  # 'v'
        56: SequenceLikelihood.UNLIKELY,  # 'w'
        59: SequenceLikelihood.NEGATIVE,  # 'x'
        14: SequenceLikelihood.LIKELY,  # 'y'
        18: SequenceLikelihood.UNLIKELY,  # 'z'
        68: SequenceLikelihood.NEGATIVE,  # 'Â'
        51: SequenceLikelihood.UNLIKELY,  # 'Ç'
        69: SequenceLikelihood.NEGATIVE,  # 'Î'
        54: SequenceLikelihood.UNLIKELY,  # 'Ö'
        70: SequenceLikelihood.NEGATIVE,  # 'Û'
        55: SequenceLikelihood.UNLIKELY,  # 'Ü'
        58: SequenceLikelihood.UNLIKELY,  # 'â'
        25: SequenceLikelihood.LIKELY,  # 'ç'
        63: SequenceLikelihood.UNLIKELY,  # 'î'
        27: SequenceLikelihood.LIKELY,  # 'ö'
        67: SequenceLikelihood.UNLIKELY,  # 'û'
        17: SequenceLikelihood.POSITIVE,  # 'ü'
        62: SequenceLikelihood.NEGATIVE,  # 'Ğ'
        24: SequenceLikelihood.UNLIKELY,  # 'ğ'
        36: SequenceLikelihood.UNLIKELY,  # 'İ'
        7: SequenceLikelihood.POSITIVE,  # 'ı'
        53: SequenceLikelihood.UNLIKELY,  # 'Ş'
        19: SequenceLikelihood.UNLIKELY,  # 'ş'
    },
}

# Character Mapping Table(s):
CP857_TURKISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 30,  # 'B'
    67: 46,  # 'C'
    68: 37,  # 'D'
    69: 34,  # 'E'
    70: 47,  # 'F'
    71: 40,  # 'G'
    72: 39,  # 'H'
    73: 48,  # 'I'
    74: 61,  # 'J'
    75: 31,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 43,  # 'N'
    79: 44,  # 'O'
    80: 42,  # 'P'
    81: 65,  # 'Q'
    82: 41,  # 'R'
    83: 32,  # 'S'
    84: 33,  # 'T'
    85: 50,  # 'U'
    86: 52,  # 'V'
    87: 60,  # 'W'
    88: 64,  # 'X'
    89: 38,  # 'Y'
    90: 57,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 22,  # 'c'
    100: 9,  # 'd'
    101: 2,  # 'e'
    102: 28,  # 'f'
    103: 20,  # 'g'
    104: 23,  # 'h'
    105: 3,  # 'i'
    106: 49,  # 'j'
    107: 8,  # 'k'
    108: 6,  # 'l'
    109: 11,  # 'm'
    110: 4,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 5,  # 'r'
    115: 12,  # 's'
    116: 10,  # 't'
    117: 13,  # 'u'
    118: 21,  # 'v'
    119: 56,  # 'w'
    120: 59,  # 'x'
    121: 14,  # 'y'
    122: 18,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 51,  # 'Ç'
    129: 17,  # 'ü'
    130: 0,  # 'é'
    131: 58,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 0,  # 'å'
    135: 25,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 63,  # 'î'
    141: 7,  # 'ı'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 27,  # 'ö'
    149: 0,  # 'ò'
    150: 67,  # 'û'
    151: 0,  # 'ù'
    152: 36,  # 'İ'
    153: 54,  # 'Ö'
    154: 55,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: 53,  # 'Ş'
    159: 19,  # 'ş'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 62,  # 'Ğ'
    167: 24,  # 'ğ'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 68,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'º'
    209: 0,  # 'ª'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: CharacterCategory.UNDEFINED,  # None
    214: 0,  # 'Í'
    215: 69,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: CharacterCategory.UNDEFINED,  # None
    232: CharacterCategory.SYMBOL,  # '×'
    233: 0,  # 'Ú'
    234: 70,  # 'Û'
    235: 0,  # 'Ù'
    236: 0,  # 'ì'
    237: 0,  # 'ÿ'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.UNDEFINED,  # None
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP857_TURKISH_MODEL = SingleByteCharSetModel(
    charset_name="CP857",
    language="Turkish",
    char_to_order_map=CP857_TURKISH_CHAR_TO_ORDER,
    language_model=TURKISH_LANG_MODEL,
    typical_positive_ratio=0.9626279932436153,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÂÇÎÖÛÜâçîöûüĞğİıŞş",
)

CP1026_TURKISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 58,  # 'â'
    67: 0,  # 'ä'
    68: 0,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: CharacterCategory.SYMBOL,  # '{'
    73: 0,  # 'ñ'
    74: 51,  # 'Ç'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 0,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 0,  # 'í'
    86: 63,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: 62,  # 'Ğ'
    91: 36,  # 'İ'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 68,  # 'Â'
    99: 0,  # 'Ä'
    100: 0,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: CharacterCategory.SYMBOL,  # '['
    105: 0,  # 'Ñ'
    106: 19,  # 'ş'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 0,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 0,  # 'Í'
    118: 69,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: 7,  # 'ı'
    122: CharacterCategory.SYMBOL,  # ':'
    123: 54,  # 'Ö'
    124: 53,  # 'Ş'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: 55,  # 'Ü'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 16,  # 'b'
    131: 22,  # 'c'
    132: 9,  # 'd'
    133: 2,  # 'e'
    134: 28,  # 'f'
    135: 20,  # 'g'
    136: 23,  # 'h'
    137: 3,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: CharacterCategory.SYMBOL,  # '}'
    141: CharacterCategory.SYMBOL,  # '`'
    142: CharacterCategory.SYMBOL,  # '¦'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 49,  # 'j'
    146: 8,  # 'k'
    147: 6,  # 'l'
    148: 11,  # 'm'
    149: 4,  # 'n'
    150: 15,  # 'o'
    151: 26,  # 'p'
    152: 66,  # 'q'
    153: 5,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: 27,  # 'ö'
    162: 12,  # 's'
    163: 10,  # 't'
    164: 13,  # 'u'
    165: 21,  # 'v'
    166: 56,  # 'w'
    167: 59,  # 'x'
    168: 14,  # 'y'
    169: 18,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: CharacterCategory.SYMBOL,  # ']'
    173: CharacterCategory.SYMBOL,  # '$'
    174: CharacterCategory.SYMBOL,  # '@'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: 25,  # 'ç'
    193: 29,  # 'A'
    194: 30,  # 'B'
    195: 46,  # 'C'
    196: 37,  # 'D'
    197: 34,  # 'E'
    198: 47,  # 'F'
    199: 40,  # 'G'
    200: 39,  # 'H'
    201: 48,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: CharacterCategory.SYMBOL,  # '~'
    205: 0,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: 24,  # 'ğ'
    209: 61,  # 'J'
    210: 31,  # 'K'
    211: 45,  # 'L'
    212: 35,  # 'M'
    213: 43,  # 'N'
    214: 44,  # 'O'
    215: 42,  # 'P'
    216: 65,  # 'Q'
    217: 41,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 67,  # 'û'
    220: CharacterCategory.SYMBOL,  # '\\'
    221: 0,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: 17,  # 'ü'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 32,  # 'S'
    227: 33,  # 'T'
    228: 50,  # 'U'
    229: 52,  # 'V'
    230: 60,  # 'W'
    231: 64,  # 'X'
    232: 38,  # 'Y'
    233: 57,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: CharacterCategory.SYMBOL,  # '#'
    237: 0,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 70,  # 'Û'
    252: CharacterCategory.SYMBOL,  # '"'
    253: 0,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP1026_TURKISH_MODEL = SingleByteCharSetModel(
    charset_name="CP1026",
    language="Turkish",
    char_to_order_map=CP1026_TURKISH_CHAR_TO_ORDER,
    language_model=TURKISH_LANG_MODEL,
    typical_positive_ratio=0.9626279932436153,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÂÇÎÖÛÜâçîöûüĞğİıŞş",
)

ISO_8859_3_TURKISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 30,  # 'B'
    67: 46,  # 'C'
    68: 37,  # 'D'
    69: 34,  # 'E'
    70: 47,  # 'F'
    71: 40,  # 'G'
    72: 39,  # 'H'
    73: 48,  # 'I'
    74: 61,  # 'J'
    75: 31,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 43,  # 'N'
    79: 44,  # 'O'
    80: 42,  # 'P'
    81: 65,  # 'Q'
    82: 41,  # 'R'
    83: 32,  # 'S'
    84: 33,  # 'T'
    85: 50,  # 'U'
    86: 52,  # 'V'
    87: 60,  # 'W'
    88: 64,  # 'X'
    89: 38,  # 'Y'
    90: 57,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 22,  # 'c'
    100: 9,  # 'd'
    101: 2,  # 'e'
    102: 28,  # 'f'
    103: 20,  # 'g'
    104: 23,  # 'h'
    105: 3,  # 'i'
    106: 49,  # 'j'
    107: 8,  # 'k'
    108: 6,  # 'l'
    109: 11,  # 'm'
    110: 4,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 5,  # 'r'
    115: 12,  # 's'
    116: 10,  # 't'
    117: 13,  # 'u'
    118: 21,  # 'v'
    119: 56,  # 'w'
    120: 59,  # 'x'
    121: 14,  # 'y'
    122: 18,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ħ'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.UNDEFINED,  # None
    166: 0,  # 'Ĥ'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: 36,  # 'İ'
    170: 53,  # 'Ş'
    171: 62,  # 'Ğ'
    172: 0,  # 'Ĵ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.UNDEFINED,  # None
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 0,  # 'ħ'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: 0,  # 'ĥ'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 7,  # 'ı'
    186: 19,  # 'ş'
    187: 24,  # 'ğ'
    188: 0,  # 'ĵ'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.UNDEFINED,  # None
    191: 0,  # 'ż'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 68,  # 'Â'
    195: CharacterCategory.UNDEFINED,  # None
    196: 0,  # 'Ä'
    197: 0,  # 'Ċ'
    198: 0,  # 'Ĉ'
    199: 51,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 69,  # 'Î'
    207: 0,  # 'Ï'
    208: CharacterCategory.UNDEFINED,  # None
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ġ'
    214: 54,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ĝ'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 70,  # 'Û'
    220: 55,  # 'Ü'
    221: 0,  # 'Ŭ'
    222: 0,  # 'Ŝ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 58,  # 'â'
    227: CharacterCategory.UNDEFINED,  # None
    228: 0,  # 'ä'
    229: 0,  # 'ċ'
    230: 0,  # 'ĉ'
    231: 25,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 63,  # 'î'
    239: 0,  # 'ï'
    240: CharacterCategory.UNDEFINED,  # None
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ġ'
    246: 27,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ĝ'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 67,  # 'û'
    252: 17,  # 'ü'
    253: 0,  # 'ŭ'
    254: 0,  # 'ŝ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

ISO_8859_3_TURKISH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-3",
    language="Turkish",
    char_to_order_map=ISO_8859_3_TURKISH_CHAR_TO_ORDER,
    language_model=TURKISH_LANG_MODEL,
    typical_positive_ratio=0.9626279932436153,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÂÇÎÖÛÜâçîöûüĞğİıŞş",
)

ISO_8859_9_TURKISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 30,  # 'B'
    67: 46,  # 'C'
    68: 37,  # 'D'
    69: 34,  # 'E'
    70: 47,  # 'F'
    71: 40,  # 'G'
    72: 39,  # 'H'
    73: 48,  # 'I'
    74: 61,  # 'J'
    75: 31,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 43,  # 'N'
    79: 44,  # 'O'
    80: 42,  # 'P'
    81: 65,  # 'Q'
    82: 41,  # 'R'
    83: 32,  # 'S'
    84: 33,  # 'T'
    85: 50,  # 'U'
    86: 52,  # 'V'
    87: 60,  # 'W'
    88: 64,  # 'X'
    89: 38,  # 'Y'
    90: 57,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 22,  # 'c'
    100: 9,  # 'd'
    101: 2,  # 'e'
    102: 28,  # 'f'
    103: 20,  # 'g'
    104: 23,  # 'h'
    105: 3,  # 'i'
    106: 49,  # 'j'
    107: 8,  # 'k'
    108: 6,  # 'l'
    109: 11,  # 'm'
    110: 4,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 5,  # 'r'
    115: 12,  # 's'
    116: 10,  # 't'
    117: 13,  # 'u'
    118: 21,  # 'v'
    119: 56,  # 'w'
    120: 59,  # 'x'
    121: 14,  # 'y'
    122: 18,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 68,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 51,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 69,  # 'Î'
    207: 0,  # 'Ï'
    208: 62,  # 'Ğ'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 54,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 70,  # 'Û'
    220: 55,  # 'Ü'
    221: 36,  # 'İ'
    222: 53,  # 'Ş'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 58,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 25,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 63,  # 'î'
    239: 0,  # 'ï'
    240: 24,  # 'ğ'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 27,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 67,  # 'û'
    252: 17,  # 'ü'
    253: 7,  # 'ı'
    254: 19,  # 'ş'
    255: 0,  # 'ÿ'
}

ISO_8859_9_TURKISH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-9",
    language="Turkish",
    char_to_order_map=ISO_8859_9_TURKISH_CHAR_TO_ORDER,
    language_model=TURKISH_LANG_MODEL,
    typical_positive_ratio=0.9626279932436153,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÂÇÎÖÛÜâçîöûüĞğİıŞş",
)

MACTURKISH_TURKISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 30,  # 'B'
    67: 46,  # 'C'
    68: 37,  # 'D'
    69: 34,  # 'E'
    70: 47,  # 'F'
    71: 40,  # 'G'
    72: 39,  # 'H'
    73: 48,  # 'I'
    74: 61,  # 'J'
    75: 31,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 43,  # 'N'
    79: 44,  # 'O'
    80: 42,  # 'P'
    81: 65,  # 'Q'
    82: 41,  # 'R'
    83: 32,  # 'S'
    84: 33,  # 'T'
    85: 50,  # 'U'
    86: 52,  # 'V'
    87: 60,  # 'W'
    88: 64,  # 'X'
    89: 38,  # 'Y'
    90: 57,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 22,  # 'c'
    100: 9,  # 'd'
    101: 2,  # 'e'
    102: 28,  # 'f'
    103: 20,  # 'g'
    104: 23,  # 'h'
    105: 3,  # 'i'
    106: 49,  # 'j'
    107: 8,  # 'k'
    108: 6,  # 'l'
    109: 11,  # 'm'
    110: 4,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 5,  # 'r'
    115: 12,  # 's'
    116: 10,  # 't'
    117: 13,  # 'u'
    118: 21,  # 'v'
    119: 56,  # 'w'
    120: 59,  # 'x'
    121: 14,  # 'y'
    122: 18,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Å'
    130: 51,  # 'Ç'
    131: 0,  # 'É'
    132: 0,  # 'Ñ'
    133: 54,  # 'Ö'
    134: 55,  # 'Ü'
    135: 0,  # 'á'
    136: 0,  # 'à'
    137: 58,  # 'â'
    138: 0,  # 'ä'
    139: 0,  # 'ã'
    140: 0,  # 'å'
    141: 25,  # 'ç'
    142: 0,  # 'é'
    143: 0,  # 'è'
    144: 0,  # 'ê'
    145: 0,  # 'ë'
    146: 0,  # 'í'
    147: 0,  # 'ì'
    148: 63,  # 'î'
    149: 0,  # 'ï'
    150: 0,  # 'ñ'
    151: 0,  # 'ó'
    152: 0,  # 'ò'
    153: 0,  # 'ô'
    154: 27,  # 'ö'
    155: 0,  # 'õ'
    156: 0,  # 'ú'
    157: 0,  # 'ù'
    158: 67,  # 'û'
    159: 17,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 0,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 0,  # 'Œ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ÿ'
    217: 0,  # 'Ÿ'
    218: 62,  # 'Ğ'
    219: 24,  # 'ğ'
    220: 36,  # 'İ'
    221: 7,  # 'ı'
    222: 53,  # 'Ş'
    223: 19,  # 'ş'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 68,  # 'Â'
    230: 0,  # 'Ê'
    231: 0,  # 'Á'
    232: 0,  # 'Ë'
    233: 0,  # 'È'
    234: 0,  # 'Í'
    235: 69,  # 'Î'
    236: 0,  # 'Ï'
    237: 0,  # 'Ì'
    238: 0,  # 'Ó'
    239: 0,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 0,  # 'Ò'
    242: 0,  # 'Ú'
    243: 70,  # 'Û'
    244: 0,  # 'Ù'
    245: CharacterCategory.CONTROL,  # '\uf8a0'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACTURKISH_TURKISH_MODEL = SingleByteCharSetModel(
    charset_name="MacTurkish",
    language="Turkish",
    char_to_order_map=MACTURKISH_TURKISH_CHAR_TO_ORDER,
    language_model=TURKISH_LANG_MODEL,
    typical_positive_ratio=0.9626279932436153,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÂÇÎÖÛÜâçîöûüĞğİıŞş",
)

WINDOWS_1254_TURKISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 30,  # 'B'
    67: 46,  # 'C'
    68: 37,  # 'D'
    69: 34,  # 'E'
    70: 47,  # 'F'
    71: 40,  # 'G'
    72: 39,  # 'H'
    73: 48,  # 'I'
    74: 61,  # 'J'
    75: 31,  # 'K'
    76: 45,  # 'L'
    77: 35,  # 'M'
    78: 43,  # 'N'
    79: 44,  # 'O'
    80: 42,  # 'P'
    81: 65,  # 'Q'
    82: 41,  # 'R'
    83: 32,  # 'S'
    84: 33,  # 'T'
    85: 50,  # 'U'
    86: 52,  # 'V'
    87: 60,  # 'W'
    88: 64,  # 'X'
    89: 38,  # 'Y'
    90: 57,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 22,  # 'c'
    100: 9,  # 'd'
    101: 2,  # 'e'
    102: 28,  # 'f'
    103: 20,  # 'g'
    104: 23,  # 'h'
    105: 3,  # 'i'
    106: 49,  # 'j'
    107: 8,  # 'k'
    108: 6,  # 'l'
    109: 11,  # 'm'
    110: 4,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 66,  # 'q'
    114: 5,  # 'r'
    115: 12,  # 's'
    116: 10,  # 't'
    117: 13,  # 'u'
    118: 21,  # 'v'
    119: 56,  # 'w'
    120: 59,  # 'x'
    121: 14,  # 'y'
    122: 18,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: CharacterCategory.UNDEFINED,  # None
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: CharacterCategory.UNDEFINED,  # None
    159: 0,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 68,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 51,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 69,  # 'Î'
    207: 0,  # 'Ï'
    208: 62,  # 'Ğ'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 54,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 70,  # 'Û'
    220: 55,  # 'Ü'
    221: 36,  # 'İ'
    222: 53,  # 'Ş'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 58,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 25,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 63,  # 'î'
    239: 0,  # 'ï'
    240: 24,  # 'ğ'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 27,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 67,  # 'û'
    252: 17,  # 'ü'
    253: 7,  # 'ı'
    254: 19,  # 'ş'
    255: 0,  # 'ÿ'
}

WINDOWS_1254_TURKISH_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1254",
    language="Turkish",
    char_to_order_map=WINDOWS_1254_TURKISH_CHAR_TO_ORDER,
    language_model=TURKISH_LANG_MODEL,
    typical_positive_ratio=0.9626279932436153,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÂÇÎÖÛÜâçîöûüĞğİıŞş",
)
