# Gooey 1.0.3 Released!

![title card](https://github.com/chriskiehl/GooeyImages/blob/images/docs/releases/1.0.3/release-title-card.png)

After cooking for far too long, **Gooey 1.0.3 is released!**



Grab the latest version:

* [github](https://github.com/chriskiehl/Gooey)
* [PyPi](TODO)


Runnable demos for all the new features can be found in the [Examples repo](https://github.com/chriskiehl/GooeyExamples).

## Overview:


A lot of focus was put on settling Gooey down into a more stable mature project. In addition to all of the new features, a lot of time was spent writing documentation, stamping down cross platform issues / quirks, and making numerous tweaks and additions to enable a smoother experience when packaging Gooey for distribution.    


## What's new


### Fancy Layout controls!


![advanced layout](https://github.com/chriskiehl/GooeyImages/raw/images/docs/releases/1.0.3/advanced-layout.png)

The main goal of this release was enabling more complex real-world layouts and more customization of Gooey's UI. As of 1.1.0, you now have have control over every color, font, and display status within the application. You can now brand Gooey to your organization's colors, logically group related items under a central heading, and optionally show/hide all the individual components that make up an input widget.


### Menu Bars

Gooey now includes a simple declarative system for creating top level menu bars and items.

![menu bar](https://github.com/chriskiehl/GooeyImages/raw/images/docs/releases/1.0.3/menu.png)



The menu option currently supports three flavors:



**AboutDialog**


This is an AboutDialog as rendered natively by your OS. It's a good place to show standard info like version info, descriptions, licenses, etc.. in a standard way across platforms.



**MessageDialogs**


Next up are general message dialogs. You can display any informational text inside of these.



**Link**


Finally, you can create fixed menu items that simply link to external resources, for instance, your site, documentation, pdfs, etc.. 


## Rich Text Controls

Thanks to @NathanRichard, Gooey can now optionally honor terminal control sequences and display Rich Text in the output panel.

![rich text](https://github.com/chriskiehl/GooeyImages/raw/images/docs/releases/1.0.3/rich-text.png)


### New Gooey Program Icon

<img src="https://github.com/chriskiehl/GooeyImages/raw/images/logo/gooey.png" width="200" height="auto">

New icon provided by professional cool guy and crazy talented UX designer [Justin Rhee](https://www.linkedin.com/in/justinrhee/).   

 


## Additional features

* OSX now shows program Icon in Dock 
* `show_error_modal` option to toggle whether or not failures additionally raise alert modals.
* `BlockCheckbox` widget.
* Hyperlinks written to the console appear as such and will launch a browser on click
* `clear_before_run` option lets you control whether or not subsequent program runs start from a fresh terminal or preserve the previous output.
* Conditionally show/hide restart button
* `requires_shell` option - controls how `Popen` spawns your program. By default (and historically), this value is False.
* Optionally silence textual progress updates when using the Progress widget (via @conradhilley)
* Multi-Directory Choosers - these were accidentally dropped from the project. @HenrykHaniewicz added them back!
* Additional explicit wx imports to make packaging on OSX easier
* Textfields can now be made Readonly for informational purposes
* better custom target support via `suppress_gooey_flag` which prevents the `--ignore-gooey` flag from being injected




## Breaking Changes

No breaking changes between `1.0.0` and `1.1.0`!

## Language Additions / Improvements

* Completed Italian translation - @gison93

* Updated French translation - @NathanRichard
* Updated Hebrew translation - @eturkes



## Bug Fixes

* Fixed 5 year old bug(!) where an errant lambda function wasn't passing through all of its arguments which caused frustratingly opaque failures under specific conditions.
* Fixed bug where external updates weren't applied to `ListBox`
* Fix bug where tuples weren't coerced to List which causes concatenation errors
* Fixed bug where string coercion in `argparse_to_json` was too broad and caused type errors
* Fixed bug where wrong validator was applied to Dropdown type causing preflight checks to always fail
* Fixed bug where Radio Groups would apply too much vertical spacing between components
* Fixed bug where subgroups with single items were attached to the wrong UI parent
* Fixed bug where legacy default groups weren't being translated
* Fixed bug where certain languages would sometimes cause components to be rendered off screen


