# Gooey 1.0.4 Released!

Gooey picked up some cool new widget types thanks to awesome contributions from @NathanRichard and @conradhilley. 

The rest of this release was focused on bug fixes and quality improvements. My commitment is to having Gooey be a stable, reliable project. This has required slowly shedding it's fast and loose hobby project past. Test coverage more than doubled between 1.0.3 and 1.0.4 and several bugs were fixed along the way as a result of this. The next few releases of Gooey will be similarly focused on bringing its codebase up to snuff so that wider changes can be made without introducing unexpected regressions.  


## Upgrading from 1.0.3 to 1.0.4

Translation notice! Yes/No options in confirmation modals are now backed by the language files. Previously, they were fixed to english regardless of the selected language. If the new language options aren't configured for your language, you will now see a translation request in the button label! 


## What's new


### Widgets: TimeChooser

<p align="center">
    <img src="https://github.com/chriskiehl/GooeyImages/raw/images/docs/releases/1.0.4/time-chooser-demo.JPG">
</p>

Usage: 

```python
parser = GooeyParser()
parser.add_argument('--time', widget='TimeChooser')
``` 

@NathanRichard added this one after an excellent deep dive into the complexities of dealing with time inside of WX. See the README for notes on usage. 


### Widgets: ColourChooser

<p align="center">
    <img src="https://github.com/chriskiehl/GooeyImages/raw/images/docs/releases/1.0.4/color-chooser-demo.jpg">
</p>

Usage: 

```python
parser = GooeyParser()
parser.add_argument('--color', widget='ColourChooser')
``` 

@conradhilley brought this one to life. You can now select colors from an awesome little chooser widget.  


### CLI based defaults 

@jschultz added the ability to use arguments passed on the command line as defaults in Gooey.  Enable this functionality by passing `use_cmd_args` to the Gooey decorator. 

```python
@Gooey(use_cmd_args=True)
def main():
    parser = ArgumentParser()
    parser.add_argument('--foo')
```

Now any CLI args you pass when invoking your program will show up as defaults in Gooey. 

```
python my_program.py --foo "hello!" 
```

### Additional features

 - Added option to start Gooey in full screen mode


## Language Additions / Improvements

 * @foben - documentation fixes 
 * @gediz - turkish translations 
 * @dsardelic - bosnian & Croatian translations
 * @partrita - Korean translations 


## Bug Fixes 

 - Main README image had a typo "Command Lines Applications" 
 - Truthy values 
 - Fixed bug where nargs in textfields weren't being mapped correctly
 - Fixed bug where argparse's SUPPRESS flag was showing in the UI
 - Fixed missing i18n capabilities in modals
 - Fixed bug where program_description wasn't being honored
 - Fixed bug where gooey_options weren't being honored in the Header
 - Fixed bug where RadioGroup wasn't enabling it's child widget when `initial_selection` was set
 - Fixed bug where checkboxes weren't honoring visibility options
 - Fixed bug where gooey_options weren't being passed to footer 
    
 

