## Gooey 1.0.6 Released! 


This is a minor release beefing up the new FilterableDropdown's search capabilities and performance. In the previous release, the dropdown was backed by WX's `ListBox` widget. 1.0.6 replaces this for a fully virtualized version which allows Gooey to operate on massive datasets without taking a hit to UI performance. Additionally, how Gooey internally filters for matches has also been updated. Choice are now backed by a trie for super fast lookup even against large data sets. Tokenization and match strategies can be customized to support just about any lookup style.      

Head over to the [Examples Repo](https://github.com/chriskiehl/GooeyExamples) to see the updated demo which now uses a dataset consisting of about 25k unique items.  


**New Gooey Options:**

`FilterableDropdown` now takes a `search_strategy` in its `gooey_options`.   

```python
from gooey import Gooey, GooeyParser, PrefixTokenizers

gooey_options={
    'label_color': (255, 100, 100),
    'placeholder': 'Start typing to view suggestions',
    'search_strategy': {
        'type': 'PrefixFilter',
        'choice_tokenizer': PrefixTokenizers.ENTIRE_PHRASE,
        'input_tokenizer': PrefixTokenizers.REGEX('\s'),
        'ignore_case': True,
        'operator': 'AND',
        'index_suffix': False
    }
})
```

This gives control over how the choices and user input get tokenized, as well as how those tokenized matches get treated (ANDed together vs ORd). Want to match on any part of any word? Enable the `index_suffix` option to index all of your candidate words by their individual parts. e.g. 

```
Word: 'Banana' 
Suffixes: ['Banana', 'anana', 'nana', 'ana']
```

These all get loaded into a trie for super fast lookup. Combine this with the `WORDs` tokenizer, and you get really fine grained search though your options! 


## Thank you to the current Patreon supporters! 

* Qteal
* Joseph Rhodes


## Breaking Changes 

No breaking changes from 1.0.5.

 

