## Gooey 1.0.7 Released! 

Lots of new stuff this release! We've got 3 new widget types, new gooey_options, as well as some quality of Life improvements for using Gooey Options. 


### New Widgets: IntegerField, DecimalField, and Slider

<p align="center"><img src="https://github.com/chriskiehl/GooeyImages/raw/images/docs/releases/1.0.7/numeric-inputs.gif" ></p>


Gooey now has 3 inputs specifically geared towards accepting numeric inputs. Previously, all Gooey had were text fields which you could add `validators` to in order to enforce only numbers were entered, but now we have top level widgets which do all of that out of the box! 
  
**Important Usage Note:** since these numeric inputs don't allow any non-numeric characters to be entered, they do **not** give you the ability to blank them out. Unlike a `TextField` which can be left empty and thus have its value not passed to your program, the numeric inputs will always send a value. Thus, you have to have sane handling in user-land.   

Checkout the [Options docs](https://github.com/chriskiehl/Gooey/blob/master/docs/Gooey-Options.md) for more details. 

 
### New Gooey Options: placeholder 

<p align="center"><img src="https://github.com/chriskiehl/GooeyImages/raw/images/docs/releases/1.0.7/placeholders.gif" ></p>

Widgets with text inputs now all accept a `placeholder` Gooey option. 

```python
add_argument('--foo', widget='TextField', gooey_options=options.TextField(
    placeholder='Type some text here!'
)

# or without the options helper 
add_argument('--foo', widget='TextField', gooey_options={
    'placeholder': 'Type some text here!'
})
```


### New Validator option: RegexValidator

```python
add_argument('--foo', widget='TextField', gooey_options=options.TextField(
    placeholder='Type some text here!',
    validator=options.RegexValidator(
        test='\d{4}',
        message='Must be exactly 4 digits long!'
    )
)

# or without the options helper 
add_argument('--foo', widget='TextField', gooey_options={
    'placeholder': 'Type some text here!',
    'validator': {
        'type': 'RegexValidator',
        'test': '\d{4}',
        'message': 'Must be exactly 4 digits long!'
    }
})
```

 
### New feature: Options helpers 

Gooey now has a top-level `options` module which can be imported. Previously, Gooey Options have been an opaque map. While great for openness / extensibility, it's pretty terrible from a discoverability / "what does this actually take again..?" perspective. The new `options` module aims to make using `gooey_options` easier and more discoverable. 

```python
from gooey import options
```

The goal is to enable IDE's to provide better auto-completion help as well as more REPL driven usefulness via help() and docstrings. 

```python
from gooey import options

parser.add_argument(
    '--foo', 
    help='Some foo thing',
    widget='FilterableDropdown',
    gooey_options=options.FilterableDropdown(
        placeholder='Search for a Foo',
        search_strategy=options.PrefixSearchStrategy(
            ignore_case=True 
        )
    ))
``` 

Note that these are _just_ helpers for generating the right data shapes. They're still generating plain data behind the scenes and thus all existing `gooey_options` code remains 100% compatible. 

**Better Docs:**

Which is to say, documentation which actually exists rather than _not_ exist. You can inspect the docs live in the REPL or by hopping to the symbol in editors which support such things. 

```
>>> from gooey import options 
>>> help(options.RadioGroup) 
Help on function FileChooser in module __main__:

FileChooser(wildcard=None, default_dir=None, default_file=None, message=None, **layout_options)
    :param wildcard: Sets the wildcard, which can contain multiple file types, for 
                     example: "BMP files (.bmp)|.bmp|GIF files (.gif)|.gif"
    :param message:  Sets the message that will be displayed on the dialog.
    :param default_dir: The default directory selected when the dialog spawns 
    :param default_file: The default filename used in the dialog
    
    Layout Options:
    ---------------
    
    Color options can be passed either as a hex string ('#ff0000') or as
    a collection of RGB values (e.g. `[255, 0, 0]` or `(255, 0, 0)`)
    
    :param label_color:    The foreground color of the label text
    :param label_bg_color: The background color of the label text.
    :param help_color:     The foreground color of the help text.
    :param help_bg_color:  The background color of the help text.
    :param error_color:    The foreground color of the error text (when visible).
    :param error_bg_color: The background color of the error text (when visible).
    :param show_label:     Toggles whether or not to display the label text
    :param show_help:      Toggles whether or not to display the help text
    :param visible:        Hides the entire widget when False. Note: the widget
                           is still present in the UI and will still send along any
                           default values that have been provided in code. This option
                           is here for when you want to hide certain advanced / dangerous
                           inputs from your GUI users.
    :param full_width:     This is a layout hint for this widget. When True the widget
                           will fill the entire available space within a given row.
                           Otherwise, it will be sized based on the column rules
                           provided elsewhere. 
```

Ideally, and eventually, we'll be able to completely type these options to increase visibility / usability even more. However, for backwards compatibility reasons, Gooey will continue to be sans anything more than the most basic of type hinting for the time being.


## Breaking Changes 

**No breaking API changes from 1.0.6 to 1.0.7.** However, the _strictness_ of existing Gooey Options has been increased, which _could_ result in issues when upgrading from 1.0.6. In an attempt to be helpful, Gooey now throws an exception if invalid Gooey Options are supplied. This is to catch things like invalid types or ill-formed data. If you were passing bad data in 1.0.6, it will now be flagged as such in 1.0.7.   


## Thank you to the current [Patreon supporters](https://www.patreon.com/chriskiehl)! 

* Sponsors: 
    * Qteal
* Individuals: 
    * Joseph Rhodes
    * Nicholas 
    

    
    