## Gooey 1.0.8 Released! 


Another minor Gooey release! This one brings a new global Gooey Option for setting initial values in the UI, support for `version` action types, plus a few bug/linting fixes.

Additionally, I continue to plug away at getting the test coverage to useful levels. We're now pushing 80% coverage which is making working on Gooey with confidence much easier!   


### New Gooey Options: initial_value 

This option lets you specify the value present in the widget when Gooey starts. 

```python
parser.add_argument('-my-arg', widget='Textarea', gooey_options={
    'initial_value': 'Hello world!'  
})
```

Or, using the new `options` helpers: 

```python
from gooey import options 
parser.add_argument('-my-arg', widget='Textarea', gooey_options=options.Textarea(
    initial_value='Hello World!'
))
```

If you've been using Gooey awhile, you'll recognize that this overlaps with the current behavior of `default`. The new `initial_value` enables you to supply a truly optional seed value to the UI. When using `default`, even if the user clears your value out of the UI, argparse will add it back in when it parses the CLI string. While this is often useful behavior, it prevents certain workflows from being possible. `initial_value` let's you control the UI independent of argparse. This means you can now, for instance, set a checkbox to be checked by default in the UI, but optionally allow the user to deselect it without having argprase re-populate the 'checked' state (a behavior which comes up frequently in the issue tracker due to it being technically correct, but also very confusing!). 


### action=version support 

When using `action='version'` Gooey will now map it a CheckBox widget type. 


### Other Fixes / Changes: 

 * Bug fix: add missing translation step for tabbed group titles (@neonbunny)
 * Linting: swap `is not` for `!=` (@DrStrinky) 


## Breaking Changes 

**No breaking API changes from 1.0.7 to 1.0.8**   


## Thank you to the current [Patreon supporters](https://www.patreon.com/chriskiehl)! 

* Sponsors: 
    * Qteal
* Individuals: 
    * Joseph Rhodes
    * Nicholas 
    * Joey
    

    
    