# Gooey 1.2.0-ALPHA Released! 

### Warning: 

>**Upgrade with caution!** 1.2.0 removes the experimental Dynamic Updates feature and replaces it with a _new_ experimental Dynamic Updates feature! The two APIs are incompatible.    

This release brings a whole host of new features to Gooey. Chief among them are the new Dynamic Updates and Validation functionality. This was effectively a rebuild of a substantial portion of Gooey's internal to enable a more client/server style functionality. This means that you have more control over the gooey's lifecycle, and can subscribe to high level events. Currently, FormSubmit, OnComplete, and OnError are supported, but more are on their way! Soon you'll be able to have fine grained control over the UI and its presentation, and still without having to write a single line of traditional GUI code! 


### Breaking Changes (1.0.8 -> 1.2.0) 

 * **Validation** - the validation mechanism available via gooey_options has been removed entirely in favor of the new API.   
 * **Dynamic Updates** - there was previously minimal support for loading new data at run time. This has been revomed in favor of a new system which gives advanced control over the state of the UI. 

### New Features

* **Dynamic Updates and Validation** - Checkout the [README](https://github.com/chriskiehl/Gooey/blob/master/README.md) for details on how to get started. This feature is really hairy behind the scenes and involves all kinds of crazy monkey patching in order to work. Odds of encountering a bug or scenario that doesn't work for your use case is high in this initial release. Please fill out an issue if any problems pop up! Checkout [the examples repo](https://github.com/chriskiehl/GooeyExamples/blob/master/examples/lifecycle_hooks.py) to see the new lifecycle hooks in action. 
* **Graceful Shutdown control** - Gooey previously would `SIGTERM` your application when you tried to halt it while running. However, with 1.2.0, you have control over which signal Gooey sends when you request a shutdown. This gives you a chance to catch that signal and clean up and resources currently un use before shutting down.
* **Better sys.argv handling** - Gooey no longer mutates the global sys.argv variable. This caused people all kinds of problems -- most frequent being Gooey spawning multiple windows. This is now removed, and hopefully all the pain stemming from it as well. 
     


 
  
  
 