# Agentic Search

{% Video link="https://www.youtube.com/embed/_VAPVcdow-Q" title="Framework-less Agentic Search" /%}

We've seen how retrieval enables LLMs to answer questions over private data and maintain state for AI applications. While this approach works well for simple lookups, it falls short in most real-world scenarios.

Consider building an internal chatbot for a business where a user asks: 

> What were the key factors behind our Q3 sales growth, and how do they compare to industry trends?

Suppose you have Chroma collections storing quarterly reports, sales data, and industry research papers. A simple retrieval approach might query the sales-data collection—or even all collections at once—retrieve the top results, and pass them to an LLM for answer generation.

However, this single-step retrieval strategy has critical limitations:
* **It can't decompose complex questions** - This query contains multiple sub-questions: internal growth factors, external industry trends, and comparative analysis. The information needed may be scattered across different collections and semantically dissimilar documents.
* **It can't adapt its search strategy** - If the first retrieval returns insufficient context about industry trends, there's no mechanism to refine the query and search again with a different approach.
* **It can't handle ambiguous terms** - "Q3" could refer to different years across your collections, while "sales growth" might mean unit sales, revenue, or profit margins. A single query has no way to disambiguate and search accordingly.

**Agentic search** addresses these limitations by enabling your AI application to use retrieval intelligently - planning, reasoning, and iterating much like a human researcher. At its core, an agentic search system uses an LLM to break down a user query and iteratively search for information needed to generate an answer. The system:
1. **Plans** - Breaks down complex queries into a sequence of retrieval steps
2. **Executes** - Performs targeted searches across Chroma collections or using other tools
3. **Evaluates** - Assesses whether the retrieved information answers the question or identifies gaps
4. **Iterates** - Refines the plan and repeats steps 2-3 based on what it has learned so far
5. **Synthesizes** - Combines information from multiple retrievals to form a comprehensive answer

Instead of executing a single query and hoping for the best, an agentic approach allows the agent to break down complex questions into manageable sub-queries, execute multiple retrievals across different Chroma collections, evaluate whether the retrieved information is sufficient, and refine its search strategy based on what it discovers.

For example, an agentic search system might handle our example question above as follows:

{% CollapsibleCodeBlock %}
```terminal
[PLAN] Analyzing query: "What were the key factors behind our Q3 sales growth, 
       and how do they compare to industry trends?"

[PLAN] Identified information needs:
       1. Internal Q3 sales performance metrics
       2. Factors driving the growth
       3. Industry benchmark data for comparison

━━━━━━━━━━━━━━━━━━━━━ ITERATION 1 ━━━━━━━━━━━━━━━━━━━━━

[EXECUTE] Querying collection: sales-data
          Query: "Q3 2024 sales growth revenue"
          n_results: 5

[RETRIEVED] Found 5 chunks
            - Q3 revenue up 15% YoY
            - Enterprise segment primary growth driver
            - Consumer segment flat

[EVALUATE] ✓ Growth metrics obtained (15%)
           ✗ Root causes unclear - need more detail on drivers
           ✗ Industry comparison data missing

━━━━━━━━━━━━━━━━━━━━━ ITERATION 2 ━━━━━━━━━━━━━━━━━━━━━

[EXECUTE] Querying collection: sales-data
          Query: "Q3 2024 enterprise growth factors drivers"
          n_results: 5

[RETRIEVED] Found 5 chunks
            - New AI-powered analytics features launched in Q3
            - Sales team expanded by 20%
            - Three major enterprise deals closed

[EVALUATE] ✓ Internal factors identified
           ✗ Still missing industry benchmarks

━━━━━━━━━━━━━━━━━━━━━ ITERATION 3 ━━━━━━━━━━━━━━━━━━━━━

[EXECUTE] Querying collection: industry-research
          Query: "Q3 2024 software industry revenue growth benchmarks"
          n_results: 3

[RETRIEVED] Found 3 chunks
            - Industry average: 8% growth in Q3 2024
            - Market conditions: moderate growth environment
            - Top performers: 12-18% growth range

[EVALUATE] ✓ All information requirements satisfied
           ✓ Ready to synthesize answer

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

[SYNTHESIZE] Combining findings from 3 retrievals across 2 collections...

[ANSWER] Our 15% Q3 growth significantly outperformed the 8% industry average,
         placing us in the top performer category. This was driven by our AI 
         analytics feature launch and 20% sales team expansion, which enabled 
         us to close three major enterprise deals during the quarter.
```
{% /CollapsibleCodeBlock %}

Agentic search is the technique that powers most production AI applications.

* Legal assistants search across case law databases, statutes, regulatory documents, and internal firm precedents.
* Medical AI systems query across clinical guides, research papers, patient records, and drug databases to support medical reasoning.
* Customer support AI agents navigate product documentation, past ticket resolutions, and company knowledge bases, while dynamically adjusting their search based on specific use cases.
* Coding assistants search across documentation, code repositories, and issue trackers to help developers solve problems.

The common thread across all these systems is that they don't rely on a single retrieval step, but instead use agentic search to orchestrate multiple searches, evaluate results, and iteratively gather the information needed to provide accurate and comprehensive answers.

In more technical terms, an agentic search system implements several key capabilities:
* **Query Planning** - using the LLM to analyze the user's question and generate a structured plan, breaking the input query down to sub-queries that can be addressed step-by-step.
* **Tool Use** - the agent has access to a suite of tools - such as querying Chroma collections, searching the internet, and using other APIs. For each step of the query plan, we ask an LLM to repeatedly call tools to gather information for the current step.
* **Reflection and Evaluation** - at each step, we use an LLM to evaluate the retrieved results, determining if they're sufficient, relevant, or if we need to revise the rest of our plan.
* **State Management and Memory** - the agent maintains context across all steps, tracking retrieved information, remaining sub-queries, and intermediate findings that inform subsequent retrieval decisions.

## BrowseComp-Plus

In this guide we will build a Search Agent from scratch. Our agent will be
able to answer queries from the [BrowseComp-Plus](https://github.com/texttron/BrowseComp-Plus/tree/main) dataset, which is
based on OpenAI's [BrowseComp](https://openai.com/index/browsecomp/) benchmark. The dataset contains
challenging questions that need multiple rounds of searching and reasoning
to answer correctly.

This makes it ideal for demonstrating how to build an agentic search system and
how tuning each of its components (retrieval, reasoning, model selection, and more) affects
overall performance.

Every query in the BrowseComp-Plus dataset has
* Gold docs - that are needed to compile the final correct answer for the query.
* Evidence docs - are needed to answer the query but may not directly contain the final answer themselves. They provide supporting information required for reasoning through the problem. The gold docs are a subset of the evidence docs.
* Negative docs - are included to deliberately make answering the query more difficult. They are introduced to distract the agent, and force it to distinguish between relevant and irrelevant information.

For example, here is query `770`:

```terminal
Could you provide the name of the individual who:
- As of December 2023, the individual was the coordinator of a research group founded in 2009.  
- Co-edited a book published in 2018 by Routledge.  
- The individual with whom they co-edited the book was a keynote speaker at a conference in 2019. 
- Served as the convenor of a panel before 2020. 
- Published an article in 2012. 
- Completed their PhD on the writings of an English writer.
```

And the evidence documents in the dataset needed for answering this question:

{% TabbedUseCaseCodeBlock language="terminal" scrollable=true %}

{% Tab label="6753" %}
```terminal
---
title: Laura Lojo-Rodríguez
date: 2015-05-01
---
Dr. Laura Lojo-Rodriguez is currently the supervisor of the research group "Discourse and Identity," funded by the Galician Regional Government for the period 2014–2018.
Lojo-Rodríguez is Senior Lecturer in English Literature at the Department of English Studies of University of Santiago de Compostela, Spain, where she teaches Literature(s) in English, Literary Theory, and Gender Studies. She is also convenor of the Short Story Panel of the Spanish Association of English and American Studies (AEDEAN).
Research interests: Contemporary British fiction; short story; critical theory; comparative literature.
Publications
2018. "Magic Realism and Experimental Fiction: From Virginia Woolf to Jeanette Winterson", in Anne Fernald, ed. The Oxford Handbook of Virginia Woolf. Oxford: Oxford University Press. Forthcoming.
2018. '"Thought in American and for the Americans": Victoria Ocampo, Sur and European Modernism', in Falcato A., Cardiello A. eds. The Condition of Modernism. Cham: Palgrave Macmillan, 2018, 167-190.
2017. "Tourism and Identitary Conflicts in Monica Ali's Alentejo Blue". Miscelánea: A Journal of English and American Studies. vol. 56(2017): 73-90 201.
2017. "Writing to Historicize and Contextualize: The Example of Virginia Woolf". The Discipline, Ethics, and Art of Writing about Literature. Ed. Kirilka Stavreva. Gale-Cengage, Gale Researcher British Literature. 2017. Online.
2016. "Virginia Woolf in Spanish-Speaking Countries". The Blackwell Companion to Virginia Woolf. Ed. Jessica Berman. Oxford: Wiley-Blackwell, 2016. 46-480.
2015. "La poética del cuento en la primera mitad del siglo XX en Reino Unido: Virgina Woolf y Elizabeth Bowen". Fragmentos de realidad: Los autores y las poéticas del cuento en lengua inglesa. Ed. Santiago Rodríguez Guerrero-Strachan. Valladolid: Servicio de publicaciones de la Universidad de Valladolid, pp. 111-125.
2014. "Unveiling the Past: Éilís Ní Dhuibhne's 'Sex in the Context of Ireland'". Nordic Irish Studies 13.2 (2014): 19–30.
2014. "'The Saving Power of Hallucination': Elizabeth Bowen's "Mysterious Kôr" and Female Romance". Zeitschrift für Anglistik und Amerikanistik 62.4 (2014): 273–289.
2013. "Exilio, historia, e a visión feminina: Éilís Ní Dhuibhne" in Felipe Andrés Aliaga Sáez, ed., Cultura y migraciones: Enfoques multidisciplinarios. Santiago de Compostela: Servicio de publicaciones de la Universidad, 2013, 178–183.
2012. (ed.). Moving across a Century: Women's Short Fiction from Virginia Woolf to Ali Smith. Bern: Peter Lang, 2012.
2012. "Recovering the Maternal Body as Paradise: Michèle Roberts's 'Charity'". Atlantis: A Journal of the Spanish Association of Anglo-American Studies 34.2 (Dec 2012): 33–47.
2011. (with Jorge Sacido-Romero) "Through the Eye of a Postmodernist Child: Ian McEwan's 'Homemade'". Miscelánea: A Journal of English and American Studies 44 (2011): 107–120.
2011. "Voices from the Margins: Éilís Ní Dhuibhne's Female Perspective in The Pale Gold of Alaska and Other Stories". Nordic Irish Studies 10 (2011): 35–40.
2011-2012. "Joyce's Long Shadow: Éilís Ní Dhuibhne's Short Fiction". Papers on Joyce 17.18 (2011-2012): 159–178.
2010. (with Manuela Palacios and Mª Xesús Nogueira). Creation, Publishing, and Criticism: The Advance of Women's Writing. Bern: Peter Lang, 2010.
2009. "The Poetics of Motherhood in Contemporary Irish Women's Verse" in Manuela Palacios and Laura Lojo-Rodríguez, eds., Writing Bonds: Irish and Galician Women Poets. Bern: Peter Lang, 2009, 123-142.
2009. "Making Sense of Wilderness: An Interview with Anne Le Marquand Hartigan" in Manuela Palacios and Laura Lojo-Rodríguez, eds., Writing Bonds: Irish and Galician Women Poets. Bern: Peter Lang, 2009, 195–204.
2008. "Virginia Woolf's Female History in 'The Journal of Mistress Joan Martyn'". Short Story 16.1 (2008): 73–86.
```
{% /Tab %}

{% Tab label="68484" %}
```terminal
---
title: ABOUT US
date: 2019-01-01
---
ABOUT US
DISCOURSE AND IDENTITY (D&I) is a Competitive Reference Research Group ((ED431C 2019/01, Xunta de Galicia) located in the Department of English and German Studies at the University of Santiago de Compostela (USC). Coordinated by Laura Lojo-Rodríguez, D&I is integrated into the following research networks:
	- English Language, Literature and Identity III (ED431D 2017/17)
- European Research Network for Short Fiction (ENSFR)
- Contrastive Linguistics: Constructional and Functional Approaches (FWO-Flanders)
Endowed with an interdisciplinary scope, D&I brings together researchers working in the fields of English Language, Literature and History-Culture. The group includes senior and junior scholars from the USC, support staff and external collaborators from other universities in Spain as well as from Simon Fraser University, University of Notre Dame, Brown University, University of Sussex, University College London or VU University Amsterdam. The research conducted by the members of the group is funded by the University of Santiago de Compostela, the Galician Regional Government (Xunta de Galicia), the Spanish Government as well as by various European entities.
D&I was founded in 2009 with a two-fold objective: to further interdisciplinary inquiry into the relationship between discourse and identity, and to foster high quality research through a successful partnership between Linguistics, Literature and Cultural Studies. The research conducted within the group looks into the relationship between discourse in its multiple manifestations (i.e. linguistic, literary, aesthetic, cultural, semiotic) and the configuration of gender, ethnic, class and cultural identities, taking into account the potential ideologies underlying the discourse-identity correlation. As foregrounded by such approaches as "Critical Discourse Analysis", "Social Semiotics" or "Cognitive Grammar", there exists an intimate relationship between:
-
"discourse" (< Lat dis-currere), understood as the semiotic (not simply linguistic) processes and systems that intervene in the production and interpretation of speech acts (Van Dijk 1985),
-
"identity" (< Lat idem-et-idem), referring both to individual and cultural identity in a given context, as well as to the synergies and antagonisms that might arise between them,
-
"ideology", a concept that we interpret as a systematic body of ideas organised according to a particular viewpoint,
Due to its complexity and broad scope, the critical analysis of the interaction between discourse-identity-ideology needs to be addressed from an interdisciplinary approach, which requires – and at the same time justifies – the collaboration of the different teams working within this research group, to which we should also add the incorporation of the epistemology provided by other disciplines such as psychology, sociology or semiotics. Indeed, the group fosters connections with scholars from other areas who share an interest in the study of discourse and/or identity. Additionally, group members also work in conjunction with a number of scientific and professional societies, scholarly journals, publishing houses and institutions.
LINKS
Collaborating RESEARCH NETWORKS
- Contrastive Linguistics: Constructional and Functional Approaches
- European Research Network for Short Fiction
Collaborating INSTITUTIONS
- AEDEAN (Asociación Española de Estudios Anglo-norteamericanos)
- Amergin. Instituto Universitario de Estudios Irlandeses
- Asociación Española James Joyce
- Asociación de Escritores en Lingua Galega
- Celga-ILTEC. Centro de Estudos de Linguística Geral e Aplicada da Universidade de Coimbra
- CIPPCE (Centro de Investigación de Procesos e Prácticas Culturais Emerxentes)
- Instituto Cervantes (Dublín)
- The Richard III Society
- SELICUP (Sociedad Española de Estudios Literarios de Cultura Popular)
- SITM (Société Internationale pour l'étude du théâtre médiéval)
D&I has organized various activities resulting from the interdisciplinary collaboration between different research teams, the various editions of the International Workshop on Discourse Analysis (2011, 2013, 2015, 2016) and the International Conference on 'The Discourse of Identity' (2012, 2016) being prominent examples in this respect. Both events have successively gathered together more than 300 recognized experts in the fields of English Linguistics, Literature and History-Culture, which turns D&I into a leading research group in discourse and identity studies. In addition to the organization of conferences, workshops and seminars, the group regularly hosts speakers from universities all over the world, thus contributing to the internationalization of our work and to forging new partnerships and collaborations. Research results have also been transferred through multiple publications in world-leading publishing houses and journals. This academic work has led the D&I Research Group to receive generous funding from a variety of entities. Since its foundation in 2009, group members have participated in more than 10 research projects funded by regional, national and international entities. Currently, the group receives funding from the Galician Regional Government (Xunta de Galicia) as a Competitive Reference Research Group. The group has also proved itself to have a strong teaching and training capacity. In the period since 2009, well over 50 theses have been completed and currently there are more than 20 Ph. D. dissertations in progress.
AWARDS
- Gómez González, María de los Ángeles. Premio 'Rafael Monroy' para investigadores experimentados, concedido pola Asociación Española de Lingüística Aplicada (AESLA), 2019.
- Martínez Ponciano, Regina. Premio de investigación 'Patricia Shaw', concedido pola Asociación Española de Estudios Anglonorteamericanos (AEDEAN), 2016.
- Palacios González, Manuela. Premio de Promoción da USC en Destinos Internacionais (1º premio na categoría de Artes e Humanidades)
```
{% /Tab %}

{% Tab label="1735" %}
```terminal
---
title: Creation, Publishing, and Criticism
author: Maria Xesus Nogueira Laura Lojo Rodriguez Manuela Palacios
date: 2025-01-01
---
Creation, Publishing, and Criticism
The Advance of Women's Writing
©2010
Monographs
XX,
230 Pages
Series:
Galician Studies, Volume 2
Summary
Since the 1980s, there has been an unprecedented and unremitting rise in the number of women writers in Galicia and Ireland. Publishers, critics, journals, and women's groups have played a decisive role in this phenomenon. Creation, Publishing, and Criticism provides a plurality of perspectives on the strategies deployed by the various cultural agents in the face of the advance of women authors and brings together a selection of articles by writers, publishers, critics, and theatre professionals who delve into their experiences during this process of cultural change. This collection of essays sets out to show how, departing from comparable circumstances, the Galician and the Irish literary systems explore their respective new paths in ways that are pertinent to each other. This book will be of particular interest to students of Galician and Irish studies, comparative literature, women's studies, and literary criticism. Both specialists in cultural analysis and the common reader will find this an enlightening book.
Details
- Pages
- XX, 230
- Publication Year
- 2010
- ISBN (PDF)
- 9781453900222
- ISBN (Hardcover)
- 9781433109546
- DOI
- 10.3726/978-1-4539-0022-2
- Language
- English
- Publication date
- 2010 (November)
- Keywords
- Irish literature Women Writers Poetry Fiction Theatre Publishing Criticism literary creation. Galician literature
- Published
- New York, Bern, Berlin, Bruxelles, Frankfurt am Main, Oxford, Wien, 2010. XX, 230 pp.
- Product Safety
- Peter Lang Group AG
```
{% /Tab %}

{% Tab label="60284" %}
```terminal
---
title: Publications
date: 2018-06-23
---
PUBLICATIONS
2018
- Lojo-Rodríguez, Laura. \"'Genealogies of Women': Discourses on Mothering and Motherhood in the Short Fiction of Michèle Roberts\" en Gender and Short Fiction: Women's Tales in Contemporary Britain. London and New York: Routledge, 2018. 102-122.
- Lojo-Rodríguez, Laura. \"England's Most Precious Gift: Virginia Woolf's Transformations into Spanish\". A Companion to World Literature. Ed. Kenneth Seigneurie. Oxford: Blackwells, 2018.
- Lojo-Rodríguez, Laura. \"Magic Realism and Experimental Fiction: From Virginia Woolf to Jeanette Winterson\", in Anne Fernald, ed. The Oxford Handbook of Virginia Woolf. Oxford: Oxford University Press, 2018 [forthcoming]
- Lojo-Rodríguez, Laura. '\"Thought in American and for the Americans\": Victoria Ocampo, Sur and European Modernism', in Ana Falcato, ed. Philosophy in the Condition of Modernism. Londres: Palgrave, 2018: 167-190.
- Lojo-Rodríguez, Laura. \"Victorian Male Heroes and Romance in Elizabeth Bowen's Short Fiction\". En Tracing the Heroic through Gender, Monika Mommertz, Thomas Seedorf, Carolin Bahr, Andreas Schlüter, eds. Würzburg.
- Sacido-Romero, Jorge and Laura Lojo Rodríguez. Gender & Short Fiction: Women's Tales in Contemporary Britain. Londres: Routledge.
- Sacido Romero, Jorge \"Chapter 10: In a Different Voice: Janice Galloway's Short Stories\". Gender and Short Fiction: Women's Tales in Contemporary Britain. Eds. J. Sacido and L. Lojo. New York: Routledge, 2018, pp. 191-214.
- Sacido Romero, Jorge y Laura María Lojo Rodríguez. \"Introduction\". Gender and Short Fiction: Women's Tales in Contemporary Britain. Eds. J. Sacido and L. Lojo. New York: Routledge, 2018, pp. 1-14.
- Sacido-Romero, Jorge. \"Liminality in Janice Galloway's Short Fiction\". Zeitschrift für und Amerikanistik: A Quarterly of Language, Literature and Culture. 66/4 (2018). [Forthcoming]
- Sacido-Romero, Jorge. \"An Interview with Janice Galloway\". The Bottle Imp 23 (June 2018)
- Sacido-Romero, Jorge. \"Intertextuality and Intermediality in Janice Galloway's 'Scenes from the Life' (Blood 1991)\". Short Fiction in Theory and Practice 8/1 (2018).
PREVIOUS PUBLICATIONS
2017
- Lojo-Rodriguez, Laura. \"Tourism and Identitary Conflicts in Monica Ali's Alentejo Blue\". Miscelánea: A Journal of English and American Studies. vol. 53 (2017): 73-90.
- Lojo-Rodriguez, Laura. \"Writing to Historicize and Contextualize: The Example of Virginia Woolf\". The Discipline, Ethics, and Art of Writing about Literature. Ed. Kirilka Stavreva. Gale-Cengage, Gale Researcher British Literature. Online.
- Mieszkowksi, Sylvia. \"An Interview with A. L. Kennedy\". The Bottle Imp 22. Online at: 
2016
- Lojo-Rodriguez, Laura. \"Virginia Woolf in Spanish-Speaking Countries\" in Jessica Berman, ed., The Blackwell Companion to Virginia Woolf. Oxford: Wiley-Blackwell, 2016, 446-480.
- Rallo-Lara, Carmen, J. Sacido-Romero, L. Torres-Zúñiga and I. Andrés Cuevas. \"Women's Tales of Dissent: Exploring Female Experience in the Short Fiction of Helen Simpson, Janice Galloway, A. S. Byatt, and Jeanette Winterson\". On the Move: Glancing Backwards to Build a Future in English Studies. Aitor Ibarrola-Armendariz and Jon Ortiz de Urbina Arruabarrena (eds.). Bilbao: Servicio de Publicaciones de la Universidad de Deusto, 2016, 345-50.
- Sacido-Romero, Jorge. \"Ghostly Visitations in Contemporary Short Fiction by Women: Fay Weldon, Janice Galloway and Ali Smith\". Atlantis: A Journal of the Spanish Association for Anglo-American Studies, 38.2 (Dec 2016): 83-102.
2015
- Lojo-Rodriguez, Laura. \"La poética del cuento en la primera mitad del siglo XX en Reino Unido: Virgina Woolf y Elizabeth Bowen\". Fragmentos de realidad. Servicio de publicaciones de la Universidad, 2015: 111-125.
- Mieszkowksi, Sylvia. \"Kitsch als Kitt: Die 'preposterous history' von Gilbert & Sullivans The Mikado in Mike Leighs Topsy-Turvy\" [fertig gestellt], in: Kitsch und Nation eds. Kathrin Ackermann and Christopher F. Laferl; Bielefeld: [transcript], 2015.
- Sacido-Romero, Jorge and Silvia Mieszkowski (eds.). Sound Effects: The Object Voice in Fiction. Leiden: Brill / Rodopi.
- Sacido-Romero, Jorge. \"The Voice in Twentieth-Century English Short Fiction: E.M. Forster, V.S. Pritchett and Muriel Spark,\" in J. Sacido-Romero and S. Mieszkowski, eds., Sound Effects: The Object Voice in Fiction. Leiden: Brill / Rodopi, 2015, 185–214.
2014
- Andrés-Cuevas, Isabel Ma, Laura Lojo-Rodríguez and Carmen Lara-Rallo. \"The Short Story and the Verbal-Visual Dialogue\" in E. Álvarez-López (coord. and ed.), E. M. Durán-Almarza and A. Menéndez-Tarrazo, eds., Building International Knowledge. Approaches to English and American Studies in Spain. AEDEAN/Universidad de Oviedo, 2014, 261–266.
- Andrés-Cuevas, Isabel M. \"Modernism, Postmodernism, and the Short Story in English, ed. Jorge Sacido\". Miscelánea: Revista de Estudios Ingleses y Norteamericanos 50 (2014): 173–177.
- Lara-Rollo, Carmen, Laura Lojo-Rodríguez and Isabel Andrés Cuevas). \"The Short Story and the Verbal-Visual Dialogue\" in Esther Álvarez López et al., eds., Building Interdisciplinary Knowledge. Approaches to English and American Studies in Spain. Oviedo: KRK Ediciones, 2014 261–65.
- Lojo-Rodriguez, Laura. \"'The Saving Power of Hallucination': Elizabeth Bowen's \"Mysterious Kôr\" and Female Romance\". Zeitschrift für Anglistik und Amerikanistik 62.4 (2014): 273–289.
- Lojo-Rodriguez, Laura. \"Unveiling the Past: Éilís Ní Dhuibhne's 'Sex in the Context of Ireland'\". Nordic Irish Studies 13.2 (2014): 19–30.
- Mieszkowksi, Sylvia. \"Feudal Furies: Interpellation and Tragic Irony in Shakespeare's Coriolanus\". Zeitsprünge 18 (2014), Vol. 3/4, 333–348.
- Mieszkowksi, Sylvia. \"QueerIng Ads? Imagepflege (in) der heteronormativen Gesellschaft,\" in Jörn Arendt, Lutz Hieber and York Kautt, eds., Kampf um Images: Visuelle Kommunikation in gesellschaftlichen Konfliktlagen. Bielefeld: transcript, 2014, 117–136.
- Mieszkowksi, Sylvia. \"Was war und ist Homosexualitätsforschung?\" in Jenniver Evans, Rüdiger Lautmann, Florian Mildenberge and Jakob Pastötter Homosexualität, eds., Spiegel der Wissenschaften. Hamburg: Männerschwarm Verlag, 2014.
- Mieszkowksi, Sylvia.Resonant Alterities: Sound, Desire and Anxiety in Non-Realist Fiction. Bielefeld: [transcript], 2014.
- Torres-Zúñiga, Laura. \"Autofiction and Jouissance in Tennessee Williams's 'Ten Minute Stop'\" The Tennessee Williams Annual Review (2014).
- Torres-Zúñiga, Laura. \"Sea and sun and maybe – Quien sabe! Tennessee Williams and Spain\" in J.S. Bak, ed., Tennessee Williams in Europe: Intercultural Encounters, Transatlantic Exchanges. Rodopi, 2014.
2013
- Andrés-Cuevas, Isabel Ma, Laura Lojo-Rodríguez and Jorge Sacido-Romero. \"Parents Then and Now: Infantile and Parental Crises in the Short Fiction of Katherine Mansfield, Helen Simpson and Hanif Kureishi\" in R. Arias, M. López-Rodríguez, C. Pérez-Hernández and A. Moreno-Ortiz, eds., Hopes and Fears. English and American Studies in Spain. AEDEAN/Universidad de Málaga, 2013, 304–307.
- Torres-Zúñiga, Laura. \"Comida, mujeres y poder en la obra de Tennessee Williams/Food, Women and Power in the Work of Tennessee Williams\" Dossiers Feministes 17 (2013).
- Mieszkowksi, Sylvia. \"Unauthorised Intercourse: Early Modern Bed Tricks and their Under-Lying Ideologies\". Zeitschrift für Anglistik und Amerikanistik 4 (2013): 319–340.
- Mieszkowksi, Sylvia. \"Eve Kosofsky Sedgwick\" in Marianne Schmidbaur, Helma Lutz and Ulla Wischermann, KlassikerInnen Feministischer Theorie. Bd III (1986-Gegenwart). Königstein/Taunus: Ulrike Helmer Verlag, 2013, 285–291.
- Lojo-Rodriguez, Laura. \"Exilio, historia, e a visión feminina: Éilís Ní Dhuibhne\" in Felipe Andrés Aliaga Sáez, ed., Cultura y migraciones: Enfoques multidisciplinarios. Santiago de Compostela: Servicio de publicaciones de la Universidad, 2013, 178–183.
- Lara-Rollo, Carmen. \"Intertextual and Relational Echoes in Contemporary British Short Fiction\". Il Confronto Letterario 60 sup. (2013): 119–133.
2012
- Andrés-Cuevas, Isabel Ma, Laura Lojo-Rodríguez and Carmen Lara-Rallo. \"Escenarios de la memoria: espacio, recuerdo y pasado traumático\" in S. Martín-Alegre, M. Moyer, E. Pladevall and S. Tuvau, eds., At a Time of Crisis: English and American Studies in Spain: Works from the 35th AEDEAN Conference. AEDEAN/Universidad Autónoma de Barcelona, 2012, 242–245.
- Torres-Zúñiga, Laura. \"Married Folks They are; And Few Pleasures They Have': Marriage Scenes in O. Henry's Short Stories\" in Mauricio D. Aguilera-Linde, María José de la Torre-Moreno and Laura Torres-Zúñiga, eds., Into Another's Skin: Studies in Honor of Mª Luisa Dañobeitia. Granada: Editorial Universidad de Granada, 2012.
- Sacido-Romero, Jorge. (with C. Lara-Rallo and I. Andrés Cuevas). \"Nature in Late-Twentieth-Century English Short Fiction: Angela Carter, Margaret Drabble and A. S. Byatt\". Proceedings of the 38th AEDEAN Conference.
- Sacido-Romero, Jorge. \"The Boy's Voice and Voices for the Boy in Joyce's 'The Sisters'\". Papers on Joyce 17.18 (Dec 2012): 203–242.
- Sacido-Romero, Jorge. \"Modernism, Postmodernism, and the Short Story\", in Jorge Sacido, ed. Modernism, Postmodernism and the Short Story in English. Amsterdam: Rodopi, 2012, 1-25.
- Sacido-Romero, Jorge (ed.). Modernism, Postmodernism, and the Short Story in English. Amsterdam: Rodopi, 2012
- Lojo-Rodriguez, Laura. (ed.). Moving across a Century: Women's Short Fiction from Virginia Woolf to Ali Smith. Bern: Peter Lang, 2012.
- Lojo-Rodriguez, Laura. \"Recovering the Maternal Body as Paradise: Michèle Roberts's 'Charity'\". Atlantis: A Journal of the Spanish Association of Anglo-American Studies 34.2 (Dec 2012): 33–47.
- Lara-Rollo, Carmen. \"The Rebirth of the Musical Author in Recent Fiction Written in English\". Authorship 1.2 (2012): 1–9.
- Lara-Rollo, Carmen. \"The Myth of Pygmalion and the Petrified Woman\" in José Manuel Losada and Marta Guirao, eds., Recent Anglo-American Fiction. Myth and Subversion in the Contemporary Novel. Newcastle upon Tyne: Cambridge Scholars Publishing, 2012, 199–212.
2011
- Andrés-Cuevas, Isabel Ma. \"Virginia Woolf's Ethics of the Short Story, by Christine Reynier\". Miscelánea: Revista de Estudios Ingleses y Norteamericanos 42 (2011): 173–179.
- Andrés-Cuevas, Isabel Ma and G. Rodríguez-Salas. The Aesthetic Construction of the Female Grotesque in Katherine Mansfield and Virginia Woolf: A Study of the Interplay of Life and Literature. Edwin Mellen Press: Lampeter, Ceredigion, 2011.
- Sacido-Romero, Jorge. \"Failed Exorcism: Kurtz Spectral Status and Its Ideological Function in Conrad's 'Heart of Darkness'\". Atlantis: A Journal of the Spanish Association for Anglo-American Studies. 32.2 (Dec 2011): 43–60.
- Lojo-Rodriguez, Laura. \"Voices from the Margins: Éilís Ní Dhuibhne's Female Perspective in The Pale Gold of Alaska and Other Stories\". Nordic Irish Studies 10 (2011): 35–40.
- Lojo-Rodriguez, Laura and Jorge Sacido-Romero. \"Through the Eye of a Postmodernist Child: Ian McEwan's 'Homemade'\". Miscelánea: A Journal of English and American Studies 44 (2011): 107–120.
- Lara-Rollo, Carmen. \"Deep Time and Human Time: The Geological Representation of Ageing in Contemporary Literature\" in Brian Worsfold, ed., Acculturating Age: Approaches to Cultural Gerontology. Lérida: Servicio de Publicaciones de la Universidad de Lérida, 2011, 167–86.
- Lara-Rollo, Carmen. \"'She thought human thoughts and stone thoughts': Geology and the Mineral World in A.S. Byatt's Fiction\" in Cedric Barfoot and Valeria Tinkler-Villani, eds., Restoring the Mystery of the Rainbow. Literature's Refraction of Science. Amsterdam and New York: Rodopi, 2011, 487–506.
2010
- Andrés-Cuevas, Isabel Ma, Carmen Lara-Rallo and L. Filardo-Lamas. \"The Shot in the Story: A Roundtable Discussion on Subversion in the Short Story\" in R. Galán-Moya et al., eds., Proceedings of the 33rd Aedean International Conference. Aedean/Universidad De Cádiz, 2010.
- Lojo-Rodriguez, Laura, Manuela Palacios and Mª Xesús Nogueira. Creation, Publishing, and Criticism: The Advance of Women's Writing. Bern: Peter Lang, 2010.
2009
- Lojo-Rodriguez, Laura. \"The Poetics of Motherhood in Contemporary Irish Women's Verse\" in Manuela Palacios and Laura Lojo-Rodríguez, eds., Writing Bonds: Irish and Galician Women Poets. Bern: Peter Lang, 2009, 123-142.
- Lojo-Rodriguez, Laura. \"Making Sense of Wilderness: An Interview with Anne Le Marquand Hartigan\" in Manuela Palacios and Laura Lojo-Rodríguez, eds., Writing Bonds: Irish and Galician Women Poets. Bern: Peter Lang, 2009, 195–204.
- Lara-Rollo, Carmen. \"Pictures Worth a Thousand Words: Metaphorical Images of Textual Interdependence\". Nordic Journal of English Studies. Special issue: \"Intertextuality\" 8.2 (2009): 91–110.
- Lara-Rollo, Carmen. \"Museums, Collections and Cabinets: 'Shelf after Shelf after Shelf'\" in Caroline Patey and Laura Scuriatti, eds., The Exhibit in the Text. The Museological Practices of Literature. Bern: Peter Lang, 2009, 219–39. Series: Cultural Interactions.
2008
- Lojo-Rodriguez, Laura. \"Virginia Woolf's Female History in 'The Journal of Mistress Joan Martyn'\". Short Story 16.1 (2008): 73–86.
2007
- Andrés-Cuevas, Isabel Ma. \"The Duplicity of the City in O.Henry: 'Squaring the Circle' and 'The Defeat of the City'\" in G. S. Castillo, M. R. Cabello et al., eds., The Short Story in English: Crossing Boundaries. Universidad de Alcalá de Henares, 2007, 32–42.
- Torres-Zúñiga, Laura. \"Tennessee Williams' 'Something About Him' or the Veiled Diagnosis of an Insane Society\" in Mauricio D. Aguilera-Linde et al., eds., Entre la creación y el aula. Granada: Editorial Universidad de Granada, 2007.
```
{% /Tab %}

{% /TabbedUseCaseCodeBlock %}

For this guide, we prepared a collection with a subset of the BrowseComp-Plus data. It includes the first 10 queries, their associated evidence and negative documents.

In this collection there are 10 query records. Each has the following metadata fields:
* `query_id`: The BrowseComp-Plus query ID.
* `query`: Set to `true`, indicating this is a query record.
* `gold_docs`: The list of gold doc IDs needed to answer this query

Most BrowseComp-Plus documents are too large to embed and store as they are, so we chunked them into discrete pieces. Each document record has the following metadata fields:
* `doc_id`: The original BrowseComp-Plus document ID this record was chunked from.
* `index`: The order in which this chunk appears in the original document. This is useful if we want to reconstruct the original documents.

Chunking the documents not only allows us to store them efficiently, but it is also a good context engineering practice. When the agent issues a search a smaller relevant chunk is more economical than a very large document.

## Running the Agent

Before we start walking through the implementation, let's run the agent to get a sense of what we're going to build.

{% Steps %}

{% Step %}
[Login](https://trychroma.com/login) to your Chroma Cloud account. If you don't have one yet, you can [signup](https://trychroma.com/signup). You will get free credits that should be more than enough for running this project.
{% /Step %}

{% Step %}
Use the "Create Database" button on the top right of the Chroma Cloud dashboard, and name your DB `agentic-search` (or any name of your choice). If you're a first time user, you will  be greeted with the "Create Database" modal after creating your account. 
{% /Step %}

{% Step %}
Choose the "Load sample dataset" option, and then choose the BrowseCompPlus dataset. This will copy the data into a collection in your own Chroma DB. 
{% /Step %}

{% Step %}
Once your collection loads, choose the "Settings" tab. On the bottom of the page, choose the `.env` tab. Create an API key, and copy the environment variables you will need for running the project: `CHROMA_API_KEY`, `CHROMA_TENANT`, and `CHROMA_DATABASE`.
{% /Step %}

{% Step %}
Clone the [Chroma Cookbooks](https://github.com/chroma-core/chroma-cookbooks) repo:

```terminal
git clone https://github.com/chroma-core/chroma-cookbooks.git
```

{% /Step %}

{% Step %}
Navigate to the `agentic-search` directory, and create a `.env` file at its root with the values you obtained in the previous step:

```terminal
cd chroma-cookbooks/agentic-search
touch .env
```

{% /Step %}

{% Step %}
To run this project, you will also need an [OpenAI API key](https://platform.openai.com/api-keys). Set it in your `.env` file:

```text
CHROMA_API_KEY=<YOUR CHROMA API KEY>
CHROMA_TENANT=<YOUR CHROMA TENANT>
CHROMA_DATABASE=agentic-search
OPENAI_API_KEY=<YOUR OPENAI API KEY>
```

{% /Step %}

{% Step %}

This project uses [pnpm](https://pnpm.io/installation) workspaces. In the root directory, install the dependencies:

```terminal
pnpm install
```

{% /Step %}

{% /Steps %}

The project includes a CLI interface that lets you interact with the search agent. You can run it in development mode to get started. The CLI expects one argument - the query ID to solve. From the root directory you can run

```terminal
pnpm cli:dev 770
```

To see the agent in action. It will go through the steps for solving query 770 - query planning, tool calling, and outcome evaluation, until it can solve the input query. The tools in this case, are different search capabilities over the Chroma collection containing the dataset.

Other arguments you can provide:
* `--provider`: The LLM provider you want to use. Defaults to OpenAI (currently only OpenAI is supported).
* `--model`: The model you want the agent to use. Defaults to `gpt-4o-mini`.
* `--max-plan-size`: The maximum query plan steps the agent will go through to solve the query. Defaults to 10. When set to 1, the query planning step is skipped.
* `--max-step-iterations`: The maximum number of tool-call interactions the agent will issue when solving each step. Defaults to 5.

Experiment with different configurations of the agent. For example, stronger reasoning models are slower, but may not need a query plan, or many iterations to solve a query correctly. They are more likely to be better at selecting the correct search tools, providing them with the best arguments, and reasoning through the results. Smaller or older models are faster and may not excel at tool calling. However, with a query plan and the intermediate evaluation steps, they might still produce the correct answer. 

## Building the Agent

{% Banner type="tip" %}
You can find the full implementation in the [chroma-cookbooks](https://github.com/chroma-core/chroma-cookbooks/tree/master/agentic-search) repo.
{% /Banner %}

We built a simple agent in this project to demonstrate the core concepts in this guide.

The `BaseAgent` class orchestrates the agentic workflow described above. It holds a reference to
* An `LLMService` - a simple abstraction for interacting with an LLM provider for getting structured outputs and tool calling.
* A `prompts` objects, defining the prompts used for different LLM interactions needed for this workflow (for example, generating the query plan, evaluating it, etc.).
* A list of `Tool`s that will be used to solve a user's query.

The project encapsulates different parts of the workflow into their own components.

The `QueryPlanner` generates a query plan for a given user query. This is a list of `PlanStep` objects, each keeping track of its status (`Pending`, `Success`, `Failure`, `Cancelled` etc.), and dependency on other steps in the plan. The planner is an iterator that emits the next batch of `Pending` steps ready for execution. It also exposes methods that let other components override the plan and update the status of completed steps.

The `Executor` solves a single `PlanStep`. It implements a simple tool calling loop with the `LLMService` until the step is solved. Finally it produces a `StepOutcome` object, summarizing the execution, identifying candidate answers and supporting evidence.

The `Evaluator` considers the plan and the history of outcomes to decide how to proceed with the query plan.

The `SearchAgent` class extends `BaseAgent` and provides it with the tools to search over the BrowseComp-Plus collection, using Chroma's [Search API](../../cloud/search-api/overview). It also passes the specific prompts needed for this specific search task.
