#[macro_use]
mod types;
mod api_types;
mod base64_decode;
mod collection;
mod collection_configuration;
mod collection_schema;
mod data_chunk;
mod data_record;
mod database_name;
mod execution;
mod flush;
mod hnsw_configuration;
mod log;
mod metadata;
mod operation;
pub mod operators;
pub mod operators_generated;
mod record;
mod scalar_encoding;
mod segment;
mod segment_scope;
mod signed_rbm;
mod spann_configuration;
mod spann_posting_list;
#[cfg(feature = "testing")]
pub mod strategies;
mod task;
mod tenant;
mod topology;
mod validators;
mod where_parsing;

pub mod optional_u128;
pub mod regex;

// Re-export Space from hnsw_configuration
pub use hnsw_configuration::Space;

// Re-export the types module, so that we can use it as a single import in other modules.
pub use api_types::*;
pub use base64_decode::*;
pub use collection::*;
pub use collection_configuration::*;
pub use collection_schema::*;
pub use data_chunk::*;
pub use data_record::*;
pub use database_name::*;
pub use execution::*;
pub use flush::*;
pub use hnsw_configuration::*;
pub use log::*;
pub use metadata::*;
pub use operation::*;
pub use operators::*;
pub use record::*;
pub use scalar_encoding::*;
pub use segment::*;
pub use segment_scope::*;
pub use signed_rbm::*;
pub use spann_configuration::*;
pub use spann_posting_list::*;
pub use task::*;
pub use tenant::*;
pub use topology::*;
pub use types::*;
pub use validators::validate_name;
pub use where_parsing::*;

#[allow(clippy::all)]
pub mod chroma_proto {
    tonic::include_proto!("chroma");
}
