//! Well-known operator IDs and names that are pre-populated in the database.
//!
//! ⚠️  **DO NOT EDIT THIS FILE MANUALLY** ⚠️
//!
//! These constants are auto-generated from the Go source file:
//! `go/pkg/sysdb/metastore/db/dbmodel/constants.go`
//!
//! ## To add a new operator:
//!
//! 1. Create a database migration to INSERT the operator
//!    (in `go/pkg/sysdb/metastore/db/migrations/*.sql`)
//!
//! 2. Add the UUID constant to `go/pkg/sysdb/metastore/db/dbmodel/constants.go`:
//!    ```go
//!    OperatorMyOperator = uuid.MustParse("your-uuid-here")
//!    OperatorNameMyOperator = "my_operator"
//!    ```
//!
//! 3. Run the generation script:
//!    ```bash
//!    ./bin/generate_operator_constants.sh
//!    ```
//!
//! 4. Commit the updated `operators_generated.rs` file
//!
//! See `rust/types/README_OPERATORS.md` for more details.

// Include the generated constants file (checked into git)
include!("operators_generated.rs");
