import type { SidebarsConfig } from '@docusaurus/plugin-content-docs';

const sidebars: SidebarsConfig = {
  docs: [
    {
      type: 'category',
      label: 'Getting Started',
      collapsed: false,
      items: [
        'getting_started/overview',
        'getting_started/quickstart',
        'getting_started/installation',
      ],
    },
    {
      type: 'category',
      label: 'CocoIndex Core',
      collapsed: false,
      items: [
        'core/basics',
        'core/data_types',
        'core/flow_def',
        'core/settings',
        'core/flow_methods',
        'core/cli',
      ],
    },
    {
      type: 'category',
      label: 'Tutorials',
      collapsed: false,
      items: [
        {
          type: 'autogenerated',
          dirName: 'tutorials',
        },
      ],
    },
    {
      type: 'doc',
      id: 'query',
      label: 'Query Support',
    },
    {
      type: 'category',
      label: 'Built-in Sources',
      link: { type: 'doc', id: 'sources/index' },
      collapsed: true,
      items: [
        'sources/amazons3',
        'sources/azureblob',
        'sources/googledrive',
        'sources/localfile',
        'sources/postgres',
      ],
    },
    {
      type: 'doc',
      id: 'ops/functions',
      label: 'Built-in Functions',
    },
    {
      type: 'category',
      label: 'Built-in Targets',
      link: { type: 'doc', id: 'targets/index' },
      collapsed: true,
      items: [
        'targets/postgres',
        'targets/qdrant',
        'targets/lancedb',
        'targets/neo4j',
        'targets/kuzu',
      ],
    },
    {
      type: 'category',
      label: 'Custom Operations',
      collapsed: false,
      items: [
        'custom_ops/custom_sources',
        'custom_ops/custom_functions',
        'custom_ops/custom_targets',
      ],
    },
    {
      type: 'category',
      label: 'AI Support',
      collapsed: false,
      items: [
        'ai/llm',
      ],
    },
    {
      type: 'doc',
      id: 'cocoinsight_access',
      label: 'CocoInsight Access',
    },
    {
      type: 'category',
      label: 'Contributing',
      collapsed: false,
      items: [
        'contributing/setup_dev_environment',
        'contributing/guide',
        'contributing/new_built_in_target',
      ],
    },
    {
      type: 'category',
      label: 'About',
      collapsed: false,
      items: [
        'about/community',
      ],
    },
  ],

};

export default sidebars;
