---
title: Sources
toc_max_heading_level: 4
description: CocoIndex Built-in Sources
---

# CocoIndex Built-in Sources

In CocoIndex, a source is the data origin you import from (e.g., files, databases, APIs) that feeds into an indexing flow for transformation and retrieval.

| Source Type    | Description                        |
|----------------|------------------------------------|
| [LocalFile](/docs/sources/localfile)     | Local file system                        |
| [AmazonS3](/docs/sources/amazons3)       | Object store (Amazon S3 bucket)          |
| [AzureBlob](/docs/sources/azureblob)     | Object store (Azure Blob Storage)        |
| [GoogleDrive](/docs/sources/googledrive) | Cloud file system (Google Drive)         |
| [Postgres](/docs/sources/postgres)       | Relational database (Postgres)           |

Related:
- [Life cycle of a indexing flow](/docs/core/basics#life-cycle-of-an-indexing-flow)
- [Live Update Tutorial](/docs/tutorials/live_updates)
for change capture mechanisms.
