## Description

Please explain the changes you are proposing.

---

## Related Issue(s)

Closes or relates to #

---

## Checklist

- [ ] I have referenced relevant issue numbers above
- [ ] I have performed a self-review of my code and it follows
      the style guidelines of this project
- [ ] I have added new or used existing tests that prove my fix
      is effective or that my feature works
- [ ] I have added necessary documentation (if appropriate) and
      updated the changelog
- [ ] I have added an AI assistance disclosure file (required!)
      in this PR

---

## AI Assistance Disclosure File

:warning: **Required for this PR:** You MUST include a disclosure
file at `.audit/<branch-name>.md` right in this PR. The
disclosure file must **follow the exact format and content** as
described below. _Your PR will not be accepted without a
disclosure file._

**Example 1** file contents of your disclosure file
`.audit/<branch-name>.md`:

```
## AI Assistance Disclosure

- [ ] I did **not** use any AI-assistance tools to help create this pull request.
- [x] I **did** use AI-assistance tools to *help* create this pull request.
- [x] I have read, understood and followed the projects' [AI Policy](https://github.com/crossbario/autobahn-python/blob/main/AI_POLICY.md) when creating code, documentation etc. for this pull request.

Submitted by: @your-github-username
Date: YYYY-MM-DD
Related issue(s): #issue-number
Branch: branch-name
```

**OR**

**Example 2** file contents of your disclosure file
`.audit/<branch-name>.md`:

```
## AI Assistance Disclosure

- [x] I did **not** use any AI-assistance tools to help create this pull request.
- [ ] I **did** use AI-assistance tools to *help* create this pull request.
- [x] I have read, understood and followed the projects' [AI Policy](https://github.com/crossbario/autobahn-python/blob/main/AI_POLICY.md) when creating code, documentation etc. for this pull request.

Submitted by: @your-github-username
Date: YYYY-MM-DD
Related issue(s): #issue-number
Branch: branch-name
```

---

Submitting code generated _primarily_ by AI, or for which you
cannot claim _human authorship_, is not permitted. See
[AI Policy](https://github.com/crossbario/autobahn-python/blob/main/AI_POLICY.md)
for details.

**Example 1 OR Example 2** show the only valid two variants. You
cannot have both or none of the first two marks checked, and you
must always have the last tick checked.

Well, "must" if you want your PR to be accepted and ultimately
merged that is. Of course you are always free to
`Go ahead! Fork my Day. (TM)` ;) This is Open-source.
