# Release Plan

The scheduled features for Pyarmor 8+

- [Pyarmor 8 (closed)](#plan-features-for-pyarmor-8)
- [Pyarmor 9 (working)](#plan-features-for-pyarmor-9)

## Plan Features For Pyarmor 8

**8.0**

Status: released

- Support Python 3.11
- Introduce 3 new commands: gen, cfg, reg
- Introduce BCC Mode, an irreversible obfuscation method
- Introduce RFT mode, an irreversible obfuscation method
- Localize and internationalize runtime error messages
- Check expired date by NTP server

**8.1**

Status: released

- Support platform darwin.aarch64 (Apple M1), linux.aarch64
- Support platform windows.x86, linux.x86, linux.armv7 without BCC mode

**8.2**

Status: released (2023-05-10)

- Full documentation
- Group license available
- Support plugins and hooks
- BCC mode for windows.x86, linux.x86, linux.armv7
- Variable runtime package name for non trial version by `pyarmor cfg package_name_format "xxxx"`
- Clear frame locals by `pyarmor cfg clear_frame_locals 1`
- Improve pack security by
  - protect system package
  - bind interp
  - check debugger

**8.3**

Status: relealsed (2023-08-01)

- Support `--enable-themida`
- pyarmor-webui for 8.0
- Support multiple Python versions
- Support platforms: Android, Alpine Linux (musl-c/docker), FreeBSD
- Support new arch `loongarch64` for Linux
- Group license supports unlimited dockers which uses default bridge network and not highly customized.

**8.4**

Status: released (2023-10-18)

- Support Python 3.12

**8.5**

Status: released (2024-03-08)

- Expert users could write their own python code in pyarmor_runtime initialization
- New plugin "post_script" called after each script has been obfuscated
- Runtime key could be obfuscated
- No patch `pyarmor_runtime.so` for Apple Silcon so Windows users could build obfuscated scripts for Apple Silcon

## Plan Features For Pyarmor 9

**9.0**

Status: released (2024-11-10)

- Pyarmor.man package to find solutions quickly when something is wrong
- Add special Pyarmor CI License for CI/CD pipeline
- Support Python 3.13 (since v9.0.5)

**9.1**

Status: released (2025-02-24)

- MINI mode, a simple RFT mode, the goal is high performance after obfuscation

**9.2**

Status: released (2025-10-31)

- Support Python 3.14 and 3.15 (a2)

**9.3**

Status: developing

- Full testcases
- Refine RFT mode to improve performance for big scripts (same as MINI mode)
- ECC mode, mini BCC mode, only transform part of function body to C code
- VMC mode, simple ECC mode, convert function body to VM, not real C code

The following features are cancelled because ECC/VMC mode are introduced:

- Convert unsupported node types as far as possible for BCC mode (cancel)
- Expert users could customize C sources generated by BCC mode (cancel)
- BCC mode support cross-platform (may not if too complex) (cancel)
- Obfuscate string constants in extension module "pyarmor_runtime" (cancel)

**9.4**

Status: not start

- Learning system to help users learning and using Pyarmor

Pyarmor features will be stable in 2025
