[<img src="images/MainIcon.png" align="right" width="128">](https://en.wikipedia.org/wiki/Easter_egg_(media))

# Awesome Learn Gamedev [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> A Mega-List of Learning Resources for Game Creators 

<p>


## Contents

- [About](#about)
- [Key](#key)
- [General](#general)
- [Programming](#programming)
    - [Gameplay](#gameplay)
    - [Graphics](#graphics)
    - [Networking](#networking)
    - [Fun](#fun)
- [Technical Art](#technical-art)
    - [Shaders](#shaders)
    - [Rigging](#rigging)
    - [VFX](#vfx)
- [Art](#art)
    - [2D/Illustration](#2dillustration)
    - [3D](#3d)
    - [Animation](#animation)
    - [Resources for Non-Artists](#resources-for-non-artists)
- [Design](#design)
    - [Level Design](#level-design)
    - [UI/UX](#uiux)
    - [Reference](#reference)
- [Audio](#audio)
- [Writing](#writing)
- [Production](#production)
- [Marketing and Business](#marketing-and-business)
- [Job Hunting and Career](#job-hunting-and-career)
- [Other](#other)

<br />


![An illustration of a cream-and-orange calico cat that Hazel uses as her profile icon :3](images/KittyIcon.png 'Check out my portfolio below!')


### 💜 Curated by <ins>[Hazel Kennedy](https://linktr.ee/dawdledoodles)</ins> 💜

Got resources? Notice a broken link? Email me, shoot me a DM, or make a pull request! I like chatting too - don't be shy! ^^

<br />

## About

This list is aimed at learning the craft of game development. It has been curated to offer general knowledge, resources, and hiring advice for the variety of disciplines and roles under the gamedev umbrella. 

Nearly all resources are free, and anything with a price tag will be clearly marked. Paid resources are only included if they have been personally endorsed by an industry professional working in the relevant discipline.

Suggestions and future-proofing efforts are always welcome! See `Contributing.md` for contribution guidelines, and check out [open issues](https://github.com/notpresident35/learn-awesome-gamedev/issues) for tasks that need completing, such as archival work.

Generally, this lists avoids tools and assets. However, it contains courses/tutorials for specific tools wherever they are required for a role, and assets whenever they would enable a person to learn their role more effectively (for example, the animation section contains rigs). For tools, assets, communities, and more granular lists for individual tools like Unity, check out [the gaming category of awesome](https://github.com/sindresorhus/awesome#gaming)

This list avoids including tutorials (within reason). It aims to help you develop your problem-solving skills and improve your general knowledge, rather than show you how to solve a particular problem. It also avoids design analysis videos, as they tend to be aimed at passive entertainment more than active learning. Both of these are easy to find and difficult to categorize. For curation purposes, this list errs on the side of exclusion.

These resources made my career possible. I hope they are just as helpful for you!

Disclaimer: I'm a technical artist and gameplay programmer, so most resources are geared towards tech and art. However, _most_ disciplines are represented here in some fashion, particularly through general materials and other curated lists.

## Key

💠 Starred Resources are "best for beginner" links. These include courses, classes, books, and lists aimed at people who are new to the games industry, or game development as a whole.

🟪 Purple Resources are “most useful” links. These include highly influential courses/books, resources I've personally found invaluable, and other entire mega-lists.

<br />

## General 

<br />

### [New to game development? Start here](https://allurious.itch.io/cheatsheets2018) 💠🟪

<br />
<br />

["The Door Problem"](https://lizengland.com/blog/2014/04/the-door-problem/) 💠🟪 - A one-sentence summary of most major roles in a large studio, and a bigger explanation of a game designer's job



[My mega-playlist of great gamedev videos](https://www.youtube.com/playlist?list=PLLwMDKo-0Eku3TxVg2Ye9dgW0jtUgkWRn) 🟪 - Conference talks, tutorials, analyses, etc


[GameDev Contacts](https://docs.google.com/spreadsheets/d/e/2PACX-1vRYveFAl_GuvBo0iuy3EvgPm0fWAGci-Z8e5CZ6hoYz9n8gcoK4dgE0RML-x0pWqRNjGqte-V7phtqB/pubhtml) 🟪 - A huge list of professional game developers you can contact for advice! Be courteous - these are real people! Curated by Joe Hobbs - @JLHGameArt on Twitter.


[MIT Open Courseware](https://ocw.mit.edu/) 💠🟪 - classes and materials from MIT (free to access)! 


[Game Design Stuff](https://www.youtube.com/watch?v=Pb5oIIPO62g&list=PLZQDJJp3vTmB6awcmhFc9V6HG2bd9vofo&index=58) - Another mega-list of game development videos (primarily aimed at game design and programming)


[FOSS GameDev](https://docs.google.com/document/u/0/d/1HMtvSenYvd9SN58gTmRNs-FqiHhbnnVgkMEV5mqKKaQ/mobilebasic) - A list of Free and Open Source Software for every aspect of gamedev


[VGDC at UCI Resources](https://docs.google.com/document/d/1yGzqp1Cq8emRasH0JHYMXE4-Z6xYxQ0GDe6ZyemctVM/edit) - A list of workshops and resources from the Video Game Development Club at the University of California, Irvine () 

More huge lists of resources, with many, many more incredible things! Some of these are older, so beware broken links and the like. 🟪
- [Game Industry Resources](https://docs.google.com/document/d/1G0YTvNM8pzqjy_paxvEyVQSfb7KAJFGxJ5fY2ui8FEI/edit)
- [38 Great Resources for Game Developers](https://www.gamedeveloper.com/audio/38-great-resources-for-game-developers)
- [GameDev Resources](https://github.com/Kavex/GameDev-Resources)
- [Gamedev Resources](https://github.com/Hengle/gamedev-resources-1)
- [Free & Cheap Indie GameDev Resources](https://community.gamedev.tv/t/wiki-free-cheap-indie-gamedev-resources/1948)
- [Game Dev Resources](https://letsmakegames.info/game-dev-resources)
- [The Ultimate List of Free and Low-Cost Developer Tools and Resources](https://web.archive.org/web/20220815084025/https://www.gamesparks.com/the-ultimate-list-of-free-and-low-cost-developer-tools-and-resources/)
- [Game Development Learning Resources](https://www.tomlooman.com/game-development-learning-resources/)
- [Free Unity Assets](https://www.procedural-worlds.com/blog/best-free-unity-assets-categorised-mega-list/)
- [r/GameDev Wiki Resources](https://www.reddit.com/r/gamedev/wiki/index/)
- [r/GameDesign Wiki Resources](https://www.reddit.com/r/gamedesign/wiki/index/)


<br />

## Programming 

<br />


[The Open Source University](https://github.com/ossu/computer-science) 🟪 - A complete study plan for a computer science education.


[Coding Interview University](https://github.com/jwasham/coding-interview-university) 🟪 - Another complete study plan aimed at software engineers.


[Professional Programming](https://github.com/charlax/professional-programming) 🟪 - An expansive list of resources and other lists of resources intended to make you a more proficient programmer at a professional level.


[How Game Engines Work](https://interestingengineering.com/innovation/how-game-engines-work) 💠 - A blog and video explaining the game engine, or a tool/framework used to create games.


[Complete Godot 4 Game Deveoper by GameDev.tv](https://www.gamedev.tv/p/godot-complete-2d/?coupon_code=BLIMEY) 💠🟪 - A fantastic way to learn Godot, a free and open source game engine. Gamedev.tv are an invaluable resource for learning game engines and tools, and I cannot recommend their courses enough. They are more than worth the $15.  


[Unreal Engine 5 C++ Developer](https://www.udemy.com/course/unrealcourse/) 💠🟪 - Same as above, but with Unreal 5, a popular and powerful game engine. This course is invaluable - I know several full-time developers who learned from gamedev.tv, they are a gem. Wait for it to go on sale, then go pick this up.


[Complete Unity Game Developer by GameDev.tv](https://www.udemy.com/course/unitycourse2/) - Unity has been a long-standing champion in the industry, particularly in the mobile/AR/VR space. Despite this, I would be cautious recommending it over other options, in part because of technical details such as its closed source and slow development, and in part due to poor business practices on behalf of Unity Technologies, such as the now-revoked install-based pricing model and their involvement in defense contracting.   


 [Intro to Computer Science and Programming in Python](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-0001-introduction-to-computer-science-and-programming-in-python-fall-2016/) 💠 - An introductory python course taught at MIT (free to access!)


[Programming in C++ as a Second Language](https://web.archive.org/web/20220604184602/https://www.ics.uci.edu/~thornton/ics45c/Schedule.html) 🟪 - Lecture notes, assignments, and materials from a course on C++ taught at the University of California, Irvine (free to access!) 


[Data Structure Implementation and Analysis](https://web.archive.org/web/20220405031903/https://www.ics.uci.edu/~thornton/ics46/Schedule.html) 🟪 - Lecture notes, assignments, and materials from a course on data structures and algorithms taught at the University of California, Irvine (free to access!)


[Game Programming Patterns](https://gameprogrammingpatterns.com/) 🟪 - A free book on programming patterns for games.


[A Study Path for Game Programmers](https://github.com/miloyip/game-programmer) 🟪 - A huge collection of game programming book titles and covers organized by specialization, with fancy flow charts between each title for a recommended reading order! Note that the books are _not_ included - a quick search should help you out with that ;]


[How to Learn Software Design and Architecture](https://www.freecodecamp.org/news/software-design/) 🟪 - A list of resources for software architecture.


[Redblob](https://www.redblobgames.com/) - Interactive tutorials for math and algorithms.


[Introduction to Algorithms](https://mitpress.mit.edu/9780262046305/) - A book on algorithms. Pricey, look for it in a library or "something" (wink) first.


[Awesome Math](https://github.com/rossant/awesome-math) 🟪 - Another awesome list for mathematics, useful generally but often applicable to programming.


[Math for Game Programmers](https://gamemath.com/book/intro.html) - A free book on math for game programmers.


[A Pragmatic Approach to Optimizing CPU Performance](https://larstofus.com/2024/10/19/a-pragmatic-approach-to-optimizing-cpu-performance/) 🟪 - Solid introductory advice for making code run fast. See also: [How to Build an Optimization Toolbox](https://larstofus.com/2024/12/30/how-to-build-an-optimization-toolbox/), an introduction to profiling tools, broken down by categories of purpose.


[Mature Optimization](https://carlos.bueno.org/optimization/) - A free book on structuring code for performance, as well as testing large systems.


[Data Oriented Design](https://www.dataorienteddesign.com/dodbook/dodmain.html) 🟪 - A free book on data-oriented design, an alternative to object-oriented programming


[generatingfunctionology](https://www2.math.upenn.edu/~wilf/DownldGF.html) - A free book on generating functions.


[C++ for C# Developers](https://www.jacksondunstan.com/articles/5530) 💠 - An extensive tutorial series.


[Game Engine Architecture](https://www.gameenginebook.com/) 🟪 - A book on game engines. About $25 for the e-book, probably worth the investment if you plan to be an engine, tools, or graphics programmer.


[Pro Git](https://www.git-scm.com/book/en/v2) - A free book on everything git.


[Design Patterns](https://refactoring.guru/design-patterns/) - A free book with _very_ pretty illustrations.


[Rethinking Design Patterns](https://blog.codinghorror.com/rethinking-design-patterns/) - An interesting criticism of the above book. I believe there is a response to this on the design patterns site.


[Making a Game Engine](https://www.youtube.com/playlist?list=PLlrATfBNZ98dC-V-N3m0Go4deliWHPFwT) - For the engine programmers and the insane: save yourself some trouble and watch this instead of making yet another game engine ^^


[C# for Beginners](https://www.robmiles.com/c-yellow-book) - A free book on C#


[Tool Dev](https://www.youtube.com/watch?v=pZ45O2hg_30&list=PLImQaTpSAdsBKEkUvKxw6p0tpwl7ylw0d) 💠🟪 - An introduction to tool development (or creating tools to make game development more productive) and editor scripting in Unity by Freya Holmér.


[Dive Into Systems](https://diveintosystems.org) - A free textbook on computer systems and C programming. 


[Gamedev in Rust for Beginners](https://arewegameyet.rs/#resources) - A collection of books, tutorials, articles, and a community to boot.


[DemoFox](https://blog.demofox.org) - A blog with lots and lots of programming, graphics, and math tutorials and breakdowns.


[Bit101](http://www.bit-101.com/blog/) - A blog on mathy-programmer things with some tutorials and breakdowns.


[Math for Game Devs](https://www.youtube.com/watch?v=MOYiVLEnhrw&list=PLImQaTpSAdsD88wprTConznD1OY1EfK_V) - A primer on math geared towards game development by Freya Holmér.


[Essence of Linear Algebra](https://www.youtube.com/playlist?list=PLZHQObOWTQDPD3MizzM2xVFitgF8hE_ab) - A video series meant as a supplement for a class on Linear Algebra, made by 3Blue1Brown.


[How to make Games for Gameboy](https://laroldsjubilantjunkyard.com/tutorials/how-to-make-a-gameboy-game/) - A comprehensive tutorial series on developing games for the Gameboy. Also includes links to other relevant tutorial series, such as one on C programming.


[Understanding ECS](https://www.gamedev.net/articles/programming/general-and-gameplay-programming/understanding-component-entity-systems-r3013/) - A blog post about Entity Component System design and implementation.


[HandMadeHero](https://handmadehero.org/) - A very extensive catalogue of live-streamed coding tutorials.


[VGDC at UCI Programming](https://docs.google.com/spreadsheets/d/1VxoJGdBmRrsYLx9MnaVmZ0iFc9Vcx4xGSqOuW2bisVM/edit#gid=2006991768) - A (slightly outdated) list of programming tutorials from the VGDC at UCI.


[Optimization tips for Unity](https://web.archive.org/web/20220830175614/https://images.response.unity3d.com/Web/Unity/%7B5dc4de9b-9e59-4860-b933-eb6daae82ecd%7D_Unity_Games_Optimization_Best_Practices-v5.pdf) - Some tips from Unity about optimizing their games.

[Larold's Retro Gameyard](https://laroldsretrogameyard.com/) - A collection of retro video game programming tutorials. Learn to make [Game Boy](https://laroldsretrogameyard.com/category/tutorials/gb/) or [Game Boy Advance](https://laroldsretrogameyard.com/category/tutorials/gba/) games from scratch. In the future, tutorials for additional consoles will added.


<br />


### Gameplay


[Study Reference Sheet for Gameplay Engineers](https://docs.google.com/document/d/1qIkaxtSfrtmgvO_yh-h187by7EIyrl61a3EaF40xBLs/edit#heading=h.ejywv1aotlnc) 🟪 - Perfect for intermediate programmers looking to shore up their technical knowledge to prep for an interview. Note: this is currently being migrated. It is incomplete at time of writing, but I have also included [the future-proof link](https://www.mrventures.net/get-into-gamedev.html).


[Game AI Pro](http://www.gameaipro.com/) 🟪 - Three (3) free books (or more accurately, volumes of short papers) on game AI. Notable authors include Steve Rabin, a DigiPen professor who teaches AI for games.


[AI Game Dev.com](https://web.archive.org/web/20190107192021/http://aigamedev.com/page/free-features/page/3/) - An AI development community with lots of resources. It only exists on the internet archive, so be wary of outdated knowledge and broken links.


<br />


### Graphics


[The Awesome list for Computer Graphics](https://github.com/luisnts/awesome-computer-graphics) 💠🟪 - Another awesome list specifically tailored to this topic, albeit not games-focused.


[Graphics](https://guerilla-tactics.com/hats/graphics/) 💠🟪 - A Megalist of Graphics Programming and Tech Art resources.


[How do I become a graphics programmer?](https://gpuopen.com/learn/how_do_you_become_a_graphics_programmer/) 💠🟪 - An overview of graphics programming and a collection of resources tailored to beginners learning graphics programming. 


[WebGLFundamentals](https://webglfundamentals.org) 💠🟪 - An introduction to WebGL, a web-based rasterization engine. WebGL is a good tool to use when learning the fundamentals before diving into more complex frameworks such as Vulkan or DirectX 12.


[GPU Gems](https://developer.nvidia.com/gpugems/gpugems/contributors) - Three (3) free books by Nvidia about GPU programming and architecture.


[Render Hell](http://simonschreibt.de/gat/renderhell/) 🟪 - An overview of graphics and everything rendering for programmers. Covers an overview, with lots of references to books and other resources for deeper reading.


[Rendering Course](https://users.cg.tuwien.ac.at/zsolnai/gfx/rendering-course/) - A free master's level course on ray tracing, photorealistic rendering, and global illumination taught at the Technical University of Vienna.


[A Trip Through the Graphics Pipeline 2011](https://fgiesen.wordpress.com/2011/07/09/a-trip-through-the-graphics-pipeline-2011-index/) 🟪 - A somewhat-dated dive into a typical graphics pipeline, intended for those with some exposure to graphics APIs such as OpenGL or Direct3D 11.


["Painting with maths"](https://www.youtube.com/c/InigoQuilez) - A YouTube series about a _very_ technical art form.


[GPU Memory pools in D3D12](https://therealmjp.github.io/posts/gpu-memory-pool/) - How GPU memory works in Direct3D 12.


[A comparison of modern graphics APIs](https://alain.xyz/blog/comparison-of-modern-graphics-apis) - A blog post comparing graphics APIs (namely, Vulkan, DirectX, Metal, WebGPU, and OpenGL).


[A comparison of 3D file formats](http://liu.diva-portal.org/smash/get/diva2:462098/FULLTEXT01.pdf) - A bachelor thesis on 3D file formats.


[How SDFs work](https://jasmcole.com/2019/10/03/signed-distance-fields/) - A blog post on signed distance fields.


[Ray Marching and SDFs](https://jamie-wong.com/2016/07/15/ray-marching-signed-distance-functions/) - An article on SDFs and ray marching with references to further reading.


[Kosmonaut's Blog](https://kosmonautblog.wordpress.com/) - A blog exploring various rendering implementations such as SDF rendering.


[Behind the Pretty Frames](https://mamoniem.com/category/behind-the-pretty-frames/) - Technical explorations of the rendering pipelines behind games like Detroit: Become Human, Death Stranding, and God of War.


<br />


### Networking


[Unreal Multiplayer by GameDev.tv](https://www.udemy.com/course/unrealmultiplayer/) 💠🟪 - A course on multiplayer and networking in Unreal. Wait for it to go on sale, then go pick this up. 


[Unity Multiplayer by GameDev.tv](https://www.udemy.com/course/unity-multiplayer/) 💠🟪 - A course on multiplayer and networking in Unity. Wait for it to go on sale, then go pick this up.


[GafferOnGames](https://gafferongames.com) 🟪 - A bunch of articles on netcode for games.


[Source Multiplayer Networking](https://developer.valvesoftware.com/wiki/Source_Multiplayer_Networking) - Technical documentation from Valve about the netcode of source games.


[Latency Compensating Methods](https://developer.valvesoftware.com/wiki/Latency_Compensating_Methods_in_Client/Server_In-game_Protocol_Design_and_Optimization) - Technical documentation from Valve about accounting for latency.


[Replication -
Part 1](https://0fps.net/2014/02/10/replication-in-networked-games-overview-part-1/)
 | [Part 2](https://0fps.net/2014/02/17/replication-in-networked-games-latency-part-2/)
 | [Part 3](https://0fps.net/2014/02/26/replication-in-networked-games-spacetime-consistency-part-3/)
 | [Part 4](https://0fps.net/2014/03/09/replication-in-network-games-bandwidth-part-4/) - A four-part series on replication (that is, ensuring all players have consistent game state).


[Deterministic Netcode](https://yal.cc/preparing-your-game-for-deterministic-netcode/) - A blog post about ensuring consistency across game clients, given the same initial state and inputs.


[The TRIBES Engine Networking Model](https://www.gamedevs.org/uploads/tribes-networking-model.pdf) - A particularly notable paper on the networking model developed for Starsiege TRIBES.


[Fast-Paced Multiplayer - Part 1](https://www.gabrielgambetta.com/client-server-game-architecture.html) | [Part 2](https://www.gabrielgambetta.com/client-side-prediction-server-reconciliation.html) | [Part 3](https://www.gabrielgambetta.com/entity-interpolation.html) | [Part 4](https://www.gabrielgambetta.com/lag-compensation.html) | [Live Demo](https://www.gabrielgambetta.com/client-side-prediction-live-demo.html) - A four-part series on networking for games, along with a sample implementation of some concepts described.


<br />


### Fun


[Music for Programming](https://musicforprogramming.net/latest/)


[Good](https://www.techwell.com/techwell-insights/2013/12/why-best-programmers-are-lazy-and-act-dumb). [Advice](http://blogoscoped.com/archive/2005-08-24-n14.html). [Repeated](https://kilon.org/why-good-programmers-are-lazy-and-dumb/).
 [Ad nauseum](https://blog.codinghorror.com/how-to-be-lazy-dumb-and-successful/) - Swallow your pride, and optimize out busywork.


[The Case of the Missing Rewards](https://www.bungie.net/en/Explore/Detail/News/50140) - A very interesting breakdown of a particularly tricky bug in Destiny and how it was found and fixed.

[C is not a Low-Level Language](https://queue.acm.org/detail.cfm?id=3212479) - An article on why C is not a low-level language, and performance as a result of that.

[Sigbovik](http://sigbovik.org) - Pore over this for a good laugh :P


<br />


## Technical Art

<br />


[Tech Art Learning Resources](https://heartmachine.notion.site/Tech-Art-Learning-Resources-d2eb63aeca624cf59faab5a19b4a732d) 🟪 - A list of tech art resources, communities, and professionals, curated by Heart Machine (the studio that made Hyper Light Drifter and now Hyper Light Breaker).


[Tech Artists](https://tech-artists.org) - A community of tech artists.


[Tech Art Course](https://simonschreibt.de/gat/tech-art-course/) - Materials from a tech art course (many are unexplained, since the class was delivered in-person, but they're still useful).


[Making Crash Bandicoot](https://all-things-andy-gavin.com/2011/02/04/making-crash-bandicoot-part-3/) - A blog post series from a developer of Crash Bandicoot discussing its rendering tech and the hardware limitations of the PS1.


[Proc Gen / HyperDec: Part 1](https://heartmachinez.tumblr.com/post/690221520736387072/proc-gen-hyperdec-part-1) | [Part 2](https://heartmachinez.tumblr.com/post/690221567668568064/proc-gen-hyperdec-part-2) - An extended breakdown of the procedural art tools of Hyper Light Breaker.


[Seeing Blue](https://calebkruse.com/10-projects/seeing-blue/) - Slightly mind-blowing writeup on the physics of the color blue.


<br />


### Shaders 


[Shaders for Game Devs](https://www.youtube.com/watch?v=kfM-yu0iQBk&list=PLImQaTpSAdsCnJon-Eir92SZMl7tPBS4Z) 💠🟪 - An introduction to HLSL Shaders using Unity by Freya Holmér.


[The Book of Shaders](https://thebookofshaders.com/00/) 🟪 - A book on GLSL pixel shaders.


[Catlike Coding](https://catlikecoding.com/unity/tutorials/) 🟪 - Unity and HLSL Shader Tutorials.

[Shadertoy](https://www.shadertoy.com/) - An online shader editor and hosting/sharing site.


[Render Doc](https://renderdoc.org/) 🟪 - A program that breaks down a frame rendered from a game and allows you to analyze processes that created it.


[Intro to Shader Graph](https://www.cyanilux.com/tutorials/intro-to-shader-graph/) 💠 - A detailed introduction to shader graph in Unity.


[Cyanilux](https://www.cyanilux.com/contents/) - Tutorials and shader breakdowns (same blog as above).


[Shaderquest](https://halisavakis.com/category/shaderquest/) - A guide series from a blog about tech art.


<br />


### Rigging


[Cult of Rig](http://www.cultofrig.com) - A catalogue of live-streamed lectures coupled with rig creation. Sorry in advance for the cult theme.

[Animator Friendly Rigging](https://jasonschleifer.com/afr/) - A course on creating rigs that behave well for animators. Fair warning: this has an up-front cost of around $105-120.

[Procedural Rigging Python](https://www.pluralsight.com/courses/procedural-rigging-python-maya-2283) - A course on creating python tools to procedurally rig characters in Maya. Note: has a 10 day free trial, but gets quite expensive after that.

[Stop Staring: Facial Modeling and Animation Done Right](https://www.amazon.com/Stop-Staring-Facial-Modeling-Animation/dp/0470609907) - A book on facial modeling, animation, and rigging. Fair warning: this is $80 new. I would recommend getting it used, if possible.

[Mastering Rigging and Python Scripting in Maya](https://www.thegnomonworkshop.com/tutorials/master-rigging-python-scripting-in-maya) - A course from Gnomon, a well-known art university. Fair warning: first 2 hours of content within 7 days are free, but then a subscription costs $54 per month. 


<br />


### VFX


[Getting Started in Real Time VFX](https://realtimevfx.com/t/getting-started-in-real-time-vfx-start-here/3415) 💠🟪 - Also check out the rest of this website (realtimevfx.com) to find a thriving community filled with useful knowledge and amazing people.


[VFX Talks Playlist](https://www.youtube.com/watch?v=YPy2hytwDLM&list=PLdiateg_U8PFnlScGDJDQeHUX9qmYvsxv) 🟪 - A playlist of VFX talks at GDC (the linked video is about Diablo, and is very insightful).

[BiteyCastle Academy 2DFX Animation Course](https://chluaid.gumroad.com/l/bcafx) 💠🟪 - A full 2D FX animation course (completely free!)

[VFX Apprentice](https://www.vfxapprentice.com) - Several VFX courses geared towards developing a professional portfolio. _Very_ pricey, but may be worth your while if you are serious about VFX - it is a _hell_ of a lot cheaper than art school.

[Houdini Isnt Scary - Part 1: Basics](https://www.youtube.com/watch?v=Tsv8UGqDibc&list=PLhyeWJ40aDkUDHDOhZQ2UkCfNiQj7hS5W&index=5) - A playlist of a Houdini tutorial series.


<br />


## Art

<br />

[Art Industry Resources](https://www.notion.so/Art-Industry-Resources-86e6733162f24c26829aa65961f461e3) 💠🟪 - A Megalist of Art Resources!


[Saint11: Tutorials](https://saint11.org/blog/pixel-art-tutorials/) 💠🟪 | [Articles](https://saint11.org/pixel_articles/) | [Patreon](https://www.patreon.com/saint11) - Fantastic pixel art animation tutorials and articles on pixel art. Note that most patreon posts are free.


[Pixel Art Class](https://www.youtube.com/watch?v=7BWr2tlK-4c&list=PLLdxW--S_0h4dlWUpl-TzBp-ulqK3NiM_) - A tutorial series covering the basics of art aimed at pixel artists.


[CubeBrush](https://cubebrush.co) - A marketplace for art resources, with tutorials, assets, brushes, tools, etc.


[Genevieve Routhier](https://genevieverouthier.art.blog/) - A blog on art direction and leadership from a senior art director.


[The Gnomon Workshop](https://www.thegnomonworkshop.com) - Extremely professional-looking art, animation, and VFX courses. Seems aimed at film with a large overlap in games. Beware of hefty price tag.


[Smithsonian Open Access](https://www.si.edu/openaccess) - A massive repository of 3D and 2D digital resources from the Smithsonian Institute archives, such as photos and 3D scans of historical objects. Perfect for reference and creative commons reuse!


[Resources for Commission Artists](https://www.nadiaxel.com/post/free-ressources-for-commission-artists) - If you want to open yourself up for commission work, this is a godsend.


[SageThumbs](https://www.cherubicsoft.com/en/projects/sagethumbs/) - An extension that adds advanced file previews and conversion tools to Windows Explorer (including, notably, .psd). For artists who frequently use many Adobe programs or file formats, RAW files, and PDFs, this will save you time.


[A whole lot of time-saving tools](https://mobile.twitter.com/Marcel_Hampel/status/1559178642856484865) - I personally recommend Pureref. [Archived PDF](archives/twitter/MarcelHampelThread.pdf).


<br />


### 2D/Illustration


[How To Draw](https://www.webtoons.com/en/challenge/how-to-draw-/intro-/viewer?title_no=730330&episode_no=1) 💠🟪 - An webcomic on how to draw, and much more importantly, how to _learn_ to draw.


[Radiorunner's Curriculum for the Solo Artist](https://www.brendanmeachen.com/soloartist) 🟪 - A curriculum for self-teaching art. If you want to _really_ hone your skills, this will undoubtedly be worth your time.


[DrawABox](https://drawabox.com/) 💠🟪 - An exhaustive course for the art fundamentals (completely free!)


[LoSpec](https://lospec.com/) 🟪 - A Pixel Art gold mine (Job Board, Pallette Database, Tutorials, Resources, and more).


[Proko Figure Drawing Fundamentals](https://www.youtube.com/playlist?list=PLR2KBLDDnZz3Ec8LZ66IDS--P9g3TdwOM) 🟪 - An exhaustive series on drawing people from a reputable channel.


[How to Learn Digital Painting (Beginners)](https://www.youtube.com/watch?v=iwRa5qTnr8o) 💠🟪 - A guide to digital painting for beginners and intermediate painters. See other tutorials by Sinix for guides aimed at more advanced artists.


[Cut-Out People](https://www.vishopper.com/cut-out-people) - A searchable repository of extremely diverse reference images for humans, with filters for easy search (IE "1 woman age 20-40 with dog from the front" or "3 people sitting in a home")


[Drawing the Head and Hands](https://ia601608.us.archive.org/8/items/andrew-loomis-drawing-the-head-hands/andrew-loomis-drawing-the-head-hands.pdf) - A book on figure construction by Andrew Loomis. Free in the public domain!

[Figure Drawing for All its Worth](https://archive.org/details/loomis_FIGURE_draw) - A book on figure drawing by Andrew Loomis. Free in the public domain!


[Digital Inking Tips](https://www.youtube.com/watch?v=NBE-RTFkXDk) - A good guide to sharpening your technical skills.


[Human Anatomy for the Head](https://www.youtube.com/watch?v=2T7cDY7YDsg) - A lesson on human anatomy for artists, breaking down the head.


[Lines and Edges](https://bryan-sturm.github.io/articles/lines-and-edges/) - A neat style guide for using edges and lines effectively.


[What Level Is Your Art?](https://www.youtube.com/watch?v=j38HRF17YMA) - Need a quick confidence boost? Watch this :3


<br />


### 3D


[World Building in Blender by Ian Hubert](https://www.youtube.com/watch?v=whPWKecazgM) 💠🟪 - The best resource for thinking about 3D art, possibly ever.


[Sculpting in Blender](https://www.artstation.com/learning/courses/3Va/intro-to-sculpting-in-blender/chapters/8OjR/intro) 🟪 - A short, free course on sculpting in Blender.


[Photorealism Explained](https://www.youtube.com/watch?v=R1-Ef54uTeU) 🟪 - An explanation of photorealism and how it is achieved in CG.


[Realtime Hair Tutorial](https://flippednormals.com/product/realtime-hair-tutorial-29017) - A course delving into a hair pipeline for characters.


Royalty-Free Textures, Models, HDRIs, and Assets!
- [Textures](https://www.textures.com/)
- [More Textures](https://publicdomaintextures.com/)
- [HDRIs, Textures, and Models](https://polyhaven.com/)


<br />


### Animation


[The Animator's Survival Kit](http://www.theanimatorssurvivalkit.com) 🟪 - An essential resource for any animator. Has a price tag, but if you want to get a job in industry, it is well worth your money.


[The 12 Principles of Animation](https://www.youtube.com/watch?v=haa7n3UGyDc&list=PL-bOh8btec4CXd2ya1NmSKpi92U_l6ZJd) 💠 - A visual tutorial series on a fundamental part of animation.


[Hybrid 02 Maya Rig](https://oninationsquad.gumroad.com/l/hybrid02) - A humanoid rig for Maya, free for non-commercial use.


[Universal Human Body & Face Rig](https://cjones.gumroad.com/l/JJuKG) - A generic humanoid body and face rig by Chris Jones, with many advanced features. $200 license, but would be very worth it for serious animators looking to animate for realism.

<br />

### Resources for Non-Artists

Note that there are many, many more resources out there - these are primarily included as a way to build a polished-looking game even while learning a different discipline.

Royalty Free Game Art! Don't forget to check the license.
- [Open Game Art](https://opengameart.org/)
- [2D and 3D assets](http://www.kenney.nl/)
- [Game Icons](https://game-icons.net/)
- [Low-Poly Models](https://Poly.Pizza)


[100% free assets](https://www.reddit.com/r/Unity2D/comments/3dfi5k/lets_create_a_list_of_all_100_free_2d_assets_with/) - A post and thread with lots of free art assets and tools.


<br />


## Design

<br />


[The Art of Game Design](https://www.schellgames.com/art-of-game-design/) 💠🟪 - An essential book on game design, basically mandatory reading for designers. Has a price tag, but is well worth the money.


[The Design of Everyday Things](https://ia902800.us.archive.org/3/items/thedesignofeverydaythingsbydonnorman/The%20Design%20of%20Everyday%20Things%20by%20Don%20Norman.pdf) 💠🟪 - A book on design in everything, basically mandatory reading for designers.


[Game Accessibility Guidelines](https://gameaccessibilityguidelines.com/) 🟪 - A list of accessibility features, organized by implementation difficulty. Also includes testimonials for each feature and the impact it makes on people, as well as best practice examples and implementation resources (tools, guides, etc) where available.


[Game Design](https://ocw.mit.edu/courses/cms-608-game-design-fall-2010/) 💠🟪 - A Game Design class taught at MIT (free to access!) 


[How to make a Game Design Document](https://www.gamedesigning.org/learn/game-design-document/) - A tutorial on writing Game Design Documents (GDDs).


[Pattern Language for Game Design](https://patternlanguageforgamedesign.com/) 💠🟪 - A database of common design patterns presented as problem solutions, compiled from the book _Pattern Language for Game Design_. Also contains work from students and designers completing excercises from the book.


[The Evolution of Trust](https://ncase.me/trust/) 💠🟪 - An interactive walkthrough of some game theory. Would probably be mandatory reading in a game design class.


[Extra Credits: So You Want To Be a Game Designer](https://www.youtube.com/watch?v=zQvWMdWhFCc) 💠🟪 - A channel on game design that was far ahead of its time. Their backlog is filled with invaluable advice, though their more recent content has a controversial reputation, and they've largely pivoted away from games into history and literature. Start with their career video(s) - dig through their game design backlog if you would like, but stick to the older stuff.


[The Platformer Toolkit](https://gmtk.itch.io/platformer-toolkit) 💠🟪 - A playable video essay/game, giving an overview on platforming mechanics, game feel, and tuning by Mark Brown from GMTK.


[Design Oriented Topic Wheel](https://designoriented.net/wheel) 💠 - Short descriptions of many major design topics and concepts, categorized neatly in an approachable wheel interface.


[GDKeys](https://gdkeys.com/) - A collection of articles and tools created by Nico, a senior game designer.


[Puzzle Ideation Strategies](https://cwpat.me/misc/puzzle-level-idea-strategies/) - A list of strategies for coming up with puzzles, and links to the talks that inspired them.


[MDA](https://users.cs.northwestern.edu/~hunicke/MDA.pdf) - Mechanics -> Design -> Aesthetics, or a formal approach to game design and research.


[Hooked](https://www.theguardian.com/australia-news/datablog/ng-interactive/2017/sep/28/hooked-how-pokies-are-designed-to-be-addictive) - An interactive article on the psychology of gambling and addiction.


[Design in Detail: Changing the Time Between Shots for the Sniper Rifle from 0.5 to 0.7 Seconds for Halo 3](https://www.gdcvault.com/play/1012211/Design-in-Detail-Changing-the) - A talk on why minute tuning matters.


[The Poor Man's 3D Camera](https://etodd.io/2017/11/28/poor-mans-3d-camera/) - A breakdown of the design thinking and solutions that went into an extremely specific 3D camera


<br />


### Level Design


[Level Design and How To Get Into It](https://80.lv/articles/level-design-tips-tricks-and-how-to-get-into-it/) 💠 - A gentle introduction to level design.


[The Level Design Book](https://book.leveldesignbook.com/) 💠🟪 - A free book on level design. The book is still being written, but contains many useful insights as it stands.


[Trenchbroom Manual](https://trenchbroom.github.io/manual/latest/) 🟪 - The user guide for Trenchbroom, an enduring level editor. Though designed for the Quake engine, it finds use in other engines through tools such as [Qodot](https://qodotplugin.github.io/) and [Qnity](https://github.com/QFormatPlugins/Qnity)


[Quake Mapping Tips](https://www.slipseer.com/index.php?threads/bals-quake-mapping-tips-tricks.100/) - Tips and tricks for Trenchbroom and Quake mapping.


[Tiled](https://www.mapeditor.org/) - A free and open source map editor 


<br />


### UI/UX


[WE CAN FIX IT IN UI](https://www.notion.so/onewithmachines/WE-CAN-FIX-IT-IN-UI-9f588869324a45e2b2d0595546ce77d1) 💠🟪 - A huge list of UI/UX resources!


[Game UI Database](https://www.gameuidatabase.com/index.php) 💠🟪 - A searchable repository of UI designs from many different games to use as reference.


[Laws of UX](https://lawsofux.com/en/) - Best practices of UX design.


[Daily UI](https://www.dailyui.co/) - A 100-day daily UI design challenge.


<br />


### Reference


[Game Docs](https://gamedocs.org/category/design-document/) - A collection of design documents from completed games - links have been ripped and placed below.


[Destiny](http://www.cand.land/destiny) - A collection of UI/UX documentation from Destiny (a game that won awards for its UI) by David Candland.


[Hit the Road GDD](https://web.archive.org/web/20180219004603/https://samandmax.co.uk/wp-content/uploads/Hit%20the%20Road%20design%20document.pdf) - The design document for Sam and Max Hit the Road.


[Mythos Pitch Domcument](https://mega.nz/#!3aImBa6D!QUKtZYf_frlIgSUk2A096KNCQ9cfijr_38son-N4AGo) - The pitch deck for Mythos.


[Wasteland 2 Vision Document](https://drive.google.com/file/d/0BxMevjNSr2EjbDBpZ2ZMdmNnc28/view?resourcekey=0-2-ybLxFeJk2R5ROLOAB3oQ) - The original vision document for Wasteland 2.


[The Design of Dirty Bomb](https://www.dirtybomb.com/news/the-design-of-dirty-bomb/) - The design document and art book for Dirty Bomb. Archived pdf links: [Design](https://web.archive.org/web/20220815160634/http://db-design.splashdamage.com.s3-eu-west-1.amazonaws.com/dirty_bomb-game_design_document.pdf) | [Art](https://web.archive.org/web/20220815160724/http://db-design.splashdamage.com.s3-eu-west-1.amazonaws.com/the_art_of_dirty_bomb.pdf)


[Finch Concept Doc](https://web.archive.org/web/20220815160819/https://www.giantsparrow.com/blog/news/wp-content/uploads/2018/04/Finch-Original-Concept-Doc.pdf) - Concept document for What Remains of Edith Finch.


[Grid Paper](https://gridpaper-maps.tumblr.com/) - A repository of maps and top-down views of levels.

<br />

## Audio 

<br />

[Game Audio Learning Resources](https://docs.google.com/spreadsheets/d/1fcuhGEesLC_PWCwY3dIwLgF774sKswOwIcZECWiH7Xo/edit#gid=0) 💠🟪 - A megalist of game audio learning resources! 


[The Sound Effects Bible](https://postproduciendoenlaeav.files.wordpress.com/2017/09/the-sound-effects-bible-ric-viers.pdf) 🟪 - A book on everything sound effects.


[Another list of resources!](https://twitter.com/chiragmachhar/status/1511446337639927811) 🟪 - [Archived PDF](archives/twitter/chiragmachharThread.pdf). 


[SFXR](https://sfxr.me/) - A great program for generating simple sound effects.


[Beep Box](https://www.beepbox.co/) - A simple but fun web-based music program.


[Bosca Ceoil](https://boscaceoil.net/) - A very simplistic and limited but fast, free, and fun audio program for chiptune music! 


[GDC Freebies](https://sonniss.com/gameaudiogdc#1605030813191-c5a1f3d0-8baf) - Royalty free SFX samples from GDC.


Royalty free music! Don't forget to check the license.
- [Pixabay](https://pixabay.com/music/)
- [DOVA-SYNDROME](https://www.youtube.com/c/DOVASYNDROMEYouTubeOfficial)


<br />


## Writing 

<br />


[Game Narrative Resources](http://sashakirlee.com/game-narrative-resources) 💠🟪 - A collection of books, tools, talks, resources, job listings, and more for writing, as well as related disciplines where relevant to narrative.


[Inkle](https://www.inklestudios.com/ink/) 🟪 - A writing tool for games (free and integrates well with Unity!)


[Dialogger](https://github.com/etodd/dialogger) - A simple cross-platform dialogue graph editor (free with MIT license!)


[Writing Better Dialogue](https://gutefabrik.com/craft-writing-better-dialogue-a-2-day-workshop/) - A workshop on dialogue writing from a series on game writing.


[The Borksheet](https://docs.google.com/spreadsheets/d/16WoJik9w93FHNOw8GrE4L0UAwTYJMsBQ6QSxZ1MYr9A/edit#gid=0) - A template sheet for an exercise to write "Barks" or simple dialogue lines - good for emphasizing character variety and attention-to-detail personalization.


[Emily Short's Interactive Storytelling](https://emshort.blog/) - Neat blog on storytelling in games and interactive media.


<br />

## Production

<br />


[What is a Games Producer?](https://www.screenskills.com/job-profiles/browse/games/production/games-producer-games/) 💠 - An explanation of the production role, and resources on how to become a producer.


[Video Game Production Resources](https://www.breakingthewheel.com/video-game-production-resources/) 🟪 - A collection of resources for producers, categorized by purpose. Targets soft skills such as entrepreneurship, management, and marketing.


[Game Producer's Guide](https://www.gameproducersguide.com/Home_home.html) - A collection of books, tools, conference talks, and other resources for producers.


[How to Become a Video Game Producer](https://www.gameindustrycareerguide.com/how-to-become-a-video-game-associate-producer/) - An interview with Merric Shank, a senior producer, on the role, with  hiring advice for entry-level producers.


[Awesome Game Production](https://github.com/vhladiienko/awesome-game-production) 🟪 - An Awesome list, focused on project and product management in game development.


<br />

## Marketing and Business

<br />


[Leveling the Playing Field](https://ltpf.ramiismail.com) 💠🟪 - A blog/newsletter by Rami Ismail with advice on business, marketing, skill development, and various topics needed to run an indie studio. Past newsletters are archived here. I personally recommend "Budget Viability" as a starting point.


[How to Market a Game](https://howtomarketagame.com) 💠🟪 - A blog and a collection of resources by Chris Zukowski with advice on marketing and sales. I personally recommend his GDC talks "Empathizing with Steam: How People Shop for Your Game" and "What to Write So People Buy: Selling Your Game Without Feeling Sleazy" as starting points.


[Community Dev Newsletter and Blog](https://www.victoriatran.com) 💠🟪 - A blog and a newsletter by Victoria Tran with advice on community management, social media, and marketing. Past newsletters are archived here. I personally recommend "Failure Marketing" and "Charm your Communities" as starting points.


[Blog by Derek Lieu](https://www.derek-lieu.com/blog/) 🟪 - A blog by Derek Lieu with advice on game trailers. I personally recommend "Show the Dream, Not the Job" and "Video Game Trailer Specifications" as starting points.


[The Game Developer's Guide to Publishing Agreements](https://deviantlegal.com/guide/game-developers-guide-publishing-agreements/) 🟪 - An introduction to games contract law by René Otto, written primarily for developers seeking to work with publishers. 


[GameDiscoverCo Newsletter](https://newsletter.gamediscover.co/) - A newsletter by Simon Carless and associates on "how people discover and buy video games" and related marketing/industry topics.


[Push to Talk](https://www.pushtotalk.gg/about) - A newsletter on the business of making and marketing video games.


<br />

## Job Hunting and Career

<br />


[Video Game Job Hunt](https://www.gameindustrycareerguide.com/video-game-job-hunt-guide/) 🟪 - A huge list of job-hunting resources: multiple blogs with everything from building a portfolio/resume to searching for and applying to jobs and even salary negotiation and relocation advice.


[Career Documents from Jean Leggett](https://docs.google.com/document/d/1pGglICnig6oZ1IABXLMuwAEN1azPP5pnZUvdrYwbyGs/edit) 🟪 - Another huge list of career documents and resources!


[Game Dev LFW Resources](https://javieracordero.notion.site/cce9a8faef6e4f31bb43b7630521a4d2?v=efdf687094be499bb2d9a33f55b906bc) 🟪 - Yet another list of resources and communities!


[Interview Placemat](https://www.linkedin.com/posts/victoriaearle_jobhunt-jobsearch-interviewing-activity-7052059362810335232-UhrI/) 🟪 - A template useful for interview prep. [Archived Image](archives/InterviewPlacemat.jpg).


[The Complete List of Gaming Jobs](https://hitmarker.net/career-advice/the-complete-list-of-gaming-esports-jobs)  🟪 - A comprehensive list of gaming jobs and specialties (includes both game development and esports).


[Industry Portfolios](https://www.plusonewisdom.com/post/industry-portfolios) - A big list of portfolios from industry professionals.


[GameDev Jobs (2022)](https://docs.google.com/document/d/1H34_z043mJrLahXw7fCgwf5w4ZWyrB2GBE9XAXufjmQ/edit) - A megalist of studio career pages and job posting sites.


[Career Advice Collected](https://claudiasnotes.notion.site/claudiasnotes/Career-Advice-Collected-560272eab6ce4069ada95d0852dbb1c9) - Advice on writing resumes and cover letters. Primarily written for producers and entry-level job seekers, but generally applicable.


[Questions to ask game studios you're interviewing with](https://lindenreidblog.com/2020/05/21/questions-to-ask-game-studios-youre-interviewing-with/) 🟪 - A list of questions for you to ask a potential employer in an interview.


[The Reverse Interview](https://github.com/viraptor/reverse-interview) - Another list for you to ask a potential employer (created for non-games tech, but most questions apply to games, and some apply to all disciplines).


[Guide to Game Art Applications](https://www.artstation.com/blogs/kierangoodson/mY0N/guide-to-game-art-applications-portfolios-and-job-postings) 🟪 - A guide to game art portfolios and job hunting.


[The Bible of Getting a Job in Game Audio](https://docs.google.com/document/d/1sAd8xOdngsdLJqKfcOnyL8xRhPi3Uitys6fEXU9O2X0/edit) 🟪 - A massive collection of career resources for game audio.


[How to Get an Internship](https://helpful-clover-96f.notion.site/How-to-get-an-internship-v-2-d906cdbf321c4986ae46bd43282b1a84) - Tips on getting an internship for college students.


[How to Get a Job as a Game Producer](https://www.gamesindustry.biz/how-to-get-a-job-as-a-game-producer) - Career advice for those seeking a job in production.


[GameDevMap](https://www.gamedevmap.com) - A map of game development studios


[A short thread of cover letter tips](https://twitter.com/JeanLeggett/status/1354615348071460865) - [Archived PDF](archives/twitter/JeanLeggettThread.pdf).


[A word of warning](https://twitter.com/MemoPotato/status/1550209887401017344?s=20&t=6Kp0ZGR8XuZukP5eAz2MGA) - Why you need to clearly label personal work as personal work and not make your developer name seem like a studio name if it is not: a thread. [Archived Thread](archives/twitter/MemoPotatoThread.pdf) and [Sub-Thread](archives/twitter/JoannaHaslamThread.pdf)


<br />


## Other 

<br />


[Obsidian](https://obsidian.md/) 🟪 - Important productivity fuel (and what I used to hoard this list :P)


[A series of game jam post-mortems](https://www.youtube.com/watch?v=fW88C_w3EzE&list=PLrvwNabyAw30pIbitXIHLdSTm4t9I3iT1) 💠🟪 - These are more valuable than they let on, because they show you the whole game-making process, start to finish. Not only will this help you avoid common pitfalls, it will help you know how to follow that process for your own game. Watch a couple before entering your first jam or starting your first project!


[The California Problem](https://ellaguro.blogspot.com/2023/02/the-california-problem.html) 🟪 - One of my favorite articles ever written. A philosophical analysis of the culture of games as an industry and the importance of gamedev as a hobby, not just a business. 


[So, you want to make a TTRPG?](https://thecoppercompendium.co.uk/so-you-want-to-make-a-ttrpg) 💠🟪 - A collection of resources for creating a TTRPG. Paper prototyping, anyone?


[Game Developer (previously known as Gamasutra)](https://www.gamedeveloper.com/) - A site filled with post-mortems, gamedev news, blog posts, and other articles with a focus on game developers and their communities.


[Papers Please Devlog](https://fguillen.github.io/PapersPleaseDevlogScrap/) - Posts from the development of Papers Please.


[EA Spouse](https://ea-spouse.livejournal.com/274.html) - A cautionary tale on crunch. For all of our sakes, don't let the industry return to this.


[Where the Water Tastes Like Wine Postmortem](https://johnnemann.medium.com/where-the-water-tastes-like-wine-postmortem-211a1f9d791a) - A must-read for aspiring independent game developers. Making money from the art is hard, even for industry veterans, but there are other things that are valuable.


[Surveillance Self-Defense](https://ssd.eff.org/en) - Tips, Tools, and Tutorials for privacy and online self-defense


[Polyglot Gamedev](https://docs.google.com/spreadsheets/d/17f0dQawb-s_Fd7DHgmVvJoEGDMH_yoSd8EYigrb0zmM/edit#gid=296134756) - A big list of localized words across many different languages that can be used to loosely translate simple phrases such as UI buttons or tooltips. 


[Tiny Tools](https://tinytools.directory/) - A collection of tiny, usually fun tools for various purposes! 


[Paul Graham](http://paulgraham.com/articles.html) - Good general advice, both for specific disciplines (particularly programming and business) and for life, from Paul Graham (founder of YCombinator).


[Open Dyslexic](https://opendyslexic.org/) - A dyslexia-friendly, accessible font! 


[Is This Arabic?](https://isthatarabic.com) - A friendly guide to not borking Arabic script.


[The Stranger Things (or Montauk) pitch bible](http://www.zen134237.zen.co.uk/Stranger_Things/Stranger_Things_-_Bible.pdf) - Useful as reference for what a great pitch can look like, albeit in the context of film rather than games.


</p>
<br />
<br />
  
![A cute drawing of Asriel from Undertale reaching for a heart](images/Asriel.png 'Thanks for reading!')

