# Contribution Guidelines

Please note that this project is released with a [Contributor Code of Conduct](code-of-conduct.md). By participating in this project, you agree to abide by its terms.

Before submitting a pull request please:

- Read the About section of the readme in full, to ensure that your request is in line with the purpose of this list.
    - Tools are cool, but only included out of necessity. Resources to learn said tools are preferable to the tools themselves. 
    - Similarly, assets are included to enable work that relies on other roles. For example, art and music are included to support programmers and designers, and rigs are included to support animators. 
- Ensure that new suggestions do not contain outdated information or broken links.
- Ensure that all suggestions are legally sourced (in particular, watch for illegally distributed pdfs of books)
- Ensure that all suggestions would be useful to others - I try to curate things, so don't over-do it on the links 
- Search previous suggestions before making a new one to avoid duplicates.
    - Note that this is important even if you've read the relevant category because it may be in a different category than you expect - for example, game art portfolio advice would be listed under career, not art.
- Include a link to all new suggestions for resources - don't just add plaintext names, even for print objects books!
- Include a relevant, succinct description of each new link, matching the existing style of the guide
- Append new links to the bottom of the relevant category and sub-category.
    - New categories/sub-categories and improvements to existing categorization are welcome. Be sure to update the table of contents!
- Make an individual pull request for each suggestion (bunches of links are fine - links and recategorizations are not).
- Avoid misusing the purple square (🟪) and the blue star (💠). These are extremely important resources or collections of resources, and need to be treated as such - if in doubt, leave it out!
- Check your spelling and grammar.
- Title your pull request and commit nicely.

If any issues are caught, we will ask you to edit your Pull Request before it is included. This is normally due to spelling errors, or because your PR didn't match the guidelines.

[Here](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) is a write up on how to change a Pull Request, and the different ways you can do that.

Finally, please remember that every link and contribution - no matter how small - is highly appreciated and encouraged. We're here to support the whole community!