# Awesome Web Typography [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)


A curated collection of awesome web typography articles.

## Articles

- [No @font-face Syntax will ever be Bulletproof, Nor Should It Be](https://calendar.perfplanet.com/2016/no-font-face-bulletproof-syntax/)
- [Font Aliasing, or how to rename a font in CSS](https://www.zachleat.com/web/rename-font/)
- [The Future of Web Fonts](https://viljamis.com/2016/the-future-of-web-fonts/)
- [Your Body Text Is Too Small](https://medium.com/@xtianmiller/your-body-text-is-too-small-5e02d36dc902#.w1wdaeqzo)
- [Methods for Controlling Spacing in Web Typography](https://css-tricks.com/methods-controlling-spacing-web-typography/)
- [Bold or Italic](https://practicaltypography.com/bold-or-italic.html)
- [Webfonts on the Prairie](https://alistapart.com/article/webfonts-on-the-prairie)
- [Typography is impossible](https://medium.engineering/typography-is-impossible-5872b0c7f891#.5tnat6wy5)
- [The New Web Typography](https://robinrendle.com/essays/new-web-typography/)
- [Tools And Resources For A More Meaningful Web Typography](https://www.smashingmagazine.com/2016/03/meaningful-web-typography/)
- [A more modern scale for Web Typography](http://typecast.com/blog/a-more-modern-scale-for-web-typography)
- [Better web typography in 13 simple steps](https://www.creativebloq.com/typography/better-web-typography-few-simple-steps-5132803)
- [Choosing web fonts: 15 expert tips](https://www.creativebloq.com/web-design/choose-web-fonts-1233034)
- [The Good, The Bad And The Great Examples Of Web Typography](https://www.smashingmagazine.com/2014/12/the-good-the-bad-and-the-great-examples-of-web-typography/)
- [Web Fonts Performance: Making Pretty, Fast](https://www.igvita.com/2012/09/12/web-fonts-performance-making-pretty-fast/)
- [Font Smoothing](https://davidwalsh.name/font-smoothing)
- [The State of Web Type](https://dev.opera.com/articles/state-of-web-type/)
- [Dashes in Web Typography](https://viljamis.com/dashes/)
- [Scale & Rhythm in Typography](http://lamb.cc/typograph/)
- [Typographic Scale](http://retinart.net/typography/typographicscale/)
- [The Mathematical Symphony of Typography](https://pearsonified.com/2011/12/golden-ratio-typography.php)
- [The Best Free Alternatives to the Most Popular Fonts](https://blog.spoongraphics.co.uk/articles/the-best-free-alternatives-to-the-most-popular-fonts)
- [A History of Typeface Styles & Type Classification](https://blog.spoongraphics.co.uk/articles/a-history-of-typeface-styles-type-classification)
- [26 digital typography rules for beginners](https://medium.com/product-design-ux-ui/26-digital-typography-rules-for-beginners-a04c6a5aaff3)
- [Variable Fonts for Responsive Design](https://alistapart.com/blog/post/variable-fonts-for-responsive-design)
- [Typeface Mechanics](https://frerejones.com/blog/typeface-mechanics-001/)
- [Truly Fluid Typography With vh And vw Units](https://www.smashingmagazine.com/2016/05/fluid-typography/)
- [Viewport Based Typography](https://zellwk.com/blog/viewport-based-typography/)
- [Animated Typographic Cheat Sheet](https://www.supremo.co.uk/typeterms/)
- [Typography for User Interfaces](https://viljamis.com/2016/typography-for-user-interfaces/)
- [Loading Web Fonts Asynchronously](https://calendar.perfplanet.com/2016/loading-web-fonts-asynchronously/)
- [Font-size: An Unexpectedly Complex CSS Property](https://manishearth.github.io/blog/2017/08/10/font-size-an-unexpectedly-complex-css-property/)
- [93 most popular premium fonts alternative google fonts](https://designtheway.com/most-used-fonts-alternative-google-fonts/)
- [Font Aliasing, or How to Rename a Font in CSS](https://www.zachleat.com/web/rename-font/)

## Web Fonts & Web Performance
- [Controlling Font Performance with font-display](https://developers.google.com/web/updates/2016/02/font-display)
- [Lightning Fast Font Loading Techniques](https://davidwalsh.name/font-loading)
- [Loading webfonts with high performance on responsive websites](http://bdadam.com/blog/loading-webfonts-with-high-performance.html)
- [Font Loading Revisited with Font Events](https://www.filamentgroup.com/lab/font-events.html)
- [How we use web fonts responsibly, or, avoiding a @font-face-palm](https://www.filamentgroup.com/lab/font-loading.html)
- [Better @font-face with Font Load Events](https://dev.opera.com/articles/better-font-face/)
- [Better webfont loading with using localStorage and providing WOFF2 support](http://bdadam.com/blog/better-webfont-loading-with-localstorage-and-woff2.html)
- [Using Web Fonts the Best Way (in 2015)](https://helloanselm.com/writings/using-webfonts-in-2015)
- [Web Font Loading Patterns](http://bramstein.com/writing/web-font-loading-patterns.html)
- [Performance and Web Typography - Video](https://www.youtube.com/watch?v=emLfXChvVPQ)
- [Tips for balancing web fonts & page load](https://frontendnews.io/editions/2018-07-25-tips-for-loading-web-fonts)
- [Loading Web Fonts Asynchronously](http://calendar.perfplanet.com/2016/loading-web-fonts-asynchronously/)
- [Font Aliasing, or How to Rename a Font in CSS](https://www.zachleat.com/web/rename-font/)
- [A Collection of Web Font Loading Recipes](https://www.zachleat.com/web/recipes/)
- [No @font-face Syntax will ever be Bulletproof, Nor Should It Be](http://calendar.perfplanet.com/2016/no-font-face-bulletproof-syntax/)
- [Performance and Web Typography](https://www.youtube.com/watch?v=emLfXChvVPQ)

## Tools
- [The State of Web Type - Up-to-date data on support for type and typographic features on the web](http://stateofwebtype.com/)
- [A simple plugin to keep font-size in proportion with it's containers size](https://github.com/jkroso/flowtype)
- [Type Rendering Mix](http://typerendering.com/)
- [Web Font Loader](https://developers.google.com/fonts/docs/webfont_loader)
- [Preventing the Performance Hit from Custom Fonts](https://css-tricks.com/preventing-the-performance-hit-from-custom-fonts/)
- [Web Font Optimization](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/webfont-optimization?hl=en)
- [Font Face and Performance](http://www.stevesouders.com/blog/2009/10/13/font-face-and-performance/)
- [Normalize-Opentype.css - Adds OpenType features—ligatures, kerning, and more—to Normalize.css.](https://github.com/kennethormandy/normalize-opentype.css)
- [Type­set.js - A typographic pre-processor for your html which uses zero client-side JavaScript](https://blot.im/typeset/)
- [brick.im](https://github.com/alfredxing/brick)
- [Typebase.css](http://devinhunt.github.io/typebase.css/)
- [Google WebFonts Helper](https://google-webfonts-helper.herokuapp.com/fonts/aguafina-script?subsets=latin)
- [Using Custom Fonts in Emails](https://github.com/ladjs/custom-fonts-in-emails)
- [Typographist — Modular scale calculator API with config validation](https://github.com/typographist)
- [Font Face Observer is a fast and simple web font loader](https://fontfaceobserver.com/)
- [MixFont A Modern Font Generator](https://www.mixfont.com/)
- [How to use custom fonts in emails](https://github.com/forwardemail/custom-fonts-in-emails)

## Books
- [On Web Typography](https://abookapart.com/products/on-web-typography)
- [The Elements of Typographic Style](https://www.amazon.co.uk/Elements-Typographic-Style-Robert-Bringhurst/dp/0881792063)
- [The Elements of Typographic Style - Online Version](http://webtypography.net/)
- [Practical Typography](https://practicaltypography.com/)
- [Combining Typefaces: Free guide to great typography](https://blog.typekit.com/2016/04/29/combining-typefaces-free-guide-to-great-typography/)
- [The Typography Handbook](http://typographyhandbook.com/)

## Font Combinations
- [Mixfont](https://www.mixfont.com/)
- [Font Combinations](https://www.canva.com/font-combinations/)
- [Google web fonts in action](http://femmebot.github.io/google-type/)
- [Beautiful Web Type](https://beautifulwebtype.com/)
- [Google Font Combinations](https://briangardner.com/google-font-combinations/)
- [Top 5 Google Fonts](http://techdissected.com/web-and-computing/design/top-5-google-font-combinations/)
- [100 Days of Fonts](http://100daysoffonts.com/)
- [Sessions with Typography](http://www.sessions-with-typography.com)
- [Google Web Font inspiration in HTML & CSS](http://tobiasahlin.com/typesource/)
- [Google Font Pairing Tool](http://www.ourownthing.co.uk/fontpairing/)

## Talks
- [Web Fonts are Rocket Science](https://www.filamentgroup.com/lab/rocket-science.html)
- [Video Screencast - Font Loading with Zach Leatherman](https://css-tricks.com/video-screencasts/152-font-loading-zach-leatherman/)

## Featured
- This [site](https://deanhume.github.io/typography/) was featured on the [Device Wall](https://twitter.com/gauntface/status/604029887414829057/photo/1) at Google I/O 2015.

![Google I/O Device Wall](https://raw.githubusercontent.com/deanhume/typography/master/images/device-wall-small.jpg)

## License

[![CC0](https://licensebuttons.net/l/by/4.0/88x31.png)](https://creativecommons.org/licenses/by/4.0/)
