<div align="center">

# Awesome Product Management

[![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)
[![PDF Build](https://github.com/dend/awesome-product-management/actions/workflows/makepdf.yml/badge.svg)](https://github.com/dend/awesome-product-management/actions/workflows/makepdf.yml)
[![Link Checker](https://github.com/dend/awesome-product-management/actions/workflows/linkchecker.yml/badge.svg)](https://github.com/dend/awesome-product-management/actions/workflows/linkchecker.yml)
[![GitHub Repo stars](https://img.shields.io/github/stars/dend/awesome-product-management?style=flat)](https://github.com/dend/awesome-product-management/stargazers)

*A curated list of awesome resources for product/program managers to learn and grow.*

</div> 

## Who's a product manager?

By definition, a product manager is an individual who drives the product vision and has a deep understanding of customer needs. PMs generally are considered to be at the intersection of the business, technology and design spaces - they are the experts in the problem space, and are able to learn and iterate quickly to deliver valuable experiences to consumers.

## Contents

- [Tools](#tools)
  - [Note-Taking & Documentation](#note-taking--documentation)
    - [OneNote](#onenote)
    - [Bear](#bear)
    - [Obsidian](#Obsidian)
    - [Notion](#notion)
    - [Notejoy](#notejoy)
  - [Task & Project Management](#task--project-management)
    - [Trello](#trello)
    - [Taiga](#taiga)
    - [Tenzu](#tenzu)
    - [To-Do](#to-do)
    - [Taskade](#taskade)
  - [Design & Prototyping](#design--prototyping)
    - [Balsamiq](#balsamiq)
    - [Sketch](#sketch)
    - [Figma](#figma)
  - [Product Roadmapping & Feedback](#product-roadmapping--feedback)
    - [productboard](#productboard)
    - [logchimp](#logchimp)
    - [Hellonext](#hellonext)
    - [Screeb](#screeb)
  - [OKRs & Outcome Tracking](#okrs--outcome-tracking)
    - [Tability](#tability)
- [Articles](#articles)
  - [Product Fundamentals & Philosophy](#product-fundamentals--philosophy)
  - [Product Development & Process](#product-development--process)
  - [Product Strategy & Planning](#product-strategy--planning)
  - [Customer Research & User Experience](#customer-research--user-experience)
  - [Team Collaboration & Leadership](#team-collaboration--leadership)
  - [Product Metrics & Analytics](#product-metrics--analytics)
  - [Career Development & Skills](#career-development--skills)
  - [Growth & Marketing](#growth--marketing)
- [Books](#books)
  - [Product Management Fundamentals](#product-management-fundamentals)
  - [Product Strategy & Planning](#product-strategy--planning-1)
  - [Customer Research & User Experience](#customer-research--user-experience-1)
  - [Product Development & Process](#product-development--process-1)
  - [Team Leadership & Management](#team-leadership--management)
  - [Psychology & Behavioral Change](#psychology--behavioral-change)
  - [Engineering & Technical](#engineering--technical)
- [Podcasts](#podcasts)
- [Communities](#communities)
- [Conferences](#conferences)
- [Additional resources](#additional-resources)
- [License](#license)

## Tools

In day-to-day activities, product managers need to rely on tools to help them make sense of the information and insights they're handling. The list below represents _some_ of those tools. A product manager doesn't need to use every single one of them, and neither is one better than the other. These are just pointers to some of the instruments that can be used to be effective at organizing and sharing PM expertise. None of them, standalone, will make one a better product manager.

### Note-taking & Knowledge Management
Tools in this section help product managers capture meeting notes, ideas, research, and product knowledge efficiently.

#### OneNote

Efficient note-taking with superior organizational capabilities. Integrates easily with team-based workflows, where notes from the same notebook can be shared with many individuals.

![OneNote](media/tool-onenote.gif)

| Property  | Value                              |
|-----------|------------------------------------|
| Developer | [Microsoft](https://microsoft.com) |
| Cost      | Free                               |
| Platform  | macOS, Windows, iOS, Android, web  |
| URL       | https://onenote.com                |

#### Bear

Note-taking in Markdown format, with tag-based organizational capabilities.

![Bear](media/tool-bear.gif)

| Property  | Value                                      |
|-----------|--------------------------------------------|
| Developer | [Shiny Frog](http://www.shinyfrog.net/)    |
| Cost      | Freemium (_$16/yr subscription available_) |
| Platform  | macOS, iOS                                 |
| URL       | https://bear.app/                          |

#### Obsidian

Obsidian is a private and flexible writing app that adapts to the way you think. From personal notes to journaling, knowledge bases, and project management, Obsidian gives you the tools to come up with ideas and organize them. Turn your notes into an online wiki, knowledge base, documentation, or digital garden.

![Obsidian](media/obsidian.png)

| Property  | Value                                       |
|-----------|---------------------------------------------|
| Developer | [Obsidian, Inc.](https://obsidian.md)       |
| Cost      | Paid if used commercially (_$50/user/year_) |
| Platform  | iOS, Android, Windows, Mac, Linux           |
| URL       | https://obsidian.md/                        |

#### Notejoy

A collaborative note-taking application that is simple, intuitive and allows you to focus on the notes rather than the process around those.

| Property  | Value                                                                                                            |
|-----------|------------------------------------------------------------------------------------------------------------------|
| Developer | [Sachin Rekhi](https://www.linkedin.com/in/sachinrekhi/), [Ada Chen Rekhi](https://www.linkedin.com/in/adachen/) |
| Cost      | Freemium (_$0-12/month_)                                                                                         |
| Platform  | macOS, Windows, iOS, Android, web                                                                                |
| URL       | https://notejoy.com                                                                                              |

#### Notion

All-in-one workspace for teams and individuals.

![Notion](media/tool-notion.gif)

| Property  | Value                                                |
|-----------|------------------------------------------------------|
| Developer | [Notion Labs](https://notion.so/)                    |
| Cost      | Freemium (_$4/mo/user individual, $8/mo/user teams_) |
| Platform  | macOS, Windows, iOS, Android, web                    |
| URL       | https://notion.so/                                   |

### Task & Project Management
Use these tools to manage team tasks, backlogs, sprints, and collaboration efficiently across product development cycles.

#### Trello

A visual project and task management tool based on Kanban boards. Suitable for lightweight workflows and collaborative product planning. Offers integrations with Slack, Jira, GitHub, and more.

| Property  | Value                                          |
|-----------|------------------------------------------------|
| Developer | [Atlassian](https://www.atlassian.com/)        |
| Cost      | Freemium (_$9.99/mo+ subscriptions available_) |
| Platform  | macOS, Windows, iOS, Android, web              |
| URL       | https://trello.com/                            |

#### Taiga

Taiga is a project management tool for multi-functional agile teams. It has a rich feature set and at the same time it is very simple to start with through its intuitive user interface.

![Switching zoom modes in Kanban section](media/tool-taiga.gif)

| Property  | Value                                                    |
|-----------|----------------------------------------------------------|
| Developer | [Kaleidos](https://kaleidos.net/)                        |
| Cost      | Free (self-hosted) or [Freemium](https://taiga.io/) |
| Platform  | macOS, Windows, iOS, Android, Web                        |
| URL       | https://taiga.io                                    |

#### Tenzu

Lightweight project management tool for agile teams. Features workspaces creation and kanban boards.

![Tenzu overview](media/tool-tenzu.gif)

| Property  | Value                                                                 |
|-----------|-----------------------------------------------------------------------|
| Developer | [BIRU](https://biru.sh/)                                              |
| Cost      | Free (self-hosted) or [Free contribution](https://tenzu.net/pricing/) |
| Platform  | Web                                                                   |
| URL       | https://tenzu.net                                                     |

#### To-Do

A tool to quickly manage "to-dos".

| Property  | Value                                   |
|-----------|-----------------------------------------|
| Developer | [Microsoft](https://www.microsoft.com/) |
| Cost      | Free                                    |
| Platform  | macOS, Windows, iOS, Android, web       |
| URL       | https://to-do.microsoft.com/            |

#### Taskade

Get work done with collaborative task lists, notes and video chat. Taskade is beautifully designed for remote teams.

![Taskade](media/tool-taskade.gif)

| Property  | Value                                                              |
|-----------|--------------------------------------------------------------------|
| Developer | [Taskade Inc.](https://taskade.com/about)                          |
| Cost      | Freemium (_$0-10/month_)                                           |
| Platform  | macOS, Windows, iOS, Android, Chrome Extension, Firefox Addon, Web |
| URL       | https://www.taskade.com                                            |


### Design & Prototyping
Design interfaces and prototypes to visualize and test user experiences before development begins.


#### Balsamiq

Wireframing tool that allows building mocks without a strong focus on details. Extremely useful for situations where you don't want others to over-index on pixels and instead focus on the content.

| Property  | Value                                          |
|-----------|------------------------------------------------|
| Developer | [Balsamiq Studios, LLC](https://balsamiq.com/) |
| Cost      | Paid (_$89/person - permanent license_)        |
| Platform  | macOS, Windows, web                            |
| URL       | https://balsamiq.com/                          |

#### Sketch

Mocking and prototyping made efficient. Offers many downloadable components that can help one create high-fidelity designs for websites, apps and other experiences.

![Sketch](media/tool-sketch.gif)

| Property  | Value                                                |
|-----------|------------------------------------------------------|
| Developer | [Bohemian B.V.](https://www.sketchapp.com/about-us/) |
| Cost      | Paid (_$99/year_)                                    |
| Platform  | macOS                                                |
| URL       | https://www.sketchapp.com/                           |

#### Figma

A better way to design. Design, prototype, and collaborate all in the browser—with Figma.

![Figma](media/tool-figma.gif)

| Property  | Value                                |
|-----------|--------------------------------------|
| Developer | [Figma](https://www.figma.com/blog/) |
| Cost      | Freemium (_$0-45/month_)             |
| Platform  | macOS, Windows, web                  |
| URL       | https://www.figma.com                |


### Product Roadmapping & Feedback
These tools help PMs collect feedback, define product direction, and share strategic roadmaps.


#### productboard

productboard is the product management system that helps you understand what users need, prioritize what to build, and rally everyone around your roadmap.

![productboard](media/tool-productboard.png)

| Property  | Value                                         |
|-----------|-----------------------------------------------|
| Developer | [productboard](https://www.productboard.com/) |
| Cost      | Paid (starts at _$49/month_)                  |
| Platform  | Web                                           |
| URL       | https://productboard.com                      |

#### logchimp

LogChimp allows you to track your customers feedback to build better products.

![logchimp](media/logchimp.png)

| Property  | Value                                        |
|-----------|----------------------------------------------|
| Developer | [LogChimp](https://logchimp.codecarrot.net/) |
| Cost      | Free (Open source)                           |
| Platform  | Web                                          |
| URL       | https://logchimp.codecarrot.net              |


#### Hellonext

Hellonext helps you close the user feedback loop. Comes with feedback portal, roadmap, and changelog.

![hellonext](media/hellonext.png)

| Property  | Value                                    |
|-----------|------------------------------------------|
| Developer | [Hellonext, Inc.](https://hellonext.co)  |
| Cost      | Freemium (_$0-99/month_)                 |
| Platform  | Web                                      |
| URL       | https://hellonext.co                     |

#### Screeb

Screeb is a product-led user research platform helping product teams to build better products by helping understand their users.

![screeb](media/screeb.png)

| Property  | Value                              |
|-----------|------------------------------------|
| Developer | [Screeb, Inc.](https://screeb.app) |
| Cost      | Freemium (_start $0-39/month_)     |
| Platform  | Web                                |
| URL       | https://screeb.app                 |


### OKRs & Outcome Tracking
Track team goals and outcomes, not just output. These tools help PMs maintain focus on measurable impact.


#### Tability  
A lightweight OKR tracking tool that helps product teams stay focused on outcomes, not outputs. Great for async check-ins and remote teams.


| Property   | Value                              |
|------------|------------------------------------|
| Developer  | Tability                           |
| Cost       | Freemium (Paid plans from $35/mo)  |
| Platform   | Web                                |
| URL        | https://tability.io                |

## Articles

There are a lot of folks that write great content that can help those wanting to excel and grow in the product management field to gain new perspectives. Treat the list below as an amalgamation of opinions, experiences, and patterns rather than as a definitive "list of things to always do."

### Product Fundamentals & Philosophy

Core principles and mental models that shape effective product thinking and decision-making.

- [How to build great products](https://www.defmacro.org/2013/09/26/products.html) - By [Slava Akhmechet](https://www.defmacro.org).
- [If your product is Great, it doesn't need to be Good](https://paulbuchheit.blogspot.com/2010/02/if-your-product-is-great-it-doesnt-need.html) - By [Paul Bucheit](http://en.wikipedia.org/wiki/Paul_Buchheit).
- [Finding and Fostering Great Product Sense](https://staysaasy.com/product/2023/05/14/product-sense.html) - By [Stay SaaSy](https://staysaasy.com/about.html).
- [Want To Build An Incredible Product? Strive For The Delta Of "Wow"](https://medium.com/@waynechang/want-to-build-an-incredible-product-strive-for-the-delta-of-wow-f184b716af18) - By [Wayne Chang](https://chang.com/).
- [Quality is not a tradeoff](https://medium.com/the-year-of-the-looking-glass/quality-is-not-a-tradeoff-bcddf7c85553) - By [Julie Zhuo](https://www.juliezhuo.com/).
- [The Black Box of Product Management](https://blackboxofpm.com/the-black-box-of-product-management-3feb65db6ddb) - By [Brandon Chu](https://medium.com/@brandonmchu).
- [Product Management Mental Models for Everyone](https://blackboxofpm.com/product-management-mental-models-for-everyone-31e7828cb50b) - By [Brandon Chu](https://medium.com/@brandonmchu).
- [Great Product Managers are "Outcome Thinkers"](https://medium.com/@max.bennett/great-product-managers-are-outcome-thinkers-66fa5d69cfac) - By [Max Bennett](https://medium.com/@max.bennett).
- [Do you really understand the concept of product value?](https://www.productboard.com/blog/do-you-really-understand-the-concept-of-product-value/) - by [Hubert Palan](https://www.linkedin.com/in/hubertpalan/).
- [My product is my garden](https://herman.bearblog.dev/my-product-is-my-garden/) - By [Herman Martinus](https://herman.bearblog.dev/).
- [Solution-space taste](https://grantslatton.com/solution-space-taste) - By [Grant Slatton](https://grantslatton.com/).
- [The Tools Don't Matter](https://www.bringthedonuts.com/essays/the-tools-dont-matter/) - By [Ken Norton](https://www.bringthedonuts.com/).
- [Building a Great Product Management Organization](https://melissaperri.com/blog/2024/7/16/building-a-great-product-management-organization) - By [Melissa Perri](https://melissaperri.com/).
- [Relentlessly Resourceful](http://www.paulgraham.com/relres.html) - By [Paul Graham](https://www.paulgraham.com/).
- [How to Be an Expert in a Changing World](http://www.paulgraham.com/ecw.html) - By [Paul Graham](https://www.paulgraham.com/).
- [Hackers and Painters](http://www.paulgraham.com/hp.html) - By [Paul Graham](https://www.paulgraham.com/).
- [The Product Manager](https://paulgraham.com/pmjob.html) - By [Paul Graham](https://www.paulgraham.com/).

### Product Development & Process

Methodologies, processes, and best practices for building and shipping products effectively.

- [How to Deliver More Software Projects on Time](https://web.archive.org/web/20151029064330/https://www.inc.com/mark-suster/how-to-deliver-more-software-projects-on-time.html) - By [Mark Suster](https://www.linkedin.com/in/marksuster/).
- [Shipping is a Feature: Some Guiding Principles for People That Build Things](https://a16z.com/2014/04/16/shipping-is-a-feature-some-guiding-principals-for-people-that-build-things/) - By [Michael Copeland](https://www.linkedin.com/in/mcopeland/).
- [The Time Value of Shipping](https://blackboxofpm.com/the-time-value-of-shipping-6deaf8d7d565) - By [Brandon Chu](https://medium.com/@brandonmchu).
- [A Minimum Viable Product Is Not a Product, It's a Process](https://web.archive.org/web/20201004000942/https://www.ycombinator.com/library/4Q-a-minimum-viable-product-is-not-a-product-it-s-a-process) - By [Jim Brikman](https://www.ybrikman.com/).
- [Painless Functional Specifications – Part 1: Why Bother?](https://www.joelonsoftware.com/2000/10/02/painless-functional-specifications-part-1-why-bother/) - By [Joel Spolsky](https://www.joelonsoftware.com).
- [Painless Functional Specifications – Part 2: What's a Spec?](https://www.joelonsoftware.com/2000/10/03/painless-functional-specifications-part-2-whats-a-spec/) - By [Joel Spolsky](https://www.joelonsoftware.com).
- [Painless Functional Specifications – Part 3: But… How?](https://www.joelonsoftware.com/2000/10/04/painless-functional-specifications-part-3-but-how/) - By [Joel Spolsky](https://www.joelonsoftware.com).
- [Painless Functional Specifications – Part 4: Tips](https://www.joelonsoftware.com/2000/10/15/painless-functional-specifications-part-4-tips/) - By [Joel Spolsky](https://www.joelonsoftware.com).
- [One door at a time](https://m.signalvnoise.com/one-door-at-a-time/) - By [Jason Fried](https://world.hey.com/jason).
- [Do Things that Don't Scale](http://paulgraham.com/ds.html) - By [Paul Graham](https://www.paulgraham.com/).
- [Speed as a habit](http://firstround.com/review/speed-as-a-habit/) - By [Dave Girouard](https://www.linkedin.com/in/davegirouard).
- [A Comprehensive Guide To Product Design](https://www.smashingmagazine.com/2018/01/comprehensive-guide-product-design/) - By [Nick Babich](https://www.smashingmagazine.com/author/nickbabich).
- [Don't Give Your Users Shit Work ](https://zachholman.com/posts/shit-work/) - By [Zach Holman](https://zachholman.com/about).
- [Don't start a tech-enabled service](https://waseem.substack.com/p/tech-enabled-services) - By [Waseem Daher](https://substack.com/@waseem).

### Product Strategy & Planning

Strategic thinking, roadmapping, prioritization, and long-term product planning approaches.

- [Guide to building a product roadmap](https://hellonext.co/blog/how-to-build-great-product-roadmap) - By Hellonext, Inc.
- [12 Things about Product-Market Fit](https://web.archive.org/web/20180629011058/https://a16z.com/2017/02/18/12-things-about-product-market-fit/) - By [Tren Griffin](https://www.linkedin.com/in/tren-griffin-50582725/).
- [Understanding How The Innovator's Dilemma Affects You](https://bothsidesofthetable.com/understanding-how-the-innovator-s-dilemma-affects-you-75563219a58d) - By [Mark Suster](https://www.linkedin.com/in/marksuster/).
- [OKRs and Product Roadmaps](https://www.romanpichler.com/blog/okrs-and-product-roadmaps/) - By [Roman Pichler](https://www.romanpichler.com/).
- [Product OKRs: Driving Outcomes Over Outputs](https://productschool.com/blog/product-strategy/product-okrs) - By [Carlos Gonzalez de Villaumbrosia](https://www.linkedin.com/in/villaumbrosia/).
- [Deadlines](https://blackboxofpm.com/deadlines-d6925e5c694f) - By [Brandon Chu](https://medium.com/@brandonmchu).
- [Ruthless Prioritization](https://blackboxofpm.com/ruthless-prioritization-e4256e3520a9) - By [Brandon Chu](https://medium.com/@brandonmchu).
- [How to focus on what's important, not just what's urgent](https://hbr.org/2018/07/how-to-focus-on-whats-important-not-just-whats-urgent) - By [Alice Boyes](https://www.aliceboyes.com/).
- [Mud Rooms, Red Letters, and Real Priorities](https://web.archive.org/web/20090710004515/https://www.43folders.com/2009/04/28/priorities) - By [Merlin Mann](https://web.archive.org/web/20090707094417/http://www.43folders.com/).
- [Good strategy understands affect, not just cognition](https://vaughntan.org/strataffect) - By [Vaughn Tan](https://www.linkedin.com/in/vaughntan/).
- [Seven strategy tensions … and misunderstandings](https://vaughntan.org/strategy) - By [Vaughn Tan](https://www.linkedin.com/in/vaughntan/).
- [Is or Is Not The Opposite Stupid on its Face?](https://rogermartin.medium.com/is-or-is-not-the-opposite-stupid-on-its-face-ab635b9c5582) - By [Roger Martin](https://rogermartin.medium.com/).
- [Virtuous Cycles, Platforms, Flywheels, Snowballs, and Tidal Waves](https://ceklog.kindel.com/2021/03/30/virtuous-cycles-platforms-flywheels-snowballs-and-tidal-waves/) - By [Charlie Kindel](https://www.linkedin.com/in/ckindel/).
- [Is your company product-led, sales-led, or marketing-led?](https://philippcannons.com/is-your-company-product-led-sales-led-or-marketing-led/) - By [Philipp Cannons](https://philippcannons.com).
- [On narratives](https://ceklog.kindel.com/?s=narratives) - By [Charlie Kindel](https://www.linkedin.com/in/ckindel/).
- [Navigating Mid-Success](https://blog.ycombinator.com/navigating-mid-success/) - By [Sam Altman](https://en.wikipedia.org/wiki/Sam_Altman).
- [Startup Exercise: What can't be solved with money?](https://longform.asmartbear.com/startup-money/) - By [Jason Cohen](https://www.linkedin.com/in/jasoncohen).
- [Product Purgatory: When they love it but still don't buy](https://longform.asmartbear.com/purgatory/) - By [Jason Cohen](https://www.linkedin.com/in/jasoncohen).
- [Product Discovery Basics](https://www.producttalk.org/2021/08/product-discovery/) - By [Teresa Torres](https://www.producttalk.org/).
- [Remote Product Management Tips](https://www.atlassian.com/agile/product-management/remote-product-management) - By [Atlassian](https://www.atlassian.com/).
- [How to Craft Your Product Management Team Structure at Every Stage](https://review.firstround.com/how-to-craft-your-product-team-at-every-stage-from-pre-product-market-fit-to-hypergrowth/) - By [Nikhyl Singhal](https://www.linkedin.com/in/nikhylsinghal/).

### Customer Research & User Experience

Understanding users, conducting research, and designing better customer experiences.

- [How to Listen to Customers](https://www.bringthedonuts.com/essays/how-to-listen-to-customers.html) - By [Ken Norton](https://www.bringthedonuts.com/).
- [The Product Manager's Guide to UX Research](https://www.userinterviews.com/blog/ux-research-for-product-managers) - By [Katryna Balboni](https://katryna-balboni.com/).
- [Effective User Interviews](https://producthq.org/agile/product-management/effective-user-interviews/) - By [Product HQ](https://producthq.org/).
- [Story-Based Customer Interviews](https://www.producttalk.org/2024/04/story-based-customer-interviews/) - By [Teresa Torres](https://www.producttalk.org/).
- [Product Management Skills: User Research](https://productschool.com/blog/user-experience/product-management-skills-user-research) - By [Carlos Gonzalez de Villaumbrosia](https://www.linkedin.com/in/villaumbrosia/).
- [The Quintessential Guide For Building An Unforgettable First-time User Experience](https://hackernoon.com/the-quintessential-guide-for-building-an-unforgettable-first-time-user-experience-19720a7447d2) - By [Wayne Chang](https://chang.com/).
- [User Onboarding Examples: Analyzing 6 Real-Life Onboarding Flows](https://cxl.com/blog/6-user-onboarding-flows/) - By [Shanelle Mullin](https://cxl.com/blog/author/shanelle-mullin/).
- [Inside the 6 Hypotheses that Doubled Patreon's Activation Success](https://brianbalfour.com/essays/patreon-onboarding-growth) - By [Brian Balfour](https://brianbalfour.com).
- [How to Use the Google HEART Framework to Measure and Improve Your App's UX](https://web.archive.org/web/20190714162138/https://clevertap.com/blog/google-heart-framework/) - By [Emily Bonnie](https://web.archive.org/web/20200320142602/https://clevertap.com/blog/author/emily/).

### Team Collaboration & Leadership

Working effectively with cross-functional teams, leadership, and communication strategies.

- [How to Work with Designers](https://medium.com/the-year-of-the-looking-glass/how-to-work-with-designers-6c975dede146#.e81zu5ql7) - By [Julie Zhuo](https://joulee.medium.com/).
- [How to Work With Software Engineers](https://www.bringthedonuts.com/essays/how-to-work-with-software-engineers.html) - By [Ken Norton](https://www.bringthedonuts.com/).
- [The Product-Minded Software Engineer](https://blog.pragmaticengineer.com/the-product-minded-engineer/) - By [Gergely Orosz](https://blog.pragmaticengineer.com/).
- [Being Glue](https://noidea.dog/glue) - By [Tanya Reilly](https://noidea.dog/about).
- [The work is never just "the work"](https://davestewart.co.uk/blog/the-work-is-never-just-the-work/) - By [Dave Stewart](https://davestewart.co.uk/).
- [You Won't Regret Positive Feedback](https://zachholman.com/posts/positive-feedback/) - By [Zach Holman](https://zachholman.com).
- [Maker's Schedule, Manager's Schedule](http://www.paulgraham.com/makersschedule.html) - By [Paul Graham](https://www.paulgraham.com/).
- [The Art of Persuasion Hasn't Changed in 2,000 Years](https://hbr.org/2019/07/the-art-of-persuasion-hasnt-changed-in-2000-years) - By [Carmine Gallo](https://hbr.org/search?term=carmine%20gallo).
- [Mastering Effective Communication as a Product Manager](https://www.sachinrekhi.com/mastering-effective-communication-as-a-product-manager) - By [Sachin Rekhi](https://www.sachinrekhi.com/about).
- [The Top 10 Deliverables of Product Managers](https://www.sachinrekhi.com/top-10-deliverables-of-product-managers) - By [Sachin Rekhi](https://www.sachinrekhi.com/about).
- [Coaching Tools – The Plan](https://svpg.com/coaching-tools-the-plan/) - By [Marty Cagan](https://www.svpg.com/team/marty-cagan/).
- [Remote teams](https://managershandbook.notion.site/Remote-teams-5ca3f257580040718fde6eb25c47e134) - By Notion Team.
- [The Dos and Don'ts of Mentoring in Product](https://www.mindtheproduct.com/the-dos-and-donts-of-mentoring-in-product/) - By [Eira Hayward](https://www.mindtheproduct.com/profile/eira-hayward/).
- [Rickover's Lessons](https://www.chinatalk.media/p/rickovers-lessons-how-to-build-a) - By [Lily Ottinger](https://substack.com/@voidpoliticstaiwan) and [Charles Yang](https://substack.com/@charlesyang).
- [What is Good Product Strategy?](https://melissaperri.com/blog/2016/07/14/what-is-good-product-strategy) - By [Melissa Perri](https://melissaperri.com/).
- [How to think strategically in your job](https://lesley.pizza/think-strategically-at-work/) - By [Lesley](https://lesley.pizza/about/).
- [Fell in a hole, got out](https://medium.com/the-coach-life/fell-in-a-hole-got-out-381356ec8d7f) - By [Tony Stubblebine](https://medium.com/@coachtony).

### Product Metrics & Analytics

Measuring success, understanding data, and making data-driven product decisions.

- [How to Calculate Customer Lifetime Value](https://blog.hubspot.com/service/how-to-calculate-customer-lifetime-value) - By [Clint Fontanella](https://www.pedaling4pups.com/).
- [Analytics should be an Assembly Line](https://tayloramurphy.substack.com/p/analytics-should-be-an-assembly-line) - By [Taylor A. Murphy](https://substack.com/@tayloramurphy).
- [SSEBITDA—A steady-state profit metric for SaaS companies](https://longform.asmartbear.com/ssebitda/) - By [Jason Cohen](https://www.linkedin.com/in/jasoncohen).
- [In-depth: The AARRR pirate funnel explained](https://posthog.com/product-engineers/aarrr-pirate-funnel) - By [PostHog](https://posthog.com).

### Career Development & Skills

Professional growth, skill development, and career advancement in product management.

- [How Am I Going To Move My Product Forward Today?](https://www.sachinrekhi.com/how-am-i-going-to-move-my-product-forward-today) - By [Sachin Rekhi](https://www.sachinrekhi.com/).
- [PM at Microsoft](https://web.archive.org/web/20180220022153/https://blogs.msdn.microsoft.com/techtalk/2005/12/16/pm-at-microsoft/) - By [Steven Sinofsky](https://en.wikipedia.org/wiki/Steven_Sinofsky).
- [Hiring Your First Product Manager](https://blog.learningbyshipping.com/2015/04/07/hiring-your-first-product-manager/) - By [Steven Sinofsky](https://en.wikipedia.org/wiki/Steven_Sinofsky).
- [Relentlessly Resourceful](http://www.paulgraham.com/relres.html) - By [Paul Graham](https://www.paulgraham.com/).
- [How to Be an Expert in a Changing World](http://www.paulgraham.com/ecw.html) - By [Paul Graham](https://www.paulgraham.com/).
- [The dark side of expertise](https://lwn.net/Articles/809556/) - By Jake Edge.
- [So You Wanted to be a Product Manager](https://stackoverflow.blog/2020/01/09/humor-so-you-wanted-to-be-a-product-manager/) - By [Scott C. Reynolds](https://stackoverflow.blog/author/sreynolds/).
- [Breaking into Product Management — Should you even consider it?](https://medium.com/@sshubhi/breaking-into-product-management-a-guide-c6fa3bc59449) - By [Shubhi Saxena](https://medium.com/@sshubhi).
- [Getting to the Product Manager interview stage](https://glenngillen.com/getting-the-pm-interview/) - By Glenn Gillen.
- [Is It Possible to Work Remotely as a Product Manager?](https://productschool.com/blog/job-search-advice/remote-product-manager) - By [Roy Cobby](https://www.linkedin.com/in/roycobby/).
- [Why Product Operations is the Next Iteration in Product Management](https://productcraft.com/perspectives/why-product-operations-is-the-next-iteration-in-product-management/) - By [Christine Itwaru](https://productschool.com/product-leaders/christine-itwaru).
- [It's Time to Fight for a Dual Product Management Career Path](https://www.bringthedonuts.com/essays/dual-product-management-career-path/) - By [Ken Norton](https://www.bringthedonuts.com/).
- [Great PM Interview Answers Include Tradeoffs. Here's How.](https://www.tryexponent.com/blog/the-key-to-a-successful-pm-interview-answer-tradeoffs) - By [Sushanth Raman](https://www.linkedin.com/in/sushanth-raman/).
- [Product Management Job Hunt: How to get an Interview and Nail it](https://mtp2017.wpenginepowered.com/product-management-job-hunt-how-to-get-an-interview-and-nail-it/) - By [Kostas Sirvydis](https://mtp2017.wpenginepowered.com/profile/KostasSirvydis203).
- [A Pyramid-shaped Career](https://jackdanger.com/pyramid-shaped-career/) - By [Jack Danger](https://jackdanger.com/about/).
- [Career advice in 2025](https://lethain.com/career-advice-2025/) - By [Will Larson](https://lethain.com/about/).
- [How to be more agentic](https://usefulfictions.substack.com/p/how-to-be-more-agentic) - By [Cate Hall](https://substack.com/@usefulfictions).
- [On agency](https://www.henrikkarlsson.xyz/p/agency) - By [Henrik Karlsson](https://substack.com/@henrikkarlsson) and [Johanna Karlsson](https://substack.com/@karlssonjohanna).

### Growth & Marketing

Product marketing, growth strategies, and customer acquisition approaches.

- [How We Got Our First 2,000 Users Doing Things That Don't Scale](https://www.fastcompany.com/3024472/how-we-got-our-first-2000-users-doing-things-that-dont-scale) - By [Ryan Hoover](https://www.fastcompany.com/user/ryan-hoover).
- [How To Get Media Coverage for Your Brand](https://www.shopify.com/blog/15973132-hacking-the-press-clever-ways-to-get-free-press-coverage-with-zero-budget#) - By [Michael Keenan](https://www.shopify.com/blog/authors/michael-keenan).
- [Guy Kawasaki, proto-evangelist](http://scripting.com/2024/10/08/155702.html) - By [Dave Winer](https://en.wikipedia.org/wiki/Dave_Winer).
- [The Art of Evangelism](https://hbr.org/2015/05/the-art-of-evangelism) - By [Guy Kawasaki](https://guykawasaki.com/).

## Books

### Product Management Fundamentals

Essential reading for understanding core product management principles, roles, and responsibilities.

- [Inspired: How to Create Tech Products Customers Love](https://www.barnesandnoble.com/w/inspired-marty-cagan/1127308294) - By Marty Cagan.
- [EMPOWERED: Ordinary People, Extraordinary Products](https://www.barnesandnoble.com/w/empowered-marty-cagan/1137059391?ean=9781119691297) - By Marty Cagan, Chris Jones.
- [Transformed: Moving to the Product Operating Model](https://www.barnesandnoble.com/w/transformed-marty-cagan/1143825957) - By Marty Cagan.
- [Escaping The Build Trap](https://www.oreilly.com/library/view/escaping-the-build/9781491973783/) - By Melissa Perri.
- [Product Operations: How successful companies build better products at scale](https://www.barnesandnoble.com/w/product-operations-melissa-perri/1144201706) - By Melissa Perri and Denise Tilles.
- [Intercom on Product Management](https://www.intercom.com/resources/books/intercom-product-management)
- [Building Products for the Enterprise](https://www.oreilly.com/library/view/building-products-for/9781492024774/) - By Blair Reeves and Benjamin Gaines.
- [The Product Book](https://productschool.com/resources/ebooks/the-product-book) - By Carlos Gonzalez de Villaumbrosia and Josh Anon.
- [Decode and Conquer](https://www.lewis-lin.com/decode-and-conquer) - By Lewis C. Lin.

### Product Strategy & Planning

Books focused on strategic thinking, roadmapping, prioritization, and long-term product planning.

- [Good Strategy, Bad Strategy](https://www.barnesandnoble.com/w/good-strategy-bad-strategy-richard-rumelt/1101087922?ean=9780307886231) - By Richard Rumelt.
- [The Lean Startup: How Today's Entrepreneurs Use Continuous Innovation to Create Radically Successful Businesses](https://www.barnesandnoble.com/w/the-lean-startup-eric-ries/1100642052) - By Eric Ries.
- [The Four Steps to the Epiphany](https://www.barnesandnoble.com/w/the-four-steps-to-the-epiphany-steve-blank/1116075934) - By Steve Blank.
- [The Startup Owner's Manual: The Step-By-Step Guide for Building a Great Company](https://www.barnesandnoble.com/w/the-startup-owners-manual-steve-blank/1116176524) - By Steve Blank and Bob Dorf.
- [Business Model Generation: A Handbook for Visionaries, Game Changers, and Challengers](https://www.barnesandnoble.com/w/business-model-generation-alexander-osterwalder/1020903233) - By Alexander Osterwalder and Yves Pigneur.
- [Value Proposition Design: How to Create Products and Services Customers Want (Strategyzer)](https://www.barnesandnoble.com/w/value-proposition-design-alexander-osterwalder/1124336924) - By Alexander Osterwalder and Yves Pigneur.
- [The Innovator's Dilemma: When New Technologies Cause Great Firms to Fail (Management of Innovation and Change)](https://www.barnesandnoble.com/w/the-innovators-dilemma-clayton-m-christensen/1100196911) - By Clayton M. Christensen.
- [Crossing The Chasm](https://www.barnesandnoble.com/w/crossing-the-chasm-3rd-edition-geoffrey-a-moore/1116092388?ean=9780062292988) - By Geoffrey A. Moore.
- [Measure What Matters: How Google, Bono, and the Gates Foundation Rock the World with OKRs](https://www.barnesandnoble.com/w/measure-what-matters-john-doerr/1127681175) - By John Doerr.
- [Positioning: The Battle for Your Mind](https://www.barnesandnoble.com/w/positioning-al-ries/1117107645) - By Al Ries and Jack Trout.

### Customer Research & User Experience

Understanding users, conducting research, and designing customer-centric products.

- [Continuous Discovery Habits: Discover Products that Create Customer Value and Business Value](https://www.barnesandnoble.com/w/continuous-discovery-habits-teresa-torres/1139454943) - By Teresa Torres.
- [The Mom Test: How to talk to customers & learn if your business is a good idea when everyone is lying to you](https://www.barnesandnoble.com/w/the-mom-test-rob-fitzpatrick/1138124916) - By Rob Fitzpatrick.
- [The Customer-Driven Playbook](https://www.oreilly.com/library/view/the-customer-driven-playbook/9781491981269/) - By Jessica Rich and Travis Lowdermilk.
- [Evidence-Guided: Creating High Impact Products in the Face of Uncertainty](https://www.barnesandnoble.com/w/evidence-guided-itamar-gilad/1144237485) - By Itamar Gilad.
- [The Design of Everyday Things: Revised and Expanded Edition](https://www.barnesandnoble.com/w/the-design-of-everyday-things-donald-a-norman/1114591337) - By Don Norman.
- [Observing the User Experience: A Practitioner's Guide to User Research](https://www.barnesandnoble.com/w/observing-the-user-experience-mike-kuniavsky/1110784914) - By Mike Kuniavsky.
- [Don't Make Me Think: A Common Sense Approach to Web Usability](https://www.barnesandnoble.com/w/dont-make-me-think-revisited-steve-krug/1116173905) - By Steve Krug.

### Product Development & Process

Methodologies, processes, and best practices for building and shipping products.

- [The Lean Product Playbook: How to Innovate with Minimum Viable Products and Rapid Customer Feedback](https://www.barnesandnoble.com/w/the-lean-product-playbook-dan-olsen/1124337316) - By Dan Olsen.
- [Sprint: How to Solve Big Problems and Test New Ideas in Just Five Days](https://www.barnesandnoble.com/w/sprint-jake-knapp/1123177843) - By Jake Knapp, John Zeratsky, Braden Kowitz.
- [Shape Up](https://basecamp.com/shapeup) - By Ryan Singer.
- [Hooked: How to Build Habit-Forming Products](https://www.barnesandnoble.com/w/hooked-nir-eyal/1119342753) - By Nir Eyal.
- [Build: An Unorthodox Guide to Making Things Worth Making](https://www.barnesandnoble.com/w/build-tony-fadell/1140408161) - By Tony Fadell.
- [The Mythical Man-Month: Essays on Software Engineering](https://www.barnesandnoble.com/w/the-mythical-man-month-frederick-brooks-jr/1126893908) - By Frederick P. Brooks Jr.
- [Thinking in Systems: A Primer](https://www.barnesandnoble.com/w/thinking-in-systems-donella-meadows/1138462657) - By Donella H. Meadows.

### Team Leadership & Management

Leading cross-functional teams, management skills, and organizational dynamics.

- [The Manager's Path](https://www.oreilly.com/library/view/the-managers-path/9781491973882/) - By Camille Fournier.
- [Radical Candor: Be a Kick-Ass Boss Without Losing Your Humanity](https://www.barnesandnoble.com/w/radical-candor-kim-malone-scott/1123749305) - By Kim Scott.
- [An Elegant Puzzle](https://lethain.com/elegant-puzzle/) - By Will Larson.
- [Staff Engineer](https://staffeng.com/book) - By Will Larson.
- [Difficult Conversations](https://www.stoneandheen.com/difficult-conversations) - By Douglas Stone.
- [Creativity, Inc.: Overcoming the Unseen Forces That Stand in the Way of True Inspiration](https://www.barnesandnoble.com/w/creativity-inc-ed-catmull/1115696843) - By Ed Catmull and Amy Wallace.

### Psychology & Behavioral Change

Understanding human behavior, decision-making, and driving organizational change.

- [Switch: How to Change Things When Change Is Hard](https://www.barnesandnoble.com/w/switch-chip-heath/1100203647) - By Chip Heath and Dan Heath.
- [Made to Stick: Why Some Ideas Survive and Others Die](https://www.barnesandnoble.com/w/made-to-stick-chip-heath/1102808718) - By Chip Heath and Dan Heath.
- [The Power of Habit: Why We Do What We Do in Life and Business](https://www.barnesandnoble.com/w/the-power-of-habit-charles-duhigg/1103588638) - By Charles Duhigg.
- [Influence: The Psychology of Persuasion](https://www.barnesandnoble.com/w/influence-new-and-expanded-robert-b-cialdini-phd/1137838452) - By Robert B. Cialdini.

### Engineering & Technical

Technical perspectives on product development and engineering practices.

- [Creative Selection](http://creativeselection.io/) - By Ken Kocienda.
- [The Art of Doing Science and Engineering: Learning to Learn](https://en.wikipedia.org/wiki/The_Art_of_Doing_Science_and_Engineering) - By Richard W. Hamming.
- [High Output Management](https://www.barnesandnoble.com/w/high-output-management-andrew-s-grove/1000970775) - By Andrew S. Grove.
- [7 Powers: The Foundations of Business Strategy](https://www.barnesandnoble.com/w/7-powers-hamilton-helmer/1125041039) - By Hamilton Helmer.

## Podcasts

| Podcast                                                                                | Hosts                         | URL                                                                       | Description |
|----------------------------------------------------------------------------------------|-------------------------------|---------------------------------------------------------------------------|-------------|
| <img alt="The Work Item" src="media/pod-the-work-item.png" width="100px" />            | Den Delimarsky                | https://theworkitem.com                                                   | Every week, Den Delimarsky sits down with folks from a range of industries, roles, and backgrounds to learn more about their career journey, lessons learned, and what it takes to map out your own very unique track. |
| <img alt="Masters of Scale" src="media/pod-masters-of-scale.jpg" width="100px" />      | Reid Hoffman                  | https://mastersofscale.com/                                               | How do companies grow from zero to a gazillion? Legendary Silicon Valley investor / entrepreneur Reid Hoffman tests his theories with famous founders. Guests include Facebook's Mark Zuckerberg & Sheryl Sandberg, Netflix's Reed Hastings, Google's Eric Schmidt, Spanx's Sara Blakely. With original music and hilariously honest stories, the show sounds like nothing you've ever heard. |
| <img alt="The Product Podcast" src="media/pod-product.jpg" width="100px" />            | Multiple                      | https://itunes.apple.com/us/podcast/the-product-podcast/id1219400787      | This is your Product Management podcast featuring PMs from Google, Facebook, LinkedIn, Spotify, Twitter and other tech companies/ startups. Tune in if you're a manager, designer, engineer, entrepreneur or marketer who wants to learn the latest best practices. |
| <img alt="StartUp" src="media/pod-startup.webp" width="100px" />                       | Multiple                      | https://podcasts.apple.com/us/podcast/startup-podcast/id913805339         | The business origin story you never get to hear. |
| <img alt="How I Built This" src="media/pod-how-i-built.jpg" width="100px" />           | Guy Raz                       | https://www.npr.org/podcasts/510313/how-i-built-this                      | Guy Raz dives into the stories behind some of the world's best known companies. How I Built This weaves a narrative journey about innovators, entrepreneurs and idealists—and the movements they built. |
| <img alt="The Pitch" src="media/pod-pitch.webp" width="100px" />                       | Multiple                      | https://www.thepitch.show/                                                | Where real entrepreneurs pitch to real investors—for real money. |
| <img alt="ReWork" src="media/pod-rework.png" width="100px" />                          | Multiple                      | https://rework.fm/                                                        | A podcast by Basecamp about the better way to work and run your business. We bring you stories and unconventional wisdom from Basecamp's co-founders and other business owners. |
| <img alt="Art Of Product" src="media/pod-art-of-product.jpg" width="100px" />          | Multiple                      | https://artofproductpodcast.com/                                          | Chronicling the journeys of two entrepreneurs building software companies. |
| <img alt="Lenny's Podcast" src="media/pod-lennys-podcast.webp" width="100px" />        | Lenny Rachitsky               | https://www.lennyspodcast.com/                                            | Lenny Rachitsky (author of #1 business newsletter on Substack, with 200k+ subscribers) interviews world-class product leaders and growth experts to uncover concrete, actionable, and tactical advice to help you build, launch, and grow your own product. |
| <img alt="Design Details" src="media/pod-design-details.jpg" width="100px" />          | Marshall Bock, Brian Lovin    | https://designdetails.fm                                                  | A weekly conversation about design process and culture. Hosted by Marshall Bock and Brian Lovin. |
| <img alt="Product Hunt Radio" src="media/pod-product-hunt-radio.webp" width="100px" /> | Ryan Hoover, Abadesi Osunsade | https://podcasts.apple.com/us/podcast/product-hunt-radio/id862714883      | Product Hunt Radio is a a weekly podcast with the people creating and exploring the future. Tune in every week with Ryan Hoover and Abadesi Osunsade as they're joined by founders, investors, journalists, and makers to discuss the latest in tech. |

## Communities

- [Women in Product](https://www.womenpm.org/) (_using [Facebook](https://facebook.com)_)
- [Product School](https://www.productschool.com/) (_using [Slack](https://slack.com/)_)
- [The Product Coalition](https://productcoalition.com/) (_using [Slack](https://slack.com/)_)
- [Product Collective](https://productcollective.com/) (_using [Slack](https://slack.com/)_)

## Conferences

- [Industry](https://industryconference.com/) - Over 3 days, attendees will learn from renowned product leaders and share the latest methods, tools, and frameworks that they use to build, launch and scale world-class software products. Building world-class software products is hard. At INDUSTRY you will see how others manage product in different environments, from fast-paced startups to complex large enterprises.
- [ProductCon](https://www.productschool.com/productcon/) - Organized by Product School, ProductCon takes place five times a year with events in San Francisco, Los Angeles, New York, Seattle and London. The speaker lineup features product leaders from Google, Slack, Amazon, Airbnb, Netflix, Facebook and more. You’ll learn best practices behind the most successful products, and new trends in AI, VR, IoT and Blockchain. You’ll also have the opportunity to interact with all our sponsor companies interested in recruiting PMs.
- [La Product Conf](https://www.laproductconf.com/) - Organized by Thiga, La Product Conf (LPC) takes place once a year with events in Paris (France) and Madrid (Spain). The speaker lineup features product leaders from Pinterest, Carrefour, Payfit, Google, Meetic and more.

## Additional resources

- [Stratechery by Ben Thompson](https://stratechery.com/) - Product and strategy insights from the industry.
- [Mobbin](https://mobbin.design/) - Hand-picked collection of mobile app design patterns.
- [Marketing for Engineers](https://github.com/goabstract/Marketing-for-Engineers) - A handy guide on growing marketing skills for folks with engineering backgrounds.

## License

Licensed under the [Creative Commons CC0 License](https://creativecommons.org/publicdomain/zero/1.0/).


