# Contribution Guidelines

Ensure your pull request adheres to the following guidelines:

- If you submit a project that is similar to an existing project in the list, argue how it's different or better.
- Suggested packages should be tested and documented.
- Make an individual pull request for each suggestion.
- Use the following format: `[package](link) - Description.`
- Additions should be ordered in the alphabetical order in the section.
- Link to the GitHub repo.
- Keep descriptions short and simple, but descriptive.
- Start the description with a capital and end with a full stop/period.
- Start the description with either a verb or a noun phrase.
- Don't add `-s` suffix if the description starts with a verb.
- Avoid `(for) Deno` in the description unless necessary. Stylize as `Deno` instead of `deno`.
- Check your spelling and grammar.
- Make sure your text editor is set to remove trailing whitespace.
- The pull request should have a useful title and include a link to the package and why it should be included.
- New categories or improvements to the existing categorization are welcome, but should be done in a separate pull request.
