# Awesome Digital Humanities [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="android-chrome-512x512.png" align="right" width="100">](https://github.com/dh-tech/awesome-digital-humanities/)

> Software for humanities scholars using quantitative or computational methods.

This is a curated list of tools, resources, and services supporting the Digital Humanities. [Contributions](CONTRIBUTING.md) are welcome!

## Contents

- [Bibliography and Sources Management](#bibliography-and-sources-management)
- [Corpus linguistics](#corpus-linguistics)
- [Data Collection](#data-collection)
- [Data Analysis](#data-analysis)
- [Data Extraction and Conversion](#data-extraction-and-conversion)
- [Data Annotation](#data-annotation)
- [DH Centers](#dh-centers)
- [Document Management and Processing](#document-management-and-processing)
- [Journals](#journals)
- [Organizations and Research Infrastructures](#organizations-and-research-infrastructures)
- [Other Resources](#other-resources)
- [Platforms](#platforms)
- [Publishing](#publishing)
- [Tool Building and Rapid Prototyping](#tool-building-and-rapid-prototyping)
- [Twitter](#twitter)
- [User Guides and Training Materials](#user-guides-and-training-materials)
- [Visualization](#visualization)

## Bibliography and Sources Management

- [JabRef](https://www.jabref.org/) - Open source bibliography reference manager.
- [Tropy](https://tropy.org/) - Research Photo Management.
- [Zotero](https://www.zotero.org/) - Free, easy-to-use tool to help you collect, organize, cite, and share research.

## Corpus linguistics

- [AntConc](https://www.laurenceanthony.net/software/antconc/) - A freeware corpus analysis toolkit for concordancing and text analysis.
- [CorpusExplorer v2.0](http://www.CorpusExplorer.de) - Software for corpus linguists and text/data mining enthusiasts. The CorpusExplorer combines over 45 interactive visualizations under an user-friendly interface. Routine tasks such as text acquisition, cleaning or tagging are completely automated. The simple interface supports the use in university teaching and leads the users/students to fast and substantial results. The CorpusExplorer is open for many standards (XML, CSV, JSON, R, etc.) and also offers its own software development kit (SDK), which allows you to integrate all functions into your own programs.
- [TXM](https://txm.gitpages.huma-num.fr/textometrie/en/) - The project brings together open-source Textometry software developments to set up a modular platform called TXM, in synergy with existing corpus technologies (Unicode, XML, TEI, NLP tools, CQP, R).

## Data Collection

- [Data Commons](https://datacommons.org/) - Data Commons aggregates data from a [wide range of sources](https://docs.datacommons.org/datasets/) into a unified database to make it more accessible and useful.
- [OpenArchive](https://open-archive.org/) - Making it easy to store, share, and amplify your mobile media while protecting your identity.
- [Open EU Data Portal](https://data.europa.eu/euodp/en/data/) - European Union open data.
- [Social Feed Manager](https://gwu-libraries.github.io/sfm-ui/) - Open source software that harvests social media data and web resources from Twitter, Tumblr, Flickr, and Sina Weibo.
- [Trafilatura](https://trafilatura.readthedocs.io/) - Open source software to gather text and metadata on the Web: Crawling, scraping, extraction, output in multiple formats. Usable with Python, R and on the command-line.
- [Transkribus](https://transkribus.eu/) - Transcribe. Collaborate. Share and benefit from cutting edge research in Handwritten Text Recognition!
- [Textgrid](https://textgrid.de/) - Open source tools and services support humanistic scholars during the entire process of research, especially in digital scholarly editing.
- [webrecorder.io](https://webrecorder.io/) - Web archiving service anyone can use for free to save web pages.

## Data Analysis

- [Allmaps](https://allmaps.org/) - Curating, georeferencing and exploring for IIIF maps.
- [Breve](http://hdlab.stanford.edu/breve/) - Visualize and edit tabular data.
- [Data Pen](http://hdlab.stanford.edu/data-pen/) - Framework for humanities researchers to access, explore, and manipulate multidimensional historical data.
- [DocFetcher](http://docfetcher.sourceforge.net/) - Open Source desktop search application.
- [Leipzig Corpus Miner (LCM)](https://ilcm.informatik.uni-leipzig.de/) - The LCM project pursues the development of an integrated research environment for the analysis of structured and unstructured data in a 'Software as a Service' architecture (SaaS). The research environment addresses requirements for the quantitative evaluation of large amounts of text data (e.g. 3 million news articles) using text mining methods and requirements for the reproducibility of data-driven research designs in the social sciences and the digital humanities.
- [Lexos](http://lexos.wheatoncollege.edu) - Online tool for text analysis.
- [Mallet](https://mimno.github.io/Mallet/) - Java-based package for statistical natural language processing, document classification, clustering, topic modeling, information extraction, and other machine learning applications to text.
- [Open Semantic Search](https://www.opensemanticsearch.org/) - Free Software for your own Search Engine, Explorer for Discovery of large document collections, Media Monitoring, Text Analytics, Document Analysis & Text Mining platform based on Apache Solr or Elasticsearch open-source enterprise-search and Open Standards for Linked Data, Semantic Web & Linked Open Data integration.
- [Stylo](https://github.com/computationalstylistics/stylo) - R package for stylometric analyses.
- [TinEye](https://tineye.com/) - Search by image or image section and find where that image appears online.
- [Voyant](https://voyant-tools.org/) - Reading and analysis environment for digital texts.
- [YouTube Metadata](https://mattw.io/youtube-metadata/) - It grabs singular details about a video and its uploader, playlist and its creator, or channel.

## Data Extraction and Conversion

- [ImageMagick](https://imagemagick.org/) - Image conversion tool.
- [MuPDF](https://mupdf.com/) - PDF viewer and converter.
- [OCRmyPDF](https://github.com/jbarlow83/OCRmyPDF) - OCR toolkit.
- [Poppler](https://poppler.freedesktop.org/) - PDF toolkit.
- [QPDF](http://qpdf.sourceforge.net/) - PDF toolkit.

## Data Annotation

- [Annotation Studio](https://www.annotationstudio.org/) - Suite of tools for collaborative web-based annotation, developed by MIT's HyperStudio. 
- [CATMA](https://catma.de/) - Computer Assisted Text Markup and Analysis.
- [Glycerine](https://glycerine.io/) - Provides a suite of IIIF image annotation tools and end-to-end workflows for researchers, curators and students to collaborate on projects across repositories and publish research ouputs.
- [Recogito](https://recogito.pelagios.org/) - Semantic Annotation for images and texts.

## DH Centers

- [ACDH-DH](https://www.oeaw.ac.at/acdh/) - Austrian Centre for Digital Humanities.
- [DHCenter UNIL-EPFL](https://dhcenter-unil-epfl.com/) - Founded in 2018, the dhCenter UNIL-EPFL is an interdisciplinary research platform.
- [Digital Humanities Bern](https://www.dh.unibe.ch/) - It explores different topics, in the context of digital text and image analysis, digital edition, and reflection on the impact of digital methods on the humanities.
- [Digital Humanities Lab - Universität Basel](https://dhlab.philhist.unibas.ch/en/) - The Digital Humanities is an interdisciplinary institution of the University of Basel.
- [HDLab](http://hdlab.stanford.edu/) - Humanities + Design a Research Lab at Stanford University.
- [Humanités numériques Unversity of Geneva](https://www.unige.ch/lettres/humanites-numeriques/) - The aim of the Chair is to teach the use of digital technology to all human sciences, according to the methods and issues specific to the Humanities.
- [Ladhul dhCenter](http://www.dhlausanne.ch/) - Laboratoire de cultures et humanités digitales de l'Université de Lausanne.
- [Luxembourg Centre for Contemporary and Digital History](https://www.c2dh.uni.lu/) - Research on new digital methods and tools for historical research and teaching.
- [Roy Rosenzweig Center for History and New Media](https://rrchnm.org/) - Creators of Zotero and other amazing open-source software tools for historians.

## Document Management and Processing

- [Giles Ecosystem](https://diging.atlassian.net/wiki/spaces/GECO/overview) - The Giles Ecosystem is a distributed system based on Apache Kafka that allows users to upload documents for text and image extraction. It automatically performs OCR on uploaded images and extracts images and embedded texts from pdf files. The Giles Ecosystem can be easily scaled to accommodate higher workloads.

## Journals

- [Current Research in Digital History](http://crdh.rrchnm.org/) - Annual open-access, peer-reviewed publication of the Roy Rosenzweig Center for History and New Media at George Mason University.

## Organizations and Research Infrastructures

- [ACH](http://ach.org/) - Association for Computers and the Humanities (ACH) is a major professional society for the digital humanities. We support and disseminate research and cultivate a vibrant professional community through conferences, publications, and outreach activities.
- [ADHO](http://adho.org/) - The Alliance of Digital Humanities Organizations (ADHO) promotes and supports digital research and teaching across all arts and humanities disciplines, acting as a community-based advisory force, and supporting excellence in research, publication, collaboration and training.
- [CHAIN](https://mith.umd.edu/chain/) - Coalition of Humanities and Arts Infrastructures and Networks.
- [CHCI](https://chcinetwork.org/) - Consortium of Humanities Centers and Institutes. Currently it has a membership of more than 250 organizations in the Americas, Europe, Africa, Asia, and Pacific Rim. Our members include humanities centers at small, medium, and large colleges and universities, community colleges, independent scholarly societies, research libraries, and other institutes of advanced study.
- [centerNet](http://dhcenternet.org/) - An international network of digital humanities centers.
- [CLARIN](https://www.clarin.eu/) - CLARIN stands for "Common Language Resources and Technology Infrastructure". It is a research infrastructure that was initiated from the vision that all digital language resources and tools from all over Europe and beyond are accessible through a single sign-on online environment for the support of researchers in the humanities and social sciences.
- [DARIAH](https://www.dariah.eu/) - The Digital Research Infrastructure for the Arts and Humanities (DARIAH) aims to enhance and support digitally-enabled research and teaching across the arts and humanities. DARIAH is a network of people, expertise, information, knowledge, content, methods, tools and technologies from its member countries. It develops, maintains and operates an infrastructure in support of ICT-based research practices and sustains researchers in using them to build, analyse and interpret digital resources.
- [DHCH](https://dh-ch.ch/) - Interdisciplinary research in the digital humanities in Switzerland.
- [Digital History Network Switzerland](https://www.digitalhistorynetwork.ch/) - Network of digital historians in academia and GLAM institutions in Switzerland with a fairly active mailing list.
- [Digital Humanities Now](http://digitalhumanitiesnow.org/) - Digital Humanities Now is an experimental, edited publication that highlights and distributes informally published digital humanities scholarship and resources from the open web.
- [European Holocaust Research Infrastructure (EHRI)](https://www.ehri-project.eu/) - The EHRI Portal enables online access to information about Holocaust sources, no matter where they are located. It also promotes innovative tools that advance the digital transformation of Holocaust research.
- [European Research Infrastructure for Heritage Science (E-RIHS)](http://www.e-rihs.eu/) - It supports research on heritage interpretation, preservation, documentation and management.
- [GO::DH](http://www.globaloutlookdh.org/) - The purpose of Global Outlook::Digital Humanities (GO::DH) is to help break down barriers that hinder communication and collaboration among researchers and students of the Digital Arts, Humanities, and Cultural Heritage sectors in high, mid, and low income economies.

## Other Resources

- [Awesome Digital History](https://github.com/maehr/awesome-digital-history) - A curated list of awesome things related to digital history.
- [Awesome IIIF](https://github.com/IIIF/awesome-iiif) - A curated list of awesome resources related to the International Image Interoperability Framework (IIIF).
- [Awesome OCR](https://github.com/kba/awesome-ocr) - This list contains links to great software tools and libraries and literature related to Optical Character Recognition (OCR).
- [Awesome Scientific Writing](https://github.com/writing-resources/awesome-scientific-writing) - A curated list of awesome tools, demos and resources to go beyond LaTeX.
- [Awesome Web Archiving](https://github.com/iipc/awesome-web-archiving) - Resources to archive the web.
- [Carolina Digital Humanities Initiative Tools Page](http://digitalhumanities.unc.edu/resources/tools/) - It provides a range of platforms, plug-ins, readings, and other items that might be of use for DH researchers.
- [DH Toychest](http://dhresourcesforprojectbuilding.pbworks.com/w/page/69244319/Digital%20Humanities%20Tools) - Guides, tools, and other resources for practical work in the digital humanities by researchers, teachers, and students. Curated by [Alan Liu](http://liu.english.ucsb.edu/), University of California, Santa Barbara.
- [Digital Textuality Resource Pages](http://digitaltextuality.pbworks.com/w/page/68178062/Digital%20Textuality%20Resource%20Pages) - Inspired by Alan Liu's ToyChest, Kimberly Knight and her students at U. Texas (Dallas) keep in this repository a list of tools for text production, visualization, still image work, sound work, and video and animation; includes some student reviews of tools.
- [Duke University's DH Tools catalog](https://digitalhumanities.duke.edu/tools) - This list includes tools that Duke supports and tools that have been used by Duke digital projects. Some of the tools are made specifically for DH and others that can be re-purposed quite effectively for Humanities research.
- [FID Romanistik](https://www.fid-romanistik.de/forschungsdaten/suche-nach-forschungsdaten/fid-internetressourcen/tools/) - Curated list of tools and resources for digital humanists in German.
- [GLAMS Workbench](https://glam-workbench.net/) - A collection of tools, tutorials, examples, and hacks to help you work with data from galleries, libraries, archives, and museums (the GLAM sector). The primary focus is Australia and New Zealand, but new collections are being added all the time.
- [Social Sciences & Humanities Open Marketplace](https://marketplace.sshopencloud.eu/) - A discovery portal which pools and contextualises resources for Social Sciences and Humanities research communities: tools, services, training materials, datasets, publications and workflows.
- [TAPoR 3](http://tapor.ca/home) - TAPoR is a gateway to the tools used in sophisticated text analysis and retrieval. It was redesigned in order to integrate the DiRT (Digital Research Tools) directory.
- [Taxonomy of Digital Research Activities in the Humanities (TaDiRAH)](https://tadirah.info/) - This taxonomy has been developed for use by community-driven sites and projects that aim to structure information relevant to digital humanities and make it more easily discoverable. The taxonomy is expected to be particularly useful to endeavors aiming to collect information on digital humanities tools, methods, projects, or readings.

## Platforms

- [DHSlack](https://github.com/amandavisconti/DHslack/blob/master/CodeOfConduct.md) - Slack channels for digital humanities scholars.
- [HSS Digital](https://hssonline.org/page/digitalprojects) - Digital scholarship in the history of science initiative.
- [Perspectives on History](https://www.historians.org/community-careers/digital-history-resources/) - The newsmagazine of the American Historical Association.
- [wethink.hypotheses.org](https://wethink.hypotheses.org/) - Collaborative Digital History.
- [Wikipedia](https://en.wikipedia.org/wiki/Digital_history) - Digital history is the use of digital media to further historical analysis, presentation, and research.

## Publishing

- [CollectionBuilder](https://collectionbuilder.github.io/) - Open source tool for creating digital collection and exhibition websites based on metadata and powered by modern static web technology.
- [Manifold](https://manifoldapp.org/) - Scholarly publishing and collaborative and social reading platform.
- [Omeka](https://omeka.org/) - Open-source web publishing platform for sharing digital collections and creating media-rich online exhibits.
- [Wax](https://minicomp.github.io/wax/) - Jekyll based framework for minimal exhibitions with IIIF.

## Tool Building and Rapid Prototyping

- [JupyterHub Workspace](https://github.com/maltevogl/jupyterworkspace) - The JupyterHub Workspace aims to be a collaborative programming and code-sharing platform. It provides access to browser-based Jupyter Notebooks, which integrate code with explanatory text, and are already used as a new publishing form. Data can be shared using the Nextcloud backend. A single sign-on mechanism simplifies access. By sharing useful code snippets among users, a growing examples collection further lowers the entrance barrier to programming for new DH members.

## Twitter

- [Digital History by @moritzmaehr](https://twitter.com/moritzmaehr/lists/digital-history) - List of Digital History people by Moritz Mährg.
- [Digital Humanities by @GrandjeanMartin](https://twitter.com/GrandjeanMartin/lists/digital-humanities) - List of Digital Humanities people by Martin Grandjean.
- [Digital Humanities by @normanlippert](https://twitter.com/normanlippert/lists/digital-humanities) - List of Digital Humanities people by Norman Lippert.
- [Digital Humanities by @wpippich](https://twitter.com/i/lists/907641704949436416) - List of Digital Humanities people by Waltraud von Pippich.
- [Digital Humanities Women by @amandafrench](https://twitter.com/i/lists/81258446) - List of Digital Humanities women by Amanda French.

## User Guides and Training Materials

- [#dariahTeach](https://teach.dariah.eu/) - An open-source, multilingual, community-driven platform for high-quality teaching and training materials for the digital arts and humanities.
- [DARIAH-CAMPUS](https://campus.dariah.eu/) - A discovery framework and hosting platform for DARIAH learning resources.
- [DH Tools for Beginners](https://medium.com/dh-tools-for-beginners) - A collection of tutorials about DH tools aiming at digital humanities researchers.
- [Digital Editions Course](https://www.prisms.digital/training/) - The course covers the the whole process of creating a digital edition, from selecting a text right through to publication.
- [Digital Humanities Literacy Guidebook](https://cmu-lib.github.io/dhlg/topics/) - Overview on the field of Digital History and Digital Humanities.
- [Digital Humanities Theories and Practice](https://ltagliaferri.github.io/dh-rutgers-2022/) - Balancing practical guidance on tools and methodologies with modes for entering into the research of participants, the course will foster experimentation with and critical exploration of digital scholarship coupled with humanistic inquiry.
- [forText](https://fortext.net) - Collection of german tutorials for the interpretation and visualization of literature.
- [Framework for Information Literacy for Higher Education](http://www.ala.org/acrl/standards/ilframework) - How to teach digital literacy.
- [Humanities Data Analysis](https://www.humanitiesdataanalysis.org/) - A practical guide to data-intensive humanities research using the Python programming language.
- [Intro Cultural Analytics](https://melaniewalsh.github.io/Intro-Cultural-Analytics/welcome.html) - Analyze cultural artifacts with Python.
- [Introduction to Digital Humanities (DH101)](https://asandersgarcia.humspace.ucla.edu/courses/dh101f18/) - Collection of resources/online coursebook based on the *Introduction to Digital Humanities (DH101)* course at [UCLA](http://www.ucla.edu/).
- [Jupyter Notebooks for Digital Humanities](https://github.com/quinnanya/dh-jupyter/blob/master/README.md) - A diverse range of Jupyter notebooks, comprising research materials, course content, Python tutorials, and specific analysis tools.
- [Missing Semester](https://missing.csail.mit.edu/) - Useful tools that are not taught in class.
- [New Languages for NLP](https://new-languages-for-nlp.github.io/course-materials/intro.html) - Learn how to annotate linguistic data and train statistical language models using cutting-edge natural language processing (NLP) tools.
- [PARTHENOS Training](https://training.parthenos-project.eu/) -  The PARTHENOS cluster of humanities research infrastructure projects has devised a series of training modules and resources for those who want to learn more about research infrastructures in the Digital Humanities. Contains material about research infrastructures, research data, existing digital collections of use to researchers, guides to ontologies and a catalogue of webinars and training material.
- [The Programming Historian](https://programminghistorian.org/) - Novice-friendly, peer-reviewed tutorials that help humanists learn a wide range of digital tools, techniques, and workflows to facilitate research and teaching.

## Visualization

- [Bertin.js](https://github.com/neocarto/bertin) - JavaScript library for visualizing geospatial data and make thematic maps for the web.
- [DARIAH-DE Geo-Browser](https://geobrowser.de.dariah.eu/) - Create visualizations with geotagges data.
- [Gephi](https://gephi.org/) - Gephi is the leading visualization and exploration software for all kinds of graphs and networks.
- [Khartis](https://www.sciencespo.fr/cartographie/khartis/en/) - A tool for easy creation of thematic maps in 3 steps from CSV data.
- [Palladio](https://hdlab.stanford.edu/palladio/) - Visualize complex historical data with ease.
- [RAWGraphs](https://rawgraphs.io/) - Open source, web-based tool for the visualization of complex data.
- [StorylineJS](http://storyline.knightlab.com/) - Tell the story behind the numbers.
- [StorymapJS](https://storymap.knightlab.com/) - Maps that tell stories.
- [TimelineJS](https://timeline.knightlab.com/) - Easy-to-make, beautiful timelines.
- [Vistorian.online](https://vistorian.github.io/) - Interactive Visualizations for Dynamic and Multivariate Networks.
