% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgb.train.R
\name{xgb.params}
\alias{xgb.params}
\title{XGBoost Parameters}
\usage{
xgb.params(
  objective = NULL,
  verbosity = NULL,
  nthread = NULL,
  seed = NULL,
  booster = NULL,
  eta = NULL,
  learning_rate = NULL,
  gamma = NULL,
  min_split_loss = NULL,
  max_depth = NULL,
  min_child_weight = NULL,
  max_delta_step = NULL,
  subsample = NULL,
  sampling_method = NULL,
  colsample_bytree = NULL,
  colsample_bylevel = NULL,
  colsample_bynode = NULL,
  lambda = NULL,
  reg_lambda = NULL,
  alpha = NULL,
  reg_alpha = NULL,
  tree_method = NULL,
  scale_pos_weight = NULL,
  updater = NULL,
  refresh_leaf = NULL,
  grow_policy = NULL,
  max_leaves = NULL,
  max_bin = NULL,
  num_parallel_tree = NULL,
  monotone_constraints = NULL,
  interaction_constraints = NULL,
  multi_strategy = NULL,
  base_score = NULL,
  eval_metric = NULL,
  seed_per_iteration = NULL,
  device = NULL,
  disable_default_eval_metric = NULL,
  use_rmm = NULL,
  max_cached_hist_node = NULL,
  max_cat_to_onehot = NULL,
  max_cat_threshold = NULL,
  sample_type = NULL,
  normalize_type = NULL,
  rate_drop = NULL,
  one_drop = NULL,
  skip_drop = NULL,
  feature_selector = NULL,
  top_k = NULL,
  num_class = NULL,
  tweedie_variance_power = NULL,
  huber_slope = NULL,
  quantile_alpha = NULL,
  aft_loss_distribution = NULL,
  lambdarank_pair_method = NULL,
  lambdarank_num_pair_per_sample = NULL,
  lambdarank_normalization = NULL,
  lambdarank_score_normalization = NULL,
  lambdarank_unbiased = NULL,
  lambdarank_bias_norm = NULL,
  ndcg_exp_gain = NULL
)
}
\arguments{
\item{objective}{(default=\code{"reg:squarederror"})
Specify the learning task and the corresponding learning objective or a custom objective function to be used.

For custom objective, see \href{https://xgboost.readthedocs.io/en/latest/tutorials/custom_metric_obj.html}{Custom Objective and Evaluation Metric}
and \href{https://xgboost.readthedocs.io/en/latest/tutorials/saving_model.html#custom-obj-metric}{Custom objective and metric} for more information,
along with the end note for function signatures.

Supported values are:
\itemize{
\item \code{"reg:squarederror"}: regression with squared loss.
\item \code{"reg:squaredlogerror"}: regression with squared log loss \eqn{\frac{1}{2}[log(pred + 1) - log(label + 1)]^2}.  All input labels are required to be greater than -1.  Also, see metric \code{rmsle} for possible issue  with this objective.
\item \code{"reg:logistic"}: logistic regression, output probability
\item \code{"reg:pseudohubererror"}: regression with Pseudo Huber loss, a twice differentiable alternative to absolute loss.
\item \code{"reg:absoluteerror"}: Regression with L1 error. When tree model is used, leaf value is refreshed after tree construction. If used in distributed training, the leaf value is calculated as the mean value from all workers, which is not guaranteed to be optimal.

Version added: 1.7.0
\item \code{"reg:quantileerror"}: Quantile loss, also known as "pinball loss". See later sections for its parameter and \href{https://xgboost.readthedocs.io/en/latest/python/examples/quantile_regression.html#sphx-glr-python-examples-quantile-regression-py}{Quantile Regression} for a worked example.

Version added: 2.0.0
\item \code{"binary:logistic"}: logistic regression for binary classification, output probability
\item \code{"binary:logitraw"}: logistic regression for binary classification, output score before logistic transformation
\item \code{"binary:hinge"}: hinge loss for binary classification. This makes predictions of 0 or 1, rather than producing probabilities.
\item \code{"count:poisson"}: Poisson regression for count data, output mean of Poisson distribution.
\code{"max_delta_step"} is set to 0.7 by default in Poisson regression (used to safeguard optimization)
\item \code{"survival:cox"}: Cox regression for right censored survival time data (negative values are considered right censored).

Note that predictions are returned on the hazard ratio scale (i.e., as HR = exp(marginal_prediction) in the proportional hazard function \code{h(t) = h0(t) * HR}).
\item \code{"survival:aft"}: Accelerated failure time model for censored survival time data.
See \href{https://xgboost.readthedocs.io/en/latest/tutorials/aft_survival_analysis.html}{Survival Analysis with Accelerated Failure Time} for details.
\item \code{"multi:softmax"}: set XGBoost to do multiclass classification using the softmax objective, you also need to set num_class(number of classes)
\item \code{"multi:softprob"}: same as softmax, but output a vector of \code{ndata * nclass}, which can be further reshaped to \code{ndata * nclass} matrix. The result contains predicted probability of each data point belonging to each class.
\item \code{"rank:ndcg"}: Use LambdaMART to perform pair-wise ranking where the normalized discounted cumulative gain (NDCG) is maximized. This objective supports position debiasing for click data.
\item \code{"rank:map"}: Use LambdaMART to perform pair-wise ranking where the mean average precision (MAP) is maximized
\item \code{"rank:pairwise"}: Use LambdaRank to perform pair-wise ranking using the \code{ranknet} objective.
\item \code{"reg:gamma"}: gamma regression with log-link. Output is a mean of gamma distribution. It might be useful, e.g., for modeling insurance claims severity, or for any outcome that might be gamma-distributed.
\item \code{"reg:tweedie"}: Tweedie regression with log-link. It might be useful, e.g., for modeling total loss in insurance, or for any outcome that might be tweedie-distributed.
}}

\item{verbosity}{(default=1)
Verbosity of printing messages. Valid values are 0 (silent), 1 (warning), 2 (info), 3
(debug). Sometimes XGBoost tries to change configurations based on heuristics, which
is displayed as warning message. If there's unexpected behaviour, please try to
increase value of verbosity.}

\item{nthread}{(default to maximum number of threads available if not set)
Number of parallel threads used to run XGBoost. When choosing it, please keep thread
contention and hyperthreading in mind.}

\item{seed}{Random number seed. If not specified, will take a random seed through R's own RNG engine.}

\item{booster}{(default= \code{"gbtree"})
Which booster to use. Can be \code{"gbtree"}, \code{"gblinear"} or \code{"dart"}; \code{"gbtree"} and \code{"dart"} use tree based models while \code{"gblinear"} uses linear functions.}

\item{eta, learning_rate}{(two aliases for the same parameter)
Step size shrinkage used in update to prevent overfitting. After each boosting step, we can directly get the weights of new features, and \code{eta} shrinks the feature weights to make the boosting process more conservative.
\itemize{
\item range: \eqn{[0,1]}
\item default value: 0.3 for tree-based boosters, 0.5 for linear booster.
}

Note: should only pass one of \code{eta} or \code{learning_rate}. Both refer to the same parameter and there's thus no difference between one or the other.}

\item{gamma, min_split_loss}{(two aliases for the same parameter) (for Tree Booster) (default=0, alias: \code{gamma})
Minimum loss reduction required to make a further partition on a leaf node of the tree. The larger \code{min_split_loss} is, the more conservative the algorithm will be. Note that a tree where no splits were made might still contain a single terminal node with a non-zero score.

range: \eqn{[0, \infty)}

Note: should only pass one of \code{gamma} or \code{min_split_loss}. Both refer to the same parameter and there's thus no difference between one or the other.}

\item{max_depth}{(for Tree Booster) (default=6, type=int32)
Maximum depth of a tree. Increasing this value will make the model more complex and more likely to overfit. 0 indicates no limit on depth. Beware that XGBoost aggressively consumes memory when training a deep tree. \code{"exact"} tree method requires non-zero value.

range: \eqn{[0, \infty)}}

\item{min_child_weight}{(for Tree Booster) (default=1)
Minimum sum of instance weight (hessian) needed in a child. If the tree partition step results in a leaf node with the sum of instance weight less than \code{min_child_weight}, then the building process will give up further partitioning. In linear regression task, this simply corresponds to minimum number of instances needed to be in each node. The larger \code{min_child_weight} is, the more conservative the algorithm will be.

range: \eqn{[0, \infty)}}

\item{max_delta_step}{(for Tree Booster) (default=0)
Maximum delta step we allow each leaf output to be. If the value is set to 0, it means there is no constraint. If it is set to a positive value, it can help making the update step more conservative. Usually this parameter is not needed, but it might help in logistic regression when class is extremely imbalanced. Set it to value of 1-10 might help control the update.

range: \eqn{[0, \infty)}}

\item{subsample}{(for Tree Booster) (default=1)
Subsample ratio of the training instances. Setting it to 0.5 means that XGBoost would randomly sample half of the training data prior to growing trees. and this will prevent overfitting. Subsampling will occur once in every boosting iteration.

range: \eqn{(0,1]}}

\item{sampling_method}{(for Tree Booster) (default= \code{"uniform"})
The method to use to sample the training instances.
\itemize{
\item \code{"uniform"}: each training instance has an equal probability of being selected. Typically set
\code{"subsample"} >= 0.5 for good results.
\item \code{"gradient_based"}: the selection probability for each training instance is proportional to the
\bold{regularized absolute value} of gradients (more specifically, \eqn{\sqrt{g^2+\lambda h^2}}).
\code{"subsample"} may be set to as low as 0.1 without loss of model accuracy. Note that this
sampling method is only supported when \code{"tree_method"} is set to \code{"hist"} and the device is \code{"cuda"}; other tree
methods only support \code{"uniform"} sampling.
}}

\item{colsample_bytree, colsample_bylevel, colsample_bynode}{(for Tree Booster) (default=1)
This is a family of parameters for subsampling of columns.
\itemize{
\item All \code{"colsample_by*"} parameters have a range of \eqn{(0, 1]}, the default value of 1, and specify the fraction of columns to be subsampled.
\item \code{"colsample_bytree"} is the subsample ratio of columns when constructing each tree. Subsampling occurs once for every tree constructed.
\item \code{"colsample_bylevel"} is the subsample ratio of columns for each level. Subsampling occurs once for every new depth level reached in a tree. Columns are subsampled from the set of columns chosen for the current tree.
\item \code{"colsample_bynode"} is the subsample ratio of columns for each node (split). Subsampling occurs once every time a new split is evaluated. Columns are subsampled from the set of columns chosen for the current level. This is not supported by the exact tree method.
\item \code{"colsample_by*"} parameters work cumulatively. For instance,
the combination \verb{\{'colsample_bytree'=0.5, 'colsample_bylevel'=0.5, 'colsample_bynode'=0.5\}} with 64 features will leave 8 features to choose from at
each split.
}

One can set the \code{"feature_weights"} for DMatrix to
define the probability of each feature being selected when using column sampling.}

\item{lambda, reg_lambda}{(two aliases for the same parameter)
\itemize{
\item For tree-based boosters:
\itemize{
\item L2 regularization term on weights. Increasing this value will make model more conservative.
\item default: 1
\item range: \eqn{[0, \infty]}
}
\item For linear booster:
\itemize{
\item L2 regularization term on weights. Increasing this value will make model more conservative. Normalised to number of training examples.
\item default: 0
\item range: \eqn{[0, \infty)}
}
}

Note: should only pass one of \code{lambda} or \code{reg_lambda}. Both refer to the same parameter and there's thus no difference between one or the other.}

\item{alpha, reg_alpha}{(two aliases for the same parameter)
\itemize{
\item L1 regularization term on weights. Increasing this value will make model more conservative.
\item For the linear booster, it's normalised to number of training examples.
\item default: 0
\item range: \eqn{[0, \infty)}
}

Note: should only pass one of \code{alpha} or \code{reg_alpha}. Both refer to the same parameter and there's thus no difference between one or the other.}

\item{tree_method}{(for Tree Booster) (default= \code{"auto"})
The tree construction algorithm used in XGBoost. See description in the \href{https://arxiv.org/abs/1603.02754}{reference paper} and \href{https://xgboost.readthedocs.io/en/latest/treemethod.html}{Tree Methods}.

Choices: \code{"auto"}, \code{"exact"}, \code{"approx"}, \code{"hist"}, this is a combination of commonly
used updaters.  For other updaters like \code{"refresh"}, set the parameter \code{updater}
directly.
\itemize{
\item \code{"auto"}: Same as the \code{"hist"} tree method.
\item \code{"exact"}: Exact greedy algorithm.  Enumerates all split candidates.
\item \code{"approx"}: Approximate greedy algorithm using quantile sketch and gradient histogram.
\item \code{"hist"}: Faster histogram optimized approximate greedy algorithm.
}}

\item{scale_pos_weight}{(for Tree Booster) (default=1)
Control the balance of positive and negative weights, useful for unbalanced classes. A typical value to consider: \verb{sum(negative instances) / sum(positive instances)}. See \href{https://xgboost.readthedocs.io/en/latest/tutorials/param_tuning.html}{Parameters Tuning} for more discussion. Also, see Higgs Kaggle competition demo for examples: \href{https://github.com/dmlc/xgboost/blob/master/demo/kaggle-higgs/higgs-train.R}{R}, \href{https://github.com/dmlc/xgboost/blob/master/demo/kaggle-higgs/higgs-numpy.py}{py1}, \href{https://github.com/dmlc/xgboost/blob/master/demo/kaggle-higgs/higgs-cv.py}{py2}, \href{https://github.com/dmlc/xgboost/blob/master/demo/guide-python/cross_validation.py}{py3}.}

\item{updater}{Has different meanings depending on the type of booster.
\itemize{
\item For tree-based boosters:
A comma separated string defining the sequence of tree updaters to run, providing a modular way to construct and to modify the trees. This is an advanced parameter that is usually set automatically, depending on some other parameters. However, it could be also set explicitly by a user. The following updaters exist:
\itemize{
\item \code{"grow_colmaker"}: non-distributed column-based construction of trees.
\item \code{"grow_histmaker"}: distributed tree construction with row-based data splitting based on global proposal of histogram counting.
\item \code{"grow_quantile_histmaker"}: Grow tree using quantized histogram.
\item \code{"grow_gpu_hist"}:  Enabled when \code{tree_method} is set to \code{"hist"} along with \code{device="cuda"}.
\item \code{"grow_gpu_approx"}: Enabled when \code{tree_method} is set to \code{"approx"} along with \code{device="cuda"}.
\item \code{"sync"}: synchronizes trees in all distributed nodes.
\item \code{"refresh"}: refreshes tree's statistics and/or leaf values based on the current data. Note that no random subsampling of data rows is performed.
\item \code{"prune"}: prunes the splits where loss < \code{min_split_loss} (or \code{gamma}) and nodes that have depth greater than \code{max_depth}.
}
\item For \code{booster="gblinear"}:
(default= \code{"shotgun"}) Choice of algorithm to fit linear model
\itemize{
\item \code{"shotgun"}: Parallel coordinate descent algorithm based on shotgun algorithm. Uses 'hogwild' parallelism and therefore produces a nondeterministic solution on each run.
\item \code{"coord_descent"}: Ordinary coordinate descent algorithm. Also multithreaded but still produces a deterministic solution. When the \code{device} parameter is set to \code{"cuda"} or \code{"gpu"}, a GPU variant would be used.
}
}}

\item{refresh_leaf}{(for Tree Booster) (default=1)
This is a parameter of the \code{"refresh"} updater. When this flag is 1, tree leafs as well as tree nodes' stats are updated. When it is 0, only node stats are updated.}

\item{grow_policy}{(for Tree Booster) (default= \code{"depthwise"})
\itemize{
\item Controls a way new nodes are added to the tree.
\item Currently supported only if \code{tree_method} is set to \code{"hist"} or \code{"approx"}.
\item Choices: \code{"depthwise"}, \code{"lossguide"}
\itemize{
\item \code{"depthwise"}: split at nodes closest to the root.
\item \code{"lossguide"}: split at nodes with highest loss change.
}
}}

\item{max_leaves}{(for Tree Booster) (default=0, type=int32)
Maximum number of nodes to be added.  Not used by \code{"exact"} tree method.}

\item{max_bin}{(for Tree Booster) (default=256, type=int32)
\itemize{
\item Only used if \code{tree_method} is set to \code{"hist"} or \code{"approx"}.
\item Maximum number of discrete bins to bucket continuous features.
\item Increasing this number improves the optimality of splits at the cost of higher computation time.
}}

\item{num_parallel_tree}{(for Tree Booster) (default=1)
Number of parallel trees constructed during each iteration. This option is used to support boosted random forest.}

\item{monotone_constraints}{(for Tree Booster)
Constraint of variable monotonicity. See \href{https://xgboost.readthedocs.io/en/latest/tutorials/monotonic.html}{Monotonic Constraints} for more information.}

\item{interaction_constraints}{(for Tree Booster)
Constraints for interaction representing permitted interactions. The constraints must
be specified in the form of a nest list, e.g. \code{list(c(0, 1), c(2, 3, 4))}, where each inner
list is a group of indices of features (base-0 numeration) that are allowed to interact with each other.
See \href{https://xgboost.readthedocs.io/en/latest/tutorials/feature_interaction_constraint.html}{Feature Interaction Constraints} for more information.}

\item{multi_strategy}{(for Tree Booster) (default = \code{"one_output_per_tree"})
The strategy used for training multi-target models, including multi-target regression
and multi-class classification. See \href{https://xgboost.readthedocs.io/en/latest/tutorials/multioutput.html}{Multiple Outputs} for more information.
\itemize{
\item \code{"one_output_per_tree"}: One model for each target.
\item \code{"multi_output_tree"}:  Use multi-target trees.
}

Version added: 2.0.0

Note: This parameter is working-in-progress.}

\item{base_score}{\itemize{
\item The initial prediction score of all instances, global bias
\item The parameter is automatically estimated for selected objectives before training. To
disable the estimation, specify a real number argument.
\item If \code{base_margin} is supplied, \code{base_score} will not be added.
\item For sufficient number of iterations, changing this value will not have too much effect.
}}

\item{eval_metric}{(default according to objective)
\itemize{
\item Evaluation metrics for validation data, a default metric will be assigned according to objective (rmse for regression, and logloss for classification, \verb{mean average precision} for \code{rank:map}, etc.)
\item User can add multiple evaluation metrics.
\item The choices are listed below:
\itemize{
\item \code{"rmse"}: root mean square error
\item \code{"rmsle"}: root mean square log error: \eqn{\sqrt{\frac{1}{N}[log(pred + 1) - log(label + 1)]^2}}. Default metric of \code{"reg:squaredlogerror"} objective. This metric reduces errors generated by outliers in dataset.  But because \code{log} function is employed, \code{"rmsle"} might output \code{nan} when prediction value is less than -1.  See \code{"reg:squaredlogerror"} for other requirements.
\item \code{"mae"}: mean absolute error.
\item \code{"mape"}: mean absolute percentage error.
\item \code{"mphe"}: mean Pseudo Huber error. Default metric of \code{"reg:pseudohubererror"} objective.
\item \code{"logloss"}: negative log-likelihood.
\item \code{"error"}: Binary classification error rate. It is calculated as \verb{#(wrong cases)/#(all cases)}. For the predictions, the evaluation will regard the instances with prediction value larger than 0.5 as positive instances, and the others as negative instances.
\item \code{"error@t"}: a different than 0.5 binary classification threshold value could be specified by providing a numerical value through 't'.
\item \code{"merror"}: Multiclass classification error rate. It is calculated as \verb{#(wrong cases)/#(all cases)}.
\item \code{"mlogloss"}: \href{https://scikit-learn.org/stable/modules/generated/sklearn.metrics.log_loss.html}{Multiclass logloss}.
\item \code{"auc"}: area under the receiver-operating characteristic curve.
Available for classification and learning-to-rank tasks.
\itemize{
\item When used with binary classification, the objective should be \code{"binary:logistic"} or similar functions that work on probability.
\item When used with multi-class classification, objective should be \code{"multi:softprob"} instead of \code{"multi:softmax"}, as the latter doesn't output probability.  Also the AUC is calculated by 1-vs-rest with reference class weighted by class prevalence.
\item When used with LTR task, the AUC is computed by comparing pairs of documents to count correctly sorted pairs.  This corresponds to pairwise learning to rank.  The implementation has some issues with average AUC around groups and distributed workers not being well-defined.
\item On a single machine the AUC calculation is exact. In a distributed environment the AUC is a weighted average over the AUC of training rows on each node - therefore, distributed AUC is an approximation sensitive to the distribution of data across workers. Use another metric in distributed environments if precision and reproducibility are important.
\item When input dataset contains only negative or positive samples, the output is \code{NaN}.  The behavior is implementation defined, for instance, \code{scikit-learn} returns \eqn{0.5} instead.
}
\item \code{"aucpr"}: area under the PR curve
Available for classification and learning-to-rank tasks.

After XGBoost 1.6, both of the requirements and restrictions for using \code{"aucpr"} in classification problem are similar to \code{"auc"}.  For ranking task, only binary relevance label \eqn{y \in [0, 1]} is supported.  Different from \code{"map"} (mean average precision), \code{"aucpr"} calculates the \emph{interpolated} area under precision recall curve using continuous interpolation.
\item \code{"pre"}: Precision at \eqn{k}. Supports only learning to rank task.
\item \code{"ndcg"}: normalized discounted cumulative gain
\item \code{"map"}: mean average precision

The \verb{average precision} is defined as:

\eqn{AP@l = \frac{1}{min{(l, N)}}\sum^l_{k=1}P@k \cdot I_{(k)}}

where \eqn{I_{(k)}} is an indicator function that equals to \eqn{1} when the document at \eqn{k} is relevant and \eqn{0} otherwise. The \eqn{P@k} is the precision at \eqn{k}, and \eqn{N} is the total number of relevant documents. Lastly, the \verb{mean average precision} is defined as the weighted average across all queries.
\item \code{"ndcg@n"}, \code{"map@n"}, \code{"pre@n"}: \eqn{n} can be assigned as an integer to cut off the top positions in the lists for evaluation.
\item \code{"ndcg-"}, \code{"map-"}, \code{"ndcg@n-"}, \code{"map@n-"}: In XGBoost, the NDCG and MAP evaluate the score of a list without any positive samples as \eqn{1}. By appending "-" to the evaluation metric name, we can ask XGBoost to evaluate these scores as \eqn{0} to be consistent under some conditions.
\item \code{"poisson-nloglik"}: negative log-likelihood for Poisson regression
\item \code{"gamma-nloglik"}: negative log-likelihood for gamma regression
\item \code{"cox-nloglik"}: negative partial log-likelihood for Cox proportional hazards regression
\item \code{"gamma-deviance"}: residual deviance for gamma regression
\item \code{"tweedie-nloglik"}: negative log-likelihood for Tweedie regression (at a specified value of the \code{tweedie_variance_power} parameter)
\item \code{"aft-nloglik"}: Negative log likelihood of Accelerated Failure Time model.
See \href{https://xgboost.readthedocs.io/en/latest/tutorials/aft_survival_analysis.html}{Survival Analysis with Accelerated Failure Time} for details.
\item \code{"interval-regression-accuracy"}: Fraction of data points whose predicted labels fall in the interval-censored labels.
Only applicable for interval-censored data.  See \href{https://xgboost.readthedocs.io/en/latest/tutorials/aft_survival_analysis.html}{Survival Analysis with Accelerated Failure Time} for details.
}
}}

\item{seed_per_iteration}{(default= \code{FALSE})
Seed PRNG determnisticly via iterator number.}

\item{device}{(default= \code{"cpu"})
Device for XGBoost to run. User can set it to one of the following values:
\itemize{
\item \code{"cpu"}: Use CPU.
\item \code{"cuda"}: Use a GPU (CUDA device).
\item \code{"cuda:<ordinal>"}: \verb{<ordinal>} is an integer that specifies the ordinal of the GPU (which GPU do you want to use if you have more than one devices).
\item \code{"gpu"}: Default GPU device selection from the list of available and supported devices. Only \code{"cuda"} devices are supported currently.
\item \code{"gpu:<ordinal>"}: Default GPU device selection from the list of available and supported devices. Only \code{"cuda"} devices are supported currently.
}

For more information about GPU acceleration, see \href{https://xgboost.readthedocs.io/en/latest/gpu/index.html}{XGBoost GPU Support}. In distributed environments, ordinal selection is handled by distributed frameworks instead of XGBoost. As a result, using \code{"cuda:<ordinal>"} will result in an error. Use \code{"cuda"} instead.

Version added: 2.0.0

Note: if XGBoost was installed from CRAN, it won't have GPU support enabled, thus only \code{"cpu"} will be available.
To get GPU support, the R package for XGBoost must be installed from source or from the GitHub releases - see
\href{https://xgboost.readthedocs.io/en/latest/install.html#r}{instructions}.}

\item{disable_default_eval_metric}{(default= \code{FALSE})
Flag to disable default metric. Set to 1 or \code{TRUE} to disable.}

\item{use_rmm}{Whether to use RAPIDS Memory Manager (RMM) to allocate cache GPU
memory. The primary memory is always allocated on the RMM pool when XGBoost is built
(compiled) with the RMM plugin enabled. Valid values are \code{TRUE} and \code{FALSE}. See
\href{https://xgboost.readthedocs.io/en/latest/python/rmm-examples/index.html}{Using XGBoost with RAPIDS Memory Manager (RMM) plugin} for details.}

\item{max_cached_hist_node}{(for Non-Exact Tree Methods) (default = 65536)
Maximum number of cached nodes for histogram. This can be used with the \code{"hist"} and the
\code{"approx"} tree methods.

Version added: 2.0.0
\itemize{
\item For most of the cases this parameter should not be set except for growing deep
trees. After 3.0, this parameter affects GPU algorithms as well.
}}

\item{max_cat_to_onehot}{(for Non-Exact Tree Methods)
A threshold for deciding whether XGBoost should use one-hot encoding based split for
categorical data.  When number of categories is lesser than the threshold then one-hot
encoding is chosen, otherwise the categories will be partitioned into children nodes.

Version added: 1.6.0}

\item{max_cat_threshold}{(for Non-Exact Tree Methods)
Maximum number of categories considered for each split. Used only by partition-based
splits for preventing over-fitting.

Version added: 1.7.0}

\item{sample_type}{(for Dart Booster) (default= \code{"uniform"})
Type of sampling algorithm.
\itemize{
\item \code{"uniform"}: dropped trees are selected uniformly.
\item \code{"weighted"}: dropped trees are selected in proportion to weight.
}}

\item{normalize_type}{(for Dart Booster) (default= \code{"tree"})
Type of normalization algorithm.
\itemize{
\item \code{"tree"}: new trees have the same weight of each of dropped trees.
\itemize{
\item Weight of new trees are \code{1 / (k + learning_rate)}.
\item Dropped trees are scaled by a factor of \code{k / (k + learning_rate)}.
}
\item \code{"forest"}: new trees have the same weight of sum of dropped trees (forest).
\itemize{
\item Weight of new trees are \code{1 / (1 + learning_rate)}.
\item Dropped trees are scaled by a factor of \code{1 / (1 + learning_rate)}.
}
}}

\item{rate_drop}{(for Dart Booster) (default=0.0)
Dropout rate (a fraction of previous trees to drop during the dropout).

range: \eqn{[0.0, 1.0]}}

\item{one_drop}{(for Dart Booster) (default=0)
When this flag is enabled, at least one tree is always dropped during the dropout (allows Binomial-plus-one or epsilon-dropout from the original DART paper).}

\item{skip_drop}{(for Dart Booster) (default=0.0)
Probability of skipping the dropout procedure during a boosting iteration.
\itemize{
\item If a dropout is skipped, new trees are added in the same manner as \code{"gbtree"}.
\item Note that non-zero \code{skip_drop} has higher priority than \code{rate_drop} or \code{one_drop}.
}

range: \eqn{[0.0, 1.0]}}

\item{feature_selector}{(for Linear Booster) (default= \code{"cyclic"})
Feature selection and ordering method
\itemize{
\item \code{"cyclic"}: Deterministic selection by cycling through features one at a time.
\item \code{"shuffle"}: Similar to \code{"cyclic"} but with random feature shuffling prior to each update.
\item \code{"random"}: A random (with replacement) coordinate selector.
\item \code{"greedy"}: Select coordinate with the greatest gradient magnitude.  It has \code{O(num_feature^2)} complexity. It is fully deterministic. It allows restricting the selection to \code{top_k} features per group with the largest magnitude of univariate weight change, by setting the \code{top_k} parameter. Doing so would reduce the complexity to \code{O(num_feature*top_k)}.
\item \code{"thrifty"}: Thrifty, approximately-greedy feature selector. Prior to cyclic updates, reorders features in descending magnitude of their univariate weight changes. This operation is multithreaded and is a linear complexity approximation of the quadratic greedy selection. It allows restricting the selection to \code{top_k} features per group with the largest magnitude of univariate weight change, by setting the \code{top_k} parameter.
}}

\item{top_k}{(for Linear Booster) (default=0)
The number of top features to select in \code{greedy} and \code{thrifty} feature selector. The value of 0 means using all the features.}

\item{num_class}{Number of classes when using multi-class classification objectives (e.g. \code{objective="multi:softprob"})}

\item{tweedie_variance_power}{(for Tweedie Regression (\code{"objective=reg:tweedie"})) (default=1.5)
\itemize{
\item Parameter that controls the variance of the Tweedie distribution \code{var(y) ~ E(y)^tweedie_variance_power}
\item range: \eqn{(1,2)}
\item Set closer to 2 to shift towards a gamma distribution
\item Set closer to 1 to shift towards a Poisson distribution.
}}

\item{huber_slope}{(for using Pseudo-Huber (\verb{"reg:pseudohubererror}")) (default = 1.0)
A parameter used for Pseudo-Huber loss to define the \eqn{\delta} term.}

\item{quantile_alpha}{(for using Quantile Loss (\code{"reg:quantileerror"}))
A scalar or a list of targeted quantiles (passed as a numeric vector).

Version added: 2.0.0}

\item{aft_loss_distribution}{(for using AFT Survival Loss (\code{"survival:aft"}) and Negative Log Likelihood of AFT metric (\code{"aft-nloglik"}))
Probability Density Function, \code{"normal"}, \code{"logistic"}, or \code{"extreme"}.}

\item{lambdarank_pair_method}{(for learning to rank (\code{"rank:ndcg"}, \code{"rank:map"}, \code{"rank:pairwise"})) (default = \code{"topk"})
How to construct pairs for pair-wise learning.
\itemize{
\item \code{"mean"}: Sample \code{lambdarank_num_pair_per_sample} pairs for each document in the query list.
\item \code{"topk"}: Focus on top-\code{lambdarank_num_pair_per_sample} documents. Construct \eqn{|query|} pairs for each document at the top-\code{lambdarank_num_pair_per_sample} ranked by the model.
}}

\item{lambdarank_num_pair_per_sample}{(for learning to rank (\code{"rank:ndcg"}, \code{"rank:map"}, \code{"rank:pairwise"}))
It specifies the number of pairs sampled for each document when pair method is \code{"mean"}, or the truncation level for queries when the pair method is \code{"topk"}. For example, to train with \verb{ndcg@6}, set \code{"lambdarank_num_pair_per_sample"} to \eqn{6} and \code{lambdarank_pair_method} to \code{"topk"}.

range = \eqn{[1, \infty)}}

\item{lambdarank_normalization}{(for learning to rank (\code{"rank:ndcg"}, \code{"rank:map"}, \code{"rank:pairwise"})) (default = \code{TRUE})
Whether to normalize the leaf value by lambda gradient. This can sometimes stagnate the training progress.

Version added: 2.1.0}

\item{lambdarank_score_normalization}{Whether to normalize the delta metric by the difference of prediction scores. This can
sometimes stagnate the training progress. With pairwise ranking, we can normalize the
gradient using the difference between two samples in each pair to reduce influence from
the pairs that have large difference in ranking scores. This can help us regularize the
model to reduce bias and prevent overfitting. Similar to other regularization
techniques, this might prevent training from converging.

There was no normalization before 2.0. In 2.0 and later versions this is used by
default. In 3.0, we made this an option that users can disable.

Version added: 3.0.0}

\item{lambdarank_unbiased}{(for learning to rank (\code{"rank:ndcg"}, \code{"rank:map"}, \code{"rank:pairwise"})) (default = \code{FALSE})
Specify whether do we need to debias input click data.}

\item{lambdarank_bias_norm}{(for learning to rank (\code{"rank:ndcg"}, \code{"rank:map"}, \code{"rank:pairwise"})) (default = 2.0)
\eqn{L_p} normalization for position debiasing, default is \eqn{L_2}. Only relevant when \code{lambdarank_unbiased} is set to \code{TRUE}.}

\item{ndcg_exp_gain}{(for learning to rank (\code{"rank:ndcg"}, \code{"rank:map"}, \code{"rank:pairwise"})) (default = \code{TRUE})
Whether we should use exponential gain function for \code{NDCG}. There are two forms of gain function for \code{NDCG}, one is using relevance value directly while the other is using\eqn{2^{rel} - 1} to emphasize on retrieving relevant documents. When \code{ndcg_exp_gain} is \code{TRUE} (the default), relevance degree cannot be greater than 31.}
}
\value{
A list with the entries that were passed non-NULL values. It is intended to
be passed as argument \code{params} to \code{\link[=xgb.train]{xgb.train()}} or \code{\link[=xgb.cv]{xgb.cv()}}.
}
\description{
Convenience function to generate a list of named XGBoost parameters, which
can be passed as argument \code{params} to \code{\link[=xgb.train]{xgb.train()}}. See the \href{https://xgboost.readthedocs.io/en/stable/parameter.html}{online documentation} for more details.

The purpose of this function is to enable IDE autocompletions and to provide in-package
documentation for all the possible parameters that XGBoost accepts. The output from this
function is just a regular R list containing the parameters that were set to non-default
values. Note that this function will not perform any validation on the supplied arguments.

If passing \code{NULL} for a given parameter (the default for all of them), then the default
value for that parameter will be used. Default values are automatically determined by the
XGBoost core library upon calls to \code{\link[=xgb.train]{xgb.train()}} or \code{\link[=xgb.cv]{xgb.cv()}}, and are subject to change
over XGBoost library versions. Some of them might differ according to the
booster type (e.g. defaults for regularization are different for linear and tree-based boosters).
}
