
<p align="center"><img src="./media/logo.png"></p>

<p align="center">
  <a href="https://github.com/sindresorhus/awesome"><img alt="awesome" src="https://awesome.re/badge.svg"/></a>
  <img alt="PRs Welcome" src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg"/>
</p>

---

## About

✨ A curated collection of outstanding articles, tools, and resources focused on mental health in the software industry. ✨

**Mental health** is a foundational aspect of our overall well-being. It encompasses emotional, psychological, and social stability, and affects how we think, feel, act, relate to others, and make choices. In the context of the tech industry—where long hours, high pressure, and remote or isolated work environments are common—supporting mental health is a personal priority and a collective responsibility.

This list gathers resources designed to raise awareness, promote self-care, reduce stigma, and help individuals and organizations navigate mental health challenges. From managing stress and anxiety to cultivating resilience and compassion at work, these tools aim to support developers, designers, managers, and anyone working in tech.

It covers topics including, but not limited to:

* Burnout and recovery
* Depression and anxiety in remote work
* Mindfulness and stress reduction
* Imposter syndrome and self-doubt
* Building psychologically safe engineering cultures

> **Disclaimer:** This list is a collection of self-help and educational resources. While we’ve found many of them helpful, they are not a substitute for professional mental health care. Therapy, medication, and clinical support are often essential for recovery and well-being.
>
> If you or someone you know is in crisis, please seek help immediately from local emergency services or a mental health professional. You can find international crisis support here:
> * 🌍 [To Write Love on Her Arms – Find Help](https://twloha.com/find-help/international-resources/)
> * 🌐 [International Association for Suicide Prevention – Crisis Centres](https://www.iasp.info/resources/Crisis_Centres/)

---

## Contents

- [Applications](#applications)
- [Articles](#articles)
- [Books](#books)
- [Conferences](#conferences)
- [Meetups](#meetups)
- [Organizations](#organizations)
- [Podcasts](#podcasts)
- [Talks](#talks)

---

## Applications

Apps that support mental health by helping users manage anxiety, depression, stress, sleep, and emotional resilience. These tools are not substitutes for professional care, but they can complement therapy or serve as entry points to self-reflection and support.

* [Calm](https://www.calm.com) – Provides guided meditations, sleep stories, and breathing exercises to help reduce anxiety and improve sleep quality.
* [Cope Notes](https://www.copenotes.com) – Sends daily text messages with positive thoughts, exercises, and journaling prompts to help combat depression and anxiety. Content is reviewed by mental health professionals.
* [EmoBay](https://emobay.org) – An AI-driven digital mental health platform offering 24/7 conversational support, mood tracking, and crisis-response guidance via a chatbot interface.
* [eQuoo](https://www.equoogame.com) – A game-based app that teaches psychological skills to improve emotional fitness and resilience through interactive storytelling.
* [Happify](https://www.happify.com) – Offers science-based activities and games designed to reduce stress, overcome negative thoughts, and build resilience.
* [Headspace](https://www.headspace.com) – A meditation and mindfulness app offering guided sessions, sleep aids, and stress-reduction techniques. Backed by clinical research and widely used in workplace wellness programs.
* [MindShift CBT](https://www.anxietycanada.com/resources/mindshift-cbt/) – Designed to help teens and young adults cope with anxiety using CBT strategies, including relaxation exercises and thought journals.
* [Moodpath](https://mymoodpath.com/en/) – An interactive mental health journal that helps you reflect on your emotional well-being, screen for symptoms of depression, and access helpful resources. Developed with input from clinical psychologists.
* [Nyxo](https://nyxo.app) – An open-source sleep tracking and coaching app for iOS and Android. It offers personalized sleep insights and education to help you develop healthier sleep habits.
* [PTSD Coach](https://www.ptsd.va.gov/appvid/mobile/ptsdcoach_app.asp) – Developed by the U.S. Department of Veterans Affairs, this app provides education about PTSD, self-assessment tools, and resources for managing symptoms.
* [Quirk](https://www.quirk.fyi/) – A free, open-source CBT app that helps you identify and reframe distorted thoughts. It’s a lightweight, privacy-focused tool designed to help users develop healthier thinking patterns.
* [Sanvello](https://sanvello.com) – Provides daily tools to manage stress, anxiety, and depression using techniques from cognitive behavioral therapy (CBT), mindfulness, and mood tracking. Includes access to peer communities and therapy options.
* [Three Good Things](https://three-good-things.glitch.me/) – A simple gratitude journaling app based on positive psychology research. Encourages users to reflect on three positive moments each day to build emotional resilience.
* [Wake Up Time](http://wakeupti.me/) – A web-based tool that calculates optimal wake-up times based on 90-minute sleep cycles, helping users feel more rested and in sync with natural rhythms.
* [we are ANXIO.us](http://weareanxio.us) – A thoughtfully curated collection of digital wellness tools, mental health apps, and community resources designed to support people living with anxiety.
* [Woebot](https://woebothealth.com) – A mental health chatbot that delivers daily emotional support using principles from CBT, helping users track moods and develop coping strategies.
* [Wrabit](https://writewithwrabit.com) – A writing app designed to help you build a daily journaling habit while contributing anonymously to mental health research.
* [Wysa](https://www.wysa.io) – An AI-powered chatbot that uses evidence-based techniques like CBT and mindfulness to support users in managing stress, anxiety, and depression.
* [Youper](https://www.youper.ai) – An AI-powered emotional health assistant that guides you through conversations and activities based on psychological techniques.

---

## Articles

Articles, personal essays, and research papers that explore mental health challenges in the tech industry — including burnout, imposter syndrome, depression, anxiety, and emotional well-being among software developers, engineers, and tech professionals.

* [A Programmers Guide To Stress](http://codingmindfully.com/a-programmers-guide-to-stress/) - By Daragh Byrne.
* [Are You More Than Okay: The State Of Mental Health In Tech In 2016](https://modelviewculture.com/pieces/are-you-more-than-okay-the-state-of-mental-health-in-tech-in-2016) - By Julia Nguyen.
* [Beating Burnout: A Guide For Supporting Mental Health At Work](https://almanac.io/docs/beating-burnout-a-guide-for-supporting-mental-health-at-work-yDLKVF3uJtMdshcZG37HP7OHpAczogYX) - By Almanac Core.
* [Coding, Fast And Slow: Developers And The Psychology Of Overconfidence](https://medium.com/better-programming/coding-fast-and-slow-developers-and-the-psychology-of-overconfidence-433388e7aec0) - By Dan Milstein.
* [Depression At Work Is Skyrocketing, But It Doesn't Have To Be Your New Normal](https://www.fingerprintforsuccess.com/blog/depression-at-work) - By Bev Campling.
* [Developer Depression: Isolation Is The Biggest Problem](https://thenextweb.com/insider/2012/10/20/are-developers-depressed/#gref) - By Lauren Maffeo.
* [Developers: How to Overcome Imposter Syndrome](https://medium.com/learn-love-code/developers-how-to-overcome-imposter-syndrome-48edee803cf4) - By Abhishek Pillai.
* [Do Not Disturb](https://joebell.co.uk/blog/do-not-disturb/) - By Joe Bell.
* [Encouraging Wellness in a Remote Workpalce](https://dev.to/desi/encouraging-wellness-in-a-remote-workplace-17m5) - By Desi Rottman.
* [For The Developers With Anxiety, And Everyone Else](https://medium.com/envato/for-the-developers-with-anxiety-and-everyone-else-834cc2517eba) - By Daine Mawer.
* [How I Beat Impostor Syndrome And Stopped Feeling Like A Fake](http://codingmindfully.com/how-i-beat-impostor-syndrome/) - By Daragh Byrne.
* [How I Conquered Anxiety And Learned To LOVE Coding](https://skillcrush.com/2015/06/18/eliminate-your-coding-anxiety/) - By Joyce Akiko.
* [How I Fought Through Anxiety And Depression To Finish freeCodeCamp's Front End Dev Program](https://medium.freecodecamp.org/battling-depression-and-anxiety-to-finish-freecodecamps-front-end-dev-program-66a4c8cc0e13) - By Emily Aamodt.
* [How To Keep Your Mental Health In Check When You Work From Home](https://weworkremotely.com/how-to-keep-your-mental-health-in-check-when-you-work-from-home) - By WeWorkRemotely.
* [How To Move Your Organization From Fear To Fearlessness](https://liberationist.org/how-to-move-your-organization-from-fear-to-fearlessness/) - By Gustavo Razzetti.
* [How To Prevent Or Recover From Developer Burnout](https://www.actitime.com/productivity/how-to-prevent-burnout) - By Anastasia.
* [Hunting For A Web Developer Job... With Crushing Anxiety And No Self-Esteem](https://medium.com/@jameslave/hunting-for-a-web-developer-job-with-crushing-anxiety-and-no-self-esteem-3aa64d67a0a4) - By James Lave.
* [I Can't Do It All: My Burnout Story](https://dev.to/molly_struve/i-cant-do-it-all-my-burnout-story-1e54) - By Molly Struve.
* [Intro To Meditation For Coders](https://dev.to/256hz/intro-to-meditation-for-coders-1p6f) - By Abe Dolinger.
* [It's Okay To Not Be Okay](https://dev.to/andrew/its-okay-to-not-be-okay) - By Andrew Montagne.
* [It's Time To Talk About Mental Health In The Games Industry](https://www.gamesindustry.biz/articles/2017-05-09-its-time-to-talk-about-mental-health-in-the-games-industry) - By Rich Eddy.
* [It's Time To Talk About Mental Illness In Indie Development](https://www.engadget.com/2018/04/04/mental-illness-indie-take-this-kate-edwards-mike-wilson) - By Jessica Conditt.
* [Mental Illness In The Web Industry](https://alistapart.com/article/mental-illness-in-the-web-industry) - By Brandon Gregory.
* [Mental Self Care For Software Developers And Web Designers](https://www.elegantthemes.com/blog/editorial/mental-self-care-for-software-developers-and-web-designers) - By B.J. Keeton.
* [My Mental Health Toolbelt](https://medium.com/@taylorotwell/my-mental-health-toolbelt-9b9fdd4ae149) - By Taylor Otwell.
* [On Dealing With Anxiety And Depression As A Developer](https://dev.to/moimikey/on-dealing-with-anxiety-and-depression-as-a-developer-2ac4) - By Michael Scott Hertzberg.
* [Overcoming Public Speaking Anxiety Of Software Engineers Using Virtual Reality Exposure Therapy](https://www.researchgate.net/publication/319064487_Overcoming_Public_Speaking_Anxiety_of_Software_Engineers_Using_Virtual_Reality_Exposure_Therapy) - By Merve Denizci Nazligul, Murat Yilmaz, Ulas Gulec, Mert Ali Gozcu, Rory V. O'Connor & Paul Clarke.
* [Perfectionism, Anxiety And Learning To Be Kind To Yourself](https://medium.com/samsung-internet-dev/perfectionism-anxiety-and-learning-to-be-kind-to-yourself-e3c23710704) - By Jo Franchetti.
* [Programmer Imposter Syndrome: 6 Ways To Get Over Yours](https://www.codingdojo.com/blog/programmer-imposter-syndrome) - By Ethan Urie.
* [Recovering From Burnout](https://kierantie.com/burnout) - By Kieran Tie.
* [Software Developer Careers Considered Harmful](http://www.methodsandtools.com/archive/zenprogrammer.php) - By Christian Grobmeier.
* [Sorry, Not Sorry - How To Advocate For Your Mental Health At Work](https://www.thriveglobal.com/stories/38629-how-to-advocate-for-yourself-at-work) - By Jessica DiVento.
* [Taming Anxiety And Hacking Your Way Into Productivity](https://hackernoon.com/taming-anxiety-and-hacking-your-way-into-productivity-1c9258b8380a) - By André Pena.
* [The Programmer’s Great Clinical Depression](https://simpleprogrammer.com/programmers-great-clinical-depression) - By Jason Lowenthal.
* [Tips For Dealing With Developer Stress](https://www.airpair.com/javascript/posts/tips-for-dealing-with-developer-stress) - By Rich McLaughlin.
* [Tips To Maintain Your Mental Health As A Software Developer](https://www.brightdevelopers.com/tips-maintain-mental-health-software-developer/) - By Steven To.
* [We Need To Talk About Developers And Depression](https://www.creativebloq.com/web-design/we-need-talk-about-developers-and-depression-101413045) - By Greg Baugues.
* [What Happens When Software Developers Are (un)Happy](https://www.sciencedirect.com/science/article/pii/S0164121218300323) - By Daniel Graziotin, Fabian Fagerholm, Xiaofeng Wang & Pekka Abrahamssone.
* [What It's Like Being A Developer With Schizoaffective Disorder](https://dev.to/ogfris/what-its-like-being-a-developer-with-schizoaffective-disorder-1ei) - By Fris.
* [What Most Remote Companies Don't Tell You About Remote Work](https://blog.doist.com/mental-health-and-remote-work-1b77616f6945) - By Amir Salihefendic.
* [Why Burnout Is Dangerous And How You Can Recover From It (It's Possible)](https://blog.toggl.com/recover-from-burnout) - By Theodora S. Abigail.
* [Why Do Software Developers Suffer From Imposter Syndrome?](https://medium.com/@rajeefmk/why-does-software-developers-suffer-from-imposter-syndrome-ccf961d0c29a) - By Muhammed Rajeef M K.

---

## Books

Books that explore mental health, self-care, and emotional well-being in the context of the tech industry — from personal stories and practical guides to research-backed strategies for navigating stress, burnout, imposter syndrome, and the challenges of modern software work.

* [Brotopia: Breaking Up the Boys’ Club of Silicon Valley](https://www.amazon.com/Brotopia-Breaking-Boys-Club-Silicon-Valley/dp/0735213534) - By Emily Chang. A revealing investigation into sexism and exclusion in tech culture—and the toll it takes on women’s mental health.
* [Building a Startup Without Going Crazy](https://www.amazon.com/Building-Startup-Without-Going-Crazy/dp/946126643X) - By Leen de Bruyne. A set of 100 short lessons from a founder who burned out and recovered, offering advice for staying sane while launching a company.
* [Burn Rate: Launching a Startup and Losing My Mind](https://www.amazon.com/Burn-Rate-Launching-Startup-Losing/dp/0593238265) - By Andy Dunn. A gripping memoir by the co-founder of Bonobos about living with bipolar disorder while building a startup.
* [Code Review Anxiety Workbook](https://developersuccesslab.gitbook.io/code-review-anxiety-workbook/) - By Developer Success Lab. A free, research-backed workbook to help developers manage fear, stress, and criticism around code reviews.
* [Developers and Depression](https://leanpub.com/developers-and-depression) - By Greg Baugues. A candid collection of essays and talks exploring bipolar disorder, ADHD, and mental illness in the developer community.
* [Imposter Syndrome (No CS Degree)](https://gumroad.com/l/imposter-syndrome) - Compiled by Pete. Insights from over 30 self-taught developers about overcoming imposter syndrome and thriving in the tech world without a computer science degree.
* [It Doesn’t Have to Be Crazy at Work](https://www.amazon.com/Doesnt-Have-Be-Crazy-Work/dp/0062874780) - By Jason Fried and David Heinemeier Hansson. A manifesto for calm work culture from the Basecamp founders, arguing against hustle culture and burnout.
* [Mental Health In Tech: Guidelines For Employees](https://leanpub.com/osmi-guidelines-for-employees) - By OSMI. A practical guide for employees navigating mental health at work, covering legal rights, accommodations, and how to advocate for wellness in the workplace.
* [Mental Health In Tech: Guidelines For Executives And HR Professionals](https://leanpub.com/osmi-guidelines-for-employers) - By OSMI. A resource for company leaders on creating supportive environments, complying with legal obligations, and fostering inclusive mental health policies in tech teams.
* [Mental Health In Tech: Guidelines For Mental Wellness In The Workplace](https://leanpub.com/osmi-mental-wellness-in-the-workplace) - By OSMI. A comprehensive handbook for building mentally healthy workplaces in tech, covering strategies, policy examples, and case studies.
* [Peopleware: Productive Projects and Teams](https://www.amazon.com/Peopleware-Productive-Projects-Teams-3rd/dp/0321934113) - By Tom DeMarco and Timothy Lister. An influential text on the human factors of software development, advocating for healthier team environments and better work-life balance.
* [Slack: Getting Past Burnout, Busywork, and the Myth of Total Efficiency](https://www.amazon.com/Slack-Getting-Burnout-Busywork-Efficiency/dp/0767907698) - By Tom DeMarco. A classic book on the importance of “slack” in developer workflows, highlighting the dangers of overwork and the need for creative space.

---

## Conferences

Conferences that promote mental health awareness, self-care, and emotional well-being in the tech industry — creating space for open conversations, education, and innovation around the psychological challenges faced by developers, designers, founders, and tech teams.

* [Behavioral Health Tech](https://behavioralhealthtech.com) - The leading conference on innovation in behavioral health and technology. Brings together tech companies, healthcare providers, and developers working on mental health platforms and services.
* [Computing And Mental Health](http://mentalhealth.media.mit.edu/) - A multidisciplinary gathering focused on how digital tools and computing technologies can support and enhance mental well-being. Hosted by the MIT Media Lab.
* [Heartifacts](https://heartifacts.codeandsupply.co/) - A people-focused tech conference centered around mental health, communication, and inclusion in the software industry. Designed to foster open conversations about burnout, stress, and psychological safety.
* [Mental Health America Annual Conference](https://mhanational.org/annual-conference) - A broad conference addressing national mental health issues, with tech-related tracks exploring innovation in digital mental health, privacy, and accessibility in mental health tech.

---

## Meetups

Community-led meetup groups around the world that create safe, supportive spaces for software professionals to connect, share experiences, and explore topics related to mental health, emotional well-being, and self-care in the tech industry.

* [Berlin Mental Health Support Group](https://www.meetup.com/berlin-mental-health-support-group/) - A peer support circle for tech professionals and others navigating mental health challenges. Offers regular “Soundness Check” sessions in a safe, non-judgmental space.
* [Thought Tech](https://www.meetup.com/thought-tech/) - Based in New York City, this group brings together technologists and innovators to explore the intersection of mental health and tech through open discussions and guest speakers.
* [Wellness for People in Tech](https://www.meetup.com/wellness-for-people-in-tech/) - A Silicon Valley meetup helping IT professionals manage stress and avoid burnout. Hosts wellness-focused workshops on self-care, work-life balance, and mental resilience.

---

## Organizations

Organizations bringing mental health awareness to the software industry.

* [Black Minds Matter](http://blackmindsmatter.co.uk/) - A non-profit organisation that aims to empower communities of Black people aged 13- 25, and wants to make more equal and just society for all.
* [Black Therapists Rock](https://www.blacktherapistsrock.com/) - Black Therapists Rock (BTR) is an organization committed to increasing awareness of social and psychological challenges impacting vulnerable communities.
* [The Black, African, and Asian Therapy Network](https://www.baatn.org.uk/) - The UK’s largest independent organisation to specialise in working psychologically, informed by an understanding of intersectionality, with people who identify as Black, African, South Asian and Caribbean.
* [Brown Sisters Speak](https://twitter.com/BrownSistersSpk) - Mental Health Peer Support & Advocacy for Women Of Color.
* [Compassionate Coding](https://compassionatecoding.com) - Compassionate Coding combines the effective practices of agile software development with a focus on empathy and the latest in positive organizational psychology.
* [Everybody Has A Brain](http://everybodyhasabrain.com/) - Everybody Has A Brain is about creating opportunities for dialogue around personal mental health.
* [Hack Mental Health](https://www.hackmentalhealth.care) - The intersection of mental health and technology.
* [IfMe](https://www.if-me.org) - Community for mental health experiences that encourages people to share their personal stories with trusted allies.
* [Mental Health Hackers](https://mentalhealthhackers.org/) - An Organization that aims at providing support services to those who may be susceptible to related mental health issues such as anxiety, depression, social isolation, eating disorders, etc.
* [Mental Health Knowledge Base](https://mentalhealth-kb.net/) - GitHub-based project and website that encourages a diversity of views regarding mental health.
* [MHPrompt](http://mhprompt.org) - Let's start a conversation about mental health in tech.
* [OSMI](https://osmihelp.org) - Open Sourcing Mental Illness is a non-profit, corporation dedicated to raising awareness, educating, and providing resources to support mental wellness in the tech and open source communities.
* [SelfCare.Tech](http://selfcare.tech/) - A repository of self-care resources for developers & others.

---

## Podcasts

Podcast episodes and series focused on mental health awareness in the software industry, including burnout, self-care, stress, and emotional resilience for developers and tech teams.

* [Destigmatizing Mental Health in the Tech Industry](https://hanselminutes.com/728) – On Hanselminutes (Ep. 728). Scott Hanselman interviews Dr. Jennifer Akullian about breaking the stigma around therapy, stress, and emotional struggles in the software industry.
* [Emotional Intelligence And Ethics In Tech](http://happyporchradio.com/season-4-episode-3-april-wensel/) – By April Wensel on the Happy Porch podcast. A conversation about compassionate coding and building emotionally intelligent engineering cultures.
* [Mental Health in Tech](https://anchor.fm/mental-health-in-tech) – Hosted by Schalk Neethling and Schalk Venter. A monthly podcast sharing real stories from developers about mental health, burnout, vulnerability, and resilience in tech.
* [Soft Skills Engineering](https://softskills.audio) – Hosted by Jamison Dance and Dave Smith. A humorous advice show for developers tackling topics like burnout, imposter syndrome, performance anxiety, and career balance.
* [Valarie Regas’s Story](https://devjourney.info/Guests/284-ValarieRegas.html) – On Software Developer’s Journey. A heartfelt episode where Valarie discusses her experience with depression, anxiety, and the need for empathy in tech workplaces.

---

## Talks

Talks and presentations about mental health awareness and other testimonies and experiences in the software industry.

* [A Conversation About Mental Health In Tech - Distill 2014](https://vimeo.com/105802592) - By Ed Finkler, Greg Baugues, John Dalton & Paddy Foran.
* [Advocating For Mental Health At Work - AnxietyTech 2018](https://www.youtube.com/watch?v=GfTSrtJgemQ) - By Dr. Jessica DiVento.
* [Anxiety & Calm Technology - AnxietyTech 2018](https://www.youtube.com/watch?v=hhliVWI4mCY) - By Amber Case.
* [Authentic Developer - Droidcon Berlin 2018](https://www.youtube.com/watch?v=k6tROMj_rIQ) - By Anastasia López Dornak.
* [Beyond Burnout: Mental Health And Neurodiversity In Engineering - DevOpsDays Boston 2018](https://www.youtube.com/watch?v=NGiy02nEcG8) - By James Meickle.
* [Burnout And Your Meat Computer - Electromagnetic Field 2018](https://www.youtube.com/watch?v=gcYRhATiyO4) - By Jessica Rose.
* [Cultivating Compassionate Tech Communities - AnxietyTech 2018](https://www.youtube.com/watch?v=4COZk8IjbJs) - By April Wensel.
* [Debugging Our Feelings: Cognitive Behavioural Therapy For Developers - Peers Conference 2018](https://vimeo.com/253833709) - By Jamie Strachan.
* [Developers And Depression - Codeland NYC 2017](https://www.youtube.com/watch?v=us4w6lBV30Y) - By Greg Baugues.
* [Developers, Entrepreneurs And Depression - Business Of Software 2015](https://www.youtube.com/watch?v=zUQjZZJjKsY) - By Greg Baugues.
* [Emotional Intelligence For Engineers - ngAtlanta 2018](https://www.youtube.com/watch?v=SJnVhkEx8Cs) - By April Wensel.
* [Fight Tech With Tech - AnxietyTech 2018](https://www.youtube.com/watch?v=DDka7_Yaaw4) - By Pamela Fox.
* [Getting Therapy To Those Who Need It Most - AnxietyTech 2018](https://www.youtube.com/watch?v=O4AWH5o1NVk) - By Shawn Kernes.
* [Hacking With My Anxiety - AnxietyTech 2018](https://www.youtube.com/watch?v=8tB6Eo8iJ70) - By Bryan Hughes.
* [Hitting The Wall And How To Get Up Again - Tackling Burnout And Strategies For Self Care - PyCon Australia 2016](https://www.youtube.com/watch?v=Rdc06jpjVIY) - By Jackson Fairchild.
* [Howto: Not Get A Burnout - PowerShell Conference EU 2018](https://www.youtube.com/watch?v=0MjqMlkA3gs) - By Jeff Wouters.
* [Imposter Syndrome - PyCon Australia 2016](https://www.youtube.com/watch?v=hNlLM0OUXDc) - By Bianca Gibson.
* [It's Dangerous To Go Alone: Battling The Invisible Monsters In Tech - PyCon 2014](https://www.youtube.com/watch?v=1i8ylq4j_EY) - By Julie Pagano.
* [It's Darkest Before Dawn: Alcoholism And Addiction In Tech - DjangoCon US 2016](https://www.youtube.com/watch?v=lyVHKTGjivo) - By Timothy Allen.
* [Living With Bipolar Disorder As A Software Engineer - AnxietyTech 2018](https://www.youtube.com/watch?v=Jv9HdGwulE0) - By Jenna Quindica.
* [Looking After Your Mental Health, A Guide For Software Developers - PHP Yorkshire 2018](https://www.youtube.com/watch?v=ITY3RAg_PW0) - By Mark Railton.
* [Mental Health In Development - PyCon Australia 2016](https://www.youtube.com/watch?v=P4wWbHvNAvY) - By Eloise Macdonald-Meyer.
* [Modern Mindfulness - Hey! 2016](https://www.youtube.com/watch?v=Dc2JkIXfx8I) - By Joe Bell.
* [Programmers Don't Like People...Or Do They? - Node.js Interactive 2018](https://www.youtube.com/watch?v=HPFuHS6aPhw) - By April Wensel.
* [Self Care: Avoiding Burnout - AnxietyTech 2018](https://www.youtube.com/watch?v=P4eR419RgVc) - By Shemika Lamare.
* [Stress & Depression, A Taboo In Our Time - GOTO 2017](https://www.youtube.com/watch?v=jGG6Wip_PGg) - By Gitte Klitgaard.
* [Stronger Than Fear: Mental Health In The Developer Community - ElixirDaze 2017](https://www.youtube.com/watch?v=7CoEDFOXJQo) - By Ed Finkler.
* [Successful, Accomplished, Depressed: A Talk About Performance, Perfectionism, And Burnout In IT - WeAreDevelopers 2018](https://www.youtube.com/watch?v=C84h5e9cOZY) - By Dennis Traub.
* [The Evolution Of VR Therapy - AnxietyTech 2018](https://www.youtube.com/watch?v=qdddeZfzrus) - By Skip Rizzo.
* [The Mental Impact of Tech Interviews - Abstractions II](https://www.youtube.com/watch?v=smS1PxK5qK4) ([Slides](https://docs.google.com/presentation/d/e/2PACX-1vRuuiXy4yk7B56kqCyYOxqKD1PRm5qVTEIg9FFlnTMLnNsrag6yzxnLgZFHjaFb6WbXLa60w4ci91xR/pub?start=false&loop=false&delayms=3000&slide=id.g44670d1eb8_0_13)) - By Zack Zlotnik.
* [The Never Ending Hack Mental Health In InfoSec Community - Circle City Con 5.0](https://www.youtube.com/watch?v=CWHfIdG0nOw) - By Danny Akacki.
* [UX Of Wearables In Clinical Treatment For PTSD - AnxietyTech 2018](https://www.youtube.com/watch?v=Ru58976R0Gw) - By Ada Ng.
* [VR Mental Health Startup: Idea To Reality - AnxietyTech 2018](https://www.youtube.com/watch?v=6fmT_MBcoTY) - By Jonathan Sockell.
* [Why We Need Innovation In Mental Health Tech - AnxietyTech 2018](https://www.youtube.com/watch?v=whYGza42F5U) - By Solome Tibebu.

## Contributing

[![Contributor Covenant](https://img.shields.io/badge/Contributor%20Covenant-v2.0%20adopted-ff69b4.svg)](https://github.com/dreamingechoes/awesome-mental-health/blob/master/CODE_OF_CONDUCT.md)

Please see [CONTRIBUTING](https://github.com/dreamingechoes/awesome-mental-health/blob/master/.github/CONTRIBUTING.md) for more details on how to suggest awesome resources or other modifications to the list. You can also find an alphabetically-ordered list of contributors of this repository [here](https://github.com/dreamingechoes/awesome-mental-health/blob/master/CONTRIBUTORS.md).

All contributors are expected to adhere to the [Code of Conduct](https://github.com/dreamingechoes/awesome-mental-health/blob/master/CODE_OF_CONDUCT.md) of the project. (Contributor Covenant)

---

This project was started by [dreamingechoes](https://github.com/dreamingechoes).
