# Frontend Development [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

Manually curated collection of resources for frontend web developers.

You are viewing the TGF (Totally Gigantic File). Proceed to [frontend-dev-bookmarks](./README.md) for a browsable version.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------------------------------

## Appearance

The outward or visible aspect of a website.

+ **Animation**: The process of creating motion and shape change.
    + **[Animate.css](http://daneden.github.io/animate.css/)**: Just-add-water CSS animations.
    + **[Animate.less](https://github.com/machito/animate.less)**: A bunch of cool, fun, and cross-browser animations converted into LESS for you to use in your Bootstrap projects.
    + **[Anime.js](https://github.com/juliangarnier/anime)**: Anime is a flexible yet lightweight JavaScript animation library. It works with CSS, Individual Transforms, SVG, DOM attributes and JS Objects.
    + **[Approach](http://srobbin.com/jquery-plugins/approach/)**: A jQuery plugin that allows you to animate CSS properties based on distance to an object.
    + **[CSS Spritesheet Animation Example](http://jsfiddle.net/simurai/CGmCe/light/)**: Sprite Sheet animation with CSS3 using the steps() feature.
    + **[Caat](http://hyperandroid.github.io/CAAT/)**: Scene graph director-based animation framework for javascript.
    + **[CanvasScript3](http://www.arahaya.com/canvasscript3/)**: CanvasScript3 is a Javascript library for the new HTML5 Canvas with an interface similar to ActionScript3. This library enables Sprite Groups, Layers, Mouse Events, Keyboard Events, Bitmap Effects, Tween Animations etc.
    + **[Collie](http://jindo.dev.naver.com/collie/)**: Collie is a Javascript library that helps to create highly optimized animations and games using HTML 5. Collie runs on both PC and mobile using HTML 5 canvas and DOM.
    + **[Emile.js](https://github.com/madrobby/emile)**: Emile.js is a no-frills stand-alone CSS animation JavaScript framework.
    + **[Firmin](http://extralogical.net/projects/firmin/)**: Firmin is a JavaScript animation library using CSS transforms and transitions.
    + **[GreenSock Animation Platform](http://www.greensock.com/get-started-js/)**: GreenSock Animation Platform is a suite of tools for scripted animation.
        + **[Codepen Repository](http://codepen.io/GreenSock/)**: Codepen repository with examples of Greensock usage and code.
        + **[Examples](http://ahrengot.com/tutorials/greensock-javascript-animation/)**: Here are a couple of examples demonstrating the core features of the Greensock Animation Platform.
        + **[Learning Center](http://www.greensock.com/learning/)**: Tutorials and videos for GreenSock Animation Platform.
    + **[JQuery Transit](http://ricostacruz.com/jquery.transit/)**: Super-smooth CSS3 transformations and transitions for jQuery.
    + **[Janis](https://github.com/MikeMcTiernan/Janis)**: Janis is a lightweight Javascript framework that provides simple animations via CSS transitions for modern browsers on the web as well as mobile devices.
    + **[Keanu](https://github.com/wambotron/Keanu)**: Keanu is a micro-lib for animation on Canvas/JS.
    + **[Magic](https://github.com/miniMAC/magic)**: CSS3 Animations with special effects.
    + **[Move.js](http://visionmedia.github.com/move.js/)**: Move.js is a small JavaScript library making CSS3 backed animation extremely simple and elegant.
    + **[Ramjet](http://www.rich-harris.co.uk/ramjet/)**: Ramjet makes it looks as though one DOM element is capable of transforming into another, no matter where the two elements sit in the DOM tree.
    + **[Rekapi](http://rekapi.com/)**: A keyframe animation library for JavaScript.
    + **[SVG.js](http://svgjs.com/)**: A lightweight library for manipulating and animating SVG.
    + **[Scripty2](http://scripty2.com/)**: scripty2 is a powerful, flexible JavaScript framework to help you write your own          delicious visual effects & user interfaces.
    + **[Shifty](http://jeremyckahn.github.com/shifty/)**: Shifty is a tweening engine built in JavaScript.  It is designed to fit any number of tweening needs.
    + **[Snap.svg](http://snapsvg.io/)**: Snap.svg JavaScript library makes working with your SVG assets as easy as jQuery makes working with the DOM.
    + **[Stylie](http://jeremyckahn.github.io/stylie/)**: Stylie is a fun tool for easily creating complex CSS animations. Quickly design your animation graphically, grab the generated code and go!
    + **[Textillate.js](http://jschr.github.io/textillate/)**: Textillate.js combines some awesome libraries to provide a ease-to-use plugin for applying CSS3 animations to any text.
    + **[Tween.js](https://github.com/sole/tween.js)**: Super simple, fast and easy to use tweening engine which incorporates optimised Robert Penner's equations.
    + **[Twitter Fave Animation](https://cssanimation.rocks/twitter-fave/)**: Rather than rely on CSS transitions, the new animation makes use of a series of images. Here’s how to recreate the animation using the CSS animation steps timing function.
    + **[Web Animation Past, Present, and Future (2016)](http://alistapart.com/article/web-animation-past-present-and-future)**: Rachel Nabors explores the world of web animation standards, platforms and tools in 2016: SVG, SMIL, GreenSock AP, Framer, Browser Tooling etc.
    + **[Web Animations API](http://w3c.github.io/web-animations/)**: Web Animations is a new JavaScript API for driving animated content on the web. By unifying the animation features of SVG and CSS, Web Animations unlocks features previously only usable declaratively, and exposes powerful, high-performance animation capabilities to developers.
        + **[Are we animated yet?](https://birtles.github.io/areweanimatedyet/)**: This page tracks the progress of implementing the Web Animations API in Firefox.
        + **[WAAPI Browser Support Test (+ Polyfill)](http://codepen.io/danwilson/pen/XmWraY)**: This codepen tests whether and to which extend your browser supports Web Animations API. The test is run after including the Polyfill.
        + **[Web Animations Polyfill](https://github.com/web-animations/web-animations-js)**: JavaScript implementation of the Web Animations API.
+ **Typography**: The style, arrangement, or appearance of typeset matter.
    + **[A Comprehensive Guide to Font Loading Strategies](https://www.zachleat.com/web/comprehensive-webfonts/)**: Zach Leatherman describes different approaches to loading of web fonts.
    + **[Adobe Edge Web Fonts](https://edgewebfonts.adobe.com/fonts)**: Edge Web Fonts is a free service that provides access to a large library of fonts for your website. It’s one of the Edge Tools & Services from Adobe. Use of the service is free and unlimited.
    + **[Baseline.js](https://github.com/daneden/Baseline.js)**: A simple jQuery plugin for restoring vertical baselines thrown off by odd image sizes.
    + **[CSS Typography cheat sheet](http://www.newnet-soft.com/blog/csstypography)**: Small roundup on CSS features that will enhance your web typography.
    + **[Convincing a browser to load fonts from other domains](http://stackoverflow.com/questions/2892691/font-face-fonts-only-work-on-their-own-domain)**: A StackOverflow question about loading fonts across domains.
    + **[FitText](http://fittextjs.com/)**: FitText makes font-sizes flexible. Use this plugin on your fluid or responsive layout to achieve scalable headlines that fill the width of a parent element.
    + **[FlowType.JS](http://simplefocus.com/flowtype/)**: Font-size and line-height based on element width.
    + **[Fontmatrix](http://media.24ways.org/2007/17/fontmatrix.html)**: Matrix of fonts bundled with Mac and Windows operating systems, Microsoft Office and Adobe Creative Suite.
    + **[Google Fonts](https://www.google.com/fonts/)**: Google Fonts makes it quick and easy for everyone to use web fonts. Our goal is to create a directory of web fonts for the world to use. Our API service makes it easy to add Google Fonts to a website in seconds.
    + **[Gutenberg](http://matejlatin.github.io/Gutenberg/)**: Gutenberg is a flexible and simple-to-use web typography starter kit for web designers and developers.
    + **[Lettering.js](http://letteringjs.com/)**: Web type is exploding all over the web but CSS currently doesn't offer complete down-to-the-letter control. So we created a jQuery plugin to give you that control.
    + **[OpenFoundry](http://open-foundry.com/)**: A platform for open-source fonts in a noise-free environment; to highlight their beauty and encourage further exploration.
    + **[Pure Typography](http://tilomitra.github.io/csstypography/)**: CSS Styles for nicer web type. Depends on Pure.
    + **[Quick guide to webfonts via @font-face](http://www.html5rocks.com/en/tutorials/webfonts/quick/)**: The @font-face feature from CSS3 allows us to use custom typefaces on the web in an accessible, manipulable, and scalable way.
    + **[Truly Fluid Typography With vh And vw Units](https://www.smashingmagazine.com/2016/05/fluid-typography/)**: This article describes viewport units and other technics to achieve typography which resizes smoothly with the screen.
    + **[TypeButter](https://github.com/hudsonfoo/typebutter)**: TypeButter allows you to set optical kerning for any font on your website. If you're longing for beautifully laid out text that today' browsers just don't provide, this is the plugin for you.
    + **[Typeset.css](https://github.com/joshuarudd/typeset.css)**: A no-nonsense CSS typography reset for styling user-generated content like blog posts, comments, and forum content.
    + **[Typeset.css](http://stormwarning.github.io/typeset.css/)**: A Sass library that provides some sensible default styles, optional classes to use & extend as needed, and some utility functions & mixins to make elevating your typography simpler.
    + **[bacon](http://baconforme.com/)**: Bacon is a jQuery plugin that allows you to wrap text around a bezier curve or a line.
    + **[slabText](https://github.com/freqDec/slabText/)**: A jQuery plugin for producing big, bold & responsive headlines.
    + **[trunk8](http://jrvis.com/trunk8/)**: trunk8 is an intelligent text truncation plugin to jQuery. When applied to a large block of text, trunk8 will cut off just enough text to prevent it from spilling over.
+ **Visualization**: Placing data in a visual context.
    + **[Bonsai.js](http://bonsaijs.org/)**: A lightweight graphics library with an intuitive graphics API and an SVG renderer.
    + **[Chart.js](http://www.chartjs.org/)**: Simple, clean and engaging charts for designers and developers.
    + **[Crossfilter](http://square.github.io/crossfilter/)**: Crossfilter is a JavaScript library for exploring large multivariate datasets in the browser.
    + **[Cube](http://square.github.io/cube/)**: Cube is a system for collecting timestamped events and deriving metrics. By collecting events rather than metrics, Cube lets you compute aggregate statistics post hoc.
    + **[Cubism.js](http://square.github.io/cubism/)**: Cubism.js is a D3 plugin for visualizing time series. Use Cubism to construct better realtime dashboards, pulling data from Graphite, Cube and other sources.
    + **[D3.js](https://d3js.org/)**: D3.js is a JavaScript library for manipulating documents based on data. D3 helps you bring data to life using HTML, SVG, and CSS.
        + **[DataMaps](http://datamaps.github.io/)**: Customizable SVG (world) map visualizations for the web in a single Javascript file using D3.js.
        + **[Interactive Introduction to D3](http://vadim.ogievetsky.com/IntroD3/)**: D3 slides in D3 that I put together after becoming frustrated with explaining D3 using PowerPoint.
        + **[NVD3](http://nvd3.org/)**: This project is an attempt to build re-usable charts and chart components for d3.js without taking away the power that d3.js gives you.
        + **[Tutorial: Introduction to D3](http://www.janwillemtulp.com/2011/03/20/tutorial-introduction-to-d3/)**: Basically we just plot hidden circles randomly on the screen, and then transition them to a portion of the screen. Then we add some interaction to it so that the circles will move once you move your mouse over them.
        + **[xCharts](http://tenxer.github.io/xcharts/)**: xCharts is a JavaScript library for building beautiful and custom data-driven chart visualizations for the web using D3.js. Using HTML, CSS, and SVG, xCharts are designed to be dynamic, fluid, and open to integrations and customization.
    + **[Easy Pie Chart](http://rendro.github.io/easy-pie-chart/)**: Easy pie chart is a jQuery plugin that uses the canvas element to render simple pie charts for single values
    + **[Flot](http://www.flotcharts.org/)**: Flot is a pure JavaScript plotting library for jQuery, with a focus on simple usage, attractive looks and interactive features.
    + **[Google Chart Tools](https://developers.google.com/chart/)**: The Google Visualization API allows you to create charts and reporting applications over structured data and helps integrate these directly into your website.
    + **[Paper.js](http://paperjs.org)**: Paper.js offers a clean Scene Graph / Document Object Model and a lot of powerful functionality to create and work with vector graphics and bezier curves.
    + **[Photon](http://photon.attasi.com/)**: Photon is a JavaScript library that adds simple lighting effects to DOM elements in 3D space.
    + **[Piecon](http://lipka.github.io/piecon/)**: A tiny javascript library for dynamically generating progress pie charts in your favicons.
    + **[Processing.js](http://berniesumption.com/software/animator/)**: Processing.js is the sister project of the popular Processing visual programming language, designed for the web. Processing.js makes your data visualizations work using web standards.
    + **[Smoothie Charts](http://smoothiecharts.org/)**: A JavaScript Charting Library for Streaming Data.
    + **[TimelineJS](http://timeline.knightlab.com/)**: TimelineJS is an open-source tool that enables anyone to build visually rich, interactive timelines.
    + **[Timesheet.js](http://sbstjn.github.io/timesheet.js/)**: Visualize your data and events with sexy HTML5 and CSS3. Create simple time sheets with sneaky JavaScript. Style them with CSS and have mobile fun as well.
    + **[Treefun by Jim Blackler](https://github.com/jimblackler/treefun)**: This tool creates SVG (Standard Vector Graphics) files to illustrate information structured as a basic tree.
    + **[jQuery.Gantt](http://taitems.github.io/jQuery.Gantt/)**: Draw Gantt charts with the famous jQuery ease of development.
    + **[jStat](http://jstat.github.io/)**: jStat is a statistical library written in JavaScript that allows you to perform advanced statistical operations without the need of a dedicated statistical language (e.g. MATLAB or R).
    + **[morris.js](http://morrisjs.github.io/morris.js/)**: Morris.js is a very simple API for drawing line, bar, area and donut charts.
    + **[mxgraph](http://jgraph.github.io/mxgraph/)**: mxGraph is a JavaScript diagramming library that enables interactive graph and charting applications to be quickly created that run natively in any major browser, both HTML 5 capable and Internet Explorer v7+.
    + **[three.js](http://threejs.org/)**: Three.js is a library that makes WebGL - 3D in the browser - easy to use. While a simple cube in raw WebGL would turn out hundreds of lines of Javascript and shader code, a Three.js equivalent is only a fraction of that.
    + **[vis.js](http://visjs.org/)**: Vis.js is a dynamic, browser based visualization library. The library is designed to be easy to use, handle large amounts of dynamic data, and enable manipulation of the data.

## Architecture

High level structure of the frontend code and the discipline of creating such structures.

+ **Algorithms**: A self-contained step-by-step set of operations to be performed. Algorithms perform calculation, data processing, and/or automated reasoning tasks.
    + **[Algorithm Visualizer](https://github.com/parkjs814/AlgorithmVisualizer)**: A collection of algorithms with code and visualizations for each one of them.
    + **[Sorting Algorithms Animations](https://www.toptal.com/developers/sorting-algorithms/)**: The following animations illustrate how effectively data sets from different starting points can be sorted using different algorithms.
+ **Design Patterns**: Best practices that the programmer can use to solve common problems when designing an application or system.
    + **[CSS Modules](https://github.com/css-modules)**: A CSS Module is a CSS file in which all class names and animation names are scoped locally by default.
        + **[CSS Modules Documentation](https://github.com/css-modules/css-modules)**: General overview and some implementations.
        + **[ES CSS Modules](https://github.com/jacobp100/es-css-modules)**: PostCSS plugin that combines CSS Modules and ES Imports.
        + **[Tree Shaking Bootstrap](https://medium.com/@jacobp/tree-shaking-bootstrap-95d6301f61a9)**: Jacob Parker describes how to include only those parts of Bootstrap you are really using on your website by leveraging CSS modules and ES6 modules.
    + **Components**: Reusable and composable pieces of HTML, CSS and/or JavaScript code which are mostly used for GUI elements.
        + **[Component Check](https://github.com/Mercateo/component-check)**: In this project Donald Pipowitch compares the usage and development of components in several frameworks such as Angular, Ember, Cycle.js and React.
        + **[Container Components](https://medium.com/@learnreact/container-components-c0e67432e005)**: Container Components is a pattern which allows to separate data-fetching and rendering concerns and increase the reusability of the (child) components.
        + **[Devbridge Styleguide](http://livingstyleguide.devbridge.com/)**: Devbridge Styleguide helps you create, share, and automate a living visual style library of your brand.
        + **[Presentational and Container Components](https://medium.com/@dan_abramov/smart-and-dumb-components-7ca2f9a7c7d0)**: Dan Abramov creates a pattern for separating presentational and container components to increase reusability and clarity of the application code.
        + **Web Components**: Web Components is a W3C standard for encapsulated, reusable and composable widgets for the web platform.
            + **[Are We Componentized Yet?](http://jonrimmer.github.io/are-we-componentized-yet/)**: Tracking the progress of Web Components through standardisation, polyfillification and implementation.
            + **[Custom Elements](http://www.html5rocks.com/en/tutorials/webcomponents/customelements/)**: Eric Bidelman describes how to create new HTML elements and manage their life cycle.
            + **[Custom Elements W3C Editor's Draft](http://w3c.github.io/webcomponents/spec/custom/)**: This specification describes the method for enabling the author to define and use new types of DOM elements in a document.
            + **[HTML Imports W3C Editor's Draft](http://w3c.github.io/webcomponents/spec/imports/)**: HTML Imports are a way to include and reuse HTML documents in other HTML documents.
            + **[HTML Imports: #include for the web](http://www.html5rocks.com/en/tutorials/webcomponents/imports/)**: Eric Bidelman describes how to use HTML imports and goes through several edge cases.
            + **[HTML's New Template Tag](http://www.html5rocks.com/en/tutorials/webcomponents/template/)**: The template element allows you to declare fragments of DOM which are parsed, inert at page load, and instantiated later at runtime.
            + **[Shadow DOM 101](http://www.html5rocks.com/en/tutorials/webcomponents/shadowdom/)**: Dominic Cooney shows you how to use Shadow DOM in this tutorial.
            + **[Shadow DOM 201](http://www.html5rocks.com/en/tutorials/webcomponents/shadowdom-201/)**: Eric Bidelman explains advanced topics related to styling of Shadow DOM elements.
            + **[Shadow DOM 301](http://www.html5rocks.com/en/tutorials/webcomponents/shadowdom-301/)**: Eric Bidelman talks about advanced Shadow DOM topics like multiple shadow roots, insertion points, event model and Shadow DOM Visualizer.
            + **[Shadow DOM W3C Editor's Draft](http://w3c.github.io/webcomponents/spec/shadow/)**: This specification describes a method of combining multiple DOM trees into one hierarchy and how these trees interact with each other within a document, thus enabling better composition of the DOM.
            + **[ShadowDOM Visualizer](http://html5-demos.appspot.com/static/shadowdom-visualizer/index.html)**: This tool allows you to visualize how Shadow DOM renders in the browser.
            + **[Why Web Components Are So Important](https://blog.revillweb.com/why-web-components-are-so-important-66ad0bd4807a)**: Leon Revill compares web components with concepts from different frameworks and explains why web components matter.
            + **[Write Web Components with ES2015 (ES6)](https://blog.revillweb.com/write-web-components-with-es2015-es6-75585e1f2584)**: This tutorial shows how to create a web component using ES2015 and how to make use of babel to transpile back to ES5.
    + **DOM Diffing & Patching**: Diffing & Patching is a pattern which allows faster and simpler rendering and updating of DOM trees as manual manipulation à la jQuery.
        + **[Change And Its Detection In JavaScript Frameworks](http://teropa.info/blog/2015/03/02/change-and-its-detection-in-javascript-frameworks.html)**: This article explores several approaches to manage state: Ember's data binding, Angular's dirty checking, React's virtual DOM, and its relationship to immutable data structures.
        + **[Cito.js](https://github.com/joelrich/citojs)**: The core of cito.js consists of a virtual DOM library inspired by React/Mithril. On top of that, it will provide a component framework which will make it easy to build well-encapsulated components.
        + **[Incremental DOM](https://github.com/google/incremental-dom)**: Incremental DOM is a library for building up DOM trees and updating them in-place when data changes. It differs from the established virtual DOM approach in that no intermediate tree is created (the existing tree is mutated in-place).
            + **[Introducing Incremental DOM](https://medium.com/google-developers/introducing-incremental-dom-e98f79ce2c5f)**: Incremental DOM is a library inspired by Virtual DOM developed at Google.
        + **[Morphdom](https://github.com/patrick-steele-idem/morphdom)**: Lightweight module for morphing an existing DOM node tree to match a target DOM node tree. It's fast and works with the real DOM—no virtual DOM here!
        + **[React Demystified](http://blog.reverberate.org/2014/02/react-demystified.html)**: This article is an attempt to explain the core ideas behind React.js and Virtual DOM.
        + **[React vs Incremental DOM vs Glimmer](https://auth0.com/blog/2015/11/20/face-off-virtual-dom-vs-incremental-dom-vs-glimmer/)**: In this post we will explore three technologies to build dynamic DOMs. We will also run benchmarks and find out which one is faster.
        + **[React-less Virtual DOM with Snabbdom: functions everywhere!](https://medium.com/@yelouafi/react-less-virtual-dom-with-snabbdom-functions-everywhere-53b672cb2fe3)**: Yassine Elouafi shows in this post how to write a virtual DOM based applications using a small and standalone library.
        + **[Snabbdom](https://github.com/paldepind/snabbdom)**: A virtual DOM library with focus on simplicity, modularity, powerful features and performance.
        + **[Virtual DOM](https://github.com/Matt-Esch/virtual-dom)**: Virtual-dom is a collection of modules designed to provide a declarative way of representing the DOM for your app. So instead of updating the DOM, you simply create a virtual tree or VTree, which looks like the DOM state that you want.
            + **[html-to-vdom](https://github.com/TimBeyer/html-to-vdom)**: This is yet another library to convert HTML into a vtree. It's used in conjunction with virtual-dom to convert template based views into virtual-dom views.
            + **[html2hyperscript](https://github.com/unframework/html2hyperscript)**: Automatically translate old HTML markup into the new Hyperscript markup embeddable directly inside your component Javascript code.
            + **[vdom-to-html](https://github.com/nthtran/vdom-to-html/)**: Turn Virtual DOM nodes into HTML.
            + **[vdom-virtualize](https://github.com/marcelklehr/vdom-virtualize/)**: Turn a DOMNode into a virtual-dom node.
            + **[virtual-html](https://github.com/yoshuawuyts/virtual-html)**: Convert given HTML into Virtual DOM object.
            + **[vtree-select](https://github.com/parshap/vtree-select)**: Select vtree nodes (used by virtual-dom) using css selectors. Selector matching is done using cssauron. See the documentation for details on supported selectors.
    + **Design Pattern Collections**: Overview resources and collections of design patterns.
        + **[About HTML Semantics and Frontend Architecture](http://nicolasgallagher.com/about-html-semantics-front-end-architecture/)**: A collection of thoughts, experiences, ideas on HTML semantics, components and approaches to front-end architecture, class naming patterns, and HTTP compression.
        + **[Box Tech Talk: Scalable JavaScript Application Architecture](https://www.youtube.com/watch?v=mKouqShWI4o)**: A video by Nicholas Zakas (2012) about JavaScript Architecture.
        + **[Learning JavaScript Design Patterns](https://addyosmani.com/resources/essentialjsdesignpatterns/book/)**: In this free book Addy Osmani explores applying both classical and modern design patterns to the JavaScript programming language.
        + **[Patterns For Large-Scale JavaScript Application Architecture](https://addyosmani.com/largescalejavascript/)**: An extensive overview by Addy Osmani of existing architectural solutions in the frontend development field.
        + **[Scalable JavaScript Application Architecture](https://www.youtube.com/watch?v=vXjVFPosQHw)**: In this video (2011) Nicholas Zakas discusses frontend architecture for complex, modular web applications with significant JavaScript elements.
        + **[Single Page Apps in Depth](http://singlepageappbook.com/)**: This free book is what I wanted when I started working with single page apps. It's not an API reference on a particular framework, rather, the focus is on discussing patterns, implementation choices and decent practices.
    + **JavaScript Modules**: Modules divide programs into clusters of code that, by some criterion, belong together.
        + **[Chapter 10 of Eloquent JavaScript: Modules](http://eloquentjavascript.net/10_modules.html)**: This chapter explores some of the benefits that division of code provides and shows techniques for building modules in JavaScript.
        + **[ES6 In Depth: Modules](https://hacks.mozilla.org/2015/08/es6-in-depth-modules/)**: This article highlights export and import keywords from ES6.
        + **[Efficient Module Loading Without Bundling](https://mariusgundersen.net/module-pusher/)**: We can combine ES2015 modules, static analysis of those modules, HTTP/2, caching, Service Workers and a bloom-filter to create a server-client relationship where the client can efficiently load any module.
        + **[JavaScript Modules: A Beginner’s Guide](https://medium.freecodecamp.com/javascript-modules-a-beginner-s-guide-783f7d7a5fcc#.i78m6tfs9)**: In this post, Preethi Kasireddy will unpack the buzzwords like module bundlers, AMD and CommonJS for you in plain English, including a few code samples.
        + **[Modern Modular JavaScript Design Patterns](https://addyosmani.com/resources/essentialjsdesignpatterns/book/#modularjavascript)**: A chapter from Essential JavaScript Design Patterns on Modules.
        + **Module Bundlers and Loaders**: Libraries for bundling JavaScript Modules into one or several files.
            + **[Browserify](http://browserify.org/)**: Browserify lets you require('modules') in the browser by bundling up all of your dependencies.
                + **[Budo](https://github.com/mattdesl/budo)**: A browserify development server, focused on incremental reloading, LiveReload integration (including CSS injection), and other high-level features.
                + **[Watchify](https://www.npmjs.org/package/watchify)**: Watch mode for browserify builds.
            + **[CrapLoader](https://github.com/gregersrygg/crapLoader)**: The goal of crapLoader is to load ads, widgets or any JavaScript code with document.write in it. This library hijacks document.write and delegates the content loaded from each script into the correct position.
            + **[Modules Webmake](https://github.com/medikoo/modules-webmake)**: A CommonJS module bundler similar to Browserify but much faster due to different requirements finder.
            + **[Require.js](http://requirejs.org/)**: RequireJS is a JavaScript file and AMD module loader. It is optimized for in-browser use, but it can be used in other JavaScript environments.
            + **[Require1k](http://stuk.github.io/require1k/)**: CommonJS require for the browser in 1KB, with no build needed.
            + **[Rollup.js](http://rollupjs.org/)**: Rollup is a next-generation JavaScript module bundler. Author your app or library using ES2015 modules, then efficiently bundle them up into a single file for use in browsers and Node.js.
            + **[SystemJS](https://github.com/systemjs/systemjs)**: Universal dynamic module loader - loads ES6 modules, AMD, CommonJS and global scripts in the browser and NodeJS. Works with both Traceur and Babel.
                + **[Modular JavaScript: A Beginners Guide to SystemJS & JSPM](http://www.sitepoint.com/modular-javascript-systemjs-jspm/)**: The combination of jspm and SystemJS provides a unified way of installing and loading dependencies.
            + **[URequire](https://github.com/anodynos/urequire)**: The Ultimate JavaScript Module Builder & Automagical Task Runner.
            + **[Webpack](http://webpack.github.io/)**: Webpack is a module bundler. It takes modules with dependencies and generates static assets representing those modules.
                + **[Block, Element, Modifying Your JavaScript Components](https://medium.com/seek-ui-engineering/block-element-modifying-your-javascript-components-d7f99fcab52b)**: Mark Dalgleish is discussing how to organize React code with BEM and build everything with Webpack.
                + **[Developing with Docker and Webpack](http://dapperdeveloper.com/2016/05/18/developing-with-docker-and-webpack/)**: Chris Harrington explains how to create a development environment with Webpack and Docker to match the production as much as possible.
                + **[Full-Stack Redux Tutorial](http://teropa.info/blog/2015/09/10/full-stack-redux-tutorial.html)**: We will go through all the steps of constructing a Node+Redux backend and a React+Redux frontend for a real-world application, using test-first development.
                + **[How to Set Up Webpack Image Loader](http://www.davidmeents.com/how-to-set-up-webpack-image-loader/)**: This brief tutorial will help you set up an image loader in Webpack.
                + **[The SoundCloud Client in React + Redux](http://www.robinwieruch.de/the-soundcloud-client-in-react-redux/)**: After finishing this step by step tutorial you will be able to author your own React + Redux project with Webpack and Babel.
                + **[Webpack from Apprentice to Master](http://survivejs.com/webpack/)**: The purpose of this guide is to help you get started with Webpack and then go beyond basics.
                + **[WebpackBin](http://www.webpackbin.com/)**: A webpack code sandbox.
                + **[Why I think Webpack is the Right Approach To Build Pipelines](http://devlog.disco.zone/2016/06/01/webpack/)**: Thomas Boyt compares how Grunt, Gulp, Broccoli and Webpack discover dependencies.
        + **[UMD (Universal Module Definition)](https://github.com/umdjs/umd)**: This repository formalizes the design and implementation of the Universal Module Definition (UMD) API for JavaScript modules. These are modules which are capable of working everywhere, be it in the client, on the server or elsewhere.
        + **[Writing Modular JavaScript With AMD, CommonJS & ES Harmony](https://addyosmani.com/writing-modular-js/)**: In this article Addy Osmani reviewes several of the options available for writing modular JavaScript using modern module formats AMD, CommonJS and ES6 Modules.
    + **Observable**: An Observable is an event stream which can emit zero or more events, and may or may not finish. If it finishes, then it does so by either emitting an error or a special “complete” event.
        + **[ECMAScript Observable](https://github.com/zenparsing/es-observable)**: This proposal introduces an Observable type to the ECMAScript standard library. The Observable type can be used to model push-based data sources such as DOM events, timer intervals, and sockets.
        + **[Reactive Extensions (RxJS)](https://github.com/Reactive-Extensions/RxJS)**: RxJS is a set of libraries for composing asynchronous and event-based programs using observable sequences and fluent query operators.
            + **[Async JavaScript with Reactive Extensions](https://www.youtube.com/watch?v=XRYN2xt11Ek)**: Jafar Husain explains in this video how Netflix uses the Reactive Extensions (Rx) library to build responsive user experiences that strive to be event-driven, scalable and resilient.
            + **[Exploring Rx Operators: FlatMap](http://blog.thoughtram.io/rx/2016/08/01/exploring-rx-operators-flatmap.html)**: Christoph Burgdorf introduces the FlatMap operator and its usage for collections and observables.
            + **[Exploring Rx Operators: Map](http://blog.thoughtram.io/angular/2016/05/16/exploring-rx-operators-map.html)**: Christoph Burgdorf explains how to use the map operator in RxJS.
            + **[Functional Core Reactive Shell](http://www.mokacoding.com/blog/functional-core-reactive-shell/)**: Giovanni Lodi makes an overview of different architecture meta-patterns and describes his current findings about functional programming and observables as a way to control side effects.
            + **[Learn RX](http://reactivex.io/learnrx/)**: A series of interactive exercises for learning Microsoft's Reactive Extensions (Rx) Library for Javascript.
            + **[Learn RxJS](http://www.learnrxjs.io/)**: This site focuses on making RxJS concepts approachable, the examples clear and easy to explore, and features references throughout to the best RxJS related material on the web.
            + **[Real World Observables](https://medium.com/@sergimansilla/real-world-observables-1f65748c8f9)**: Sergi Mansilla writes an FTP client to use it as an example for a real world application based on RxJS.
            + **[Rx Training Games](https://github.com/JulienMoumne/rx-training-games)**: Rx Training Games is a coding playground that can be used to learn and practice Reactive Extensions coding grid-based games
            + **[Rx-Book](http://xgrommx.github.io/rx-book/index.html)**: A complete book about RxJS v.4.0.
            + **[RxMarbles](http://rxmarbles.com/)**: A webapp for experimenting with diagrams of Rx Observables, for learning purposes.
            + **[RxState](https://www.npmjs.com/package/rxstate)**: Simple opinionated state management library based on RxJS and Immutable.js
            + **[Taking Advantage of Observables in Angular 2](http://blog.thoughtram.io/angular/2016/01/06/taking-advantage-of-observables-in-angular2.html)**: Christoph Burgdorf describes the advantages of Observables and how you can use them in Angular 2 context.
            + **[Transducers with Observable Sequences](https://xgrommx.github.io/rx-book/content/getting_started_with_rxjs/creating_and_querying_observable_sequences/transducers.html)**: A chapter from the RxJS Book describing Transducers.
            + **[Why We Built Xstream](http://staltz.com/why-we-built-xstream.html)**: The authors needed a stream library tailored for Cycle.js. It needs to be “hot” only, small in kB size and it should have only a few and intuitive operators.
    + **Routing**: A routing system parses a string input (usually a URL) and decides which action should be executed by matching the string against multiple patterns.
        + **[A JavaScript router in 20 lines](http://joakim.beng.se/blog/posts/a-javascript-router-in-20-lines.html)**: Joakim Carlstein shows how to write a simple router with data binding.
        + **[Crossroads.js](http://millermedeiros.github.io/crossroads.js/)**: Crossroads.js is a powerful and flexible routing system. If used properly it can reduce code complexity by decoupling objects and also by abstracting navigation paths and server requests.
        + **[Director](https://github.com/flatiron/director)**: A tiny and isomorphic URL router for JavaScript.
        + **[Encapsulated Routing with Elements](https://www.polymer-project.org/1.0/blog/routing)**: Peter Burns describes a routing approach based on Polymer elements, that allow to create chained and modular routes.
        + **[Hash.js](https://github.com/javve/hash.js)**: Hash.js is a 0.5 KB script that lets you manipulate everything behind # in urls.
        + **[JQuery Address](http://www.asual.com/jquery/address/)**: The jQuery Address plugin provides powerful deep linking capabilities and allows the creation of unique virtual addresses that can point to a website section or an application state.
        + **[Page.js](https://github.com/visionmedia/page.js)**: Micro client-side router inspired by the Express router.
        + **[Roadcrew.js](http://grobmeier.github.io/Roadcrew.js/)**: Roadcrew.js is a small JavaScript component which lets you switch pages of a single file website.
        + **[Route Recognizer](https://github.com/tildeio/route-recognizer)**: A lightweight JavaScript library that matches paths against registered routes. It includes support for dynamic and star segments and nested handlers.
        + **[Router.js (Ember)](https://github.com/tildeio/router.js)**: Router.js is the routing microlib used by Ember.js.
        + **[Router5](https://github.com/router5/router5)**: A simple, powerful, modular and extensible router, organising your named routes in a tree and handling route transitions. In its simplest form, Router5 processes routing instructions and outputs state updates.
    + **UI Data Binding**: Binding of UI elements to an application domain model. Most frameworks employ the Observer pattern as the underlying binding mechanism.
        + **[Bindings in Ember](https://guides.emberjs.com/v2.6.0/object-model/bindings/)**: Unlike most other frameworks that include some sort of binding implementation, bindings in Ember.js can be used with any object.
        + **[Change And Its Detection In JavaScript Frameworks](http://teropa.info/blog/2015/03/02/change-and-its-detection-in-javascript-frameworks.html)**: This article explores several approaches to manage state: Ember's data binding, Angular's dirty checking, React's virtual DOM, and its relationship to immutable data structures.
        + **[Easy Two-Way Data Binding in JavaScript](http://www.lucaongaro.eu/blog/2012/12/02/easy-two-way-data-binding-in-javascript/)**: Two-way data binding refers to the ability to bind changes to an object’s properties to changes in the UI, and viceversa. This article describes how to implement data binding with vanilla JavaScript.
        + **[Functional Reactive Bindings](https://github.com/kriskowal/frb)**: A CommonJS package that includes functional and generic building blocks to help incrementally ensure consistent state.
        + **[Knockout.js](http://knockoutjs.com/)**: Knockout is a standalone JavaScript implementation of the Model-View-ViewModel pattern with templates.
        + **[Rivets.js](http://rivetsjs.com/)**: Lightweight and powerful data binding + templating solution for building modern web applications.
        + **[Synapse](https://github.com/bruth/synapse/)**: Hooks to support data binding between virtually any object.
    + **Unidirectional Data Flow**: An architecture design pattern which promotes a flow of data and events in a single direction, usually creating an interactive loop.
        + **[Flux](https://facebook.github.io/flux/)**: Flux is the application architecture that Facebook uses for building client-side web applications. It complements React's composable view components by utilizing a unidirectional data flow. It's more of a pattern rather than a formal framework, and you can start using Flux immediately without a lot of new code.
            + **[Fluxiny](https://github.com/krasimir/fluxiny)**: ~1K implementation of flux architecture
        + **[Immutable User Interfaces](https://vimeo.com/album/3953264/video/166790294)**: Lee Byron talks about unidirectional data flow architectures based on immutable data structures in contrast to traditional MVC based designs.
            + **[Immutable.js](https://github.com/facebook/immutable-js/)**: Immutable persistent data collections for Javascript which increase efficiency and simplicity.
        + **[MobX](https://github.com/mobxjs/mobx)**: MobX is a battle tested library that makes state management simple and scalable by transparently applying functional reactive programming.
        + **Model-View-Intent (MVI)**: MVI is a unidirectional data flow architecture pattern consisting of three parts: Intent (to listen to the user), Model (to process information), and View (to output back to the user).
            + **[MVI in Cycle.js Docs](http://cycle.js.org/model-view-intent.html)**: André Staltz describes how to refactor an application into MVI pattern.
            + **[Model-View-Intent with React and RxJS](https://satishchilukuri.com/blog/entry/model-view-intent-with-react-and-rxjs)**: Satish Chilukuri shows an example implementation of MVI pattern with React.
            + **[Reactive MVC and the Virtual DOM](http://futurice.com/blog/reactive-mvc-and-the-virtual-dom)**: André Staltz describes the idea of Reactive Programming vs. Interactive Programming, proceeds with the MVI design pattern and compares it to React/Flux.
            + **[What Developers Need to Know about MVI (Model-View-Intent)](http://thenewstack.io/developers-need-know-mvi-model-view-intent/)**: The article explains the general MVI pattern and how it relates to React, Reactive Programming and Cycle.js
        + **[Nothing New in React and Flux Except One Thing](http://staltz.com/nothing-new-in-react-and-flux-except-one-thing.html)**: Andre Staltz talks about aspects of React and Flux which make them innovative and compelling.
        + **[Redux](http://redux.js.org/)**: Redux is a predictable state container for JavaScript apps. It attempts to make state mutations predictable by imposing certain restrictions on how and when updates can happen.
            + **[Building Redux in TypeScript with Angular 2](http://blog.ng-book.com/introduction-to-redux-with-typescript-and-angular-2/)**: In this post we’re going to discuss the ideas behind Redux. How to build our own mini version of the Redux Store and hook it up to Angular 2.
            + **[Exploring Redux Middleware](http://blog.krawaller.se/posts/exploring-redux-middleware/)**: The author explains how to author your own middleware for Redux. He dives into the execution path of each middleware function in the chain and shows some examples.
            + **[Full-Stack Redux Tutorial](http://teropa.info/blog/2015/09/10/full-stack-redux-tutorial.html)**: We will go through all the steps of constructing a Node+Redux backend and a React+Redux frontend for a real-world application, using test-first development.
            + **[Immutable.js](https://github.com/facebook/immutable-js/)**: Immutable persistent data collections for Javascript which increase efficiency and simplicity.
            + **[Learn Redux](https://youtu.be/hmwBow1PUuo)**: A video series by Wes Bos, teaching Redux. From setting up Webpack to using Dev Tools.
            + **[Normalizr](https://github.com/paularmstrong/normalizr)**: Normalizes deeply nested JSON API responses according to a schema for Flux and Redux apps.
            + **[Redux Actions](https://github.com/acdlite/redux-actions)**: Flux Standard Action utilities for Redux.
            + **[Redux Form](https://github.com/erikras/redux-form)**: A Higher Order Component using react-redux to keep form state in a Redux store.
            + **[Redux Loop](https://github.com/raisemarketplace/redux-loop)**: A port of elm-effects and the Elm Architecture to Redux that allows you to sequence your effects naturally and purely by returning them from your reducers.
            + **[Redux Saga](https://github.com/yelouafi/redux-saga)**: An alternative Side Effects middleware for Redux applications. Instead of dispatching Thunks which get handled by the redux-thunk middleware, you create Sagas to gather all your Side Effects logic in a central place.
            + **[Redux Tutorial](https://github.com/happypoulp/redux-tutorial)**: This repository contains a step by step tutorial to help grasp flux and more specifically Redux.
            + **[Reinventing Flux - Interview with Dan Abramov](http://survivejs.com/blog/redux-interview/)**: Dan talks about why he developed Redux.
            + **[Reselect](https://github.com/reactjs/reselect)**: Simple “selector” library for Redux inspired by getters in NuclearJS and subscriptions in re-frame.
            + **[Some Problems with React/Redux](http://staltz.com/some-problems-with-react-redux.html)**: André Staltz goes through the pros and cons of React + Redux.
            + **[Testing a React & Redux Codebase](http://silvenon.com/testing-react-and-redux/)**: This series aims to be a very comprehensive guide through testing a React and Redux codebase, where you can really cover a lot with just unit tests because the code is mostly universal.
            + **[The Redux Ecosystem](https://medium.com/@denisraslov/the-redux-ecosystem-539c630ec521)**: Let’s take a look at most of the features that you’ll have to deal with when the time comes, — and where React & Redux themselves can’t help you.
            + **[The Redux Journey at react-europe 2016](https://www.youtube.com/watch?v=uvAXVMwHJXU)**: In this talk, Dan Abramov reflects on the past, present, and future of Redux.
            + **[The SoundCloud Client in React + Redux](http://www.robinwieruch.de/the-soundcloud-client-in-react-redux/)**: After finishing this step by step tutorial you will be able to author your own React + Redux project with Webpack and Babel.
            + **[Tic-Tac-Toe.js: Redux Pattern in Plain JavaScript](http://ramonvictor.github.io/tic-tac-toe-js/)**: Ramon Victor describes how to use Redux with vanilla JavaScript. No React, no jQuery, no micro-library, it doesn't rely on anything else. It's just plain JS.
            + **[Understanding Redux Middleware](https://medium.com/@meagle/understanding-87566abcfb7a)**: The author describes the functional programming concepts involved in the creation and application of middleware functions.
        + **[Unidirectional Data Flow Architectures (Talk)](https://vimeo.com/168652278)**: Andre Staltz compares modern architecture patterns including Flux, Redux, Model-View-Intent, Elm Arch and BEST.
+ **Designs**: Ready to use and well documented structures and frameworks for frontend development.
    + **[Atomic Design](http://atomicdesign.bradfrost.com/table-of-contents/)**: Atomic Design discusses the importance of crafting robust design systems, and introduces a methodology for which to create smart, deliberate interface systems.
        + **[A More Seamless Workflow — Style Guides for Better Design and Development](https://medium.com/@AshConnolly/a-more-seamless-workflow-style-guides-for-better-design-and-development-639fc55be28c)**: Ash Connolly explains what styles guides are and which benefits they bring to designers and developers.
        + **[Atomic Docs](http://atomicdocs.io/)**: Atomic Docs is a styleguide generator and component manager. Atomic Docs is built in PHP. Inspired by Brad Frost's Atomic Design principles.
        + **[Atomic Lab](http://steelydylan.github.io/atomic-lab/)**: Template sharing and coding environment based on atomic design.
    + **Authoring jQuery Plugins**: jQuery is an utility library and a plugin framework. This section collects resources about creating such plugins.
        + **[Advanced Plugin Concepts](http://learn.jquery.com/plugins/advanced-plugin-concepts/)**: A collection of best practices for jQuery plugin authoring.
        + **[How to Create a Basic Plugin](http://learn.jquery.com/plugins/basic-plugin-creation/)**: The article describes basic plugin creation and provides a simple boilerplate.
        + **[Signs of a poorly written jQuery plugin](https://remysharp.com/2010/06/03/signs-of-a-poorly-written-jquery-plugin)**: Collection of jQuery plugin antipatterns.
        + **[The Ultimate Guide to Writing jQuery Plugins](https://websanova.com/blog/jquery/the-ultimate-guide-to-writing-jquery-plugins)**: A comprehensive guide on how to develop jQuery plugins including a simple boilerplate.
        + **[Writing Stateful Plugins with the jQuery UI Widget Factory](http://learn.jquery.com/plugins/stateful-plugins-with-widget-factory/)**: The article demonstrates the capabilities of the Widget Factory by building a simple progress bar plugin.
        + **[jQuery Boilerplate](https://github.com/jquery-boilerplate/jquery-boilerplate)**: This project won't seek to provide a perfect solution to every possible pattern, but will attempt to cover a simple template for beginners and above.
        + **[jQuery Plugin Patterns](https://github.com/jquery-boilerplate/jquery-patterns)**: This project won't seek to provide implementations for every possible pattern, but will attempt to cover popular patterns developers often use in the wild.
    + **[Block Element Modifier (BEM)](https://en.bem.info/method/)**: Methodology aimed at achieving fast to develop long-lived projects, team scalability, and code reuse.
        + **[A New Front-End Methodology: BEM](http://www.smashingmagazine.com/2012/04/a-new-front-end-methodology-bem/)**: An introduction by Varvara Stepanova at SmashingMagazine.
        + **[An Introduction to the BEM Methodology](http://webdesign.tutsplus.com/articles/an-introduction-to-the-bem-methodology--cms-19403)**: General introduction article on tutsplus.
        + **[BEM 101](https://css-tricks.com/bem-101/)**: A collaborative post by Joe Richardson, Robin Rendle, and CSS-Tricks staff giving an introduction to BEM with some good examples.
        + **[BEM I (finally) understand](https://m.alphasights.com/bem-i-finally-understand-b0c74815d5b0)**: In this article Andrei Popa will focus on the basics of BEM and how to approach simple to complex anatomies.
        + **[Battling BEM (Extended Edition): 10 Common Problems And How To Avoid Them](https://www.smashingmagazine.com/2016/06/battling-bem-extended-edition-common-problems-and-how-to-avoid-them/)**: This article aims to be useful for people who are already BEM enthusiasts and wish to use it more effectively or people who are curious to learn more about it.
        + **[Block, Element, Modifying Your JavaScript Components](https://medium.com/seek-ui-engineering/block-element-modifying-your-javascript-components-d7f99fcab52b)**: Mark Dalgleish is discussing how to organize React code with BEM and build everything with Webpack.
        + **[Emmet filter for BEM](http://docs.emmet.io/filters/bem/)**: If you’re writing your HTML and CSS code in OOCSS-style, Yandex’s BEM style specifically, you will like this filter. It provides some aliases and automatic insertions of common block and element names in classes.
        + **[Fifty Shades of BEM](http://blog.kaelig.fr/post/48196348743/fifty-shades-of-bem)**: Article describes different flavors of BEM.
        + **[How We Use BEM to Modularise Our CSS](https://m.alphasights.com/how-we-use-bem-to-modularise-our-css-82a0c39463b0)**: Andrei Popa describes the challenges, AlphaSights team had, implementing BEM in their projects.
        + **[Introduction To BEM Methodology (Toptal)](https://www.toptal.com/css/introduction-to-bem-methodology)**: General introduction to BEM methodology and platform.
        + **[MindBEMding – getting your head ’round BEM syntax](http://csswizardry.com/2013/01/mindbemding-getting-your-head-round-bem-syntax/)**: Article on csswizardry explaining the BEM syntax for CSS classes.
        + **[Pobem](https://github.com/bem-contrib/pobem)**: PostCSS plugin for BEM syntax.
        + **[Support for BEM modules in Sass 3.3](http://mikefowler.me/2013/10/17/support-for-bem-modules-sass-3.3/)**: The next major release of Sass is poised for release and with it comes real support for BEM-style modules...
        + **[To BEM or not to BEM](http://www.didoo.net/to-bem-or-not-to-bem/)**: A series of interviews on BEM methodology.
    + **[Cycle.js](http://cycle.js.org/)**: A functional and reactive JavaScript framework that solves the cyclic dependency of Observables which emerge during dialogues (mutual observations) between the Human and the Computer.
        + **[Async Driver](https://github.com/whitecolor/cycle-async-driver)**: Higher order factory for creating cycle.js async request based drivers. Allows you almost completely eliminate boilerplate code for this kind of drivers.
        + **[Cycle.js Was Built to Solve Problems](https://www.youtube.com/watch?v=Rj8ZTRVka4E)**: In this video André Staltz shows how Cycle.js has a practical purpose, meant to solve problems your customers/business may relate to.
        + **[Cycle.js and Functional Reactive User Interfaces](https://www.youtube.com/watch?v=uNZnftSksYg)**: In this talk we will discover how Cycle.js is purely reactive and functional, and why it's an interesting alternative to React.
        + **[Draw Cycle](https://glebbahmutov.com/draw-cycle/)**: Simple Cycle.js program visualized
        + **[Drivers](http://cycle.js.org/drivers.html)**: Drivers are functions that listen to Observable sinks (their input), perform imperative side effects, and may return Observable sources (their output).
            + **[Animation](https://github.com/Widdershin/cycle-animation-driver)**: A Cycle driver for requestAnimationFrame.
            + **[Audio Graph Driver](https://github.com/benji6/cycle-audio-graph)**: Audio graph driver for Cycle.js based on virtual-audio-graph.
            + **[Cookie](https://github.com/10clouds/cyclejs-cookie)**: Cycle.js Cookie Driver, based on cookie_js library.
            + **[DOM](https://github.com/cyclejs/dom)**: The standard DOM Driver for Cycle.js based on virtual-dom, and other helpers.
            + **[Fetch](https://github.com/secobarbital/cycle-fetch-driver)**: A Cycle.js Driver for making HTTP requests, using the Fetch API.
            + **[Fetcher](https://github.com/r7kamura/cycle-fetcher-driver)**: A Cycle.js Driver for making HTTP requests using stackable-fetcher.
            + **[Firebase](https://github.com/dralletje/cycle-firebase)**: Thin layer around the firebase javascript API that allows you to query and declaratively update your favorite real-time database.
            + **[HTTP](https://github.com/cyclejs/http)**: A Cycle.js Driver for making HTTP requests, based on superagent.
            + **[Hammer.js](https://github.com/CyclicMaterials/cycle-hammer-driver)**: The driver incorporates the Hammer.js gesture library.
            + **[History](https://github.com/cyclejs/history)**: Cycle.js URL Driver based on the rackt/history library.
            + **[Keys](https://github.com/raquelxmoss/cycle-keys)**: A Cycle.js driver for keyboard events.
            + **[Mongoose.js](https://github.com/whitecolor/cycle-mongoose/)**: A driver for using Mongoose with Cycle JS. Accepts both, write and read operations.
            + **[Notification](https://github.com/cyclejs/cycle-notification-driver)**: A Cycle.js Driver for showing and responding to HTML5 Notifications.
            + **[Router](https://github.com/TylorS/cycle-router)**: A router built from the ground up with Cycle.js in mind. Stands on the shoulders of battle-tested libraries switch-path for route matching and rackt/history for dealing with the History API.
            + **[Router5](https://github.com/axefrog/cycle-router5)**: A source/sink router driver for Cycle.js, based on router5.
            + **[Server-Sent Events](https://github.com/jessaustin/cycle-sse-driver)**: Cycle.js driver for Server-Sent Events (SSE), a browser feature also known as EventSource. Server-Sent Events allow the server to continuously update the page with new events, without resorting to hacks like long-polling.
            + **[Snabbdom](https://github.com/TylorS/cycle-snabbdom)**: Alternative DOM driver utilizing the snabbdom library.
            + **[Socket.IO](https://github.com/cgeorg/cycle-socket.io)**: A Cycle driver for applications using Socket.IO
            + **[Storage](https://github.com/cyclejs/storage)**: A Cycle.js Driver for using localStorage and sessionStorage in the browser.
        + **Example Projects**: Example applications built with Cycle.js
            + **[Cycle.js Examples](https://github.com/cyclejs/examples)**: Browse and learn from examples of small Cycle.js apps using Core, DOM Driver, HTML Driver, HTTP Driver, JSONP Driver, and others.
            + **[RX Marbles](https://github.com/staltz/rxmarbles)**: Interactive diagrams of Rx Observables.
            + **[TODO: Minimum Viable Pizza](https://github.com/cgeorg/todomvp)**: Minimum Viable Pizza implemented with Cycle.js
            + **[Tricycle](https://github.com/Widdershin/tricycle)**: A scratchpad for trying out Cycle.js.
        + **[Intro to Functional Reactive Programming with Cycle.js](https://www.youtube.com/watch?v=6_ETUyh0tns)**: Nick Johnstone gives an introduction to developing with Cycle.js in this video presentation.
        + **[Learning How to Ride: an Introduction to Cycle.js](https://www.youtube.com/watch?v=31URmaeNHSs)**: In this talk, Fernando Macias Pereznieto introduces us to the good, the bad, and the beautiful of using Cycle.js, whether you are a complete beginner or an experienced JS ninja.
        + **[Motorcycle.js](https://github.com/motorcyclejs/core)**: This is a sister project that will continue to evolve and grow alongside Cycle.js for the foreseeable future. The primary focus of this project is to tune it for performance as much as possible.
            + **[Most](https://github.com/cujojs/most)**: Monadic reactive streams with high performance.
        + **[Plug and Play All Your Observable Streams With Cycle.js](https://medium.com/@fkrautwald/plug-and-play-all-your-observable-streams-with-cycle-js-e543fc287872)**: Frederik Krautwald explains the principles behind Cycle.js, it's inner workings and how to use it to create a simple program with drivers.
        + **[Tricycle](https://github.com/Widdershin/tricycle)**: A scratchpad for trying out Cycle.js.
        + **[What Developers Need to Know about MVI (Model-View-Intent)](http://thenewstack.io/developers-need-know-mvi-model-view-intent/)**: The article explains the general MVI pattern and how it relates to React, Reactive Programming and Cycle.js
    + **[Polymer Project](https://www.polymer-project.org/1.0/docs/devguide/feature-overview.html)**: The Polymer library is designed to make it easier and faster for developers to create great, reusable components for the modern web.
        + **[Building web components using ES6 classes](https://www.polymer-project.org/1.0/articles/es6.html)**: Web components evolve markup into something that’s meaningful, maintainable, and highly modular. Thanks to these new API primitives, not only do we have improved ergonomics when building apps, but we gain better overall structure, design, and reusability.
        + **[Developing Front-End Microservices](https://technologyconversations.com/2015/08/09/developing-front-end-microservices-with-polymer-web-components-and-test-driven-development-part-15-the-first-component/)**: In this article series we’ll go through Web Components development in context of microservices.
        + **[Lazy Loading of Pages](https://github.com/TimvdLippe/iron-lazy-pages)**: iron-lazy-pages is a Polymer component which allows to load pages on demand.
        + **[ShadowDOM Visualizer](http://html5-demos.appspot.com/shadowdom-visualizer)**: This tools allows you to visualize how Shadow DOM renders in the browser.
        + **[Thinking in Polymer (The Polymer Summit 2015)](https://www.youtube.com/watch?v=ZDjiUmx51y8)**: Kevin Schaaf explains how to employ data binding and composition to build complex application using only Polymer.
        + **[Unidirectional Dataflow Architecture with Polymer + RxJS + Immutable Data](https://medium.com/@richardanaya/unidirectional-data-architecture-with-polymer-rxjs-immutable-data-c689386ee998)**: Richard Anaya describes how to combine Polymer, RxJS and Freezer to implement a unidirectional data flow architecture.
        + **[Using Elements](https://elements.polymer-project.org/guides/using-elements)**: This guide describes how to install and use standalone Polymer components in an existing project.
        + **[Using Polymer with Flux and a Global App State](http://paulusschoutsen.nl/blog/2015/07/using-polymer-with-flux-and-a-global-app-state/)**: Paulus Schoutsen describes his experience integrating Polymer and NuclearJS.
        + **[What is shady DOM?](https://www.polymer-project.org/1.0/articles/shadydom.html)**: On browsers that support shadow DOM, it’s possible to have an element that is rendered with complex DOM, but have that complexity hidden away as implementation detail.
    + **[SMACSS](https://smacss.com/book/)**: SMACSS (pronounced “smacks”) is a way to examine your design process and as a way to fit those rigid frameworks into a flexible thought process. It is an attempt to document a consistent approach to site development when using CSS.
    + **[T3](http://t3js.org/)**: T3 is a minimalist JavaScript framework sponsored by Box Inc. that provides core structure to code.
    + **[The Elm Architecture](http://guide.elm-lang.org/architecture/index.html)**: The Elm Architecture is a simple pattern for infinitely nestable components. It is great for modularity, code reuse, and testing.
    + **[TodoMVC](http://todomvc.com/)**: A project which offers the same Todo application implemented using MV* concepts in most of the popular JavaScript MV* frameworks of today.
+ **Event-Driven Programming**: Event-driven programming is a programming paradigm in which the flow of the program is determined by events such as user actions, sensor outputs, or messages from other programs/threads.
    + **[Comparison Between Different Observer Pattern Implementations](https://github.com/millermedeiros/js-signals/wiki/Comparison-between-different-Observer-Pattern-implementations)**: The comparison below is just about the basic features of subscribing to an event type, dispatching and removing an event listener.
    + **[Event Emitter, Pub Sub or Deferred Promises](https://otaqui.com/blog/1374/event-emitter-pub-sub-or-deferred-promises-which-should-you-choose/)**: In this post Pete Otaqui explores a little about how each pattern works with (very) basic implementations and looks at the reasons why you might choose one over another.
    + **Implementations**: Libraries, frameworks and tools that use Event-Driven Programming paradigm.
        + **[Bacon.js](https://baconjs.github.io/)**: A small functional reactive programming lib for JavaScript. Turns your event spaghetti into clean and declarative feng shui bacon, by switching from imperative to functional.
        + **[Flight](http://flightjs.github.io/)**: An event-driven web framework, from Twitter.
        + **[Mediator.js](http://thejacklawson.com/Mediator.js/)**: Mediator is a simple class that allows you to register, unregister, and call subscriber methods to help event-based, asyncronous programming.
        + **[Postal.js](https://github.com/postaljs/postal.js)**: Postal.js takes the familiar "eventing-style" paradigm and extends it by providing "broker" and subscriber implementations
        + **[Radio.js](http://radio.uxder.com/)**: Radio.js is a small dependency-free publish/subscribe JavaScript library. Use it to implement the observer pattern in your code to help decouple your application architecture for greater maintainability.
        + **[js-signals](http://millermedeiros.github.io/js-signals/)**: Custom Event/Messaging system for JavaScript.
        + **[pubsub.js](https://github.com/federico-lox/pubsub.js)**: A tiny (~600 bytes when minified, ~300 bytes when gzip'd) and robust pubsub implementation.
+ **Functional Programming**: Functional programming is a programming paradigm, that treats computation as the evaluation of mathematical functions and avoids changing-state and mutable data.
    + **A Gentle Introduction to Functional JavaScript**: A 3 part series, by Derick Bailey featuring Chet Harrison, about functional programming with many examples in JavaScript.
        + **[Monads, Monoids and Composition with Functional JavaScript](https://www.youtube.com/watch?v=ZQSU4geXAxM)**: Chet Harrison explains monads using form validation as an example.
        + **[Notes and Code from the Crowdcast](https://github.com/ChetHarrison/A-Gentle-Introduction-to-Functional-JavaScript)**: Chet Harrison provides a broad overview of functional programming concepts and a step by step tutorial for building Monads.
        + **[The Basics of Functional Programming](https://www.youtube.com/watch?v=myISHtMMeyU)**: In this first episode, you'll learn the basics of why functional programming, what it is, where it came from and what the core of it is. You'll see function composition, function purity, currying, higher order functions and first-class functions.
    + **[A Million Ways to Fold in JS](https://www.youtube.com/watch?v=JZSoPZUoR58)**: Brian Lonsdorf provides many functional alternatives to loops in this video.
    + **[Adventures in Functional Programming](https://vimeo.com/45140590)**: A talk by Jim Weirich, demonstrating how to use functional programming and lambda calculus to derive Y combinator.
    + **[Allong.es](http://allong.es/)**: allong.es is a JavaScript library based on the function combinator and decorator recipes introduced in the book JavaScript Allongé.
    + **[Barely Functional](https://github.com/cullophid/barely-functional)**: Tiny (2.7kb) functional programming library using native es5/6 operations.
    + **[Basic Lazy Evaluation and Memoization in JavaScript](http://blog.gypsydave5.com/2015/03/21/lazy-eval-and-memo/)**: Memoization is a way of optimizing code so that it will return cached results for the same inputs.
    + **[Bilby.js](http://bilby.brianmckenna.org/)**: A functional library based on category theory with immutable multimethods, functional data structures, functional operator overloading, automated specification testing.
    + **[Composability: from Callbacks to Categories in ES6](https://medium.com/@homam/composability-from-callbacks-to-categories-in-es6-f3d91e62451e)**: The author borrows some ideas from functional languages to explore a different approach for addressing the callback hell.
    + **[Curry or Partial Application?](https://medium.com/javascript-scene/curry-or-partial-application-8150044c78b8)**: Eric Elliott describes the difference between partial application and curry.
    + **[Daggy](https://github.com/puffnfresh/daggy)**: Library for creating tagged constructors with catamorphism.
    + **[Date FP](https://github.com/cullophid/date-fp)**: Functional programming date manipulation library.
    + **[Debugging Functional](https://medium.com/@drboolean/debugging-functional-7deb4688a08c)**: This post will demonstrate a simple solution that can go a long way to enhance the debugging experience in functional JavaScript applications.
    + **[Deterministic](https://deterministic.curated.co/)**: A weekly digest of interesting news and articles covering functional programming for the web, especially on the front end.
    + **Example Projects**: Open source projects which use functional programming, preferably point-free and side-effect-free.
        + **[Async Problem](https://github.com/plaid/async-problem)**: This project considers various approaches to the problem of concurrently reading files inside a directory and concatenating their contents.
        + **[CommonJS module dependencies resolver](https://github.com/iamstarkov/es-deps-deep)**: The module and all related modules are written using point-free style.
        + **[Egg Hunt Server](https://github.com/Bradcomp/egghunt-server/tree/functional)**: A restful API written in FP style.
        + **[Idealist](https://github.com/Avaq/Idealist)**: Functional HTTP micro-framework.
        + **[Sanctuary Build Script](https://github.com/sanctuary-js/sanctuary-site/blob/gh-pages/scripts/generate)**: A build script for generating the Sanctuary website.
    + **[FP DOM](https://github.com/fp-dom/fp-dom)**: A collection of functions to favor functional programming in a DOM context.
    + **[Fantasy Combinators](https://github.com/fantasyland/fantasy-combinators)**: Combinators which are used for fantasy-land projects.
    + **[Fantasy Land](https://github.com/fantasyland/fantasy-land)**: Specification for interoperability of common algebraic structures in JavaScript.
        + **[Conformant Implementations](https://github.com/fantasyland/fantasy-land/blob/master/implementations.md)**: A list of libraries implementing the Fantasy Land specification.
    + **[Fantasy Lenses](https://github.com/fantasyland/fantasy-lenses)**: Composable, immutable getters and setters.
    + **[Functional Concepts For JavaScript Developers: Currying](https://blog.simpleblend.net/functional-javascript-concepts-currying/)**: Andrew Robbins talks about what currying is and why it's useful.
    + **[Functional Core Reactive Shell](http://www.mokacoding.com/blog/functional-core-reactive-shell/)**: Giovanni Lodi makes an overview of different architecture meta-patterns and describes his current findings about functional programming and observables as a way to control side effects.
    + **[Functional Frontend Architecture](https://github.com/paldepind/functional-frontend-architecture)**: This repository is meant to document and explore the implementation of what is known as "the Elm architecture". A simple functional architecture for building frontend applications.
    + **[Functional JavaScript Mini Book](https://jcouyang.gitbooks.io/functional-javascript/content/en/index.html)**: Jichao Ouyang gives and introduction to functional programming with JavaScript and describes some Typeclasses like Functor and Monad.
    + **[Functional Javascript Workshop](https://github.com/timoxley/functional-javascript-workshop)**: The goal of this workshop is to create realistic problems that can be solved using terse, vanilla, idiomatic JavaScript.
    + **[Functional Principles In React](https://www.youtube.com/watch?v=1uRC3hmKQnM)**: Jessica Kerr talks about four functional principles: Composition, Declarative Style, Isolation and Flow Of Data, and their usage in React.
    + **[Functional Programming Jargon](https://github.com/hemanth/functional-programming-jargon)**: Jargon from the functional programming world in simple terms.
    + **[Functional Programming for JavaScript People](https://medium.com/@chetcorcos/functional-programming-for-javascript-people-1915d8775504)**: Chet Corcos explains different features of functional programming like composition, currying, lazy evaluation, referential transparency and compares Clojure with Haskell.
    + **[Functional Refactoring in JavaScript](http://victorsavkin.com/post/63551894251/functional-refactoring-in-javascript)**: In this article Victor Savkin shows how to apply functional thinking when refactoring JavaScript code. He does that by taking a simple function and transforming it into a more extendable one, which has no mutable state, and no if statements.
    + **[Functional.js](http://functionaljs.com/)**: Functional.js is a functional JavaScript library. It facilitates currying and point-free / tacit programming and this methodology has been adhered to from the ground up.
    + **[Functionize](https://github.com/paldepind/functionize)**: A collection of functions which aids in making non-functional libraries functional.
    + **[Futures and Monoids](https://medium.com/@yelouafi/futures-and-monoids-7e9f4574bd88)**: Yassine Elouafi explains the nature of Monoids using Futures, Numbers and Strings as examples.
    + **[Hey Underscore, You're Doing It Wrong!](http://functionaltalks.org/2013/05/27/brian-lonsdorf-hey-underscore-youre-doing-it-wrong/)**: In this talk Brian Lonsdorf gently takes a shot at underscore.js for not thinking about currying and partial function application in its library design.
    + **[Immutability, Interactivity & JavaScript](https://www.youtube.com/watch?v=mS264h8KGwk)**: We'll dive in and see how trees of JavaScript arrays can permit building efficient immutable collections. Then we'll see how embracing immutable values dramatically simplifies some classic hard problems in client side programming including but not limited to undo, error playback, and online/offline synchronization.
    + **[Immutable Sequence.js](https://github.com/qiao/immutable-sequence.js)**: High performance implementation of Immutable Sequence in JavaScript, based on Finger Tree.
    + **[Immutable.js](https://github.com/facebook/immutable-js/)**: Immutable persistent data collections for Javascript which increase efficiency and simplicity.
    + **[JSAir - Functional and Immutable Design Patterns in JavaScript](https://javascriptair.com/episodes/2015-12-30/)**: An episode of JavaScript Air about "the how and why of functional programming and immutable design patterns in JavaScript" with Dab Abramov and Brian Lonsdorf as guests.
    + **[JavaScript and Type Thinking](https://medium.com/@yelouafi/javascript-and-type-thinking-735edddc388d)**: Yassine Elouafi introduces Algebraic Data Types with an example of a simple and a recursive type.
    + **[Javascript Combinators by Reginald Braithwaite](https://vimeo.com/97408202)**: In this talk, we'll explore functions that consume and return functions, and see how they can be used to build expressive programs that hew closely to JavaScript's natural style.
    + **[Lamda.js](https://github.com/loop-recur/lambdajs)**: This library takes all the methods on instances of strings, arrays, objects, numbers, and regexp's and turns them into functions that can be used in a pointfree way.
    + **[Lenses Quick n’ Dirty](https://vimeo.com/104807358)**: A video by Brian Lonsdorf that introduces lenses.
    + **[Lenses and Virtual DOM Support Open Closed](http://joneshf.github.io/programming/2015/12/19/Lenses-and-Virtual-DOM-Support-Open-Closed.html)**: Hardy Jones explains how Lenses work using a simple example of working with Virtual DOM.
    + **[Lenses.js](https://github.com/DrBoolean/lenses)**: Composable kmett style lenses.
    + **[Lodash/fp](https://github.com/lodash/lodash/wiki/FP-Guide)**: The lodash/fp module is an instance of lodash with its methods wrapped to produce immutable auto-curried iteratee-first data-last methods.
    + **[Making your JavaScript Pure](http://alistapart.com/article/making-your-javascript-pure)**: Jack Franklin compares pure and impure functions and describes how to leverage functional programming principles in JavaScript.
    + **Monads**: Composable computation descriptions. The essence of monad is thus separation of composition timeline from the composed computation's execution timeline, as well as the ability of computation to implicitly carry extra data.
        + **Collections of Monads**: Libraries of monad implementations.
            + **[Akh](http://akh-js.com/)**: Akh includes a basic set of common monad transformers, along with monads derived from these transformers. Akh structures implement the Fantasy Land specification.
            + **[Folktale](http://folktale.origamitower.com)**: Folktale is a suite of libraries for generic functional programming in JavaScript that allows you to write elegant modular applications with fewer bugs, and more reuse.
            + **[Monet.js](https://github.com/cwmyers/monet.js)**: Monet is a tool bag that assists Functional Programming by providing a rich set of Monads and other useful functions.
        + **Continuation Monad**: Represents computations in continuation-passing style (CPS). In continuation-passing style function result is not returned, but instead is passed to another function, received as a parameter (continuation).
            + **[The Delimited Continuation Monad in Javascript](http://blog.mattbierner.com/the-delimited-continuation-monad-in-javascript/)**: This post overviews continuations in Atum and covers the implementation of the delimited continuation monad in JavaScript.
        + **Either Monad**: The Either type represents values with two possibilities: a value of type Either a b is either Left a or Right b. It is often used for error handling.
            + **[Lazy Either](https://www.npmjs.com/package/lazy-either)**: The LazyEither type is used to represent a lazy Either value. It is similar to the Future and Promise types.
            + **[Practical Intro to Monads in JavaScript: Either](https://tech.evojam.com/2016/03/21/practical-intro-to-monads-in-javascript-either/)**: Jakub Strojewski describes the Either Monad, a tool for fast-failing, synchronous computation chains.
        + **Free Monad**: A free monad satisfies all the Monad laws, but does not do any computation. It just builds up a nested series of contexts. The user who creates such a free monadic value is responsible for doing something with those nested contexts.
            + **[Fantasy Frees](https://github.com/fantasyland/fantasy-frees)**: An implementation of Coyoneda, Yoneda, Trampoline, Free Monad and Free Applicative with usage examples.
            + **[Free Monad Experiments by Hardy Jones](https://github.com/joneshf/abstractions/tree/master/src)**: Coyoneda, Coproduct, Either, Free, State, AJAX and so on.
            + **[Free Monads Video Series](https://www.youtube.com/watch?v=WH5BrkzGgQY&list=PLK_hdtAJ4KqUWp5LJdLOgkD_8qKW0iAHi&index=1)**: A video series on free monads by Brian Lonsdorf explaining Coyoneda, Free Monad and Interpretors.
            + **[Freeky](https://github.com/DrBoolean/freeky)**: Collection of free monads by Brian Lonsdorf.
        + **Futures**: Futures represent the value arising from the success or failure of an asynchronous operation (I/O).
            + **[Fluture](https://github.com/Avaq/Fluture)**: The debuggable Fantasy Land Future library.
            + **[Folktale Task](http://folktale.origamitower.com/api/v2.1.0/en/folktale.concurrency.task.html)**: A structure for time-dependent values, providing explicit effects for delayed computations, latency, etc.
            + **[From Callback to Future -> Functor -> Monad](https://medium.com/@yelouafi/from-callback-to-future-functor-monad-6c86d9c16cb5)**: Yassine Elouafi goes through a simple implementation of Futures and compares them to Promises.
            + **[Future IO](https://github.com/futurize/future-io)**: A fantasy-land compliant monadic IO library for Node.js.
            + **[Futurizer](https://github.com/arcseldon/futurizer)**: Turn callback-style functions or promises into futures!
        + **Introduction**: Introductory materials about monads.
            + **[Monads in JavaScript](https://curiosity-driven.org/monads-in-javascript)**: This article explains monads and their usage in JavaScript including Identity, Maybe, List, Continuation, Do notation and Chaining.
            + **[Practical Intro to Monads in JavaScript](https://tech.evojam.com/2016/02/22/practical-intro-to-monads-in-javascript/)**: A simple, practical tutorial for JavaScript developers showing how some monads can be used.
            + **[Understanding Monads With JavaScript](http://igstan.ro/posts/2011-05-02-understanding-monads-with-javascript.html)**: The author starts with a problem of dealing with explicit immutable state and solves it with JavaScript using monads.
        + **Maybe Monad**: Using Maybe is a good way to deal with errors or exceptional cases without resorting to drastic measures such as error. It is a simple kind of error monad, where all errors are represented by Nothing. A richer error monad can be built using the Either type.
            + **[A Gentle Intro to Monads … Maybe?](http://sean.voisen.org/blog/2013/10/intro-monads-maybe/)**: A short introduction to Maybe and the world of monads.
            + **[A Monad in Practicality: First-Class Failures](http://robotlolita.me/2013/12/08/a-monad-in-practicality-first-class-failures.html)**: This article shows how the Maybe monad can be used for handling simple failure use cases. It then extrapolates into complex failure scenarios and shows how these cases can be modelled in terms of the Either monad.
            + **[Practical Intro to Monads in JavaScript](https://tech.evojam.com/2016/02/22/practical-intro-to-monads-in-javascript/)**: A simple, practical tutorial for JavaScript developers showing how some monads can be used.
        + **Reader Monad**: Represents a computation, which can read values from a shared environment, pass values from function to function, and execute sub-computations in a modified environment.
            + **[Don’t Fear the Reader](https://passy.svbtle.com/dont-fear-the-reader)**: Pascal Hartig explains how to use the reader monad in JavaScript.
            + **[Fantasy Readers](https://github.com/fantasyland/fantasy-readers)**: Fantasy Land compatible implementation of the Reader Monad.
            + **[LiveCoding Video of Reader Monad Implementation](https://www.livecoding.tv/evilsoft/videos/WojoB-functional-js-reader-monad)**: In this video you will learn how to use and implement a Reader from scratch.
            + **[Monad a Day: Reader](https://vimeo.com/105300347)**: Short video by Brian Lonsdorf about the Reader Monad.
        + **Transformers**: Special types that allow us to roll two monads into a single one that shares the behavior of both.
            + **[Akh](http://akh-js.com/)**: Akh includes a basic set of common monad transformers, along with monads derived from these transformers. Akh structures implement the Fantasy Land specification.
            + **[Fantasy ArrayT](https://github.com/quarterto-archive/fantasy-arrayt)**: Monad transformer for JavaScript Arrays.
            + **[Monad Transformers](https://github.com/boris-marinov/monad-transformers)**: Monad transformers are tricky, they require an excessive amount of type juggling. One of the aims of this package is to reduce the amount of wrapping and unwrapping needed for making a new transformer and to provide an easy way to define and combine transformers.
            + **[Monad Transformers Library](https://github.com/boris-marinov/monad-transformers)**: Practical monad transformers for JS.
        + **Validation Monad**: A disjunction that is appropriate for validating inputs and aggregating failures.
            + **[Folktale Validation](http://folktale.origamitower.com/api/v2.1.0/en/folktale.validation.html)**: Validation Monad implementation of Folktale Library.
            + **[Practical Intro to Monads in JavaScript: Validation](https://tech.evojam.com/2016/04/26/practical-intro-to-monads-in-javascript-validation/)**: Jakub Strojewski shows how to accumulate errors in a simple Validation use case.
    + **[Mori](http://swannodette.github.io/mori/)**: A library for using ClojureScript's persistent data structures and supporting API from the comfort of vanilla JavaScript.
    + **[Mostly Adequate Guide to Functional Programming](https://drboolean.gitbooks.io/mostly-adequate-guide/content/)**: A book by Brian Lonsdorf that introduces algebraic functional programming in JavaScript.
    + **[Nanoscope](http://kovach.me/nanoscope/)**: Nanoscope is a javascript library designed to make complex transformations of data much easier. It is a built on the idea of a functional Lens - a construct that enables focusing on sub-parts of data structures to get and modify.
    + **[Pointfree Fantasy](https://www.npmjs.com/package/pointfree-fantasy)**: Point-free wrappers for fantasy-land. Functions are curried using lodash's curry function, and receive their data last. Gives us aliases with our familar haskell names as well.
    + **[Pointfree Javascript](http://lucasmreis.github.io/blog/pointfree-javascript/)**: In this post Lucas Reis presents what is called pointfree style programming and goes through some common scenarios to demonstrate its benefits.
    + **[Practical Functional Programming: Pick Two](https://www.youtube.com/watch?v=XcS-LdEBUkE)**: James Coglan tries to show in this video how to use functional concepts in daily JavaScript programming.
    + **[Promises + FP = Beautiful Streams](https://medium.com/@yelouafi/promises-fp-beautiful-streams-6f0235c5b179)**: Yassine Elouafi show how to use functional programming and algebraic data types to derive a pure functional definition of reactive programming like streams.
    + **[Pure JavaScript](https://vimeo.com/49384334)**: Christian Johansen shows you how you can up your game by leaving loops behind and embracing functions as the primary unit of abstraction.
    + **[Pure UI](http://rauchg.com/2015/pure-ui/)**: Guillermo Rauch discusses the definition of an application’s UI as a pure function of application state.
    + **[PureScript](http://www.purescript.org/)**: PureScript is a strongly, statically typed language which compiles to JavaScript. It is written in and inspired by Haskell.
    + **[Ramda](http://ramdajs.com/)**: A practical library designed specifically for a functional programming style, one that makes it easy to create functional pipelines, one that never mutates user data.
        + **Practical Ramda - Functional Programming Examples**: Tom MacWright gives some practical examples of Ramda usage.
    + **[Ramda Fantasy](https://github.com/ramda/ramda-fantasy)**: Fantasy Land compatible types for easy integration with Ramda. This is an experimental project and will probably merge with Sanctuary.
    + **[Sanctuary](http://sanctuary.js.org/)**: Sanctuary is a functional programming library inspired by Haskell and PureScript. It depends on and works nicely with Ramda. Sanctuary makes it possible to write safe code without null checks.
        + **[Sanctuary Build Script](https://github.com/sanctuary-js/sanctuary-site/blob/gh-pages/scripts/generate)**: A build script for generating the Sanctuary website.
    + **[The Little Idea of Functional Programming](http://jaysoo.ca/2016/01/13/functional-programming-little-ideas/)**: Jack Hsu tries to take a look at a couple of simple concepts that make up the little idea behind functional programming and to tie the concepts back to code examples in JavaScript.
    + **[Timm](http://guigrpa.github.io/timm/)**: Immutability helpers with fast reads and acceptable writes.
    + **[Transducers](http://blog.cognitect.com/blog/2014/8/6/transducers-are-coming)**: Transducers are a powerful and composable way to build algorithmic transformations that you can reuse in many contexts.
        + **["Transducers" Presentation at Strange Loop](https://www.youtube.com/watch?v=6mTbuzafcII)**: This talk will describe transducers, a new library feature for Clojure (but of interest to other languages) that emphasizes composable, context-free, intermediate-free notions like 'mapping' and 'filtering' and their concrete reuse across all of the contexts above.
        + **[Figuring out what transducers are good for](http://gfxmonk.net/2015/11/25/figuring-out-what-transducers-are-good-for.html)**: Tim Cuthbertson attempts some plausible but detailed examples with Transducers in JavaScript.
        + **Implementations**: Libraries that implement Transducer protocoll and include ready to use transformers.
            + **[Transduce](https://github.com/transduce/transduce)**: Implementation by Kevin Beaty extracted from underarm.
            + **[Transducers-js by Cognitect Labs](https://github.com/cognitect-labs/transducers-js)**: A high performance Transducers implementation for JavaScript by Cognitect Labs.
            + **[Transducers.js Library by James Long](https://github.com/jlongster/transducers.js)**: A small library for generalized transformation of data (inspired by Clojure's transducers)
                + **[Transducers.js Round 2 with Benchmarks](http://jlongster.com/Transducers.js-Round-2-with-Benchmarks)**: Refactored version of Transducers.js, some benchmarks, Laziness, the transformer protocoll.
                + **[Transducers.js: A JavaScript Library for Transformation of Data](http://jlongster.com/Transducers.js--A-JavaScript-Library-for-Transformation-of-Data)**: A post announcing the transducers.js library with some explanation.
        + **[Streaming Logs with Transducers and Ramda](http://simplectic.com/blog/2015/ramda-transducers-logs/)**: In this article we will use Ramda to parse a log file without curly braces (and introduce transducers along the way).
        + **[Transducers Documentation for Clojure](http://clojure.org/reference/transducers)**: Transducers are composable algorithmic transformations. They are independent from the context of their input and output sources and specify only the essence of the transformation in terms of an individual element.
        + **[Transducers Explained: Part 1](http://simplectic.com/blog/2014/transducers-explained-1/)**: An introduction to transducers using JavaScript. We will work from reducing over arrays, to defining transformations as transformers, then incrementally introducing transducers and using them with transduce.
        + **[Transducers Explained: Pipelines](http://simplectic.com/blog/2014/transducers-explained-pipelines/)**: In this article, we will introduce four new transducers: filter, remove, drop and take. We will show how transducers can be composed into pipelines and talk about the order of transformation.
        + **[Transducers are Coming](http://blog.cognitect.com/blog/2014/8/6/transducers-are-coming)**: The first announcement by Rich Hickey.
        + **[Transducers with Observable Sequences](https://xgrommx.github.io/rx-book/content/getting_started_with_rxjs/creating_and_querying_observable_sequences/transducers.html)**: A chapter from the RxJS Book describing Transducers.
        + **[Understanding Transducers in JavaScript](https://medium.com/@roman01la/understanding-transducers-in-javascript-3500d3bd9624#.3lbq6d4yq)**: Roman Liutikov translated code examples from similar Clojure article into JavaScript. So you can still read the article and check code examples here.
    + **[Union Type](https://github.com/paldepind/union-type)**: Union types are a way to group different values together. Union-type is a small JavaScript library for defining and using union types.
+ **Functional Reactive Programming (FRP)**: FRP is a programming paradigm for asynchronous dataflow programming using the building blocks of functional programming.
    + **[A General Theory of Reactivity](https://github.com/kriskowal/gtor)**: Kris Kowal describes popular primitives of Reactive Programming and some use cases.
    + **[A General Theory of Reactivity (Video)](https://www.youtube.com/watch?v=R9CGieinKVo)**: Kris Kowal talks about reactive primitives and their traits.
    + **[Controlling Time and Space](https://www.youtube.com/watch?v=Agu6jipKfYw)**: This talk will quickly cover the basics of FRP, and then go into a couple different formulations of FRP that people are beginning to use. We will explore how these formulations fit together historically and theoretically.
    + **[Cycle.js](http://cycle.js.org/)**: A functional and reactive JavaScript framework that solves the cyclic dependency of Observables which emerge during dialogues (mutual observations) between the Human and the Computer.
        + **[Async Driver](https://github.com/whitecolor/cycle-async-driver)**: Higher order factory for creating cycle.js async request based drivers. Allows you almost completely eliminate boilerplate code for this kind of drivers.
        + **[Cycle.js Was Built to Solve Problems](https://www.youtube.com/watch?v=Rj8ZTRVka4E)**: In this video André Staltz shows how Cycle.js has a practical purpose, meant to solve problems your customers/business may relate to.
        + **[Cycle.js and Functional Reactive User Interfaces](https://www.youtube.com/watch?v=uNZnftSksYg)**: In this talk we will discover how Cycle.js is purely reactive and functional, and why it's an interesting alternative to React.
        + **[Draw Cycle](https://glebbahmutov.com/draw-cycle/)**: Simple Cycle.js program visualized
        + **[Drivers](http://cycle.js.org/drivers.html)**: Drivers are functions that listen to Observable sinks (their input), perform imperative side effects, and may return Observable sources (their output).
            + **[Animation](https://github.com/Widdershin/cycle-animation-driver)**: A Cycle driver for requestAnimationFrame.
            + **[Audio Graph Driver](https://github.com/benji6/cycle-audio-graph)**: Audio graph driver for Cycle.js based on virtual-audio-graph.
            + **[Cookie](https://github.com/10clouds/cyclejs-cookie)**: Cycle.js Cookie Driver, based on cookie_js library.
            + **[DOM](https://github.com/cyclejs/dom)**: The standard DOM Driver for Cycle.js based on virtual-dom, and other helpers.
            + **[Fetch](https://github.com/secobarbital/cycle-fetch-driver)**: A Cycle.js Driver for making HTTP requests, using the Fetch API.
            + **[Fetcher](https://github.com/r7kamura/cycle-fetcher-driver)**: A Cycle.js Driver for making HTTP requests using stackable-fetcher.
            + **[Firebase](https://github.com/dralletje/cycle-firebase)**: Thin layer around the firebase javascript API that allows you to query and declaratively update your favorite real-time database.
            + **[HTTP](https://github.com/cyclejs/http)**: A Cycle.js Driver for making HTTP requests, based on superagent.
            + **[Hammer.js](https://github.com/CyclicMaterials/cycle-hammer-driver)**: The driver incorporates the Hammer.js gesture library.
            + **[History](https://github.com/cyclejs/history)**: Cycle.js URL Driver based on the rackt/history library.
            + **[Keys](https://github.com/raquelxmoss/cycle-keys)**: A Cycle.js driver for keyboard events.
            + **[Mongoose.js](https://github.com/whitecolor/cycle-mongoose/)**: A driver for using Mongoose with Cycle JS. Accepts both, write and read operations.
            + **[Notification](https://github.com/cyclejs/cycle-notification-driver)**: A Cycle.js Driver for showing and responding to HTML5 Notifications.
            + **[Router](https://github.com/TylorS/cycle-router)**: A router built from the ground up with Cycle.js in mind. Stands on the shoulders of battle-tested libraries switch-path for route matching and rackt/history for dealing with the History API.
            + **[Router5](https://github.com/axefrog/cycle-router5)**: A source/sink router driver for Cycle.js, based on router5.
            + **[Server-Sent Events](https://github.com/jessaustin/cycle-sse-driver)**: Cycle.js driver for Server-Sent Events (SSE), a browser feature also known as EventSource. Server-Sent Events allow the server to continuously update the page with new events, without resorting to hacks like long-polling.
            + **[Snabbdom](https://github.com/TylorS/cycle-snabbdom)**: Alternative DOM driver utilizing the snabbdom library.
            + **[Socket.IO](https://github.com/cgeorg/cycle-socket.io)**: A Cycle driver for applications using Socket.IO
            + **[Storage](https://github.com/cyclejs/storage)**: A Cycle.js Driver for using localStorage and sessionStorage in the browser.
        + **Example Projects**: Example applications built with Cycle.js
            + **[Cycle.js Examples](https://github.com/cyclejs/examples)**: Browse and learn from examples of small Cycle.js apps using Core, DOM Driver, HTML Driver, HTTP Driver, JSONP Driver, and others.
            + **[RX Marbles](https://github.com/staltz/rxmarbles)**: Interactive diagrams of Rx Observables.
            + **[TODO: Minimum Viable Pizza](https://github.com/cgeorg/todomvp)**: Minimum Viable Pizza implemented with Cycle.js
            + **[Tricycle](https://github.com/Widdershin/tricycle)**: A scratchpad for trying out Cycle.js.
        + **[Intro to Functional Reactive Programming with Cycle.js](https://www.youtube.com/watch?v=6_ETUyh0tns)**: Nick Johnstone gives an introduction to developing with Cycle.js in this video presentation.
        + **[Learning How to Ride: an Introduction to Cycle.js](https://www.youtube.com/watch?v=31URmaeNHSs)**: In this talk, Fernando Macias Pereznieto introduces us to the good, the bad, and the beautiful of using Cycle.js, whether you are a complete beginner or an experienced JS ninja.
        + **[Motorcycle.js](https://github.com/motorcyclejs/core)**: This is a sister project that will continue to evolve and grow alongside Cycle.js for the foreseeable future. The primary focus of this project is to tune it for performance as much as possible.
            + **[Most](https://github.com/cujojs/most)**: Monadic reactive streams with high performance.
        + **[Plug and Play All Your Observable Streams With Cycle.js](https://medium.com/@fkrautwald/plug-and-play-all-your-observable-streams-with-cycle-js-e543fc287872)**: Frederik Krautwald explains the principles behind Cycle.js, it's inner workings and how to use it to create a simple program with drivers.
        + **[Tricycle](https://github.com/Widdershin/tricycle)**: A scratchpad for trying out Cycle.js.
        + **[What Developers Need to Know about MVI (Model-View-Intent)](http://thenewstack.io/developers-need-know-mvi-model-view-intent/)**: The article explains the general MVI pattern and how it relates to React, Reactive Programming and Cycle.js
    + **[Cycle.js and Functional Reactive User Interfaces](https://www.youtube.com/watch?v=uNZnftSksYg)**: In this talk we will discover how Cycle.js is purely reactive and functional, and why it's an interesting alternative to React.
    + **[Dynamics of Change: why Reactivity Matters](https://www.youtube.com/watch?v=v68ppDlvHqs)**: In this talk we will see when passive or reactive strategy is advantageous, and how the reactive strategy is a sensible default.
    + **[Enemy of the State](https://vimeo.com/68987289)**: An introduction to Functional Reactive Programming and Bacon.js by Philip Roberts.
    + **[MobX](https://github.com/mobxjs/mobx)**: MobX is a battle tested library that makes state management simple and scalable by transparently applying functional reactive programming.
    + **[Promises + FP = Beautiful Streams](https://medium.com/@yelouafi/promises-fp-beautiful-streams-6f0235c5b179)**: Yassine Elouafi show how to use functional programming and algebraic data types to derive a pure functional definition of reactive programming like streams.
    + **Stream Libraries**: Libraries which help you compose asynchronous operations on streams of time-varying values and events.
        + **[Bacon.js](http://baconjs.github.io/)**: A small functional reactive programming lib for JavaScript. Turns your event spaghetti into clean and declarative feng shui bacon, by switching from imperative to functional.
        + **[Kefir.js](https://rpominov.github.io/kefir/)**: Kefir — is a Reactive Programming library for JavaScript inspired by Bacon.js and RxJS, with focus on high performance and low memory usage.
        + **[Most](https://github.com/cujojs/most)**: Monadic reactive streams with high performance.
        + **[Reactive Extensions (RxJS)](https://github.com/Reactive-Extensions/RxJS)**: RxJS is a set of libraries for composing asynchronous and event-based programs using observable sequences and fluent query operators.
            + **[Async JavaScript with Reactive Extensions](https://www.youtube.com/watch?v=XRYN2xt11Ek)**: Jafar Husain explains in this video how Netflix uses the Reactive Extensions (Rx) library to build responsive user experiences that strive to be event-driven, scalable and resilient.
            + **[Exploring Rx Operators: FlatMap](http://blog.thoughtram.io/rx/2016/08/01/exploring-rx-operators-flatmap.html)**: Christoph Burgdorf introduces the FlatMap operator and its usage for collections and observables.
            + **[Exploring Rx Operators: Map](http://blog.thoughtram.io/angular/2016/05/16/exploring-rx-operators-map.html)**: Christoph Burgdorf explains how to use the map operator in RxJS.
            + **[Functional Core Reactive Shell](http://www.mokacoding.com/blog/functional-core-reactive-shell/)**: Giovanni Lodi makes an overview of different architecture meta-patterns and describes his current findings about functional programming and observables as a way to control side effects.
            + **[Learn RX](http://reactivex.io/learnrx/)**: A series of interactive exercises for learning Microsoft's Reactive Extensions (Rx) Library for Javascript.
            + **[Learn RxJS](http://www.learnrxjs.io/)**: This site focuses on making RxJS concepts approachable, the examples clear and easy to explore, and features references throughout to the best RxJS related material on the web.
            + **[Real World Observables](https://medium.com/@sergimansilla/real-world-observables-1f65748c8f9)**: Sergi Mansilla writes an FTP client to use it as an example for a real world application based on RxJS.
            + **[Rx Training Games](https://github.com/JulienMoumne/rx-training-games)**: Rx Training Games is a coding playground that can be used to learn and practice Reactive Extensions coding grid-based games
            + **[Rx-Book](http://xgrommx.github.io/rx-book/index.html)**: A complete book about RxJS v.4.0.
            + **[RxMarbles](http://rxmarbles.com/)**: A webapp for experimenting with diagrams of Rx Observables, for learning purposes.
            + **[RxState](https://www.npmjs.com/package/rxstate)**: Simple opinionated state management library based on RxJS and Immutable.js
            + **[Taking Advantage of Observables in Angular 2](http://blog.thoughtram.io/angular/2016/01/06/taking-advantage-of-observables-in-angular2.html)**: Christoph Burgdorf describes the advantages of Observables and how you can use them in Angular 2 context.
            + **[Transducers with Observable Sequences](https://xgrommx.github.io/rx-book/content/getting_started_with_rxjs/creating_and_querying_observable_sequences/transducers.html)**: A chapter from the RxJS Book describing Transducers.
            + **[Why We Built Xstream](http://staltz.com/why-we-built-xstream.html)**: The authors needed a stream library tailored for Cycle.js. It needs to be “hot” only, small in kB size and it should have only a few and intuitive operators.
        + **[Xstream](https://github.com/staltz/xstream)**: An extremely intuitive, small, and fast functional reactive stream library for JavaScript.
            + **[Why We Built Xstream](http://staltz.com/why-we-built-xstream.html)**: The authors needed a stream library tailored for Cycle.js. It needs to be “hot” only, small in kB size and it should have only a few and intuitive operators.
    + **[The Introduction to Reactive Programming](https://gist.github.com/staltz/868e7e9bc2a7b8c1f754)**: André Staltz provides a complete introduction to the Reactive Programming and RxJS.
    + **[What if the User was a Function?](https://www.youtube.com/watch?v=1zj7M1LnJV4)**: In this video André Staltz talks about the input/output cycle between humans and computers and how to take advantage of this model by using FRP and event streams.

## Compatibility

Ability of a product to work with different input/output devices and rendering software. Including printers, email, mobile devices and different browsers.

+ **Cross Browser**: Cross-browser refers to the ability of a website, web application, HTML construct or client-side script to function in environments that provide its required features and to bow out or degrade gracefully when features are absent or lacking.
    + **[Can I use ... ?](http://caniuse.com/)**: "Can I use" provides up-to-date browser support tables for support of front-end web technologies on desktop and mobile web browsers.
    + **[Dev Tools by Microsoft](https://developer.microsoft.com/en-us/microsoft-edge/tools/)**: These tools allow you to test your product on different version of Internet Explorer and Microsoft Edge.
    + **[HTML5 Cross Browser Polyfills](https://github.com/Modernizr/Modernizr/wiki/HTML5-Cross-browser-Polyfills)**: So here we're collecting all the shims, fallbacks, and polyfills in order to implant HTML5 functionality in browsers that don't natively support them.
    + **[HTML5 Please](http://html5please.com/)**: Look up HTML5, CSS3, etc features, know if they are ready for use, and if so find out how you should use them – with polyfills, fallbacks or as they are.
    + **[Modernizr](https://modernizr.com/)**: It’s a collection of superfast tests – or “detects” as we like to call them – which run as your web page loads, then you can use the results to tailor the experience to the user.
    + **[Normalize.css](http://necolas.github.io/normalize.css/)**: A modern, HTML5-ready alternative to CSS resets.
    + **[Polyfill.io](https://polyfill.io/)**: Just the polyfills you need for your site, tailored to each browser.
+ **E-Mail**: Preparing HTML based electronic mail.
    + **[Bulletproof E-Mail Buttons](https://buttons.cm/)**: Design gorgeous buttons using progressively enhanced VML and CSS.
    + **[Email Lab](https://github.com/sparkbox/email-lab)**: This a project for developing and testing email templates. It uses Grunt to streamline and simplify the creation of email templates. Email template can be built with re-usable components.
    + **[Email-Boilerplate](https://github.com/seanpowell/Email-Boilerplate)**: Use these code examples as a guideline for formatting your HTML email to avoid some of the major styling pitfalls in HTML email design.
    + **[Foundation for Emails 2](http://foundation.zurb.com/emails.html)**: Frontend Framework for E-Mails including a grid, global styles, aligment classes, buttons, callout panels, thumbnail styles, typography, visibility classes.
    + **[MJML](https://mjml.io/)**: MJML is a markup language designed to reduce the pain of coding a responsive email. Its semantic syntax makes it easy and straightforward and its rich standard components library speeds up your development time and lightens your email codebase.
    + **[MailChimp E-Mail Blueprints](https://github.com/mailchimp/Email-Blueprints)**: Email Blueprints is a collection of HTML email templates that can serve as a solid foundation and starting point for the design of emails.
    + **[Open Source Email Templates](https://www.sendwithus.com/resources/templates)**: The sendwithus Open Source Template Project is a collection of free email templates created and managed by the sendwithus team and community.
    + **[Really Simple Responsive HTML Email Template](https://github.com/leemunroe/responsive-html-email-template)**: Sometimes all you want is a really simple HTML email template. Here it is.
    + **[Responsive Email Design](https://www.campaignmonitor.com/dev-resources/guides/mobile/)**: In this guide, the author will cover the fundamentals of designing and building a mobile-friendly email and back it all up with some neat tips and techniques.
    + **[Responsive Email Templates](http://zurb.com/playground/responsive-email-templates)**: Zurb Studios put together this set of super awesome email templates so that you can make your email campaigns responsive.
    + **[The Ultimate Guide to CSS](https://www.campaignmonitor.com/css/)**: A complete breakdown of the CSS support for the top 10 most popular mobile, web and desktop email clients on the planet.
+ **Keyboard**: Working with keyboard input in a web browser.
    + **[What’s New with KeyboardEvents? Keys and Codes!](https://developers.google.com/web/updates/2016/04/keyboardevent-keys-codes)**: Jeff Posnick talks about the code and key event attributes and how to use them in practice.
+ **Mobile**: Development of websites optimized for viewing on smartphone and tablet devices.
    + **Emulation**: Tools for emulating features of mobile devices on a desktop.
        + **[Responsinator](http://www.responsinator.com/)**: Quickly test any website in popular resolutions.
        + **[Simulate Mobile Devices with Chrome Developer Tools](https://developers.google.com/web/tools/chrome-devtools/iterate/device-mode/?hl=en)**: Use Chrome DevTools' Device Mode to build mobile-first, fully responsive web sites. Learn how to use it to simulate a wide range of devices and their capabilities.
        + **[Touché](https://github.com/davidcalhoun/touche)**: Touché: bringing touch events to non-touch browsers (how touching!). No dependencies. No code bloat.
        + **[thumbs.js](http://mwbrooks.github.io/thumbs.js/)**: Adds touch support to your browser.
    + **Gestures**: Resources for working with touch mechanics (what your fingers do on the screen) and touch activities (results of specific gestures).
        + **[Hammer.js](http://hammerjs.github.io/)**: Hammer helps you add support for touch gestures to your page, and remove the 300ms delay from clicks.
        + **[Introduction to Gestures](https://www.google.com/design/spec/patterns/gestures.html)**: Descriptions of different gestures an their meanings.
        + **[Pointer Events Polyfill](https://github.com/jquery/PEP)**: PEP polyfills pointer events in all browsers that haven't yet implemented them, providing a unified, responsive input model for all devices and input types.
        + **[Touchy](https://github.com/HotStudio/touchy)**: Touchy is a jQuery plugin for managing touch events on W3C-compliant browsers, such as Mobile Safari or Android Browser, or any browser that supports the ontouchstart, ontouchmove and ontouchend events.
        + **[jGestures](http://jgestures.codeplex.com/)**: A jQuery plugin that enables you to add gesture events just like native jQuery events. Includes event substitution for mouse events.
    + **Layout**: The way in which the parts of the website are arranged or laid out.
        + **[Snap.js](https://github.com/jakiestfu/Snap.js)**: A Library for creating beautiful mobile shelfs (side menus) in Javascript.
        + **[Swipe](https://github.com/thebird/swipe)**: Swipe is the most accurate touch slider.
        + **[Swiper](http://idangero.us/swiper/)**: Swiper is a free mobile touch slider with hardware accelerated transitions and  native behavior. It is intended to be used in mobile websites, mobile web apps, and mobile native/hybrid apps.
        + **[jqm-pagination](https://github.com/filamentgroup/jqm-pagination)**: A jQuery Mobile plugin for sequential pagination between pages with support for touch, mouse, and keyboard.
        + **[swipeslide](https://github.com/max-power/swipeslide)**: A Zepto Plugin for iOS like swipe navigation.
    + **Scrolling**: Native scrolling of the browsers doesn't always fit for mobile websites. There are resources which solve this problem.
        + **[Overscroll](https://github.com/azoff/overscroll)**: Overscroll is a jQuery plug-in that mimics the iphone/ipad scrolling experience in a browser.
        + **[Overthrow](https://www.filamentgroup.com/lab/overthrow.html)**: A framework-independent, overflow: auto polyfill for use in responsive design.
        + **[Zynga Scroller](https://github.com/zynga/scroller)**: A pure logic component for scrolling/zooming. It is independent of any specific kind of rendering or event system.
        + **[iScroll](http://iscrolljs.com/)**: iScroll is a high performance, small footprint, dependency free, multi-platform javascript scroller.
        + **[jQuery.pep.js](http://pep.briangonzalez.org/)**: A lightweight plugin for kinetic-drag on mobile/desktop.
        + **[jSwipeKinetic](http://jswipekinetic.codeplex.com/)**: A jQuery plugin that enables you to add kinetic scrolling on your touch optimized projects. jSwipeKinetic is build on top of jGestures.
        + **[pull-to-refresh.js](https://github.com/visiongeist/pull-to-refresh-js)**: This plugin enables a pull-to-refresh functionality in mobile safari for scrollable block elements with native scrolling on iOS.
    + **Tap Acceleration**: Every touch-based mobile browser has an artificial ~300ms delay between you tapping a thing on the screen and the browser considering it a "click", but there are ways to work around this behavior.
        + **[300ms Tap Delay, Gone Away](https://developers.google.com/web/updates/2013/12/300ms-tap-delay-gone-away)**: An article by Google describing the 300ms delay and how Chrome 32+ on Anrdoid deals with it.
        + **[Hammer.js](http://hammerjs.github.io/)**: Hammer helps you add support for touch gestures to your page, and remove the 300ms delay from clicks.
        + **[Tappable](http://cheeaun.github.io/tappable/)**: Tappable is a simple, standalone library to invoke the tap event for touch-friendly web browsers.
        + **[fastclick](https://github.com/ftlabs/fastclick)**: FastClick is a simple, easy-to-use library for eliminating the 300ms delay between a physical tap and the firing of a click event on mobile browsers.
    + **Touch Keyboard**: Almost all modern smartphones provide a touch based keyboard for text input. There are some tactics to influence them and work around their quirks.
        + **[A Guide To Designing Touch Keyboards](https://www.smashingmagazine.com/2013/08/guide-to-designing-touch-keyboards-with-cheat-sheet/)**: In this article, we will look a bit deeper into the usability issues surrounding touch keyboards, including five design guidelines that will alleviate some of these pains.
    + **Working With Sensors**: All mobile devices are equipped with sensors like gyroscope, accelerometers, photometers, magnetometers and so on. Some of them are accessible in a browser through JavaScript.
        + **[This End Up: Using Device Orientation](http://www.html5rocks.com/en/tutorials/device/orientation/)**: In this article, we’ll take a look at device orientation and motion events, and use CSS to rotate an image based on the orientation of the device.
        + **[lenticular.js](http://lenticular.attasi.com/)**: Tilt-controlled images in the browser.
+ **Printers**: Manipulation of printer output through CSS.
    + **[Tips And Tricks For Print Style Sheets](http://coding.smashingmagazine.com/2013/03/08/tips-tricks-print-style-sheets/)**: A comprehensive guide for print optimization including background images and colors, expanding external links, QR codes, CSS3 filters for print quality.
+ **Responsive Web Design (RWD)**: RWD responds to the needs of the users and the devices they’re using. The layout changes based on the size and capabilities of the device.
    + **Data Tables**: Tables filled with data don't behave well on small screens. Here are some resources to tame them.
        + **[Responsive Data Tables](https://css-tricks.com/responsive-data-tables/)**: Several ideas by Chris Coyier on how to deal with responsive tables.
        + **[stacktable.js](http://johnpolacek.github.com/stacktable.js/)**: jQuery plugin for stacking tables on small screens.
    + **[Future Friendly Thinking](http://futurefriendlyweb.com/thinking.html)**: We want to make things that are future friendly. The following ideas have been on our minds recently. Help us explore them further or suggest new ones.
    + **[How to make a Responsive Newspaper-like layout](http://www.newnet-soft.com/blog/responsive-multi-column)**: The article describes several approaches for creating multi column websites.
    + **Images**: Images pose a set of problems on responsive websites: scaling, performance, retina screens and file size.
        + **[Adaptive Images](http://adaptive-images.com/)**: Adaptive Images detects your visitor's screen size and automatically creates, caches, and delivers device appropriate re-scaled versions of your web page's embeded HTML images.
        + **[Choosing A Responsive Image Solution](https://www.smashingmagazine.com/2013/07/choosing-a-responsive-image-solution/)**: This article leads you through the basics, and then arms you with the information you’ll need to pick the best responsive image solution for your situation.
        + **[Clown Car Technique](https://github.com/estelle/clowncar)**: We can use media queries within SVG to serve up the right image. The beauty of the "Clown Car" technique is that all the logic remains in the SVG file.
        + **[How to Use Responsive Images...](http://www.shutterstock.com/blog/2013/05/how-to-use-responsive-images-to-make-your-site-shine-on-any-platform/)**: Engineers at Shutterstock describe different problems and solutions around responsive images.
        + **[Picturefill](http://scottjehl.github.io/picturefill/)**: A responsive image polyfill for <picture>, srcset, sizes, and more.
        + **[Riloadr](https://github.com/tubalmartin/riloadr)**: The goal of this library is to deliver optimized, contextual image sizes in responsive layouts that utilize dramatically different image sizes at different resolutions in order to improve page load time.
        + **[Why We Need Responsive Images](https://timkadlec.com/2013/06/why-we-need-responsive-images/)**: Tim Kadlec talks about page weight and responsive image solutions.
        + **[imgLiquid](https://github.com/karacas/imgLiquid)**: A jQuery Plugin to resize images to fit in a container.
        + **[jQuery Picture](http://jquerypicture.com/)**: jQuery Picture is a tiny (2kb) plugin to add support for responsive images to your layouts. It supports both figure elements with some custom data attributes and the new proposed picture format.
    + **Monitoring Breakpoints**: Triggering JavaScript events on different breakpoints.
        + **[Breakpoints.js](http://xoxco.com/projects/code/breakpoints/)**: Define breakpoints for your responsive design, and Breakpoints.js will fire custom events when the browser enters and/or exits that breakpoint.
        + **[Harvey](http://harvesthq.github.io/harvey/)**: Harvey helps you monitor and manage behavior changes by firing an event whenever your media query is activated.
        + **[enquire.js](http://wicky.nillia.ms/enquire.js/)**: enquire.js is a lightweight, pure javascript library (with no dependencies) for programmatically responding to media queries.
    + **Navigation**: Adapting the website navigation to different screen sizes.
        + **[Complex Navigation Patterns](http://bradfrost.com/blog/web/complex-navigation-patterns-for-responsive-design/)**: The article describes some emerging patterns for dealing with complex, lengthy and/or multi-level navigations.
        + **[Responsive Navigation On Complex Websites](http://mobile.smashingmagazine.com/2013/09/11/responsive-navigation-on-complex-websites/)**: To illustrate the techniques involved in implementing responsive navigation on a large website, author refers to two actual clients.
        + **[Responsive Navigation Patterns](http://bradfrost.com/blog/web/responsive-nav-patterns/)**: The article describes some of the more popular techniques for handling navigation in responsive designs.
    + **[Responsive Design Workflow](http://vimeo.com/45915667)**: In this video, Stephen Hay explores at a content-based approach to design workflow which is grounded in our multiplatform reality, not fixed-width Photoshop comps and overproduced wireframes.
    + **[Responsive Elements](http://kumailht.com/responsive-elements/)**: Responsive elements makes it possible for any element to adapt and respond to the area they occupy. It's a tiny JavaScript library that you can drop into your projects today.
    + **[Responsive Patterns](http://bradfrost.github.io/this-is-responsive/patterns.html)**: A collection of patterns and modules for responsive designs.
    + **Text**: Working with text in a context of different viewport sizes.
        + **[FitText](http://fittextjs.com/)**: FitText makes font-sizes flexible. Use this plugin on your fluid or responsive layout to achieve scalable headlines that fill the width of a parent element.
        + **[Out Of Words!](http://starburst1977.github.io/out-of-words/)**: The responsive typography framework behind Words App.
        + **[Responsive Font Sizing](http://www.newnet-soft.com/blog/responsivefontsizing)**: Making your font size respond to your screen size, easy & maintainable.
        + **[Responsive Measure](http://jbrewer.github.com/Responsive-Measure/)**: A jQuery plugin for generating a responsive ideal measure.
        + **[Truly Fluid Typography With vh And vw Units](https://www.smashingmagazine.com/2016/05/fluid-typography/)**: This article describes viewport units and other technics to achieve typography which resizes smoothly with the screen.
    + **[Viewport Component](https://github.com/pazguille/viewport)**: Viewport is a component to ease viewport management. You can get the dimensions of the viewport and beyond, which can be quite helpful to perform some checks with JavaScript.
+ **Web Accessibility**: Web accessibility means that people with disabilities can perceive, understand, navigate, and interact with the Web, and that they can contribute to the Web.
    + **[Notes on Using ARIA in HTML](http://w3c.github.io/aria-in-html/)**: This document is a practical guide for developers on how to add accessibility information to HTML elements using the Accessible Rich Internet Applications specification.
    + **[The A11Y Project](http://a11yproject.com/)**: A community-driven effort to make web accessibility easier.

## Ecosystem

Important developers, companies, organizations and news sources.

+ **Communities Around Projects**: Successful open source projects attract many developers who produce plugins, libraries, tutorials and other resources. This section collects such resources.
    + **[Angular](https://angularjs.org/)**: AngularJS is a web application framework trying to address many of the challenges encountered in developing single-page applications.
        + **[Adventures in Angular](https://devchat.tv/adv-in-angular)**: Adventures in Angular is a weekly podcast dedicated to the Angular JavaScript framework and related technologies, tools, languages, and practices.
        + **[Angular 2 ESNext Starter](https://github.com/blacksonic/angular2-esnext-starter)**: This repo stands as a starting point for those who try Angular 2 in Javascript. It shows techniques how easy development can be also without Typescript.
        + **[Angular 2 Template Syntax](https://vsavkin.com/angular-2-template-syntax-5f2ee9f13c6a)**: Victor Savkin writes about Angular 2 Templates including bindings, interpolation, syntax sugar, web component support and much more.
        + **[Angular 2 Upgrade Strategies from Angular 1.x](http://developer.telerik.com/featured/angular-2-upgrade-strategies-angular-1-x/)**: Some thoughts on general upgrading to Angular 2 and what you/your team can do to prepare.
        + **[Building Redux in TypeScript with Angular 2](http://blog.ng-book.com/introduction-to-redux-with-typescript-and-angular-2/)**: In this post we’re going to discuss the ideas behind Redux. How to build our own mini version of the Redux Store and hook it up to Angular 2.
        + **[Change Detection in Angular 2](http://victorsavkin.com/post/110170125256/change-detection-in-angular-2)**: In this article Victor Savkin talks in depth about the Angular 2 change detection system.
        + **[How to Implement Conditional Validation in Model-driven Forms](https://scotch.io/tutorials/how-to-implement-conditional-validation-in-angular-2-model-driven-forms)**: In this article, we will learn about how to handle conditional validation in our model-driven form using the latest forms module.
        + **[How to Prevent Name Collisions in Angular 2 Providers](http://blog.thoughtram.io/angular/2016/05/23/opaque-tokens-in-angular-2.html)**: Opaque tokens are distinguishable and prevent us from running into naming collisions. Whenever we create a token that is not a type, OpaqueToken should be used.
        + **[Ng-Newsletter](http://www.ng-newsletter.com/)**: The free, weekly newsletter of the best AngularJS content on the web.
        + **[PrimeNG](http://www.primefaces.org/primeng/)**: PrimeNG is a collection of rich UI components for AngularJS2. PrimeNG is a sibling of the popular JavaServer Faces Component Suite, PrimeFaces.
        + **[Simple Language Translation](https://medium.com/@jecelynyeen/simple-language-translation-in-angular-2-part-1-a14087f50431)**: Create a pipe that we can use to translate words in the HTML view and a service that we can use to translate our words in JS / Typescript.
        + **[Using Model-Driven Forms with FormGroup and FormControl](https://scotch.io/tutorials/using-angular-2s-model-driven-forms-with-formgroup-and-formcontrol)**: In this article, we will learn about building model-driven form with validation using the latest forms module, then we will talk about what are the advantages / disadvantages of using model driven form as compared to template-driven form.
    + **[Backbone.js](http://backbonejs.org/)**: Backbone supplies structure to JavaScript-heavy applications by providing models, collections, views with declarative event handling, and connects it all to your existing application over a RESTful JSON interface.
    + **[Bootstrap](http://getbootstrap.com/)**: Bootstrap is a HTML, CSS, and JS framework for developing responsive, mobile first projects on the web.
        + **[Bootstrap 4 Cheat Sheet](http://hackerthemes.com/bootstrap-cheatsheet/)**: A quick reference for Bootstrap v4 by Alexander Rechsteiner.
        + **[Tree Shaking Bootstrap](https://medium.com/@jacobp/tree-shaking-bootstrap-95d6301f61a9)**: Jacob Parker describes how to include only those parts of Bootstrap you are really using on your website by leveraging CSS modules and ES6 modules.
    + **[Cycle.js](http://cycle.js.org/)**: A functional and reactive JavaScript framework that solves the cyclic dependency of Observables which emerge during dialogues (mutual observations) between the Human and the Computer.
        + **[Async Driver](https://github.com/whitecolor/cycle-async-driver)**: Higher order factory for creating cycle.js async request based drivers. Allows you almost completely eliminate boilerplate code for this kind of drivers.
        + **[Cycle.js Was Built to Solve Problems](https://www.youtube.com/watch?v=Rj8ZTRVka4E)**: In this video André Staltz shows how Cycle.js has a practical purpose, meant to solve problems your customers/business may relate to.
        + **[Cycle.js and Functional Reactive User Interfaces](https://www.youtube.com/watch?v=uNZnftSksYg)**: In this talk we will discover how Cycle.js is purely reactive and functional, and why it's an interesting alternative to React.
        + **[Draw Cycle](https://glebbahmutov.com/draw-cycle/)**: Simple Cycle.js program visualized
        + **[Drivers](http://cycle.js.org/drivers.html)**: Drivers are functions that listen to Observable sinks (their input), perform imperative side effects, and may return Observable sources (their output).
            + **[Animation](https://github.com/Widdershin/cycle-animation-driver)**: A Cycle driver for requestAnimationFrame.
            + **[Audio Graph Driver](https://github.com/benji6/cycle-audio-graph)**: Audio graph driver for Cycle.js based on virtual-audio-graph.
            + **[Cookie](https://github.com/10clouds/cyclejs-cookie)**: Cycle.js Cookie Driver, based on cookie_js library.
            + **[DOM](https://github.com/cyclejs/dom)**: The standard DOM Driver for Cycle.js based on virtual-dom, and other helpers.
            + **[Fetch](https://github.com/secobarbital/cycle-fetch-driver)**: A Cycle.js Driver for making HTTP requests, using the Fetch API.
            + **[Fetcher](https://github.com/r7kamura/cycle-fetcher-driver)**: A Cycle.js Driver for making HTTP requests using stackable-fetcher.
            + **[Firebase](https://github.com/dralletje/cycle-firebase)**: Thin layer around the firebase javascript API that allows you to query and declaratively update your favorite real-time database.
            + **[HTTP](https://github.com/cyclejs/http)**: A Cycle.js Driver for making HTTP requests, based on superagent.
            + **[Hammer.js](https://github.com/CyclicMaterials/cycle-hammer-driver)**: The driver incorporates the Hammer.js gesture library.
            + **[History](https://github.com/cyclejs/history)**: Cycle.js URL Driver based on the rackt/history library.
            + **[Keys](https://github.com/raquelxmoss/cycle-keys)**: A Cycle.js driver for keyboard events.
            + **[Mongoose.js](https://github.com/whitecolor/cycle-mongoose/)**: A driver for using Mongoose with Cycle JS. Accepts both, write and read operations.
            + **[Notification](https://github.com/cyclejs/cycle-notification-driver)**: A Cycle.js Driver for showing and responding to HTML5 Notifications.
            + **[Router](https://github.com/TylorS/cycle-router)**: A router built from the ground up with Cycle.js in mind. Stands on the shoulders of battle-tested libraries switch-path for route matching and rackt/history for dealing with the History API.
            + **[Router5](https://github.com/axefrog/cycle-router5)**: A source/sink router driver for Cycle.js, based on router5.
            + **[Server-Sent Events](https://github.com/jessaustin/cycle-sse-driver)**: Cycle.js driver for Server-Sent Events (SSE), a browser feature also known as EventSource. Server-Sent Events allow the server to continuously update the page with new events, without resorting to hacks like long-polling.
            + **[Snabbdom](https://github.com/TylorS/cycle-snabbdom)**: Alternative DOM driver utilizing the snabbdom library.
            + **[Socket.IO](https://github.com/cgeorg/cycle-socket.io)**: A Cycle driver for applications using Socket.IO
            + **[Storage](https://github.com/cyclejs/storage)**: A Cycle.js Driver for using localStorage and sessionStorage in the browser.
        + **Example Projects**: Example applications built with Cycle.js
            + **[Cycle.js Examples](https://github.com/cyclejs/examples)**: Browse and learn from examples of small Cycle.js apps using Core, DOM Driver, HTML Driver, HTTP Driver, JSONP Driver, and others.
            + **[RX Marbles](https://github.com/staltz/rxmarbles)**: Interactive diagrams of Rx Observables.
            + **[TODO: Minimum Viable Pizza](https://github.com/cgeorg/todomvp)**: Minimum Viable Pizza implemented with Cycle.js
            + **[Tricycle](https://github.com/Widdershin/tricycle)**: A scratchpad for trying out Cycle.js.
        + **[Intro to Functional Reactive Programming with Cycle.js](https://www.youtube.com/watch?v=6_ETUyh0tns)**: Nick Johnstone gives an introduction to developing with Cycle.js in this video presentation.
        + **[Learning How to Ride: an Introduction to Cycle.js](https://www.youtube.com/watch?v=31URmaeNHSs)**: In this talk, Fernando Macias Pereznieto introduces us to the good, the bad, and the beautiful of using Cycle.js, whether you are a complete beginner or an experienced JS ninja.
        + **[Motorcycle.js](https://github.com/motorcyclejs/core)**: This is a sister project that will continue to evolve and grow alongside Cycle.js for the foreseeable future. The primary focus of this project is to tune it for performance as much as possible.
            + **[Most](https://github.com/cujojs/most)**: Monadic reactive streams with high performance.
        + **[Plug and Play All Your Observable Streams With Cycle.js](https://medium.com/@fkrautwald/plug-and-play-all-your-observable-streams-with-cycle-js-e543fc287872)**: Frederik Krautwald explains the principles behind Cycle.js, it's inner workings and how to use it to create a simple program with drivers.
        + **[Tricycle](https://github.com/Widdershin/tricycle)**: A scratchpad for trying out Cycle.js.
        + **[What Developers Need to Know about MVI (Model-View-Intent)](http://thenewstack.io/developers-need-know-mvi-model-view-intent/)**: The article explains the general MVI pattern and how it relates to React, Reactive Programming and Cycle.js
    + **[Dojo Toolkit](http://dojotoolkit.org/)**: A JavaScript toolkit that saves you time and scales with your development process. Provides everything you need to build a Web app. Language utilities, UI components, and more, all in one place, designed to work together perfectly.
    + **[Ember](http://emberjs.com/)**: Ember.js is an open-source JavaScript web framework, based on the MVC pattern. It allows developers to create scalable single-page web applications.
        + **[Bindings in Ember](https://guides.emberjs.com/v2.6.0/object-model/bindings/)**: Unlike most other frameworks that include some sort of binding implementation, bindings in Ember.js can be used with any object.
        + **[Router.js (Ember)](https://github.com/tildeio/router.js)**: Router.js is the routing microlib used by Ember.js.
    + **[Foundation](http://foundation.zurb.com/)**: Foundation provides a responsive grid and HTML and CSS UI components, templates, and code snippets, including typography, forms, buttons, navigation and other interface components, as well as optional JavaScript extensions.
    + **[Gulp](http://gulpjs.com/)**: Gulp is a toolkit that helps you automate painful or time-consuming tasks in your development workflow. It's very fast, platform-agnostic and simple.
        + **Articles & Tutorials**: Publications about gulp or step by step guides for setting up and using gulp in a project.
            + **Building with Gulp 3 and 4 (Series)**: Great series of articles about single components and gulp as a whole.
                + **[Part 1: Examples](http://blog.reactandbethankful.com/posts/2015/04/23/building-with-gulp-3-and-4-part-1-examples/)**: Introduction to gulp and gulpfile.js.
                + **[Part 2: Gulp's anatomy](http://blog.reactandbethankful.com/posts/2015/04/23/building-with-gulp-3-and-4-part-2-gulp-anatomy/)**: Orchestrator, Undertaker, Vinyl and Vinyl FS, Gulp Plugins.
                + **[Part 3: Writing transformers](http://blog.reactandbethankful.com/posts/2015/04/28/building-with-gulp-3-and-4-part-3-writing-transformers/)**: Using map-stream, though2 and event-stream.
                + **[Part 4: Incremental builds](http://blog.reactandbethankful.com/posts/2015/05/01/building-with-gulp-4-part-4-incremental-builds/)**: Building files which changed since last run and caching.
                + **[Part 5: Caveats](http://blog.reactandbethankful.com/posts/2015/05/05/building-with-gulp-part-5-caveats/)**: Error management in Gulp 3 and "MANY:1 disguised as a 1:1" problem.
            + **[The vision, history, and future of the project (Apr. 2014)](https://medium.com/@contrahacks/gulp-3828e8126466)**: The article talks about Streams, Vinyl, Vinyl Adapters, Orchestrator and Error Management in Gulp 4.
            + **[Why Gulp might not be the Answer](http://scm.io/blog/hack/2014/07/why-gulp-might-not-be-the-answer/)**: ... there is still a conceptual problem that Gulp has yet to address. Many build steps are not 1:1 (one file in, one file out) but rather n:1 or 1:n.
        + **CSS**: Gulp plugins for working with CSS files.
            + **[gulp-clean-css](https://github.com/scniro/gulp-clean-css)**: gulp plugin to minify CSS, using clean-css.
            + **[gulp-cssnano](https://www.npmjs.com/package/gulp-cssnano)**: Minify CSS with cssnano.
        + **Concatenation**: Plugins for file concatenation. For example bundling CSS or JavaScript files.
            + **[gulp-concat](https://www.npmjs.com/package/gulp-concat)**: This plugin will concat files by your operating systems newLine. It will take the base directory from the first file that passes through it.
            + **[gulp-group-concat](https://www.npmjs.com/package/gulp-group-concat)**: Concats groups of files into a smaller number of files
        + **Deployment**: Plugins for pushing built files into production.
            + **[gulp-tar](https://github.com/sindresorhus/gulp-tar)**: Create tarball from files.
            + **[vinyl-ftp](https://github.com/morris/vinyl-ftp)**: Blazing fast vinyl adapter for FTP.
            + **[vinyl-s3](https://github.com/izaakschroeder/vinyl-s3)**: Use S3 as a source or destination of vinyl files.
        + **Ecosystem**: The network of developers and plugins around gulp.
            + **[@sindresorhus plugins](https://github.com/search?q=%40sindresorhus+gulp-)**: A collection of plugins by Sindre Sorhus.
            + **[Gulp Friendly NPM Packages](https://www.npmjs.com/browse/keyword/gulpfriendly)**: Normal node packages that work with gulp.
        + **Filters**: Plugins for filtering files in a vinyl stream.
            + **[gulp-cache](https://www.npmjs.com/package/gulp-cache)**: A temp file based caching proxy task for gulp.
            + **[gulp-cached](https://www.npmjs.com/package/gulp-cached)**: A simple in-memory file cache for gulp.
            + **[gulp-changed](https://github.com/sindresorhus/gulp-changed)**: Only pass through changed files.
            + **[gulp-filter](https://www.npmjs.com/package/gulp-filter)**: Filter files in a vinyl stream.
            + **[gulp-newer](https://github.com/tschaub/gulp-newer)**: Pass through newer source files only.
            + **[gulp-remember](https://github.com/ahaurw01/gulp-remember)**: A plugin for gulp that remembers and recalls files passed through it.
            + **[vinyl-diff](https://www.npmjs.com/package/vinyl-diff)**: This library allows you to perform diffs between streams of vinyl.
        + **Images**: Plugins for working with images.
            + **[gulp-imagemin](https://github.com/sindresorhus/gulp-imagemin)**: Minify PNG, JPEG, GIF and SVG images.
            + **[gulp-webp](https://github.com/sindresorhus/gulp-webp)**: Convert PNG, JPEG, TIFF images to WebP.
        + **JavaScript**: Module loaders, minifiers and other tools for working with JavaScript files.
            + **[gulp-pure-cjs](https://www.npmjs.com/package/gulp-pure-cjs)**: Gulp plugin for Pure CommonJS builder.
            + **[gulp-uglify](https://www.npmjs.com/package/gulp-uglify)**: Minify files with UglifyJS.
            + **[yoloader](https://www.npmjs.com/package/yoloader)**: A CommonJS module loader implementation. It provides tools to bundle a CommonJS based project and to load such bundles.
        + **SourceMaps**: A source map provides a way of mapping code within a compressed file back to it’s original position in a source file.
            + **[Plugins with gulp sourcemaps support](https://github.com/floridoo/gulp-sourcemaps/wiki/Plugins-with-gulp-sourcemaps-support)**: A list of plugins which support gulp-sourcemaps.
            + **[gulp-sourcemaps](https://github.com/floridoo/gulp-sourcemaps)**: Source map support for Gulp.js
            + **[vinyl-sourcemaps-apply](https://www.npmjs.com/package/vinyl-sourcemaps-apply)**: Apply a source map to a vinyl file, merging it with preexisting source maps.
        + **Utility**: Tools and parts for building gulp plugins.
            + **[gulp-count](https://www.npmjs.com/package/gulp-count)**: Count files in a vinyl stream.
            + **[gulp-debug](https://www.npmjs.com/package/gulp-debug)**: Debug vinyl file streams to see what files are run through your gulp pipeline.
            + **[gulp-size](https://github.com/sindresorhus/gulp-size)**: Logs out the total size of files in the stream and optionally the individual file-sizes.
            + **[lazypipe](https://www.npmjs.com/package/lazypipe)**: Lazypipe allows you to create an immutable, lazily-initialized pipeline. It's designed to be used in an environment where you want to reuse partial pipelines, such as with gulp.
            + **[map-stream](https://github.com/dominictarr/map-stream)**: Create a through stream from an asyncronous function.
        + **[Vinyl](https://github.com/gulpjs/vinyl)**: Vinyl is a very simple metadata object that describes a file.
            + **[gulp-chmod](https://github.com/sindresorhus/gulp-chmod)**: Change permissions of Vinyl files.
            + **[gulp-rename](https://github.com/hparra/gulp-rename)**: A plugin to rename files easily.
            + **[mem-fs](https://www.npmjs.com/package/mem-fs)**: Simple in-memory vinyl file store.
            + **[vinyl-ast](https://www.npmjs.com/package/vinyl-ast)**: Parse-once and generate-once AST tool bridge for Gulp plugins.
            + **[vinyl-buffer](https://www.npmjs.com/package/vinyl-buffer)**: Creates a transform stream that takes vinyl files as input, and outputs buffered (isStream() === false) vinyl files as output.
            + **[vinyl-file](https://www.npmjs.com/package/vinyl-file)**: Create a vinyl file from an actual file.
            + **[vinyl-fs](https://github.com/wearefractal/vinyl-fs)**: Vinyl adapter for the file system.
            + **[vinyl-fs-fake](https://www.npmjs.com/package/vinyl-fs-fake)**: A vinyl adapter that extends vinyl-fs to allow for easy debugging by passing in virtual files instead of globs, and calling a function instead of writing.
            + **[vinyl-git](https://www.npmjs.com/package/vinyl-git)**: Vinyl adapter for git.
            + **[vinyl-map](https://github.com/hughsk/vinyl-map)**: Map vinyl files' contents as strings, so you can easily use existing code without needing yet another gulp plugin!
            + **[vinyl-paths](https://www.npmjs.com/package/vinyl-paths)**: Get the file paths in a vinyl stream.
            + **[vinyl-source-buffer](https://www.npmjs.com/package/vinyl-source-buffer)**: Convert a text stream into a vinyl pipeline whose content is a buffer.
            + **[vinyl-source-stream](https://www.npmjs.com/package/vinyl-source-stream)**: Use conventional text streams at the start of your gulp or vinyl pipelines, making for nicer interoperability with the existing npm stream.
            + **[vinyl-to-stream](https://www.npmjs.com/package/vinyl-to-stream)**: Convert a vinyl stream to a text stream.
            + **[vinyl-transform](https://www.npmjs.com/package/vinyl-transform)**: Wraps standard text transform streams so you can write fewer gulp plugins. Fulfills a similar use case to vinyl-map and vinyl-source-stream.
    + **[Meteor](https://www.meteor.com/)**: Meteor is a full-stack JavaScript platform for developing modern web and mobile applications. Meteor includes a key set of technologies for building connected-client reactive applications, a build tool, and a curated set of packages.
    + **[React](http://facebook.github.io/react/)**: React is a JavaScript library for creating user interfaces. Many people choose to think of React as the V in MVC. We built React to solve one problem: building large applications with data that changes over time.
        + **[3 Lightweight React Alternatives](https://www.sitepoint.com/react-alternatives-preact-virtualdom-deku/)**: Dan Prince explores Preact, VirtualDom & Deku.
        + **[A Stateless React App?](http://jamesknelson.com/state-react-1-stateless-react-app/)**: James K Nelson describes how to avoid state in React Components.
        + **[Block, Element, Modifying Your JavaScript Components](https://medium.com/seek-ui-engineering/block-element-modifying-your-javascript-components-d7f99fcab52b)**: Mark Dalgleish is discussing how to organize React code with BEM and build everything with Webpack.
        + **[CSS Modules To The Rescue.jsx](https://medium.com/@kadmil/css-modules-to-the-rescue-jsx-ded2db874d34)**: If you use react-like templates/components, use webpack CSS loader to enable CSS Modules and forget about global CSS problems.
        + **[Find Your Perfect React Starter Project](http://andrewhfarmer.com/starter-project/)**: A simple search engine for React boilerplates with the ability to pick the ingredients.
        + **[Full-Stack Redux Tutorial](http://teropa.info/blog/2015/09/10/full-stack-redux-tutorial.html)**: We will go through all the steps of constructing a Node+Redux backend and a React+Redux frontend for a real-world application, using test-first development.
        + **[Functional DOM Programming](https://medium.com/@floydophone/functional-dom-programming-67d81637d43)**: One of the earliest intros to React and its purpose by Pete Hunt.
        + **[Functional Principles In React](https://www.youtube.com/watch?v=1uRC3hmKQnM)**: Jessica Kerr talks about four functional principles: Composition, Declarative Style, Isolation and Flow Of Data, and their usage in React.
        + **[Getting Started with TDD in React](https://semaphoreci.com/community/tutorials/getting-started-with-tdd-in-react)**: Learn how to test React components using a TDD approach with minimal setup, while learning exactly what to test and how to avoid common pitfalls.
        + **[Getting to Grips with React (as an Angular developer)](https://daveceddia.com/to-react-from-angular/)**: In a series of posts Dave Ceddia tries to help you apply your hard-won knowledge of “Angularisms” to React.
        + **[How to Handle State in React. The Missing FAQ](https://medium.com/react-ecosystem/how-to-handle-state-in-react-6f2d3cd73a0c)**: Osmel Mora challenges the common misconception that you always need a Flux-like architecture in your React apps.
        + **[How we use the Flux architecture in Delve](https://medium.com/@delveeng/how-we-use-the-flux-architecture-in-delve-effc551f8fbc)**: Øystein Hallaråker describes how Delve utilizes the Flux application architecture.
        + **[Immutable Data and React](https://www.youtube.com/watch?v=I7IdS-PbEgI)**: Lee Byron talks about how persistent immutable data structures work, and techniques for using them in a React applications with Immutable.js.
        + **[JSX Transform](https://github.com/alexmingoia/jsx-transform)**: JSX transpiler. A standard and configurable implementation of JSX decoupled from React.
        + **[Jest](https://github.com/facebook/jest)**: A JavaScript unit testing framework, used by Facebook to test services and React applications.
        + **[Model-View-Intent with React and RxJS](https://satishchilukuri.com/blog/entry/model-view-intent-with-react-and-rxjs)**: Satish Chilukuri shows an example implementation of MVI pattern with React.
        + **[Monocle](https://github.com/team-gryff/react-monocle)**: A developer tool for generating visual representations of your React app's component hierarchy.
        + **[Nothing New in React and Flux Except One Thing](http://staltz.com/nothing-new-in-react-and-flux-except-one-thing.html)**: Andre Staltz talks about aspects of React and Flux which make them innovative and compelling.
        + **[Pure UI](http://rauchg.com/2015/pure-ui/)**: Guillermo Rauch discusses the definition of an application’s UI as a pure function of application state.
        + **[React - Basic Theoretical Concepts](https://github.com/reactjs/react-basic)**: Sebastian Markbage attempts to formally explain his mental model of React. The intention is to describe this in terms of deductive reasoning that lead us to this design.
        + **[React App](https://github.com/kriasoft/react-app)**: React App is a small library powered by React, Universal Router and History that handles routing, navigation and rendering logic in isomorphic (universal) and single-page applications.
        + **[React Components, Elements, and Instances](https://medium.com/@dan_abramov/react-components-elements-and-instances-90800811f8ca#.9208ahtfb)**: Dan Abramov explains the Virtual DOM dictionary in React.
        + **[React Demystified](http://blog.reverberate.org/2014/02/react-demystified.html)**: This article is an attempt to explain the core ideas behind React.js and Virtual DOM.
        + **[React Native for Web](https://github.com/necolas/react-native-web)**: This project allows components built upon React Native to be run on the Web, and it manages all component styling out-of-the-box.
        + **[React Starter Kit](https://www.reactstarterkit.com/)**: Isomorphic web app boilerplate including Node.js, Express, GraphQL, React.js, Babel 6, PostCSS, Webpack, Browsersync.
        + **[React Storybook](https://github.com/kadirahq/react-storybook)**: Isolate your React UI Component development from the main app.
        + **[React Workshop](https://github.com/jesstelford/react-workshop)**: This is a self-directed workshop. Follow along to the steps at your own pace, and feel free to ask your instructors questions as you go.
        + **[React in Patterns](https://github.com/krasimir/react-in-patterns)**: List of design patterns/techniques used while developing with React.
        + **[React vs Incremental DOM vs Glimmer](https://auth0.com/blog/2015/11/20/face-off-virtual-dom-vs-incremental-dom-vs-glimmer/)**: In this post we will explore three technologies to build dynamic DOMs. We will also run benchmarks and find out which one is faster.
        + **[React: Rethinking best practices (2013)](https://www.youtube.com/watch?v=x7cQ3mrcKaY)**: A video introduction to React by Pete Hunt.
        + **[ReactPerfTool](https://github.com/RamonGebben/react-perf-tool)**: ReactPerfTool tries to give you a more visual way of debugging performance of your React application. It does this by using the addons delivered by the React team and community to get measurements and visualize this using graphs.
        + **[Removing User Interface Complexity, or Why React is Awesome](http://jlongster.com/Removing-User-Interface-Complexity,-or-Why-React-is-Awesome)**: In this post James Long tries not to evangelize React specifically, but to explain why its technique is profound.
        + **[Rethinking Best Practices](https://www.youtube.com/watch?v=x7cQ3mrcKaY)**: Pete Hunt talks about React's design decisions challenging established best practices.
        + **[Retractor](https://github.com/LiquidLabsGmbH/retractor)**: Retractor exposes the internals of a React application for end-to-end testing purposes. This allows you to select DOM nodes based on the name of the React Component that rendered the node as well as its state or properties.
        + **[Some Problems with React/Redux](http://staltz.com/some-problems-with-react-redux.html)**: André Staltz goes through the pros and cons of React + Redux.
        + **[Taming the React Setup](http://developer.telerik.com/featured/taming-react-setup/)**: Cody Lindley lays out seven React setups in this article and explains the relation of React to BYOA (Bring Your Own Architecture) approach.
        + **[Testing a React & Redux Codebase](http://silvenon.com/testing-react-and-redux/)**: This series aims to be a very comprehensive guide through testing a React and Redux codebase, where you can really cover a lot with just unit tests because the code is mostly universal.
        + **[The Bare Minimum to Work with React](http://krasimirtsonev.com/blog/article/The-bare-minimum-to-work-with-React)**: Krasimir Tsonev describes how to start working with React after installing only 7 dependencies and learning only three commands.
        + **[The Redux Ecosystem](https://medium.com/@denisraslov/the-redux-ecosystem-539c630ec521)**: Let’s take a look at most of the features that you’ll have to deal with when the time comes, — and where React & Redux themselves can’t help you.
        + **[The SoundCloud Client in React + Redux](http://www.robinwieruch.de/the-soundcloud-client-in-react-redux/)**: After finishing this step by step tutorial you will be able to author your own React + Redux project with Webpack and Babel.
        + **[Tutorial: Cloning Yelp](https://www.fullstackreact.com/articles/react-tutorial-cloning-yelp/)**: This post will guide you through building a full React app, even with little to no experience in the framework. We are going to build a Yelp clone in React.
        + **[Using React to Sync Updates and Offline Activity](https://medium.com/@firasd/interface-from-data-using-react-to-sync-updates-and-offline-activity-across-devices-f672b213701c)**: Firas Durri describes how React based architectures make syncing state across devices much easier.
        + **[What Developers Need to Know about MVI (Model-View-Intent)](http://thenewstack.io/developers-need-know-mvi-model-view-intent/)**: The article explains the general MVI pattern and how it relates to React, Reactive Programming and Cycle.js
        + **[Why Did You Update?](https://github.com/garbles/why-did-you-update)**: A function that monkey patches React and notifies you in the console when potentially unnecessary re-renders occur.
        + **[Why did we build React?](http://facebook.github.io/react/blog/2013/06/05/why-react.html)**: Pete Hunt tries to explain why Facebook devs built React in the first place.
    + **[Yeoman](http://yeoman.io/)**: Yeoman helps you to kickstart new projects, prescribing best practices and tools to help you stay productive. It provides a generator ecosystem.
    + **[jQuery](https://jquery.com/)**: jQuery is a fast, small, and feature-rich JavaScript library. It makes things like HTML document traversal and manipulation, event handling, animation, and Ajax much simpler.
        + **Alternatives**: Other libraries which intend to replace jQuery in one way or another.
            + **[Cash](https://github.com/kenwheeler/cash)**: Cash is a small library for modern browsers that provides jQuery style syntax for manipulating the DOM.
            + **[Chibi](https://github.com/kylebarrow/chibi)**: Chibi focuses on just the essentials, melted down and mixed with optimisation rainbows to create a really light micro-library that allows you to do awesome things.
            + **[DOM CSS](https://github.com/mattdesl/dom-css)**: Small module for fast and reliable DOM styling.
            + **[Minified.js](http://minifiedjs.com/)**: Minified.js is a client-side JavaScript library that's both powerful and small. It offers jQuery-like features and utility functions with a single, consistent API.
            + **[Plain.js](https://plainjs.com/javascript/)**: Vanilla JS utilities for writing powerful web applications without jQuery.
            + **[Zepto.js](http://zeptojs.com/)**: Zepto is a minimalist JavaScript library for modern browsers with a largely jQuery-compatible API.
        + **Authoring jQuery Plugins**: jQuery is an utility library and a plugin framework. This section collects resources about creating such plugins.
            + **[Advanced Plugin Concepts](http://learn.jquery.com/plugins/advanced-plugin-concepts/)**: A collection of best practices for jQuery plugin authoring.
            + **[How to Create a Basic Plugin](http://learn.jquery.com/plugins/basic-plugin-creation/)**: The article describes basic plugin creation and provides a simple boilerplate.
            + **[Signs of a poorly written jQuery plugin](https://remysharp.com/2010/06/03/signs-of-a-poorly-written-jquery-plugin)**: Collection of jQuery plugin antipatterns.
            + **[The Ultimate Guide to Writing jQuery Plugins](https://websanova.com/blog/jquery/the-ultimate-guide-to-writing-jquery-plugins)**: A comprehensive guide on how to develop jQuery plugins including a simple boilerplate.
            + **[Writing Stateful Plugins with the jQuery UI Widget Factory](http://learn.jquery.com/plugins/stateful-plugins-with-widget-factory/)**: The article demonstrates the capabilities of the Widget Factory by building a simple progress bar plugin.
            + **[jQuery Boilerplate](https://github.com/jquery-boilerplate/jquery-boilerplate)**: This project won't seek to provide a perfect solution to every possible pattern, but will attempt to cover a simple template for beginners and above.
            + **[jQuery Plugin Patterns](https://github.com/jquery-boilerplate/jquery-patterns)**: This project won't seek to provide implementations for every possible pattern, but will attempt to cover popular patterns developers often use in the wild.
        + **[Pragmatic jQuery Style](https://github.com/yuanyan/pragmatic-jquery)**: Coding guidelines for working with jQuery.
        + **[jQuery Fundamentals](http://jqfundamentals.com/)**: A guide to the basics of jQuery including a built-in editor for examples.
        + **[jQuery UI](http://jqueryui.com/)**: jQuery UI is a curated set of user interface interactions, effects, widgets, and themes built on top of the jQuery JavaScript Library.
            + **[Learning jQuery UI](http://learn.jquery.com/jquery-ui/)**: Series of articles about jQuery UI on learn.jquery.com.
+ **News**: Websites & newsletters which provide daily and weekly news related to frontend web development.
    + **[A Drip of JavaScript](http://adripofjavascript.com/)**: One quick JavaScript tip, delivered to your inbox every other week.
    + **[CSS Weekly](http://css-weekly.com/)**: Weekly E-Mail roundup of CSS articles, tutorials, experiments and tools
curated by Zoran Jambor.
    + **[Deterministic](https://deterministic.curated.co/)**: A weekly digest of interesting news and articles covering functional programming for the web, especially on the front end.
    + **[Frontend Dev Weekly](http://frontenddevweekly.com/)**: Front-end developer news, tools and inspiration hand-picked each week.
    + **[HTML5 Bookmarks](http://html5bookmarks.com/)**: Daily bookmarks of HTML5 related resources.
    + **[HTML5 Weekly](http://html5weekly.com/)**: A once–weekly HTML5 and Web Platform technology roundup. CSS 3, Canvas, WebSockets, WebGL, Native Client, and more.
    + **[JavaScript Weekly](http://javascriptweekly.com/)**: A free, once–weekly e-mail round-up of JavaScript news and articles.
    + **[Ng-Newsletter](http://www.ng-newsletter.com/)**: The free, weekly newsletter of the best AngularJS content on the web.
    + **[Responsive Design Newsletter](http://responsivedesignweekly.com/)**: A free, once–weekly round-up of responsive design articles, tools, tips, tutorials and inspirational links.
    + **[WDRL](https://wdrl.info/)**: A handcrafted, carefully selected list of web development related resources. Curated and published usually every week.
    + **[Web Design Weekly](https://web-design-weekly.com/)**: A once a week email with no spam, no rambling. Just pure awesome links to the best news and articles to hit the interweb during the week.
    + **[Web Platform Daily](http://webplatformdaily.org/)**: Daily digest of web development news.
    + **[Web Tools Weekly](http://webtoolsweekly.com/)**: Web Tools Weekly is a front-end development and web design newsletter with a focus on tools.
    + **[echo.js](http://www.echojs.com/)**: Echo JS is a community-driven news site entirely focused on JavaScript development, HTML5, and front-end news.
+ **Notable Community Members**: Important engineers, evangelists, architects and other celebrities.
    + **[Addy Osmani](https://addyosmani.com/)**: Engineer at Google working on open web tooling.
        + **[Learning JavaScript Design Patterns](https://addyosmani.com/resources/essentialjsdesignpatterns/book/)**: In this free book Addy Osmani explores applying both classical and modern design patterns to the JavaScript programming language.
        + **[Patterns For Large-Scale JavaScript Application Architecture](https://addyosmani.com/largescalejavascript/)**: An extensive overview by Addy Osmani of existing architectural solutions in the frontend development field.
        + **[Writing Modular JavaScript With AMD, CommonJS & ES Harmony](https://addyosmani.com/writing-modular-js/)**: In this article Addy Osmani reviewes several of the options available for writing modular JavaScript using modern module formats AMD, CommonJS and ES6 Modules.
    + **[Alex Sexton](https://alexsexton.com/)**: Alex Sexton is an engineer at Stripe. He is on the Modernizr core team, the  jQuery Board of Directors, as well as the Dojo Foundation Board.
        + **[Modernizr](https://modernizr.com/)**: It’s a collection of superfast tests – or “detects” as we like to call them – which run as your web page loads, then you can use the results to tailor the experience to the user.
    + **[André Staltz](http://staltz.com/)**: Founder of the cycle.js framework and important contributor to ReactiveX.
        + **[Cycle.js and Functional Reactive User Interfaces](https://www.youtube.com/watch?v=uNZnftSksYg)**: In this talk we will discover how Cycle.js is purely reactive and functional, and why it's an interesting alternative to React.
        + **[Dynamics of Change: why Reactivity Matters](https://www.youtube.com/watch?v=v68ppDlvHqs)**: In this talk we will see when passive or reactive strategy is advantageous, and how the reactive strategy is a sensible default.
        + **[MVI in Cycle.js Docs](http://cycle.js.org/model-view-intent.html)**: André Staltz describes how to refactor an application into MVI pattern.
        + **[Nothing New in React and Flux Except One Thing](http://staltz.com/nothing-new-in-react-and-flux-except-one-thing.html)**: Andre Staltz talks about aspects of React and Flux which make them innovative and compelling.
        + **[RxMarbles](http://rxmarbles.com/)**: A webapp for experimenting with diagrams of Rx Observables, for learning purposes.
        + **[Some Problems with React/Redux](http://staltz.com/some-problems-with-react-redux.html)**: André Staltz goes through the pros and cons of React + Redux.
        + **[The Introduction to Reactive Programming](https://gist.github.com/staltz/868e7e9bc2a7b8c1f754)**: André Staltz provides a complete introduction to the Reactive Programming and RxJS.
        + **[Unidirectional Data Flow Architectures (Talk)](https://vimeo.com/168652278)**: Andre Staltz compares modern architecture patterns including Flux, Redux, Model-View-Intent, Elm Arch and BEST.
        + **[What if the User was a Function?](https://www.youtube.com/watch?v=1zj7M1LnJV4)**: In this video André Staltz talks about the input/output cycle between humans and computers and how to take advantage of this model by using FRP and event streams.
        + **[Why We Built Xstream](http://staltz.com/why-we-built-xstream.html)**: The authors needed a stream library tailored for Cycle.js. It needs to be “hot” only, small in kB size and it should have only a few and intuitive operators.
        + **[Xstream](https://github.com/staltz/xstream)**: An extremely intuitive, small, and fast functional reactive stream library for JavaScript.
            + **[Why We Built Xstream](http://staltz.com/why-we-built-xstream.html)**: The authors needed a stream library tailored for Cycle.js. It needs to be “hot” only, small in kB size and it should have only a few and intuitive operators.
    + **[Brad Frost](http://bradfrost.com/)**: Web designer, speaker, writer, consultant, musician, and artist in beautiful Pittsburgh.
        + **[Atomic Design](http://atomicdesign.bradfrost.com/table-of-contents/)**: Atomic Design discusses the importance of crafting robust design systems, and introduces a methodology for which to create smart, deliberate interface systems.
            + **[A More Seamless Workflow — Style Guides for Better Design and Development](https://medium.com/@AshConnolly/a-more-seamless-workflow-style-guides-for-better-design-and-development-639fc55be28c)**: Ash Connolly explains what styles guides are and which benefits they bring to designers and developers.
            + **[Atomic Docs](http://atomicdocs.io/)**: Atomic Docs is a styleguide generator and component manager. Atomic Docs is built in PHP. Inspired by Brad Frost's Atomic Design principles.
            + **[Atomic Lab](http://steelydylan.github.io/atomic-lab/)**: Template sharing and coding environment based on atomic design.
        + **[Responsive Navigation Patterns](http://bradfrost.com/blog/web/responsive-nav-patterns/)**: The article describes some of the more popular techniques for handling navigation in responsive designs.
    + **[Brian Lonsdorf](https://github.com/DrBoolean)**: Lead UXE Engineer at Salesforce, JavaScript developer and speaker known for his work in functional programming community.
        + **[A Million Ways to Fold in JS](https://www.youtube.com/watch?v=JZSoPZUoR58)**: Brian Lonsdorf provides many functional alternatives to loops in this video.
        + **[Debugging Functional](https://medium.com/@drboolean/debugging-functional-7deb4688a08c)**: This post will demonstrate a simple solution that can go a long way to enhance the debugging experience in functional JavaScript applications.
        + **[Free Monads Video Series](https://www.youtube.com/watch?v=WH5BrkzGgQY&list=PLK_hdtAJ4KqUWp5LJdLOgkD_8qKW0iAHi&index=1)**: A video series on free monads by Brian Lonsdorf explaining Coyoneda, Free Monad and Interpretors.
        + **[Freeky](https://github.com/DrBoolean/freeky)**: Collection of free monads by Brian Lonsdorf.
        + **[Hey Underscore, You're Doing It Wrong!](http://functionaltalks.org/2013/05/27/brian-lonsdorf-hey-underscore-youre-doing-it-wrong/)**: In this talk Brian Lonsdorf gently takes a shot at underscore.js for not thinking about currying and partial function application in its library design.
        + **[JSAir - Functional and Immutable Design Patterns in JavaScript](https://javascriptair.com/episodes/2015-12-30/)**: An episode of JavaScript Air about "the how and why of functional programming and immutable design patterns in JavaScript" with Dab Abramov and Brian Lonsdorf as guests.
        + **[Lenses Quick n’ Dirty](https://vimeo.com/104807358)**: A video by Brian Lonsdorf that introduces lenses.
        + **[Lenses.js](https://github.com/DrBoolean/lenses)**: Composable kmett style lenses.
        + **[Monad a Day: Reader](https://vimeo.com/105300347)**: Short video by Brian Lonsdorf about the Reader Monad.
        + **[Monad a day 1: Reader](https://vimeo.com/105300347)**: A video by Brian Lonsdorf explaining the Reader Monad.
        + **[Monad a day 2: Future](https://vimeo.com/106008027)**: Brian Lonsdorf explains the Future monad in this video.
        + **[Monad a day 3: State](https://vimeo.com/109984691)**: Brian Lonsdorf explains the State monad in this video.
        + **[Mostly Adequate Guide to Functional Programming](https://drboolean.gitbooks.io/mostly-adequate-guide/content/)**: A book by Brian Lonsdorf that introduces algebraic functional programming in JavaScript.
    + **[Charles Max Wood](https://twitter.com/cmaxw)**: Podcaster at Devchat.tv, organizer of remote confs such as Angular RC, React RC, Rails RC. Software consultant and developer.
        + **[Adventures in Angular](https://devchat.tv/adv-in-angular)**: Adventures in Angular is a weekly podcast dedicated to the Angular JavaScript framework and related technologies, tools, languages, and practices.
        + **[JavaScript Jabber](https://devchat.tv/js-jabber/)**: A weekly podcast about JavaScript, including Node.js, Front-End Technologies, Careers, Teams and more.
    + **[Chris Coyier](http://chriscoyier.net/)**: Designer at Codepen. Writer at CSS-Tricks. Podcaster at ShopTalk.
        + **[Responsive Data Tables](https://css-tricks.com/responsive-data-tables/)**: Several ideas by Chris Coyier on how to deal with responsive tables.
    + **[Douglas Crockford](http://www.crockford.com/)**: Computer programmer who is best known for his ongoing involvement in the development of the JavaScript language, for having popularized the data format JSON, and for developing JSLint and JSMin.
        + **[Monads and Gonads](https://www.youtube.com/watch?v=dkZFtimgAcM)**: In this video from YUIConf 2012, Douglas Crockford attempts to break the long-standing Monad tutorial curse by explaining the concept and applications of monads in a way that is actually understandable to the audience.
        + **[Prototypal Inheritance in JavaScript](http://javascript.crockford.com/prototypal.html)**: An article by Douglas Crockford introducing the Object.create() method and describing the rational behind it.
    + **[James Long](http://jlongster.com/)**: Works on Firefox Developer Tools at Mozilla.
        + **[A Study on Solving Callbacks with JavaScript Generators](http://jlongster.com/A-Study-on-Solving-Callbacks-with-JavaScript-Generators)**: This article describes how Generators help fight callback hell.
        + **[Removing User Interface Complexity, or Why React is Awesome](http://jlongster.com/Removing-User-Interface-Complexity,-or-Why-React-is-Awesome)**: In this post James Long tries not to evangelize React specifically, but to explain why its technique is profound.
        + **[Transducers.js Library by James Long](https://github.com/jlongster/transducers.js)**: A small library for generalized transformation of data (inspired by Clojure's transducers)
            + **[Transducers.js Round 2 with Benchmarks](http://jlongster.com/Transducers.js-Round-2-with-Benchmarks)**: Refactored version of Transducers.js, some benchmarks, Laziness, the transformer protocoll.
            + **[Transducers.js: A JavaScript Library for Transformation of Data](http://jlongster.com/Transducers.js--A-JavaScript-Library-for-Transformation-of-Data)**: A post announcing the transducers.js library with some explanation.
        + **[Transducers.js Round 2 with Benchmarks](http://jlongster.com/Transducers.js-Round-2-with-Benchmarks)**: Refactored version of Transducers.js, some benchmarks, Laziness, the transformer protocoll.
        + **[Transducers.js: A JavaScript Library for Transformation of Data](http://jlongster.com/Transducers.js--A-JavaScript-Library-for-Transformation-of-Data)**: A post announcing the transducers.js library with some explanation.
    + **[Jonathan Snook](http://snook.ca/about/)**: A web designer and developer who is currently UX Architect at Xero. Former lead frontend developer at Shopify.
        + **[SMACSS](https://smacss.com/book/)**: SMACSS (pronounced “smacks”) is a way to examine your design process and as a way to fit those rigid frameworks into a flexible thought process. It is an attempt to document a consistent approach to site development when using CSS.
    + **[Mikito Takada (mixu)](http://mixu.net/)**: Software engineer at Stripe.
        + **[Learn CSS Layout the pedantic way](http://book.mixu.net/css/)**: Walks you through every major concept in CSS layout, without trying to simplify away the underlying mechanisms described in the CSS 2.1 and flexbox specs.
        + **[Single Page Apps in Depth](http://singlepageappbook.com/)**: This free book is what I wanted when I started working with single page apps. It's not an API reference on a particular framework, rather, the focus is on discussing patterns, implementation choices and decent practices.
    + **[Nicholas C. Zakas](https://www.nczonline.net/about/)**: Former principal front-end engineer at Yahoo! and YUI developer. Leads a team of frontend engineers at Box now.
        + **[Box Tech Talk: Scalable JavaScript Application Architecture](https://www.youtube.com/watch?v=mKouqShWI4o)**: A video by Nicholas Zakas (2012) about JavaScript Architecture.
        + **[Scalable JavaScript Application Architecture](https://www.youtube.com/watch?v=vXjVFPosQHw)**: In this video (2011) Nicholas Zakas discusses frontend architecture for complex, modular web applications with significant JavaScript elements.
        + **[T3](http://t3js.org/)**: T3 is a minimalist JavaScript framework sponsored by Box Inc. that provides core structure to code.
        + **[Understanding ECMAScript 6](https://leanpub.com/understandinges6/read)**: Free (as in pay what you want) E-Book by Nicholas C. Zakas describing the new features in EcmaScript 6.
    + **[Nicolas Gallagher](http://nicolasgallagher.com/)**: Frontend Engineer at Twitter.
        + **[Normalize.css](http://necolas.github.io/normalize.css/)**: A modern, HTML5-ready alternative to CSS resets.
    + **[Pete Hunt](https://github.com/petehunt)**: Co-founder & CEO @HelloSmyte. Ex-FB and Instagram. Worked on React.js.
        + **[Functional DOM Programming](https://medium.com/@floydophone/functional-dom-programming-67d81637d43)**: One of the earliest intros to React and its purpose by Pete Hunt.
        + **[React: Rethinking best practices (2013)](https://www.youtube.com/watch?v=x7cQ3mrcKaY)**: A video introduction to React by Pete Hunt.
        + **[Why did we build React?](http://facebook.github.io/react/blog/2013/06/05/why-react.html)**: Pete Hunt tries to explain why Facebook devs built React in the first place.
+ **Organizations**: Commercial companies and nonprofit organizations around web development.
    + **[Airbnb](http://airbnb.io/projects/)**: Airbnb is a website for people to list, find, and rent lodging.
        + **[Airbnb CSS + Sass Style Guide](http://airbnb.io/projects/css/)**: This style guide covers Terminology, Rule Declaration, Selectors, Properties, Formatting, Comments, OOCSS and BEM, ID Selectors, JavaScript hooks
Sass, Syntax, Ordering, Mixins, Placeholders, Nested selectors.
        + **[Airbnb JavaScript Style Guide](http://airbnb.io/projects/javascript/)**: A style guide for writing JavaScript code at Airbnb.
        + **[Enzyme](http://airbnb.io/projects/enzyme/)**: Enzyme is a JavaScript Testing utility for React that makes it easier to assert, manipulate, and traverse your React Components’ output.
        + **[Polyglot](http://airbnb.io/polyglot.js/)**: Polyglot.js is a I18n helper library written in JavaScript, made to work both in the browser and in CommonJS environments (Node). It provides a simple solution for interpolation and pluralization.
        + **[Turbocharged JavaScript Refactoring with Codemods](https://medium.com/airbnb-engineering/turbocharged-javascript-refactoring-with-codemods-b0cae8b326b9)**: Joe Lencioni describes how they used codemods to transform a large JavaScript code base at AirBnB
    + **[Box Inc.](http://opensource.box.com/)**: Box is an online file sharing and content management service for businesses based in Redwood City, California.
        + **[Leche](https://github.com/box/leche)**: A JavaScript testing utility designed to work with Mocha and Sinon. This is intended for use both by Node.js and in browsers, so any changes must work in both locations.
        + **[Nicholas C. Zakas](https://www.nczonline.net/about/)**: Former principal front-end engineer at Yahoo! and YUI developer. Leads a team of frontend engineers at Box now.
            + **[Box Tech Talk: Scalable JavaScript Application Architecture](https://www.youtube.com/watch?v=mKouqShWI4o)**: A video by Nicholas Zakas (2012) about JavaScript Architecture.
            + **[Scalable JavaScript Application Architecture](https://www.youtube.com/watch?v=vXjVFPosQHw)**: In this video (2011) Nicholas Zakas discusses frontend architecture for complex, modular web applications with significant JavaScript elements.
            + **[T3](http://t3js.org/)**: T3 is a minimalist JavaScript framework sponsored by Box Inc. that provides core structure to code.
            + **[Understanding ECMAScript 6](https://leanpub.com/understandinges6/read)**: Free (as in pay what you want) E-Book by Nicholas C. Zakas describing the new features in EcmaScript 6.
        + **[Shalam](https://github.com/box/shalam)**: A friendly tool for CSS spriting. Shalam allows you to add Retina-friendly, high-quality image sprites to your website without modifying any markup.
        + **[T3](http://t3js.org/)**: T3 is a minimalist JavaScript framework sponsored by Box Inc. that provides core structure to code.
        + **[stalker](https://github.com/box/stalker)**: A jQuery plugin allowing elements to follow the user as they scroll a page.
    + **[Facebook](https://code.facebook.com/projects/)**: Facebook is a corporation and online social networking service headquartered in Menlo Park, California, in the United States.
        + **[Immutable.js](https://github.com/facebook/immutable-js/)**: Immutable persistent data collections for Javascript which increase efficiency and simplicity.
        + **[React](http://facebook.github.io/react/)**: React is a JavaScript library for creating user interfaces. Many people choose to think of React as the V in MVC. We built React to solve one problem: building large applications with data that changes over time.
            + **[3 Lightweight React Alternatives](https://www.sitepoint.com/react-alternatives-preact-virtualdom-deku/)**: Dan Prince explores Preact, VirtualDom & Deku.
            + **[A Stateless React App?](http://jamesknelson.com/state-react-1-stateless-react-app/)**: James K Nelson describes how to avoid state in React Components.
            + **[Block, Element, Modifying Your JavaScript Components](https://medium.com/seek-ui-engineering/block-element-modifying-your-javascript-components-d7f99fcab52b)**: Mark Dalgleish is discussing how to organize React code with BEM and build everything with Webpack.
            + **[CSS Modules To The Rescue.jsx](https://medium.com/@kadmil/css-modules-to-the-rescue-jsx-ded2db874d34)**: If you use react-like templates/components, use webpack CSS loader to enable CSS Modules and forget about global CSS problems.
            + **[Find Your Perfect React Starter Project](http://andrewhfarmer.com/starter-project/)**: A simple search engine for React boilerplates with the ability to pick the ingredients.
            + **[Full-Stack Redux Tutorial](http://teropa.info/blog/2015/09/10/full-stack-redux-tutorial.html)**: We will go through all the steps of constructing a Node+Redux backend and a React+Redux frontend for a real-world application, using test-first development.
            + **[Functional DOM Programming](https://medium.com/@floydophone/functional-dom-programming-67d81637d43)**: One of the earliest intros to React and its purpose by Pete Hunt.
            + **[Functional Principles In React](https://www.youtube.com/watch?v=1uRC3hmKQnM)**: Jessica Kerr talks about four functional principles: Composition, Declarative Style, Isolation and Flow Of Data, and their usage in React.
            + **[Getting Started with TDD in React](https://semaphoreci.com/community/tutorials/getting-started-with-tdd-in-react)**: Learn how to test React components using a TDD approach with minimal setup, while learning exactly what to test and how to avoid common pitfalls.
            + **[Getting to Grips with React (as an Angular developer)](https://daveceddia.com/to-react-from-angular/)**: In a series of posts Dave Ceddia tries to help you apply your hard-won knowledge of “Angularisms” to React.
            + **[How to Handle State in React. The Missing FAQ](https://medium.com/react-ecosystem/how-to-handle-state-in-react-6f2d3cd73a0c)**: Osmel Mora challenges the common misconception that you always need a Flux-like architecture in your React apps.
            + **[How we use the Flux architecture in Delve](https://medium.com/@delveeng/how-we-use-the-flux-architecture-in-delve-effc551f8fbc)**: Øystein Hallaråker describes how Delve utilizes the Flux application architecture.
            + **[Immutable Data and React](https://www.youtube.com/watch?v=I7IdS-PbEgI)**: Lee Byron talks about how persistent immutable data structures work, and techniques for using them in a React applications with Immutable.js.
            + **[JSX Transform](https://github.com/alexmingoia/jsx-transform)**: JSX transpiler. A standard and configurable implementation of JSX decoupled from React.
            + **[Jest](https://github.com/facebook/jest)**: A JavaScript unit testing framework, used by Facebook to test services and React applications.
            + **[Model-View-Intent with React and RxJS](https://satishchilukuri.com/blog/entry/model-view-intent-with-react-and-rxjs)**: Satish Chilukuri shows an example implementation of MVI pattern with React.
            + **[Monocle](https://github.com/team-gryff/react-monocle)**: A developer tool for generating visual representations of your React app's component hierarchy.
            + **[Nothing New in React and Flux Except One Thing](http://staltz.com/nothing-new-in-react-and-flux-except-one-thing.html)**: Andre Staltz talks about aspects of React and Flux which make them innovative and compelling.
            + **[Pure UI](http://rauchg.com/2015/pure-ui/)**: Guillermo Rauch discusses the definition of an application’s UI as a pure function of application state.
            + **[React - Basic Theoretical Concepts](https://github.com/reactjs/react-basic)**: Sebastian Markbage attempts to formally explain his mental model of React. The intention is to describe this in terms of deductive reasoning that lead us to this design.
            + **[React App](https://github.com/kriasoft/react-app)**: React App is a small library powered by React, Universal Router and History that handles routing, navigation and rendering logic in isomorphic (universal) and single-page applications.
            + **[React Components, Elements, and Instances](https://medium.com/@dan_abramov/react-components-elements-and-instances-90800811f8ca#.9208ahtfb)**: Dan Abramov explains the Virtual DOM dictionary in React.
            + **[React Demystified](http://blog.reverberate.org/2014/02/react-demystified.html)**: This article is an attempt to explain the core ideas behind React.js and Virtual DOM.
            + **[React Native for Web](https://github.com/necolas/react-native-web)**: This project allows components built upon React Native to be run on the Web, and it manages all component styling out-of-the-box.
            + **[React Starter Kit](https://www.reactstarterkit.com/)**: Isomorphic web app boilerplate including Node.js, Express, GraphQL, React.js, Babel 6, PostCSS, Webpack, Browsersync.
            + **[React Storybook](https://github.com/kadirahq/react-storybook)**: Isolate your React UI Component development from the main app.
            + **[React Workshop](https://github.com/jesstelford/react-workshop)**: This is a self-directed workshop. Follow along to the steps at your own pace, and feel free to ask your instructors questions as you go.
            + **[React in Patterns](https://github.com/krasimir/react-in-patterns)**: List of design patterns/techniques used while developing with React.
            + **[React vs Incremental DOM vs Glimmer](https://auth0.com/blog/2015/11/20/face-off-virtual-dom-vs-incremental-dom-vs-glimmer/)**: In this post we will explore three technologies to build dynamic DOMs. We will also run benchmarks and find out which one is faster.
            + **[React: Rethinking best practices (2013)](https://www.youtube.com/watch?v=x7cQ3mrcKaY)**: A video introduction to React by Pete Hunt.
            + **[ReactPerfTool](https://github.com/RamonGebben/react-perf-tool)**: ReactPerfTool tries to give you a more visual way of debugging performance of your React application. It does this by using the addons delivered by the React team and community to get measurements and visualize this using graphs.
            + **[Removing User Interface Complexity, or Why React is Awesome](http://jlongster.com/Removing-User-Interface-Complexity,-or-Why-React-is-Awesome)**: In this post James Long tries not to evangelize React specifically, but to explain why its technique is profound.
            + **[Rethinking Best Practices](https://www.youtube.com/watch?v=x7cQ3mrcKaY)**: Pete Hunt talks about React's design decisions challenging established best practices.
            + **[Retractor](https://github.com/LiquidLabsGmbH/retractor)**: Retractor exposes the internals of a React application for end-to-end testing purposes. This allows you to select DOM nodes based on the name of the React Component that rendered the node as well as its state or properties.
            + **[Some Problems with React/Redux](http://staltz.com/some-problems-with-react-redux.html)**: André Staltz goes through the pros and cons of React + Redux.
            + **[Taming the React Setup](http://developer.telerik.com/featured/taming-react-setup/)**: Cody Lindley lays out seven React setups in this article and explains the relation of React to BYOA (Bring Your Own Architecture) approach.
            + **[Testing a React & Redux Codebase](http://silvenon.com/testing-react-and-redux/)**: This series aims to be a very comprehensive guide through testing a React and Redux codebase, where you can really cover a lot with just unit tests because the code is mostly universal.
            + **[The Bare Minimum to Work with React](http://krasimirtsonev.com/blog/article/The-bare-minimum-to-work-with-React)**: Krasimir Tsonev describes how to start working with React after installing only 7 dependencies and learning only three commands.
            + **[The Redux Ecosystem](https://medium.com/@denisraslov/the-redux-ecosystem-539c630ec521)**: Let’s take a look at most of the features that you’ll have to deal with when the time comes, — and where React & Redux themselves can’t help you.
            + **[The SoundCloud Client in React + Redux](http://www.robinwieruch.de/the-soundcloud-client-in-react-redux/)**: After finishing this step by step tutorial you will be able to author your own React + Redux project with Webpack and Babel.
            + **[Tutorial: Cloning Yelp](https://www.fullstackreact.com/articles/react-tutorial-cloning-yelp/)**: This post will guide you through building a full React app, even with little to no experience in the framework. We are going to build a Yelp clone in React.
            + **[Using React to Sync Updates and Offline Activity](https://medium.com/@firasd/interface-from-data-using-react-to-sync-updates-and-offline-activity-across-devices-f672b213701c)**: Firas Durri describes how React based architectures make syncing state across devices much easier.
            + **[What Developers Need to Know about MVI (Model-View-Intent)](http://thenewstack.io/developers-need-know-mvi-model-view-intent/)**: The article explains the general MVI pattern and how it relates to React, Reactive Programming and Cycle.js
            + **[Why Did You Update?](https://github.com/garbles/why-did-you-update)**: A function that monkey patches React and notifies you in the console when potentially unnecessary re-renders occur.
            + **[Why did we build React?](http://facebook.github.io/react/blog/2013/06/05/why-react.html)**: Pete Hunt tries to explain why Facebook devs built React in the first place.
        + **[Regenerator](https://github.com/facebook/regenerator)**: This package implements a source transformation that takes the proposed syntax for generators/yield from future versions of JS and spits out efficient JS-of-today (ES5) that behaves the same way.
    + **[Google](https://www.google.com/)**: Google’s mission is to organize the world’s information and make it universally accessible and useful.
        + **[Addy Osmani](https://addyosmani.com/)**: Engineer at Google working on open web tooling.
            + **[Learning JavaScript Design Patterns](https://addyosmani.com/resources/essentialjsdesignpatterns/book/)**: In this free book Addy Osmani explores applying both classical and modern design patterns to the JavaScript programming language.
            + **[Patterns For Large-Scale JavaScript Application Architecture](https://addyosmani.com/largescalejavascript/)**: An extensive overview by Addy Osmani of existing architectural solutions in the frontend development field.
            + **[Writing Modular JavaScript With AMD, CommonJS & ES Harmony](https://addyosmani.com/writing-modular-js/)**: In this article Addy Osmani reviewes several of the options available for writing modular JavaScript using modern module formats AMD, CommonJS and ES6 Modules.
        + **[Closure Compiler](https://developers.google.com/closure/compiler/)**: The Closure Compiler parses your JavaScript, analyzes it, removes dead code and rewrites and minimizes what's left. It also checks syntax, variable references, and types, and warns about common JavaScript pitfalls.
        + **[Introducing Incremental DOM](https://medium.com/google-developers/introducing-incremental-dom-e98f79ce2c5f)**: Incremental DOM is a library inspired by Virtual DOM developed at Google.
    + **[Microsoft](http://www.microsoft.com/)**: Microsoft Corporation is an American multinational technology company, that develops, manufactures, licenses, supports and sells computer software, consumer electronics and personal computers and services.
        + **[Dev Tools by Microsoft](https://developer.microsoft.com/en-us/microsoft-edge/tools/)**: These tools allow you to test your product on different version of Internet Explorer and Microsoft Edge.
        + **[Knockout.js](http://knockoutjs.com/)**: Knockout is a standalone JavaScript implementation of the Model-View-ViewModel pattern with templates.
        + **[Reactive Extensions (RxJS)](https://github.com/Reactive-Extensions/RxJS)**: RxJS is a set of libraries for composing asynchronous and event-based programs using observable sequences and fluent query operators.
            + **[Async JavaScript with Reactive Extensions](https://www.youtube.com/watch?v=XRYN2xt11Ek)**: Jafar Husain explains in this video how Netflix uses the Reactive Extensions (Rx) library to build responsive user experiences that strive to be event-driven, scalable and resilient.
            + **[Exploring Rx Operators: FlatMap](http://blog.thoughtram.io/rx/2016/08/01/exploring-rx-operators-flatmap.html)**: Christoph Burgdorf introduces the FlatMap operator and its usage for collections and observables.
            + **[Exploring Rx Operators: Map](http://blog.thoughtram.io/angular/2016/05/16/exploring-rx-operators-map.html)**: Christoph Burgdorf explains how to use the map operator in RxJS.
            + **[Functional Core Reactive Shell](http://www.mokacoding.com/blog/functional-core-reactive-shell/)**: Giovanni Lodi makes an overview of different architecture meta-patterns and describes his current findings about functional programming and observables as a way to control side effects.
            + **[Learn RX](http://reactivex.io/learnrx/)**: A series of interactive exercises for learning Microsoft's Reactive Extensions (Rx) Library for Javascript.
            + **[Learn RxJS](http://www.learnrxjs.io/)**: This site focuses on making RxJS concepts approachable, the examples clear and easy to explore, and features references throughout to the best RxJS related material on the web.
            + **[Real World Observables](https://medium.com/@sergimansilla/real-world-observables-1f65748c8f9)**: Sergi Mansilla writes an FTP client to use it as an example for a real world application based on RxJS.
            + **[Rx Training Games](https://github.com/JulienMoumne/rx-training-games)**: Rx Training Games is a coding playground that can be used to learn and practice Reactive Extensions coding grid-based games
            + **[Rx-Book](http://xgrommx.github.io/rx-book/index.html)**: A complete book about RxJS v.4.0.
            + **[RxMarbles](http://rxmarbles.com/)**: A webapp for experimenting with diagrams of Rx Observables, for learning purposes.
            + **[RxState](https://www.npmjs.com/package/rxstate)**: Simple opinionated state management library based on RxJS and Immutable.js
            + **[Taking Advantage of Observables in Angular 2](http://blog.thoughtram.io/angular/2016/01/06/taking-advantage-of-observables-in-angular2.html)**: Christoph Burgdorf describes the advantages of Observables and how you can use them in Angular 2 context.
            + **[Transducers with Observable Sequences](https://xgrommx.github.io/rx-book/content/getting_started_with_rxjs/creating_and_querying_observable_sequences/transducers.html)**: A chapter from the RxJS Book describing Transducers.
            + **[Why We Built Xstream](http://staltz.com/why-we-built-xstream.html)**: The authors needed a stream library tailored for Cycle.js. It needs to be “hot” only, small in kB size and it should have only a few and intuitive operators.
        + **[Visual Studio Code](https://code.visualstudio.com/)**: Build and debug modern web and cloud applications. VS Code is free and available on your favorite platform - Linux, Mac OSX, and Windows.
    + **[Mozilla](https://www.mozilla.org/)**: Mozilla is a community, which uses, develops, spreads and supports free software products. It is supported institutionally by the Mozilla Foundation and its tax-paying subsidiary, the Mozilla Corporation.
        + **[Firefox](https://www.mozilla.org/en-US/firefox/products/)**: Firefox is the highly popular free web browser. It is available for Linux, Mac, Windows, handheld devices, and in more than 70 different languages.
        + **[James Long](http://jlongster.com/)**: Works on Firefox Developer Tools at Mozilla.
            + **[A Study on Solving Callbacks with JavaScript Generators](http://jlongster.com/A-Study-on-Solving-Callbacks-with-JavaScript-Generators)**: This article describes how Generators help fight callback hell.
            + **[Removing User Interface Complexity, or Why React is Awesome](http://jlongster.com/Removing-User-Interface-Complexity,-or-Why-React-is-Awesome)**: In this post James Long tries not to evangelize React specifically, but to explain why its technique is profound.
            + **[Transducers.js Library by James Long](https://github.com/jlongster/transducers.js)**: A small library for generalized transformation of data (inspired by Clojure's transducers)
                + **[Transducers.js Round 2 with Benchmarks](http://jlongster.com/Transducers.js-Round-2-with-Benchmarks)**: Refactored version of Transducers.js, some benchmarks, Laziness, the transformer protocoll.
                + **[Transducers.js: A JavaScript Library for Transformation of Data](http://jlongster.com/Transducers.js--A-JavaScript-Library-for-Transformation-of-Data)**: A post announcing the transducers.js library with some explanation.
            + **[Transducers.js Round 2 with Benchmarks](http://jlongster.com/Transducers.js-Round-2-with-Benchmarks)**: Refactored version of Transducers.js, some benchmarks, Laziness, the transformer protocoll.
            + **[Transducers.js: A JavaScript Library for Transformation of Data](http://jlongster.com/Transducers.js--A-JavaScript-Library-for-Transformation-of-Data)**: A post announcing the transducers.js library with some explanation.
        + **[Mozilla Developer Network (MDN)](https://developer.mozilla.org/)**: The MDN is a complete learning platform for Web technologies and the software that powers the Web.
        + **[Nunjucks](http://mozilla.github.io/nunjucks/)**: A rich and powerful templating language for JavaScript.
    + **[Stripe](https://stripe.com/open-source)**: Stripe is an Irish technology company that allows both private individuals and businesses to accept payments over the Internet.
        + **[Alex Sexton](https://alexsexton.com/)**: Alex Sexton is an engineer at Stripe. He is on the Modernizr core team, the  jQuery Board of Directors, as well as the Dojo Foundation Board.
            + **[Modernizr](https://modernizr.com/)**: It’s a collection of superfast tests – or “detects” as we like to call them – which run as your web page loads, then you can use the results to tailor the experience to the user.
        + **[Mikito Takada (mixu)](http://mixu.net/)**: Software engineer at Stripe.
            + **[Learn CSS Layout the pedantic way](http://book.mixu.net/css/)**: Walks you through every major concept in CSS layout, without trying to simplify away the underlying mechanisms described in the CSS 2.1 and flexbox specs.
            + **[Single Page Apps in Depth](http://singlepageappbook.com/)**: This free book is what I wanted when I started working with single page apps. It's not an API reference on a particular framework, rather, the focus is on discussing patterns, implementation choices and decent practices.
        + **[jquery.mobilePhoneNumber](https://github.com/stripe/jquery.mobilePhoneNumber)**: A general purpose library for validating and formatting mobile phone numbers.
        + **[jquery.payment](https://github.com/stripe/jquery.payment)**: A general purpose library for building credit card forms, validating inputs and formatting numbers.
    + **[TODO Group](http://todogroup.org/)**: TODO is an open group of companies who want to collaborate on practices, tools, and other ways to run successful and effective open source projects and programs.
    + **[Twitter](https://twitter.com/)**: Twitter is an online social networking service that enables users to send and read short 140-character messages called "tweets".
        + **[Flight](http://flightjs.github.io/)**: An event-driven web framework, from Twitter.
        + **[Hogan.js](http://twitter.github.io/hogan.js/)**: Hogan.js is a 3.4k JS templating engine developed at Twitter. It was developed against the mustache test suite.
        + **[Nicolas Gallagher](http://nicolasgallagher.com/)**: Frontend Engineer at Twitter.
            + **[Normalize.css](http://necolas.github.io/normalize.css/)**: A modern, HTML5-ready alternative to CSS resets.
    + **[World Wide Web Consortium (W3C)](https://www.w3.org/)**: The W3C is an international community where Member organizations, a full-time staff, and the public work together to develop Web standards.
        + **[Architecture of the World Wide Web: Identification](https://www.w3.org/TR/webarch/#identification)**: This architecture document by W3C discusses the core design components of the Web. They are identification of resources, representation of resource state, and the protocols that support the interaction between agents and resources in the space.
        + **[CSS Flexible Box Layout Module Level 1](https://www.w3.org/TR/css-flexbox-1/)**: W3C specification for CSS flexbox.
        + **[Document Object Model (DOM) Technical Reports](https://www.w3.org/DOM/DOMTR)**: Specifications by the W3C.
        + **[Notes on Using ARIA in HTML](http://w3c.github.io/aria-in-html/)**: This document is a practical guide for developers on how to add accessibility information to HTML elements using the Accessible Rich Internet Applications specification.
        + **[Service Workers](https://www.w3.org/TR/service-workers/)**: A method that enables applications to take advantage of persistent background processing, including hooks to enable bootstrapping of web applications while offline.
            + **[Instant Loading Web Apps With An Application Shell Architecture](https://medium.com/google-developers/instant-loading-web-apps-with-an-application-shell-architecture-7c0c2f10c73)**: Addy Osmani describes how to leverage the Service Worker API to drastically improve the loading speed of your web application.
            + **[Introduction to Service Worker](http://www.html5rocks.com/en/tutorials/service-worker/introduction/)**: Matt Gaunt introduces the main features of Service Worker API in this article.
            + **[Is ServiceWorker Ready?](https://jakearchibald.github.io/isserviceworkerready/)**: Tracks the implementation status across the main browsers.
        + **[Shadow DOM W3C Editor's Draft](http://w3c.github.io/webcomponents/spec/shadow/)**: This specification describes a method of combining multiple DOM trees into one hierarchy and how these trees interact with each other within a document, thus enabling better composition of the DOM.
    + **[Yandex](https://www.yandex.com/)**: Yandex is one of the largest internet companies in Europe, operating Russia’s most popular search engine and its most visited website.
        + **[Block Element Modifier (BEM)](https://en.bem.info/method/)**: Methodology aimed at achieving fast to develop long-lived projects, team scalability, and code reuse.
            + **[A New Front-End Methodology: BEM](http://www.smashingmagazine.com/2012/04/a-new-front-end-methodology-bem/)**: An introduction by Varvara Stepanova at SmashingMagazine.
            + **[An Introduction to the BEM Methodology](http://webdesign.tutsplus.com/articles/an-introduction-to-the-bem-methodology--cms-19403)**: General introduction article on tutsplus.
            + **[BEM 101](https://css-tricks.com/bem-101/)**: A collaborative post by Joe Richardson, Robin Rendle, and CSS-Tricks staff giving an introduction to BEM with some good examples.
            + **[BEM I (finally) understand](https://m.alphasights.com/bem-i-finally-understand-b0c74815d5b0)**: In this article Andrei Popa will focus on the basics of BEM and how to approach simple to complex anatomies.
            + **[Battling BEM (Extended Edition): 10 Common Problems And How To Avoid Them](https://www.smashingmagazine.com/2016/06/battling-bem-extended-edition-common-problems-and-how-to-avoid-them/)**: This article aims to be useful for people who are already BEM enthusiasts and wish to use it more effectively or people who are curious to learn more about it.
            + **[Block, Element, Modifying Your JavaScript Components](https://medium.com/seek-ui-engineering/block-element-modifying-your-javascript-components-d7f99fcab52b)**: Mark Dalgleish is discussing how to organize React code with BEM and build everything with Webpack.
            + **[Emmet filter for BEM](http://docs.emmet.io/filters/bem/)**: If you’re writing your HTML and CSS code in OOCSS-style, Yandex’s BEM style specifically, you will like this filter. It provides some aliases and automatic insertions of common block and element names in classes.
            + **[Fifty Shades of BEM](http://blog.kaelig.fr/post/48196348743/fifty-shades-of-bem)**: Article describes different flavors of BEM.
            + **[How We Use BEM to Modularise Our CSS](https://m.alphasights.com/how-we-use-bem-to-modularise-our-css-82a0c39463b0)**: Andrei Popa describes the challenges, AlphaSights team had, implementing BEM in their projects.
            + **[Introduction To BEM Methodology (Toptal)](https://www.toptal.com/css/introduction-to-bem-methodology)**: General introduction to BEM methodology and platform.
            + **[MindBEMding – getting your head ’round BEM syntax](http://csswizardry.com/2013/01/mindbemding-getting-your-head-round-bem-syntax/)**: Article on csswizardry explaining the BEM syntax for CSS classes.
            + **[Pobem](https://github.com/bem-contrib/pobem)**: PostCSS plugin for BEM syntax.
            + **[Support for BEM modules in Sass 3.3](http://mikefowler.me/2013/10/17/support-for-bem-modules-sass-3.3/)**: The next major release of Sass is poised for release and with it comes real support for BEM-style modules...
            + **[To BEM or not to BEM](http://www.didoo.net/to-bem-or-not-to-bem/)**: A series of interviews on BEM methodology.
        + **[Yandex Browser](https://browser.yandex.com/)**: Chromium based browser developed by Yandex.
    + **[Zurb](http://zurb.com/)**: ZURB is a product design company since 1998. Through consulting, product design tools and training, they transform the way businesses approach Progressive Design.
        + **[Foundation](http://foundation.zurb.com/)**: Foundation provides a responsive grid and HTML and CSS UI components, templates, and code snippets, including typography, forms, buttons, navigation and other interface components, as well as optional JavaScript extensions.
        + **[Foundation for Emails 2](http://foundation.zurb.com/emails.html)**: Frontend Framework for E-Mails including a grid, global styles, aligment classes, buttons, callout panels, thumbnail styles, typography, visibility classes.
        + **[Responsive Email Templates](http://zurb.com/playground/responsive-email-templates)**: Zurb Studios put together this set of super awesome email templates so that you can make your email campaigns responsive.
+ **Podcasts**: A podcast is a form of digital media that consists of an episodic series of audio, video, digital radio, PDF, or ePub files subscribed to and downloaded automatically through web syndication or streamed online to a computer or mobile device.
    + **[Adventures in Angular](https://devchat.tv/adv-in-angular)**: Adventures in Angular is a weekly podcast dedicated to the Angular JavaScript framework and related technologies, tools, languages, and practices.
    + **[CDNify Podcasts](https://itunes.apple.com/us/podcast/cdnify/id786191888)**: The CDNify podcast covers all things tech, startup, web performance and acceleration.
    + **[JavaScript Air](https://javascriptair.com/)**: The live broadcast podcast all about JavaScript.
    + **[JavaScript Jabber](https://devchat.tv/js-jabber/)**: A weekly podcast about JavaScript, including Node.js, Front-End Technologies, Careers, Teams and more.
    + **[Non Breaking Space Show](http://goodstuff.fm/nbsp)**: Seeking out the best, brightest, and smartest creative people on digital art, design, and development. From workflows to life hacks, we examine why they do what they do and how they did it.
    + **[Shop Talk Show](http://shoptalkshow.com/)**: An internet radio show about the internet starring Dave Rupert and Chris Coyier.
    + **[The Big Web Show](http://5by5.tv/bigwebshow)**: The award winning Big Web Show features special guests and topics like web publishing, art direction, content strategy, typography, web technology, and more. It's everything web that matters.
    + **[The Web Ahead](http://5by5.tv/webahead)**: Conversations with world experts on changing technologies and future of the web. The Web Ahead is your shortcut to keeping up.
    + **[Web Security Warrior](https://devchat.tv/web-sec-warriors)**: Web Security Warriors is a weekly discussion by developers about keeping websites, data, servers, and other internet outposts secure.

## Languages, Protocols, Browser APIs

Programming/mark-up languages and web related standards.

+ **[Cascading Style Sheets (CSS)](https://developer.mozilla.org/en-US/docs/Web/CSS)**: CSS are a stylesheet language used to describe the presentation of a document written in HTML or XML. It describes how elements should be rendered on screen, on paper, in speech, or on other media.
    + **CSS Coding Conventions**: Coding conventions are a set of guidelines for a specific programming language that recommend programming style, practices and methods for each aspect of a piece program written in this language.
        + **[CSS Guidelines](http://cssguidelin.es/)**: High-level advice and guidelines for writing sane, manageable, scalable CSS.
        + **[Idiomatic CSS](https://github.com/necolas/idiomatic-css)**: The following document outlines a reasonable style guide for CSS development. These guidelines strongly encourage the use of existing, common, sensible patterns.
        + **[Maintainable CSS](http://maintainablecss.com/)**: MaintainableCSS is an approach to writing modular, scalable and of course, maintainable CSS.
        + **[Primer](http://primercss.io/)**: Primer is GitHub’s internal CSS framework. It includes basic global styling for typography, small components like buttons and tabs, and our general guidelines for writing HTML and CSS.
        + **[Wordpress CSS Coding Standards](https://make.wordpress.org/core/handbook/best-practices/coding-standards/css/)**: The purpose of the WordPress CSS Coding Standards is to create a baseline for collaboration and review within various aspects of the WordPress open source project and community, from core code to themes to plugins.
    + **[CSS Variables W3C Editor's Draft](https://drafts.csswg.org/css-variables/)**: This module introduces cascading variables as a new primitive value type that is accepted by all CSS properties, and custom properties for defining them.
    + **Flexbox**: The Flexbox Layout officially called CSS Flexible Box Layout Module is new layout module in CSS3 made to improve the items align, directions and order in the container even when they are with dynamic or even unknown size.
        + **[5 Flexbox Techniques You Need to Know About](http://tutorialzine.com/2016/04/5-flexbox-techniques-you-need-to-know-about/)**: In this article we’re going to take a look at five flexbox approaches to solving common CSS layout problems. We’ve also included practical examples to showcase real life scenarios in which these techniques are applied.
        + **[A Complete Guide to Flexbox](https://css-tricks.com/snippets/css/a-guide-to-flexbox/)**: Chris Coyer provides a great reference to the flexbox features with code examples.
        + **[A Visual Guide to CSS3 Flexbox Properties](https://scotch.io/tutorials/a-visual-guide-to-css3-flexbox-properties)**: Rather that explaining how the flex properties work, this guide will focus on how the flex properties affect the layout in a visual way.
        + **[CSS Flexible Box Layout Module Level 1](https://www.w3.org/TR/css-flexbox-1/)**: W3C specification for CSS flexbox.
        + **[Flex-Grow is weird. Or is it?](https://css-tricks.com/flex-grow-is-weird/)**: Manuel Matuzovic describes how flex-grow works, including it's weird quirks. Then he goes into several examples on how common layout patterns may be implemented using flex-grow and flex-basis.
        + **[Flexbox Froggy](http://flexboxfroggy.com/)**: A fun way to learn Flexbox by playing a game where you help Froggy and friends to arrive at a lilypad.
        + **[Flexbox Patterns](http://www.flexboxpatterns.com/)**: These interactive examples will show you practical ways to use Flexbox to build UI components.
        + **[Flexbugs](https://github.com/philipwalton/flexbugs)**: This repository is a community-curated list of flexbox issues and cross-browser workarounds for them.
    + **[How To Center in CSS](http://howtocenterincss.com/)**: This tool consolidates the many ways of centering a div and gives you the code you need for each situation.
    + **[The Complete Guide to Centering a DIV](http://www.tipue.com/blog/center-a-div/)**: The aim of this article is to show how, with a few CSS tricks, any div can be centered; horizontally, vertically or both. And within the page or a div.
    + **[Understanding border-image](https://css-tricks.com/understanding-border-image/)**: The new CSS3 property border-image can allow you to create flexible boxes with custom borders with a single div and a single image.
    + **[What No One Told You About Z-Index](http://philipwalton.com/articles/what-no-one-told-you-about-z-index/)**: The problem with z-index is that it’s not complicated, but it if you’ve never taken the time to read its specification, there are almost certainly crucial aspects that you’re completely unaware of.
+ **Document Object Model (DOM)**: The DOM is a programming interface for HTML, XML and SVG documents. It defines methods that allow access to the tree, so that they can change the document structure, style and content.
    + **Document Events**: DOM event model is a generic event system and a set of standard modules of events for user interface control and document mutation notifications
        + **[An Introduction To DOM Events](https://www.smashingmagazine.com/2013/11/an-introduction-to-dom-events/)**: Wilson Page introduces the basics of working with DOM events, then delves into their inner workings, explaining how we can make use of them to solve common problems.
        + **[DOM Level 2 Event Model](https://www.w3.org/TR/DOM-Level-2-Events/events.html)**: W3C specification section for DOM Level 2 Events.
        + **[Gator](https://craig.is/riding/gators)**: Gator is a small (~0.8 kb minified + gzipped), simple, standalone, event delegation library.
    + **Overview**: High level guides, articles and documents about DOM.
        + **[DOM Features You Didn’t Know Existed](http://www.impressivewebs.com/dom-features-you-didnt-know-existed-video-slides/)**: Louis Lazaris talks about DOM Features you probably don't know.
        + **[DOM Reference at the MDN](https://developer.mozilla.org/en-US/docs/Web/API/Document_Object_Model)**: Complete reference of the DOM provided by the Mozilla Development Network.
        + **[Document Object Model (DOM) Technical Reports](https://www.w3.org/DOM/DOMTR)**: Specifications by the W3C.
        + **[Introduction to the DOM](https://developer.mozilla.org/en-US/docs/Web/API/Document_Object_Model/Introduction)**: This section provides a brief conceptual introduction to the DOM: what it is, how it provides structure for HTML and XML documents, how you can access it, and how this API presents the reference information and examples.
+ **[HyperText Markup Language (HTML)](https://www.w3.org/html/)**: HTML is the standard markup language used to create web pages and its elements form the building blocks of all websites.
    + **[Dive Into HTML5 (Book)](http://diveintohtml5.info/)**: Dive Into HTML5 elaborates on a hand-picked selection of features from the HTML5 specification and other fine standards.
    + **[Google HTML/CSS Style Guide](https://google.github.io/styleguide/htmlcssguide.xml)**: This document defines formatting and style rules for HTML and CSS. It aims at improving collaboration, code quality, and enabling supporting infrastructure.
    + **[HEAD](https://github.com/joshbuchea/HEAD)**: A list of everything that could go in the <head> of your document.
    + **[Idiomatic HTML](https://github.com/necolas/idiomatic-html)**: The following document outlines a reasonable style guide for HTML development. These guidelines strongly encourage the use of existing, common, sensible patterns. They should be adapted as needed to create your own style guide.
    + **Video & Audio**: Use the  HTML video and audio element to embed video content in a document.
        + **[Bringing Production Video To The Web](https://www.smashingmagazine.com/2016/04/html5-media-source-extensions-bringing-production-video-web/)**: Stefan Lederer gives you a good overview of the state and future of video on the web.
    + **[Wordpress HTML Coding Standards](https://make.wordpress.org/core/handbook/best-practices/coding-standards/html/)**: Coding conventions for WordPress.
+ **[Hypertext Transfer Protocol (HTTP)](https://www.mnot.net/blog/2016/04/22/ideal-http)**: The Hypertext Transfer Protocol (HTTP) is an application protocol for distributed, collaborative, hypermedia information systems. HTTP is the foundation of data communication for the World Wide Web.
    + **[Best Practice for HTTP2 Front-End Deployments](http://blog.cloud66.com/best-practice-for-http2-front-end-deployments/)**: This post describes how to set up and use the new HTTP/2 protocol.
    + **[Ideal HTTP Performance](https://www.mnot.net/blog/2016/04/22/ideal-http)**: This post talks about the design of the HTTP protocol, it's performance drawbacks and how to work around them.
+ **JavaScript (EcmaScript)**: JavaScript is a full-fledged dynamic programming language that, when applied to an HTML document, can provide dynamic interactivity on websites. It is defined by ECMAScript standard.
    + **Control Flow & Error Handling**: Statements, that you can use to incorporate interactivity in your application.
        + **[A Guide to Proper Error Handling in JavaScript](https://www.sitepoint.com/proper-error-handling-javascript/)**: Camilo Reyes describes ways to handle Exceptions and asynchronous errors in JavaScript.
    + **Enhancement Libraries**: Libraries that attempt to improve and enhance the vanilla JavaScript language by providing utility functions.
        + **[Flow](https://flowtype.org/)**: Flow is a static type checker for JavaScript. It can be used to catch common bugs in JavaScript programs before they run.
        + **[Lodash](https://lodash.com/)**: A modern JavaScript utility library delivering modularity, performance, & extras.
        + **[MOUT](http://moutjs.com/)**: MOUT provides many helper methods similar to those found on other languages standard libraries (ie. Python, Ruby, PHP).
        + **[Ramda](http://ramdajs.com/)**: A practical library designed specifically for a functional programming style, one that makes it easy to create functional pipelines, one that never mutates user data.
            + **Practical Ramda - Functional Programming Examples**: Tom MacWright gives some practical examples of Ramda usage.
        + **[RubyJS](http://rubyjs.org/)**: RubyJS is a JavaScript implementation of all methods from Ruby classes like Array, String, Numbers, Time and more.
    + **Functions**: A function is a JavaScript procedure—a set of statements that performs a task or calculates a value.
        + **[Closures explained by Jim Ley](http://jibbering.com/faq/notes/closures/)**: Explanation of closures in JavaScript.
        + **[Let’s Learn JavaScript Closures](https://medium.freecodecamp.com/lets-learn-javascript-closures-66feb44f6a44)**: So this post will be dedicated to the nuts and bolts of how and why closures work the way they do.
        + **[MDN Guide Chapter about Functions](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Functions)**: Defining functions, scope, closures, arguments, parameters, arrow functions and predefined functions.
        + **[MDN Reference for Functions](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions)**: Defining functions, arguments, parameters, methods, block-level functions and browser compatibility.
    + **Generators**: Generators allow you to define an iterative algorithm by writing a single function which can maintain its own state.
        + **[A Closer Look at Generators Without Promises](http://jlongster.com/A-Closer-Look-at-Generators-Without-Promises)**: Author looks at libraries for asynchronous programming with generators but without promises.
        + **[A Study on Solving Callbacks with JavaScript Generators](http://jlongster.com/A-Study-on-Solving-Callbacks-with-JavaScript-Generators)**: This article describes how Generators help fight callback hell.
        + **[Callbacks vs Coroutines](https://medium.com/@tjholowaychuk/callbacks-vs-coroutines-174f1fe66127)**: In this post TJ Holowaychuk goes through hist experiences with coroutines and why he thinks they’re a great tool.
        + **[Coroutine Event Loops in Javascript](https://x.st/javascript-coroutines/)**: An intriguing use of coroutines is to implement event loops as an alternative to callback functions. This is particularly relevant to Javascript, where the use of callbacks is pervasive.
        + **[Coroutine vs Continuation vs Generator](http://stackoverflow.com/questions/715758/coroutine-vs-continuation-vs-generator)**: StackOverflow Discussion about the difference between Couroutines, Continuations and Generators.
        + **[Regenerator](https://github.com/facebook/regenerator)**: This package implements a source transformation that takes the proposed syntax for generators/yield from future versions of JS and spits out efficient JS-of-today (ES5) that behaves the same way.
    + **Grammar and Types**: JavaScript's basic grammar, variable declarations, data types scope, hoisting and literals.
        + **[Detailed Overview of Well-Known Symbols](https://rainsoft.io/detailed-overview-of-well-known-symbols/)**: Well-known symbols are used by built-in JavaScript algorithms. This article guides through the list of well-known symbols and explains how to use them comfortable in your code.
        + **[Grammar and Types Chapter on the MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Grammar_and_types)**: This chapter discusses JavaScript's basic grammar, variable declarations, data types and literals.
        + **[Variable Hoisting Explained](http://bytearcher.com/articles/variable-hoisting-explained/)**: The author explains how hoisting works in JavaScript including variable declarations and ES6 let operator.
        + **[Variables Lifecycle: Why Let is not Hoisted](https://rainsoft.io/variables-lifecycle-and-why-let-is-not-hoisted/)**: ES2015 provides a different and improved mechanism for let. It demands stricter variable declaration practices and as result better code quality. Let's dive into more details about this process.
    + **JS Coding Conventions**: Coding conventions are a set of guidelines for a specific programming language that recommend programming style, practices and methods for each aspect of a piece program written in this language.
        + **[Airbnb JavaScript Style Guide](https://github.com/airbnb/javascript)**: A reasonable approach to JavaScript by Airbnb.
        + **[Google JavaScript Style Guide](https://google.github.io/styleguide/javascriptguide.xml)**: JavaScript is the main client-side scripting language used by many of Google's open-source projects. This style guide is a list of dos and don'ts for JavaScript programs.
        + **[Idiomatic.js](https://github.com/rwaldron/idiomatic.js/)**: The following list outlines the practices that Rick Waldron uses in all code that he is the original author of.
        + **[JavaScript Standard Style](http://standardjs.com/)**: A set of modules to check and improve the style of your code.
        + **[WordPress JavaScript Coding Standards](https://make.wordpress.org/core/handbook/best-practices/coding-standards/javascript/)**: JavaScript has become a critical component in developing WordPress-based applications (themes and plugins) as well as WordPress core. Standards are needed for formatting and styling JavaScript code.
    + **Objects**: An object is a software bundle of related state and behavior. Software objects are often used to model the real-world objects that you find in everyday life.
        + **[ECMA-262-3 in detail: OOP - The general theory](http://dmitrysoshnikov.com/ecmascript/chapter-7-1-oop-general-theory/)**: In this article we consider major aspects of object-oriented programming in ECMAScript. Much attention is given to theoretical aspects to see these processes from within.
        + **[Gentle explanation of this keyword in JavaScript](http://rainsoft.io/gentle-explanation-of-this-in-javascript/)**: This article is focused on the invocation explanation, how the function call influences this and demonstrates the common pitfalls of identifying the context.
        + **[OOP In JavaScript: What You NEED to Know](http://javascriptissexy.com/oop-in-javascript-what-you-need-to-know/)**: In this article, we are concerned with only Inheritance and Encapsulation since only these two concepts apply to OOP in JavaScript.
        + **[Object-Oriented Design in TypeScript / ES6](http://blog.wolksoftware.com/about-classes-inheritance-and-object-oriented-design-in-typescript-and-es6)**: The author dives into advanced OOP topics such as functional programming principles, inheritance and inversion of control.
        + **[Prototypal Inheritance in JavaScript](http://javascript.crockford.com/prototypal.html)**: An article by Douglas Crockford introducing the Object.create() method and describing the rational behind it.
        + **[Prototypal Object-Oriented Programming using JavaScript](http://alistapart.com/article/prototypal-object-oriented-programming-using-javascript)**: Mehdi Maujood describes the prototypical OO style and compares it to classes in JavaScript.
        + **[Prototypes and Inheritance in JavaScript](https://msdn.microsoft.com/en-us/magazine/ff852808.aspx)**: This article tries to demystify the concept of prototypes in JavaScript. It shows how prototypes allow objects to inherit functionality from other objects, an approach to building objects using the new operator and a constructor function.
    + **Overview**: General, high level guides and introductions to the JavaScript language.
        + **[Eloquent JavaScript (Book)](http://eloquentjavascript.net/)**: A comprehensive book about JavaScript, the language, the browser and Node.js.
        + **[JavaScript Garden](http://bonsaiden.github.io/JavaScript-Garden/)**: JavaScript Garden is a growing collection of documentation about the most quirky parts of the JavaScript programming language. It gives advice to avoid common mistakes and subtle bugs.
        + **[JavaScript Guide by Mozilla Developer Network](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide)**: The JavaScript Guide shows you how to use JavaScript and gives an overview of the language.
        + **[Simplified JavaScript Jargon](http://jargon.js.org/)**: A community-driven attempt at explaining the loads of buzzwords making the current JavaScript ecosystem in a few simple words.
        + **[Understanding ECMAScript 6](https://leanpub.com/understandinges6/read)**: Free (as in pay what you want) E-Book by Nicholas C. Zakas describing the new features in EcmaScript 6.
        + **[What the heck is the event loop anyway?](https://www.youtube.com/watch?v=8aGhZQkoFbQ)**: Philip Roberts, in this video, tries to create an intuitive understanding of what happens when JavaScript runs. He talks about the call stack, event loop, callback queue and other concepts.
        + **[You Dont Know JS](https://github.com/getify/You-Dont-Know-JS)**: These books each take on specific core parts of the language which are most commonly misunderstood or under-understood, and dive very deep and exhaustively into them.
    + **[Promises](https://www.promisejs.org/)**: A promise represents the result of an asynchronous operation.
        + **[Bluebird.js](http://bluebirdjs.com/)**: Bluebird is a full featured promise library with unmatched performance.
        + **[Difference between a Promise and a Task](https://glebbahmutov.com/blog/difference-between-promise-and-task/)**: Once you have a Promise instance the action has already started. Task instance does not run until someone calls .fork()
        + **[ECMAScript Promises Spec](https://tc39.github.io/ecma262/#sec-promise-objects)**: Standard ES specification for promises.
        + **[MDN page on Promises](https://developer.mozilla.org/en/docs/Web/JavaScript/Reference/Global_Objects/Promise)**: The Promise object is used for deferred and asynchronous computations. A Promise represents an operation that hasn't completed yet, but is expected in the future.
        + **[The Promises/A+ Spec](https://promisesaplus.com/)**: An open standard for sound, interoperable JavaScript promises—by implementers, for implementers.
        + **[Tracking Unhandled Rejected Promises](http://www.2ality.com/2016/04/unhandled-rejections.html)**: In Promise-based asynchronous code, rejections are used for error handling. One risk is that rejections may get lost, leading to silent failures.
        + **[What is Promise.try, and why does it matter?](http://cryto.net/~joepie91/blog/)**: In this brief article Sven Slootweg provides a better explanation of what Promise.try is, and why you should always use it, without exceptions.
        + **[What's The Point Of Promises?](http://www.telerik.com/blogs/what-is-the-point-of-promises)**: The point of promises is to represent the eventual resulting value from an operation, but the reason to use them is to better parallel synchronous operations and to solve the callback hell.
+ **[JavaScript Object Notation (JSON)](http://www.json.org/)**: JSON (JavaScript Object Notation) is a lightweight data-interchange format. It is easy for humans to read and write. It is easy for machines to parse and generate. It is based on a subset of the JavaScript Programming Language.
    + **[JSON-LD](http://json-ld.org/)**: JSON-LD is a lightweight Linked Data format. It is based on the already successful JSON format and provides a way to help JSON data interoperate at Web-scale.
+ **Scalable Vector Graphics (SVG)**: An XML-based vector image format for two-dimensional graphics with support for interactivity and animation.
    + **[Tools And Resources For Editing, Converting And Optimizing SVGs](https://www.smashingmagazine.com/2016/04/tools-and-resources-for-editing-converting-and-optimizing-svgs/)**: This article will provide you with tools and resources to simplify editing, converting, optimizing, and delivering SVGs.
+ **[Service Workers](https://www.w3.org/TR/service-workers/)**: A method that enables applications to take advantage of persistent background processing, including hooks to enable bootstrapping of web applications while offline.
    + **[Instant Loading Web Apps With An Application Shell Architecture](https://medium.com/google-developers/instant-loading-web-apps-with-an-application-shell-architecture-7c0c2f10c73)**: Addy Osmani describes how to leverage the Service Worker API to drastically improve the loading speed of your web application.
    + **[Introduction to Service Worker](http://www.html5rocks.com/en/tutorials/service-worker/introduction/)**: Matt Gaunt introduces the main features of Service Worker API in this article.
    + **[Is ServiceWorker Ready?](https://jakearchibald.github.io/isserviceworkerready/)**: Tracks the implementation status across the main browsers.
+ **Templating Languages and Engines**: Template engines are tools to separate program-logic and presentation into two independent parts. This makes the development of both logic and presentation easier, improves flexibility and eases modification and maintenance.
    + **[Dot.js](http://olado.github.io/doT/)**: The fastest + concise javascript template engine for Node.js and browsers.
    + **[Dust.js by LinkedIn](http://www.dustjs.com/)**: Dust is a Javascript templating engine. It inherits its look from the ctemplate family of languages, and is designed to run asynchronously on both the server and the browser.
    + **[Dōmo](http://jed.github.io/domo/)**: dōmo lets you write HTML markup and CSS styles in JavaScript syntax. It is a simpler and easier alternative to template engines and CSS pre-processors.
    + **[HyperScript](https://github.com/dominictarr/hyperscript)**: Create HyperText with JavaScript, on client or server.
    + **[Marko](https://github.com/marko-js/marko)**: Marko is a really fast and lightweight HTML-based templating engine from eBay. Marko runs on Node.js and in the browser and it supports streaming, async rendering and custom tags.
    + **[Mustache](http://mustache.github.io/)**: Mustache is a Logic-less template language. There are no if statements, else clauses, or for loops. Instead there are only tags.
        + **[Handlebars.js](https://github.com/wycats/handlebars.js/)**: Handlebars.js is an extension to the Mustache templating language. Handlebars.js and Mustache are both logicless templating languages that keep the view and the code separated like we all know they should be.
        + **[Hogan.js](http://twitter.github.io/hogan.js/)**: Hogan.js is a 3.4k JS templating engine developed at Twitter. It was developed against the mustache test suite.
        + **[Mustache Specification](http://mustache.github.io/mustache.5.html)**: This document explains the different types of Mustache tags.
        + **[Walrus](http://documentup.com/jeremyruppel/walrus/)**: Walrus is a templating library inspired by mustache, handlebars, ejs and friends,
but with a couple of important differences in philosophy and style.
        + **[mustache.js](https://github.com/janl/mustache.js)**: mustache.js is an implementation of the mustache template system in JavaScript.
        + **[templayed.js](http://archan937.github.io/templayed.js/)**: The fastest and smallest Mustache compliant Javascript templating library written in 1806 bytes.
    + **[Nunjucks](http://mozilla.github.io/nunjucks/)**: A rich and powerful templating language for JavaScript.
    + **[Pithy](https://github.com/caolan/pithy)**: An internal DSL for generating HTML in JavaScript.
    + **[T](https://github.com/gcao/T.js)**: T.js is a template engine that uses simple Javascript data structure to represent html/xml data.
    + **[Template7](http://idangero.us/template7/)**: Template7 is a mobile-first JavaScript template engine with Handlebars-like syntax. It is used as default template engine in Framework7.
    + **[Transparency](http://leonidas.github.io/transparency/)**: Transparency is a minimal template engine for jQuery. It maps JSON objects to DOM elements with zero configuration.
    + **[Weld](https://github.com/tmpvar/weld)**: Weld binds data to markup, and can generate markup based on your data. There's no special syntax or data reshaping required.
+ **Transpiled Languages**: Abstract languages converted to native, browser supported standards like JavaScript or CSS.
    + **[ClojureScript](https://github.com/clojure/clojurescript)**: ClojureScript is a compiler for Clojure that targets JavaScript. It is designed to emit JavaScript code which is compatible with the advanced compilation mode of the Google Closure optimizing compiler.
    + **[Dart](https://www.dartlang.org/)**: Dart is an open-source, scalable programming language, with robust libraries and runtimes, for building web, server, and mobile apps compiled to JavaScript
    + **[Elm](http://elm-lang.org/)**: Elm is a functional programming language for declaratively creating web browser-based graphical user interfaces.
        + **[The Elm Architecture](http://guide.elm-lang.org/architecture/index.html)**: The Elm Architecture is a simple pattern for infinitely nestable components. It is great for modularity, code reuse, and testing.
    + **[Less](http://lesscss.org/)**: Less is a CSS pre-processor, meaning that it extends the CSS language, adding features that allow variables, mixins, functions and many other techniques that allow you to make CSS that is more maintainable, themable and extendable.
    + **[PureScript](http://www.purescript.org/)**: PureScript is a strongly, statically typed language which compiles to JavaScript. It is written in and inspired by Haskell.
    + **[Sass](http://sass-lang.com/)**: Sass is an extension of CSS, adding nested rules, variables, mixins, selector inheritance, and more. It's translated to well-formatted, standard CSS using the command line tool or a web-framework plugin.
    + **[Scala.js](http://www.scala-js.org/)**: A Scala to JavaScript compiler.
    + **[Stylus](http://stylus-lang.com/)**: Stylus is a revolutionary new language, providing an efficient, dynamic, and expressive way to generate CSS. Supporting both an indented syntax and regular CSS style.
    + **[TypeScript](https://www.typescriptlang.org/)**: A typed superset of JavaScript that compiles to plain JavaScript. Popular in the Angular and Microsoft community.
        + **[Angular 2: Why TypeScript?](https://vsavkin.com/writing-angular-2-in-typescript-1fa77c78d8e8)**: Angular 2 is written in TypeScript. In this article Victor Savkin talks about why they made the decision.
        + **[InversifyJS](https://github.com/inversify/InversifyJS)**: A powerful and lightweight inversion of control container for JavaScript & Node.js apps powered by TypeScript.
        + **[Safety in the Absence of Types](https://vsavkin.com/typescript-how-to-be-safe-even-if-you-cannot-type-it-31eb08485fe6)**: Victor Savking talks about the limitation of TypeScript's static type checker and how to mitigate them.
+ **Uniform Resource Identifier (URI)**: URI is a string of characters used to identify a resource. The most common form of URI is the Uniform Resource Locator (URL).
    + **[Architecture of the World Wide Web: Identification](https://www.w3.org/TR/webarch/#identification)**: This architecture document by W3C discusses the core design components of the Web. They are identification of resources, representation of resource state, and the protocols that support the interaction between agents and resources in the space.
    + **[SpeakingURL](https://github.com/pid/speakingurl)**: This module aims to transliterate the input string and create a so-called Semantic  or Speaking URL.
    + **[URI.js](http://medialize.github.io/URI.js/)**: URI.js is a javascript library for working with URLs. It offers a "jQuery-style" API to read and write all regular components and a number of convenience methods.
+ **[Web Animations API](http://w3c.github.io/web-animations/)**: Web Animations is a new JavaScript API for driving animated content on the web. By unifying the animation features of SVG and CSS, Web Animations unlocks features previously only usable declaratively, and exposes powerful, high-performance animation capabilities to developers.
    + **[Are we animated yet?](https://birtles.github.io/areweanimatedyet/)**: This page tracks the progress of implementing the Web Animations API in Firefox.
    + **[WAAPI Browser Support Test (+ Polyfill)](http://codepen.io/danwilson/pen/XmWraY)**: This codepen tests whether and to which extend your browser supports Web Animations API. The test is run after including the Polyfill.
    + **[Web Animations Polyfill](https://github.com/web-animations/web-animations-js)**: JavaScript implementation of the Web Animations API.
+ **WebAssembly**: WebAssembly is meant to fill a place that JavaScript has been forced to occupy up to now: a low-level code representation that can serve as a compiler target.
    + **[7 Things You Should Know About WebAssembly](https://auth0.com/blog/2015/10/14/7-things-you-should-know-about-web-assembly/)**: In this post we will explore seven key facts about WebAssembly, one of the biggest changes the web will experience in the coming years.

## User Interface Components

Drop-in UI components for web sites and applications.

+ **Buttons**: The term button refers to any graphical control element that provides the user a simple way to trigger an event, like searching for a query at a search engine, or to interact with dialog boxes, like confirming an action.
    + **[Quantum Paper Buttons](https://github.com/nashvail/Quttons)**: With this plugin you can hide any div behind a Quantum Paper Button or Qutton. Qunatum Paper is a digital paper that can change its size, shape and color to accommodate new content. Quantum paper is part of Google's new Material Design language.
    + **[Sharingbuttons.io](http://sharingbuttons.io/)**: This generator outputs social media sharing buttons that do not use JavaScript, don't block your website from rendering, are accessible and don't track the user.
+ **Code**: Code viewers and editors designed for embedding inside a website.
    + **[Behave.js](http://jakiestfu.github.io/Behave.js/)**: Behave.js is a lightweight library for adding IDE style behaviors to plain text areas, making it much more enjoyable to write code in.
    + **[CodeMirror](http://codemirror.net/)**: CodeMirror is a versatile text editor implemented in JavaScript for the browser. It is specialized for editing code, and comes with a number of language modes and addons that implement more advanced editing functionality.
    + **[Intelligist](http://srobbin.com/jquery-plugins/intelligist/)**: A jQuery plugin that makes it easy to share and demo code in-page, using GitHub gists.
    + **[Prism](http://prismjs.com/)**: Prism is a lightweight, extensible syntax highlighter, built with modern web standards in mind.
    + **[Rainbow](https://craig.is/making/rainbows)**: Rainbow is a code syntax highlighting library written in Javascript.
It was designed to be lightweight, easy to use, and extendable.
It is completely themable via CSS.
    + **[ansi_up](https://github.com/drudru/ansi_up)**: A javascript library that converts text with ANSI terminal codes into colorful HTML
    + **[tabIndent.js](http://julianlam.github.io/tabIndent.js/)**: tabIndent.js enhances a textarea, so that the tab key no longer takes you to the next input, but rather, acts like a text editor by inserting a tab character.
+ **Forms**: A HTML form on a web page allows a user to enter data that is sent to a server for processing. Web users fill out the forms using checkboxes, radio buttons, or text fields.
    + **[ALAJAX](https://github.com/alaabadran/ALAJAX)**: A jQuery plugin to convert normal HTML forms into AJAX forms simply. It Ajaxifys your HTML Form with this plugin. No change will be required on Server-Side.
    + **[Fields.js](http://schneiderik.github.io/fields/)**: An abstract way of interacting with fields. Fields.js creates collections of fields. Each field is constantly evaluated for validity, and is accessible through the collection.
    + **[Grid Forms](http://kumailht.com/gridforms/)**: A tiny Javascript/CSS framework that helps you make forms on grids with ease.
    + **[HTML5Forms.js](https://github.com/zoltan-dulac/html5Forms.js)**: HTML5Forms.js is a JavaScript polyfill that implements a subset of the HTML5 Forms module in all browsers. The script will only add support for the different parts of the module when there doesn't exist a native implementation.
    + **[Ladda](https://github.com/hakimel/Ladda)**: Buttons with built-in loading indicators.
    + **[Native form elements](http://nativeformelements.com/)**: This is what every HTML5 form element looks like on your current operating system and browser.
    + **[Redux Form](https://github.com/erikras/redux-form)**: A Higher Order Component using react-redux to keep form state in a Redux store.
    + **Serializers**: Libraries for collecting form data in JavaScript.
        + **[form2js](https://github.com/maxatwork/form2js)**: Convenient way to collect structured form data into JavaScript object.
        + **[jQuery.serializeObject](https://github.com/hongymagic/jQuery.serializeObject)**: Encode a set of form elements as a JSON object for manipulation/submission.
        + **[jquery-serialize-object](https://github.com/macek/jquery-serialize-object)**: Adds the method serializeObject to jQuery, to perform complex form serialization into JavaScript objects.
        + **[jquery.serializeJSON](https://github.com/danheberden/jquery-serializeForm)**: Make an object out of form elements.
        + **[serializeForm](https://github.com/danheberden/jquery-serializeForm)**: jQuery plugin to serialize form elements into an object.
    + **Validation**: A form validation behavior checks data against a set of criteria before passing it along to the server.
        + **[Form Validation UX in HTML and CSS](https://css-tricks.com/form-validation-ux-html-css/)**: Chris Coyier describes how to implement form validation with just HTML attributes and some CSS trickery.
        + **[Mailcheck.js](https://github.com/mailcheck/mailcheck)**: The Javascript library and jQuery plugin that suggests a right domain when your users misspell it in an email address.
        + **[One Validation](https://github.com/One-com/one-validation)**: This is a collection of regular expressions for general validation purposes. The basic design concept is to split up the regexes into semantic parts of the pattern to match.
        + **[Parsley](https://github.com/guillaumepotier/Parsley.js)**: JavaScript form validation, without actually writing a single line of JavaScript!
    + **[jQuery Super Labels Plugin](https://github.com/remybach/jQuery.superLabels)**: This plugin was born out of the need to use the label-over-field method for forms.
+ **Galeries & Image Sliders**: A sophisticated way to present a collection of images on your website.
    + **[Lightgallery.js](https://github.com/sachinchoolur/lightgallery.js/)**: Full featured JavaScript Lightbox gallery without any dependencies.
+ **Grid**: CSS Grid Layout Systems.
    + **[Bourbon Neat](http://neat.bourbon.io/)**: A lightweight semantic grid framework for Sass and Bourbon.
    + **[Profound Grid](http://www.profoundgrid.com/)**: A responsive grid system for fixed and fluid layouts. Built in SCSS, it gives you flexibility and full control.
    + **[RWDGrid](http://rwdgrid.com/)**: 2kb, Mobile First Grid System, HTML5 Boilerplate Head, 960grid like naming convention. PSD Grid included.
    + **[Simple Grid](http://thisisdallas.github.io/Simple-Grid/)**: Simple Grid was created for developers who need a barebones grid. With fluid columns, Simple Grid is responsive down to mobile.
+ **Rich Text Editors**: A rich text editor is the interface for editing rich text within web browsers. The aim is to reduce the effort for users trying to express their formatting directly as valid HTML markup.
    + **Content Sanitizers**: Rich text editors often produce unclean input when you copy & paste some content into them. Content sanitizers help you clean up the text.
        + **[FilteredPaste.js](http://willemmulder.github.io/FilteredPaste.js/)**: A jQuery plugin that filters any pasted input so that your application gets clean input, without any tags or attributes that you don't want.
        + **[Sanitize.js](https://github.com/gbirke/sanitize.js)**: Sanitize.js is a whitelist-based HTML sanitizer. Given a list of acceptable elements and attributes, Sanitize.js will remove all unacceptable HTML from a DOM node.
        + **[html-janitor](https://github.com/guardian/html-janitor)**: Cleans up your markup and allows you to take control of your HTML. HTMLJanitor uses a defined whitelist to limit HTML it is given to a defined subset.
    + **[Create.js](http://createjs.org/)**: Create.js is a comprehensive web editing interface for Content Management Systems. It is designed to provide a modern, fully browser-based HTML5 environment for managing content
    + **[Demarcate](http://will-hart.github.io/demarcate.js/)**: demarcate.js lets you edit directly in a page and generate Markdown back from the HTML elements.
    + **[Hallo](http://hallojs.org/)**: Hallo is the simplest web editor imaginable. Instead of cluttered forms or toolbars, you edit your web content as it is. Just you, your web design, and your content.
    + **Inspired by Medium**: Medium.com has a great and simple rich text editor built in. This libraries try to clone its behavior.
        + **[Medium.js](https://github.com/jakiestfu/Medium.js)**: A tiny JavaScript library for making contenteditable beautiful (Like Medium's editor)
        + **[Pen](http://sofish.github.io/pen/)**: Rich text editor inspired by Medium and backed by Markdown.
        + **[grande.js](https://github.com/mduvall/grande.js)**: A small Javascript library that implements features from Medium's editing experience.
        + **[medium-editor](https://github.com/yabwe/medium-editor)**: Medium.com WYSIWYG editor clone. Uses contenteditable API to implement a rich text solution.
    + **[Kajero](https://github.com/JoelOtter/kajero)**: Interactive JavaScript notebooks with markdown support and clever graphing.
    + **[MarkItUp](http://markitup.jaysalvat.com/)**: markItUp! is a JavaScript plugin built on the jQuery library. It allows you to turn any textarea into a markup editor.
    + **[Mercury Editor](http://jejacks0n.github.io/mercury/)**: Mercury is a full featured HTML5 editor. It was built from the ground up to help your team get the most out of content editing in modern browsers.
    + **[Quill](https://github.com/quilljs/quill/)**: Quill is a modern rich text editor built for compatibility and extensibility. It was created by Jason Chen and Byron Milligan and open sourced by Salesforce.com.
    + **[Scribe](https://github.com/guardian/scribe)**: A rich text editor framework for the web platform, with patches for browser inconsistencies and sensible defaults. Developed by The Guardian.
        + **[Inside the Guardian’s CMS: meet Scribe, an extensible rich text editor](https://www.theguardian.com/info/developer-blog/2014/mar/20/inside-the-guardians-cms-meet-scribe-an-extensible-rich-text-editor)**: The team behind the Guardian’s digital content management system talk about how and why they built and open sourced Scribe.
    + **[Substance](http://substance.io/)**: Substance is a JavaScript library for web-based content editing. It provides building blocks for realizing custom text editors and web-based publishing systems.
        + **[Build your own editor with Substance](https://medium.com/@_mql/build-your-own-editor-with-substance-7790eb600109)**: This article describes the philosophy behind Substance and how to get started.
    + **[TextAngular](http://textangular.com/)**: A Lightweight, Two-Way-Bound Angular.js Text-Editor.
    + **[WYSIHTML5](http://xing.github.io/wysihtml5/)**: wysihtml5 is an open source rich text editor based on HTML5 technology and the progressive-enhancement approach. It aims to generate fully valid HTML5 markup by preventing unmaintainable tag soups and inline styles.
        + **[Voog fork](https://github.com/Voog/wysihtml)**: wysihtml is an extended and less strict approach on xing/wysihtml5 open source rich text editor based on HTML5 technology. The code is completely library agnostic: No jQuery, Prototype or similar is required.
        + **[WYSIHTML5 Enhanced](https://github.com/zohararad/wysihtml5n)**: WYSIHTML5 Enhanced is a rich-text editor, based on the wonderful wysihtml5 editor, with a bit of help from Twitter Bootstrap, Font-Awesome, Jcrop and HTML5's Drag & Drop and File API.
        + **[bootstrap3-wysiwyg](https://github.com/bootstrap-wysiwyg/bootstrap3-wysiwyg)**: Bootstrap-wysihtml5 is a javascript plugin that makes it easy to create simple, beautiful wysiwyg editors with the help of wysihtml5 and Twitter Bootstrap.
    + **[X-editable](http://vitalets.github.io/x-editable/)**: This library allows you to create editable elements on your page. It can be used with any engine (bootstrap, jquery-ui, jquery only) and includes both popup and inline modes.
+ **Table Of Contents**: Components for automatic table of contents generation.
    + **[Tocbot](http://tscanlin.github.io/tocbot/)**: Tocbot builds a table of contents (TOC) from headings in an HTML document.
+ **UI Kits**: Collections of ready to use components.
    + **[CloudFlare Components](https://cloudflare.github.io/cf-ui/)**: A set of UI components built by CloudFlare and based on React.
    + **[Ink](http://ink.sapo.pt/)**: An HTML5/CSS3 framework used at SAPO for fast and efficient website design and prototyping.
    + **[PrimeNG](http://www.primefaces.org/primeng/)**: PrimeNG is a collection of rich UI components for AngularJS2. PrimeNG is a sibling of the popular JavaServer Faces Component Suite, PrimeFaces.
    + **[Primer](http://primercss.io/)**: Primer is GitHub’s internal CSS framework. It includes basic global styling for typography, small components like buttons and tabs, and our general guidelines for writing HTML and CSS.
    + **[Pure.css](http://purecss.io/)**: A set of small, responsive CSS modules that you can use in every web project.
    + **[UIkit](http://getuikit.com/)**: A lightweight and modular front-end framework and a set of components for developing fast and powerful web interfaces.
    + **[Vital](http://doximity.github.io/vital/)**: A minimally invasive CSS framework for modern web applications.
+ **Video & Audio**: Components for playing audio and video files on a website.
    + **[Audio.js](http://kolber.github.io/audiojs/)**: audio.js is a drop-in javascript library that allows HTML5’s audio tag to be used anywhere.
    + **[Howler.js](https://github.com/goldfire/howler.js)**: howler.js is an audio library for the modern web. It defaults to Web Audio API and falls back to HTML5 Audio.
    + **[JPlayer](http://jplayer.org/)**: jPlayer a media library written in JavaScript. A jQuery plugin, jPlayer allows you to rapidly weave cross platform audio and video into your web pages.
    + **[MediaElement.js](http://mediaelementjs.com/)**: HTML5 audio or video player with Flash and Silverlight shims that mimics the HTML5 MediaElement API, enabling a consistent UI in all browsers.
    + **[Stratus 2](https://stratus.soundcloud.com/)**: Stratus is a jQuery powered SoundCloud player that lives at the bottom (or top) of your website or blog.
    + **[Video.js](https://github.com/videojs/video.js)**: Video.js is a web video player built from the ground up for an HTML5 world. It supports HTML5 and Flash video, as well as YouTube and Vimeo (through plugins). It supports video playback on desktops and mobile devices.

## Workflow

Task automation and asset delivery.

+ **Automated Testing**: Automated software testing is a process in which software tools execute pre-scripted tests on a software application before it is released into production.
    + **[5 Common Misconceptions About TDD & Unit Tests](https://medium.com/javascript-scene/5-common-misconceptions-about-tdd-unit-tests-863d5beb3ce9)**: Eric Elliott breaks down some common misconceptions and  explains how you can benefit the most from TDD & unit tests.
    + **[A Gentle Introduction to Javascript Test Driven Development](http://jrsinclair.com/articles/2016/gentle-introduction-to-javascript-tdd-intro/)**: Over the course of the series, James Sinclair works through developing a full application in JavaScript that involves making network requests and manipulating the DOM.
    + **[Anti-patterns and Their Fixes](https://shanetomlinson.com/2013/testing-javascript-frontend-part-1-anti-patterns-and-fixes/)**: Shane Tomlinson presents a sample application that contains several common anti-patterns and how these can be refactored to be more testable.
    + **[Chai](http://chaijs.com/)**: Chai is a BDD/TDD assertion library for node and the browser that can be paired with any JavaScript testing framework.
    + **[Cucumber](https://cucumber.io/)**: Cucumber is a software tool that computer programmers use for testing other software. It runs automated acceptance tests written in a behavior-driven development (BDD) style.
        + **[Cucumber.js](https://github.com/cucumber/cucumber-js)**: Cucumber.js is a Cucumber implementation written in pure JavaScript. It runs on Node.js, IO.js, browsers and any other JavaScript platform.
        + **[Gherkin](https://github.com/cucumber/cucumber/wiki/Gherkin)**: Gherkin is the language that Cucumber understands. It is a Business Readable, Domain Specific Language that lets you describe software’s behaviour without detailing how that behaviour is implemented.
    + **[FiveUI](http://galoisinc.github.io/FiveUI/)**: FiveUI is an extensible tool for evaluating HTML user interfaces
against sets of codified UI Guidelines.
    + **[Introducing BDD](https://dannorth.net/introducing-bdd/)**: Dan North introduces behaviour-driven development (BDD). A software development process that emerged from test-driven development (TDD).
    + **[Jasmine](https://github.com/jasmine/jasmine)**: Jasmine is a Behavior Driven Development testing framework for JavaScript. It does not rely on browsers, DOM, or any JavaScript framework. Thus it's suited for websites, Node.js projects, or anywhere that JavaScript can run.
    + **[JavaScript Testing: Unit vs Functional vs Integration Tests](https://www.sitepoint.com/javascript-testing-unit-functional-integration/)**: Unit tests, integration tests, and functional tests are all types of automated tests which form essential cornerstones of continuous delivery, a development methodology that allows you to safely ship changes to production in days or hours rather than months or years.
    + **[Jest](https://github.com/facebook/jest)**: A JavaScript unit testing framework, used by Facebook to test services and React applications.
    + **[Kakapo.js](http://devlucky.github.io/kakapo-js)**: Kakapo its a full featured http mocking library, he allows you to entirely replicate your backend logic in simple and declaritive way directly in the browser.
    + **[Karma](http://karma-runner.github.io/)**: A simple tool that allows you to execute JavaScript code in multiple real browsers.
    + **[Leche](https://github.com/box/leche)**: A JavaScript testing utility designed to work with Mocha and Sinon. This is intended for use both by Node.js and in browsers, so any changes must work in both locations.
    + **[My Node Test Strategy](https://remysharp.com/2015/12/14/my-node-test-strategy)**: Remy Sharp shates his automated testing process with tape, proxyquire, sinon and browserify.
    + **[PhantomCSS](https://github.com/Huddle/PhantomCSS)**: PhantomCSS takes screenshots and compares them to baseline images to test for RGB pixel differences. PhantomCSS then generates image diffs to help you find the cause.
    + **[QUnit](http://qunitjs.com/)**: QUnit is a powerful, easy-to-use JavaScript unit testing framework. It's used by the jQuery, jQuery UI and jQuery Mobile projects and is capable of testing any generic JavaScript code.
    + **[Refactor Away Anti-Patterns](https://shanetomlinson.com/2013/writing-testable-javascript-part-2-refactor-away-anti-patterns/)**: Shane Tomlinson continues by refactoring the original application, including testing anti patterns, to be easier to read, easier to reuse, and easier to test.
    + **[Sinon.JS Assertions for Chai](https://github.com/domenic/sinon-chai)**: Sinon–Chai provides a set of custom assertions for using the Sinon.JS spy, stub, and mocking framework with the Chai assertion library. You get all the benefits of Chai with all the powerful tools of Sinon.JS.
    + **[Sinon.js](http://sinonjs.org/)**: Standalone test spies, stubs and mocks for JavaScript. No dependencies, works with any unit testing framework.
        + **[How to Stub/Mock Complex Objects](http://codeutopia.net/blog/2016/05/23/sinon-js-quick-tip-how-to-stubmock-complex-objects-such-as-dom-objects/)**: In this article, we’ll look at how to stub objects which are deeply nested, and when functions have more complex return values and they interact with other objects.
    + **[Tape](https://github.com/substack/tape)**: Tap-producing test harness for node and browsers.
        + **[Testing JavaScript Modules with Tape](https://ponyfoo.com/articles/testing-javascript-modules-with-tape)**: In this article we will get an in-depth look at three modules:  tape, proxyquire, and sinon.
        + **[Why I use Tape Instead of Mocha & So Should You](https://medium.com/javascript-scene/why-i-use-tape-instead-of-mocha-so-should-you-6aa105d8eaf4#.fjpja613n)**: Eric Elliott describes the advantages of Tape and compares it to more popular testing frameworks.
    + **[TestCheck](https://github.com/leebyron/testcheck-js)**: TestCheck is a library for generative testing of program properties, ala QuickCheck.
    + **[Testing a React & Redux Codebase](http://silvenon.com/testing-react-and-redux/)**: This series aims to be a very comprehensive guide through testing a React and Redux codebase, where you can really cover a lot with just unit tests because the code is mostly universal.
    + **Writing Testable JavaScript**: Rebecca Murphey discusses how to organize code to make JavaScript more testable in unit tests.
+ **Build Tools**: Toolkits and their ecosystems, that help you automate painful and repeated tasks.
    + **[Automaton](http://indigounited.com/automaton/)**: Task automation tool built in JavaScript.
    + **[Grunt](http://gruntjs.com/)**: Grunt is a task-based command line build tool for JavaScript projects.
        + **[A beginner’s guide to Grunt: Redux](http://mattbailey.io/a-beginners-guide-to-grunt-redux.html)**: Simple Grunt boilerplate for frontend workflow with detailed instructions.
        + **[GruntStart](https://github.com/tsvensen/gruntstart)**: A Grunt-enabled head-start with the H5BP, jQuery, Modernizr, and Respond. The building blocks to quickly get started with Grunt to create an optimized website.
        + **[Synchronised Testing Between Browsers/Devices](http://mattbailey.io/grunt-synchronised-testing-between-browsers-devices)**: The article describes an easy way to test your projects on your devices.
        + **[Web development is getting complex. Let's go shopping.](http://ruudud.github.io/2012/12/22/grunt/)**: A step by step tutorial for building a new project with grunt.
    + **[Gulp](http://gulpjs.com/)**: Gulp is a toolkit that helps you automate painful or time-consuming tasks in your development workflow. It's very fast, platform-agnostic and simple.
        + **Articles & Tutorials**: Publications about gulp or step by step guides for setting up and using gulp in a project.
            + **Building with Gulp 3 and 4 (Series)**: Great series of articles about single components and gulp as a whole.
                + **[Part 1: Examples](http://blog.reactandbethankful.com/posts/2015/04/23/building-with-gulp-3-and-4-part-1-examples/)**: Introduction to gulp and gulpfile.js.
                + **[Part 2: Gulp's anatomy](http://blog.reactandbethankful.com/posts/2015/04/23/building-with-gulp-3-and-4-part-2-gulp-anatomy/)**: Orchestrator, Undertaker, Vinyl and Vinyl FS, Gulp Plugins.
                + **[Part 3: Writing transformers](http://blog.reactandbethankful.com/posts/2015/04/28/building-with-gulp-3-and-4-part-3-writing-transformers/)**: Using map-stream, though2 and event-stream.
                + **[Part 4: Incremental builds](http://blog.reactandbethankful.com/posts/2015/05/01/building-with-gulp-4-part-4-incremental-builds/)**: Building files which changed since last run and caching.
                + **[Part 5: Caveats](http://blog.reactandbethankful.com/posts/2015/05/05/building-with-gulp-part-5-caveats/)**: Error management in Gulp 3 and "MANY:1 disguised as a 1:1" problem.
            + **[The vision, history, and future of the project (Apr. 2014)](https://medium.com/@contrahacks/gulp-3828e8126466)**: The article talks about Streams, Vinyl, Vinyl Adapters, Orchestrator and Error Management in Gulp 4.
            + **[Why Gulp might not be the Answer](http://scm.io/blog/hack/2014/07/why-gulp-might-not-be-the-answer/)**: ... there is still a conceptual problem that Gulp has yet to address. Many build steps are not 1:1 (one file in, one file out) but rather n:1 or 1:n.
        + **CSS**: Gulp plugins for working with CSS files.
            + **[gulp-clean-css](https://github.com/scniro/gulp-clean-css)**: gulp plugin to minify CSS, using clean-css.
            + **[gulp-cssnano](https://www.npmjs.com/package/gulp-cssnano)**: Minify CSS with cssnano.
        + **Concatenation**: Plugins for file concatenation. For example bundling CSS or JavaScript files.
            + **[gulp-concat](https://www.npmjs.com/package/gulp-concat)**: This plugin will concat files by your operating systems newLine. It will take the base directory from the first file that passes through it.
            + **[gulp-group-concat](https://www.npmjs.com/package/gulp-group-concat)**: Concats groups of files into a smaller number of files
        + **Deployment**: Plugins for pushing built files into production.
            + **[gulp-tar](https://github.com/sindresorhus/gulp-tar)**: Create tarball from files.
            + **[vinyl-ftp](https://github.com/morris/vinyl-ftp)**: Blazing fast vinyl adapter for FTP.
            + **[vinyl-s3](https://github.com/izaakschroeder/vinyl-s3)**: Use S3 as a source or destination of vinyl files.
        + **Ecosystem**: The network of developers and plugins around gulp.
            + **[@sindresorhus plugins](https://github.com/search?q=%40sindresorhus+gulp-)**: A collection of plugins by Sindre Sorhus.
            + **[Gulp Friendly NPM Packages](https://www.npmjs.com/browse/keyword/gulpfriendly)**: Normal node packages that work with gulp.
        + **Filters**: Plugins for filtering files in a vinyl stream.
            + **[gulp-cache](https://www.npmjs.com/package/gulp-cache)**: A temp file based caching proxy task for gulp.
            + **[gulp-cached](https://www.npmjs.com/package/gulp-cached)**: A simple in-memory file cache for gulp.
            + **[gulp-changed](https://github.com/sindresorhus/gulp-changed)**: Only pass through changed files.
            + **[gulp-filter](https://www.npmjs.com/package/gulp-filter)**: Filter files in a vinyl stream.
            + **[gulp-newer](https://github.com/tschaub/gulp-newer)**: Pass through newer source files only.
            + **[gulp-remember](https://github.com/ahaurw01/gulp-remember)**: A plugin for gulp that remembers and recalls files passed through it.
            + **[vinyl-diff](https://www.npmjs.com/package/vinyl-diff)**: This library allows you to perform diffs between streams of vinyl.
        + **Images**: Plugins for working with images.
            + **[gulp-imagemin](https://github.com/sindresorhus/gulp-imagemin)**: Minify PNG, JPEG, GIF and SVG images.
            + **[gulp-webp](https://github.com/sindresorhus/gulp-webp)**: Convert PNG, JPEG, TIFF images to WebP.
        + **JavaScript**: Module loaders, minifiers and other tools for working with JavaScript files.
            + **[gulp-pure-cjs](https://www.npmjs.com/package/gulp-pure-cjs)**: Gulp plugin for Pure CommonJS builder.
            + **[gulp-uglify](https://www.npmjs.com/package/gulp-uglify)**: Minify files with UglifyJS.
            + **[yoloader](https://www.npmjs.com/package/yoloader)**: A CommonJS module loader implementation. It provides tools to bundle a CommonJS based project and to load such bundles.
        + **SourceMaps**: A source map provides a way of mapping code within a compressed file back to it’s original position in a source file.
            + **[Plugins with gulp sourcemaps support](https://github.com/floridoo/gulp-sourcemaps/wiki/Plugins-with-gulp-sourcemaps-support)**: A list of plugins which support gulp-sourcemaps.
            + **[gulp-sourcemaps](https://github.com/floridoo/gulp-sourcemaps)**: Source map support for Gulp.js
            + **[vinyl-sourcemaps-apply](https://www.npmjs.com/package/vinyl-sourcemaps-apply)**: Apply a source map to a vinyl file, merging it with preexisting source maps.
        + **Utility**: Tools and parts for building gulp plugins.
            + **[gulp-count](https://www.npmjs.com/package/gulp-count)**: Count files in a vinyl stream.
            + **[gulp-debug](https://www.npmjs.com/package/gulp-debug)**: Debug vinyl file streams to see what files are run through your gulp pipeline.
            + **[gulp-size](https://github.com/sindresorhus/gulp-size)**: Logs out the total size of files in the stream and optionally the individual file-sizes.
            + **[lazypipe](https://www.npmjs.com/package/lazypipe)**: Lazypipe allows you to create an immutable, lazily-initialized pipeline. It's designed to be used in an environment where you want to reuse partial pipelines, such as with gulp.
            + **[map-stream](https://github.com/dominictarr/map-stream)**: Create a through stream from an asyncronous function.
        + **[Vinyl](https://github.com/gulpjs/vinyl)**: Vinyl is a very simple metadata object that describes a file.
            + **[gulp-chmod](https://github.com/sindresorhus/gulp-chmod)**: Change permissions of Vinyl files.
            + **[gulp-rename](https://github.com/hparra/gulp-rename)**: A plugin to rename files easily.
            + **[mem-fs](https://www.npmjs.com/package/mem-fs)**: Simple in-memory vinyl file store.
            + **[vinyl-ast](https://www.npmjs.com/package/vinyl-ast)**: Parse-once and generate-once AST tool bridge for Gulp plugins.
            + **[vinyl-buffer](https://www.npmjs.com/package/vinyl-buffer)**: Creates a transform stream that takes vinyl files as input, and outputs buffered (isStream() === false) vinyl files as output.
            + **[vinyl-file](https://www.npmjs.com/package/vinyl-file)**: Create a vinyl file from an actual file.
            + **[vinyl-fs](https://github.com/wearefractal/vinyl-fs)**: Vinyl adapter for the file system.
            + **[vinyl-fs-fake](https://www.npmjs.com/package/vinyl-fs-fake)**: A vinyl adapter that extends vinyl-fs to allow for easy debugging by passing in virtual files instead of globs, and calling a function instead of writing.
            + **[vinyl-git](https://www.npmjs.com/package/vinyl-git)**: Vinyl adapter for git.
            + **[vinyl-map](https://github.com/hughsk/vinyl-map)**: Map vinyl files' contents as strings, so you can easily use existing code without needing yet another gulp plugin!
            + **[vinyl-paths](https://www.npmjs.com/package/vinyl-paths)**: Get the file paths in a vinyl stream.
            + **[vinyl-source-buffer](https://www.npmjs.com/package/vinyl-source-buffer)**: Convert a text stream into a vinyl pipeline whose content is a buffer.
            + **[vinyl-source-stream](https://www.npmjs.com/package/vinyl-source-stream)**: Use conventional text streams at the start of your gulp or vinyl pipelines, making for nicer interoperability with the existing npm stream.
            + **[vinyl-to-stream](https://www.npmjs.com/package/vinyl-to-stream)**: Convert a vinyl stream to a text stream.
            + **[vinyl-transform](https://www.npmjs.com/package/vinyl-transform)**: Wraps standard text transform streams so you can write fewer gulp plugins. Fulfills a similar use case to vinyl-map and vinyl-source-stream.
    + **[Mimosa](http://mimosajs.com)**: Mimosa is a batteries included web development workflow tool that will get you coding in seconds rather than hunting down plugins and wrangling config for hours.
    + **[Plop](https://github.com/amwmedia/plop)**: Micro-generator framework that makes it easy for an entire team to create files with a level or uniformity.
        + **[Automating Workflow with plop](http://newbranch.cn/ui-development-with-es6-javascript-part-x-automating-workflow-with-plop/)**: Automating UI Development with Riot.js and ES6 Javascript.
    + **[Webpack](http://webpack.github.io/)**: Webpack is a module bundler. It takes modules with dependencies and generates static assets representing those modules.
        + **[Block, Element, Modifying Your JavaScript Components](https://medium.com/seek-ui-engineering/block-element-modifying-your-javascript-components-d7f99fcab52b)**: Mark Dalgleish is discussing how to organize React code with BEM and build everything with Webpack.
        + **[Developing with Docker and Webpack](http://dapperdeveloper.com/2016/05/18/developing-with-docker-and-webpack/)**: Chris Harrington explains how to create a development environment with Webpack and Docker to match the production as much as possible.
        + **[Full-Stack Redux Tutorial](http://teropa.info/blog/2015/09/10/full-stack-redux-tutorial.html)**: We will go through all the steps of constructing a Node+Redux backend and a React+Redux frontend for a real-world application, using test-first development.
        + **[How to Set Up Webpack Image Loader](http://www.davidmeents.com/how-to-set-up-webpack-image-loader/)**: This brief tutorial will help you set up an image loader in Webpack.
        + **[The SoundCloud Client in React + Redux](http://www.robinwieruch.de/the-soundcloud-client-in-react-redux/)**: After finishing this step by step tutorial you will be able to author your own React + Redux project with Webpack and Babel.
        + **[Webpack from Apprentice to Master](http://survivejs.com/webpack/)**: The purpose of this guide is to help you get started with Webpack and then go beyond basics.
        + **[WebpackBin](http://www.webpackbin.com/)**: A webpack code sandbox.
        + **[Why I think Webpack is the Right Approach To Build Pipelines](http://devlog.disco.zone/2016/06/01/webpack/)**: Thomas Boyt compares how Grunt, Gulp, Broccoli and Webpack discover dependencies.
    + **[Yeoman](http://yeoman.io/)**: Yeoman helps you to kickstart new projects, prescribing best practices and tools to help you stay productive. It provides a generator ecosystem.
+ **CSS Tools**: Tools for analysis, pre and post processing of CSS files.
    + **[CSS Pack](https://www.npmjs.com/package/css-pack)**: Packs CSS dependency graphs produced from dgraph or module-deps into a single CSS bundle, assuming every node in the graph contains CSS source and the graph itself is sorted with deps-sort
    + **[CSS Stringify](https://github.com/reworkcss/css-stringify)**: CSS stringifier using the AST from 'css.parse'
    + **[CSSCSS](http://zmoazeni.github.io/csscss/)**: A CSS redundancy analyzer that analyzes redundancy.
    + **[Clean CSS](https://www.npmjs.com/package/clean-css)**: Clean-css is a fast and efficient Node.js library for minifying CSS files.
    + **[Helium CSS](https://github.com/geuis/helium-css)**: Helium is a tool for discovering unused CSS across many pages on a web site.
    + **[PostCSS](http://postcss.org/)**: PostCSS parses CSS into an abstract syntax tree (AST), passes it through a series of plugins, and then concatenates back into a string.
        + **[An Introduction to PostCSS](https://www.sitepoint.com/an-introduction-to-postcss/)**: This article describes what PostCSS is and how to get started.
        + **[ES CSS Modules](https://github.com/jacobp100/es-css-modules)**: PostCSS plugin that combines CSS Modules and ES Imports.
        + **[Improving the Quality of Your CSS with PostCSS](https://www.sitepoint.com/improving-the-quality-of-your-css-with-postcss/)**: In this article, we will explore how we can utilise PostCSS to help us maintain a higher quality in our CSS code.
        + **[React Starter Kit](https://www.reactstarterkit.com/)**: Isomorphic web app boilerplate including Node.js, Express, GraphQL, React.js, Babel 6, PostCSS, Webpack, Browsersync.
        + **[Working with Images in Stylesheets](https://css-tricks.com/images-in-postcss/)**: Aleks Hudochenkov does a great job of showcasing what PostCSS is good at and the role it has grown into in the front end stack.
    + **[Stylelint](http://stylelint.io/)**: Stylelint's ambitious goal is to supplement our discipline with automatic enforcement — to provide a core set of rules and a pluggable framework that CSS authors can use to enforce their own strategies.
        + **[Lint your CSS with Stylelint](https://css-tricks.com/stylelint/)**: David Clark writes about reasons for using a CSS linter and advantages of Stylelint.
+ **Code Editors**: Text editor programs designed specifically for editing source code of a website.
    + **[Atom](https://atom.io/)**: Atom is a text editor that's modern, approachable, yet hackable to the core—a tool you can customize to do anything but also use productively without ever touching a config file.
    + **[Brackets](http://brackets.io/)**: An open source code editor for the web, written in JavaScript, HTML and CSS.
    + **[Notepad++](https://notepad-plus-plus.org/)**: Notepad++ is a free (as in "free speech" and also as in "free beer") source code editor and Notepad replacement that supports several languages. Running in the MS Windows environment, its use is governed by GPL License
    + **[Visual Studio Code](https://code.visualstudio.com/)**: Build and debug modern web and cloud applications. VS Code is free and available on your favorite platform - Linux, Mac OSX, and Windows.
+ **Documentation**: Writing, generating, publishing and consuming documentation for web deliverables.
    + **[Atomic Docs](http://atomicdocs.io/)**: Atomic Docs is a styleguide generator and component manager. Atomic Docs is built in PHP. Inspired by Brad Frost's Atomic Design principles.
    + **[Daux](http://daux.io/)**: Daux.io is a documentation generator that uses a simple folder structure and Markdown files to create custom documentation on the fly.
    + **[Dexy](http://www.dexy.it/)**: Dexy makes it easier to create technical documents by doing the repetitive parts for you. Dexy provides a consistent interface to tools and scripts so you don't have to run them manually.
    + **[Docco](http://jashkenas.github.io/docco/)**: Docco is a quick-and-dirty documentation generator. It produces an HTML document that displays your comments intermingled with your code.
    + **[JSDoc Documentation](http://usejsdoc.org/)**: Comprehensive guide for JSDoc.
    + **[Ronn](https://github.com/rtomayko/ronn)**: Ronn builds manuals. It converts simple, human readable textfiles to roff for terminal display, and also to HTML for the web.
    + **[Transcribe](https://github.com/plaid/transcribe)**: Transcribe is a simple program which generates Markdown documentation from code comments.
    + **[YUIDoc](http://yui.github.io/yuidoc/)**: YUIDoc is a Node.js application that generates API documentation from comments in source, using a syntax similar to tools like Javadoc and Doxygen.
    + **[coddoc](http://doug-martin.github.io/coddoc/)**: coddoc is a jsdoc parsing library. Coddoc is different in that it is easily extensible by allowing users to add tag and code parsers. It also parses source code to be used in APIs.
    + **[devdocs.io](http://devdocs.io/)**: Devdocs is an all-in-one API documentation reader with a fast, organized, and consistent interface.
    + **[dox](https://github.com/visionmedia/dox)**: JavaScript documentation generator for node using markdown and jsdoc.
    + **[styledocco](http://jacobrask.github.io/styledocco/)**: StyleDocco generates documentation and style guide documents from your stylesheets.
+ **Fonts for Programmers**: Programmers need special fonts, which help align the code and distinguish between characters, that look alike.
    + **[Droid Sans Mono](https://www.google.com/fonts/specimen/Droid+Sans+Mono)**: Droid Sans Mono makes for a great programming font. Its only real flaw is the lack of a slashed zero.
    + **[Free Programming Fonts](http://cdn.sixrevisions.com/0441-01_programming-fonts/demo/programming-fonts.html)**: A demonstration of beautiful fonts for people who love to code.
    + **[Mononoki](https://github.com/madmalik/mononoki)**: Mononoki is a typeface by Matthias Tellen, created to enhance code formatting.
    + **[Profont](http://tobiasjung.name/profont/)**: Profont is a monospaced font created to be a most readable font for programming. It is designed to look good a really small sizes
    + **[Source Code Pro](https://github.com/adobe-fonts/source-code-pro)**: Source Code Pro is a set of OpenType fonts that have been designed to work well in user interface (UI) environments.
    + **[Space Mono](https://fonts.google.com/specimen/Space%20Mono)**: Space Mono is an original fixed-width type family designed by Colophon Foundry for Google Design.
+ **Getting Started**: Step by step guides for setting up a frontend development workflow.
    + **[Front-end Process - Flat Builds and Automation (series)](http://www.gpmd.co.uk/blog/front-end-process-flat-builds-and-automation-part-1-introduction/)**: A flat build is basically the process of coding a static page (or pages) in HTML and CSS. The idea is to supply our developers with design assets such as style guides, pattern libraries or prototypes, including assets such as images, fonts, css, and javascript, as flat builds.
        + **[CSS Framework (Inuit)](http://www.gpmd.co.uk/blog/front-end-process-flat-builds-and-automation-part-4-css-framework/)**: In this part the author introduces the inuit CSS framework and describes how to integrate the framework into the development process.
        + **[Environment Setup & Yeoman](http://www.gpmd.co.uk/blog/front-end-process-flat-builds-and-automation-part-2-environment-setup-and-yeoman/)**: In this part the author outlines how to set up your dev environment, and how to scaffold a project using Yeoman.
        + **[Grunt Tasks](http://www.gpmd.co.uk/blog/front-end-process-flat-builds-and-automation-part-3-grunt-tasks/)**: The author outlined how to set up your dev environment, and how to scaffold a project using Yeoman. In this third part we will look at how to install and configure some grunt tasks.
+ **HTML Tools**: Tools for pre and post processing of the HTML source code.
    + **[html-inspector](https://www.npmjs.org/package/html-inspector)**: HTML Inspector is a code quality tool to help you and your team write better markup. It's written in JavaScript and runs in the browser, so testing your HTML has never been easier.
    + **[html-minifier](https://www.npmjs.com/package/html-minifier)**: HTMLMinifier is a highly configurable, well-tested, Javascript-based HTML minifier, with lint-like capabilities.
+ **Image Post Processing**: Tools for image conversion and optimization.
    + **[ImageOptim-CLI](https://github.com/JamieMason/ImageOptim-CLI)**: Make lossless optimisation of images part of your automated build process.
    + **[Jpegoptim](https://github.com/tjko/jpegoptim)**: Utility to optimize/compress JPEG files.
    + **[Optimize Images for Web – Ultimate Guide](https://www.keycdn.com/blog/optimize-images-for-web/)**: We will discuss the three areas in which you can better optimize images for web: better web performance, rank and index better in search engines, better social media engagement and CTR.
    + **[Pngcrush](http://pmt.sourceforge.net/pngcrush/)**: Pngcrush is an optimizer for PNG (Portable Network Graphics) files.
    + **[SMLR](https://github.com/jasonmoo/smlr)**: Re-encode jpeg images with no perceivable quality loss. Uses the butteraugli psychovisual comparison and k-ary search to determine the best jpeg quality setting.
+ **JavaScript Tools**: Tools for static analysis, pre and post processing of JavaScript files.
    + **[Babel](https://babeljs.io/)**: Babel is a generic multi-purpose compiler for JavaScript. Using Babel you can use (and create) the next generation of JavaScript, as well as the next generation of JavaScript tooling.
        + **[Full-Stack Redux Tutorial](http://teropa.info/blog/2015/09/10/full-stack-redux-tutorial.html)**: We will go through all the steps of constructing a Node+Redux backend and a React+Redux frontend for a real-world application, using test-first development.
        + **[JavaScript Transpilers: What They Are & Why We Need Them](https://scotch.io/tutorials/javascript-transpilers-what-they-are-why-we-need-them)**: Learn how to use Babel, and what has to do with the future of JavaScript.
    + **[Closure Compiler](https://developers.google.com/closure/compiler/)**: The Closure Compiler parses your JavaScript, analyzes it, removes dead code and rewrites and minimizes what's left. It also checks syntax, variable references, and types, and warns about common JavaScript pitfalls.
    + **[Flow](https://flowtype.org/)**: Flow is a static type checker for JavaScript. It can be used to catch common bugs in JavaScript programs before they run.
    + **[JSCodeshift](https://github.com/facebook/jscodeshift)**: Codemods are tools that assist large-scale, partially automatable codebase refactoring. JSCodeshift is a toolkit for running codemods over multiple JS files.
        + **[Turbocharged JavaScript Refactoring with Codemods](https://medium.com/airbnb-engineering/turbocharged-javascript-refactoring-with-codemods-b0cae8b326b9)**: Joe Lencioni describes how they used codemods to transform a large JavaScript code base at AirBnB
    + **JavaScript Code Linting**: Linting is the process of running a program that will analyse code for potential errors.
        + **[ESLint](http://eslint.org/)**: The pluggable linting utility for JavaScript and JSX.
        + **[JSHint](http://jshint.com/)**: JSHint is a tool for more flexible static analysis of JavaScript programs.
        + **[JSLint](http://jslint.com/)**: JSLint is a tool for detecting errors or problems by static analysis of JavaScript programs.
        + **[JSLint, JSHint and ESLint Error Explanations](http://jslinterrors.com)**: JSLint Error Explanations is designed to help you improve your JavaScript by understanding the sometimes cryptic error messages produced by JSLint, JSHint and ESLint, and teaching you how to avoid such errors.
    + **Module Bundlers and Loaders**: Libraries for bundling JavaScript Modules into one or several files.
        + **[Browserify](http://browserify.org/)**: Browserify lets you require('modules') in the browser by bundling up all of your dependencies.
            + **[Budo](https://github.com/mattdesl/budo)**: A browserify development server, focused on incremental reloading, LiveReload integration (including CSS injection), and other high-level features.
            + **[Watchify](https://www.npmjs.org/package/watchify)**: Watch mode for browserify builds.
        + **[CrapLoader](https://github.com/gregersrygg/crapLoader)**: The goal of crapLoader is to load ads, widgets or any JavaScript code with document.write in it. This library hijacks document.write and delegates the content loaded from each script into the correct position.
        + **[Modules Webmake](https://github.com/medikoo/modules-webmake)**: A CommonJS module bundler similar to Browserify but much faster due to different requirements finder.
        + **[Require.js](http://requirejs.org/)**: RequireJS is a JavaScript file and AMD module loader. It is optimized for in-browser use, but it can be used in other JavaScript environments.
        + **[Require1k](http://stuk.github.io/require1k/)**: CommonJS require for the browser in 1KB, with no build needed.
        + **[Rollup.js](http://rollupjs.org/)**: Rollup is a next-generation JavaScript module bundler. Author your app or library using ES2015 modules, then efficiently bundle them up into a single file for use in browsers and Node.js.
        + **[SystemJS](https://github.com/systemjs/systemjs)**: Universal dynamic module loader - loads ES6 modules, AMD, CommonJS and global scripts in the browser and NodeJS. Works with both Traceur and Babel.
            + **[Modular JavaScript: A Beginners Guide to SystemJS & JSPM](http://www.sitepoint.com/modular-javascript-systemjs-jspm/)**: The combination of jspm and SystemJS provides a unified way of installing and loading dependencies.
        + **[URequire](https://github.com/anodynos/urequire)**: The Ultimate JavaScript Module Builder & Automagical Task Runner.
        + **[Webpack](http://webpack.github.io/)**: Webpack is a module bundler. It takes modules with dependencies and generates static assets representing those modules.
            + **[Block, Element, Modifying Your JavaScript Components](https://medium.com/seek-ui-engineering/block-element-modifying-your-javascript-components-d7f99fcab52b)**: Mark Dalgleish is discussing how to organize React code with BEM and build everything with Webpack.
            + **[Developing with Docker and Webpack](http://dapperdeveloper.com/2016/05/18/developing-with-docker-and-webpack/)**: Chris Harrington explains how to create a development environment with Webpack and Docker to match the production as much as possible.
            + **[Full-Stack Redux Tutorial](http://teropa.info/blog/2015/09/10/full-stack-redux-tutorial.html)**: We will go through all the steps of constructing a Node+Redux backend and a React+Redux frontend for a real-world application, using test-first development.
            + **[How to Set Up Webpack Image Loader](http://www.davidmeents.com/how-to-set-up-webpack-image-loader/)**: This brief tutorial will help you set up an image loader in Webpack.
            + **[The SoundCloud Client in React + Redux](http://www.robinwieruch.de/the-soundcloud-client-in-react-redux/)**: After finishing this step by step tutorial you will be able to author your own React + Redux project with Webpack and Babel.
            + **[Webpack from Apprentice to Master](http://survivejs.com/webpack/)**: The purpose of this guide is to help you get started with Webpack and then go beyond basics.
            + **[WebpackBin](http://www.webpackbin.com/)**: A webpack code sandbox.
            + **[Why I think Webpack is the Right Approach To Build Pipelines](http://devlog.disco.zone/2016/06/01/webpack/)**: Thomas Boyt compares how Grunt, Gulp, Broccoli and Webpack discover dependencies.
    + **[Regenerator](https://github.com/facebook/regenerator)**: This package implements a source transformation that takes the proposed syntax for generators/yield from future versions of JS and spits out efficient JS-of-today (ES5) that behaves the same way.
+ **Package Management**: A package manager or package management system is a collection of software tools that automates the process of installing, upgrading, configuring, and removing reusable libraries and components in a consistent manner.
    + **[Bower](https://github.com/bower/bower)**: Bower offers a generic, unopinionated solution to the problem of front-end package management, while exposing the package dependency model via an API that can be consumed by a more opinionated build stack.
    + **[Lerna](https://github.com/lerna/lerna)**: Lerna is a tool that optimizes the workflow around managing multi-package repositories with git and npm.
    + **[NPM](https://www.npmjs.com/)**: NPM makes it easy for JavaScript developers to share and reuse code, and it makes it easy to update the code that you're sharing.
+ **[Sourcemaps](http://www.html5rocks.com/en/tutorials/developertools/sourcemaps/)**: Sourcemap is a way to map a combined/minified file back to an unbuilt state.
    + **[combine-source-map](https://www.npmjs.org/package/combine-source-map)**: Add source maps of multiple files, offset them and then combine them into one source map.
    + **[convert-source-map](https://www.npmjs.org/package/convert-source-map)**: Converts a source-map from/to different formats and allows adding/changing properties.
    + **[exorcist](https://github.com/thlorenz/exorcist)**: Externalizes the source map found inside a stream to an external .js.map file
    + **[generate-sourcemap](https://www.npmjs.org/package/generate-sourcemap)**: Generates a source map for files that were packed into a bundle.
    + **[inline-source-map](https://www.npmjs.org/package/inline-source-map)**: Adds source mappings and base64 encodes them, so they can be inlined in your generated file.
    + **[mold-source-map](https://www.npmjs.org/package/mold-source-map)**: Mold a source map that is almost perfect for you into one that is.
    + **[source-map-cjs](https://www.npmjs.org/package/source-map-cjs)**: Generates and consumes source maps. Adapted to be commonjs only and work in older browsers.
+ **Version Control**: Version control or source control is a system that records changes to a file or set of files over time so that you can recall specific versions later.
    + **[Git](https://git-scm.com/)**: Git is a free and open source distributed version control system designed to handle everything from small to very large projects with speed and efficiency.
        + **[Become a Git Guru](https://www.atlassian.com/git/tutorials)**: A series of Git tutorials by Atlassian.
    + **[OctoLinker](https://github.com/OctoLinker/browser-extension)**: The OctoLinker is a browser extensions which makes references to other files in GitHub clickable.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.