# Typography

**Context: [frontend-dev-bookmarks](../README.md) / Appearance**

The style, arrangement, or appearance of typeset matter.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **[A Comprehensive Guide to Font Loading Strategies](https://www.zachleat.com/web/comprehensive-webfonts/)**: Zach Leatherman describes different approaches to loading of web fonts.
+ **[Adobe Edge Web Fonts](https://edgewebfonts.adobe.com/fonts)**: Edge Web Fonts is a free service that provides access to a large library of fonts for your website. It’s one of the Edge Tools & Services from Adobe. Use of the service is free and unlimited.
+ **[Baseline.js](https://github.com/daneden/Baseline.js)**: A simple jQuery plugin for restoring vertical baselines thrown off by odd image sizes.
+ **[CSS Typography cheat sheet](http://www.newnet-soft.com/blog/csstypography)**: Small roundup on CSS features that will enhance your web typography.
+ **[Convincing a browser to load fonts from other domains](http://stackoverflow.com/questions/2892691/font-face-fonts-only-work-on-their-own-domain)**: A StackOverflow question about loading fonts across domains.
+ **[FitText](http://fittextjs.com/)**: FitText makes font-sizes flexible. Use this plugin on your fluid or responsive layout to achieve scalable headlines that fill the width of a parent element.
+ **[FlowType.JS](http://simplefocus.com/flowtype/)**: Font-size and line-height based on element width.
+ **[Fontmatrix](http://media.24ways.org/2007/17/fontmatrix.html)**: Matrix of fonts bundled with Mac and Windows operating systems, Microsoft Office and Adobe Creative Suite.
+ **[Google Fonts](https://www.google.com/fonts/)**: Google Fonts makes it quick and easy for everyone to use web fonts. Our goal is to create a directory of web fonts for the world to use. Our API service makes it easy to add Google Fonts to a website in seconds.
+ **[Gutenberg](http://matejlatin.github.io/Gutenberg/)**: Gutenberg is a flexible and simple-to-use web typography starter kit for web designers and developers.
+ **[Lettering.js](http://letteringjs.com/)**: Web type is exploding all over the web but CSS currently doesn't offer complete down-to-the-letter control. So we created a jQuery plugin to give you that control.
+ **[OpenFoundry](http://open-foundry.com/)**: A platform for open-source fonts in a noise-free environment; to highlight their beauty and encourage further exploration.
+ **[Pure Typography](http://tilomitra.github.io/csstypography/)**: CSS Styles for nicer web type. Depends on Pure.
+ **[Quick guide to webfonts via @font-face](http://www.html5rocks.com/en/tutorials/webfonts/quick/)**: The @font-face feature from CSS3 allows us to use custom typefaces on the web in an accessible, manipulable, and scalable way.
+ **[Truly Fluid Typography With vh And vw Units](https://www.smashingmagazine.com/2016/05/fluid-typography/)**: This article describes viewport units and other technics to achieve typography which resizes smoothly with the screen.
+ **[TypeButter](https://github.com/hudsonfoo/typebutter)**: TypeButter allows you to set optical kerning for any font on your website. If you're longing for beautifully laid out text that today' browsers just don't provide, this is the plugin for you.
+ **[Typeset.css](https://github.com/joshuarudd/typeset.css)**: A no-nonsense CSS typography reset for styling user-generated content like blog posts, comments, and forum content.
+ **[Typeset.css](http://stormwarning.github.io/typeset.css/)**: A Sass library that provides some sensible default styles, optional classes to use & extend as needed, and some utility functions & mixins to make elevating your typography simpler.
+ **[bacon](http://baconforme.com/)**: Bacon is a jQuery plugin that allows you to wrap text around a bezier curve or a line.
+ **[slabText](https://github.com/freqDec/slabText/)**: A jQuery plugin for producing big, bold & responsive headlines.
+ **[trunk8](http://jrvis.com/trunk8/)**: trunk8 is an intelligent text truncation plugin to jQuery. When applied to a large block of text, trunk8 will cut off just enough text to prevent it from spilling over.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.