# Visualization

**Context: [frontend-dev-bookmarks](../README.md) / Appearance**

Placing data in a visual context.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **[Bonsai.js](http://bonsaijs.org/)**: A lightweight graphics library with an intuitive graphics API and an SVG renderer.
+ **[Chart.js](http://www.chartjs.org/)**: Simple, clean and engaging charts for designers and developers.
+ **[Crossfilter](http://square.github.io/crossfilter/)**: Crossfilter is a JavaScript library for exploring large multivariate datasets in the browser.
+ **[Cube](http://square.github.io/cube/)**: Cube is a system for collecting timestamped events and deriving metrics. By collecting events rather than metrics, Cube lets you compute aggregate statistics post hoc.
+ **[Cubism.js](http://square.github.io/cubism/)**: Cubism.js is a D3 plugin for visualizing time series. Use Cubism to construct better realtime dashboards, pulling data from Graphite, Cube and other sources.
+ **[D3.js](https://d3js.org/)**: D3.js is a JavaScript library for manipulating documents based on data. D3 helps you bring data to life using HTML, SVG, and CSS.
    + **[DataMaps](http://datamaps.github.io/)**: Customizable SVG (world) map visualizations for the web in a single Javascript file using D3.js.
    + **[Interactive Introduction to D3](http://vadim.ogievetsky.com/IntroD3/)**: D3 slides in D3 that I put together after becoming frustrated with explaining D3 using PowerPoint.
    + **[NVD3](http://nvd3.org/)**: This project is an attempt to build re-usable charts and chart components for d3.js without taking away the power that d3.js gives you.
    + **[Tutorial: Introduction to D3](http://www.janwillemtulp.com/2011/03/20/tutorial-introduction-to-d3/)**: Basically we just plot hidden circles randomly on the screen, and then transition them to a portion of the screen. Then we add some interaction to it so that the circles will move once you move your mouse over them.
    + **[xCharts](http://tenxer.github.io/xcharts/)**: xCharts is a JavaScript library for building beautiful and custom data-driven chart visualizations for the web using D3.js. Using HTML, CSS, and SVG, xCharts are designed to be dynamic, fluid, and open to integrations and customization.
+ **[Easy Pie Chart](http://rendro.github.io/easy-pie-chart/)**: Easy pie chart is a jQuery plugin that uses the canvas element to render simple pie charts for single values
+ **[Flot](http://www.flotcharts.org/)**: Flot is a pure JavaScript plotting library for jQuery, with a focus on simple usage, attractive looks and interactive features.
+ **[Google Chart Tools](https://developers.google.com/chart/)**: The Google Visualization API allows you to create charts and reporting applications over structured data and helps integrate these directly into your website.
+ **[Paper.js](http://paperjs.org)**: Paper.js offers a clean Scene Graph / Document Object Model and a lot of powerful functionality to create and work with vector graphics and bezier curves.
+ **[Photon](http://photon.attasi.com/)**: Photon is a JavaScript library that adds simple lighting effects to DOM elements in 3D space.
+ **[Piecon](http://lipka.github.io/piecon/)**: A tiny javascript library for dynamically generating progress pie charts in your favicons.
+ **[Processing.js](http://berniesumption.com/software/animator/)**: Processing.js is the sister project of the popular Processing visual programming language, designed for the web. Processing.js makes your data visualizations work using web standards.
+ **[Smoothie Charts](http://smoothiecharts.org/)**: A JavaScript Charting Library for Streaming Data.
+ **[TimelineJS](http://timeline.knightlab.com/)**: TimelineJS is an open-source tool that enables anyone to build visually rich, interactive timelines.
+ **[Timesheet.js](http://sbstjn.github.io/timesheet.js/)**: Visualize your data and events with sexy HTML5 and CSS3. Create simple time sheets with sneaky JavaScript. Style them with CSS and have mobile fun as well.
+ **[Treefun by Jim Blackler](https://github.com/jimblackler/treefun)**: This tool creates SVG (Standard Vector Graphics) files to illustrate information structured as a basic tree.
+ **[jQuery.Gantt](http://taitems.github.io/jQuery.Gantt/)**: Draw Gantt charts with the famous jQuery ease of development.
+ **[jStat](http://jstat.github.io/)**: jStat is a statistical library written in JavaScript that allows you to perform advanced statistical operations without the need of a dedicated statistical language (e.g. MATLAB or R).
+ **[morris.js](http://morrisjs.github.io/morris.js/)**: Morris.js is a very simple API for drawing line, bar, area and donut charts.
+ **[mxgraph](http://jgraph.github.io/mxgraph/)**: mxGraph is a JavaScript diagramming library that enables interactive graph and charting applications to be quickly created that run natively in any major browser, both HTML 5 capable and Internet Explorer v7+.
+ **[three.js](http://threejs.org/)**: Three.js is a library that makes WebGL - 3D in the browser - easy to use. While a simple cube in raw WebGL would turn out hundreds of lines of Javascript and shader code, a Three.js equivalent is only a fraction of that.
+ **[vis.js](http://visjs.org/)**: Vis.js is a dynamic, browser based visualization library. The library is designed to be easy to use, handle large amounts of dynamic data, and enable manipulation of the data.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.