# Event-Driven Programming

**Context: [frontend-dev-bookmarks](../README.md) / Architecture**

Event-driven programming is a programming paradigm in which the flow of the program is determined by events such as user actions, sensor outputs, or messages from other programs&#x2F;threads.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **[Comparison Between Different Observer Pattern Implementations](https://github.com/millermedeiros/js-signals/wiki/Comparison-between-different-Observer-Pattern-implementations)**: The comparison below is just about the basic features of subscribing to an event type, dispatching and removing an event listener.
+ **[Event Emitter, Pub Sub or Deferred Promises](https://otaqui.com/blog/1374/event-emitter-pub-sub-or-deferred-promises-which-should-you-choose/)**: In this post Pete Otaqui explores a little about how each pattern works with (very) basic implementations and looks at the reasons why you might choose one over another.
+ **Implementations**: Libraries, frameworks and tools that use Event-Driven Programming paradigm.
    + **[Bacon.js](https://baconjs.github.io/)**: A small functional reactive programming lib for JavaScript. Turns your event spaghetti into clean and declarative feng shui bacon, by switching from imperative to functional.
    + **[Flight](http://flightjs.github.io/)**: An event-driven web framework, from Twitter.
    + **[Mediator.js](http://thejacklawson.com/Mediator.js/)**: Mediator is a simple class that allows you to register, unregister, and call subscriber methods to help event-based, asyncronous programming.
    + **[Postal.js](https://github.com/postaljs/postal.js)**: Postal.js takes the familiar "eventing-style" paradigm and extends it by providing "broker" and subscriber implementations
    + **[Radio.js](http://radio.uxder.com/)**: Radio.js is a small dependency-free publish/subscribe JavaScript library. Use it to implement the observer pattern in your code to help decouple your application architecture for greater maintainability.
    + **[js-signals](http://millermedeiros.github.io/js-signals/)**: Custom Event/Messaging system for JavaScript.
    + **[pubsub.js](https://github.com/federico-lox/pubsub.js)**: A tiny (~600 bytes when minified, ~300 bytes when gzip'd) and robust pubsub implementation.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.