# Functional Programming

**Context: [frontend-dev-bookmarks](../README.md) / Architecture**

Functional programming is a programming paradigm, that treats computation as the evaluation of mathematical functions and avoids changing-state and mutable data.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **A Gentle Introduction to Functional JavaScript**: A 3 part series, by Derick Bailey featuring Chet Harrison, about functional programming with many examples in JavaScript.
    + **[Monads, Monoids and Composition with Functional JavaScript](https://www.youtube.com/watch?v=ZQSU4geXAxM)**: Chet Harrison explains monads using form validation as an example.
    + **[Notes and Code from the Crowdcast](https://github.com/ChetHarrison/A-Gentle-Introduction-to-Functional-JavaScript)**: Chet Harrison provides a broad overview of functional programming concepts and a step by step tutorial for building Monads.
    + **[The Basics of Functional Programming](https://www.youtube.com/watch?v=myISHtMMeyU)**: In this first episode, you'll learn the basics of why functional programming, what it is, where it came from and what the core of it is. You'll see function composition, function purity, currying, higher order functions and first-class functions.
+ **[A Million Ways to Fold in JS](https://www.youtube.com/watch?v=JZSoPZUoR58)**: Brian Lonsdorf provides many functional alternatives to loops in this video.
+ **[Adventures in Functional Programming](https://vimeo.com/45140590)**: A talk by Jim Weirich, demonstrating how to use functional programming and lambda calculus to derive Y combinator.
+ **[Allong.es](http://allong.es/)**: allong.es is a JavaScript library based on the function combinator and decorator recipes introduced in the book JavaScript Allongé.
+ **[Barely Functional](https://github.com/cullophid/barely-functional)**: Tiny (2.7kb) functional programming library using native es5/6 operations.
+ **[Basic Lazy Evaluation and Memoization in JavaScript](http://blog.gypsydave5.com/2015/03/21/lazy-eval-and-memo/)**: Memoization is a way of optimizing code so that it will return cached results for the same inputs.
+ **[Bilby.js](http://bilby.brianmckenna.org/)**: A functional library based on category theory with immutable multimethods, functional data structures, functional operator overloading, automated specification testing.
+ **[Composability: from Callbacks to Categories in ES6](https://medium.com/@homam/composability-from-callbacks-to-categories-in-es6-f3d91e62451e)**: The author borrows some ideas from functional languages to explore a different approach for addressing the callback hell.
+ **[Curry or Partial Application?](https://medium.com/javascript-scene/curry-or-partial-application-8150044c78b8)**: Eric Elliott describes the difference between partial application and curry.
+ **[Daggy](https://github.com/puffnfresh/daggy)**: Library for creating tagged constructors with catamorphism.
+ **[Date FP](https://github.com/cullophid/date-fp)**: Functional programming date manipulation library.
+ **[Debugging Functional](https://medium.com/@drboolean/debugging-functional-7deb4688a08c)**: This post will demonstrate a simple solution that can go a long way to enhance the debugging experience in functional JavaScript applications.
+ **[Deterministic](https://deterministic.curated.co/)**: A weekly digest of interesting news and articles covering functional programming for the web, especially on the front end.
+ **Example Projects**: Open source projects which use functional programming, preferably point-free and side-effect-free.
    + **[Async Problem](https://github.com/plaid/async-problem)**: This project considers various approaches to the problem of concurrently reading files inside a directory and concatenating their contents.
    + **[CommonJS module dependencies resolver](https://github.com/iamstarkov/es-deps-deep)**: The module and all related modules are written using point-free style.
    + **[Egg Hunt Server](https://github.com/Bradcomp/egghunt-server/tree/functional)**: A restful API written in FP style.
    + **[Idealist](https://github.com/Avaq/Idealist)**: Functional HTTP micro-framework.
    + **[Sanctuary Build Script](https://github.com/sanctuary-js/sanctuary-site/blob/gh-pages/scripts/generate)**: A build script for generating the Sanctuary website.
+ **[FP DOM](https://github.com/fp-dom/fp-dom)**: A collection of functions to favor functional programming in a DOM context.
+ **[Fantasy Combinators](https://github.com/fantasyland/fantasy-combinators)**: Combinators which are used for fantasy-land projects.
+ **[Fantasy Land](https://github.com/fantasyland/fantasy-land)**: Specification for interoperability of common algebraic structures in JavaScript.
    + **[Conformant Implementations](https://github.com/fantasyland/fantasy-land/blob/master/implementations.md)**: A list of libraries implementing the Fantasy Land specification.
+ **[Fantasy Lenses](https://github.com/fantasyland/fantasy-lenses)**: Composable, immutable getters and setters.
+ **[Functional Concepts For JavaScript Developers: Currying](https://blog.simpleblend.net/functional-javascript-concepts-currying/)**: Andrew Robbins talks about what currying is and why it's useful.
+ **[Functional Core Reactive Shell](http://www.mokacoding.com/blog/functional-core-reactive-shell/)**: Giovanni Lodi makes an overview of different architecture meta-patterns and describes his current findings about functional programming and observables as a way to control side effects.
+ **[Functional Frontend Architecture](https://github.com/paldepind/functional-frontend-architecture)**: This repository is meant to document and explore the implementation of what is known as "the Elm architecture". A simple functional architecture for building frontend applications.
+ **[Functional JavaScript Mini Book](https://jcouyang.gitbooks.io/functional-javascript/content/en/index.html)**: Jichao Ouyang gives and introduction to functional programming with JavaScript and describes some Typeclasses like Functor and Monad.
+ **[Functional Javascript Workshop](https://github.com/timoxley/functional-javascript-workshop)**: The goal of this workshop is to create realistic problems that can be solved using terse, vanilla, idiomatic JavaScript.
+ **[Functional Principles In React](https://www.youtube.com/watch?v=1uRC3hmKQnM)**: Jessica Kerr talks about four functional principles: Composition, Declarative Style, Isolation and Flow Of Data, and their usage in React.
+ **[Functional Programming Jargon](https://github.com/hemanth/functional-programming-jargon)**: Jargon from the functional programming world in simple terms.
+ **[Functional Programming for JavaScript People](https://medium.com/@chetcorcos/functional-programming-for-javascript-people-1915d8775504)**: Chet Corcos explains different features of functional programming like composition, currying, lazy evaluation, referential transparency and compares Clojure with Haskell.
+ **[Functional Refactoring in JavaScript](http://victorsavkin.com/post/63551894251/functional-refactoring-in-javascript)**: In this article Victor Savkin shows how to apply functional thinking when refactoring JavaScript code. He does that by taking a simple function and transforming it into a more extendable one, which has no mutable state, and no if statements.
+ **[Functional.js](http://functionaljs.com/)**: Functional.js is a functional JavaScript library. It facilitates currying and point-free / tacit programming and this methodology has been adhered to from the ground up.
+ **[Functionize](https://github.com/paldepind/functionize)**: A collection of functions which aids in making non-functional libraries functional.
+ **[Futures and Monoids](https://medium.com/@yelouafi/futures-and-monoids-7e9f4574bd88)**: Yassine Elouafi explains the nature of Monoids using Futures, Numbers and Strings as examples.
+ **[Hey Underscore, You're Doing It Wrong!](http://functionaltalks.org/2013/05/27/brian-lonsdorf-hey-underscore-youre-doing-it-wrong/)**: In this talk Brian Lonsdorf gently takes a shot at underscore.js for not thinking about currying and partial function application in its library design.
+ **[Immutability, Interactivity & JavaScript](https://www.youtube.com/watch?v=mS264h8KGwk)**: We'll dive in and see how trees of JavaScript arrays can permit building efficient immutable collections. Then we'll see how embracing immutable values dramatically simplifies some classic hard problems in client side programming including but not limited to undo, error playback, and online/offline synchronization.
+ **[Immutable Sequence.js](https://github.com/qiao/immutable-sequence.js)**: High performance implementation of Immutable Sequence in JavaScript, based on Finger Tree.
+ **[Immutable.js](https://github.com/facebook/immutable-js/)**: Immutable persistent data collections for Javascript which increase efficiency and simplicity.
+ **[JSAir - Functional and Immutable Design Patterns in JavaScript](https://javascriptair.com/episodes/2015-12-30/)**: An episode of JavaScript Air about "the how and why of functional programming and immutable design patterns in JavaScript" with Dab Abramov and Brian Lonsdorf as guests.
+ **[JavaScript and Type Thinking](https://medium.com/@yelouafi/javascript-and-type-thinking-735edddc388d)**: Yassine Elouafi introduces Algebraic Data Types with an example of a simple and a recursive type.
+ **[Javascript Combinators by Reginald Braithwaite](https://vimeo.com/97408202)**: In this talk, we'll explore functions that consume and return functions, and see how they can be used to build expressive programs that hew closely to JavaScript's natural style.
+ **[Lamda.js](https://github.com/loop-recur/lambdajs)**: This library takes all the methods on instances of strings, arrays, objects, numbers, and regexp's and turns them into functions that can be used in a pointfree way.
+ **[Lenses Quick n’ Dirty](https://vimeo.com/104807358)**: A video by Brian Lonsdorf that introduces lenses.
+ **[Lenses and Virtual DOM Support Open Closed](http://joneshf.github.io/programming/2015/12/19/Lenses-and-Virtual-DOM-Support-Open-Closed.html)**: Hardy Jones explains how Lenses work using a simple example of working with Virtual DOM.
+ **[Lenses.js](https://github.com/DrBoolean/lenses)**: Composable kmett style lenses.
+ **[Lodash/fp](https://github.com/lodash/lodash/wiki/FP-Guide)**: The lodash/fp module is an instance of lodash with its methods wrapped to produce immutable auto-curried iteratee-first data-last methods.
+ **[Making your JavaScript Pure](http://alistapart.com/article/making-your-javascript-pure)**: Jack Franklin compares pure and impure functions and describes how to leverage functional programming principles in JavaScript.
+ **Monads**: Composable computation descriptions. The essence of monad is thus separation of composition timeline from the composed computation's execution timeline, as well as the ability of computation to implicitly carry extra data.
    + **Collections of Monads**: Libraries of monad implementations.
        + **[Akh](http://akh-js.com/)**: Akh includes a basic set of common monad transformers, along with monads derived from these transformers. Akh structures implement the Fantasy Land specification.
        + **[Folktale](http://folktale.origamitower.com)**: Folktale is a suite of libraries for generic functional programming in JavaScript that allows you to write elegant modular applications with fewer bugs, and more reuse.
        + **[Monet.js](https://github.com/cwmyers/monet.js)**: Monet is a tool bag that assists Functional Programming by providing a rich set of Monads and other useful functions.
    + **Continuation Monad**: Represents computations in continuation-passing style (CPS). In continuation-passing style function result is not returned, but instead is passed to another function, received as a parameter (continuation).
        + **[The Delimited Continuation Monad in Javascript](http://blog.mattbierner.com/the-delimited-continuation-monad-in-javascript/)**: This post overviews continuations in Atum and covers the implementation of the delimited continuation monad in JavaScript.
    + **Either Monad**: The Either type represents values with two possibilities: a value of type Either a b is either Left a or Right b. It is often used for error handling.
        + **[Lazy Either](https://www.npmjs.com/package/lazy-either)**: The LazyEither type is used to represent a lazy Either value. It is similar to the Future and Promise types.
        + **[Practical Intro to Monads in JavaScript: Either](https://tech.evojam.com/2016/03/21/practical-intro-to-monads-in-javascript-either/)**: Jakub Strojewski describes the Either Monad, a tool for fast-failing, synchronous computation chains.
    + **Free Monad**: A free monad satisfies all the Monad laws, but does not do any computation. It just builds up a nested series of contexts. The user who creates such a free monadic value is responsible for doing something with those nested contexts.
        + **[Fantasy Frees](https://github.com/fantasyland/fantasy-frees)**: An implementation of Coyoneda, Yoneda, Trampoline, Free Monad and Free Applicative with usage examples.
        + **[Free Monad Experiments by Hardy Jones](https://github.com/joneshf/abstractions/tree/master/src)**: Coyoneda, Coproduct, Either, Free, State, AJAX and so on.
        + **[Free Monads Video Series](https://www.youtube.com/watch?v=WH5BrkzGgQY&list=PLK_hdtAJ4KqUWp5LJdLOgkD_8qKW0iAHi&index=1)**: A video series on free monads by Brian Lonsdorf explaining Coyoneda, Free Monad and Interpretors.
        + **[Freeky](https://github.com/DrBoolean/freeky)**: Collection of free monads by Brian Lonsdorf.
    + **Futures**: Futures represent the value arising from the success or failure of an asynchronous operation (I/O).
        + **[Fluture](https://github.com/Avaq/Fluture)**: The debuggable Fantasy Land Future library.
        + **[Folktale Task](http://folktale.origamitower.com/api/v2.1.0/en/folktale.concurrency.task.html)**: A structure for time-dependent values, providing explicit effects for delayed computations, latency, etc.
        + **[From Callback to Future -> Functor -> Monad](https://medium.com/@yelouafi/from-callback-to-future-functor-monad-6c86d9c16cb5)**: Yassine Elouafi goes through a simple implementation of Futures and compares them to Promises.
        + **[Future IO](https://github.com/futurize/future-io)**: A fantasy-land compliant monadic IO library for Node.js.
        + **[Futurizer](https://github.com/arcseldon/futurizer)**: Turn callback-style functions or promises into futures!
    + **Introduction**: Introductory materials about monads.
        + **[Monads in JavaScript](https://curiosity-driven.org/monads-in-javascript)**: This article explains monads and their usage in JavaScript including Identity, Maybe, List, Continuation, Do notation and Chaining.
        + **[Practical Intro to Monads in JavaScript](https://tech.evojam.com/2016/02/22/practical-intro-to-monads-in-javascript/)**: A simple, practical tutorial for JavaScript developers showing how some monads can be used.
        + **[Understanding Monads With JavaScript](http://igstan.ro/posts/2011-05-02-understanding-monads-with-javascript.html)**: The author starts with a problem of dealing with explicit immutable state and solves it with JavaScript using monads.
    + **Maybe Monad**: Using Maybe is a good way to deal with errors or exceptional cases without resorting to drastic measures such as error. It is a simple kind of error monad, where all errors are represented by Nothing. A richer error monad can be built using the Either type.
        + **[A Gentle Intro to Monads … Maybe?](http://sean.voisen.org/blog/2013/10/intro-monads-maybe/)**: A short introduction to Maybe and the world of monads.
        + **[A Monad in Practicality: First-Class Failures](http://robotlolita.me/2013/12/08/a-monad-in-practicality-first-class-failures.html)**: This article shows how the Maybe monad can be used for handling simple failure use cases. It then extrapolates into complex failure scenarios and shows how these cases can be modelled in terms of the Either monad.
        + **[Practical Intro to Monads in JavaScript](https://tech.evojam.com/2016/02/22/practical-intro-to-monads-in-javascript/)**: A simple, practical tutorial for JavaScript developers showing how some monads can be used.
    + **Reader Monad**: Represents a computation, which can read values from a shared environment, pass values from function to function, and execute sub-computations in a modified environment.
        + **[Don’t Fear the Reader](https://passy.svbtle.com/dont-fear-the-reader)**: Pascal Hartig explains how to use the reader monad in JavaScript.
        + **[Fantasy Readers](https://github.com/fantasyland/fantasy-readers)**: Fantasy Land compatible implementation of the Reader Monad.
        + **[LiveCoding Video of Reader Monad Implementation](https://www.livecoding.tv/evilsoft/videos/WojoB-functional-js-reader-monad)**: In this video you will learn how to use and implement a Reader from scratch.
        + **[Monad a Day: Reader](https://vimeo.com/105300347)**: Short video by Brian Lonsdorf about the Reader Monad.
    + **Transformers**: Special types that allow us to roll two monads into a single one that shares the behavior of both.
        + **[Akh](http://akh-js.com/)**: Akh includes a basic set of common monad transformers, along with monads derived from these transformers. Akh structures implement the Fantasy Land specification.
        + **[Fantasy ArrayT](https://github.com/quarterto-archive/fantasy-arrayt)**: Monad transformer for JavaScript Arrays.
        + **[Monad Transformers](https://github.com/boris-marinov/monad-transformers)**: Monad transformers are tricky, they require an excessive amount of type juggling. One of the aims of this package is to reduce the amount of wrapping and unwrapping needed for making a new transformer and to provide an easy way to define and combine transformers.
        + **[Monad Transformers Library](https://github.com/boris-marinov/monad-transformers)**: Practical monad transformers for JS.
    + **Validation Monad**: A disjunction that is appropriate for validating inputs and aggregating failures.
        + **[Folktale Validation](http://folktale.origamitower.com/api/v2.1.0/en/folktale.validation.html)**: Validation Monad implementation of Folktale Library.
        + **[Practical Intro to Monads in JavaScript: Validation](https://tech.evojam.com/2016/04/26/practical-intro-to-monads-in-javascript-validation/)**: Jakub Strojewski shows how to accumulate errors in a simple Validation use case.
+ **[Mori](http://swannodette.github.io/mori/)**: A library for using ClojureScript's persistent data structures and supporting API from the comfort of vanilla JavaScript.
+ **[Mostly Adequate Guide to Functional Programming](https://drboolean.gitbooks.io/mostly-adequate-guide/content/)**: A book by Brian Lonsdorf that introduces algebraic functional programming in JavaScript.
+ **[Nanoscope](http://kovach.me/nanoscope/)**: Nanoscope is a javascript library designed to make complex transformations of data much easier. It is a built on the idea of a functional Lens - a construct that enables focusing on sub-parts of data structures to get and modify.
+ **[Pointfree Fantasy](https://www.npmjs.com/package/pointfree-fantasy)**: Point-free wrappers for fantasy-land. Functions are curried using lodash's curry function, and receive their data last. Gives us aliases with our familar haskell names as well.
+ **[Pointfree Javascript](http://lucasmreis.github.io/blog/pointfree-javascript/)**: In this post Lucas Reis presents what is called pointfree style programming and goes through some common scenarios to demonstrate its benefits.
+ **[Practical Functional Programming: Pick Two](https://www.youtube.com/watch?v=XcS-LdEBUkE)**: James Coglan tries to show in this video how to use functional concepts in daily JavaScript programming.
+ **[Promises + FP = Beautiful Streams](https://medium.com/@yelouafi/promises-fp-beautiful-streams-6f0235c5b179)**: Yassine Elouafi show how to use functional programming and algebraic data types to derive a pure functional definition of reactive programming like streams.
+ **[Pure JavaScript](https://vimeo.com/49384334)**: Christian Johansen shows you how you can up your game by leaving loops behind and embracing functions as the primary unit of abstraction.
+ **[Pure UI](http://rauchg.com/2015/pure-ui/)**: Guillermo Rauch discusses the definition of an application’s UI as a pure function of application state.
+ **[PureScript](http://www.purescript.org/)**: PureScript is a strongly, statically typed language which compiles to JavaScript. It is written in and inspired by Haskell.
+ **[Ramda](http://ramdajs.com/)**: A practical library designed specifically for a functional programming style, one that makes it easy to create functional pipelines, one that never mutates user data.
    + **Practical Ramda - Functional Programming Examples**: Tom MacWright gives some practical examples of Ramda usage.
+ **[Ramda Fantasy](https://github.com/ramda/ramda-fantasy)**: Fantasy Land compatible types for easy integration with Ramda. This is an experimental project and will probably merge with Sanctuary.
+ **[Sanctuary](http://sanctuary.js.org/)**: Sanctuary is a functional programming library inspired by Haskell and PureScript. It depends on and works nicely with Ramda. Sanctuary makes it possible to write safe code without null checks.
    + **[Sanctuary Build Script](https://github.com/sanctuary-js/sanctuary-site/blob/gh-pages/scripts/generate)**: A build script for generating the Sanctuary website.
+ **[The Little Idea of Functional Programming](http://jaysoo.ca/2016/01/13/functional-programming-little-ideas/)**: Jack Hsu tries to take a look at a couple of simple concepts that make up the little idea behind functional programming and to tie the concepts back to code examples in JavaScript.
+ **[Timm](http://guigrpa.github.io/timm/)**: Immutability helpers with fast reads and acceptable writes.
+ **[Transducers](http://blog.cognitect.com/blog/2014/8/6/transducers-are-coming)**: Transducers are a powerful and composable way to build algorithmic transformations that you can reuse in many contexts.
    + **["Transducers" Presentation at Strange Loop](https://www.youtube.com/watch?v=6mTbuzafcII)**: This talk will describe transducers, a new library feature for Clojure (but of interest to other languages) that emphasizes composable, context-free, intermediate-free notions like 'mapping' and 'filtering' and their concrete reuse across all of the contexts above.
    + **[Figuring out what transducers are good for](http://gfxmonk.net/2015/11/25/figuring-out-what-transducers-are-good-for.html)**: Tim Cuthbertson attempts some plausible but detailed examples with Transducers in JavaScript.
    + **Implementations**: Libraries that implement Transducer protocoll and include ready to use transformers.
        + **[Transduce](https://github.com/transduce/transduce)**: Implementation by Kevin Beaty extracted from underarm.
        + **[Transducers-js by Cognitect Labs](https://github.com/cognitect-labs/transducers-js)**: A high performance Transducers implementation for JavaScript by Cognitect Labs.
        + **[Transducers.js Library by James Long](https://github.com/jlongster/transducers.js)**: A small library for generalized transformation of data (inspired by Clojure's transducers)
            + **[Transducers.js Round 2 with Benchmarks](http://jlongster.com/Transducers.js-Round-2-with-Benchmarks)**: Refactored version of Transducers.js, some benchmarks, Laziness, the transformer protocoll.
            + **[Transducers.js: A JavaScript Library for Transformation of Data](http://jlongster.com/Transducers.js--A-JavaScript-Library-for-Transformation-of-Data)**: A post announcing the transducers.js library with some explanation.
    + **[Streaming Logs with Transducers and Ramda](http://simplectic.com/blog/2015/ramda-transducers-logs/)**: In this article we will use Ramda to parse a log file without curly braces (and introduce transducers along the way).
    + **[Transducers Documentation for Clojure](http://clojure.org/reference/transducers)**: Transducers are composable algorithmic transformations. They are independent from the context of their input and output sources and specify only the essence of the transformation in terms of an individual element.
    + **[Transducers Explained: Part 1](http://simplectic.com/blog/2014/transducers-explained-1/)**: An introduction to transducers using JavaScript. We will work from reducing over arrays, to defining transformations as transformers, then incrementally introducing transducers and using them with transduce.
    + **[Transducers Explained: Pipelines](http://simplectic.com/blog/2014/transducers-explained-pipelines/)**: In this article, we will introduce four new transducers: filter, remove, drop and take. We will show how transducers can be composed into pipelines and talk about the order of transformation.
    + **[Transducers are Coming](http://blog.cognitect.com/blog/2014/8/6/transducers-are-coming)**: The first announcement by Rich Hickey.
    + **[Transducers with Observable Sequences](https://xgrommx.github.io/rx-book/content/getting_started_with_rxjs/creating_and_querying_observable_sequences/transducers.html)**: A chapter from the RxJS Book describing Transducers.
    + **[Understanding Transducers in JavaScript](https://medium.com/@roman01la/understanding-transducers-in-javascript-3500d3bd9624#.3lbq6d4yq)**: Roman Liutikov translated code examples from similar Clojure article into JavaScript. So you can still read the article and check code examples here.
+ **[Union Type](https://github.com/paldepind/union-type)**: Union types are a way to group different values together. Union-type is a small JavaScript library for defining and using union types.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.