# Mobile

**Context: [frontend-dev-bookmarks](../README.md) / Compatibility**

Development of websites optimized for viewing on smartphone and tablet devices.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **Emulation**: Tools for emulating features of mobile devices on a desktop.
    + **[Responsinator](http://www.responsinator.com/)**: Quickly test any website in popular resolutions.
    + **[Simulate Mobile Devices with Chrome Developer Tools](https://developers.google.com/web/tools/chrome-devtools/iterate/device-mode/?hl=en)**: Use Chrome DevTools' Device Mode to build mobile-first, fully responsive web sites. Learn how to use it to simulate a wide range of devices and their capabilities.
    + **[Touché](https://github.com/davidcalhoun/touche)**: Touché: bringing touch events to non-touch browsers (how touching!). No dependencies. No code bloat.
    + **[thumbs.js](http://mwbrooks.github.io/thumbs.js/)**: Adds touch support to your browser.
+ **Gestures**: Resources for working with touch mechanics (what your fingers do on the screen) and touch activities (results of specific gestures).
    + **[Hammer.js](http://hammerjs.github.io/)**: Hammer helps you add support for touch gestures to your page, and remove the 300ms delay from clicks.
    + **[Introduction to Gestures](https://www.google.com/design/spec/patterns/gestures.html)**: Descriptions of different gestures an their meanings.
    + **[Pointer Events Polyfill](https://github.com/jquery/PEP)**: PEP polyfills pointer events in all browsers that haven't yet implemented them, providing a unified, responsive input model for all devices and input types.
    + **[Touchy](https://github.com/HotStudio/touchy)**: Touchy is a jQuery plugin for managing touch events on W3C-compliant browsers, such as Mobile Safari or Android Browser, or any browser that supports the ontouchstart, ontouchmove and ontouchend events.
    + **[jGestures](http://jgestures.codeplex.com/)**: A jQuery plugin that enables you to add gesture events just like native jQuery events. Includes event substitution for mouse events.
+ **Layout**: The way in which the parts of the website are arranged or laid out.
    + **[Snap.js](https://github.com/jakiestfu/Snap.js)**: A Library for creating beautiful mobile shelfs (side menus) in Javascript.
    + **[Swipe](https://github.com/thebird/swipe)**: Swipe is the most accurate touch slider.
    + **[Swiper](http://idangero.us/swiper/)**: Swiper is a free mobile touch slider with hardware accelerated transitions and  native behavior. It is intended to be used in mobile websites, mobile web apps, and mobile native/hybrid apps.
    + **[jqm-pagination](https://github.com/filamentgroup/jqm-pagination)**: A jQuery Mobile plugin for sequential pagination between pages with support for touch, mouse, and keyboard.
    + **[swipeslide](https://github.com/max-power/swipeslide)**: A Zepto Plugin for iOS like swipe navigation.
+ **Scrolling**: Native scrolling of the browsers doesn't always fit for mobile websites. There are resources which solve this problem.
    + **[Overscroll](https://github.com/azoff/overscroll)**: Overscroll is a jQuery plug-in that mimics the iphone/ipad scrolling experience in a browser.
    + **[Overthrow](https://www.filamentgroup.com/lab/overthrow.html)**: A framework-independent, overflow: auto polyfill for use in responsive design.
    + **[Zynga Scroller](https://github.com/zynga/scroller)**: A pure logic component for scrolling/zooming. It is independent of any specific kind of rendering or event system.
    + **[iScroll](http://iscrolljs.com/)**: iScroll is a high performance, small footprint, dependency free, multi-platform javascript scroller.
    + **[jQuery.pep.js](http://pep.briangonzalez.org/)**: A lightweight plugin for kinetic-drag on mobile/desktop.
    + **[jSwipeKinetic](http://jswipekinetic.codeplex.com/)**: A jQuery plugin that enables you to add kinetic scrolling on your touch optimized projects. jSwipeKinetic is build on top of jGestures.
    + **[pull-to-refresh.js](https://github.com/visiongeist/pull-to-refresh-js)**: This plugin enables a pull-to-refresh functionality in mobile safari for scrollable block elements with native scrolling on iOS.
+ **Tap Acceleration**: Every touch-based mobile browser has an artificial ~300ms delay between you tapping a thing on the screen and the browser considering it a "click", but there are ways to work around this behavior.
    + **[300ms Tap Delay, Gone Away](https://developers.google.com/web/updates/2013/12/300ms-tap-delay-gone-away)**: An article by Google describing the 300ms delay and how Chrome 32+ on Anrdoid deals with it.
    + **[Hammer.js](http://hammerjs.github.io/)**: Hammer helps you add support for touch gestures to your page, and remove the 300ms delay from clicks.
    + **[Tappable](http://cheeaun.github.io/tappable/)**: Tappable is a simple, standalone library to invoke the tap event for touch-friendly web browsers.
    + **[fastclick](https://github.com/ftlabs/fastclick)**: FastClick is a simple, easy-to-use library for eliminating the 300ms delay between a physical tap and the firing of a click event on mobile browsers.
+ **Touch Keyboard**: Almost all modern smartphones provide a touch based keyboard for text input. There are some tactics to influence them and work around their quirks.
    + **[A Guide To Designing Touch Keyboards](https://www.smashingmagazine.com/2013/08/guide-to-designing-touch-keyboards-with-cheat-sheet/)**: In this article, we will look a bit deeper into the usability issues surrounding touch keyboards, including five design guidelines that will alleviate some of these pains.
+ **Working With Sensors**: All mobile devices are equipped with sensors like gyroscope, accelerometers, photometers, magnetometers and so on. Some of them are accessible in a browser through JavaScript.
    + **[This End Up: Using Device Orientation](http://www.html5rocks.com/en/tutorials/device/orientation/)**: In this article, we’ll take a look at device orientation and motion events, and use CSS to rotate an image based on the orientation of the device.
    + **[lenticular.js](http://lenticular.attasi.com/)**: Tilt-controlled images in the browser.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.