# Responsive Web Design (RWD)

**Context: [frontend-dev-bookmarks](../README.md) / Compatibility**

RWD responds to the needs of the users and the devices they’re using. The layout changes based on the size and capabilities of the device.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **Data Tables**: Tables filled with data don't behave well on small screens. Here are some resources to tame them.
    + **[Responsive Data Tables](https://css-tricks.com/responsive-data-tables/)**: Several ideas by Chris Coyier on how to deal with responsive tables.
    + **[stacktable.js](http://johnpolacek.github.com/stacktable.js/)**: jQuery plugin for stacking tables on small screens.
+ **[Future Friendly Thinking](http://futurefriendlyweb.com/thinking.html)**: We want to make things that are future friendly. The following ideas have been on our minds recently. Help us explore them further or suggest new ones.
+ **[How to make a Responsive Newspaper-like layout](http://www.newnet-soft.com/blog/responsive-multi-column)**: The article describes several approaches for creating multi column websites.
+ **Images**: Images pose a set of problems on responsive websites: scaling, performance, retina screens and file size.
    + **[Adaptive Images](http://adaptive-images.com/)**: Adaptive Images detects your visitor's screen size and automatically creates, caches, and delivers device appropriate re-scaled versions of your web page's embeded HTML images.
    + **[Choosing A Responsive Image Solution](https://www.smashingmagazine.com/2013/07/choosing-a-responsive-image-solution/)**: This article leads you through the basics, and then arms you with the information you’ll need to pick the best responsive image solution for your situation.
    + **[Clown Car Technique](https://github.com/estelle/clowncar)**: We can use media queries within SVG to serve up the right image. The beauty of the "Clown Car" technique is that all the logic remains in the SVG file.
    + **[How to Use Responsive Images...](http://www.shutterstock.com/blog/2013/05/how-to-use-responsive-images-to-make-your-site-shine-on-any-platform/)**: Engineers at Shutterstock describe different problems and solutions around responsive images.
    + **[Picturefill](http://scottjehl.github.io/picturefill/)**: A responsive image polyfill for <picture>, srcset, sizes, and more.
    + **[Riloadr](https://github.com/tubalmartin/riloadr)**: The goal of this library is to deliver optimized, contextual image sizes in responsive layouts that utilize dramatically different image sizes at different resolutions in order to improve page load time.
    + **[Why We Need Responsive Images](https://timkadlec.com/2013/06/why-we-need-responsive-images/)**: Tim Kadlec talks about page weight and responsive image solutions.
    + **[imgLiquid](https://github.com/karacas/imgLiquid)**: A jQuery Plugin to resize images to fit in a container.
    + **[jQuery Picture](http://jquerypicture.com/)**: jQuery Picture is a tiny (2kb) plugin to add support for responsive images to your layouts. It supports both figure elements with some custom data attributes and the new proposed picture format.
+ **Monitoring Breakpoints**: Triggering JavaScript events on different breakpoints.
    + **[Breakpoints.js](http://xoxco.com/projects/code/breakpoints/)**: Define breakpoints for your responsive design, and Breakpoints.js will fire custom events when the browser enters and/or exits that breakpoint.
    + **[Harvey](http://harvesthq.github.io/harvey/)**: Harvey helps you monitor and manage behavior changes by firing an event whenever your media query is activated.
    + **[enquire.js](http://wicky.nillia.ms/enquire.js/)**: enquire.js is a lightweight, pure javascript library (with no dependencies) for programmatically responding to media queries.
+ **Navigation**: Adapting the website navigation to different screen sizes.
    + **[Complex Navigation Patterns](http://bradfrost.com/blog/web/complex-navigation-patterns-for-responsive-design/)**: The article describes some emerging patterns for dealing with complex, lengthy and/or multi-level navigations.
    + **[Responsive Navigation On Complex Websites](http://mobile.smashingmagazine.com/2013/09/11/responsive-navigation-on-complex-websites/)**: To illustrate the techniques involved in implementing responsive navigation on a large website, author refers to two actual clients.
    + **[Responsive Navigation Patterns](http://bradfrost.com/blog/web/responsive-nav-patterns/)**: The article describes some of the more popular techniques for handling navigation in responsive designs.
+ **[Responsive Design Workflow](http://vimeo.com/45915667)**: In this video, Stephen Hay explores at a content-based approach to design workflow which is grounded in our multiplatform reality, not fixed-width Photoshop comps and overproduced wireframes.
+ **[Responsive Elements](http://kumailht.com/responsive-elements/)**: Responsive elements makes it possible for any element to adapt and respond to the area they occupy. It's a tiny JavaScript library that you can drop into your projects today.
+ **[Responsive Patterns](http://bradfrost.github.io/this-is-responsive/patterns.html)**: A collection of patterns and modules for responsive designs.
+ **Text**: Working with text in a context of different viewport sizes.
    + **[FitText](http://fittextjs.com/)**: FitText makes font-sizes flexible. Use this plugin on your fluid or responsive layout to achieve scalable headlines that fill the width of a parent element.
    + **[Out Of Words!](http://starburst1977.github.io/out-of-words/)**: The responsive typography framework behind Words App.
    + **[Responsive Font Sizing](http://www.newnet-soft.com/blog/responsivefontsizing)**: Making your font size respond to your screen size, easy & maintainable.
    + **[Responsive Measure](http://jbrewer.github.com/Responsive-Measure/)**: A jQuery plugin for generating a responsive ideal measure.
    + **[Truly Fluid Typography With vh And vw Units](https://www.smashingmagazine.com/2016/05/fluid-typography/)**: This article describes viewport units and other technics to achieve typography which resizes smoothly with the screen.
+ **[Viewport Component](https://github.com/pazguille/viewport)**: Viewport is a component to ease viewport management. You can get the dimensions of the viewport and beyond, which can be quite helpful to perform some checks with JavaScript.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.