# Organizations

**Context: [frontend-dev-bookmarks](../README.md) / Ecosystem**

Commercial companies and nonprofit organizations around web development.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **[Airbnb](http://airbnb.io/projects/)**: Airbnb is a website for people to list, find, and rent lodging.
    + **[Airbnb CSS + Sass Style Guide](http://airbnb.io/projects/css/)**: This style guide covers Terminology, Rule Declaration, Selectors, Properties, Formatting, Comments, OOCSS and BEM, ID Selectors, JavaScript hooks
Sass, Syntax, Ordering, Mixins, Placeholders, Nested selectors.
    + **[Airbnb JavaScript Style Guide](http://airbnb.io/projects/javascript/)**: A style guide for writing JavaScript code at Airbnb.
    + **[Enzyme](http://airbnb.io/projects/enzyme/)**: Enzyme is a JavaScript Testing utility for React that makes it easier to assert, manipulate, and traverse your React Components’ output.
    + **[Polyglot](http://airbnb.io/polyglot.js/)**: Polyglot.js is a I18n helper library written in JavaScript, made to work both in the browser and in CommonJS environments (Node). It provides a simple solution for interpolation and pluralization.
    + **[Turbocharged JavaScript Refactoring with Codemods](https://medium.com/airbnb-engineering/turbocharged-javascript-refactoring-with-codemods-b0cae8b326b9)**: Joe Lencioni describes how they used codemods to transform a large JavaScript code base at AirBnB
+ **[Box Inc.](http://opensource.box.com/)**: Box is an online file sharing and content management service for businesses based in Redwood City, California.
    + **[Leche](https://github.com/box/leche)**: A JavaScript testing utility designed to work with Mocha and Sinon. This is intended for use both by Node.js and in browsers, so any changes must work in both locations.
    + **[Nicholas C. Zakas](https://www.nczonline.net/about/)**: Former principal front-end engineer at Yahoo! and YUI developer. Leads a team of frontend engineers at Box now.
        + **[Box Tech Talk: Scalable JavaScript Application Architecture](https://www.youtube.com/watch?v=mKouqShWI4o)**: A video by Nicholas Zakas (2012) about JavaScript Architecture.
        + **[Scalable JavaScript Application Architecture](https://www.youtube.com/watch?v=vXjVFPosQHw)**: In this video (2011) Nicholas Zakas discusses frontend architecture for complex, modular web applications with significant JavaScript elements.
        + **[T3](http://t3js.org/)**: T3 is a minimalist JavaScript framework sponsored by Box Inc. that provides core structure to code.
        + **[Understanding ECMAScript 6](https://leanpub.com/understandinges6/read)**: Free (as in pay what you want) E-Book by Nicholas C. Zakas describing the new features in EcmaScript 6.
    + **[Shalam](https://github.com/box/shalam)**: A friendly tool for CSS spriting. Shalam allows you to add Retina-friendly, high-quality image sprites to your website without modifying any markup.
    + **[T3](http://t3js.org/)**: T3 is a minimalist JavaScript framework sponsored by Box Inc. that provides core structure to code.
    + **[stalker](https://github.com/box/stalker)**: A jQuery plugin allowing elements to follow the user as they scroll a page.
+ **[Facebook](https://code.facebook.com/projects/)**: Facebook is a corporation and online social networking service headquartered in Menlo Park, California, in the United States.
    + **[Immutable.js](https://github.com/facebook/immutable-js/)**: Immutable persistent data collections for Javascript which increase efficiency and simplicity.
    + **[React](http://facebook.github.io/react/)**: React is a JavaScript library for creating user interfaces. Many people choose to think of React as the V in MVC. We built React to solve one problem: building large applications with data that changes over time.
        + **[3 Lightweight React Alternatives](https://www.sitepoint.com/react-alternatives-preact-virtualdom-deku/)**: Dan Prince explores Preact, VirtualDom & Deku.
        + **[A Stateless React App?](http://jamesknelson.com/state-react-1-stateless-react-app/)**: James K Nelson describes how to avoid state in React Components.
        + **[Block, Element, Modifying Your JavaScript Components](https://medium.com/seek-ui-engineering/block-element-modifying-your-javascript-components-d7f99fcab52b)**: Mark Dalgleish is discussing how to organize React code with BEM and build everything with Webpack.
        + **[CSS Modules To The Rescue.jsx](https://medium.com/@kadmil/css-modules-to-the-rescue-jsx-ded2db874d34)**: If you use react-like templates/components, use webpack CSS loader to enable CSS Modules and forget about global CSS problems.
        + **[Find Your Perfect React Starter Project](http://andrewhfarmer.com/starter-project/)**: A simple search engine for React boilerplates with the ability to pick the ingredients.
        + **[Full-Stack Redux Tutorial](http://teropa.info/blog/2015/09/10/full-stack-redux-tutorial.html)**: We will go through all the steps of constructing a Node+Redux backend and a React+Redux frontend for a real-world application, using test-first development.
        + **[Functional DOM Programming](https://medium.com/@floydophone/functional-dom-programming-67d81637d43)**: One of the earliest intros to React and its purpose by Pete Hunt.
        + **[Functional Principles In React](https://www.youtube.com/watch?v=1uRC3hmKQnM)**: Jessica Kerr talks about four functional principles: Composition, Declarative Style, Isolation and Flow Of Data, and their usage in React.
        + **[Getting Started with TDD in React](https://semaphoreci.com/community/tutorials/getting-started-with-tdd-in-react)**: Learn how to test React components using a TDD approach with minimal setup, while learning exactly what to test and how to avoid common pitfalls.
        + **[Getting to Grips with React (as an Angular developer)](https://daveceddia.com/to-react-from-angular/)**: In a series of posts Dave Ceddia tries to help you apply your hard-won knowledge of “Angularisms” to React.
        + **[How to Handle State in React. The Missing FAQ](https://medium.com/react-ecosystem/how-to-handle-state-in-react-6f2d3cd73a0c)**: Osmel Mora challenges the common misconception that you always need a Flux-like architecture in your React apps.
        + **[How we use the Flux architecture in Delve](https://medium.com/@delveeng/how-we-use-the-flux-architecture-in-delve-effc551f8fbc)**: Øystein Hallaråker describes how Delve utilizes the Flux application architecture.
        + **[Immutable Data and React](https://www.youtube.com/watch?v=I7IdS-PbEgI)**: Lee Byron talks about how persistent immutable data structures work, and techniques for using them in a React applications with Immutable.js.
        + **[JSX Transform](https://github.com/alexmingoia/jsx-transform)**: JSX transpiler. A standard and configurable implementation of JSX decoupled from React.
        + **[Jest](https://github.com/facebook/jest)**: A JavaScript unit testing framework, used by Facebook to test services and React applications.
        + **[Model-View-Intent with React and RxJS](https://satishchilukuri.com/blog/entry/model-view-intent-with-react-and-rxjs)**: Satish Chilukuri shows an example implementation of MVI pattern with React.
        + **[Monocle](https://github.com/team-gryff/react-monocle)**: A developer tool for generating visual representations of your React app's component hierarchy.
        + **[Nothing New in React and Flux Except One Thing](http://staltz.com/nothing-new-in-react-and-flux-except-one-thing.html)**: Andre Staltz talks about aspects of React and Flux which make them innovative and compelling.
        + **[Pure UI](http://rauchg.com/2015/pure-ui/)**: Guillermo Rauch discusses the definition of an application’s UI as a pure function of application state.
        + **[React - Basic Theoretical Concepts](https://github.com/reactjs/react-basic)**: Sebastian Markbage attempts to formally explain his mental model of React. The intention is to describe this in terms of deductive reasoning that lead us to this design.
        + **[React App](https://github.com/kriasoft/react-app)**: React App is a small library powered by React, Universal Router and History that handles routing, navigation and rendering logic in isomorphic (universal) and single-page applications.
        + **[React Components, Elements, and Instances](https://medium.com/@dan_abramov/react-components-elements-and-instances-90800811f8ca#.9208ahtfb)**: Dan Abramov explains the Virtual DOM dictionary in React.
        + **[React Demystified](http://blog.reverberate.org/2014/02/react-demystified.html)**: This article is an attempt to explain the core ideas behind React.js and Virtual DOM.
        + **[React Native for Web](https://github.com/necolas/react-native-web)**: This project allows components built upon React Native to be run on the Web, and it manages all component styling out-of-the-box.
        + **[React Starter Kit](https://www.reactstarterkit.com/)**: Isomorphic web app boilerplate including Node.js, Express, GraphQL, React.js, Babel 6, PostCSS, Webpack, Browsersync.
        + **[React Storybook](https://github.com/kadirahq/react-storybook)**: Isolate your React UI Component development from the main app.
        + **[React Workshop](https://github.com/jesstelford/react-workshop)**: This is a self-directed workshop. Follow along to the steps at your own pace, and feel free to ask your instructors questions as you go.
        + **[React in Patterns](https://github.com/krasimir/react-in-patterns)**: List of design patterns/techniques used while developing with React.
        + **[React vs Incremental DOM vs Glimmer](https://auth0.com/blog/2015/11/20/face-off-virtual-dom-vs-incremental-dom-vs-glimmer/)**: In this post we will explore three technologies to build dynamic DOMs. We will also run benchmarks and find out which one is faster.
        + **[React: Rethinking best practices (2013)](https://www.youtube.com/watch?v=x7cQ3mrcKaY)**: A video introduction to React by Pete Hunt.
        + **[ReactPerfTool](https://github.com/RamonGebben/react-perf-tool)**: ReactPerfTool tries to give you a more visual way of debugging performance of your React application. It does this by using the addons delivered by the React team and community to get measurements and visualize this using graphs.
        + **[Removing User Interface Complexity, or Why React is Awesome](http://jlongster.com/Removing-User-Interface-Complexity,-or-Why-React-is-Awesome)**: In this post James Long tries not to evangelize React specifically, but to explain why its technique is profound.
        + **[Rethinking Best Practices](https://www.youtube.com/watch?v=x7cQ3mrcKaY)**: Pete Hunt talks about React's design decisions challenging established best practices.
        + **[Retractor](https://github.com/LiquidLabsGmbH/retractor)**: Retractor exposes the internals of a React application for end-to-end testing purposes. This allows you to select DOM nodes based on the name of the React Component that rendered the node as well as its state or properties.
        + **[Some Problems with React/Redux](http://staltz.com/some-problems-with-react-redux.html)**: André Staltz goes through the pros and cons of React + Redux.
        + **[Taming the React Setup](http://developer.telerik.com/featured/taming-react-setup/)**: Cody Lindley lays out seven React setups in this article and explains the relation of React to BYOA (Bring Your Own Architecture) approach.
        + **[Testing a React & Redux Codebase](http://silvenon.com/testing-react-and-redux/)**: This series aims to be a very comprehensive guide through testing a React and Redux codebase, where you can really cover a lot with just unit tests because the code is mostly universal.
        + **[The Bare Minimum to Work with React](http://krasimirtsonev.com/blog/article/The-bare-minimum-to-work-with-React)**: Krasimir Tsonev describes how to start working with React after installing only 7 dependencies and learning only three commands.
        + **[The Redux Ecosystem](https://medium.com/@denisraslov/the-redux-ecosystem-539c630ec521)**: Let’s take a look at most of the features that you’ll have to deal with when the time comes, — and where React & Redux themselves can’t help you.
        + **[The SoundCloud Client in React + Redux](http://www.robinwieruch.de/the-soundcloud-client-in-react-redux/)**: After finishing this step by step tutorial you will be able to author your own React + Redux project with Webpack and Babel.
        + **[Tutorial: Cloning Yelp](https://www.fullstackreact.com/articles/react-tutorial-cloning-yelp/)**: This post will guide you through building a full React app, even with little to no experience in the framework. We are going to build a Yelp clone in React.
        + **[Using React to Sync Updates and Offline Activity](https://medium.com/@firasd/interface-from-data-using-react-to-sync-updates-and-offline-activity-across-devices-f672b213701c)**: Firas Durri describes how React based architectures make syncing state across devices much easier.
        + **[What Developers Need to Know about MVI (Model-View-Intent)](http://thenewstack.io/developers-need-know-mvi-model-view-intent/)**: The article explains the general MVI pattern and how it relates to React, Reactive Programming and Cycle.js
        + **[Why Did You Update?](https://github.com/garbles/why-did-you-update)**: A function that monkey patches React and notifies you in the console when potentially unnecessary re-renders occur.
        + **[Why did we build React?](http://facebook.github.io/react/blog/2013/06/05/why-react.html)**: Pete Hunt tries to explain why Facebook devs built React in the first place.
    + **[Regenerator](https://github.com/facebook/regenerator)**: This package implements a source transformation that takes the proposed syntax for generators/yield from future versions of JS and spits out efficient JS-of-today (ES5) that behaves the same way.
+ **[Google](https://www.google.com/)**: Google’s mission is to organize the world’s information and make it universally accessible and useful.
    + **[Addy Osmani](https://addyosmani.com/)**: Engineer at Google working on open web tooling.
        + **[Learning JavaScript Design Patterns](https://addyosmani.com/resources/essentialjsdesignpatterns/book/)**: In this free book Addy Osmani explores applying both classical and modern design patterns to the JavaScript programming language.
        + **[Patterns For Large-Scale JavaScript Application Architecture](https://addyosmani.com/largescalejavascript/)**: An extensive overview by Addy Osmani of existing architectural solutions in the frontend development field.
        + **[Writing Modular JavaScript With AMD, CommonJS & ES Harmony](https://addyosmani.com/writing-modular-js/)**: In this article Addy Osmani reviewes several of the options available for writing modular JavaScript using modern module formats AMD, CommonJS and ES6 Modules.
    + **[Closure Compiler](https://developers.google.com/closure/compiler/)**: The Closure Compiler parses your JavaScript, analyzes it, removes dead code and rewrites and minimizes what's left. It also checks syntax, variable references, and types, and warns about common JavaScript pitfalls.
    + **[Introducing Incremental DOM](https://medium.com/google-developers/introducing-incremental-dom-e98f79ce2c5f)**: Incremental DOM is a library inspired by Virtual DOM developed at Google.
+ **[Microsoft](http://www.microsoft.com/)**: Microsoft Corporation is an American multinational technology company, that develops, manufactures, licenses, supports and sells computer software, consumer electronics and personal computers and services.
    + **[Dev Tools by Microsoft](https://developer.microsoft.com/en-us/microsoft-edge/tools/)**: These tools allow you to test your product on different version of Internet Explorer and Microsoft Edge.
    + **[Knockout.js](http://knockoutjs.com/)**: Knockout is a standalone JavaScript implementation of the Model-View-ViewModel pattern with templates.
    + **[Reactive Extensions (RxJS)](https://github.com/Reactive-Extensions/RxJS)**: RxJS is a set of libraries for composing asynchronous and event-based programs using observable sequences and fluent query operators.
        + **[Async JavaScript with Reactive Extensions](https://www.youtube.com/watch?v=XRYN2xt11Ek)**: Jafar Husain explains in this video how Netflix uses the Reactive Extensions (Rx) library to build responsive user experiences that strive to be event-driven, scalable and resilient.
        + **[Exploring Rx Operators: FlatMap](http://blog.thoughtram.io/rx/2016/08/01/exploring-rx-operators-flatmap.html)**: Christoph Burgdorf introduces the FlatMap operator and its usage for collections and observables.
        + **[Exploring Rx Operators: Map](http://blog.thoughtram.io/angular/2016/05/16/exploring-rx-operators-map.html)**: Christoph Burgdorf explains how to use the map operator in RxJS.
        + **[Functional Core Reactive Shell](http://www.mokacoding.com/blog/functional-core-reactive-shell/)**: Giovanni Lodi makes an overview of different architecture meta-patterns and describes his current findings about functional programming and observables as a way to control side effects.
        + **[Learn RX](http://reactivex.io/learnrx/)**: A series of interactive exercises for learning Microsoft's Reactive Extensions (Rx) Library for Javascript.
        + **[Learn RxJS](http://www.learnrxjs.io/)**: This site focuses on making RxJS concepts approachable, the examples clear and easy to explore, and features references throughout to the best RxJS related material on the web.
        + **[Real World Observables](https://medium.com/@sergimansilla/real-world-observables-1f65748c8f9)**: Sergi Mansilla writes an FTP client to use it as an example for a real world application based on RxJS.
        + **[Rx Training Games](https://github.com/JulienMoumne/rx-training-games)**: Rx Training Games is a coding playground that can be used to learn and practice Reactive Extensions coding grid-based games
        + **[Rx-Book](http://xgrommx.github.io/rx-book/index.html)**: A complete book about RxJS v.4.0.
        + **[RxMarbles](http://rxmarbles.com/)**: A webapp for experimenting with diagrams of Rx Observables, for learning purposes.
        + **[RxState](https://www.npmjs.com/package/rxstate)**: Simple opinionated state management library based on RxJS and Immutable.js
        + **[Taking Advantage of Observables in Angular 2](http://blog.thoughtram.io/angular/2016/01/06/taking-advantage-of-observables-in-angular2.html)**: Christoph Burgdorf describes the advantages of Observables and how you can use them in Angular 2 context.
        + **[Transducers with Observable Sequences](https://xgrommx.github.io/rx-book/content/getting_started_with_rxjs/creating_and_querying_observable_sequences/transducers.html)**: A chapter from the RxJS Book describing Transducers.
        + **[Why We Built Xstream](http://staltz.com/why-we-built-xstream.html)**: The authors needed a stream library tailored for Cycle.js. It needs to be “hot” only, small in kB size and it should have only a few and intuitive operators.
    + **[Visual Studio Code](https://code.visualstudio.com/)**: Build and debug modern web and cloud applications. VS Code is free and available on your favorite platform - Linux, Mac OSX, and Windows.
+ **[Mozilla](https://www.mozilla.org/)**: Mozilla is a community, which uses, develops, spreads and supports free software products. It is supported institutionally by the Mozilla Foundation and its tax-paying subsidiary, the Mozilla Corporation.
    + **[Firefox](https://www.mozilla.org/en-US/firefox/products/)**: Firefox is the highly popular free web browser. It is available for Linux, Mac, Windows, handheld devices, and in more than 70 different languages.
    + **[James Long](http://jlongster.com/)**: Works on Firefox Developer Tools at Mozilla.
        + **[A Study on Solving Callbacks with JavaScript Generators](http://jlongster.com/A-Study-on-Solving-Callbacks-with-JavaScript-Generators)**: This article describes how Generators help fight callback hell.
        + **[Removing User Interface Complexity, or Why React is Awesome](http://jlongster.com/Removing-User-Interface-Complexity,-or-Why-React-is-Awesome)**: In this post James Long tries not to evangelize React specifically, but to explain why its technique is profound.
        + **[Transducers.js Library by James Long](https://github.com/jlongster/transducers.js)**: A small library for generalized transformation of data (inspired by Clojure's transducers)
            + **[Transducers.js Round 2 with Benchmarks](http://jlongster.com/Transducers.js-Round-2-with-Benchmarks)**: Refactored version of Transducers.js, some benchmarks, Laziness, the transformer protocoll.
            + **[Transducers.js: A JavaScript Library for Transformation of Data](http://jlongster.com/Transducers.js--A-JavaScript-Library-for-Transformation-of-Data)**: A post announcing the transducers.js library with some explanation.
        + **[Transducers.js Round 2 with Benchmarks](http://jlongster.com/Transducers.js-Round-2-with-Benchmarks)**: Refactored version of Transducers.js, some benchmarks, Laziness, the transformer protocoll.
        + **[Transducers.js: A JavaScript Library for Transformation of Data](http://jlongster.com/Transducers.js--A-JavaScript-Library-for-Transformation-of-Data)**: A post announcing the transducers.js library with some explanation.
    + **[Mozilla Developer Network (MDN)](https://developer.mozilla.org/)**: The MDN is a complete learning platform for Web technologies and the software that powers the Web.
    + **[Nunjucks](http://mozilla.github.io/nunjucks/)**: A rich and powerful templating language for JavaScript.
+ **[Stripe](https://stripe.com/open-source)**: Stripe is an Irish technology company that allows both private individuals and businesses to accept payments over the Internet.
    + **[Alex Sexton](https://alexsexton.com/)**: Alex Sexton is an engineer at Stripe. He is on the Modernizr core team, the  jQuery Board of Directors, as well as the Dojo Foundation Board.
        + **[Modernizr](https://modernizr.com/)**: It’s a collection of superfast tests – or “detects” as we like to call them – which run as your web page loads, then you can use the results to tailor the experience to the user.
    + **[Mikito Takada (mixu)](http://mixu.net/)**: Software engineer at Stripe.
        + **[Learn CSS Layout the pedantic way](http://book.mixu.net/css/)**: Walks you through every major concept in CSS layout, without trying to simplify away the underlying mechanisms described in the CSS 2.1 and flexbox specs.
        + **[Single Page Apps in Depth](http://singlepageappbook.com/)**: This free book is what I wanted when I started working with single page apps. It's not an API reference on a particular framework, rather, the focus is on discussing patterns, implementation choices and decent practices.
    + **[jquery.mobilePhoneNumber](https://github.com/stripe/jquery.mobilePhoneNumber)**: A general purpose library for validating and formatting mobile phone numbers.
    + **[jquery.payment](https://github.com/stripe/jquery.payment)**: A general purpose library for building credit card forms, validating inputs and formatting numbers.
+ **[TODO Group](http://todogroup.org/)**: TODO is an open group of companies who want to collaborate on practices, tools, and other ways to run successful and effective open source projects and programs.
+ **[Twitter](https://twitter.com/)**: Twitter is an online social networking service that enables users to send and read short 140-character messages called "tweets".
    + **[Flight](http://flightjs.github.io/)**: An event-driven web framework, from Twitter.
    + **[Hogan.js](http://twitter.github.io/hogan.js/)**: Hogan.js is a 3.4k JS templating engine developed at Twitter. It was developed against the mustache test suite.
    + **[Nicolas Gallagher](http://nicolasgallagher.com/)**: Frontend Engineer at Twitter.
        + **[Normalize.css](http://necolas.github.io/normalize.css/)**: A modern, HTML5-ready alternative to CSS resets.
+ **[World Wide Web Consortium (W3C)](https://www.w3.org/)**: The W3C is an international community where Member organizations, a full-time staff, and the public work together to develop Web standards.
    + **[Architecture of the World Wide Web: Identification](https://www.w3.org/TR/webarch/#identification)**: This architecture document by W3C discusses the core design components of the Web. They are identification of resources, representation of resource state, and the protocols that support the interaction between agents and resources in the space.
    + **[CSS Flexible Box Layout Module Level 1](https://www.w3.org/TR/css-flexbox-1/)**: W3C specification for CSS flexbox.
    + **[Document Object Model (DOM) Technical Reports](https://www.w3.org/DOM/DOMTR)**: Specifications by the W3C.
    + **[Notes on Using ARIA in HTML](http://w3c.github.io/aria-in-html/)**: This document is a practical guide for developers on how to add accessibility information to HTML elements using the Accessible Rich Internet Applications specification.
    + **[Service Workers](https://www.w3.org/TR/service-workers/)**: A method that enables applications to take advantage of persistent background processing, including hooks to enable bootstrapping of web applications while offline.
        + **[Instant Loading Web Apps With An Application Shell Architecture](https://medium.com/google-developers/instant-loading-web-apps-with-an-application-shell-architecture-7c0c2f10c73)**: Addy Osmani describes how to leverage the Service Worker API to drastically improve the loading speed of your web application.
        + **[Introduction to Service Worker](http://www.html5rocks.com/en/tutorials/service-worker/introduction/)**: Matt Gaunt introduces the main features of Service Worker API in this article.
        + **[Is ServiceWorker Ready?](https://jakearchibald.github.io/isserviceworkerready/)**: Tracks the implementation status across the main browsers.
    + **[Shadow DOM W3C Editor's Draft](http://w3c.github.io/webcomponents/spec/shadow/)**: This specification describes a method of combining multiple DOM trees into one hierarchy and how these trees interact with each other within a document, thus enabling better composition of the DOM.
+ **[Yandex](https://www.yandex.com/)**: Yandex is one of the largest internet companies in Europe, operating Russia’s most popular search engine and its most visited website.
    + **[Block Element Modifier (BEM)](https://en.bem.info/method/)**: Methodology aimed at achieving fast to develop long-lived projects, team scalability, and code reuse.
        + **[A New Front-End Methodology: BEM](http://www.smashingmagazine.com/2012/04/a-new-front-end-methodology-bem/)**: An introduction by Varvara Stepanova at SmashingMagazine.
        + **[An Introduction to the BEM Methodology](http://webdesign.tutsplus.com/articles/an-introduction-to-the-bem-methodology--cms-19403)**: General introduction article on tutsplus.
        + **[BEM 101](https://css-tricks.com/bem-101/)**: A collaborative post by Joe Richardson, Robin Rendle, and CSS-Tricks staff giving an introduction to BEM with some good examples.
        + **[BEM I (finally) understand](https://m.alphasights.com/bem-i-finally-understand-b0c74815d5b0)**: In this article Andrei Popa will focus on the basics of BEM and how to approach simple to complex anatomies.
        + **[Battling BEM (Extended Edition): 10 Common Problems And How To Avoid Them](https://www.smashingmagazine.com/2016/06/battling-bem-extended-edition-common-problems-and-how-to-avoid-them/)**: This article aims to be useful for people who are already BEM enthusiasts and wish to use it more effectively or people who are curious to learn more about it.
        + **[Block, Element, Modifying Your JavaScript Components](https://medium.com/seek-ui-engineering/block-element-modifying-your-javascript-components-d7f99fcab52b)**: Mark Dalgleish is discussing how to organize React code with BEM and build everything with Webpack.
        + **[Emmet filter for BEM](http://docs.emmet.io/filters/bem/)**: If you’re writing your HTML and CSS code in OOCSS-style, Yandex’s BEM style specifically, you will like this filter. It provides some aliases and automatic insertions of common block and element names in classes.
        + **[Fifty Shades of BEM](http://blog.kaelig.fr/post/48196348743/fifty-shades-of-bem)**: Article describes different flavors of BEM.
        + **[How We Use BEM to Modularise Our CSS](https://m.alphasights.com/how-we-use-bem-to-modularise-our-css-82a0c39463b0)**: Andrei Popa describes the challenges, AlphaSights team had, implementing BEM in their projects.
        + **[Introduction To BEM Methodology (Toptal)](https://www.toptal.com/css/introduction-to-bem-methodology)**: General introduction to BEM methodology and platform.
        + **[MindBEMding – getting your head ’round BEM syntax](http://csswizardry.com/2013/01/mindbemding-getting-your-head-round-bem-syntax/)**: Article on csswizardry explaining the BEM syntax for CSS classes.
        + **[Pobem](https://github.com/bem-contrib/pobem)**: PostCSS plugin for BEM syntax.
        + **[Support for BEM modules in Sass 3.3](http://mikefowler.me/2013/10/17/support-for-bem-modules-sass-3.3/)**: The next major release of Sass is poised for release and with it comes real support for BEM-style modules...
        + **[To BEM or not to BEM](http://www.didoo.net/to-bem-or-not-to-bem/)**: A series of interviews on BEM methodology.
    + **[Yandex Browser](https://browser.yandex.com/)**: Chromium based browser developed by Yandex.
+ **[Zurb](http://zurb.com/)**: ZURB is a product design company since 1998. Through consulting, product design tools and training, they transform the way businesses approach Progressive Design.
    + **[Foundation](http://foundation.zurb.com/)**: Foundation provides a responsive grid and HTML and CSS UI components, templates, and code snippets, including typography, forms, buttons, navigation and other interface components, as well as optional JavaScript extensions.
    + **[Foundation for Emails 2](http://foundation.zurb.com/emails.html)**: Frontend Framework for E-Mails including a grid, global styles, aligment classes, buttons, callout panels, thumbnail styles, typography, visibility classes.
    + **[Responsive Email Templates](http://zurb.com/playground/responsive-email-templates)**: Zurb Studios put together this set of super awesome email templates so that you can make your email campaigns responsive.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.