# Cascading Style Sheets (CSS)

**Context: [frontend-dev-bookmarks](../README.md) / Languages, Protocols, Browser APIs**

CSS are a stylesheet language used to describe the presentation of a document written in HTML or XML. It describes how elements should be rendered on screen, on paper, in speech, or on other media.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **CSS Coding Conventions**: Coding conventions are a set of guidelines for a specific programming language that recommend programming style, practices and methods for each aspect of a piece program written in this language.
    + **[CSS Guidelines](http://cssguidelin.es/)**: High-level advice and guidelines for writing sane, manageable, scalable CSS.
    + **[Idiomatic CSS](https://github.com/necolas/idiomatic-css)**: The following document outlines a reasonable style guide for CSS development. These guidelines strongly encourage the use of existing, common, sensible patterns.
    + **[Maintainable CSS](http://maintainablecss.com/)**: MaintainableCSS is an approach to writing modular, scalable and of course, maintainable CSS.
    + **[Primer](http://primercss.io/)**: Primer is GitHub’s internal CSS framework. It includes basic global styling for typography, small components like buttons and tabs, and our general guidelines for writing HTML and CSS.
    + **[Wordpress CSS Coding Standards](https://make.wordpress.org/core/handbook/best-practices/coding-standards/css/)**: The purpose of the WordPress CSS Coding Standards is to create a baseline for collaboration and review within various aspects of the WordPress open source project and community, from core code to themes to plugins.
+ **[CSS Variables W3C Editor's Draft](https://drafts.csswg.org/css-variables/)**: This module introduces cascading variables as a new primitive value type that is accepted by all CSS properties, and custom properties for defining them.
+ **Flexbox**: The Flexbox Layout officially called CSS Flexible Box Layout Module is new layout module in CSS3 made to improve the items align, directions and order in the container even when they are with dynamic or even unknown size.
    + **[5 Flexbox Techniques You Need to Know About](http://tutorialzine.com/2016/04/5-flexbox-techniques-you-need-to-know-about/)**: In this article we’re going to take a look at five flexbox approaches to solving common CSS layout problems. We’ve also included practical examples to showcase real life scenarios in which these techniques are applied.
    + **[A Complete Guide to Flexbox](https://css-tricks.com/snippets/css/a-guide-to-flexbox/)**: Chris Coyer provides a great reference to the flexbox features with code examples.
    + **[A Visual Guide to CSS3 Flexbox Properties](https://scotch.io/tutorials/a-visual-guide-to-css3-flexbox-properties)**: Rather that explaining how the flex properties work, this guide will focus on how the flex properties affect the layout in a visual way.
    + **[CSS Flexible Box Layout Module Level 1](https://www.w3.org/TR/css-flexbox-1/)**: W3C specification for CSS flexbox.
    + **[Flex-Grow is weird. Or is it?](https://css-tricks.com/flex-grow-is-weird/)**: Manuel Matuzovic describes how flex-grow works, including it's weird quirks. Then he goes into several examples on how common layout patterns may be implemented using flex-grow and flex-basis.
    + **[Flexbox Froggy](http://flexboxfroggy.com/)**: A fun way to learn Flexbox by playing a game where you help Froggy and friends to arrive at a lilypad.
    + **[Flexbox Patterns](http://www.flexboxpatterns.com/)**: These interactive examples will show you practical ways to use Flexbox to build UI components.
    + **[Flexbugs](https://github.com/philipwalton/flexbugs)**: This repository is a community-curated list of flexbox issues and cross-browser workarounds for them.
+ **[How To Center in CSS](http://howtocenterincss.com/)**: This tool consolidates the many ways of centering a div and gives you the code you need for each situation.
+ **[The Complete Guide to Centering a DIV](http://www.tipue.com/blog/center-a-div/)**: The aim of this article is to show how, with a few CSS tricks, any div can be centered; horizontally, vertically or both. And within the page or a div.
+ **[Understanding border-image](https://css-tricks.com/understanding-border-image/)**: The new CSS3 property border-image can allow you to create flexible boxes with custom borders with a single div and a single image.
+ **[What No One Told You About Z-Index](http://philipwalton.com/articles/what-no-one-told-you-about-z-index/)**: The problem with z-index is that it’s not complicated, but it if you’ve never taken the time to read its specification, there are almost certainly crucial aspects that you’re completely unaware of.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.