# Document Object Model (DOM)

**Context: [frontend-dev-bookmarks](../README.md) / Languages, Protocols, Browser APIs**

The DOM is a programming interface for HTML, XML and SVG documents. It defines methods that allow access to the tree, so that they can change the document structure, style and content.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **Document Events**: DOM event model is a generic event system and a set of standard modules of events for user interface control and document mutation notifications
    + **[An Introduction To DOM Events](https://www.smashingmagazine.com/2013/11/an-introduction-to-dom-events/)**: Wilson Page introduces the basics of working with DOM events, then delves into their inner workings, explaining how we can make use of them to solve common problems.
    + **[DOM Level 2 Event Model](https://www.w3.org/TR/DOM-Level-2-Events/events.html)**: W3C specification section for DOM Level 2 Events.
    + **[Gator](https://craig.is/riding/gators)**: Gator is a small (~0.8 kb minified + gzipped), simple, standalone, event delegation library.
+ **Overview**: High level guides, articles and documents about DOM.
    + **[DOM Features You Didn’t Know Existed](http://www.impressivewebs.com/dom-features-you-didnt-know-existed-video-slides/)**: Louis Lazaris talks about DOM Features you probably don't know.
    + **[DOM Reference at the MDN](https://developer.mozilla.org/en-US/docs/Web/API/Document_Object_Model)**: Complete reference of the DOM provided by the Mozilla Development Network.
    + **[Document Object Model (DOM) Technical Reports](https://www.w3.org/DOM/DOMTR)**: Specifications by the W3C.
    + **[Introduction to the DOM](https://developer.mozilla.org/en-US/docs/Web/API/Document_Object_Model/Introduction)**: This section provides a brief conceptual introduction to the DOM: what it is, how it provides structure for HTML and XML documents, how you can access it, and how this API presents the reference information and examples.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.