# HyperText Markup Language (HTML)

**Context: [frontend-dev-bookmarks](../README.md) / Languages, Protocols, Browser APIs**

HTML is the standard markup language used to create web pages and its elements form the building blocks of all websites.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **[Dive Into HTML5 (Book)](http://diveintohtml5.info/)**: Dive Into HTML5 elaborates on a hand-picked selection of features from the HTML5 specification and other fine standards.
+ **[Google HTML/CSS Style Guide](https://google.github.io/styleguide/htmlcssguide.xml)**: This document defines formatting and style rules for HTML and CSS. It aims at improving collaboration, code quality, and enabling supporting infrastructure.
+ **[HEAD](https://github.com/joshbuchea/HEAD)**: A list of everything that could go in the <head> of your document.
+ **[Idiomatic HTML](https://github.com/necolas/idiomatic-html)**: The following document outlines a reasonable style guide for HTML development. These guidelines strongly encourage the use of existing, common, sensible patterns. They should be adapted as needed to create your own style guide.
+ **Video & Audio**: Use the  HTML video and audio element to embed video content in a document.
    + **[Bringing Production Video To The Web](https://www.smashingmagazine.com/2016/04/html5-media-source-extensions-bringing-production-video-web/)**: Stefan Lederer gives you a good overview of the state and future of video on the web.
+ **[Wordpress HTML Coding Standards](https://make.wordpress.org/core/handbook/best-practices/coding-standards/html/)**: Coding conventions for WordPress.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.