# Templating Languages and Engines

**Context: [frontend-dev-bookmarks](../README.md) / Languages, Protocols, Browser APIs**

Template engines are tools to separate program-logic and presentation into two independent parts. This makes the development of both logic and presentation easier, improves flexibility and eases modification and maintenance.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **[Dot.js](http://olado.github.io/doT/)**: The fastest + concise javascript template engine for Node.js and browsers.
+ **[Dust.js by LinkedIn](http://www.dustjs.com/)**: Dust is a Javascript templating engine. It inherits its look from the ctemplate family of languages, and is designed to run asynchronously on both the server and the browser.
+ **[Dōmo](http://jed.github.io/domo/)**: dōmo lets you write HTML markup and CSS styles in JavaScript syntax. It is a simpler and easier alternative to template engines and CSS pre-processors.
+ **[HyperScript](https://github.com/dominictarr/hyperscript)**: Create HyperText with JavaScript, on client or server.
+ **[Marko](https://github.com/marko-js/marko)**: Marko is a really fast and lightweight HTML-based templating engine from eBay. Marko runs on Node.js and in the browser and it supports streaming, async rendering and custom tags.
+ **[Mustache](http://mustache.github.io/)**: Mustache is a Logic-less template language. There are no if statements, else clauses, or for loops. Instead there are only tags.
    + **[Handlebars.js](https://github.com/wycats/handlebars.js/)**: Handlebars.js is an extension to the Mustache templating language. Handlebars.js and Mustache are both logicless templating languages that keep the view and the code separated like we all know they should be.
    + **[Hogan.js](http://twitter.github.io/hogan.js/)**: Hogan.js is a 3.4k JS templating engine developed at Twitter. It was developed against the mustache test suite.
    + **[Mustache Specification](http://mustache.github.io/mustache.5.html)**: This document explains the different types of Mustache tags.
    + **[Walrus](http://documentup.com/jeremyruppel/walrus/)**: Walrus is a templating library inspired by mustache, handlebars, ejs and friends,
but with a couple of important differences in philosophy and style.
    + **[mustache.js](https://github.com/janl/mustache.js)**: mustache.js is an implementation of the mustache template system in JavaScript.
    + **[templayed.js](http://archan937.github.io/templayed.js/)**: The fastest and smallest Mustache compliant Javascript templating library written in 1806 bytes.
+ **[Nunjucks](http://mozilla.github.io/nunjucks/)**: A rich and powerful templating language for JavaScript.
+ **[Pithy](https://github.com/caolan/pithy)**: An internal DSL for generating HTML in JavaScript.
+ **[T](https://github.com/gcao/T.js)**: T.js is a template engine that uses simple Javascript data structure to represent html/xml data.
+ **[Template7](http://idangero.us/template7/)**: Template7 is a mobile-first JavaScript template engine with Handlebars-like syntax. It is used as default template engine in Framework7.
+ **[Transparency](http://leonidas.github.io/transparency/)**: Transparency is a minimal template engine for jQuery. It maps JSON objects to DOM elements with zero configuration.
+ **[Weld](https://github.com/tmpvar/weld)**: Weld binds data to markup, and can generate markup based on your data. There's no special syntax or data reshaping required.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.