# Transpiled Languages

**Context: [frontend-dev-bookmarks](../README.md) / Languages, Protocols, Browser APIs**

Abstract languages converted to native, browser supported standards like JavaScript or CSS.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **[ClojureScript](https://github.com/clojure/clojurescript)**: ClojureScript is a compiler for Clojure that targets JavaScript. It is designed to emit JavaScript code which is compatible with the advanced compilation mode of the Google Closure optimizing compiler.
+ **[Dart](https://www.dartlang.org/)**: Dart is an open-source, scalable programming language, with robust libraries and runtimes, for building web, server, and mobile apps compiled to JavaScript
+ **[Elm](http://elm-lang.org/)**: Elm is a functional programming language for declaratively creating web browser-based graphical user interfaces.
    + **[The Elm Architecture](http://guide.elm-lang.org/architecture/index.html)**: The Elm Architecture is a simple pattern for infinitely nestable components. It is great for modularity, code reuse, and testing.
+ **[Less](http://lesscss.org/)**: Less is a CSS pre-processor, meaning that it extends the CSS language, adding features that allow variables, mixins, functions and many other techniques that allow you to make CSS that is more maintainable, themable and extendable.
+ **[PureScript](http://www.purescript.org/)**: PureScript is a strongly, statically typed language which compiles to JavaScript. It is written in and inspired by Haskell.
+ **[Sass](http://sass-lang.com/)**: Sass is an extension of CSS, adding nested rules, variables, mixins, selector inheritance, and more. It's translated to well-formatted, standard CSS using the command line tool or a web-framework plugin.
+ **[Scala.js](http://www.scala-js.org/)**: A Scala to JavaScript compiler.
+ **[Stylus](http://stylus-lang.com/)**: Stylus is a revolutionary new language, providing an efficient, dynamic, and expressive way to generate CSS. Supporting both an indented syntax and regular CSS style.
+ **[TypeScript](https://www.typescriptlang.org/)**: A typed superset of JavaScript that compiles to plain JavaScript. Popular in the Angular and Microsoft community.
    + **[Angular 2: Why TypeScript?](https://vsavkin.com/writing-angular-2-in-typescript-1fa77c78d8e8)**: Angular 2 is written in TypeScript. In this article Victor Savkin talks about why they made the decision.
    + **[InversifyJS](https://github.com/inversify/InversifyJS)**: A powerful and lightweight inversion of control container for JavaScript & Node.js apps powered by TypeScript.
    + **[Safety in the Absence of Types](https://vsavkin.com/typescript-how-to-be-safe-even-if-you-cannot-type-it-31eb08485fe6)**: Victor Savking talks about the limitation of TypeScript's static type checker and how to mitigate them.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.