# Forms

**Context: [frontend-dev-bookmarks](../README.md) / User Interface Components**

A HTML form on a web page allows a user to enter data that is sent to a server for processing. Web users fill out the forms using checkboxes, radio buttons, or text fields.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **[ALAJAX](https://github.com/alaabadran/ALAJAX)**: A jQuery plugin to convert normal HTML forms into AJAX forms simply. It Ajaxifys your HTML Form with this plugin. No change will be required on Server-Side.
+ **[Fields.js](http://schneiderik.github.io/fields/)**: An abstract way of interacting with fields. Fields.js creates collections of fields. Each field is constantly evaluated for validity, and is accessible through the collection.
+ **[Grid Forms](http://kumailht.com/gridforms/)**: A tiny Javascript/CSS framework that helps you make forms on grids with ease.
+ **[HTML5Forms.js](https://github.com/zoltan-dulac/html5Forms.js)**: HTML5Forms.js is a JavaScript polyfill that implements a subset of the HTML5 Forms module in all browsers. The script will only add support for the different parts of the module when there doesn't exist a native implementation.
+ **[Ladda](https://github.com/hakimel/Ladda)**: Buttons with built-in loading indicators.
+ **[Native form elements](http://nativeformelements.com/)**: This is what every HTML5 form element looks like on your current operating system and browser.
+ **[Redux Form](https://github.com/erikras/redux-form)**: A Higher Order Component using react-redux to keep form state in a Redux store.
+ **Serializers**: Libraries for collecting form data in JavaScript.
    + **[form2js](https://github.com/maxatwork/form2js)**: Convenient way to collect structured form data into JavaScript object.
    + **[jQuery.serializeObject](https://github.com/hongymagic/jQuery.serializeObject)**: Encode a set of form elements as a JSON object for manipulation/submission.
    + **[jquery-serialize-object](https://github.com/macek/jquery-serialize-object)**: Adds the method serializeObject to jQuery, to perform complex form serialization into JavaScript objects.
    + **[jquery.serializeJSON](https://github.com/danheberden/jquery-serializeForm)**: Make an object out of form elements.
    + **[serializeForm](https://github.com/danheberden/jquery-serializeForm)**: jQuery plugin to serialize form elements into an object.
+ **Validation**: A form validation behavior checks data against a set of criteria before passing it along to the server.
    + **[Form Validation UX in HTML and CSS](https://css-tricks.com/form-validation-ux-html-css/)**: Chris Coyier describes how to implement form validation with just HTML attributes and some CSS trickery.
    + **[Mailcheck.js](https://github.com/mailcheck/mailcheck)**: The Javascript library and jQuery plugin that suggests a right domain when your users misspell it in an email address.
    + **[One Validation](https://github.com/One-com/one-validation)**: This is a collection of regular expressions for general validation purposes. The basic design concept is to split up the regexes into semantic parts of the pattern to match.
    + **[Parsley](https://github.com/guillaumepotier/Parsley.js)**: JavaScript form validation, without actually writing a single line of JavaScript!
+ **[jQuery Super Labels Plugin](https://github.com/remybach/jQuery.superLabels)**: This plugin was born out of the need to use the label-over-field method for forms.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.