# Rich Text Editors

**Context: [frontend-dev-bookmarks](../README.md) / User Interface Components**

A rich text editor is the interface for editing rich text within web browsers. The aim is to reduce the effort for users trying to express their formatting directly as valid HTML markup.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **Content Sanitizers**: Rich text editors often produce unclean input when you copy & paste some content into them. Content sanitizers help you clean up the text.
    + **[FilteredPaste.js](http://willemmulder.github.io/FilteredPaste.js/)**: A jQuery plugin that filters any pasted input so that your application gets clean input, without any tags or attributes that you don't want.
    + **[Sanitize.js](https://github.com/gbirke/sanitize.js)**: Sanitize.js is a whitelist-based HTML sanitizer. Given a list of acceptable elements and attributes, Sanitize.js will remove all unacceptable HTML from a DOM node.
    + **[html-janitor](https://github.com/guardian/html-janitor)**: Cleans up your markup and allows you to take control of your HTML. HTMLJanitor uses a defined whitelist to limit HTML it is given to a defined subset.
+ **[Create.js](http://createjs.org/)**: Create.js is a comprehensive web editing interface for Content Management Systems. It is designed to provide a modern, fully browser-based HTML5 environment for managing content
+ **[Demarcate](http://will-hart.github.io/demarcate.js/)**: demarcate.js lets you edit directly in a page and generate Markdown back from the HTML elements.
+ **[Hallo](http://hallojs.org/)**: Hallo is the simplest web editor imaginable. Instead of cluttered forms or toolbars, you edit your web content as it is. Just you, your web design, and your content.
+ **Inspired by Medium**: Medium.com has a great and simple rich text editor built in. This libraries try to clone its behavior.
    + **[Medium.js](https://github.com/jakiestfu/Medium.js)**: A tiny JavaScript library for making contenteditable beautiful (Like Medium's editor)
    + **[Pen](http://sofish.github.io/pen/)**: Rich text editor inspired by Medium and backed by Markdown.
    + **[grande.js](https://github.com/mduvall/grande.js)**: A small Javascript library that implements features from Medium's editing experience.
    + **[medium-editor](https://github.com/yabwe/medium-editor)**: Medium.com WYSIWYG editor clone. Uses contenteditable API to implement a rich text solution.
+ **[Kajero](https://github.com/JoelOtter/kajero)**: Interactive JavaScript notebooks with markdown support and clever graphing.
+ **[MarkItUp](http://markitup.jaysalvat.com/)**: markItUp! is a JavaScript plugin built on the jQuery library. It allows you to turn any textarea into a markup editor.
+ **[Mercury Editor](http://jejacks0n.github.io/mercury/)**: Mercury is a full featured HTML5 editor. It was built from the ground up to help your team get the most out of content editing in modern browsers.
+ **[Quill](https://github.com/quilljs/quill/)**: Quill is a modern rich text editor built for compatibility and extensibility. It was created by Jason Chen and Byron Milligan and open sourced by Salesforce.com.
+ **[Scribe](https://github.com/guardian/scribe)**: A rich text editor framework for the web platform, with patches for browser inconsistencies and sensible defaults. Developed by The Guardian.
    + **[Inside the Guardian’s CMS: meet Scribe, an extensible rich text editor](https://www.theguardian.com/info/developer-blog/2014/mar/20/inside-the-guardians-cms-meet-scribe-an-extensible-rich-text-editor)**: The team behind the Guardian’s digital content management system talk about how and why they built and open sourced Scribe.
+ **[Substance](http://substance.io/)**: Substance is a JavaScript library for web-based content editing. It provides building blocks for realizing custom text editors and web-based publishing systems.
    + **[Build your own editor with Substance](https://medium.com/@_mql/build-your-own-editor-with-substance-7790eb600109)**: This article describes the philosophy behind Substance and how to get started.
+ **[TextAngular](http://textangular.com/)**: A Lightweight, Two-Way-Bound Angular.js Text-Editor.
+ **[WYSIHTML5](http://xing.github.io/wysihtml5/)**: wysihtml5 is an open source rich text editor based on HTML5 technology and the progressive-enhancement approach. It aims to generate fully valid HTML5 markup by preventing unmaintainable tag soups and inline styles.
    + **[Voog fork](https://github.com/Voog/wysihtml)**: wysihtml is an extended and less strict approach on xing/wysihtml5 open source rich text editor based on HTML5 technology. The code is completely library agnostic: No jQuery, Prototype or similar is required.
    + **[WYSIHTML5 Enhanced](https://github.com/zohararad/wysihtml5n)**: WYSIHTML5 Enhanced is a rich-text editor, based on the wonderful wysihtml5 editor, with a bit of help from Twitter Bootstrap, Font-Awesome, Jcrop and HTML5's Drag & Drop and File API.
    + **[bootstrap3-wysiwyg](https://github.com/bootstrap-wysiwyg/bootstrap3-wysiwyg)**: Bootstrap-wysihtml5 is a javascript plugin that makes it easy to create simple, beautiful wysiwyg editors with the help of wysihtml5 and Twitter Bootstrap.
+ **[X-editable](http://vitalets.github.io/x-editable/)**: This library allows you to create editable elements on your page. It can be used with any engine (bootstrap, jquery-ui, jquery only) and includes both popup and inline modes.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.