# CSS Tools

**Context: [frontend-dev-bookmarks](../README.md) / Workflow**

Tools for analysis, pre and post processing of CSS files.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)

-----------------------------------------
+ **[CSS Pack](https://www.npmjs.com/package/css-pack)**: Packs CSS dependency graphs produced from dgraph or module-deps into a single CSS bundle, assuming every node in the graph contains CSS source and the graph itself is sorted with deps-sort
+ **[CSS Stringify](https://github.com/reworkcss/css-stringify)**: CSS stringifier using the AST from 'css.parse'
+ **[CSSCSS](http://zmoazeni.github.io/csscss/)**: A CSS redundancy analyzer that analyzes redundancy.
+ **[Clean CSS](https://www.npmjs.com/package/clean-css)**: Clean-css is a fast and efficient Node.js library for minifying CSS files.
+ **[Helium CSS](https://github.com/geuis/helium-css)**: Helium is a tool for discovering unused CSS across many pages on a web site.
+ **[PostCSS](http://postcss.org/)**: PostCSS parses CSS into an abstract syntax tree (AST), passes it through a series of plugins, and then concatenates back into a string.
    + **[An Introduction to PostCSS](https://www.sitepoint.com/an-introduction-to-postcss/)**: This article describes what PostCSS is and how to get started.
    + **[ES CSS Modules](https://github.com/jacobp100/es-css-modules)**: PostCSS plugin that combines CSS Modules and ES Imports.
    + **[Improving the Quality of Your CSS with PostCSS](https://www.sitepoint.com/improving-the-quality-of-your-css-with-postcss/)**: In this article, we will explore how we can utilise PostCSS to help us maintain a higher quality in our CSS code.
    + **[React Starter Kit](https://www.reactstarterkit.com/)**: Isomorphic web app boilerplate including Node.js, Express, GraphQL, React.js, Babel 6, PostCSS, Webpack, Browsersync.
    + **[Working with Images in Stylesheets](https://css-tricks.com/images-in-postcss/)**: Aleks Hudochenkov does a great job of showcasing what PostCSS is good at and the role it has grown into in the front end stack.
+ **[Stylelint](http://stylelint.io/)**: Stylelint's ambitious goal is to supplement our discipline with automatic enforcement — to provide a core set of rules and a pluggable framework that CSS authors can use to enforce their own strategies.
    + **[Lint your CSS with Stylelint](https://css-tricks.com/stylelint/)**: David Clark writes about reasons for using a CSS linter and advantages of Stylelint.


------------------

# License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

Please provide a link back to this repository. This is not necessary for GitHub forks.