# Contribution

Thank you for contributing to make this list of awesome board games even more awesome! You will need to [edit the readme file][readme-edit-link], following the guidelines below. Then you'll create a Pull Request and, once accepted, it will become a part of the list here for all to enjoy.

Guidelines:

- This project is released with a [Contributor Code of Conduct](code-of-conduct.md). By participating in this project you agree to abide by its terms.
- A pull request should have a useful title. Pull requests with `Update readme.md` as the title are **strongly frowned upon**. Please carefully read everything in this file and stick to the [formatting guide][formatting-guide].
- Keep to a single game addition per Pull Request.
- If you need help getting started, how to add to the list, create a commit, or update a pull request, check out the [help guide][help-guide].

## Seasonal Note for Hacktoberfest / October Submissions

This project has been a proud participant of [Hacktoberfest](https://hacktoberfest.com/) annually since 2018. While participation has generally trended upward in quantity over each year, this year (2023) has seen a significant increase in contributions. I'm all for eager contributors, but the remaining manual aspects of PR review adds up in time spent on reviewing. To help keep things manageable, I ask that you:

- take your time reading this doc and any announcement issue I've opened for the year; for this year 2023 that issue is [#269](https://github.com/edm00se/awesome-board-games/issues/269)
- please leave a link in your PR back to that year's welcome issue, in a PR description or comment just add `#269` at the bottom and it will link automatically
- if you have questions, reach out, either in your Pull Request or in that year's welcome issue
- please limit yourself to no more than a handful of active Pull Requests (during October, limit to 5 overall, but no more than 2 open at once), this makes it easier not just on me, but also my current free Vercel plan, which does automated preview builds of the submissions to aid in my review

These updates are not meant for anything beyond helping this project deal with its increased popularity this year. Thank you for being a part of it.

<!--
  - 2023: #269
  - 2022: #230
  - 2021: #176
  - 2020: #131
  - 2019: #55
  - 2018: #10
-->

## Adding to This List

Note: if this all seems complicated, it shouldn't. Go check out the [example source block for a game][example-game-block] in the [formatting guide][formatting-guide] and it should clear things up. Please keep game additions in separate pull requests.

For specifics, please ensure your pull request adheres to the following guidelines:

- Search previous suggestions before making a new one, as yours may be a duplicate.
- Make an individual pull request for each suggestion.
- Use [title-casing](https://en.wikipedia.org/wiki/Capitalization#Title_case) (AP style).
- Use the format outlined in the [formatting guide][formatting-guide].
- New categories or improvements to the existing categorization are welcome.
- Check your spelling and grammar.
- The pull request and commit should have a useful title. Such as "adding &lt;game name&gt;" or "fix to &lt;game name&gt;".

Thank you for your suggestions!

[everything-is-awesome]: assets/images/everything-is-awesome.jpg
[awesome-list-src]: https://github.com/sindresorhus/awesome
[formatting-guide]: formatting.md
[help-guide]: help.md
[example-game-block]: https://github.com/edm00se/awesome-board-games/blob/main/formatting.md#example
[readme-edit-link]: https://github.com/edm00se/awesome-board-games/edit/main/readme.md
