These guidelines have been adapted from [awesome CONTRIBUTING](https://github.com/sindresorhus/awesome/blob/master/contributing.md) and the [awesome manifesto](https://github.com/sindresorhus/awesome/blob/master/awesome.md).

# Contribution Guidelines

## Table of Contents

- [Adding to this list](#adding-to-this-list)
- [Only awesome is awesome](#only-awesome-is-awesome)
- [Comment on why something is awesome](#comment-on-why-something-is-awesome)
- [Guidelines](#guidelines)

## Adding to this list

If you want something to be included on `awesome-LaTeX`, try to only add actual awesome stuff in your pull requests. After all, it's a curation, not a collection.

But **what is awesome?**

## Only awesome is awesome

Research if the stuff you're including is actually awesome. Put only stuff on the list you can personally recommend and rather leave stuff out than include too much.

## Comment on why something is awesome

Apart from suggesting a particular item, you should also inform your readers *why* it's on the list and how they will benefit from it.

## Guidelines

Please ensure your pull request adheres to the following guidelines:

- Search previous suggestions before making a new one, as yours may be a duplicate.
- Please only add/remove one (1) item per commit.
- Please ensure your items are formatted consistently with the rest, e.g. as  `[List Name](link) - description.`
- Link additions should be added to the bottom of the relevant category.
- New categories or improvements to the existing categorization are welcome.
- Please update the table of contents as needed.
- Check your spelling and grammar.
- Make sure your text editor is set to remove trailing whitespace.
- Self-promotion can be okay, but _only_ if you clearly state your involvement.
- The pull request and commit should have a useful title.

Finally, **thank you for your suggestions!**
