<style>
.promo li a {
    float: left;
    width: 130px;
    height: 20px;
    text-align: center;
    margin: 10px 30px;
    padding: 150px 0 0 0;
    background-position: 0 50%;
    background-size: 130px auto;
    background-repeat: no-repeat;
    font-size: 120%;
    color: black;
}
.promo li {
    list-style: none;
}
</style>

# Django REST framework 3.12

REST framework 3.12 brings a handful of refinements to the OpenAPI schema
generation, plus support for Django's new database-agnostic `JSONField`,
and some improvements to the `SearchFilter` class.

## Grouping operations with tags.

Open API schemas will now automatically include tags, based on the first element
in the URL path.

For example...

Method                          | Path            | Tags
--------------------------------|-----------------|-------------
`GET`, `PUT`, `PATCH`, `DELETE` | `/users/{id}/`  | `['users']`
`GET`, `POST`                   | `/users/`       | `['users']`
`GET`, `PUT`, `PATCH`, `DELETE` | `/orders/{id}/` | `['orders']`
`GET`, `POST`                   | `/orders/`      | `['orders']`

The tags used for a particular view may also be overridden...

```python
class MyOrders(APIView):
    schema = AutoSchema(tags=["users", "orders"])
    ...
```

See [the schema documentation](https://www.django-rest-framework.org/api-guide/schemas/#grouping-operations-with-tags) for more information.

## Customizing the operation ID.

REST framework automatically determines operation IDs to use in OpenAPI
schemas. The latest version provides more control for overriding the behavior
used to generate the operation IDs.

See [the schema documentation](https://www.django-rest-framework.org/api-guide/schemas/#operationid) for more information.

## Support for OpenAPI components.

In order to output more graceful OpenAPI schemes, REST framework 3.12 now
defines components in the schema, and then references them inside request
and response objects. This is in contrast with the previous approach, which
fully expanded the request and response bodies for each operation.

The names used for a component default to using the serializer class name, [but
may be overridden if needed](https://www.django-rest-framework.org/api-guide/schemas/#components
)...

```python
class MyOrders(APIView):
    schema = AutoSchema(component_name="OrderDetails")
```

## More Public API

Many methods on the `AutoSchema` class have now been promoted to public API,
allowing you to more fully customize the schema generation. The following methods
are now available for overriding...

* `get_path_parameters`
* `get_pagination_parameters`
* `get_filter_parameters`
* `get_request_body`
* `get_responses`
* `get_serializer`
* `get_paginator`
* `map_serializer`
* `map_field`
* `map_choice_field`
* `map_field_validators`
* `allows_filters`.

See [the schema docs](https://www.django-rest-framework.org/api-guide/schemas/#per-view-customization)
for details on using custom `AutoSchema` subclasses.

## Support for JSONField.

Django 3.1 deprecated the existing `django.contrib.postgres.fields.JSONField`
in favor of a new database-agnositic `JSONField`.

REST framework 3.12 now supports this new model field, and `ModelSerializer`
classes will correctly map the model field.

## SearchFilter improvements

There are a couple of significant improvements to the `SearchFilter` class.

### Nested searches against JSONField and HStoreField

The class now supports nested search within `JSONField` and `HStoreField`, using
the double underscore notation for traversing which element of the field the
search should apply to.

```python
class SitesSearchView(generics.ListAPIView):
    """
    An API view to return a list of archaeological sites, optionally filtered
    by a search against the site name or location. (Location searches are
    matched against the region and country names.)
    """

    queryset = Sites.objects.all()
    serializer_class = SitesSerializer
    filter_backends = [filters.SearchFilter]
    search_fields = ["site_name", "location__region", "location__country"]
```

### Searches against annotate fields

Django allows querysets to create additional virtual fields, using the `.annotate`
method. We now support searching against annotate fields.

```python
class PublisherSearchView(generics.ListAPIView):
    """
    Search for publishers, optionally filtering the search against the average
    rating of all their books.
    """

    queryset = Publisher.objects.annotate(avg_rating=Avg("book__rating"))
    serializer_class = PublisherSerializer
    filter_backends = [filters.SearchFilter]
    search_fields = ["avg_rating"]
```

---

## Deprecations

### `serializers.NullBooleanField`

`serializers.NullBooleanField` is now pending deprecation, and will be removed in 3.14.

Instead use `serializers.BooleanField` field and set `allow_null=True` which does the same thing.

---

## Funding

REST framework is a *collaboratively funded project*. If you use
REST framework commercially we strongly encourage you to invest in its
continued development by **[signing up for a paid plan][funding]**.

*Every single sign-up helps us make REST framework long-term financially sustainable.*

<ul class="premium-promo promo">
    <li><a href="https://getsentry.com/welcome/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/sentry130.png)">Sentry</a></li>
    <li><a href="https://getstream.io/try-the-api/?utm_source=drf&utm_medium=banner&utm_campaign=drf" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/stream-130.png)">Stream</a></li>
    <li><a href="https://software.esg-usa.com" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/esg-new-logo.png)">ESG</a></li>
    <li><a href="https://rollbar.com" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/rollbar2.png)">Rollbar</a></li>
    <li><a href="https://cadre.com" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/cadre.png)">Cadre</a></li>
    <li><a href="https://hubs.ly/H0f30Lf0" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/kloudless-plus-text.png)">Kloudless</a></li>
    <li><a href="https://lightsonsoftware.com" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/lightson-dark.png)">Lights On Software</a></li>
    <li><a href="https://retool.com/?utm_source=djangorest&utm_medium=sponsorship" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/retool-sidebar.png)">Retool</a></li>
</ul>
<div style="clear: both; padding-bottom: 20px;"></div>

*Many thanks to all our [wonderful sponsors][sponsors], and in particular to our premium backers, [Sentry](https://getsentry.com/welcome/), [Stream](https://getstream.io/?utm_source=drf&utm_medium=banner&utm_campaign=drf), [ESG](https://software.esg-usa.com/), [Rollbar](https://rollbar.com/?utm_source=django&utm_medium=sponsorship&utm_campaign=freetrial), [Cadre](https://cadre.com), [Kloudless](https://hubs.ly/H0f30Lf0), [Lights On Software](https://lightsonsoftware.com), and [Retool](https://retool.com/?utm_source=djangorest&utm_medium=sponsorship).*

[sponsors]: https://fund.django-rest-framework.org/topics/funding/#our-sponsors
[funding]: funding.md
